.nr % 1
.OH ''PBS ERS'Interface Library'
.EH 'Interface Library'PBS ERS''
.P1
.so ers_setup.ms
.Rv $Revision: 2.2 $
.nr H1 3
.nr Fi 0 1
.NH 1
.Tc \f3\s+2Interface Library\s-2\fP
.LP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
Part of the 
.B PBS
package is the
.I "Batch Interface Library" ,
or 
.I IFL .
This library provides a means of building new batch clients. 
Any batch service request can be invoked through calls to the
batch interface library.
.LP
Users may have requirements to build jobs which could status itself
or spawn off new jobs.  Or they may wish to customize the job status
display rather than use 
.B qstat .
Administrators may use the interface library to build new control commands.
.NH 2
.Tc "\f3Interface Library Overview\fP"
.LP
The IFL provides a user callable function which corresponds to each
batch client command.
There is (approximately) a one to one correlation between commands and
batch service requests.
Additional routines are provided for network connection management.
The user callable routines are declared in the header file
.Ty PBS_ifl.h .
.LP
Users open a connection with a batch server via a call to pbs_connect().
Multiple connections are supported.  
Before a connection is established, pbs_connect() will fork and exec an
.I "Interface Facility" ,
IFF, as shown in figure \n(H1\-\n+(Fi.
The purpose of the IFF is to provide the user a credential which
validates the user's identity.  This credential is included in each
batch request.
The IFF provided credential prevents a user from spoofing another user's
identity.  See chapter 10, Security, for more detail.
.DS B
.so iff.pic
.sp
\f3\s10Figure \n(H1\-\n(Fi: Interface Between Client, IFF, and Server\f1
.DE
.LP
After all requests have been made to a server, its connection is closed
via a call to pbs_disconnect().
.LP
Users request service of a batch server by calling the appropriate
library routine and passing it the required parameters.  The parameters
correspond to the options and operands on the commands.  It is the
user's responsibility to insure the parameters are in the correct syntax.
.LP
Each function will return zero upon success and a non-zero error
code on failure.  These error codes are available in the header file
.Ty PBS_error.h .
.LP
The library routine will accept the parameters and build the corresponding
batch request.  This request is then passed to the server communication
routine.
.NH 2
.Tc "\f3Interface Library Routines\fP"
.LP
The following "man" pages describe the user callable functions in the IFL.
The functions are found in files src/lib/Libifl/pbsD_*.c.
.bp
.NH 3
.Tc Alter Job
.LP
.so ../man3/pbs_alterjob.3B
.bp
.NH 3
.Tc Connect with Server
.LP
.so ../man3/pbs_connect.3B
.bp
.NH 3
.Tc Delete Job
.LP
.so ../man3/pbs_deljob.3B
.bp
.NH 3
.Tc Disconnect from Server
.LP
.so ../man3/pbs_disconnect.3B
.bp
.NH 3
.Tc Get Error Message Text
.LP
.so ../man3/pbs_geterrmsg.3B
.bp
.NH 3
.Tc Hold Job
.LP
.so ../man3/pbs_holdjob.3B
.bp
.NH 3
.Tc Locate Job
.LP
.so ../man3/pbs_locate.3B
.bp
.NH 3
.Tc Manager Server
.LP
.so ../man3/pbs_manager.3B
.bp
.NH 3
.Tc Move Job
.LP
.so ../man3/pbs_movejob.3B
.bp
.NH 3
.Tc Message Job
.LP
.so ../man3/pbs_msgjob.3B
.bp
.NH 3
.Tc Order Job
.LP
.so ../man3/pbs_orderjob.3B
.bp
.NH 3
.Tc Rerun Job
.LP
.so ../man3/pbs_rerunjob.3B
.bp
.NH 3
.Tc Release Job
.LP
.so ../man3/pbs_rlsjob.3B
.bp
.NH 3
.Tc Run Job
.LP
.so ../man3/pbs_runjob.3B
.bp
.NH 3
.Tc Select Job
.LP
.so ../man3/pbs_selectjob.3B
.bp
.NH 3
.Tc Status of Selected Jobs
.so ../man3/pbs_selstat.3B
.bp
.NH 3
.Tc Signal Job
.LP
.so ../man3/pbs_sigjob.3B
.bp
.NH 3
.Tc Stage In Files
.LP
.so ../man3/pbs_stagein.3B
.bp
.NH 3
.Tc Status Job
.LP
.so ../man3/pbs_statjob.3B
.bp
.NH 3
.Tc Status Queue
.LP
.so ../man3/pbs_statque.3B
.bp
.NH 3
.Tc Status Server
.LP
.so ../man3/pbs_statserver.3B
.bp
.NH 3
.Tc Submit Job
.LP
.so ../man3/pbs_submit.3B
.bp
.NH 3
.Tc Terminate Server
.LP
.so ../man3/pbs_terminate.3B
.bp
.NH 3
.Tc "Query Resource Availability"
.LP
While the following functions may be used by any user, they are intended for
use in a batch scheduler.  They replace avail, totpool, and usepool calls
made to pbs_mom in early versions of PBS.
.LP
.so ../man3/pbs_rescquery.3B
.bp
.NH 3
.Tc "Make and Release Resource Reservations
.LP
The following functions require manager or operator privilege.  They are 
intended for use in a batch scheduler.
.LP
.so ../man3/pbs_rescreserve.3B
\" force next chapter to odd page
.NH 3
.Tc "Node Status"
.LP
The following function provides a means to query the status of PBS nodes.
A node has a name and two attributes.   
.At ATTR_NODE_state
(state) may take the values of 
.Ty free
or one or more of the following "or-ed" together:
.RS
.IP \f5free\fP
The node is not being used by PBS and isfree to be allocated to a job.
.IP \f5down\fP
The node is not responding to queries by the PBS job server.
.IP \f5offline\fP
The node has been marked off-line by the administrator
.IP \f5reserve\fP
The node has been reserved by the PBS job scheduler.
.IP \f5job-exclusive\fP
The node has been assigned exclusively to a job, no other jobs can run
on that node.
.IP \f5job-sharing\fP
The node has been assigned to one or more jobs. Other jobs willing to share
nodes may be allocated to it.
.RE
.LP
The attribute
.At ATTR_NODE_properties
(properties) is a list of alternative names which may be used to identify
sets or groups of nodes by some arbitrary criteria.
.LP
.so ../man3/pbs_statnode.3B
.bp
.if e \{
\&
.sp 10
.DS C
[Page intentionally left bank.]
.DE
.bp
\}
