#!/bin/csh
set NPARTS = 12
set PSFILES = ( \
	ers_ch0.ps \
	ers_ch1.ps \
	ers_ch2.ps \
	ers_ch3.ps \
	ers_ch4.ps \
	ers_ch5.ps \
	ers_ch6_7.ps \
	ers_ch8.ps \
	ers_ch9.ps \
	ers_ch10_11.ps \
	ers_ch12.ps \
	ers_chA.ps \
)

rm -f ers_mailing.*
./make 
set N = 1
foreach f ( $PSFILES )
	echo making mailing part $N from $f
	compress -c $f > $f.Z
	uuencode $f.Z $f.Z > xers.$N
	echo "Attached is a part $N of the Portable Batch System External Reference spec." > ers_mailing.$N
	echo "The total spec is contained in $NPARTS mail messages." >> ers_mailing.$N
	cat prolog_mailing xers.$N >> ers_mailing.$N
	rm $f.Z xers.$N
	@ N++
end
@ N--
if ( $NPARTS != $N) then
	echo incorrect number of parts, check script and prolog
	exit 1
endif
ls -l ers_mailing.*
exit 0
