.nr % 1
.OH ''PBS ERS'Security'
.EH 'Security'PBS ERS''
.P1
.so ers_setup.ms
.Rv $Revision: 2.2 $
.nr H1 9
.nr Fi 0 1
.NH 1
.Tc \f3\s+2Security\s-2\fP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.LP
Security in 
.B PBS
is composed of two facets, authorization and authentication.
Any user making a request of a batch server must be authorized to
request that service.
To provide the basis for authorization, each
request contains the identity of the user making the request.
To insure the user identity is correct, the identity must be
authenticated in some manner.
.NH 2
.Tc \f3Authorization\fP
.LP
There is an authorization method, usually an 
.I "access control list" ,
or ACL,
to control access to each object managed by a batch server, jobs, queues,
and the server itself.
.LP
While the exact format of the entries in access control lists varies depending
upon the list, they have several properties in common.
Each list is maintained by the server as an editable text file.
Each list entry consists of a single text line.
Entries in the list may be prefixed with a single \*Q+\*U or \*Q-\*U character
to indicate allowing or denying access.  If neither character is present,
allowing access is assumed.
For example, a list containing:
.Cs
        -Kenneth
        +Lora
        -Julie
        -Bob
.Ce
Would explicitly grant access to Lora and explicitly deny access to Kenneth,
Julie, and Bob.
.LP
Note that while each entry in the list is maintained in the file as a separate
line,  when entering the entries through 
.B qmgr ,
the entries are comma separated on a single line.  For example:
.Cs
        set server some_list="-Kenneth,Lora,-Julie,-Bob"
.Ce
The quote marks are required to correctly parse the string as a single value
for the keyword \*Qsome_list\*U as the string contains commas.
Also be aware that when entered via qmgr, entries for ACLs which contain a
host\-domain part are sorted such that the more restrictive (fully specified,
least wild carded) entries occur first.  This is important to the comparison
algorithm used when checking privilege.  If the file is edited by hand, the
order should be maintained.
.NH 3
.Tc Server Access
.LP
Server access is controlled by a host access control list, and by two
lists which grant special privilege to certain users.
.NH 4
Server Host ACL
.LP
Each server has an access control list that specifies which hosts are allowed,
or not allowed, to send requests to the server.
The server depends on the network to identify the host which originated the
connection (request).
The entries in this list are fully specified host-domain names:
.Cs
        +host_one.domain.name.one
        -host_two.domain.name.one
        host_three.another.domain
        *.my.domain
        *.edu
        -*
.Ce
As shown in the last three entries, fields on the left, host, sub-domain, or
domain names, may be \*Qwild carded\*U by the use of a single asterisk.
Thus any host in the domain 
.Ty my.domain
or any host in any subdomain under the top level 
.Ty edu
domain is granted access, while the last line denies access to any other host.
.NH 4
Managers and Operators
.LP
Each server has a list of \*Qusers at hosts\*U who have the privilege to
request services restricted to operators and managers (administrators).  
Requests for those services from other users will be rejected.
Requests from the named users on hosts other than the named host will also
be rejected.
The format of these lists is:
.Cs
        user_name@host.domain.name
.Ce
As above, the host, sub-domain, or domain name may be wild carded.
.NH 3
.Tc Queue Access
.LP
Queue access is controlled by three levels: host, group, and user.
Unlike other ACLs, the user and group list may have an extra first entry
which determines the default for unnamed members.
This entry in the list consists solely of a single \*Q+\*U or \*Q-\*U
character with no additional characters.  Any name, user or group, not specified
will implicitly be granted or denied access based on this line.
If multiple default lines, single + or -, appear in a list, it is undefined
as to which takes precedence.
.NH 4
Queue Host Access
.LP
As with the server, queue access can also be controlled by originating host.
Each queue has an Host ACL identifying hosts from which 
jobs may or may not be entered into the particular queue.
The format of the list entries is the same as the server's host list.
.NH 4
Queue Group Access
.LP
An access control list can be established which limits access to jobs run
under certain group names.  This is the group name under which the job would
be executed.  It may be different than the group name under which the user 
submitted the job, see the job attribute
.At group_list .
The format of this list is
.Cs
        [+|-]
        [+|-]group_name
.Ce
The optional first line of a single '+' or '-' establishes the default privilege
for unlisted groups.  If the first line is '-', any unlisted group is denied
access.  If the first line is '+' or contains additional characters, any
unlisted group is allowed access.
.NH 4
Queue User Access
.LP
The user identification in each request may also control queue access.
Each queue has an access control list identifying the users who are
permitted or denied the ability to enter jobs into the queue.
The format of this list is:
.Cs
        [+|-]
        [+|-]user[@host.domain]
.Ce
The optional first line is identical to the group ACL.
The \*Qhost.domain\*U may be wild carded as described under the Server Host ACL.
If a user name is given without a \*Q@host.domain\*U, then it is equivalent to
that user name at any host, \*Quser@*\*U.
.LP
.NH 3
.Tc Job Access
.LP
The owner of a job is allowed full access to his or her own
job.  Operators and administrators also have access to all jobs.
.LP
Users without special privilege, manager or operator, are not allowed to
modify or delete a job that they do not own.
The ability to query the status
of a job of another user is determined by the server attribute 
.At query_other_jobs .
If true, users may query the status of any user's jobs.
.NH 3
.Tc Root Jobs
.LP
Generally, the super user, root, is not allowed to submit batch jobs.  
This prevents someone who has cracked the system from doing additional
damage.  However, there is a build time option to allow root on the
server's local system to submit jobs.  This option is controlled by the
symbol PBS_ROOT_JOBS.  Please see the server_limits.h section of the
PBS Administrator Guide for more information.
.NH 2
.Tc \f3Authentication\fP
.LP
There must be a guarantee that the identity of the user making a batch
request is correct.
A basic method described below is provided with 
.B PBS .
It is called the PBS Interface Facility, or
.B pbs_iff
(also known as Identify, Friend or Foe).
The method of authenticating the user is somewhat modular.
It can be removed and replaced by other authentication methods
such as Kerberos with a bit of work in the server.
.LP
In the basic method provided with 
.B PBS ,
an Authentication Batch Request is sent to the server from a privileged port.
This request contains the user's true identity, the name of the host on
which the client is running, and the port name to which the client is bound and
will be communicating with the server.  This information is obtained by the
.I pbs_iff
program.  This program is a \*Qsetuid root\*U program allowing it to access
privileged ports (those requiring root privilege) and thus giving some amount
of credence to its claims.
.LP
The PBS user application programmable interface (API) library,
.B libpbs.a ,
is the client side of the credential process.  Whenever a user requests
an open connection with a batch server through the API,  the 
.B pbs_connect (3B)
routine will open a connection to the PBS server on a non-privileged port.
It will then
.I fork ()
and
.I exec ()
.B pbs_iff 
passing it the server's name and the port to which pbs_connect() is bound.
The authentication type is returned by 
.B pbs_iff
to the pbs_connect routine over a pipe.
.LP
When the server receives the authentication request, it associates the user
and host name with the network connection established by the client and 
identified by in the request.
If the request is accepted by the server, the connection is considered
authenticated for the remainder of its life.
.if o \{
\&
.bp
\}

.OH ''PBS ERS'Network Protocol'
.EH 'Network Protocol'PBS ERS''
.pn 1
.bp
.NH 1
.Tc \f3\s+2Network Protocol\s-2\fP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.LP
The batch system fits into a client - server model, with a batch
client making a request of a batch server and the server replying.
This client - server communication necessitates an interprocess
communication method and a data exchange (data encoding) format.
Since the client and server may reside on different systems, the
interprocess communication must be supportable over a network.
.LP
As new batch processing features will become part of the base,
and as vendors will extend the product, the data exchange
format must be extensible.
.LP
As the batch system will run on many systems within a complex,
the data exchange format must provide for interoperability among systems with:
.DS I
Different architectures, including word size and byte order.
Non uniform extensions to the batch systems.
.DE
.LP
While the basic PBS system fits nicely into the client - server model,
it also has aspects of a transaction system.  When jobs are being moved
between servers, it is critical that the jobs are not lost or replicated.
Updates to a batch job must be applied once and only once.  Thus the 
operation must be atomic.
.LP
Most of the client to server requests consist of a single message.  Treating
these requests as an atomic operation is simple.  One request,
"Queue Job", is more complex and involves several messages, or subrequests,
between the client and the server.  Any of these subrequests might be rejected
by the server.  It is important that either side of the connection be able
to abort the request (transaction) without losing or replicating the job.
The network connection also might be lost during the request.  Recovery from
a partially transmitted request sequence is critical.
The sequence of recovery from lost connections is discussed in the Queue Job
Request description.
.LP
The batch system data exchange protocol
must be built on top of a reliable stream connection protocol.
PBS uses
.B TCP/IP
and the 
.I socket
interface to the network.
Either the Simple Network Interface, SNI, or the Detailed
Network Interface, DNI, as specified by POSIX.12, Protocol Independent
Interfaces, could be used as a replacement.
.LP
PBS originally used the ISO standard ASN.1 data encoding between all pieces
of PBS execept for the Scheduler to Resource Monitor communication.
A public domain package, ISODE, provided for quick implementation and it was
believed that ASN.1 would be required by POSIX when the batch protocol was
standardized.  
In release 1.1.9, the user and administrative command utilities still used
the ASN.1 encoding and the Job Server, pbs_server, still accepted ASN.1
encoded requests from clients (user commands or other servers), but ASN.1
has being phased out in favor of the 
.I "Data Is Strings" ,
or DIS, encoding and is no longer used or supported.
.LP
.NH 2
.Tc "\f3General DIS Data Encoding\fP"
.LP
The purpose of the \*QData is Strings\*U encoding is to provide a simple, fast,
small, machine independent form for encoding data to a character string and
back again.  Because data can be decoded directly into the final internal
data structures, the number of data copy operations are reduced.  Human 
readability was a secondary goal and considered only when it would not cost.
.LP
Data are represented as people thing of them, but preceded with a count of
the length of each data item.  For small positive integers, it is impossible
to tell from the encoded data whether they came from signed or unsigned 
chars, shorts, ints, or longs.  Similarly, for small negative numbers numbers,
the only thing that can be determined from the encoded data is that the source
datum was not unsigned.   It is impossible to tell the word size of the 
encoding machine, or whether it uses 2's complement, one's complement or sign
\- magnitude representation, or even if it uses binary arithmetic.
.LP
All of the basic C data types are handled.  Signed and unsigned chars, shorts,
ints, longs produce integers.  NULL terminated and counted strings produce
counted strings (with the terminating NULL removed).  Floats, doubles, and
long doubles produce real numbers.
.LP
Complex data must be built up from the basic types.   Note that there is no
type tagging, so the type and sequence of data to be decoded must be known
in advance.
.LP
The crux of the the encoding is the integer.  It's BNF is:
.nf
	integer =: <count><sign><decimal string> | <count><integer>
	count   =: <decimal string>
	sign    =: '+' | '-'
	decimal string =: <digit> | <digit><decimal string>
	digit   =: '0' | '1' | '2' | '3' |'4' | '5' | '6' | '7' | '8' | '9'
.fi
Single digit numbers do not require a count, just a sign followed by the
one digit.  Otherwise, the left most count is one digit long.
Each count gives the number of digits in the decimal string to its right.
The last decimal string is the actual integer value.
The following table shows some examples of values and their encoding.
.DS
.TS
box tab(/) ;
l l .
Value/Encoded String
=
1/+1
2/+2
-3/-3
12/2+12
-13/2-13
1234567890/210+1234567890
.TE
.DE
The last value may take some explaining, the first digit, '2', is the first
count and there for the length of the following integer.  That integer, '10'
is the second count.  Since it is followed by a sign, its value follows and
is therefore '10' digits in length.
.LP
Counted character strings (or simply strings) are defined as:
.nf
	counted string =: <integer><characters>
	characters     =: <character> | <character><characters>
.fi
The number of characters in the \*Qcharacters\*U value is given by
\*Qinteger\*U.  Some examples:
.DS
.TS
box tab(/) ;
l l .
Value/Encoded String
=
"abc"/+3abc
"This is a long string."/2+22This is a long string.
.TE
.DE
.LP
Real numbers are defined as:
.nf
	real number =: <integer><integer>
.fi
The first integer is a real number is the coefficient, with no leading or
trailing zeros and with the decimal point to its right.  The second integer
of a real number is the exponent to the base 10.
.LP
PBS provides a collection of the functions to perform the
encoding/decoding of the basic data types.  The collection is in the source
tree under lib/Libdis.  The objects are placed into the API library, libpbs.a,
for ease of linking.  This library may be used outside
of PBS if desired.   The routines are described (briefly) in the PBS Internal
Design Specification.  
.LP
Layered on top of the above routines, PBS makes use of a set of batch request
and reply routines which use the DIS routines to encode/decode the data 
specific to the request or reply.   This routines are called by the public
PBS API routines defined in chapter 4 of this document.
.NH 2
.Tc "\f3DIS Encoded Batch Requests\fP"
.LP
The following describes the format of the PBS batch requests and replies using
the DIS encoding.  These requests are the basis of all communication between
the client commands (qalter, qsub, ...) and the server, between two servers,
and between the server and MOM.  The Job Scheduler uses a different message
format when talking with the Resource Manager side of MOM.
.NH 3
Batch Requests
.LP
Each request is encoded as a 
.I "Message Header" ,
a
.I "Message Body" ,
and an
.I "Message Extension" .
The format of the Message Header and the Message Extension is the same for
all batch requests.  The Message Body varies for each request.
.NH 4
Message Header
.LP
.ft 5
.nf
unsigned integer:	Batch Protocol Type Identifier     (=2)
unsigned integer:	Batch Protocol Version Identifier  (=1)
unsigned integer:	Batch Request Identifier
string:            	User Name
.fi
.ft 1
.NH 4
Message Body
.LP
.nf
.ft 1
.UL "Copy Files Request"
.sp
.ft 5
string:        		Job Id
string:        		Job Owner (may be null string)
string:	     		Execution User Name
string:	     		Execution Group Name (may be null string)
unsigned integer:	direction
unsigned integer:	number of file pairs that follow
array of file pairs:
	unsigned integer:	file type flag
	string:            	local (to mom) path name
	string:            	remote path name
.sp
.ft 1
.UL "Job Credential Request"
.sp
.ft 5
unsigned integer:	credential type
string:        		opque data
.ft 1
.sp
.UL "Job Files Move Request"
.sp
.ft 5
unsigned integer:	file block number
unsigned integer:	file type (stdout, stderr, checkpoint, ...)
unsigned integer:	amount of data in this block
string:          	Job Id
string:          	file data block
.ft 1
.sp
.UL "Job Obituary (Notice) Request"
.sp
.ft 5
string:           	Job Id
unsigned integer:	exit status
array of Attributes
.ft 1
.sp
.UL "Manager Request"
.sp
.fi
This request is used for a number of operations including Alter Job, Delete
Job, Hold Job, and Release Job, as well as  the request associated with
the qmgr command.
.sp
.nf
.ft 5
unsigned integer:	command (create, delete, set, unset, increment, decr)
unsigned integer:	object type
string:           	object name
array of Attributes
unsigned integer:	object type
string:           	object name
array of Attributes
.ft 1
.sp
.UL "Message Job Request"
.sp
.ft 5
string:             	Job Id
unsigned integer:	which file (stderr, stdout, default)
string:           	message text
.ft 1
.sp
.UL "Move Job Request"
.sp
.ft 5
string:             	Job Id
string:            	Destination
.ft 1
.sp
.UL "Queue Job Request"
.ft 5
.sp
string:            	Job Id
string:               	Destination (queue name, null string implies default)
array of Attributes
.sp
.ft 1
.UL "Register Dependency Request"
.sp
.ft 5
string:              	Job Owner
string:               	Parent Job Id
string:   	   	Child Job Id
unsigned integer:	dependency type
unsigned integer:	operation
signed long:      	dependency cost
.sp
.ft 1
.UL "Run Job Request"
.sp
.ft 5
string:            	Job Id
string:             	Destination (where to run it)
.sp
.ft 1
.UL "Shut Down Server Request"
.sp
.ft 5
unsigned integer:	manner of shutdown
.sp
.ft 1
.UL "Signal Job Request"
.sp
.ft 5
string:             	Job Id
string:            	Signal name
.sp
.ft 
.UL "Status Job, Queue, or Server Request"
.sp
.ft 5
string:             	Object Id (or null string)
array of Attributes
.sp
.ft 1
.UL "Track Job (Notice) Request"
.sp
.ft 5
string:             	Job Id
unsigned integer:	hop count
string:           	location
unsigned character:	current job state
.ft 1
.fi
.NH 4
Complex Data Encoding
.LP
Certain data items are complex, such as the array of attributes, and
require special encoding as a set.
.LP
.ft 1
.UL "Array of Attributes"
\- An array or list of attributes, regardless for job, queues, or a server,
is encoded as follows:
.nf
.sp
.ft 5
unsigned integer:	number of attributes in array (list)
.sp
.ft 1
followed by the attributes (if the above integer is non-zero):
.sp
.ft 5
unsigned integer:	sum of length of the name, resource, and value strings,
     	     	   	including the terminating null characters
string:           	attribute name
unsigned integer:	flag if resource name is present (1=yes,  0=no)
optional string:  	resource name (if above flag is 1)
string:          	value
unsigned integer:	operation
.ft 1
.fi
.sp
.UL "Status Object"
(see Batch Reply)
.sp
Each status object in an array there of is encoded as:
.sp
.nf
.ft 5
unsigned integer:	object type (server, queue, job)
string:           	object name
array of Attributes
.fi
.ft 1
.NH 4
Message Extension
.LP
.ft 5
.nf
unsigned integer:  	flag indicates presence of extension string \
(1=yes, 0=no)
optional string:    	extension string (present only if above flag is 1)
.fi
.ft 1
.NH 3
.Tc "Batch Reply Format"
.LP
The PBS batch reply is in two parts, a fixed header and a body which depends
on the type of reply indicated in the header.
.NH 4
Reply Header
.LP
The reply header is encoded as:
.sp
.nf
.ft 5
unsigned integer:	Batch Protocol type (2)
unsigned integer:	Batch Protocol version (1)
unsigned integer:	return code
unsigned integer:	auxiliary code
unsigned integer:	body type indicator
.sp
.fi
.ft 1
.NH 4
Reply Body
.LP
The reply bodies are encoded depending on type as:
.sp
.ft 1
.UL "Null body"
\- no additional data
.sp
.UL "Job Id Reply"
\- (used for Queue, Ready to Commit, and Commit requests
.nf
.sp
.ft 5
string:            	Job Id
.sp
.ft 1
.UL "Select Reply"
.sp
.ft 5
unsigned integer:	count of job id strings to follow
string:            	job id, repeated as required
.ft 1
.sp 
.UL "Status Reply"
.sp
.ft 5
unsigned integer:	count of status objects:
array of status objects
.sp
.ft 1
.UL "Text Reply"
.sp
.ft 5
string:            	text 
.sp
.ft 1
.UL "Locate reply"
.sp
.ft 5
string:            	location of job
.fi
.ft 1

.NH 2
.Tc "\f3Description of Data Exchange Format\fP"
.LP
A batch client makes a
.I "service request"
of a batch server.  The request consists of one or more
.I subrequests
from the client to the server.  For each subrequest, the server returns a 
.I reply
to the client.  As a minimum, the reply indicates success or failure
of the subrequest.  For some subrequests, such as a status request,
additional information is included in the reply.
.NH 2
.Tc "\f3Request Format\fP"
.LP
A general request consists of two required parts, a
.I "fixed header"
and a
.I "variable body" ,
and an optional third part, a
.I "request extension"
byte string.
The header contains three (3) fields:
.IP "\f3request code\f1" 25
which is a number identifying the type of request.
.IP "\f3request user\f1" 25
a string which is the effective user name of the user making the request,
.IP "\f3request credential\f1" 25
an "any" structure which contains client authentication credentials.
.LP
The format and content of the request body depends on the type
of request.  The body is decoded separately from the header and after
the header identifies the type of body.
.LP
The request extension byte string is intended to allow portable extensions
to the batch command parameters.
PBS makes use of this capability for the
.B qhold
and 
.B qdel
commands.
When a server receives a request extension that it does not recognize,
it is free to abort the request.
.NH 2
.Tc "\f3Reply Format\fP"
.LP
The reply returned by a server to a client consists of a 
.I "fixed header"
and an optional 
.I "variable body" .
The body is only required in replies to certain types of requests.
.LP
The header contains the following integer numbers:
.IP "\f3reply code\f1" 25
which contains the primary success or failure code.
.IP "\f3auxiliary code\f1" 25
which contains extended status or failure information.
.LP
The optional body format depends on the type of request to which the reply
is being returned.  The format of the reply will be discussed under those
requests which require the additional information contained in a body.
.NH 2
.Tc "\f3Sequence of Subrequests\fP"
.LP
The following sequence of requests is followed in the client - server
communication.
.NH 3
.Tc Open Connection
.LP
The client opens a reliable stream connection with the server.  The
PBS mechanism for opening the connection is the
.B connect (2)
call to connect to an address associated with the requested server.
.\" .NH 3
.\" .Tc Protocol Negotiation
.\" .LP
.\" This optional request is used to negotiate extensions to the protocol
.\" and supported features.  Use of the negotiation field of the subrequest is
.\" detailed in the description of the request.
.NH 3
.Tc Service Requests
.LP
The client sends one or more service requests to the server.
.LP
The server returns a reply following processing of each request.
The client does not send an additional request
until it has received a reply to the prior request.
.NH 3
.Tc Connection Closure
.LP
The client closes the connection to the server to indicate that there
are no more requests.  The server may close the connection.  If this occurs
before the reply is sent, the client treats this as error condition.
.NH 2
.Tc "\f3Description of Service Request\fP"
.LP
The following sections describe the data items in each request.
.\" .NH 3
.\" .Tc Protocol Negotiation Request
.\" .LP
.\" The negotiation request consists of a bit string with each bit
.\" in the string assigned to an optional feature or an extension to the
.\" base set of features.
.\" A bit being set to a "1" indicates support by the client
.\" of the extension.  A bit set to "0" (zero) indicates the client does not
.\" support or desire the optional or extended feature.
.\" .LP
.\" Absence of the negotiation request field in the request indicates that
.\" the client does not wish to perform advance negotiation of the protocol.
.\" A server may reject any request from a client if the request
.\" makes use of extensions not supported by the server.  The server does not
.\" assume the client supports any extended feature.
.\" .LP
.\" A server replies to a negotiation request with a
.\" .I negotiate-reply .
.\" The bits in the reply's bit string set to 1 (one) correspond to the features
.\" requested by the client which are supported by the server.  During the
.\" reminder of the connection, neither the client nor the server attempts
.\" to make use of extended features not indicated in the server's reply.
.NH 3
.Tc Queue Job Request
.LP
.B "Queue Job"
is a complex request, made up of four or more sub-requests:
.IP \-
Queue Job (subrequest)
.IP \-
Job Credentials
.IP \-
Job Script, zero or more sub-requests.
.IP \-
Ready to Commit.
.IP \-
Commit ownership.
.LP
The server must respond to each of the subrequests with a reply.
The request may be aborted without the job being queued by the server
at any point prior to receiving the Commit request.
.NH 4
Queue Job 
.LP
The
.B "Queue Job"
subrequest informs the server that the client wishes the server to 
accept and enqueue a batch job.
.LP
The 
.I DestinationID
field identifies the destination of the job.
It is a string in the form:
.Ty [queue][@server]
If queue is not specified, the default queue is assumed.
If @server is specified, it is ignored.
.LP
If the optional field
.I JobIdentifier
is present, the job is an existing job being moved from one server
to another.  The
.I JobIdentifier
field contains the job identifier assigned to the job by the creating server.
If
.I JobIdentifier
is not present, the job is being newly submitted by a client qsub.
The receiving server will assign a job identifier to the job.
The server, in either case, replies with the job identifier.
.LP
Also specified in the Queue Job subrequest are the batch job's private and
public attributes, including required resources and the inherited environment
variables, the
.I Variable_List .
.NH 4
Job Credential
.LP
The Job Credential is an optional subrequest.  The request is provided as
a means of passing service credentials or tickets for use by the batch job.
These services are system or network services unrelated to the batch system.
An example is a ticket authenticating the batch job to AFS (Andrew File
System).
.LP
If present, the server will just decode the data from the network
presentation.  Sites or vendors must add the additional functions to the
server to present the credentials to the system when the job is placed into
execution.
.NH 4
Job Script
.LP
The body of the 
.B "Job Script"
request consists of sections of the job script file supplied to the qsub
command.  Each section contains up to 8192 bytes of the file.  The last
section may be shorter than 8192 bytes.  The sections are send in order
and each must be acknowledged before the next is sent.
.LP
Each Job Script sub-request also contains a sequence number.  This integer
starts with one (1) and is incremented by one for each additional Job
Script sub-request.
.LP
.NH 4
Ready to Commit
.LP
Upon receipt of the Ready to Commit, the receiving server 
.B must
record the job to permanent storage 
.B before
acknowledging.
.LP
The reply to the Ready to Commit, contains the job identifier.
This is provided to assist in the recovery of a server or network failure.
.LP
If the client is another batch server which had the batch job queued, upon
receipt of a acknowledgment to the Ready to Commit, the client
removes the job from its queue and permanent storage, deleting the job.
.NH 4
Commit
.LP
When the sending client has received a positive reply to the Ready to Commit
request and had deleted the job locally, then and only then should the client
send a
.I Commit
sub-request to the server.  This ensures the job cannot be duplicated.
.LP
When the server receives the commit sub-request, the server assumes
ownership of the job and perform the steps required to place the job into a
queue.  The server 
.B "does not reply"
to the client following the commit sub-request.
.NH 4
Error Recovery
.LP
The following procedures are used to ensure the job is not lost or duplicated
if the event of a communication failure between the sending client and the
receiving server:
.IP "Client Side Recovery - Failure of Server"
The follow procedures should be followed by the client attempting to send
a job to a server when communications are lost with the server.
.RS
.IP 1. 4
If the communication link is lost before the client sends the 
.I "Ready to Commit" ,
it is to assume the job is lost and restart from the beginning.  The server
will replace the job with the new copy when the client re-established the
connection.
.IP 2. 4
If the communication link is lost after the client sends the 
.I "Ready to Commit"
but before sending the
.I Commit ,
the client can assume that prior job information is at the server.
Upon re-establishment of a connection with the server, the client re-sends the
.I "Ready to Commit"
followed by the
.I Commit .
.IP 3. 
If the communication is lost after sending the 
.I "Ready to Commit"
and at a later time the client receives a positive acknowledgement to the
.I "Ready to Commit" ,
even if one has already been received, the client sends or resends the
.I Commit .
Note, the job identifier is required in the acknowledgement for this purpose.
Also note that at this point the client should not have and does not need
a copy of the job.
.IP 4. 4
If the client is a temporary process, for example qsub, rather than restarting
the Queue Job request, it may abort and issue an error message to the user.
If the problem occurs after the 
.I "Ready to Commit" 
is sent but before an acknowledgement is received, it is unclear if the
server has the complete job.  The user should be warned to check for the
job before attempting to resubmit it.
Once the acknowledgement for the
.I "Ready to Commit" 
has been received by the temporary client, the client may safely assume the
job has been queued by the server.
.RE
.IP "Client Side Recovery - Failure of Client
Should the client side crash, upon recovery a permanent process (a sending
server) performs the actions described in 1 through 3 above.
.IP "Server Side Recovery - Failure of Client"
The following recovery procedures should be followed by a server receiving
a job upon loss of communications with the client.
.RS
.IP 1. 4
If the failure occurs before the 
.I "Ready to Commit"
is received, the server discards the job.  The client must restart
from the beginning.
.IP 2. 4
If the failure occurs after the
.I "Ready to Commit"
is received, the server should have recorded the job in permanent storage.
The server keeps the job until (a) a request is received to delete it, or
(b) the client resends the Read to Commit, Commit sequence.
If after a \*Qsite defined\*U period of time, the server has not received
any directions, it may notify the batch administrator and request instruction. 
.RE
.IP "Server Side Recovery - Failure of Server"
Should the receiving server crash, it should perform the following actions
upon being restarted.
.RS
.IP 1. 4
If the server detects a job for which a 
.I "Ready to Commit" 
had not been received, the server purges the job.
.IP 2. 4
If the server detects a job for which the
.I "Ready to Commit" 
has been received,  and the sending client was a permanent process (another
server), the server sends an acknowledgement of the Ready to Commit to
the client.  The acknowledge will include the job identifier.  This will
trigger the client to resend the the commit sequence.  In transaction 
terminology, this is called a
.I restart
message.
.RE
.LP
The send \(em receive \(em recovery steps are show in figure \n(H1\-\n+(Fi.
.DS B
.so twophase.pic
.DS
\f3Recovery Proceedures\fP
.br
A. If sender is a server, restart from top, else abort.
.br
B. Discard job.
.br
C. Resend \*QReady to Commit\*U.
.br
D. Commit (enqueue) job.
.DE
.sp
.ce
\f3Figure \n(H1\-\n+(Fi: Two Phase Commit and Error Recovery\f1
.DE
.NH 3
.Tc Delete Job Request
.LP
The
.B "Delete Job"
request is used by a client, such as the
.B qdel
command, to request that a job be deleted.
The request is a
.I manage
request with the object type set to \*Qjob\*U, the name set to the job id, and
the operation is \*Qdelete\*U.
.NH 3
.Tc Hold Job Request
.LP
The
.B "Hold Job"
request is used by a client, such as the 
.B qhold
command, to request that a hold be placed on a job.
.LP
The request is a 
.I manage
form with the object type set to \*Qjob\*U, the name set to the job identifier,
the operation set to \*Qset\*U, and the attribute list contains the
.At Hold_Types
attribute with the value being the holds to apply to the job.
.LP
PBS will use the request extension to pass the re-execution preference
information, see pbs_holdjob(3B).
.NH 3
.Tc Modify Job Request
.LP
A 
.B "Modify Job"
request is sent by a client such as the
.B qalter
command to a server to request that certain attributes of the job be
altered or modified.
.LP
The request is a 
.I manage
form with the object type set to \*Qjob\*U, the name set to the job identifier,
the operation set to \*Qset\*U, and the attribute list contains each of the
attributes to be modified.
.NH 3
.Tc Move Job Request
.LP
The
.B "Move Job"
request is used by a client, such as the 
.B qmove
command, to request that a server route the specified job to another
destination.
.LP
The
.I jobid
field specifies the job to be routed.  The 
.I destin
field specifies the destination to which the job is to be routed.
.NH 3
.Tc Message Job Request
.LP
The
.B "Message Job"
request is used by a client, such as the 
.B qmsg
command, to
ask a server to write a message into an output file of a running job.
.LP
The
.I jobid
field specifies the id of the running job for which
the message is destined.  The destination file for the message is defined
by the
.I fileopt ;
if either the
.Sc oflg
bit and / or the 
.Sc eflg
bit is
set, the message will be written in the standard output and / or standard
error file of the job.  If neither bit is set, the message will be written
to an file determined by the implementation of the server.
.LP
The message string will be in the
.I message
field.
.NH 3
.Tc Rerun Job Request
.LP
The
.B "Rerun Job"
request is used by a client such as 
.B qrerun ,
to request that a server terminate and re-queue a currently running job.
.LP
The request specifies the job identifier of the running job which is
to be rerun.
.NH 3
.Tc Select Jobs Request
.LP
The
.B "Select Jobs"
request, issued by the command qselect, requests that the
server return job identifiers for all jobs which meet the specified 
criteria.
.LP
The 
.I "attribute list"
specifies the attributes which are to be used in filtering jobs.
Resources, the job state (even though not a true attribute)
and destination may be included in the attribute set.
.LP
The server replies to the client with the special reply
.B select-reply .
The count of jobs selected in response to the request is returned in
.I reply-auxcode .
The list of job identifiers selected is returned in 
.I SelectReply .
.NH 3
.Tc Signal Job Request
.LP
The
.B "Signal Job"
request, used by a client such as 
.B qsig ,
requests that the server send a signal to a running batch job.  The
.I jobid
field indicates which job is to be sent the signal.  The
.I signal
field contains the name or value of the signal to be sent.
.NH 3
.Tc Status Job Request
.LP
A
.B "Status Job"
request directs a server to return status information about
either a job whose job identifier is in
.I id
or the set of jobs in a destination given by
.I id .
.LP
If the server owns the job or destination specified and the client is entitled
to see the status information,
the server replies with a
.B stat
reply.
The stat reply is a list of zero or more 
.B objstat
structures, one per job.  Each objstat structure includes:
.IP -
The type of object, i.e \*Qjob\*U.
.IP -
The job name
.IP -
All public attributes of the job, see next paragraph.
.IP -
Optionally, a general text string for messages, implementation defined.
.LP
If the status request includes a set of specified attributes, only those
attributes are included in the reply.
.NH 3
.Tc Status Queue Request
.LP
A 
.B "Status Queue"
request directs the server to return status information about
the queue identified in the destination specified in the request.
.LP
If a queue with the specified name exists at the server, the server
returns a 
.B stat
reply containing the attribute information about that queue.
.LP
If a queue name is not specified, is null, then the server will return
status about all queues.
.NH 3
.Tc Status Server Request
.LP
A
.B "Status Server"
request directs the server to return status information about itself.
The server responds with a 
.B stat
reply.
.NH 3
.Tc Server Shutdown Request
.LP
The
.B "Server Shutdown"
request directs a batch server to terminate batch service and exit.
The integer value is used to indicate the manner of shutdown:
.Sc immediate
or
.Sc delay .
.NH 3
.Tc Locate Job Request
.LP
The
.B "Locate Job"
request is used by a client to search for the current
location of a job.  The job identifier is specified in the request.
.LP
A server who receives a Locate Job Request for a job which the server
owns or knows the name of the server which owns the job, replies
with a 
.B "locate reply" .
If the server does not know the location, it replies with a failure code.
.LP
The locate reply is a expanded form of reply which contains the
.I locate-reply
field.  This field contains the name of the
batch server currently owning the job.
.NH 3
.Tc Track Job Request
.LP
Job tracking is an optional implementation feature in POSIX 1003.2d.
Its purpose is to provide a method for recording the current location
and status of jobs in a central location to facilitate job status reporting.
.LP
Job tracking is supported by
.B PBS.
When the server accepts a job for queuing, it sends a 
.B "Track Job"
request to the server which originated the job and optionally to one or
more "location servers" as configured by the batch system administrator.  
.LP
When a server receives the Track Job request, that server
records the current location, specified in the
.I location
field, of the job identified in the
.I jobid
field.  The
.I hopcount
is a count of the current number of routes or hops made by the job.
This is used to insure proper sequencing of the information.
.LP
The
.I jobstate
field is provided to allow for an abbreviated status following job completion.
.NH 3
.Tc Run Job
.LP
The
.B "Run Job"
request is used to direct a server to schedule a batch job immediately
for execution regardless of its state, required resources, or the
servers scheduling parameters.
.NH 3
.Tc Manage Request
.LP
The
.B Manage
request is used by the 
.B qmgr
command (and others) to create, delete, or alter managed objects.
.LP
The
.I command
field specifies the operation: create, delete, set, or unset.  The
.I objtype
field identifies the type of object and the
.I objname
field names the specific object.  Attributes and associated values of the
object are listed in the field
.I attrib .
.\" .NH 3
.\" .Tc Pull Job Request
.\" .LP
.\" The
.\" .B "Pull Job"
.\" request is an extension to POSIX 1003.2d.
.\" It is specified for use in implementations which are designed to
.\" provide a central repository of jobs which can then be requested
.\" by execution servers when they need work.
.\" When implemented, the client specifies the job type required and the
.\" resource limits in which the job must execute.  The server examines
.\" jobs in its queues and reply based on the availability of a job which meets
.\" the specification.
.\" .LP
.\" If one or more jobs are available, the server then selects one job and 
.\" initiates a 
.\" .B "Queue Job"
.\" request sequence back to the original client.
.\" .LP
.\" The 
.\" .I destin
.\" field identifies the destination to which a
.\" qualifying job should be routed. 
.\" .LP
.\" The 
.\" .I attrib
.\" field contains
.\" the attribute and resource restrictions to be used in selecting a
.\" qualifying job.
.NH 3
.Tc Register Dependent Job
.LP
This request is used to communicate job dependency requirements between
servers.
.LP
The
.I parentid
field specifies the parent or master job identifier.
The
.I childid 
field specifies the id of the child job the server is registering with
the parent.
.LP
The
.I dependtype
specifies the type of dependency.
.LP
The 
.I op
field is mostly meaningful on synchronization request.  It indicates if the
child job has reserved its resources and is ready to run.
.LP
.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[Page intentionally left bank.]
.DE
.bp
\}
