.nr % 1
.OH ''PBS IDS'Graphical User Interface'
.EH 'Graphical User Interface'PBS IDS''
.P1
.so ids_setup.ms
.Rv $Revision: 2.2 $
.nr H1 11
.NH 1
.Tc "\f3\s+2Graphical User Interface\s-2\fP"
.LP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.NH 2
.Tc \f3GUI Overview\fP
.LP
This section describes the different routines supporting the graphical user
interfaces \f3xpbs\fP and \f3xpbsmon\fP. Most of the routines are written in
Tcl/Tk.
.NH 2
.Tc \f3xpbs Packaging\fP
.LP
The main file called \f3xpbs\fP contains the main() section of the GUI; it
starts up appropriate routines on its event loop to respond to actions like
mouse presses. Related procedures, callback functions are grouped together in a 
file. Files with the ".tk" suffix contain Tk-related procedures while
those with ".tcl" suffix contain non-Tk related routines. Bitmap files used by
the GUI are located in the \f3bitmaps\fP directory.  Codes written in C are in
the \f3Ccode\fP directory. Help files accessed by the GUI are in the \f3help\fP 
directory.
.NH 2
.Fi xpbs
.LP
This file is where the main event loop is located.
.NH 3
.Fn main()
.Cs
main{argc argv}
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
list contain the following arguments:
.RS
 [\-admin]
.RE
.RE
.IP Returns: 4
Zero, if no command line syntax errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
set appropriate Tcl/Tk library directories, program version number, and
program paths.

Get the user's name.

Process command line arguments (if any).
if argument is "-admin" then
  set perm_level to "admin"
else
  set perm_level to "user"
endif

Load xpbs resource values as supplied from the X resources files: global and
user's .xpbsrc file.
Set default values for unset xpbs resources.
Set the colors of various widgets based on xpbs color resources.
Save the initial values of the xpbs resources.

Set the mainWindow path and make it visible.

Set listbox-related parameters.

Set the months values.

Set polling-related parameters such as the data update sequence and the
trackjob update sequence.

Call set_pbs_commands
Call set_pbs_options
Call set_pbs_defaults
Build the main display of xpbs containing the necessary widgets.
Set properties involving the window manager.
Register bindings to the main listboxes.
Get the data for the Hosts, Queues, and Jobs listbox. Place a delay of 500
ms to allow the window display to complete its drawings.
.fi
.RE
.NH 2
.Fi main.tk
.LP
This file contains the routines for creating the main \f3xpbs\fP display.
.NH 3
.Fn build_main_window()
.Cs
build_main_window{}
.Ce
.LP
Control Flow:
.RS
.nf
Create the menubar, hosts, queues, jobs, and statusbar frames.
Make the menubar (fixed located) frame visible.

Fill the menubar with widgets.

Make the hosts, queues, jobs frames visible.
Fill the hosts frame with widgets.
Fill the queues frame with widgets.
Fill the jobs frame with widgets.
Fill the statusbar with widgets.

Create the iconized versions of the hosts, queues, jobs, and info frames.
Fill the iconized frames with widgets.

Make the iconized views visible if appropriate icon* resources are set
in xpbsrc file.
.fi
.RE
.NH 3
.Fn fillIconizedFrame()
.Cs
fillIconizedFrame{text cmd widget_name}
.Ce
.IP Args: 4
.RS
.IP text 15
The leading text label to be written on the icon bar.
.IP cmd 15
The Tcl procedure to call when the maximize button is clicked.
.IP widget_name 15
The widget where the icon frame will be displayed.
.RE
.LP
Control Flow:
.RS
.nf
Create the label for the icon bar.
Create the maximize button for the icon bar.
Make label and button visible.
.fi
.RE
.NH 3
.Fn iconizeHostsView()
.Cs
iconizeHostsView{}
.Ce
.LP
Control Flow:
.RS
.nf
Make Hosts icon bar visible.
Remove from view the Hosts frame.
Set iconview(hosts) to true
.fi 
.RE
.NH 3
.Fn iconizeQueuesView()
.Cs
iconizeQueuesView{}
.Ce
.LP
Control Flow:
.RS
.nf
Make Queues icon bar visible.
Remove from view the Queues frame.
Set iconview(queues) to true
.fi 
.RE
.NH 3
.Fn iconizeJobsView()
.Cs
iconizeJobsView{}
.Ce
.LP
Control Flow:
.RS
.nf
Make Jobs icon bar visible.
Remove from view the Jobs frame.
Set iconview(jobs) to true
.fi 
.RE
.NH 3
.Fn iconizeInfoView()
.Cs
iconizeInfoView{}
.Ce
.LP
Control Flow:
.RS
.nf
Make Info icon bar visible.
Remove from view the Info frame.
Set iconview(info) to true
.fi 
.RE
.NH 3
.Fn maximizeHostsView()
.Cs
maximizeHostsView{}
.Ce
.LP
Control Flow:
.RS
.nf
Make Hosts frame visible.
Remove from view the Hosts icon bar.
Set iconview(hosts) to false.
.fi 
.RE
.NH 3
.Fn maximizeQueuesView()
.Cs
maximizeQueuesView{}
.Ce
.LP
Control Flow:
.RS
.nf
Make Queues frame visible.
Remove from view the Queues icon bar.
Set iconview(queues) to false.
.fi 
.RE
.NH 3
.Fn maximizeJobsView()
.Cs
maximizeJobsView{}
.Ce
.LP
Control Flow:
.RS
.nf
Make Jobs frame visible.
Remove from view the Jobs icon bar.
Set iconview(jobs) to false.
.fi 
.RE
.NH 3
.Fn maximizeInfoView()
.Cs
maximizeInfoView{}
.Ce
.LP
Control Flow:
.RS
.nf
Make Info frame visible.
Remove from view the Info icon bar.
Set iconview(info) to false.
.fi 
.RE
.NH 3
.Fn fillHostsFrame()
.Cs
fillHostsFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Hosts-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the Hosts leading bar.
Create the Hosts body frame.
fill the Hosts leading bar with widgets.
fill the Hosts body frame with widgets.
.fi
.RE
.NH 3
.Fn fillHostsHeaderFrame()
.Cs
fillHostsHeaderFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Hosts leading bar-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the header label.
Create the minimize button.
Make the label and button visible.
.fi
.RE
.NH 3
.Fn fillHostsListFrame()
.Cs
fillHostsListFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Hosts body-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the Hosts listbox.
Create the command buttons, including only those that are consistent
with user's perm_level. 
Make the listbox and the buttons visible.
.fi
.RE
.NH 3
.Fn fillQueuesFrame()
.Cs
fillQueuesFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Queues-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the Queues leading bar.
Create the Queues body frame.
fill the Queues leading bar with widgets.
fill the Queues body frame with widgets.
.fi
.RE
.NH 3
.Fn fillQueuesHeaderFrame()
.Cs
fillQueuesHeaderFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Queues leading bar-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the header label.
Create the minimize button.
Create the "Listed By Hosts(s)" criteria read-only entry widget. 
Make the label and button visible.
.fi
.RE
.NH 3
.Fn fillQueuesListFrame()
.Cs
fillQueuesListFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Queues body-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the Queues listbox.
Create the Queues command buttons, including only those that are
consistent with user's perm_level.
If perm_level is set to "admin", include only buttons
Make the listbox and the buttons visible.
.fi
.RE
.NH 3
.Fn fillJobsFrame()
.Cs
fillJobsFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Jobs-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the Jobs leading bar.
Create the Jobs criteria frame.
Create the Jobs body frame.
fill the Jobs leading bar with widgets.
fill the Jobs criteria frame with widgets.
fill the Jobs body frame with widgets.
.fi
.RE
.NH 3
.Fn fillJobsHeaderFrame()
.Cs
fillJobsHeaderFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Jobs leading bar-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the Jobs header label.
Create the Jobs minimize button.
Create the "Listed By Queue(s)" criteria read-only entry widget. 
Make the label, button, and criteria visible.
.fi
.RE
.NH 3
.Fn fillJobsMiscFrame()
.Cs
fillJobsMiscFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Jobs criteria-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the Jobs select criteria buttons. Configure the buttons with the
appropriate text variables.
Create the "Select Jobs" button and configure its Tcl command.
Create the criteria label.
Make the buttons and label visible.
.fi
.RE
.NH 3
.Fn fillJobsListFrame()
.Cs
fillJobsListFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Jobs body-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the Jobs listbox.
Create the Jobs command buttons, including only those that are consistent
with user's perm_level.
Make the listbox and the buttons visible.
.fi
.RE
.NH 3
.Fn fillStatusbarFrame()
.Cs
fillStatusbarFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Info bar-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the Info leading bar frame.
Create the Info body frame.
Fill the Info leading bar with widgets.
Fill the Info body frame with widgets.
.fi
.RE
.NH 3
.Fn fillStatusbarHeaderFrame()
.Cs
fillStatusbarHeaderFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where Statusbar-related widgets are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the label for the Info leading bar.
Make the label visible.
.fi
.RE
.NH 3
.Fn fillMenubarFrame()
.Cs
fillMenubarFrame{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
The widget frame where menu buttons are to be placed.
.RE
.LP
Control Flow:
.RS
.nf
Create the menu buttons and configure them with appropriate commands.
.fi
.RE
.NH 2
.Fi wmgr.tk
.LP
This file contains window manager-related routines.
.NH 3
.Fn set_wmgr()
.Cs
set_wmgr{toplevel_win}
.Ce
.IP Args: 4
.RS
.IP "toplevel_win" 15
the top level window to decorate.
.RE
.LP
Control Flow:
.RS
.nf
set window minimum size.
set the window title.
set the window icon.
.fi
.RE
.NH 2
.Fi bindings.tk
.LP
This file contains routines for customizing the bindings for some of the
widgets.
.NH 3
.Fn listbox_non_contiguous_selection()
.Cs
listbox_non_contiguous_selection{ W cur_selection new_selection}
.Ce
.IP Args: 4
.RS
.IP W 15
names a listbox widget
.IP cur_selection 15
index to the currently selected/highlighted entry of the listbox.
.IP new_selection 15
index to a newly selected/highlighted entry of the listbox. Can be
"end" to refer to the last item on the listbox.
.RE
.LP
Control Flow:
.RS
.nf
This is a routine that is only invoked in Tk 3.6 which does not support
non-contiguous selection of entries on a listbox.

If no selection is currently selected, then
  simply select the entry at "new_selection".
endif 

let min_cur_selection be the smallest cur_selection index value
let max_cur_selection  be the larget cur_selection index value
if new_selection is > max_cur_selection, then
    position the new entry after the entry at max_cur_selection
    add the new entry to current selection list
elseif new_selection < min_cur_selection, then
    position the new entry before the entry at min_cur_selection
    add the new entry to current selection list
endif  

Adjust the listbox view so that the entry at the smallest selected index 
value is shown at the top of the listbox.
.fi
.RE
.NH 3
.Fn bind_listbox_single_select()
.Cs
 bind_listbox_single_select{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
names a listbox widget to be made into a single selection only listbox
.RE
.LP
Control Flow:
.RS
.nf
Disable bindings for B1-Motion, Shift-1, Shift-B1-Motion, 2, B2-Motion
keys.
.fi
.RE
.NH 3
.Fn bind_listbox_select()
.Cs
 bind_listbox_select{widget_name, boxframe}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
names a listbox widget to be made into a single selection only listbox
.IP boxframe 15
associated box frame.
.RE
.LP
Control Flow:
.RS
.nf
Whatever is selected in the 'widget_name', then a boxSelect is done to
 'boxframe'.
.RE
.NH 3
.Fn bind_text_readonly()
.Cs
 bind_text_readonly{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
names a text widget to be made read-only.
.RE
.LP
Control Flow:
.RS
.nf
disable text widget's bindings for <1>, <Double-1>, <Triple-1>, <B1-Motion>,
<Shift-B1-Motion>, <Return>, <BackSpace>, <Delete>, <Control-h>, <Control-d>,
<Control-v>.
.fi
.RE
.NH 3
.Fn bind_entry_readonly()
.Cs
 bind_entry_readonly{widget_name}
.Ce
.IP Args: 4
.RS
.IP widget_name 15
names an entry widget to be made read-only.
.RE
.LP
Control Flow:
.RS
.nf
disable entry widget's key bindings.
.fi
.RE
.NH 3
.Fn register_dependency()
.Cs
register_dependency{}
.LP
Control Flow:
.RS
.nf
Make the following bindings to the Queues listbox:

  For button presses <1>, <B1-Motion>, <Shift-1>, <Shift-B1-Motion>, <Cntrl-1>,
    Depending on what Queue listbox entries got selected, 
    load the appropriate jobs on the Jobs listbox.

    set the queuesSelected global variable 
    if all Queues listbox entries are selected, then
      Set the queuesSelMode button to "Deselect All" 
    else
      Set the queuesSelMode button to "Select All" 
    endif

  For button press <Double-1>,
    get the details about the selected queue.

Make the following bindings to the Hosts listbox:

  For button presses <1>, <B1-Motion>, <Shift-1>, <Shift-B1-Motion>, <Cntrl-1>,
    Depending on what Hosts listbox entries got selected, 
    load the appropriate queues on the Queues listbox.

    set the hostsSelected global variable
 
    if all Hosts listbox entries are selected, then
      Set the hostsSelMode button to "Deselect All" 
    else
      Set the hostsSelMode button to "Select All" 
    endif

  For button press <Double-1>,
    get the details about the selected host.

Make the following bindings to the Jobs listbox:

  For button presses <1>, <B1-Motion>, <Shift-1>, <Shift-B1-Motion>, <Cntrl-1>,
    set the jobsSelected global variable 
    if all Hosts listbox entries are selected, then
      Set the hostsSelMode button to "Deselect All" 
    else
      Set the hostsSelMode button to "Select All" 
    endif

  For button press <Double-1>,
    get the details about the selected host.
.fi
.RE
.NH 3
.Fn register_trackjob_box()
.Cs
register_trackjob_box{listbox}
.Ce
.IP Args: 4
.RS
.IP listbox 9
names a listbox widget that holds those job ids that have returned output
files.
.RE
.LP
Control Flow:
.RS
.nf
Set up a binding so that single clicking a job id entry will bring
up the output file/error file contents window.
.fi
.RE
.NH 3
.Fn register_default_action()
.Cs
register_default_action{toplevel button}
.Ce
.IP Args: 4
.RS
.IP toplevel 10
names a toplevel to bind the <Return> key to.
.IP button 10
the button on the toplevel window that will be invoked by default.
.RE
.LP
Control Flow:
.RS
.nf
Bind the <Return> key of toplevel so that button will  flash and then
execute its associated Tcl command.
.fi
.RE
.NH 3
.Fn bind_entry_tab()
.Cs
bind_entry_tab{entry_name next_entry_name prev_entry_name {env 1}} 
.Ce
.IP Args: 4
.RS
.IP entry_name 22
names an entry widget to be bound to <Tab>, <Cntrl-f>, <Cntrl-b> keys.
.br
.IP next_entry_name 22
the entry widget that will get the focus when <Tab>, or <Cntrl-f> key is
pressed while in entry_name.
.IP prev_entry_name 22
the entry widget that will get the focus when <Cntrl-b> key is pressed while in
entry_name.
.IP env 22
flag that is set when binding an entry related to environment variables.
.RE
.IP Returns: 4
Sets the following global variables:
.br
\ \ \  next<entry_name> - next_entry_name
.br
\ \ \  prev<entry_name> - prev_entry_name
.LP
Control Flow:
.RS
.nf
Bindings for <Tab> and <Cntrl-f>:

  Set the focus to next_entry_name
  Position the cursor to be at the end of the string. 
 
  if env is set, then load the next_entry_frame with the environment variable
         value of the name specified in entry_name.

Bindings for <Cntrl-b>:

  Set the focus to prev_entry_name
  Position the cursor to be at the end of the string. 
.fi
.RE
.NH 3
.Fn bind_entry_overselect()
.Cs
bind_entry_overselect{entry_name}
.Ce
.IP Args: 4
.RS
.IP entry_name 14
names an entry widget to be converted into a user-friendly widget.
.RE
.LP
Control Flow:
.RS
.nf
Specify bindings to allow overwriting of selected/highlighted text when any
key is pressed, allow copying and pasting text via sole use of mouse button,
and allow left and right arrow keys to be used.
.fi
.RE
.NH 3
.Fn bind_text_overselect()
.Cs
bind_text_overselect {entry_name}
.Ce
.IP Args: 4
.RS
.IP entry_name 14
names an entry widget to be converted into a user-friendly widget.
.RE
.LP
Control Flow:
.RS
.nf
Specify bindings to allow overwriting of selected/highlighted text when any
key is pressed, allow copying and pasting text via sole use of mouse button,
and allow left, right, up, or down arrow keys to be used.
.fi
.RE
.NH 3
.Fn register_spinbox_entry()
.Cs
register_spinbox_entry {entry_name}
.Ce
.IP Args: 4
.RS
.IP entry_name 14
names a spinbox entry widget. This widget has an associated global variable
named: vlist.<entry_name> - a list of valid discrete values.
.RE
.LP
Control Flow:
.RS
.nf
Addition to <AnyKeyPress> binding:
  If spinbox_value_list is a range of numbers (min-max), then
    blank out entry if any of the following conditions is met:
     case when range does not contain negative numbers: 
       (1) user entered something that is non-numeric
       (2) user entered something not between min and max
     case when range contains negative numbers:
       (1) if user typed as first character non-numeric or not "-"
       (2) if the rest of characters typed by user is non-numeric
       (3) if entry value does not fall between the min and the max.
  else
    blank out entry if user typed something where the leading characters
    don't match (regular expression) any of the values in spinbox_value_list.  
  endif

Bind <FocusOut> to spinbox entry so as
  to call check validy of spinbox value
.fi
.RE
.NH 3
.Fn register_entry_fixsize()
.Cs
register_entry_fixsize {entry size}
.Ce
.IP Args: 4
.RS
.IP entry 14
names a spinbox entry widget.
.IP size 14
size to constraint the enty widget with.
.RE
.LP
Control Flow:
.RS
.nf
Addition to <AnyKeyPress> binding:
  allow insertion of new chars if it will not exceed entry length of 'size'.
.RE
.NH 2
.Fi pbs.tcl
.LP
This file contains routines that are dependent on PBS commands.
.NH 3
.Fn getdata()
.Cs
getdata{server_names {jobs_info_only 0}}
.Ce
.IP Args: 4
.RS
.IP server_names 18
the list of servers to query for data
.IP jobs_info_only 18
a boolean value that instructs getdata to only obtain Jobs information.
.RE
.LP
Control Flow:
.RS
.nf
  set busy_cursor
  if jobs_info_only; then
    set dataCmd to "PBS_QSTATDUMP_CMD -J <select_options> server_names"
    unset jobinfo array which holds the Jobs listbox entries
  else
    set dataCmd to "run PBS_QSTATDUMP_CMD <select_options> server_names"
    unset hostinfo which holds the Hosts listbox entries
    unset qinfo which holds the Queues listbox entries
    unset jobinfo which holds the Jobs listbox entries
    clear out the entries from the hosts, queues, and jobs listboxes
  endif

  execute dataCmd
  if execution failed ; then
    remove_busy_cursor
    return
  endif

  initialize where - refers to what listbox an output of data should
      go based on its preceding header
  Foreach line_of_output obtained from dataCmd; 
  do
    NOTE: assuming of course that the header precedes all data.
    if line_of_output matches 
        HOSTS_COLUMN_LABEL; then set where to "hosts"
        QUEUES_COLUMN_LABEL; then set where to "queues"
        JOBS_COLUMN_LABEL; then set where to "jobs"
        LINES_TO_IGNORE; then throw away the line_of_output
    else (assuming that we've already obtained our "where" listbox),
       initialize fkey	
       if where listbox is "hosts", set fkey indices to HOSTS_LISTBOX_FKEY    
       if where listbox is "queues", set fkey indices to QUEUES_LISTBOX_FKEY    
       if where listbox is "jobs", set fkey indices to JOBS_LISTBOX_FKEY    

       From the line_of_output, build the list of fkey (foreign key)
       values, separated by @, by getting the corresponding values to fkey
       indices. For example, suppose:
          the line_of_output is "23.43 al bayucan", and fkey is {1, 3}, 
          then fkeyval will be set to "23.43@bayucan"
   
       if where listbox is "hosts",
	  append line_of_output to hostinfo(fkeyval) array
	  append line_of_output to Hosts listbox
	  Non-contiguous highlight/select the line_of_output in Hosts listbox
            if its primary key value matches one of hostsSelected
       else if where listbox is "queues",
	  append line_of_output to qinfo(fkeyval) array
	  if line_of_output's fkeyval matches one of hostsSelected entries,
	  then
	    append line_of_output to Queues listbox
	    Non-contiguous highlight/select the line_of_output in Queues listbox
              if its primary key value matches one of queuesSelected
          endif
       else if where listbox is "jobs",
	  append line_of_output to jobinfo(fkeyval) array
	  if line_of_output's fkeyval matches one of queuesSelected entries,
	  then 
	    append line_of_output to Jobs listbox
	    Non-contiguous highlight/select the line_of_output in Jobs listbox
              if its primary key value matches one of jobsSelected
	  endif
       endif	

       reset values for hostsSelected, queuesSelected, jobsSelected based on
	 what's currently selected/highlighted on the different listboxes.

       if no data found, popup an Info box.
       Send to InfoBox the done message.	
       remove busy cursor 	   
.fi
.RE
.NH 3
.Fn loadJobs()
.Cs
loadJobs{}
.Ce
.LP
Control Flow:
.RS
.nf
Clear the entries of Jobs Listbox.
set jobsSelMode to "Select All"
set jobsSelected to none

Load values of jobinfo, whose indices match any of queuesSelected, into Jobs
listbox.
.fi
.RE
.NH 3
.Fn loadQueues()
.Cs
loadQueues{}
.Ce
.LP
Control Flow:
.RS
.nf
Clear the entries of Queues Listbox.
set queuesSelMode to "Select All"
set queuesSelected to none

Clear the entries of Jobs Listbox.
set jobsSelMode to "Select All"
set jobsSelected to none

Load values of qinfo, whose indices match any of hostsSelected, into Queues
listbox.
.fi
.RE
.NH 3
.Fn getHostsDetail()
.Cs
getHostsDetail{}
.Ce
.LP
Control Flow:
.RS
.nf
if hostsSelected isEmpty; then
  popup InfoBox asking user to select a host
endif
run PBS_HOSTS_DETAIL_CMD on hostsSelected 
.fi
.RE
.NH 3
.Fn getQueuesDetail()
.Cs
getQueuesDetail{}
.Ce
.LP
Control Flow:
.RS
.nf
if queuesSelected isEmpty; then
  popup InfoBox asking user to select a queue
endif
run PBS_QUEUES_DETAIL_CMD on queuesSelected 
.fi
.RE
.NH 3
.Fn getJobsDetail()
.Cs
getJobsDetail{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
run PBS_HOSTS_DETAIL_CMD on jobsSelected 
.fi
.RE
.NH 3
.Fn runDelete()
.Cs
runDelete{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
call qdel procedure
.fi
.RE
.NH 3
.Fn runHold()
.Cs
runHold{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
call qhold procedure
.fi
.RE
.NH 3
.Fn runRelease()
.Cs
runRelease{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
call qrls procedure
.fi
.RE
.NH 3
.Fn runRerun()
.Cs
runRerun{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
run cmdpath(QRERUN) on jobsSelected
get new data for jobs only
.fi
.RE
.NH 3
.Fn runRun()
.Cs
runRun{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
run cmdpath(QRUN) on jobsSelected
get new data for jobs only
.fi
.RE
.NH 3
.Fn runQsig()
.Cs
runQsig{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
call qsig procedure
.fi
.RE
.NH 3
.Fn runQmsg()
.Cs
runQmsg{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
call qmsg procedure
.fi
.RE
.NH 3
.Fn runQmove()
.Cs
runQmove{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
call qmove procedure
.fi
.RE
.NH 3
.Fn runQstop()
.Cs
runQstop{}
.Ce
.LP
Control Flow:
.RS
.nf
if queuesSelected isEmpty; then
  popup InfoBox asking user to select a queue
endif
run cmdpath(QSTOP) on queuesSelected
get new data
.fi
.RE
.NH 3
.Fn runQstart()
.Cs
runQstart{}
.Ce
.LP
Control Flow:
.RS
.nf
if queuesSelected isEmpty; then
  popup InfoBox asking user to select a queue
endif
run cmdpath(QSTART) on queuesSelected
get new data
.fi
.RE
.NH 3
.Fn runQenable()
.Cs
runQenable{}
.Ce
.LP
Control Flow:
.RS
.nf
if queuesSelected isEmpty; then
  popup InfoBox asking user to select a queue
endif
run cmdpath(QENABLE) on queuesSelected
get new data
.fi
.RE
.NH 3
.Fn runQdisable()
.Cs
runQdisable{}
.Ce
.LP
Control Flow:
.RS
.nf
if queuesSelected isEmpty; then
  popup InfoBox asking user to select a queue
endif
run cmdpath(QDISABLE) on queuesSelected
get new data
.fi
.RE
.NH 3
.Fn runQalter()
.Cs
runQalter{}
.Ce
.LP
Control Flow:
.RS
.nf
if jobsSelected isEmpty; then
  popup InfoBox asking user to select a job
endif
call qalter procedure
.fi
.RE
.NH 3
.Fn runQorder()
.Cs
runQorder{}
.Ce
.LP
Control Flow:
.RS
.nf
if # of jobsSelected is != 2 ; then
  popup InfoBox asking user to select 2 jobs
endif
run cmdpath (QORDER) on jobsSelected
get new data for jobs only
.fi
.RE
.NH 3
.Fn runQterm()
.Cs
runQterm{}
.Ce
.LP
Control Flow:
.RS
.nf
if hostsSelected isEmpty; then
  popup InfoBox asking user to select a host
endif
call qterm procedure
get new data
.fi
.RE
.NH 3
.Fn runQsub()
.Cs
runQsub{}
.Ce
.LP
Control Flow:
.RS
.nf
if hostsSelected isEmpty ; then
  popup InfoBox asking user to select ONE host
elseif # of hostsSelected != 1; then
  bring up a bridge window asking users to limit selection 
endif
call qsub procedure
.fi
.RE
.NH 3
.Fn build_opt()
.Cs
build_opt{cmdline {pbsdir "#PBS"} {do_qalter 0}}
.Ce
.IP Args: 4
.RS
.IP cmdline 11
a boolean value where if set to 1 means command line options will be
returned; otherwise, PBS directive lines will be returned as a string.
.IP pbsdir 11
the PBS directive line parse string if \f3cmdline\fP is set to 1. 
.IP do_qalter
a boolean value (0 or 1) signalling options to be build is for the qalter
command instead of qsub.
.RE
.IP Returns: 4
The command line options string (if cmdline set to 1); otherwise, returns
the PBS directive lines.
.LP
Control Flow:
.RS
.nf
if do_qalter ; then
  option_value will be taken from qalterv (input_array)
  the current_dialog_box is ".qalter"
  set the default array to "def_qalter"
else
  option_value will be taken from qsubv (input_array)
  the current_dialog_box is ".qsub"
  set the default array to "def_qsub"
endif

Foreach option_name in \f3options\fP
do
  get option_name's dialog boxes location
  get option_name's option letter
  get option_name's special instructions

  if current_dialog_box is one of option_line's dialog boxes AND
       option_value is found and notEmpty and not match option_name's default
	 value
  then
    if option_name's special instruction says the option is a toggle (meaning
       no arguments), then
	 create an opt array entry with index "option letter" for option_name,
           and value "option_value".
    else 
	 create an opt array entry (if one doesn't exist) with index
           "option letter" for option_name and value "option_value". 
         if opt array entry already exists, prefix with a "," and append
	   "option_value"
    endif
  endif
 
  NOTE: opt is an array whose element names correspond to option letters, and
                              element values correspond to actual arguments to
			      option letters. 	    

 Build the options commandline or directive lines depending on whether or not
   cmdline is set, using the opt array.
.fi
.RE
.NH 3
.Fn set_opt_default()
.Cs
set_opt_default{array {do_main 1}    {do_depend 0} {do_staging 0} {do_misc 0}
                       {do_qalter 0} {do_email 0}}
.Ce
.IP Args: 4
.RS
.IP array 14
the array to be loaded with default widget values.
.IP do_main 14 
a boolean value that says set widget values in main window.
.IP do_depend 14
a boolean value that says set widget values in job dependency window.
.IP do_staging 14
a boolean value that says set widget values in file staging window.
.IP do_misc 14
a boolean value that says set widget values in misc window.
.IP do_qalter 14
a boolean value that says the current dialog box is qalter
.IP do_email 14
a boolean value that says set widget values in email dialog box.
.RE
.IP Returns: 4
The array values corresponding to widget defaults.
.LP
Control Flow:
.RS
.nf
Foreach widget_variable in default
do
  set array values with widget values depending on which group of widgets
      were instructed to be set.  
done
.fi
.RE
.NH 3
.Fn load_qsub_input()
.Cs
load_qsub_input{fd}
.Ce
.IP Args: 4
.RS
.IP fd 6
the file stream descriptor containing "job_attribute = value" data lines.
.RE
.IP Returns: 4
Zero if qsubv array was successfully loaded with widget values; 1 otherwise.
.LP
Control Flow:
.RS
.nf
Initialize attrlist, queueName, and serverName buffers

Foreach  data received in fd
do
  skip empty data
  get attribute and value parts of the data
  set appropriate entries in qsubv depending on the attribute value 
done

Special processing:

  Break up resource attribute list
  Compare the queue_name read from data with the entries in Submit window's
     destination listbox.
     - if queue_name doesn't start with "@", highlight/select an entry 
          in the destination listbox that matches "<queue_name>" (exactly) or
	  "<queue_name>@".
     - if queue_name starts with "@", then we have an @serverName
          specification. Highlight/select an entry in the destination listbox
	  that begins with the string specified by <queue_name>
     For example, "fast" will match "fast" and "fast@vn" entries, but it will
	not match "fast1" or "fast1@vn". "@vn" will match "@vn.nas.nasa.gov"
	or even "@vn.larc.nasa.gov".  	
 Now adjust the view of the destination listbox so that the selected entry can
 be seen.   

close the file stream descriptor
.fi
.RE
.NH 3
.Fn oper()
.Cs
oper{operator}
.Ce
.IP Args: 4
.RS
.IP operator 11
the operator string - should be one of "=", "!=", ">=", ">", "<=", "<"
.RE
.IP Returns: 4
the comparison operator string used in PBS select command. Returns empty string
if the mapping could not be found.
.LP
Control Flow:
.RS
.nf
  case "="	return ".eq."
       "!="	return ".ne."
       ">="	return ".ne."
       ">"	return ".gt."
       "<="	return ".le."
       "<"	return ".lt."
       *other*  return "" 
.fi
.RE
.NH 3
.Fn oper_invert()
.Cs
oper_invert {str}
.Ce
.IP Args: 4
.RS
.IP str 5
the operator string - should be one of "eq", "ne", "ge", "gt", "le", "lt"
.RE
.IP Returns: 4
the comparison operator display string used in the GUI. Returns empty string
if the mapping could not be found.
.LP
Control Flow:
.RS
.nf
  case "eq"	return "="
       "ne"	return "!="
       "ge"	return ">="
       "gt"	return ">"
       "le"	return "<="
       "lt"	return "<"
       *other*  return "" 
.fi
.RE
.NH 3
.Fn cvtdatetime_arg()
.Cs
cvtdatetime_arg{mon day year hh mm ss}
.Ce
.IP Args: 4
.RS
.IP mon 7
the month string: Jan - Dec
.IP day 7
the day string 
.IP year 7
the year string
.IP hh 7
the hour string
.IP mm 7
the minute string 
.IP ss 7
the seconds string
.RE
.IP Returns: 4
the date/time argument string suitable for PBS commands execution.
.LP
Control Flow:
.RS
.nf
Map month string to a corresponding numeric value
Prefix day with a 0 if day value is between 0 and 9  
Prefix hour with a 0 if hour value is between 0 and 9  
Prefix minute with a 0 if minute value is between 0 and 9  
Prefix seconds with a 0 if seconds value is between 0 and 9  
.fi
.RE
.NH 3
.Fn build_sel_options()
.Cs
build_sel_options{}
.Ce
.IP Returns: 4
the options string suitable for the PBS qselect command.
.LP
Control Flow:
.RS
.nf
Get option names from the select_opt array
Get option values from the selv array

Append to options_list:
  (1) the option_letter as obtained from select_opt array
  (2) the option_value if it is not empty and not "-ANY".
  
Return the options_list
.fi
.RE
.NH 3
.Fn xpbs_help()
.Cs
xpbs_help{help_category callerDialogBox}
.Ce
.IP Args: 4
.RS
.IP help_category 19
the kind of help text to exhibit. Help files are named as 'help_category'.hlp
.IP callerDialogBox 19
the widget path of the calling dialog box. This is so that we can put back the
input focus to the originating dialog box.
.RE
.LP
Control Flow:
.RS
.nf
run a "cat <helpdir>/<help_category>.hlp" with output going to an Info box.
.fi
.RE
.NH 3
.Fn resources_help()
.Cs
resources_help {callerDialogBox, suffix}
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 19
the widget path of the calling dialog box. This is so that we can put back the
input focus to the originating dialog box.
.IP suffix 19
a help page suffix.
.RE
.LP
Control Flow:
.RS
.nf
run a "man pbs_resources_$suffix | col -b" with output going to an Info box.
.fi
.RE
.NH 3
.Fn set_default_qsub_main()
.Cs
set_default_qsub_main {}
.LP
Control Flow:
.RS
.nf
set main submit window-associated  array elements of qsubv to default
.fi
.RE
.NH 3
.Fn init_qsub_main_argstr()
.Cs
init_qsub_main_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with dSubmit main window using
the array elements found in qsubv
.fi
.RE
.NH 3
.Fn set_default_qsub_depend()
.Cs
set_default_qsub_depend {}
.LP
Control Flow:
.RS
.nf
set depend window-associated  array elements of qsubv to default
.fi
.RE
.NH 3
.Fn init_qsub_depend_argstr()
.Cs
init_qsub_depend_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with depend using the
array elements found in qsubv
.fi
.RE
.NH 3
.Fn set_default_qsub_staging()
.Cs
set_default_qsub_staging {}
.LP
Control Flow:
.RS
.nf
set file staging window-associated  array elements of qsubv to default
.fi
.RE
.NH 3
.Fn init_qsub_staging_argstr()
.Cs
init_qsub_staging_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with file staging using the
array elements found in qsubv
.fi
.RE
.NH 3
.Fn set_default_qsub_misc()
.Cs
set_default_qsub_misc {}
.LP
Control Flow:
.RS
.nf
set misc window-associated  array elements of qsubv to default
.fi
.RE
.NH 3
.Fn init_qsub_misc_argstr()
.Cs
init_qsub_misc_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with misc using the
array elements found in qsubv
.fi
.RE
.NH 3
.Fn set_default_qsub_datetime()
.Cs
set_default_qsub_datetime {}
.LP
Control Flow:
.RS
.nf
set datetime window-associated  array elements of qsubv to default
.fi
.RE
.NH 3
.Fn init_qsub_datetime_argstr()
.Cs
init_qsub_datetime_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with datetime using the
array elements found in qsubv
.fi
.RE
.NH 3
.Fn set_default_qsub_email()
.Cs
set_default_qsub_email {}
.LP
Control Flow:
.RS
.nf
set email addresses  window-associated  array elements of qsubv to default
.fi
.RE
.NH 3
.Fn init_qsub_email_argstr()
.Cs
init_qsub_email_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with email addresses using the
array elements found in qsubv
.fi
.RE
.NH 3
.Fn set_default_qalter_main()
.Cs
set_default_qalter_main {}
.LP
Control Flow:
.RS
.nf
set main qalter window-associated  array elements of qalterv to default
.fi
.RE
.NH 3
.Fn init_qalter_main_argstr()
.Cs
init_qalter_main_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with main qalter window using the
array elements found in qalterv
.fi
.RE
.NH 3
.Fn set_default_qalter_depend()
.Cs
set_default_qalter_depend {}
.LP
Control Flow:
.RS
.nf
set qalter depend window-associated array elements of qalterv to default
.fi
.RE
.NH 3
.Fn init_qalter_depend_argstr()
.Cs
init_qalter_depend_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with depend using the
array elements found in qalterv
.fi
.RE
.NH 3
.Fn set_default_qalter_staging()
.Cs
set_default_qalter_staging {}
.LP
Control Flow:
.RS
.nf
set staging window-associated array elements of qalterv to default
.fi
.RE
.NH 3
.Fn init_qalter_staging_argstr()
.Cs
init_qalter_staging_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with file staging using the
array elements found in qalterv
.fi
.RE
.NH 3
.Fn set_default_qalter_misc()
.Cs
set_default_qalter_misc {}
.LP
Control Flow:
.RS
.nf
set misc window-associated array elements of qalterv to default
.fi
.RE
.NH 3
.Fn init_qalter_misc_argstr()
.Cs
init_qalter_misc_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with misc widgets using the
array elements found in qalterv
.fi
.RE
.NH 3
.Fn set_default_qalter_datetime()
.Cs
set_default_qalter_datetime {}
.LP
Control Flow:
.RS
.nf
set datetime window-associated array elements of qalterv to default
.fi
.RE
.NH 3
.Fn init_qalter_datetime_argstr()
.Cs
init_qalter_datetime_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with datetime widgets using the
array elements found in qalterv
.fi
.RE
.NH 3
.Fn set_default_qalter_email()
.Cs
set_default_qalter_email {}
.LP
Control Flow:
.RS
.nf
set email window-associated array elements of qalterv to default
.fi
.RE
.NH 3
.Fn init_qalter_email_argstr()
.Cs
init_qalter_email_argstr{}
.LP
Control Flow:
.RS
.nf
set to default the argument strings associated with email widgets using the
array elements found in qalterv
.fi
.RE
.NH 3
.Fn set_pbs_options()
.Cs
set_pbs_options {}
.LP
Control Flow:
.RS
.nf
sets the various PBS options for qsub, qalter, and qselect
.fi
.RE
.NH 3
.Fn set_pbs_defaults()
.Cs
set_pbs_defaults {}
.LP
Control Flow:
.RS
.nf
set various widget defaults using the arrays def_qsub and def_qalter
.fi
.RE
.NH 3
.Fn about()
.Cs
about {}
.LP
Control Flow:
.RS
.nf
popup the "About.." dialog box
display the XPBS logo.
create the message widget
display both the image and the message.
.fi
.RE
.NH 2
.Fi common.tk
.LP
This file contains various routines that don't quite fit in the framework of
the other "files".
.NH 3
.Fn lintmax()
.Cs
lintmax {intlist}
.Ce
.IP Args: 4
.RS
.IP intlist 11
a positive list of integers
.RE
.IP Returns 4
element with the maximum value; -1 if errors are detected. 
.LP
Control Flow:
.RS
.nf
sort the integer list from highest value to smallest value
return the highest value
.fi
.RE
.NH 3
.Fn lintmin()
.Cs
lintmin {intlist}
.Ce
.IP Args: 4
.RS
.IP intlist 11
a positive list of integers
.RE
.IP Returns 4
element with the minimum value; -1 if errors are detected. 
.LP
Control Flow:
.RS
.nf
sort the integer list from smallest value to highest value
return the smallest value
.fi
.RE
.NH 3
.Fn popupDialogBox()
.Cs
popupDialogBox{dialog_top title {grab_window 1} {class ""}}
.Ce
.IP Args: 4
.RS
.IP dialog_top 14
frame of the dialog box to bring up
.IP title 14
title to be given to the dialog box
.IP grab_window 14
boolean value (0 or 1) that says set a grab on the dialog box.
.IP class 14
class name to associate with the dialog box.
.RE
.IP Returns 4
the top and bottom frames of the dialog box.  
.LP
Control Flow:
.RS
.nf
Create a toplevel window called 'dialog_top' for dialog box toplevel. Declare
it with 'class' if class name is given.
Give a title text to the dialog box.
if grab_window then set a grab on the dialog box.
Set focus on the dialog box.
create the top and bottom frames of the dialog box and make them visible.
Return the top and bottom frames. 
.fi
.RE
.NH 3
.Fn win_cmdExec()
.Cs
win_cmdExec{callerDialogBox command_list}
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 19
dialog box that called this procedure. This is for setting the input focus
back to the calling dialog box after running this routine. 
.IP command_list 19
a command to execute.
.RE
.IP Returns 4
the exit code of the executed command.
.LP
Control Flow:
.RS
.nf
set busy_cursor
Send a message to InfoBox regarding execution of 'command_list'.
Execute 'command_list'.
Popup an error dialog box if command execution failed; otherwise, popup an
output box.
After command execution, send message to InfoBox about its completion and
remove busy_cursor.
.fi
.RE
.NH 3
.Fn busy_cursor()
.Cs
busy_cursor{}
.Ce
.LP
Control Flow:
.RS
.nf
Look for an active window by checking the \f3activeWindow\fP array.
Configure the active window's mouse cursor to be an hourglass.
.fi
.RE
.NH 3
.Fn remove_busy_cursor()
.Cs
remove_busy_cursor{}
.Ce
.LP
Control Flow:
.RS
.nf
Look for an active window by checking the \f3activeWindow\fP array.
Configure the active window's mouse cursor to go back to the default image.
.fi
.RE
.NH 3
.Fn cmdExec()
.Cs
cmdExec{command_list {popupError 0} {retcode_only 0}}
.Ce
.IP Args: 4
.RS
.IP command_list 16
a command to execute.
.IP popupError 16
boolean value (0 or 1) that says to popup an error box if an error was
encountered.
.IP retcode_only 16
boolean value (0 or 1) that says to return the exit code of the command
instead of its output.
.RE
.IP Returns 4
the output of the command unless exit code is specified (see retcode_only
argument).
.LP
Control Flow:
.RS
.nf
set busy_cursor
Send message to InfoBox regarding start of \f3command_list\fP execution.
Execute \f3command_list\fP.
If an error occurred during command execution, popup an error dialog box.
Send message to InfoBox regarding command execution completion.
remove_busy_cursor
return output of the command if \f3retcode_only\fP is not set; otherwise,
return exitcode
.fi
.RE
.NH 3
.Fn InfoBox_sendmsg()
.Cs
InfoBox_sendmsg { message {line_number 1} {append 0} {xview_increment 1} }
.Ce
.IP Args: 4
.RS
.IP message 19
message to send to InfoBox.
.IP line_number 19
the line_number entry of the InfoBox (relative to 0) where message will be
inserted.
.IP append 19
boolean value (0 or 1) that says to append the message to an existing
\f3line_number\fP.
.IP xview_increment 19
how much to right shift the horizontal display of the InfoBox. 
.RE
.LP
Control Flow:
.RS
.nf
if not append
  insert new message at 'line_number'
  delete previous message at 'line_number' if more than one entries are found
    and 'line_number' is < InfoBox size.
if append
  get the previous message at 'line_number'
  insert the previous message and the new message to 'line_number'
  delete the previous message if there are more than one entries in InfoBox
    and 'line_number' is < InfoBox size.	

Adjust the horizontal view of the listbox so that the command at the end
is visible. For Tk versions < 4.0, make use of the 'xview_increment' variable. 
.fi
.RE
.NH 3
.Fn cmdExec_bg()
.Cs
cmdExec_bg{command_list {popupError 0}}
.Ce
.IP Args: 4
.RS
.IP command_list 16
the command to execute in the background.
.IP popupError 16
boolean value (0 or 1) that says to popup an error dialog box when 
command execution has encountered an error.
.RE
.IP Returns 4
a stream descriptor where input can be read.
.LP
Control Flow:
.RS
.nf
Use Tcl pipe mechanism to execute 'command_list'.
Return pipe stream descriptor.
.fi
.RE
.NH 3
.Fn popupOutputBox()
.Cs
popupOutputBox{output}
.Ce
.IP Args: 4
.RS
.IP output 11
output message string to display.
.RE
.LP
Control Flow:
.RS
.nf
Create the Ouput dialog box.
Populate the top frame with a read-only text box widget. Also create a
vertical scrollbar for the text widget.
Make text widget and scrollbar visible.
Populate the bottom frame with an 'ok' binding.
Insert 'output' to the text widget.
Bind <Return> key to 'ok'.
.fi
.RE
.NH 3
.Fn popupErrorBox()
.Cs
popupErrorBox {retcode command_list errmsg {width_pixels 500}
               {callerDialogBox ""} }
.Ce
.IP Args: 4
.RS
.IP retcode 19
exit code of the executed command.
.IP command_list 19
command string that was executed.
.IP errmsg 19
error message resulted from command execution.
.IP width_pixels 19
the width of the error dialog box.
.IP callerDialogBox 19
the name of the calling dialog box.
.RE
.LP
Control Flow:
.RS
.nf
Create the Error dialog box.
Populate the top frame with a message widget containing information about exit
code, error message, and the name of the command executed.
Make message widget visible.
Populate the bottom frame with an 'ok' binding.
Bind <Return> key to 'ok'.
wait for the window to be destroyed before setting the focus back to 
the calling dialog box.
.fi
.RE
.NH 3
.Fn popupInfoBox()
.Cs
popupInfoBox {callerDialogBox msg {width_pixels 500} {focusBox}}
.Ce
.IP Args 4
.RS
.IP callerDialogBox 19
dialog box that called this routine.
.IP msg 19 
the message string to display.
.IP width_pixels 19
the width of the error dialog box.
.IP focusBox 19
a widget name
.RE
.LP
Control Flow:
.RS
.nf
Create the Info dialog box.
Populate the top frame with a message widget containing the 'msg' string.
Make message widget visible.
Populate the bottom frame with an 'ok' binding.
Bind <Return> key to 'ok'.
wait for the window to be destroyed before setting the focus back to 
  'focusBox'.
.fi
.RE
.NH 3
.Fn create_DateTime_box()
.Cs
create_DateTime_box {frame_name def_mon def_day def_yr def_hr
                     def_min def_sec ARR }
.Ce
.IP Args: 4
.RS
.IP frame_name 14
frame to place the date/time spin boxes.
.IP def_mon 14
default month entry value.
.IP def_day 14
default day entry value.
.IP def_yr 14
default year entry value.
.IP def_hr 14
default hour entry value.
.IP def_min 14
default minutes entry value.
.IP def_sec 14
default seconds entry value.
.IP ARR 14
array holding the entry text variables associated with the various spinboxes.
This array will hold the elements: qtimeMon, qtimeDay, qtimeYear, qtimeHH,
qtimeMM, and qtimeSS.
.RE
.IP Returns 4
the frame_name, month, day, year, hour, minute, seconds entry widget names, 
list of scrollbars used, and list of labels used.
.LP
Control Flow:
.RS
.nf
Create the frames to hold the spinbox entries, labels, and scrollbars.
Create the necessary labels.
Make the frames and labels visible.
Create the 6 spinboxes, specifying the appropriate default entry values.
Return widget names involved.
.fi
.RE
.NH 3
.Fn disable_label()
.Cs
disable_label {label_name color_name}
.Ce
.IP Args: 4
.RS
.IP label_name 14
label widget name to disable.
.IP color_name 14
color of the label widget when disabled.
.RE
.LP
Control Flow:
.RS
.nf
Save the current color of the label widget to the global selColor array.
Configure the label widget to have 'color_name'.
.fi
.RE
.NH 3
.Fn enable_label()
.Cs
enable_label{label_name}
.Ce
.IP Args: 4
.RS
.IP label_name 14
label widget name to enable.
.RE
.LP
Control Flow:
.RS
.nf
Get the active color of the label widget from the selColor array.
Configure the label widget to have the active color.
.fi
.RE
.NH 3
.Fn disable_scrollbar()
.Cs
disable_scrollbar{scrollbar color_name}
.Ce
.IP Args: 4
.RS
.IP scrollbar 14
scrollbar widget name to disable.
.IP color_name 14
color of the scrollbar widget when disabled.
.RE
.LP
Control Flow:
.RS
.nf
Save the current background/trough color, foreground color, and active
foreground colors of the scrollbar widget.
If widget is already disabled, then return
Configure the scrollbar widget so that background/trough, foreground, and
active foreground colors are all set to 'color_name'.
.fi
.RE
.NH 3
.Fn enable_scrollbar()
.Cs
enable_scrollbar{scrollbar}
.Ce
.IP Args: 4
.RS
.IP scrollbar 14
scrollbar widget name to enable.
.RE
.LP
Control Flow:
.RS
.nf
Get the current background/trough color, foreground color, and active
foreground colors of the scrollbar widget from selColor.
Configure the scrollbar widget so that background/trough, foreground, and
active foreground colors are all set to the active colors.
.fi
.RE
.NH 3
.Fn disable_dateTime()
.Cs
disable_dateTime {entryList scrollList labelList}
.Ce
.IP Args: 4
.RS
.IP entryList 14
a list of date/time entry widgets.
.IP scrollList 14
a list of date/time scrollbar widgets.
.IP labelList 14
a list of date/time label widgets.
.RE
.LP
Control Flow:
.RS
.nf
Get the disable color from the global variable/resource disabledColor.
Disable the spinbox entries.
Disable the spinbox scrollbars.
Disable the spinbox labels.
.fi
.RE
.NH 3
.Fn enable_dateTime()
.Cs
enable_dateTime {entryList scrollList labelList}
.Ce
.IP Args: 4
.RS
.IP entryList 14
a list of date/time entry widgets.
.IP scrollList 14
a list of date/time scrollbar widgets.
.IP labelList 14
a list of date/time label widgets.
.RE
.LP
Control Flow:
.RS
.nf
Enable the spinbox entries.
Enable the spinbox scrollbars.
Enable the spinbox labels.
.fi
.RE
.NH 3
.Fn construct_array_args()
.Cs
construct_array_args {arr sep {header_str ""} }
.Ce
.IP Args: 4
.RS
.IP arr 14
the array the construct an argument string. 
.IP sep 14
the separator of array elements in the resulting argument string.
.IP header_str 14
a leading string to insert in the resulting argument string.
.RE
.IP Returns 4
a string containing the elements of 'arr' separated by 'sep'.
.LP
Control Flow:
.RS
.nf
Initialize the return string.
Cycle through the sorted elements of 'arr', ignoring empty slots, and construct
the return string.
Return the resulting string.
.fi
.RE
.NH 3
.Fn deconstruct_array_args()
.Cs
deconstruct_array_args {arr_str arr sep {header_str_to_ignore ""} }
.Ce
.IP Args: 4
.RS
.IP arr_str 23
the argument string to deconstruct.
.IP arr 23
the array string to construct. 
.IP sep 23
the separator of array elements in the resulting argument string.
.IP header_str_to_ignore 23
a leading string to ignore when scanning 'arr_str' for input to 'arr'.
.RE
.IP Returns 4
the array 'arr' containing the characters in the string 'arr_str' that appear
in between 'sep'.
.LP
Control Flow:
.RS
.nf
Parse through 'arr_str' looking for characters in between 'sep' and not
matching 'header_str_to_ignore'. Fill the array 'arr' with the characters
found.
.fi
.RE
.NH 3
.Fn set_dateTime()
.Cs
set_dateTime { m d y hour min sec {default 0} {valuestr ""} }
.Ce
.IP Args: 4
.RS
.IP m 12 
a month spinbox entry textvariable.
.IP d 12 
a day spinbox entry textvariable.
.IP y 12 
a year spinbox entry textvariable.
.IP hour 12 
a hour spinbox entry textvariable.
.IP min 12 
a minutes spinbox entry textvariable.
.IP sec 12 
a seconds spinbox entry textvariable.
.IP default 12 
boolean value (0 or 1) that says to set values of textvariables to default.
.IP valuestr 12 
a string of numbers to set textvariables to.
.RE
.LP
Control Flow:
.RS
.nf
Get the date valuestr.
Set month, day, year, hour, minutes, and seconds textvariable values to:
  (1) default (Jan 1 1970 00:00:00) if 'default' is set, or if unable to
      obtain the current date/time string.
  (2) current date/time string.
For day, hour, minute, seconds values that fall between 0 and 9, make sure
  they are prefixed with a 0.  
.fi
.RE
.NH 3
.Fn digit()
.Cs
digit{number_str}
.Ce
.IP Args: 4
.RS
.IP number_str 14
a number string to convert to a digit.
.RE
.IP Returns 4
the digit part of a number string (i.e. 08 returns 8; 9 returns 9, etc...)
.LP
Control Flow:
.RS
.nf
Use of a case/switch statement should be sufficient with a regular expression
match on the number string. 
.fi
.RE
.NH 3
.Fn packinfo()
.Cs
packinfo {slave}
.Ce
.IP Args: 4
.RS
.IP slave 9
slave widget to return packing information.
.RE
.IP Returns 4
pack information for slave widget.
.LP
Control Flow:
.RS
.nf
Return the output from "pack info (or newinfo for Tk < 4.0)". 
.fi
.RE
.NH 3
.Fn clear_array()
.Cs
clear_array {array_name}
.Ce
.IP Args: 4
.RS
.IP array_name 13
name of an array
.RE
.IP Returns 4
the array 'array_name' whose elements are empty strings.
.LP
Control Flow:
.RS
.nf
Cycle through the elements of 'array_name', and resetting to empty
string each element's value.
.fi
.RE
.NH 3
.Fn load_argstr()
.Cs
load_argstr {arr_str outersep arraylist innersep_list {header_str_to_ignore}}
.Ce
.IP Args: 4
.RS
.IP arr_str 25
string containing tokens that will populate 'arraylist'.
.IP outersep 25
char separating tokens in 'arr_str'.
.IP array_list 25
list of arrays to be loaded with tokens found 'arr_str'.
.IP innsersep_list 25
list of characters to separate sub-tokens within each token.
.IP header_str_to_ignore 25
string at the beginning of 'arr_str' to ignore.
.RE
.LP
Control Flow:
.RS
.nf
Get all the tokens separated by 'outersep' in 'arr_str'
For each token ; do
  Get the subtokens separated by 'innersep_list'. 
  Copy each subtoken to corresponding elements in 'arraylist'.
.RS
Cycle through the elements of 'array_name', and resetting to empty
string each element's value.
.RE
.fi
.RE
.NH 2
.Fi button.tk
.LP
This file contains routines that are related to button widgets.
.NH 3
.Fn buildCheckboxes()
.Cs
buildCheckboxes {frame_name checkbutton_list orient spacing
                 {checkbox_labelstr ""} {place_buttonAssoc_right 1}
                 {place_labelstr_top 0} {button_assoc_groove_relief 0} }
.Ce
.IP Args: 4
.RS
.IP frame_name 30
name of the frame where a collection of checkbuttons will be placed.
.IP checkbutton_list 30
a list of checkbutton grouping specifications. A grouping specification is
in itself another list where each entry specifies the name for the button,
the label, and any outside widget association. Think of this as 2-deep:
list of lists.
.br
\ \ \ { { {group1_button1Name group1_button1Label group1_button1Assoc} 
.br
\ \ \ \ \ {group1_button2Name group1_button2Label group1_button2Assoc}
.br
\ \ \ \ \ {group1_button3Name group1_button3Label group1_button3Assoc}
.br
\ \ \ \ \ ...
.br
\ \ \ \ } 
.br
\ \ \ \ { {group2_button1Name group2_button1Label group2_button1Assoc}
.br
\ \ \ \ \ {group2_button2Name group2_button2Label group2_button2Assoc}
.br
\ \ \ \ \ ...
.br
\ \ \ \ } 
.br
\ \ \ \ ...
.br
\ \ \ }
.br
.IP orient 30
how the collection of buttons will be grouped - in a "column" or "grid".
.IP spacing 30
distance between checkbuttons (in units or pixels)
.IP checkbox_labelstr 30
single label string describing the collection of checkbuttons.
.IP place_buttonAssoc_right 30
boolean value (0 or 1) that says to place the *button*Assoc to the right side
of a check button instead of at the top.
.IP place_labelstr_top 30
boolean value (0 or 1) that says to place the checkbox_labelstr at the top
instead of at the left side.
.IP button_assoc_groove_relief 30
boolean value (0 or 1) that says to enclose *button*_Assoc in a groove relief.
.RE
.IP Returns 4
a list: frame_name, and widget names for all checkbuttons in the order specified
in 'checkbutton_list'.
.LP
Control Flow:
.RS
.nf
Create and make visible the single checkbox label string. Place the string
either at the top or at the left side depending on whether or
not ' place_labelstr_top' is set.
Foreach group of declared checkbuttons in 'checkbutton_list'; do
  create and make visible the frame for each group
  foreach button in  each group; do
    if there's an associated widget for a button, then
      create a frame that will hold the button and the associated widget
      create the button
      make the button and the associated widget visible.  
      append to buttonList the frame name holding the button and the associated
           widget.
    else
      create the button
      append to buttonList the name of the button 
    endif
  done
done
pack buttonList
return list of widget names involved.
.fi
.RE
.NH 3
.Fn buildCmdbuttons()
.Cs
buildCmdButtons {frame_name cmdbutton_list orient spacing button_width
                 button_height {first_group_spacing 0}
                 {spread_out_buttons 1} {group_spacing "10m"}
                 {cmdButton_labelstr ""}} 
.Ce
.IP Args: 4
.RS
.IP frame_name 22
name of the frame where a collection of command buttons will be placed.
.IP cmdbutton_list 22
a list of command button grouping specifications. A grouping specification is
in itself another list where each entry specifies the name for the button,
the label, and any outside widget association. Think of this as 2-deep:
list of lists.
.br
\ \ \ { { {group1_button1Name group1_button1Label group1_button1Assoc} 
.br
\ \ \ \ \ {group1_button2Name group1_button2Label group1_button2Assoc}
.br
\ \ \ \ \ {group1_button3Name group1_button3Label group1_button3Assoc}
.br
\ \ \ \ \ ...
.br
\ \ \ \ } 
.br
\ \ \ \ { {group2_button1Name group2_button1Label group2_button1Assoc}
.br
\ \ \ \ \ {group2_button2Name group2_button2Label group2_button2Assoc}
.br
\ \ \ \ \ ...
.br
\ \ \ \ } 
.br
\ \ \ \ ...
.br
\ \ \ }
.br
.IP orient 22
how the collection of buttons will be grouped - in an "x" (horizontal), "y"
(vertical), "xy" (gridded).
.IP spacing 22
distance between command buttons (in units or pixels)
.IP button_width 22
width for all buttons (in units or pixels)
.IP button_height 22
height for all buttons (in units or pixels)
.IP first_group_spacing 22
bolean value (0 or 1) that says to put a 'button_width' spacing before the
1st group of command buttons. 
.IP spread_out_buttons 22
bolean value (0 or 1) that says to spread out the distribution of the command
buttons in 'frame_name'.
.IP group_spacing 22
distance between groups of command buttons (in units or pixels)
.IP cmdButton_labelstr 22
single label string describing the collection of command buttons.
.RE
.IP Returns 4
a list: frame_name, and widget names for all command buttons in the order
specified in 'checkbutton_list'. It will also return the single label string
for the command buttons if one exists.
.LP
Control Flow:
.RS
.nf
Create and make visible the single command button label string.
Foreach group of declared command buttons in 'cmdbutton_list'; do
  create the frame for each group
  create the command buttons
  append to buttonList the name of the buttons 
done
Make visible all command buttons (i.e. pack buttonList)
Pack the frames for each group as follows:
  (1) if first_group_spacing, puts an extra spacing before 1st group
  (2) Put an amount of  'group_spacing" in between each group.
  (3) Pack the frames in such a way that the correct orientation is followed. 
return list of widget names involved.
.fi
.RE
.NH 3
.Fn buildRadioboxes()
.Cs
buildRadioboxes {frame_name radiobutton_list orient spacing
                 {radiobox_labelstr ""} {place_buttonAssoc_right 1}
                 {place_labelstr_top 0} {button_assoc_groove_relief 0} }
.Ce
.IP Args: 4
.RS
.IP frame_name 30
name of the frame where a collection of radiobuttons will be placed.
.IP "radiobutton_list" 30
a list of radiobutton grouping specifications. A grouping specification is
in itself another list where each entry specifies the name for the button,
the label, and any outside widget association. Think of this as 2-deep:
list of lists.
.br
\ \ \ { { {group1_button1Name group1_button1Label group1_button1Assoc} 
.br
\ \ \ \ \ {group1_button2Name group1_button2Label group1_button2Assoc}
.br
\ \ \ \ \ {group1_button3Name group1_button3Label group1_button3Assoc}
.br
\ \ \ \ \ ...
.br
\ \ \ \ } 
.br
\ \ \ \ { {group2_button1Name group2_button1Label group2_button1Assoc}
.br
\ \ \ \ \ {group2_button2Name group2_button2Label group2_button2Assoc}
.br
\ \ \ \ \ ...
.br
\ \ \ \ } 
.br
\ \ \ \ ...
.br
\ \ \ }
.br
.IP orient 30
how the collection of buttons will be grouped - in a "column" or "grid".
.IP spacing 30
distance between radiobuttons (in units or pixels)
.IP radiobox_labelstr 30
single label string describing the collection of radiobuttons.
.IP place_buttonAssoc_right 30
boolean value (0 or 1) that says to place the *button*Assoc to the right side
of a radio button instead of at the top.
.IP place_labelstr_top 30
boolean value (0 or 1) that says to place the radiobox_labelstr at the top
instead of at the left side.
.IP button_assoc_groove_relief 30
boolean value (0 or 1) that says to enclose *button*_Assoc in a groove relief.
.RE
.IP Returns 4
a list: frame_name, and widget names for all radiobuttons in the order specified
in 'checkbutton_list'.
.LP
Control Flow:
.RS
.nf
Create and make visible the single radiobox label string. Place the string
either at the top or at the left side depending on whether or
not ' place_labelstr_top' is set.
Foreach group of declared radiobuttons in 'radiobutton_list'; do
  create and make visible the frame for each group
  foreach button in  each group; do
    if there's an associated widget for a button, then
      create a frame that will hold the button and the associated widget
      create the button
      make the button and the associated widget visible.  
      append to buttonList the frame name holding the button and the associated
           widget.
    else
      create the button
      append to buttonList the name of the button 
    endif
  done
done
pack buttonList
return list of widget names involved.
.fi
.RE
.NH 3
.Fn disable_rcbutton()
.Cs
disable_rcbutton{button_name}
.Ce
.IP Args: 4
.RS
.IP button_name 15
name of a radiobutton or checkbutton to disable.
.RE
.LP
Control Flow:
.RS
.nf
If button already disabled then skip the rest of this routine
Save the active color of the button in the global variable selColor.
Configure the button to be in a disbled state with color of the global
variable disabledColor.
.fi
.RE
.NH 3
.Fn enable_rcbutton()
.Cs
enable_rcbutton{button_name}
.Ce
.IP Args: 4
.RS
.IP button_name 15
name of a radiobutton or checkbutton to enable.
.RE
.LP
Control Flow:
.RS
.nf
If can't find an active color for the button or the state of the button is
   already normal, then
    skip the rest of this routine
Configure the button to be in a normal state with an active color taken from
the global variable selColor.
.fi
.RE
.NH 3
.Fn  disable_button()
.Cs
disable_button{button_name}
.Ce
.IP Args: 4
.RS
.IP button_name 15
name of a command button to disable.
.RE
.LP
Control Flow:
.RS
.nf
If command button already disabled, then skip the rest of this routine.
Configure the state of this button to be disabled.
.fi
.RE
.NH 3
.Fn  enable_button()
.Cs
enable_button{button_name}
.Ce
.IP Args: 4
.RS
.IP button_name 15
name of a command button to enable.
.RE
.LP
Control Flow:
.RS
.nf
Configure the state of this button to be normal.
.fi
.RE
.NH 3
.Fn disable_rcbuttons()
.Cs
disable_rcbuttons{args}
.Ce
.IP Args: 4
.RS
.IP args 15
a list of radiobuttons/checkbuttons to disable.
.RE
.LP
Control Flow:
.RS
.nf
For each button in the argument list, call disable_rcbutton.
.fi
.RE
.NH 3
.Fn enable_rcbuttons()
.Cs
enable_rcbuttons{args}
.Ce
.IP Args: 4
.RS
.IP args 15
a list of radiobuttons/checkbuttons to enable.
.RE
.LP
Control Flow:
.RS
.nf
For each button in the argument list, call enable_rcbutton.
.fi
.RE
.NH 3
.Fn invoke_rbutton()
.Cs
invoke_rbutton {buttons}
.Ce
.IP Args: 4
.RS
.IP buttons 11
a list of radiobuttons to invoke if set.
.RE
.LP
Control Flow:
.RS
.nf
Foreach buttons; do
  if button's value correspond to the ON state, then invoke button.
done
.fi
.RE
.NH 3
.Fn invoke_cbutton()
.Cs
invoke_cbutton {buttons}
.Ce
.IP Args: 4
.RS
.IP buttons 11
a list of checkbuttons to invoke if set.
.RE
.LP
Control Flow:
.RS
.nf
Foreach buttons; do
  Force the button's state to be normal.
  invoke button
  if previous state of the button is disabled ; then
	disable the button again
done
.fi
.RE
.NH 2
.Fi entry.tk
.LP
This file contains routines that are related to entry widgets.
.NH 3
.Fn buildFullEntrybox()
.Cs
 buildFullEntrybox {frame_name label_width label entry_width
                    default_entryval scrollbar_placement all_button
                    {label_placement "left"}}
.Ce
.IP Args: 4
.RS
.IP frame_name 22
the frame where a full entry widget will be placed.
.IP label_width 22
the width (in units or pixels) for a full entry widget label.
.IP label 22
the text for the full entry widget label.
.IP entry_width 22
the width (in units or pixels) for an entry widget.
.IP default_entryval 22
the default value for an entry widget.
.IP scrollbar_placement 22
the location of the entry widget's scrollbar - left, right, bottom, top of
the entry widget.
.IP all_button 22
boolean value (0 or 1) that says to also include special "all" button.
.IP label_placement 22
specifies where to place the accompanying label for the entry widget - left,
right, bottom, top of the entry widget.
.RE
.IP Returns 4
a list: frame_name, "all" button widget name, entry widget name, and scrollbar.
.LP
Control Flow:
.RS
.nf
Create the "all" button if 'all_button' is set.
Create the label for the entry widget.
Create the entry widget.
Insert a default value for the entry widget.
Create a scrollbar and associate it with the entry widget.
Make label, scrollbar, and entry widget visible by paying close attention to
  scrollbar_placement, and label_placement.
return names of all widgets involved.
.fi
.RE
.NH 3
.Fn compress_array()
.Cs
compress_array {array_name}
.Ce
.IP Args: 4
.RS
.IP array_name 14
an array to compress
.RE
.IP Returns: 4
size of the newly-compressed array.
.LP
Control Flow:
.RS
.nf
Initialized the 'next' slot to be filled with non-empty data.
Go through all elements of 'array_name', 
  if element is non-empty, 
    insert element to the 'next' slot in array2.
    increment 'next'
  endif

Unset 'array_name'
Copy back all elements of 'array2' back to 'array_name' with all non-empty
entries now removed.  
Return the size of the new array.
.fi
.RE
.NH 3
.Fn disable_fullentry()
.Cs
disable_fullentry{entryLabel entry entryScroll {allButton ""}}
.Ce
.IP Args: 4
.RS
.IP entryLabel 15
label for an entry widget.
.IP entry 15
entry widget to disable.
.IP entryScroll 15
scrollbar for entry widget.
.IP allButton 15
the special "all" for an entry widget.
.RE
.LP
Control Flow:
.RS
.nf
Disable entryLabel using disabledColor as color.
Disable scrollbar using disabledColor as color.
Disable the "all" button.
If the entry widget is not yet disabled, then 
  save the foreground color information of the entry widget to selColor
  set the entry widget's state to disabled, and foreground color to
    disabledColor
endif
.fi
.RE
.NH 3
.Fn enable_fullentry()
.Cs
disable_fullentry{entryLabel entry entryScroll {allButton ""}}
.Ce
.IP Args: 4
.RS
.IP entryLabel 15
label for an entry widget.
.IP entry 15
entry widget to enable.
.IP entryScroll 15
scrollbar for entry widget.
.IP allButton 15
the special "all" for an entry widget.
.RE
.LP
Control Flow:
.RS
.nf
Enable entryLabel.
Enable scrollbar.
Enable the "all" button.
Configure the state of the entry widget's state to normal, and set foreground
  color to active color.
endif
.fi
.RE
.NH 2
.Fi listbox.tk
.LP
This file contains routines that are related to listbox widgets.
.NH 3
.Fn buildFullListbox()
.Cs
buildFullListbox {frame_name ColxRow header_str scrollbarType
                  {all_button 1} {header_at_left 0} }		
.Ce
.IP Args: 4
.RS
.IP frame_name 18
the name of the frame widget to place the complete listbox.
.IP ColxRow 18
# of columns (characters) and # of rows on the listbox.
.IP  header_str 18
the header string of the listbox.
.IP  scrollbarType 18
specifies the orientation of the listbox's scrollbar. Can only have the
values: xscroll, yscroll, xyscroll, noscroll.
.IP  all_button 18
boolean value (0 or 1) that says to include the "Select All/Deselect All"
buttons.
.IP header_at_left 18
boolean value (0 or 1) that says to have the header to be at the left side
of the listbox instead of at the top.
.RE
.IP Returns 4
list: frame_name, label, all button, listbox widget name, and scrollbars.
.LP
Control Flow:
.RS
.nf
Create listbox header label if header_str is not empty. Make the header
  visible.
Create and make visible the "Select All/Deselect All" button if all_button is
  set. Make sure to orient header according to instructions from header_at_left

Create the listbox widget.
Create scrollbar and associate with listbox.
Make both listbox and scrollbar visible.

return widgets that have been created.
.fi
.RE
.NH 3
.Fn get_keyvals()
.Cs
get_keyvals{lbox key_list inner_sep outer_sep {type "all"}}
.Ce
.IP Args: 4
.RS
.IP lbox 13
name of a listbox to get key values from.
.IP key_list 13
list of field indices to listbox.
.IP inner_sep 13
the string to put within key values of an entry in the resulting string.
.IP outer_sep 13
the string to put between entries of the listbox in the resulting string.
.IP type 13
choice value of either "select" or "all" referring to what type of listbox
entries will be matched for key values.
.RE
.IP Returns 4
a string containing selected field values of entries in listbox. 'inner_sep'
separates field values, while entries are separated by 'outer_sep'.
.LP
Control Flow:
.RS
.nf
Get the listbox indices to extract field values from.
Extract the field values.
Construct the return string by separating field values with 'inner_sep', and
 separating each listbox entry with 'outer_sep'.
Remove any trailing 'outer_sep'.
Return key values string.
.fi
.RE
.NH 3
.Fn strget_keyvals()
.Cs
strget_keyvals{str keylist sep}
.Ce
.IP Args: 4
.RS
.IP str 11
string to extract key values from.
.IP keylist 11
list of field indices to str.
.IP sep 11
the string to put between key values.
.RE
.IP Returns 4
a string containing selected field values of string 'str', separated by 'sep'.
.LP
Control Flow:
.RS
.nf
foreach field in key_list
do
  Extract the field values.
  Construct the return string by separating field values with 'sep'.
done
Return key values string.
.fi
.RE
.NH 2
.Fi spinbox.tk
.LP
This file contains routines supporting the spinbox widget.
.NH 3
.Fn buildSpinbox()
.Cs
buildSpinbox{ frame_name cols list_discrete_values assocVarName
              assocVarElem {label_text ""} {label_placement "right"}
              {default_val ""} {dateFormat 0} }
.Ce
.IP Args: 4
.RS
.IP frame_name 23
name of the frame where the spinbox widget will be placed.
.IP cols 23
number of columns the spinbox entry occupies.
.IP list_discrete_values 23
list of discrete values considered valid by the spinbox entry widget. 
.IP assocVarName 23
associated variable name for the spinbox entry widget.
.IP assocVarElem 23
associated variable element for the spinbox entry widget.
.IP label_text 23
the text string to label the spinbox.
.IP label_placement 23
where to place 'label_text': right, left, top, bottom.  
.IP default_val 23
default value for the spin box entry.
.IP dateFormat 23
boolean value (0 or 1) for declaring entry to be of date type: meaning
numbers from 0 to 9 are to be given a 0 prefix.
.RE
.IP Returns 4
a list: frame_name, spinbox entry widget, spinbox's scrollbar, and label.
.LP
Control Flow:
.RS
.nf
Build a full entry box. Give it a 'default_val' as value. If dateFormat is
  set, then prefix value with a 0 if between 0 and 9.
Make the spinbox entry visible.
Create a scrollbar and associate it with the entry widget.
Create a label for the entry.
Make scrollbar and label both visible, and arranged on the screen according to
instruction of 'label_placement'.

Set 'list_discrete_values' to vlist.<spinbox_entry_name>.
Associate 'assocVarName(assocVarElem)' (or simply assocVarName) as textvariable
  to spinbox entry widget. 
Register entry widget as a spinbox entry.
Return the names of the widgets involved.
.fi
.RE
.NH 3
.Fn spincmd()
.Cs
spincmd{ sbox dateFormat view_idx }
.Ce
.IP Args: 4
.RS
.IP sbox 14
the name of the spinbox entry widget.
.IP dateFormat 14
boolean variable (0 or 1) that says to prefix with a 0 if entry value is
between 0 and 9.
.IP view_idx 14
The index to entry widget to view.
.RE
.LP
Control Flow:
.RS
.nf
Call incr_spinbox if view_idx is -1; otherwise, call decr_spinbox.
.fi
.RE
.NH 3
.Fn disable_spinbox()
.Cs
disable_spinbox {spinEntry spinScroll {spinLabel ""}}
.Ce
.IP Args: 4
.RS
.IP spinEntry 14
the name of the spinbox entry widget to disable.
.IP spinScroll 14
the name of the spinbox scrollbar widget to disable.
.IP spinLabel 14
the name of the spinbox label widget to disable.
.RE
.LP
Control Flow:
.RS
.nf
Disable the spinbox entry widget.
Disable the spinbox scrollbar.
Disable the spinbox label.
.fi
.RE
.NH 3
.Fn enable_spinbox()
.Cs
enable_spinbox {spinEntry spinScroll {spinLabel ""}}
.Ce
.IP Args: 4
.RS
.IP spinEntry 14
the name of the spinbox entry widget to enable.
.IP spinScroll 14
the name of the spinbox scrollbar widget to enable.
.IP spinLabel 14
the name of the spinbox label widget to enable.
.RE
.LP
Control Flow:
.RS
.nf
Enable the spinbox entry widget.
Enable the spinbox scrollbar.
Enable the spinbox label.
.fi
.RE
.NH 3
.Fn incr_spinbox()
.Cs
incr_spinbox {spbox {dateFormat 0} }
.Ce
.IP Args: 4
.RS
.IP spbox 14
name of the spinbox entry widget whose value will be incremented by 1.
.IP dateFormat 14
boolean value (0 or 1) for declaring entry to be of date type: meaning
numbers from 0 to 9 are to be given a 0 prefix.
.RE
.IP Returns 4
new value of the spinbox entry widget.
.LP
Control Flow:
.RS
.nf
Get the list of values considered valid by the entry widget.
Get the current value of the entry widget.
If list of values is a range; then
  if entry value is currently Empty, then
    set the value to the minimum
  else
    set the value to the next number in the range. Don't increment anymore
    when the highest value is reached.
  endif
else
  if entry value is current Empty, then
    set the value to the first item in the list_discrete_values
  else
    set the value  to next item in list_discrete_values. Don't do anything
    if we've run out of elements to access from list_discrete_values.
endif
Return new value of the entry widget.
.fi
.RE
.NH 3
.Fn decr_spinbox()
.Cs
decr_spinbox {spbox {dateFormat 0} }
.Ce
.IP Args: 4
.RS
.IP spbox 14
name of the spinbox entry widget whose value will be decremented by 1.
.IP dateFormat 14
boolean value (0 or 1) for declaring entry to be of date type: meaning
numbers from 0 to 9 are to be given a 0 prefix.
.RE
.IP Returns 4
new value of the spinbox entry widget.
.LP
Control Flow:
.RS
.nf
Get the list of values considered valid by the entry widget.
Get the current value of the entry widget.
If list of values is a range; then
  if entry value is currently Empty, then
    set the value to the maximum
  else
    set the value to the previous number in the range. Don't decrement anymore
    when the lowest value is reached.
  endif
else
  if entry value is current Empty, then
    set the value to the last item in the list_discrete_values
  else
    set the value  to previous item in list_discrete_values. Don't do anything
    if we've run out of elements to access from list_discrete_values.
endif
Return new value of the entry widget.
.fi
.RE
.NH 3
.Fn check_spinbox_value()
.Cs
check_spinbox_value {spin_entry}
.Ce
.IP Args: 4
.RS
.IP spin_entry 14
name of the spinbox entry widget whose value will be checked for validity.
.RE
.LP
Control Flow:
.RS
.nf
If spinbox's value list is a range of numbers, then
  blank out entry if spinbox value is not numeric, or not in the range.
else
  blank out entry of spinbox value does not match any of the values in 
    value list.
endif
.fi
.RE
.NH 2
.Fi text.tk
.LP
This file contains routines supporting the text widget.
.NH 3
.Fn buildFullTextbox()
.Cs
buildFullTextbox{frame_name ColxRow scrollbarType {text_title ""}}
.Ce
.IP Args: 4
.RS
.IP frame_name 17
name of the frame where the textbox will be placed.
.IP ColxRow 17
number of columns and rows of the text widget.
.IP scrollbarType 17
type of scrollbar to associate with the text widget - "yscroll" or "noscroll".
.IP text_title 17
the text string for the label widget.
.RE
.IP Returns 4
a list: frame_name, name of the text widget, and scrollbar.
.LP
Control Flow:
.RS
.nf
Create a user-friendly text widget with the specified dimensions.
Create a label for the text widget if text_title is set.
Make text and label widget visible.
Create and make visible a scrollbar. Associate the scrollbar with the
text widget.
.fi
.RE
.NH 2
.Fi qsub.tk
.LP
This file contains routines supporting the Submit window.
.NH 3
.Fn qsub()
.Cs
qsub{}
.Ce
.LP
Control Flow:
.RS
.nf
Create the submit dialog box.
Mark the Submit window active.
Populate the bottom part of the dialog box with command buttons:
  confirm submit, interactive, cancel, reset options to default, and help.
  Configure "reset options to default" button to set back to default values
    the widgets found in the Submit window only, and invoking as needed the
    StdoutRet, StderrRet, NotifyAbort, NotifyBegin, NotifyEnd, EnvList
    checkboxes, and the StdoutMerge, StderrMerge, and NoMerge radioboxes.
  Configure "interactive" button to run cmdpath(QSUB) with a -I option in the
    background.
  Configure "confirm submit" button to:
    1) pre build the values of qsubv based on current widget values found in
       the Submit window and supporting windows.
    2) if scriptName is set in the FILE entry box,
         run "cmdpath(QSUB) <options> scriptName"
       else
         run "cmdpath(QSUB) <options> << {input taken from contents of the FILE
                                        text box}"
    If command executed successfully; then get jobs Data.
  Configure "cancel" button to destroy the qsub dialog box when clicked.
  Configure "help" button to bring up the help page associated with the Submit
    window.

Populate the top and middle parts of the dialog box with the following
widgets:
  Create all the necessary frames to hold and group related widgets together.
  Create the File text box.
  Create the OPTIONS and OTHER OPTIONS labels.
  Create the OTHER OPTIONS buttons: job dependency, file staging, and misc.
    configure "job dependency" button to bring up the dependency dialog box.
    configure "file staging" button to bring up the staging dialog box.
    configure "misc" button to bring up the miscellaneous dialog box.
  Create the SCRIPT label.
  Create a user-friendly FILE entry box that also recognizes wildcards (*,~)
  Create a user-friendly PBS FILE Prefix entry box.
  Create the FILE "load" and "save" buttons.
    Configure "load" button to:
      (1) set busy cursor
      (2) give an error if FILE entry is empty, or script FILE does not exist,
            or script FILE is not a regular file.
      (3) run "PBS_SCRIPTLOAD_CMD -C <PBS FILE Prefix entry value> <script FILE
            entry value>"
      (4) reset all widget values in the Submit window, dependency, staging,
            and misc dialog boxes.
      (5) load new values to widgets using output obtained from (3). Invoke
          radiobuttons, checkbuttons in the Submit window only as needed. 
      (6) reset Prefix entry value to previous value before (5) was execute. 
      (7) Load the FILE text box with the execution lines (non-PBS lines) of
          the script FILE, which is currently saved in some buffer file.
      (8) Remove the buffer file.
      (9) Remove busy cursor.
    Configure "save" button to:
      (1) set busy cursor
      (2) pre build the values of qsubv based on current widget values found
          in the Submit window and supporting windows.
      (3) Open the file specified in the FILE entry widget. Use this file as
          the destination for PBS option lines (values taken from whatever
          widget is currently set), and execution lines as taken from the
          contents of the FILE text box. PBS directive is taken from the value
          of the Prefix entry box. The format is:
            <PBS option lines>
            <execution lines>
          Also, bring up a confirmation box upon encountering a file  that
	  already exists.
      (4) remove busy cursor.
      (5) Bring up an Info box informing user of successful completion of (3)
          task.
  Create a user-friendly Job Name entry box.
  Create the priority spinbox.
  Create the destination listbox. Make it single-selectable.
    Load the listbox with values from the Queues listbox in the main xpbs
      window. Add a special default entry called "@hostsSelected" at the
      top of the listbox. This is assuming of course that hostsSelect contains
      only 1 entry. Select/highlight  this default entry.
  Build the "When to Queue" radiobuttons: NOW, and LATER at.     
    Configure the "LATER at" button to bring up the dateTime dialog box.
    Configure the "NOW" button to reset the month, day, year, hh, min, and ss
      values to default when clicked.
  Create a user-friendly "Account Name" entry box.
  Create the "Hold Job" checkbutton.
  Create the labels "Notify" and "when".
  Create the "email addrs.." button.
  Create the checkbuttons "job aborts", "job begins execution", and "job
    terminates".
    - configure the checkbuttons in a way that the "email_addrs" button is 
         disabled when "job aborts", "job begins execution", and 
         "job terminates" buttons are currently deselected; otherwise, enable
         "email_addrs" button.
  Create the "Resources List" label.
  Create the help button and associate with it help page on resources. 
  Create the resources=value box.
  Create the "Merge to Stdout", "Merge to Stderr", and "Don't Merge"
    radiobuttons.
  Create the "Stdout in exec_host:" and "Stderr in exec_host:" checkbuttons.
  Build the "Stdout File Name" entry box. Enable regular tabbing, and
    overselect.
  Build the "Stdout File Host Name" entry box. Enable regular tabbing, and
    overselect.
  Build the "Stderr File Name" entry box. Enable regular tabbing, and
    overselect.
  Build the "Stderr File Host Name" entry box. Enable regular tabbing, and
    overselect.

  Configure "Stdout in exec_host:" button to disable "Stdout File/Host Name"
    widgets when invoked. Set focus to "Stderr File Name".
  Configure "Stderr in exec_host:" button to disable "Stderr File/Host Name"
    widgets when invoked. Set focus to "Stdout File Name".
  Configure "Merge to Stdout" button to disable "Stderr File Name/Host Name"
    widgets when invoked, and to enable "Stdout in exec_host:" button. Set
    focus to "Stdout File Name".
  Configure "Merge to Stderr" button to disable "Stdout File Name/Host Name"
    widgets when invoked, and to enable "Stderr in exec_host:" button. Set
    focus to "Stderr File Name".
  Configure "Don't Merge" button to enable "Stdout in exec_host:" and
    "Stderr in exec_host:" buttons, and if no button conflict, the 
    "Stdout File/Host Name" and/or "Stderr File/Host Name".

  Create the "Environment Variables to Export" label.
  Build environment variable=value box.
  Build the checkbuttons "Current" and "Other Variables".
    Configure the "Other Variables" button to enable the environment variable
      entry boxes when the button is set, or disable the entry boxes when the
      button is not set.

  Make all widgets visible.
  Set all widget values to default including those in the job dependency, 
    staging, and misc dialog boxes. Invoke appropriate button widgets as well
    according to loaded values.
  Wait for visibility of the Submit window before removing the busy cursor.
  Wait until the Submit is destroyed.
  Mark the Submit window inactive.
  Free up the storage used up by the global variable qsubv.
.fi
.RE
.NH 3
.Fn pre_build_qsub_opt()
.Cs
pre_build_qsub_opt{}
.Ce
.IP Returns 4
0 if qsubv was successfully built; 1 otherwise.
.LP
Control Flow:
.RS
.nf
Set qsubv(destination) value based on what is currently selected in the
  destination listbox 
Set qsubv(mail_option) based on values of the notify option checkbuttons.
  If none of the checkbuttons is selected, then set qsubv(mail_option) to "n". 
Set qsubv(keep_args) based on what is set in "Stdout in exec_host:" and
  "Stderr in exec_host:" buttons.
Set qsubv(stdoutPath) to whatever non-default setting of the "Stdout File/Host
  Name" widgets.
Set qsubv(stderrPath) to whatever non-default setting of the "Stderr File/Host
  Name" widgets.
Set qsubv(res_args) to complete, non-default values of the resources=value entry
  boxes.
Set qsubv(env_args) to complete, non-default values of the
  environment=value entry boxes.
Call pre_build_depend_opt
Call pre_build_staging_opt
Call pre_build_misc_opt
Call pre_build_email_opt if qsubv(mail_option) is != n; otherwise, 
  call init_qsub_email_argstr
Call pre_build_datetime_opt if qtime setting is not "NOW"; otherwise,
  call init_qsub_datetime_argst
return 0
.fi
.RE
.NH 3
.Fn invoke_qsub_widgets()
.Cs
invoke_qsub_widgets{}
.Ce
.LP
Control Flow:
.RS
.nf
Invoke the checkbuttons: chkboxStdoutRet, chkboxStdoutRet, chkboxNotifyAbort,
chkboxNotifyBegin, chkboxNotifyEnd, chkboxEnvList if set.
Invoke the radiobuttons: radioboxStdoutMerge, radioboxStderrMerge, 
radioboxNoMerge if set.
.fi
.RE
.NH 3
.Fn confirmDelete()
.Cs
confirmDelete{}
.Ce
.LP
Control Flow:
.RS
.nf
Popup the "Save to File" dialog box.
Populate the top part of the dialog box with a message widget asking if user
  wants an existing file to be overwritten.
Populate the bottom part of the dialog box with a Yes, No button.
Bind the <Return> key to invoke the No button. 
Display the top and bottom parts of the dialog box.
.fi
.RE
.NH 3
.Fn serverSelect()
.Cs
serverSelect{}
.Ce
.LP
Control Flow:
.RS
.nf
Popup the "Server Selection" dialog box.
Populate the top part of the dialog box with a message widget, and a listbox
enumerating the list of hosts currently selected.
Populate the bottom part of the dialog box with an Ok button.
Bind the <Return> key to invoke the Ok button. 
Display the top and bottom parts of the dialog box.
.fi
.RE
.NH 2
.Fi qalter.tk
.LP
This file contains routines supporting the Modify window.
.NH 3
.Fn qalter()
.Cs
qalter{}
.Ce
.LP
Control Flow:
.RS
.nf
Create the Modify dialog box.
Mark the Modify window active.
Populate the bottom part of the dialog box with command buttons:
  confirm modify, cancel, reset options to default, and help.
  Configure "reset options to default" button to set back to default values
    the widgets found in the Modify window only, and invoking as needed the
    StdoutRet, StderrRet, NoRet, Notify, NotifyAbort, NotifyBegin, NotifyEnd
    checkboxes, and the StdoutMerge, StderrMerge, NoMerge radioboxes, and
    NoChange.
  Configure "confirm modify" button to:
    1) pre build the values of qalterv based on current widget values found in
       the Modify window and supporting windows:
	 Set qalterv(mail_option) based on values of the notify option
           checkbuttons. If none of the checkbuttons is selected, then set
           qalterv(mail_option) to "n". 
         Set qalterv(hold_args) based on values found on the hold job check
           buttons.
	 Set qalterv(keep_args) based on what is set in "Stdout in exec_host:"
	   and "Stderr in exec_host:" buttons.
	 Set qalterv(stdoutPath) to whatever non-default setting of the
	   "Stdout File/Host Name" widgets.
	 Set qalterv(stderrPath) to whatever non-default setting of the
	   "Stderr File/Host Name" widgets.
	 Set qalterv(res_args) to complete, non-default values of the
	   resources=value entry boxes.
    2) if qalter options specified is Empty, then
         issue a WARNING message.
       else
         run "cmdpath(QALTER) <options> <jobsSelected>
       endif
       If command executed successfully; then get jobs Data.
   (3) destroy  Modify window. 
  Configure "cancel" button to destroy the qalter dialog box when clicked.
  Configure "help" button to bring up the help page associated with the Modify
    window.

Populate the top and middle parts of the dialog box with the following
widgets:
  Create all the necessary frames to hold and group related widgets together.
  Create the OTHER ATTRIBUTES buttons: job dependency, file staging, and misc.
    configure "job dependency" button to bring up the dependency dialog box.
    configure "file staging" button to bring up the staging dialog box.
    configure "misc" button to bring up the miscellaneous dialog box.
  Create the Hold Types widgets: place user, place system, place other check
    buttons, and clear all checkbutton.
  Create the "Modify job(s):" label.
  Build the job id listbox making it non-selectable. The listbox contents 
    are those currently selected/highlighted in the Jobs listbox of the main
    \f3xpbs\fP window.
  Create the "ATTRIBUTES" label. 
  Create a user-friendly Job Name entry box.
  Create the priority spinbox.
  Build the "When to Queue" radiobuttons: NOW, and LATER at.     
    Configure the "LATER at" button to bring up the dateTime dialog box.
    Configure the "NOW" button to reset the mon, day, year, hh, min, ss values
       to default when clicked.
  Create a user-friendly "Account Name" entry box.
  Create the labels "Notify" and "when".
  Create the "email addrs.." button.
  Create the checkbuttons "job aborts", "job begins execution", and "job
    terminates".
    - configure the checkbuttons in a way that the "email_addrs" button is 
         disabled when "job aborts", "job begins execution", and 
         "job terminates" buttons are currently deselected; otherwise, enable
         "email_addrs" button.
  Create the "Resources List" label.
  Create the help button and associate with it help page on resources. 
  Create the resources=value box.
  Create the "Merge to Stdout", "Merge to Stderr", and "Don't Merge",
    "No Change" radiobuttons.
  Create the "Stdout in exec_host:" and "Stderr in exec_host:" checkbuttons.
  Build the "Stdout File Name" entry box. Enable regular tabbing, and
    overselect.
  Build the "Stdout File Host Name" entry box. Enable regular tabbing, and
    overselect.
  Build the "Stderr File Name" entry box. Enable regular tabbing, and
    overselect.
  Build the "Stderr File Host Name" entry box. Enable regular tabbing, and
    overselect.

  Configure "Stdout in exec_host:" button to disable "Stdout File/Host Name"
    widgets when invoked. Set focus to "Stderr File Name".
  Configure "Stderr in exec_host:" button to disable "Stderr File/Host Name"
    widgets when invoked. Set focus to "Stdout File Name".
  Configure "Merge to Stdout" button to disable "Stderr File Name/Host Name"
    widgets when invoked, and to enable "Stdout in exec_host:" button. Set
    focus to "Stdout File Name".
  Configure "Merge to Stderr" button to disable "Stdout File Name/Host Name"
    widgets when invoked, and to enable "Stderr in exec_host:" button. Set
    focus to "Stderr File Name".
  Configure "Don't Merge" and "No Change" buttons to enable 
    "Stdout in exec_host:" and "Stderr in exec_host:" buttons, and if no button
    conflict, the "Stdout File/Host Name" and/or "Stderr File/Host Name".

  Register a default binding of "cancel" to the Modify window.
  Make all widgets visible.
  Set all widget values to default including those in the job dependency, 
    staging, and misc dialog boxes. Invoke appropriate button widgets as well
    according to loaded values.
  Wait for visibility of the Submit window before removing the busy cursor.
  Wait until the Submit is destroyed.
  Mark the Submit window inactive.
  Free up the storage used up by the global variable qalterv.
.fi
.RE
.NH 3
.Fn invoke_qalter_widgets()
.Cs
invoke_qalter_widgets {assoc_array}
.Ce
.IP Args: 4
.RS
.IP assoc_array 15
array holding the values of the qalter widgets.
.RE
.LP
Control Flow:
.RS
.nf
Invoke any of radio buttons: radioboxPlace, radioboxClear, radiobox, 
radioboxStdoutMerge, radioboxStderrMerge, radioboxNoMerge, radioboxNoChange,
rboxRetain, rboxNoRetain if set.
Invoke the chkboxNotify if set.
.fi
.RE
.NH 2
.Fi depend.tk
.LP
This file contains the routines supporting the Job Dependency dialog box.
.NH 3
.Fn depend()
.Cs
depend{callerDialogBox {qalter 0} }
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 19
the name of the dialog box that called this routine.
.IP qalter 19
boolean value (0 or 1) that says to build options under the context of
qalter instead of qsub.
.RE
.LP
Control Flow:
.RS
.nf
If Submit window called this dialog box,
  set the global input array to "qsubv"
  set the default array to "def_qsub"
else
  set the global input array to "qalterv"
  set default array to "def_qalter"
endif
Set busy cursor.
Create the dependency dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, reset options to default, and help.
Configure the  ok button to call "pre_build_depend_opt" and destroy the
  depend Dialog box  when clicked.
Configure the  "reset options to default" button to set widget values to
  default values, and invoke appropriate widgets.
Configure the  help button to bring up help page relating to job dependency.
Create the necessary frames to hold/group widgets.
Create the labels for "Concurrency Set", "Schedule THIS job after:", 
  "THIS job must have:", and "THIS job is dependent on". 
Create the "on other job(s)" spinbox.
Create the "synccount" spinbox.
Create the "sync with job(s)" entry box.
Create the radio buttons invoking the "synccount" spinbox and 
  "sync with job(s)" entry as well as a "no concurrency" button.
  Configure the radiobutton invoking "synccount" spinbox so that it enables the
    spinbox and it disables the "sync with job(s)" entry box. Set focus on
    spinbox entry.
  Configure the radiobutton invoking "sync with job(s)" entry so that it
    enables the entry and it disables the "synccount" spinbox.
  Configure the "no concurrency" radio button so that it disables the 
   "sync with job(s)" entry and "synccount" spinbox.  
  Invoke whichever radiobutton was set.
Create the widgets for after, afterok,
  afternotok, afterany. Associate each one with a checkbutton. Configure each
  checkbutton so that it enables the appropriate box. Finally, toggle/invoke
  the set checkbutton.
Create the widgets for before, beforeok,
  beforenotok, beforeany. Associate each one with a checkbutton. Configure each
  checkbutton so that it enables the appropriate widget. Finally, toggle/invoke
  the set checkbutton.
Register "ok" as the default <Return> key action.
Make all the widgets visible.
Wait for the visibility of the depend dialog box before removing the busy
  cursor.
Wait for the dependency dialog box to disappear before marking the window
  inactive.
set input focus back to the calling dialog box.
set grab back to the calling dialog box.
.fi
.RE
.NH 3
.Fn pre_build_depend_opt()
.Cs
pre_build_depend_opt {array def_array}
.Ce
.IP Args: 4
.RS
.IP array 11
array to add elements to corresponding to widget values suitable for processing
by qsub and qalter.
.IP def_array 11
array holding default values for the Dependency widgets.
.RE
.LP
Control Flow:
.RS
.nf
Initialize the depend argument string.
Set array(depend) value based on values found in the dependency widgets.
.fi
.RE
.NH 3
.Fn invoke_depend_widgets()
.Cs
invoke_depend_widgets {assoc_array}
.Ce
.IP Args: 4
.RS
.IP assoc_array 15
array holding the values of the depend widgets.
.RE
.LP
Control Flow:
.RS
.nf
Invoke any of radio buttons: radioboxSyncNone, radioboxSynccount, 
and radioboxSyncwith if set.
Invoke the check buttons: chkboxAfter, chkboxAfterok, chkboxAfternotok,
chkboxAfterany, chkboxBefore, chkboxBeforeok, chkboxBeforenotok, 
chkboxBeforeany if set.
.fi
.RE
.NH 2
.Fi staging.tk
.LP
This file contains routines supporting the File Staging dialog box.
.NH 3
.Fn staging()
.Cs
staging {callerDialogBox {qalter 0}}
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 19
name of the dialog box that called this routine.
.IP qalter 19
boolean value (0 or 1) that says to build options under the context of
qalter instead of qsub.
.RE
.LP
Control Flow:
.RS
.nf
If Submit window called this dialog box,
  set the global input array to "qsubv"
else
  set the global input array to "qalterv"
endif
set busy cursor
Create the File Staging dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, reset options to default, and help.
Configure the  ok button to call "pre_build_staging_opt" and destroy the
  staging Dialog box  when clicked.
Configure the  "reset options to default" button to set widget values to
  default values.
Configure the  help button to bring up help page relating to file staging.
Create the necessary frames to hold/group widgets.
Create the Stagein box.
Create the Stageout box.
Make all widgets visible.
Register the "ok" action as default <Return>key binding.
Wait for the visibility of the staging dialog box before removing busy cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
set input focus back to the calling dialog box.
set grab back to the calling dialog box.
.fi
.RE
.NH 3
.Fn check_staging_input()
.Cs
check_staging_input {host file}
.Ce
.IP Args: 4
.RS
.IP host 11
in a stagein/stageout directive, this is the hostname part.
.IP file 11
in a stagein/stageout directive, this is the filename part.
.RE
.LP
Control Flow:
.RS
.nf
Get the directory name for file, access the host, and check for the
existence of the directory holding the file. If dir does not exist, return -1.
Either use the RSH utility if file resides remotely, or the internal "file"
utilities within TCL if file resides locally.
.fi
.RE
.NH 3
.Fn pre_build_staging_opt()
.Cs
pre_build_staging_opt {array def_idx}
.Ce
.IP Args: 4
.RS
.IP array 11
array to add elements to which corresponds to widget values suitable for
processing by qsub and qalter.
.IP def_idx 11
default value index to the \f3default\fP array.
.RE
.LP
Control Flow:
.RS
.nf
Initialize argument strings associated with file staging.
Set array(stagein_filelist) value based on values found in the stagein widgets.
Set array(stageout_filelist) value based on values found in the stagout widgets.
.fi
.RE
.NH 2
.Fi misc.tk
.LP
This file contains routines that support the Miscellaneous dialog box.
.NH 3
.Fn misc()
.Cs
misc {callerDialogBox {qalter 0}}
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 19
name of the dialog box that called this routine.
.IP qalter 19
boolean value (0 or 1) that says to build options under the context of
qalter instead of qsub.
.RE
.LP
Control Flow:
.RS
.nf
If Submit window called this dialog box,
  set the global input array to "qsubv"
  set default array to "def_qsub"
else
  set the global input array to "qalterv"
  set default array to "def_qalter"
endif
set busy cursor
Create the File Staging dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, reset options to default, and help.
Configure the  ok button to call "pre_build_misc_opt" and destroy the
  Miscellaneous Dialog box  when clicked.
Configure the "reset options to default" button to set widget values to
  default values Invoke appropriate button widgets according to new values
  loaded.
Configure the  help button to bring up help page relating to miscellaneous
  other PBS options.
Create the necessary frames to hold/group widgets.
Create the checkpoint interval minute spinbox.
Create the radiobutton invoking the checkpoint interval spinbox, as well as
  buttons for "when host shuts down", "at host's default minimum time, and
  "do not checkpoint" attributes. 
  - Configure the button invoking checkpoint interval spinbox so that it
    enables the associated spinbox. 
  - Configure the "when host shuts down", "at host's default min time", and
   "do not checkpoint"  buttons so that they disable the checkpoint interval
    spinbox.
Create the main checkbutton invoking widgets for specifying checkpoint
  attributes.
  - Configure the checkbutton so that if it is set, then enable all the 
    checkpoint widgets; otherwise, leave the widgets disabled.
Create the "rerunnable" and "not rerunnable" radiobuttons. 
Create the checkbutton invoking the radiobuttons for specifying the rerunnable
  attribute of a job.
  - Configure the checkbutton so that if it is set, then enable all the 
   rerunnable widgets; otherwise, leave the widgets disabled.
Create the Shell path box.
Create the Group list box.
Create the User list box.
Make all widgets visible.
Register the "ok" action as default <Return>key binding.
Wait for the visibility of the staging dialog box before removing busy cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
Set input focus back to the calling dialog box.
Grab back the calling dialog box.
.fi
.RE
.NH 3
.Fn pre_build_misc_opt()
.Cs
pre_build_misc_opt {array def_array}
.Ce
.IP Args: 4
.RS
.IP array 12
array to add elements to which corresponds to widget values suitable for
processing by qsub and qalter.
.IP def_array 12
array holding default values associated with misc widgets.
.RE
.LP
Control Flow:
.RS
.nf
Initialized the misc argument strings.
set array(checkpoint_arg) based on values found in checkpoint widgets.
set array(shell_args) based on values found in Shell path box.
set array(user_args) based on values found in User List box.
set array(group_args) based on values found in Group List box.
.fi
.RE
.NH 3
.Fn invoke_misc_widgets()
.Cs
invoke_misc_widgets {assoc_array}
.Ce
.IP Args: 4
.RS
.IP assoc_array 15
array holding the values of the misc widgets.
.RE
.LP
Control Flow:
.RS
.nf
Invoke any of radio buttons: radioboxManual, radioboxAuto, radioboxDefault,
and radioboxNoChkpnt if set.
Invoke the check buttons: chkboxChkpnt and chkboxMark if set.
.fi
.RE
.NH 2
.Fi email_list.tk
.LP
This file contains routines that support the Email Addresses dialog box.
.NH 3
.Fn email_list()
.Cs
email_list {callerDialogBox {qalter 0}}
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 19
name of the dialog box that called this routine.
.IP qalter 19
boolean value (0 or 1) that says to build options under the context of
qalter instead of qsub.
.RE
.LP
Control Flow:
.RS
.nf
If Submit window called this dialog box,
  set the global input array to "qsubv"
else
  set the global input array to "qalterv"
endif
set busy cursor
Create the Email Addresses dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, reset options to default, and help.
Configure the ok button to call "pre_build_email_opt" and destroy the
  Email Addresses Dialog box when clicked.
Configure the "reset options to default" button to set widget values to
  default values. Invoke appropriate button widgets according to new values
  loaded.
Configure the  help button to bring up help page relating to email addresses.
Create the necessary frames to hold/group widgets.
Create the \f3numMisc\fP entry boxes for the Email addresses box.
Make all widgets visible.
Register the "ok" action as default <Return>key binding.
Wait for the visibility of the email addresses dialog box before removing busy
cursor. 
 Wait for window to be destroyed before marking the dialog box as
inactive.
Set input focus back to the calling dialog box.
set a grab back to the calling dialog box.
.fi
.RE
.NH 3
.Fn pre_build_email_opt()
.Cs
pre_build_email_opt {array}
.Ce
.IP Args: 4
.RS
.IP array 11
array to add elements to corresponding to widget values suitable for processing
by qsub and qalter.
.RE
.LP
Control Flow:
.RS
.nf
set array(email_args) based on values found in Email Addresses box.
.fi
.RE
.NH 2
.Fi datetime.tk
.LP
Initialize email addresses argument string.
This file contains routines that support the Date/Time dialog box.
.NH 3
.Fn dateTime()
.Cs
dateTime {callerDialogBox {qalter 0}}
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 19
name of the dialog box that called this routine.
.IP qalter 19
boolean value (0 or 1) that says to build options under the context of
qalter instead of qsub.
.RE
.LP
Control Flow:
.RS
.nf
If Submit window called this dialog box,
  set the global input array to "qsubv"
else
  set the global input array to "qalterv"
endif
If current values for mon, day, year, hour, minutes, and seconds is set to
  default, then set date/time to current.
set busy cursor
Create the Date/Time dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to check validy of entered date/time value,
  call "pre_build_datetime_opt", and destroy the
  Date/Time Dialog box when clicked.
Configure the  help button to bring up help page relating to date/time.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the date/time spinbox widgets.
Make all widgets visible.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the date/time dialog box before removing busy cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
Set input focus back to the calling dialog box.
.fi
.RE
.NH 3
.Fn pre_build_datetime_opt()
.Cs
pre_build_datetime_opt {array}
.Ce
.IP Args: 4
.RS
.IP array 11
array to add elements to corresponding to widget values suitable for processing
by qsub and qalter.
.RE
.LP
Control Flow:
.RS
.nf
initialize the date/time argument string.
set array(exec_time) based on values found in date/time widgets.
.fi
.RE
.NH 2
.Fi qterm.tk
.LP
This file contains routines that support the Terminate Server dialog box.
.NH 3
.Fn qterm()
.Cs
qterm{} 
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Terminate Server dialog box.
Mark the window as active.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the "Terminate server(s):" label.
Create the servername(s) listbox and make it read-only. Insert the values found
  highlighted/selected in the Hosts listbox of the main \f3xpbs\fP window.
Create the type of shutdown radiobuttons - "immediate" and "delay".
Set the default shutdown type.
Make all widgets visible.
Populate the bottom part of the dialog box with the following buttons:
  terminate, cancel, and help.
Configure the terminate button to run:
  "cmdpath(QTERM) -t <shutdown_type> <hostsSelected>"
  If command execution was a success, then get new data for servers, queues, and
    jobs, and destroy the  Terminate Server dialog box.
Configure the "cancel" button so that it destroys the Terminate Server dialog
  box when clicked.
Configure the  help button to bring up help page relating to qterm.
Register the "cancel" action as default <Return> key binding.
Wait for the visibility of the Terminate Server dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi qdel.tk
.LP
This file contains routines that support the Delete Job dialog box.
.NH 3
.Fn qdel()
.Cs
qdel{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Delete dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  delete, cancel, and help.
Configure the delete button to run:
  "cmdpath(QTERM) -W <delay_secs> <jobsSelected>"
  If command execution was a success, then get new data for jobs only, and
    destroy the Delete dialog box.
Configure the "cancel" button so that it destroys the Delete dialog
  box when clicked.
Configure the  help button to bring up help page relating to qdel.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the "Delete job(s)" label.
Create the jobid(s) listbox and make it read-only. Insert the values found
  highlighted/selected in the Jobs listbox of the main \f3xpbs\fP window.  
Create the "For running job(s), send kill signal after" label.
Create the delay_signal spinbox.
Set the default delay_signal.
Register the "cancel" action as default <Return> key binding.
Make all widgets visible.
Wait for the visibility of the Delete Job dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
Free up the storage occupied by qdelv.
.fi
.RE
.NH 2
.Fi qhold.tk
.LP
This file contains routines that support the Hold Job dialog box.
.NH 3
.Fn qhold()
.Cs
qhold{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Hold Job dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  hold, cancel, and help.
Configure the hold button to run:
  "cmdpath(QHOLD) -h <not_default_hold_types_string> <jobsSelected>"
  If command execution was a success, then get new data for jobs only, and
    destroy the Hold Job dialog box.
Configure the "cancel" button so that it destroys the Hold Job dialog
  box when clicked.
Configure the  help button to bring up help page relating to qhold.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the jobid(s) listbox and make it read-only. Insert the values found
  highlighted/selected in the Jobs listbox of the main \f3xpbs\fP window.  
Create the hold types checkbuttons - user, other, and system.
Set the default checkbuttons' values.
Make all widgets visible.
Register the "cancel" action as default <Return> key binding.
Wait for the visibility of the HOld Job dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
Free up the storage occupied by qholdv.
.fi
.RE
.NH 2
.Fi qrls.tk
.LP
This file contains routines that support the Release Job dialog box.
.NH 3
.Fn qrls()
.Cs
qrls{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Release Job dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  release, cancel, and help.
Configure the release button to run:
  "cmdpath(QRLS) -h <not_default_hold_types_string> <jobsSelected>"
  If command execution was a success, then get new data for jobs only, and
    destroy the Release Job dialog box.
Configure the "cancel" button so that it destroys the Release Job dialog
  box when clicked.
Configure the  help button to bring up help page relating to qrls.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the jobid(s) listbox and make it read-only. Insert the values found
  highlighted/selected in the Jobs listbox of the main \f3xpbs\fP window.  
Create the hold types checkbuttons - user, other, and system.
Set the default checkbuttons' values.
Make all widgets visible.
Register the "cancel" action as default <Return> key binding.
Wait for the visibility of the Release Job dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
Free up the storage occupied by qrlsv.
.fi
.RE
.NH 2
.Fi qsig.tk
.LP
This file contains routines that support the Signal Job dialog box.
.NH 3
.Fn qsig()
.Cs
qsig{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Signal Job dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  signal, cancel, and help.
Configure the signal button to run:
  "cmdpath(QSIG) -s <not_default_signal_name> <jobsSelected>"
  If command execution was a success, then get new data for jobs only, and
    destroy the Signal Job dialog box.
Configure the "cancel" button so that it destroys the Signal Job dialog
  box when clicked.
Configure the  help button to bring up help page relating to qsig.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the "to RUNNING job(s):" label.
Create the jobid(s) listbox and make it read-only. Insert the values found
  highlighted/selected in the Jobs listbox of the main \f3xpbs\fP window.  
Create the "other signal" entry widget.
Create the radio buttons HUP, INT, KILL, TERM, and OTHER with the last one
  invoking the "other signal" entry widget.
  - Configure all the radiobuttons (except OTHER) to disable the "other entry"
      widget when the buttons are invoked.
Set the default radiobuttons' value. Based on the default values, invoke the
  appropriate radiobutton.
Make all widgets visible.
Register the "cancel" action as default <Return> key binding.
Wait for the visibility of the Signal Job dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
Free up the storage occupied by qsigv.
.fi
.RE
.NH 2
.Fi qmsg.tk
.LP
This file contains routines that support the Send Message to Running Job
  dialog box.
.NH 3
.Fn qmsg()
.Cs
qmsg{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Send Message dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  Send Message, cancel, and help.
Configure the Send Message button to run:
  "cmdpath(QMSG) <Eflag> <Oflag> <message> <jobsSelected>"
  If command execution was a success, then get new data for jobs only, and
    destroy the Send Message dialog box.
Configure the "cancel" button so that it destroys the Send Message dialog
  box when clicked.
Configure the  help button to bring up help page relating to qmsg.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the jobid(s) listbox and make it read-only. Insert the values found
  highlighted/selected in the Jobs listbox of the main \f3xpbs\fP window.  
Create the message entry box.
Create the checkbuttons Stdout, and Stderr.
Set the default values for the checkbuttons.
Create the "to" and "of RUNNING job(s)" labels.
Make all widgets visible.
Register the "cancel" action as default <Return> key binding.
Wait for the visibility of the Send Message dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
Free up the storage occupied by qmsgv.
.fi
.RE
.NH 2
.Fi qmove.tk
.LP
This file contains routines that support the Move Job dialog box.
.NH 3
.Fn qmove()
.Cs
qmove{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Move Job dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  move, cancel, and help.
Configure the move button to run:
  "cmdpath(QMOVE) <queue_selected> <jobsSelected>"
  If command execution was a success, then get new data for jobs only, and
    destroy the Move Job dialog box.
Configure the "cancel" button so that it destroys the Move Job dialog
  box when clicked.
Configure the  help button to bring up help page relating to qmove.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the jobid(s) listbox and make it read-only. Insert the values found
  highlighted/selected in the Jobs listbox of the main \f3xpbs\fP window.  
Create the destination listbox. and make it single-selectable. Load it with
  the current values in the  in the queuesListbox of the main
  \f3xpbs\fP window. Select/highlight the firs entry.
Create the "to queue (select one):" and "Move job(s):" labels.
Make all widgets visible.
Register the "cancel" action as default <Return> key binding.
Wait for the visibility of the Move Job dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
Free up the storage occupied by qmove.
.fi
.RE
.NH 2
.Fi owners.tk
.LP
This file contains routines that support the Select Owners dialog box.
.NH 3
.Fn owners()
.Cs
owners{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Owners dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select owners_list argument after
  checking for completeness of user@hostname arguments. Also, destroy the
  Select Owners dialog box after argument has been successfully created.
Configure the  help button to bring up help page relating to owners selection.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the user@hostname box.
Create the radiobuttons for invoking the user@hostname box, and for 
  invoking the wildcard "ANY" owners input. Configure the former button to
  enable the box when invoked, and configure the latter to disable the
  box when invoked.  
Make all widgets visible.
Set default values for the various widgets.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the Select Owners dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi state.tk
.LP
This file contains routines that support the Select Job States dialog box.
.NH 3
.Fn state()
.Cs
state{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Job States dialog box.
Mark the window as active.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the checkbuttons corresponding to state selection: R, Q, W, H, E, T.
Make all widgets visible.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select states argument after
  checking for presence of states value. Also, destroy the
  Select Job States dialog box after argument has been successfully created.
Configure the  help button to bring up help page relating to states selection.
Set default values for the various widgets.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the Select States dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi jobname.tk
.LP
This file contains routines that support the Select Job Name dialog box.
.NH 3
.Fn jobname()
.Cs
jobname{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Job Name dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select jobname argument after
  checking for presence of jobname argument. Also, destroy the
  Select Job Name dialog box after argument has been successfully created.
Configure the  help button to bring up help page relating to job name selection.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create job name entry box.
Create the radiobuttons for invoking the job name entry box, and for 
  invoking the wildcard "ANY" job name input. Configure the former button to
  enable the entry when invoked, and configure the latter to disable the
  entry when invoked.  
Make all widgets visible.
Set default values for the various widgets.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the Select Job Name dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi hold.tk
.LP
This file contains routines that support the Select Hold Types dialog box.
.NH 3
.Fn hold()
.Cs
hold{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Hold Types dialog box.
Mark the window as active.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the checkbuttons corresponding to hold types: user, other, system. 
Create the radiobuttons for invoking the checkbuttons, and for 
  invoking the wildcard "ANY" hold types input. Configure the former button to
  enable the checkbuttons when invoked, and configure the latter to disable the
  checkbuttons when invoked.
Set default values for the various widgets.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select hold types argument. If no hold
  types checkbutton is selected, then set the argument to "n". Destroy the
  Select Hold Types dialog box after argument has been successfully created.
Configure the  help button to bring up help page relating to hold types
  selection.
Register the "ok" action as default <Return> key binding.
Make all widgets visible.
Wait for the visibility of the Select Hold Types dialog box before removing busy
  cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi acctname.tk
.LP
This file contains routines that support the Select Account Name dialog box.
.NH 3
.Fn acctname()
.Cs
acctname{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Account Name dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select jobname argument after
  checking for presence of account name argument. Also, destroy the
  Select Job Name dialog box after argument has been successfully created.
Configure the  help button to bring up help page relating to account name
  selection.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create account name entry box.
Create the radiobuttons for invoking the account name entry box, and for 
  invoking the wildcard "ANY" account name input. Configure the former button
  to enable the entry when invoked, and configure the latter to disable the
  entry when invoked.  
Make all widgets visible.
Set default values for the various widgets.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the Select Account Name dialog box before removing
busy cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi checkpoint.tk
.LP
This file contains routines that support the Select Checkpoint Attribute dialog
box.
.NH 3
.Fn checkpoint()
.Cs
checkpoint{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Checkpoint Attribute dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select checkpoint argument after
  checking for presence of an operator argument. Also, destroy the
  Select Checkpoint Attribute dialog box after argument has been successfully
  created.
Configure the  help button to bring up help page relating to checkpoint
  attribute selection.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create operator spin box.
Create the checkpoint interval spin box. 
Create the radiobuttons for invoking the checkpoint interval spinbox, and for 
  invoking "n", "s", "c", "u", and the wildcard "ANY" checkpoint attribute.
  Configure the former button to enable the checkpoint interval spinbox when
    invoked, and to consider as valid operators: =, !=, >=, >, <=, <.
  Configure the "n", "s", "c" buttons to disable the checkpoint interval
     spinbox, and to consider as valid operators: =, !=, >=, >, <=, <.
  Configure the "u" button to disable the checkpoint interval spinbox, and to
     consider as valid operators: !=, =. Load the operator spinbox with the
     default "=" value if current value is either "!=" or "=". 
  Configure the "ANY" button to disable the checkpoint interval spinbox, and to
     consider as valid operators: =. Load the operator spinbox with the
     default "=" value. 
Set default values for the various widgets.
Make all widgets visible.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the Select Checkpoint attribute dialog box before
  removing busy cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi qtime.tk
.LP
This file contains routines that support the Select Queue Time dialog
box.
.NH 3
.Fn qtime()
.Cs
qtime{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Queue Time dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select date/time argument after
  checking for completeness and validity of the date/time argument. Also,
  destroy the Select Queue Time dialog box after argument has been successfully
  created.
Configure the  help button to bring up help page relating to queue time
  selection.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create operator spin box. Give it values: =, !=, >=, >, <=, <.
Create the date/time spin boxes. 
Create the radiobuttons for invoking the date/time spinboxes, and for 
  invoking the wildcard "ANY" date/time spinbox.
  Configure the former button to enable the date/time spinboxes when
    invoked, and to consider as valid operators: =, !=, >=, >, <=, <.
  Configure the "ANY" button to disable the date/time spinboxes, and to
     consider as valid operators: =. Load the operator spinbox with the
     default "=" value.
Create the label "Queue Time".
Make all widgets visible.
Set default values for the various widgets.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the Select Execution Time attribute dialog box before
  removing busy cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi res.tk
.LP
This file contains routines that support the Select Resource Attributes  dialog
box.
.NH 3
.Fn res()
.Cs
res{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Resource Attributes dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select resource attributes argument after
  checking for completeness of a resources and operator argument. Also, destroy
  the Select Resources dialog box after argument has been successfully
  created.
Configure the help button to bring up help page relating to resource attributes
  selection.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the res<op>val box.
Create the radiobuttons for invoking the box, and for 
  invoking the wildcard "ANY" resource attributes input.
  Configure the former button to enable the box when
    invoked, and configure the "ANY" button to disable the box.
Create the label "Resource Attribute".
Make all widgets visible.
Set default values for the various widgets.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the Select Resources attribute dialog box before
  removing busy cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi priority.tk
.LP
This file contains routines that support the Select Priority Criteria dialog
box.
.NH 3
.Fn priority()
.Cs
priority{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Priority dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select priority argument after
  checking for presence of priority entry value eand operator argument. Also,
  destroy the Select Priority dialog box after argument has been successfully
  created.
Configure the help button to bring up help page relating to priority attribute 
  selection.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the operator spin box.
Create the priority spinbox. Load as valid values: -1024 to 1023.
Create the radiobuttons for invoking the priority spinbox, and for 
  invoking the wildcard "ANY" priority input.
  Configure the former button to enable the priority spinbox when
    invoked and to consider as valid operator spinbox values: =, !=, >=, >,
    <=, <, and configure the "ANY" button to disable the priority spinbox and
    to consider as valid operator spinbox values: =.
Create the label "Priority".
Make all widgets visible.
Set default values for the various widgets.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the Select Priority attribute dialog box before
  removing busy cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi rerun.tk
.LP
This file contains routines that support the Select Rerun Attribute dialog
box.
.NH 3
.Fn rerun()
.Cs
rerun{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Select Rerun attribute dialog box.
Mark the window as active.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the radiobuttons: y, n, ANY.
Populate the bottom part of the dialog box with the following buttons:
  ok, and help.
Configure the ok button to create the select rerun attribute argument. Destroy
  the Select Rerun dialog box after argument has been successfully created.
Configure the help button to bring up help page relating to rerun attribute 
  selection.
Create the label "Rerunnable".
Make all widgets visible.
Set default values for the various widgets.
Register the "ok" action as default <Return> key binding.
Wait for the visibility of the Select Rerunnable attribute dialog box before
  removing busy cursor.
Wait for window to be destroyed before marking the dialog box as inactive.
.fi
.RE
.NH 2
.Fi trackjob.tk
.LP
This file contains routines that support the Track Job feature.
.NH 3
.Fn trackjob()
.Cs
trackjob{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Track Job dialog box.
Mark the window as active.
Populate the bottom part of the dialog box with the following buttons:
  start/reset tracking, stop, close window, and help.
Configure the start/reset tracking button to:
  call trackjob_rstart TCL procedure
Configure the stop tracking button to:
  - simply increment the TRACKJOB_UPDATE_SEQ causing any previous tracking to
    quit on its next polling activity.
  - change the background color of the trackjob button back to normal color. 
  - inform user via an Info box that the job tracking was stopped.
Configure the close window button to simply destroy the Track Job dialog box
  when the button is clicked. 
Configure the help button to bring up help page relating to track job feature.
Populate the top and middle parts of the dialog box  with the following widgets:
Create the necessary frames to hold/group widgets.
Create the message widget containing the label "Periodically check for 
  completion of jobs for user(s):".
Create the username box. 
Create the trackjob interval spinbox. Load 1-9999 as valid values.
Create the radiobuttons for invoking the RSH entry widget, as well as for
  telling xpbs that the output files are "local".
Set the default value for the radio buttons.
Create the "Jobs Found Completed" listbox. Make it single-selectable, and
  register it as a special trackjob listbox.
If trackjob_output contains entries, then
  load those entries into the listbox
endif
Make widgets visible.
Wait for visibility of the Track Job dialog box before removing busy cursor.
Register the "close window" action as default <Return> key binding.
Wait for window to be destroyed before marking the dialog box as inactive.
compress the username box array.
.fi
.RE
.NH 3
.Fn trackjob_auto_update()
.Cs
trackjob_auto_update{update_seq}
.Ce
.IP Args: 4
.RS
.IP update_seq 14
some tracking sequence number
.RE
.LP
Control Flow:
.RS
.nf
if <tracking sequence number> does not match <active sequence number> ; then
  quit out of this routine 
endif
call trackjob_auto_update_seq again after \f3trackjob_mins\fP of time.
Check for returned output files (call trackjob_check).
.fi
.RE
.NH 3
.Fn trackjob_rstart()
.Cs
trackjob_rstart{}
.Ce
.LP
Control Flow:
.RS
.nf
Check to make sure we have a valid \f3trackjob_mins\fP value
run "PBS_QSTATDUMP_CMD -T -u <user_name(s)>" and dump output to trackjob_array.
  NOTE: trackjob_array will contain one entry for each jobid found, and the
        entries list the job owner, output file and error file names.

if <tracking sequence number> does not match <active sequence number> ; then
  quit out of this routine 
endif
call trackjob_auto_update_seq again after \f3trackjob_mins\fP of time.
Check for returned output files (call trackjob_check).
Delete all entries from the trackjob listbox.
Change the color of the trackjob button to normal color.
Free up the storage used by trackjob_output.
.fi
.RE
.NH 3
.Fn trackjob_check()
.Cs
trackjob_check{}
.Ce
.LP
Control Flow:
.RS
.nf
if trackjob_array does not exit; then
  skip the rest of this routine
endif
if the Track Job dialog box exists, then
  delete all entries from the trackjob listbox
endif
Free up storage used by trackjob_output.
Send message to InfoBox that says we're looking for returned output files.
Foreach job in trackjob_array
do
  get the output file/path name of the job
  get the error file/path name of the job

  if files are local, then
    check for the existence of at least ONE of them.
    if the trackjob dialog box exists, then
      add the jobid to the trackjob listbox
    endif
    Also dd the jobid to the trackjob_output buffer array
  else
    check for existence of at least ONE of the files by running:
       "trackjob_rsh_command <outputfile/errorfile> test -f <file> && echo 1" 
    if the trackjob dialog box exists, then
      add the jobid to the trackjob listbox
    endif
    Also add the jobid to the trackjob_output buffer array
  endif
done
Set the color of the trackjob button to signalColor if the trackjob_output
  buffer array contains at least one entry.
Send "done" message to InfoBox.
.fi
.RE
.NH 3
.Fn trackjob_show()
.Cs
trackjob_show{jobid}
.Ce
.IP Args: 4
.RS
.IP jobid 8
The jobid whose output file and error file will be shown.
.RE
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Job Output Dialog Box.
Mark the window active.
Get the output path/file name for jobid.
Get the error path/file name for jobid.
Create the necessary frames to hold/group widgets.
Create the output path label message panel.
Create the error path label message panel.
Create the output contents text box. Make it read-only. Associate a scrollbar.
Create the error contents text box. Make it read-only. Associate a scrollbar.
At the bottom of the dialog box, create an "ok" button. Configure this button
  so that when clicked, it destroys the show Dialog box.
Load the text boxes with values:
  for local files, insert contents of output file into output textbox, and
    error file into error textbox using open/read.
  for remote files, insert contents of output file into output textbox, and
    error file into error textbox using "trackjob_rsh_command <host> cat <file>"
Register "ok" as the default action for <Return> key.
Make all widgets visible.
Wait for the visibility of the Job Output dialog box before removing busy
  cursor.
Wait for the dialog box to be destroyed before marking it inactive.
Send "done" message to InfoBox.
.fi
.RE
.NH 2
.Fi auto_upd.tk
.LP
This file contains routines supporting the data auto updating feature in
xpbs.
.NH 3
.Fn auto_upd()
.Cs
auto_upd{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Auto Update Dialog Box.
Mark the window active.
At the bottom of the dialog box, create the buttons: start updating,
  stop updating, close window, and help.
Configure "start updating" button so that it gets a new DATA_UPDATE_SEQ (a
  new active sequence), execute in \f3auto_update_mins\fP the TCL procedure
  data_auto_update, and inform user via a Help box that auto updating will
  start in \f3auto_update_mins\fP.
Configure the "stop updating" button so that it gets a new DATA_UPDATE_SEQ
  without running a data update.
Configure the "close window" button to simply destroy the Auto Update Dialog  
  box when button is clicked.
Configure the "help" button to bring up a help page on auto updating of data.
Create the necessary frames to hold/group widgets.
Create the "mins" label.
Create the auto_update_mins spinbox. Give it values between 1-9999.
Register "cancel" as the default action for <Return> key presses.
Wait for the visiblity of the Auto Update dialog box before removing busy
  cursor.
Wait for the dialog box to be destroyed before marking it inactive.
.fi
.RE
.NH 2
.Fi pref.tk
.LP
This file contains routines supporting the Preferences dialog box.
.NH 3
.Fn pref()
.Cs
pref{}
.Ce
.LP
Control Flow:
.RS
.nf
set busy cursor
Create the Preferences Dialog Box.
Mark the window active.
Create the necessary frames to hold/group widgets.
Create the server hosts entry box.
At the bottom of the dialog box, create the buttons: ok, help.
Configure "ok" button so that it  destroys the Preferences dialog box.
onfigure the "help" button to bring up a help page on user preferences.
Register "ok" as the default action for <Return> key presses.
Wait for the visiblity of the Preferences dialog box before removing busy
  cursor.
Wait for the dialog box to be destroyed before marking it inactive.
.fi
.RE
.NH 2
.Fi prefsave.tk
.LP
This file contains routines supporting the Preferences Save confirmation
dialog box.
.NH 3
.Fn prefsave()
.Cs
prefsave{}
.Ce
.LP
Control Flow:
.RS
.nf
Create the Save Preference Settings Dialog Box.
Create the message frame.
At the bottom of the dialog box, create the buttons: yes, no.
Configure "yes" button so that it calls the PrefSave function and then
destroys the Preferences Save dialog box.
Configure "no" button to simply destroy the PrefSave dialog box. 
Register "yes" button as the default action for <Return> key presses.
.fi
.RE
.NH 2
.Fi preferences.tcl
.LP
This file contains routines supporting the setting of user preferences.
.NH 3
.Fn Pref_Init()
.Cs
Pref_Init{ userDefaults appDefaults }
.Ce
.IP Args: 4
.RS
.IP userDefaults 16
name of the user preferences file.
.IP appDefaults 16
name of the application preferences file.
.RE
.LP
Control Flow:
.RS
.nf
PrefReadFile the application preferences file.
If the user preferences file exists, then PrefReadFile that too.
.fi
.RE
.NH 3
.Fn PrefReadFile()
.Cs
PrefReadFile{basename level}
.Ce
.IP Args: 4
.RS
.IP basename 12
name of a preferences file
.IP level 12
priority level of the resources defined in the file.
.RE
.LP
Control Flow:
.RS
.nf
Read/load the resources in the <basename> preferences file.
If color model is color, then read/load the resources in the <basename>-color
  file (if it exists).
If color model is monochrome, then read/load the resources in the 
  <basename>-mono file (if it exists).
.fi
.RE
.NH 3
.Fn PrefVar()
.Cs
PrefVar{ item }
.Ce
.IP Args: 4
.RS
.IP item 8
name of a preferences item.
.RE
.LP
Control Flow:
.RS
.nf
Return the variable to associate with an X resource. 
.fi
.RE
.NH 3
.Fn PrefXRes()
.Cs
PrefXRes{ item }
.Ce
.IP Args: 4
.RS
.IP item 8
name of a preferences item.
.RE
.LP
Control Flow:
.RS
.nf
Return the X resource name associated with a preference item.
.fi
.RE
.NH 3
.Fn PrefDefault()
.Cs
PrefDefault{ item }
.Ce
.IP Args: 4
.RS
.IP item 8
name of a preferences item.
.RE
.LP
Control Flow:
.RS
.nf
Return the default value associated with a preference item.
.fi
.RE
.NH 3
.Fn PrefComment()
.Cs
PrefComment{ item }
.Ce
.IP Args: 4
.RS
.IP item 8
name of a preferences item.
.RE
.LP
Control Flow:
.RS
.nf
Return the comment field of a preference item.
.fi
.RE
.NH 3
.Fn PrefHelp()
.Cs
PrefHelp{ item }
.Ce
.IP Args: 4
.RS
.IP item 8
name of a preferences item.
.RE
.LP
Control Flow:
.RS
.nf
Return the Help field of a preference item.
.fi
.RE
.NH 3
.Fn Pref_Add()
.Cs
Pref_Add { prefs }
.Ce
.IP Args: 4
.RS
.IP prefs 9
a list of preference items
.RE
.LP
Control Flow:
.RS
.nf
Foreach item in prefs;
do
  if Xresources item's value is Empty; then
    give the resource a default value
    set the variable associated with the item to have the resource's value
  else 
    set the variable associated with the item to have the resource's value
  endif
done
.fi
.RE
.NH 3
.Fn PrefValue()
.Cs
PrefValue{ varName xres }
.Ce
.IP Args: 4
.RS
.IP varName 11
name of a variable associated with the X resource given by 'xres'.
.IP xres 11
name of an X resources to get value from.
.RE
.LP
Control Flow:
.RS
.nf
If varName already exists, simply return its value.
else get the value of the X resource associated with the varName. Assign this
  value to varName.
endif
.fi
.RE
.NH 3
.Fn PrefValueSet()
.Cs
PrefValueSet{ varName value }
.Ce
.IP Args: 4
.RS
.IP varName 11
name of X resource variable.
.IP value 11
value of some X resource.
.RE
.LP
Control Flow:
.RS
.nf
set varName to have the 'value'. 
.fi
.RE
.NH 3
.Fn PrefSave()
.Cs
PrefSave{}
.Ce
.LP
Control Flow:
.RS
.nf
Get the X resource values from user preferences file.
Create a <user preferences filename>.new and:
  - put old resources value into this file.
  - add a line "!!! Lines below here are automatically added" to the file.
  - puts new resources values after the above line.
Now do a "mv <user preferences filename>.new <user preferences filename>".
.fi
.RE
.NH 3
.Fn prefDoIt()
.Cs
prefDoIt{}
.Ce
.LP
Control Flow:
.RS
.nf
Get the initial values for xpbs resources.
Get the current values for the xpbs resources.
If corresponding values do not match, then return 1; otherwise, return 0.
.fi
.RE
.NH 2
.Tc \f3Program: xpbs_datadump\fP
.LP
The
.B xpbs_datadump
command is mainly used by \f3xpbs\fP to obtain information about servers, 
queues, and jobs within a single execution. By turning on certain command
line options, this program can be instructed to (1) list only those jobs which
meet a list of selection criteria, (2) list only job information (-J), (3) list
only output file/path names of jobs for tracking purposes (-T). This program
combines the features of qstat and qselect.
.NH 3
.Tc Overview
.LP
Parse the options on the execute line and build up an attribute list.
Depending on what options are set, give the status of the server, queues, and
jobs for each of the hosts listed in the execute line.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
xpbs_datadump command, the exit status will be a value of zero.
.LP
If the xpbs_datadump command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi xpbs_datadump.c
.LP
This file contains the main routine and some other functions related to server,
queue, and jobs status as well as job selection.  All other functions are in
the PBS commands library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
.nf
[\-a\ [op]date_time] [\-A\ account_string][\-c\ [op]interval]
[\-h\ hold_list] [\-l\ resource_list] [\-N\ name] [\-p\ [op]priority]
[\-q\ destination] [\-r\ y|n] [\-s\ states] [\-u\ user_name] [\-J\]
[\-T\] [\-t\ wait_timeout_secs] server_name..
.fi
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process.
None are used by the main routine, but some may be used by the library. 
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
	Build the attribute list for the select job request
If destination is given Then
	Determine the queue and server name
Foreach server listed in the execute line
do 
  Connect to the server. Send alarm signal after timeout

  if "-J" option AND "-T" options are not set; then 
    Send the status server request
    Print the server status returned
  endif

  if "-J" option AND "-T" options are not set; then 
    Send the status queue request
    Print the queue status returned
  endif

  Send the select job status request
  if "-T" option is not set; then
    Print the job status for identifiers returned
  else
    Print information about jobs output file/host names, error file/host names
  endif
  Disconnect from the server
done
.fi
.RE
.NH 4
.Fn set_attrop()
.Cs
void set_attrop(struct attropl **list, char *name, char *resource,
                char *value, enum batch_op op)
.Ce
.IP Args: 4
.RS
.IP list 8
The attribute list.
.IP name 8
The name part of the attribute.
.IP resource 8
The resource part of the attribute.
.IP value 8
The value part of the attribute.
.IP op 8
The operation part of the attribute.
.RE
.LP
Control Flow:
.RS
.nf
Allocate the memory for an attribute structure
If name is defined Then
	Allocate the memory for the name part
	Copy the name part
If resource is defined Then
	Allocate the memory for the resource part
	Copy the resource part
If value is defined Then
	Allocate the memory for the value part
	Copy the value part
Set the operation part
Add the attribute structure to the beginning of the attribute list
.fi
.RE
.NH 4
.Fn check_op()
.Cs
void check_op(char *opstring, enum batch_op *op, char *value)
.Ce
.IP Args: 4
.RS
.IP opstring 8
The operator and value string from the command line.
.IP op 8
The operator part of the string turned into an enum batch_op. The operator
defaults to EQ if none is given.
.IP value 8
The value part of the string.
.RE
.LP
Control Flow:
.RS
.nf
Set the operator to EQ
If opstring contains an operator Then
	Find out which operator was used
Copy the value part
.fi
.RE
.NH 4
.Fn check_res_op()
.Cs
int check_res_op(char *resources, char *name, enum batch_op *op, char *value, char **position)
.Ce
.IP Args: 4
.RS
.IP resources 8
The comma delimited list of resources. The list looks like
.nf

name op value, ...

.fi
.IP name 8
The resource name.
.IP op 8
The operator.
.IP value 8
The value.
.IP position 8
The next position in the resource list to parse.
.RE
.IP Returns: 4
Zero, if the resource list is parsed correctly, one otherwise.
.LP
Control Flow:
.RS
.nf
Scan for the resource name
Find out which operator was used
Scan for the resource value
Set the next character position
.fi
.RE
.NH 4
.Fn istrue()
.Cs
int istrue(char *string)
.Ce
.IP Args: 4
.RS
.IP string 8
Is this string some textual form of TRUE?
.RE
.IP Returns: 4
True, if the strings represents true, false otherwise.
.LP
Control Flow:
.RS
.nf
Does the string match TRUE
Does the string match True
Does the string match true
Does the string match 1
.fi
.RE
.NH 4
.Fn states()
.Cs
void states(char *string, char *q, char *r, char *h, char *w, char *t, char *e
, int len)
.Ce
.IP Args: 4
.RS
.IP string 8
The string that holds the count of jobs in each state from the server.
.IP q 8
The number of queued jobs.
.IP r 8
The number of running jobs.
.IP h 8
The number of held jobs.
.IP w 8
The number of waiting jobs.
.IP t 8
The number of jobs in transit.
.IP e 8
The number of exiting jobs.
.RE
.LP
Control Flow:
.RS
.nf
While the string is not empty Do
        Scan for the next word
        If it is Queued Then set the output pointer to q
        If it is Running Then set the output pointer to r
        If it is Held Then set the output pointer to h
        If it is Waiting Then set the output pointer to w
        If it is Transit Then set the output pointer to t
        If it is Exiting Then set the output pointer to e
        Copy the next word to where the output pointer is pointing
.fi
.RE
.NH 4
.Fn display_statjob()
.Cs
void display_statjob(struct batch_status *status, int prtheader, int full,
                     char *server_name)
.Ce
.IP Args: 4
.LP
.IP status 15
A list of information about each job returned by the server.
.IP prtheader 15
True, if the header is to be printed, false otherwise.
.IP full 15
True, if a full display is requested, false for a normal display.
.IP server_name 15
full name of the server associated with the jobs to be displayed.
.LP
Control Flow:
.RS
.nf
If not full and header Then
        Print the header
While there is an item in the status list Do
        If full Then
                Print a full job display of all the attributes
        Else
                Print a normal display of the attributes listed in the ERS
        Get the next item in the list
.fi
.RE
.NH 4
.Fn display_statque()
.Cs
void display_statque(struct batch_status *status, int prtheader, int full,
                     char *server_name)
.Ce
.IP Args: 4
.IP status 15
A list of information about each queue returned by the server.
.IP prtheader 15
True, if the header is to be printed, false otherwise.
.IP full 15
True, if a full display is requested, false for a normal display.
.IP server_name 15
full server name associated with the list of queues to be displayed. 
.LP
Control Flow:
.RS
.nf
If not full and header Then
        Print the header
While there is an item in the status list Do
        If full Then
                Print a full queue display of all the attributes
        Else
                Print a normal display of the attributes listed in the ERS
        Get the next item in the list
.fi
.RE
.NH 4
.Fn display_statserver()
.Cs
void display_statserver(struct batch_status *status, int prtheader, int full)
.Ce
.IP Args: 4
.RS
.IP status 8
A list of information about the server returned by the server.
.IP prtheader 8
True, if the header is to be printed, false otherwise.
.IP full 8
True, if a full display is requested, false for a normal display.
.RE
.LP
Control Flow:
.RS
.nf
If not full and header Then
        Print the header
While there is an item in the status list Do
        If full Then
                Print a full server display of all the attributes
        Else
                Print a normal display of the attributes listed in the ERS
        Get the next item in the list
.fi
.RE
.NH 4
.Fn display_trackstatjob()
.Cs
void display_trackstatjob(struct batch_status *status, char *server_name)
.Ce
.IP Args: 4
.RS
.IP status 15
A list of information about the jobs returned by the server.
.IP server_name 15
full server name associated with a job.
.IP
.RE
.LP
Control Flow:
.RS
.nf
While there is an item in the status list Do
 	print the full jobid, owner, output file/host name, error file/host name
        Get the next item in the list
Done
.fi
.RE
.NH 2
.Tc \f3Program: xpbs_scriptload\fP
.LP
Command that reads in a PBS job script and returns a list of
"job attribute = value" lines based on PBS directive lines found in the
script. A special line called "Buffer File = <filename>" is also displayed where
<filename> will contain non-PBS directive lines found in the script.
.NH 3
.Tc Overview
.LP
Parse the execute line and get the PBS prefix string to look for when
scanning a script for PBS options.  Get the script and check
for embedded operands. Return "job attribute = value" lines based on 
operands found in the script. Also, include the line "Buffer_File = <filename>"
which refers to the file that holds non-PBS directive lines found in the
script.
.NH 3
.Tc External Interfaces
.LP
Upon successful processing of all the operands presented to the
the xpbs_scriptload command, the exit status will be a value of zero.
.LP
If the xpbs_scriptload command fails to process any operand, the
command exits with a value greater than zero.
.NH 3
.Fi xpbs_scriptload.c
.LP
This file contains the main routine and some other functions related to job
script parsing only.  All other functions are in the library.
.NH 4
.Fn main()
.Cs
main(int argc, char **argv, char **envp)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
 [-C directive_prefix] script
.RE
.IP envp 8
The 
.B envp
array contains environment variables for this process. Not used in this
program.
.RE
.IP Returns: 4
Zero, if no errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
Use getopt to get each option
Get the script and any options embedded in the script
Print "job attribute = value" lines.
Print "Buffer_File = <filename>" line.
.fi
.RE
.NH 4
.Fn set_dir_prefix()
.Cs
char *set_dir_prefix(char *prefix)
.Ce
.IP Args: 4
.RS
.IP prefix 8
The directive prefix supplied by the user, if given.
.RE
.IP Returns: 4
The directive prefix.
.LP
Control Flow:
.RS
.nf
If prefix has something in it Then
	Use prefix
Else If the environment variable PBS_DPREFIX is defined Then
	Use PBS_DPREFIX
Else
	Use the default PBS_DPREFIX_DEFAULT
.fi
.RE
.NH 4
.Fn isexecutable()
.Cs
int isexecutable(char *line)
.Ce
.IP Args: 4
.RS
.IP line 8
A line of the script file.
.RE
.IP Returns: 4
True, if the line is not a comment, false otherwise.
.LP
Control Flow:
.RS
.nf
Is the first non-blank character a #?
.fi
.RE
.NH 4
.Fn ispbsdir()
.Cs
int ispbsdir(char *line)
.Ce
.IP Args: 4
.RS
.IP line 8
A line from the script file.
.RE
.IP Returns: 4
True, if the line is a PBS directive, false otherwise. If it is a directive,
it returns the starting address of line string.
.LP
Control Flow:
.RS
.nf
Does the first part of the line match the PBS directive prefix?
.fi
.RE	
.NH 4
.Fn get_script()
.Cs
int get_script(FILE *file, char *script, char *prefix)
.Ce
.IP Args: 4
.RS
.IP file 8
The file descriptor of the script.
.IP script 8
The name of the copy that is made of the script that contains only non-PBS
directive lines.
.IP prefix 8
The PBS directive prefix.
.RE
.IP Returns: 4
Zero, if the script was copied okay and PBS options correctly parsed,
non-zero otherwise.
.LP
Control Flow:
.LP
.RS
.nf
Create a temporary file
While there is a line left in the script file Do
	If no executable statements yet and this is a PBS directive Then
		Continuation is TRUE
		While Continuation D0
			Check if this line is continued (ends in \\n) and
			   if it is, Get the next line in the script and
			   append to current directive line
		Done
	        Parse the PBS directives
	Else
	  Write the line to the temporary file
          If this an executable statement Then
	     stop processing anymore PBS directive lines
	  endif
.RE
.NH 4
.Fn make_argv()
.Cs
void make_argv(int *argc, char *argv[], char *line)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of PBS directives found in the line.
.IP argv 8
The individual PBS directives.
.IP line 8
The PBS directives line from the script.
.RE
.LP
Control Flow:
.RS
.nf
Set argv[0] to qsub
While the line is not empty Do
	If the next character is a quote Then
		Find the matching quote
		Make it a blank
	Scan for the next blank
	Allocate memory for the word
	Copy the word
	Put the word's address into the argv array
	Increment the number of things in argv
.fi
.RE
.NH 4
.Fn do_dir()
.Cs
int do_dir(char *line)
.Ce
.IP Args: 4
.RS
.IP line 8
A PBS directives line from the script.
.RE
.IP Returns: 4
The value returned from processing the directives (see process_opts).
.LP
Control Flow:
.RS
.nf
If the first time through Then
	Clear out the array that will hold the words of the line
Parse the line into words
Process the word list
.fi
.RE
.NH 4
.Fn process_opts()
.Cs
int process_opts(int argc, char **argv, int pass)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments in argv.
.IP argv 8
The command line or PBS directives line arguments.
.IP pass 8
Zero, if a command line argument list, positive if a PBS directive argument list.
.RE
.LP
.nf
Control Flow:
If pass is greater than zero Then
	Start at the beginning of the argument list
While getopt Do
	For each option, print corresponding "job attribute = value" string.
.fi
.LP
Note that the following rules are enforced:
.IP 1.
Option argument values supplied on the command line take precedence over values
for the same option supplied in script directives.
.IP 2.
If an option  is repeated on the command line (or in the script, subject to
rules 1), the argument value for the last occurrence:
.RS
.IP -
replaces the prior value if the option is singled valued (integer or string).
.IP -
is appended to the prior value(s) if the option is list valued (comma
separated elements).
.RE
.NH 2
.Tc \f3xpbsmon Packaging\fP
.LP
The main file called \f3xpbsmon\fP contains the main() section of the GUI; it
starts up appropriate routines on its event loop to respond to actions like
mouse presses. Related procedures, callback functions are grouped together in a
file. Files with the ".tk" suffix contain Tk-related procedures while
those with ".tcl" suffix contain non-Tk related routines. Bitmap files used by
the GUI are located in the \f3bitmaps\fP directory.  Help files accessed by
the GUI are in the help directory.
.NH 2
.Fi xpbsmon
.LP
This file contains the main event loop.
.NH 3
.Fn main()
.Cs
main{argc, argv}
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
list contain the arguments
.RE
.IP Returns: 4
Zero, if no command line syntax errors are detected.  Positive, otherwise.
.LP
Control Flow:
.RS
.nf
set appropriate Tcl/Tk library directories, program version number, and
program paths.

Load xpbsmon resource values as supplied from the X resources files: global and
user's .xpbsmonrc file.
Set default values for unset xpbsmon resources.
Set the colors of various widgets based on xpbs color resources.
Save the initial values of the xpbs resources.

Also, for sites information, load it.

Set the mainWindow path and make it visible.

Build the main display of xpbsmon containing the necessary widgets.
Set properties involving the window manager.

if autoUpdate is turned on, then
	schedule an update of nodes data.
fi
.fi
.RE
.NH 2
.Fi node.tk
.LP
This file contains routines that creates a node box which represent a node
or execution host on display.
.NH 3
.Fn nodeCreate()
.Cs
nodeCreate( nodeframe, nodename, nodelabel, clusterframe, nodeType, viewType )
.Ce
.IP Args:
.RS
.IP nodeframe 14
a node abstraction
.IP nodename 14
hostname of the node represented by 'nodeframe'
.IP nodelabel 14
display label of the node represented by 'nodeframe'
.IP clusterframe 14
the frame where 'nodeframe' belongs to
.IP nodeType  14
type of node in terms of whether or not it is managed by a server and running a
MOM (MOM_SNODE), managed by a server but is not running a MOM (NOMOM_SNODE),
not managed by a server but is running a MOM (MOM), and finally, not managed
by a server and is not running a MOM (NOMOM).
NOMOM_SNODE is the default.
.IP viewType 14
how nodeframe is going to be displayed: FULL, MIRROR, ICON.
.RE
.IP Returns: 4
{$width $height} - the resulting width and height.
.LP
Control Flow:
.RS
.nf
Depending on the requested viewType, appropriately set the font types and
maxWidth and maxHeight of the display box to use.

create the main nodeframe.
create the frame that will hold the nodelabel.
create the frame that will hold the canvas.
create the frame that will hold the x scrollbar.
create the frame that will hold the y scrollbar.

For the nodelabel, truncate it if the viewType is ICON. Calculate its width
and height.

create the canvas widget. Update the nodeframe's node status to its current
status if its nodeType is MOM and viewType is not MIRROR or if its nodeType is
not MOM and viewType is not MIRROR. The default types are NOINFO for a node that
is running a MOM, and UP for a node that is not running a MOM.
is not MIRROR. calculate its frame width and height.


create the Xscrollbar. Calculate its height.

create the Yscrollbar. Calculate its width. 


Update the various attributes appropriately of the nodeframe's structure. 
The display width of the nodeframe will be adjusted according to the width
of the nodelabel. 

If the the display width is > maxWidth, adjust things so that they all fit
in maxWidth. Do the same for display height.

If the viewType is ICON, then cover the contents of the canvas. Otherwise,
display the canvas contents. 
.fi
.RE
.NH 3
.Fn nodeReCreate()
.Cs
nodeReCreate( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.IP Returns: 4
{$width $height} - the resulting width and height.
.LP
Control Flow:
.RS
.nf
Depending on the requested viewType, get values again for font types and
maxWidth and maxHeight of the display box to use.

redisplay the nodelabel text.  
reconfigure the nodeframe's canvas' width and height and scroll regions.
update the node's status when needed.
reconfigure the xscrollbar and the yscrollbar and redisplaying them or
removing them from view when needed.

Finally, resize the display width and height depending on the new sizes of
maxWidth and maxHeight.

If viewType is ICON, then cover the contents of the canvas.
.fi
.RE
.NH 3
.Fn nodeAddWidth()
.Cs
nodeAddWidth( nodeframe, incr )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP incr 12
amount to add to the nodeframe' width
.RE
.LP
Control Flow:
.RS
.nf
Adds 'incr' amount to the  nodeframe's display width, and if the resulting
value is still within the limits, then extend the width of the nodeframe's
canvas, as well its cluster frame.
.fi
.RE
.NH 3
.Fn nodeRepack()
.Cs
nodeRepack( nodeframe ) 
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
redisplay a nodeframe, 

if line scale width is > canvas width  and is still
within the nodeMaxWidth boundary limit, then 
		set canvas width to that of line scale width,
		and adjust node distances appropriately
fi
Also, show xscroll bar or yscroll when needed.
.fi
.RE
.NH 3
.Fn nodeCoverCanvas()
.Cs
nodeCoverCanvas( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
Puts a rectangular blanket over the canvas of a nodeframe.
.RE
.NH 3
.Fn nodeUnCoverCanvas()
.Cs
nodeUnCoverCanvas( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
Removes the rectangular blanket from the canvas of a nodeframe.
.fi
.RE
.NH 3
.Fn nodeReCoverCanvas()
.Cs
nodeReCoverCanvas( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
Like nodeCoverCanvas except the rectangular blanket is resized.
.fi
.RE
.NH 3
.Fn nodeRefreshGet()
.Cs
nodeRefreshGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
get the refresh flag attribute value.
.fi
.RE
.NH 3
.Fn nodeRefreshPut()
.Cs
nodeRefreshPut ( nodeframe, flag )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP flag 12
 new flag value 
.RE
.LP
Control Flow:
.RS
.nf
update the refresh attribute value to 'flag'.
.fi
.RE
.NH 3
.Fn nodeNameGet()
.Cs
nodeNameGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
get the name attribute value.
.fi
.RE
.NH 3
.Fn nodeNamePut()
.Cs
nodeNamePut ( nodeframe, name )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP name 12
new nodename
.RE
.LP
Control Flow:
.RS
.nf
update the name attribute value to 'name'.
.fi
.RE
.NH 3
.Fn nodeLabelFrameGet()
.Cs
nodeLabelFrameGet ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
return the frame on which nodeframe's label widget sits on.
.fi
.RE
.NH 3
.Fn nodeLabelFramePut()
.Cs
nodeLabelFramePut ( nodeframe, frame )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP frame 12
a frame to put label widget
.RE
.LP
Control Flow:
.RS
.nf
set the frame on which nodeframe's label widget sits on to 'frame'.
.fi
.RE
.NH 3
.Fn nodeLabelGet()
.Cs
nodeLabelGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
returns the pathname to the widget labeling the nodeframe.
.fi
.RE
.NH 3
.Fn nodeLabelPut()
.Cs
nodeLabelPut ( nodeframe, label )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP name 12
label widget pathname
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
makes 'label' the pathname to the nodeframe's label.
.fi
.RE
.NH 3
.Fn nodeTypeGet()
.Cs
nodeTypeGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
returns the type attribute value of nodeframe.
.fi
.RE
.NH 3
.Fn nodeTypePut()
.Cs
nodeTypePut ( nodeframe, type )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP type 12
new MOM type.
.RE
.LP
Control Flow:
.RS
.nf
updates the type attribute of nodeframe to 'type'.
.fi
.RE
.NH 3
.Fn nodeViewTypeGet()
.Cs
nodeViewTypeGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the display/view type of nodeframe.
.fi
.RE
.NH 3
.Fn nodeViewTypePut()
.Cs
nodeViewTypePut ( nodeframe, type )
.Ce

.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP type 12
new display type.
.RE
.IP Returns: 4

.LP
Control Flow:
.RS
.nf
updates the display/view type of nodeframe to 'type'.
.fi
.RE

.NH 3
.Fn nodeCanvasFrameGet()
.Cs
nodeCanvasFrameGet ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the frame on which nodeframe's canvas sits on.
.fi
.RE

.NH 3
.Fn nodeCanvasFramePut()
.Cs
nodeCanvasFramePut ( nodeframe, frame )
.Ce

.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP frame 12
a frame
.RE
.IP Returns: 4

.LP
Control Flow:
.RS
.nf
set the frame on which nodeframe's canvas sits on to 'frame'.
.fi
.RE
.NH 3
.Fn nodeCanvasGet()
.Cs
nodeCanvasGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the pathname to the canvas widget of 'nodeframe'.
.fi
.RE
.NH 3
.Fn nodeCanvasPut()
.Cs
nodeCanvasPut ( nodeframe, type )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP canvas 12
new canvas widget.
.RE
.LP
Control Flow:
.RS
.nf
makes 'canvas' the nodeframe's canvas widget.
.fi
.RE
.NH 3
.Fn nodeXscrollFrameGet()
.Cs
nodeXscrollFrameGet ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
return the frame on which nodeframe's xscrollbar sits on.
.fi
.RE
.NH 3
.Fn nodeXscrollFramePut()
.Cs
nodeXscrollFramePut ( nodeframe, frame )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP frame 12
an xscroll frame 
.RE
.LP
Control Flow:
.RS
.nf
set the frame on which nodeframe's xscrollbar sits on to 'frame'.
.fi
.RE
.NH 3
.Fn nodeXscrollGet()
.Cs
nodeXscrollGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the pathname to the nodeframe's xscroll widget.
.fi
.RE
.NH 3
.Fn nodeXscrollPut()
.Cs
nodeXscrollPut ( nodeframe, xscroll )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP xscroll 12
xscrollbar pathname.
.RE
.IP Returns: 4

.LP
Control Flow:
.RS
.nf
makes 'xscroll' pathname the nodeframe's xscroll widget.
.fi
.RE
.NH 3
.Fn nodeYscrollFrameGet()
.Cs
nodeYscrollFrameGet ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
return the frame on which nodeframe's yscrollbar sits on.
.fi
.RE
.NH 3
.Fn nodeYscrollFramePut()
.Cs
nodeYscrollFramePut ( nodeframe, frame )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP frame 12
a yscroll frame 
.RE
.LP
Control Flow:
.RS
.nf
set the frame on which nodeframe's yscrollbar sits on to 'frame'.
.fi
.RE
.NH 3
.Fn nodeYscrollGet()
.Cs
nodeYscrollGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the pathname to the nodeframe's xscroll widget.
.fi
.RE
.NH 3
.Fn nodeYscrollPut()
.Cs
nodeYscrollPut ( nodeframe, yscroll )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP yscroll 12
yscrollbar pathname.
.RE
.LP
Control Flow:
.RS
.nf
makes 'yscroll' pathname the nodeframe's yscroll widget.
.fi
.RE
.NH 3
.Fn nodeScrollRegionWidthGet()
.Cs
nodeScrollRegionWidthGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the current scrollregion's width in nodeframe's canvas.
.fi
.RE
.NH 3
.Fn nodeScrollRegionWidthPut()
.Cs
nodeScrollRegionWidthPut ( nodeframe, width )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP width 12
width of the scrollregion.
.RE
.LP
Control Flow:
.RS
.nf
records the scrollregion's width in nodeframe's canvas.
.fi
.RE
.NH 3
.Fn nodeScrollRegionHeightGet()
.Cs
nodeScrollRegionHeightGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the scrollregion's height in nodeframe's canvas.
.fi
.RE

.NH 3
.Fn nodeScrollRegionHeightPut()
.Cs
nodeScrollRegionHeightPut ( nodeframe, height )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP height 12
height of the scrollregion.
.RE
.LP
Control Flow:
.RS
.nf
records the scrollregion's height in nodeframe's canvas.
.fi
.RE
.NH 3
.Fn nodeDisplayWidthGet()
.Cs
nodeDisplayWidthGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the displayWidth attribute value of nodeframe.
.fi
.RE
.NH 3
.Fn nodeDisplayWidthPut()
.Cs
nodeDisplayWidthPut ( nodeframe, width )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP width 12
width of display 
.RE
.LP
Control Flow:
.RS
.nf
set the displayWidth's attribute value of nodeframe to 'width'.
.fi
.RE
.NH 3
.Fn nodeDisplayHeightGet()
.Cs
nodeDisplayHeightGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
returns the displayHeight attribute value of nodeframe.
.fi
.RE
.NH 3
.Fn nodeDisplayHeightPut()
.Cs
nodeDisplayHeightPut ( nodeframe, height )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP height 12
height of display 
.RE
.LP
Control Flow:
.RS
.nf
set the displayHeight's attribute value of nodeframe to 'height'.
.fi
.RE
.NH 3
.Fn nodeCanvasWidthGet()
.Cs
nodeCanvasWidthGet( nodeframe }
.Ce

.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.IP Returns: 4

.LP
Control Flow:
.RS
.nf
returns the canvasWidth attribute value of nodeframe.
.fi
.RE
.NH 3
.Fn nodeCanvasWidthPut()
.Cs
nodeCanvasWidthPut ( nodeframe, width )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP width 12
width of canvas
.RE
.LP
Control Flow:
.RS
.nf
set the canvasWidth's attribute value of nodeframe to 'width'.
.fi
.RE
.NH 3
.Fn nodeCanvasHeightGet()
.Cs
nodeCanvasHeightGet( nodeframe }
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the canvasWidth attribute value of nodeframe.
.fi
.RE
.NH 3
.Fn nodeCanvasHeightPut()
.Cs
nodeCanvasHeightPut ( nodeframe, height )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP height 12
height of canvas
.RE
.LP
Control Flow:
.RS
.nf
set the canvasHeight's attribute value of nodeframe to 'height'.
.fi
.RE
.NH 3
.Fn nodeClusterFrameGet()
.Cs
nodeClusterFrameGet ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
return the cluster frame on which nodeframe sits on.
.fi
.RE
.NH 3
.Fn nodeClusterFramePut()
.Cs
nodeClusterFramePut ( nodeframe, frame )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP frame 12
a cluster frame
.RE
.LP
Control Flow:
.RS
.nf
set the cluster frame on which nodeframe sits on to 'frame'.
.fi
.RE
.NH 3
.Fn nodeXposGet()
.Cs
nodeXposGet ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
return the nodeframe's X coordinate.
.fi
.RE

.NH 3
.Fn nodeXposPut()
.Cs
nodeXposPut ( nodeframe, pt )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP pt 12
the x coordinate
.RE
.LP
Control Flow:
.RS
.nf
sets the nodeframe's X coordinate value to 'pt'.
.fi
.RE
.NH 3
.Fn nodeYposGet()
.Cs
nodeYposGet ( noderame )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
return the nodeframe's Y coordinate.
.fi
.RE
.NH 3
.Fn nodeYposPut()
.Cs
nodeYposPut ( nodeframe, pt )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP pt 12
the y coordinate
.RE
.LP
Control Flow:
.RS
.nf
sets the nodeframe's Y coordinate value to 'pt'.
.fi
.RE
.NH 3
.Fn nodeOffsetWidthGet()
.Cs
nodeOffsetWidthGet ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the amount of pixels a node needs  to move to the right during a
redisplay.
.fi
.RE
.NH 3
.Fn nodeOffsetWidthPut()
.Cs
nodeOffsetWidthPut ( nodeframe, width )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP width 12
a width in pixels
.RE
.LP
Control Flow:
.RS
.nf
sets the amount of pixels to 'width' that a a node needs to move to the right.
.fi
.RE
.NH 3
.Fn nodeNextGet()
.Cs
nodeNextGet ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
In an array of displayed nodeframes, this returns the its neighbor frame to
the right.
.fi
.RE
.NH 3
.Fn nodeNextPut()
.Cs
nodeNextPut ( nodeframe, frame )
.Ce

.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP frame 12
a neighboring frame
.RE
.LP
Control Flow:
.RS
.nf
sets nodeframe's neighbor frame to 'frame'.
.fi
.RE
.NH 3
.Fn nodeMainFrameGet()
.Cs
nodeMainFrameGet ( nodeframe )
.Ce

.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the main frame where canvas, scrollbar of nodeframe sits.
.fi
.RE
.NH 3
.Fn nodeMainFramePut()
.Cs
nodeMainFramePut ( nodeframe, frame )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP frame 12
a frame to place canvas, scrollbars
.RE
.LP
Control Flow:
.RS
.nf
sets the main frame where canvas, scrollbar of nodeframe sits to 'frame'.
.fi
.RE
.NH 3
.Fn nodeGroupXCGet()
.Cs
nodeGroupXCGet ( nodeframe, group )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP group 12
a grouping idea within a nodeframe's canvas
.RE
.LP
Control Flow:
.RS
.nf
returns the X coordinate position of this group of stuff in nodeframe's
canvas. 
.fi
.RE

.NH 3
.Fn nodeGroupXCPut()
.Cs
nodeGroupXCPut ( nodeframe, group, xc )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP group 12
a grouping idea within a nodeframe's canvas
.IP xc  12
the  X coordinate of this group of stuff 
.RE
.LP
Control Flow:
.RS
.nf
sets the X coordinate position of this group of stuff in nodeframe's
canvas to 'xc'.
.fi
.RE
.NH 3
.Fn nodeFindXCs()
.Cs
nodeFindXCs ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
In nodeframe's canvas, find all the X coordinates per group of  items.

Go through every line of data in nodeframe's canvas,
	foreach groups of data in  a line,
		get X coordinate value for the current group,
		get maximum width value for the current group,

Go through each group,
	set the X coordinate of the "next" to be
	   max( current X coordinate value for next group, 
	(X coordinate for current group + max width value for current group)

Save the max X coordinate value for each group.
.fi
.RE
.NH 3
.Fn nodeAdjustDisplay()
.Cs
nodeAdjustDisplay ( nodeframe )
.Ce

.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
Call nodeFindXCs to get the aligned X coordinates for each group (column)
of stuff in nodeframe's canvas.

Go through each item in nodeframe's canvas,
	find the group they belong to and see what their X coordinates 
		supposed to be. Calculate an offset value of the item's
		current X coordinate with the group X coordinate value.
		Then move the item appropriately using the newly-calculated
		offset. 
	Also, as you go through the loop, find the total height of the
		contents of the canvas as well as the total width. These
		will be used to update line scale width value as well
		scroll regions which would introduced the appropriate
		x scroll or yscroll.
.fi
.RE
.NH 3
.Fn nodePrint()
.Cs
nodePrint ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
prints the values of all the attributes of 'nodeframe'.
.fi
.RE
.NH 3
.Fn nodeDelete()
.Cs
nodeDelete( nodeframe )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
.RE
.LP
Control Flow:
.RS
.nf
removes from view nodeframe and deallocates all memory storage associated with
it.
.fi
.RE
.NH 3
.Fn nodeLineGet()
.Cs
nodeLineGet ( nodeframe, lineno, group )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP group 12
a grouping of stuff in nodeframe's canvas
.RE
.LP
Control Flow:
.RS
.nf
return the item-id at (lineno,groupno)  in nodeframe's canvas.
.fi
.RE

.NH 3
.Fn nodeLinePut()
.Cs
nodeLinePut ( nodeframe, lineno, group, tagOrId )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP group 12
a grouping of stuff in nodeframe's canvas
.IP tagOrId 12
the item-id
.RE
.LP
Control Flow:
.RS
.nf
set the item-id at (lineno,groupno) in nodeframe's canvas to 'tagOrId'
.fi
.RE
.NH 3
.Fn nodeAddText()
.Cs
nodeAddText ( nodeframe, lineno, groupno, text )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP group 12
a grouping of stuff in nodeframe's canvas
.IP text 12
text widget to add to nodeframe's canvas
.RE
.LP
Control Flow:
.RS
.nf
Based on the view type, set the text font to use appropriately.
The idea is to separate text widgets into different groups. Each group of text
is identified by some item id or tag. This id will be saved for future
manipulation.

Indent the text by text_width and text_height if it is the 1st group of text
in the line. Simple start the text after the previous line if one exists;
otherwise, simple add to the current line.
.fi
.RE
.NH 3
.Fn nodeAddLineText()
.Cs
nodeAddLineText ( nodeframe lineno listOfText )
.Ce
.IP Args: 4
.RS
.IP
nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP listOfText 12
list of text to add
.RE
.LP
Control Flow:
.RS
.nf
adds a "listOfText" as one line in nodeframe's canvas.
.fi
.RE

.NH 3
.Fn nodeMatchItemTag()
.Cs
nodeMatchItemTag( nodeframe, itemid, tag )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP itemid 12
an id in nodeframe's canvas
.IP tag 12
tag to match
.RE
.IP Returns: 4
.RS
1 if matching "tag" is found
0 otherwise
.RE
.LP
Control Flow:
.RS
.nf
searches for a tag in 'itemid' that matches "tag" and returns 1 if found one,
0 otherwise.
.fi
.RE
.NH 3
.Fn nodeModText()
.Cs
nodeModText ( nodeframe, lineno, groupno, text )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP group 12
a grouping of stuff in nodeframe's canvas
.IP text 12
text widget to add to nodeframe's canvas
.RE
.IP Returns: 4
.RS
1 if a modify action took place
0 otherwise
.RE
.LP
Control Flow:
.RS
.nf
Get the id @lineno,groupno in nodeframe's canvas. If its tag is a text, then
modify its text value if != "text"; otherwise, delete this current text and
call "nodeAddText" to add a new text.   
.fi
.RE
.NH 3
.Fn nodeRemLineEntry() 
.Cs
nodeRemLineEntry(nodeframe, lineno, groupno)
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP group 12
a grouping of stuff in nodeframe's canvas
.RE
.LP
Control Flow:
.RS
.nf
Starting at @lineno,groupno, text will be deleted until the end of line, and
any textid saved somewhere for the text will be thrown away.
.fi
.RE
.NH 3
.Fn nodeModLineText()
.Cs
nodeModLineText ( nodeframe, lineno, listOfText )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP listOfText 12
list of text to modify
.RE
.LP
Control Flow:
.RS
.nf
like nodeModText except that modification applies to a line of text. This
will completely replace all text found @lineno.
.fi
.RE

.NH 3
.Fn nodeRemLines()
.Cs
nodeRemLines ( nodeframe, lineno )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.RE
.LP
Control Flow:
.RS
.nf
This removes all the lines in nodeframe's canvas starting @lineno. 
.fi
.RE
.NH 3
.Fn nodeScaleCreate()
.Cs
nodeScaleCreate ( nodeframe lineno groupno value )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP group 12
a grouping of stuff in nodeframe's canvas
.IP value 12
scale value
.RE
.LP
Control Flow:
.RS
.nf
create the text value of the scale. Position it appropriately.
create the rectangle for the max value.
if value > max value; then
  create 2 filled rectangles. One for the scale value of up to max value. The
  other is for any of remaining value in excess of the max value.
else
  create 1 rectangle only for the scale value.

Mark all parts of the scale as "$lineno$groupno$nodeframe" and save this
tag for future collective manipulation.
.fi
.RE
.NH 3
.Fn nodeScaleReCreate()
.Cs
nodeScaleReCreate ( nodeframe lineno groupno newvalue )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP group 12
a grouping of stuff in nodeframe's canvas
.IP newvalue 12
scale value
.RE
.LP
Control Flow:
.RS
.nf
This will itemconfigure the label for the value of the widget. All the other
rectangles are appropriately recreated.
.fi
.RE
.NH 3
.Fn nodeAddLineScale()
.Cs
nodeAddLineScale ( nodeframe, lineno, param )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP param 12
{label valueLabel}
.RE
.LP
Control Flow:
.RS
.nf
creates a line containing a scale widget given by 'param'.
.fi
.RE
.NH 3
.Fn nodeModLineScale()
.Cs
nodeModLineScale ( nodeframe, lineno, newContent )
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.IP lineno 12
a line # in nodeframe's canvas
.IP newContent 12
new Content of the form {label valueLabel}
.RE
.LP
Control Flow:
.RS
.nf
This recreates the line that has a scale widget using 'newContent' as
specification.
.fi
.RE
.NH 3
.Fn nodeDown() 
.Cs
nodeDown ( nodeframe ) 
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
This changes the background color of the node canvas to $canvas(nodeColorDown)
.fi
.RE
.NH 3
.Fn nodeUp() 
.Cs
nodeUp ( nodeframe ) 
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
This changes the background color of the node canvas to $canvas(nodeColorUP)
.fi
.RE
.NH 3
.Fn nodeOffline() 
.Cs
nodeOffline ( nodeframe ) 
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
This changes the background color of the node canvas to $canvas(nodeColorOFFL)
.fi
.RE
.NH 3
.Fn nodeReserved() 
.Cs
nodeReserved ( nodeframe ) 
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
This changes the background color of the node canvas to $canvas(nodeColorRSVD)
.fi
.RE
.NH 3
.Fn nodeInUse() 
.Cs
nodeInUse ( nodeframe ) 
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a node abstraction
.RE
.LP
Control Flow:
.RS
.nf
This is a little less straightforward procedure because different unique
jobs can be assigned different colors. 
First, it looks at the nodeInfo of the nodename represented by 'nodeframe'. If
the nodeInfo contains a NODEJOB, that means the node is INUSE. Then get the
userinfo = { {user1 {j11 j12 ... j1n}}, {user2 { j21 j22 ... j2n} ...}, create
jobs = {user1.j11 user1.j12 ... user1.j1n user2.j21 user2.j22 ... user2.j2n ..}.
if nodestatus is INUSE-EXCLUSIVE and length(jobs) <= 1, then
	go head and assign a new INUSE color
else if length(jobs) > 1, then
	set INUSE color to be $canvas(nodeColorINUSEshared)

change the background color of the nodeframe's canvas to whatever the chosen
color if one exists.
.fi
.RE
.NH 3
.Fn nodeUpdateStat()
.Cs
nodeUpdateStat ( sysframe, nodeid, status2, defstat )
.Ce

.IP Args: 4
.RS
.IP sysframe 10
a site/system abstraction
.IP nodeid 10
name of node in a site
.IP status2 10
new node status
.IP defstat 10
default node status (=NOINFO)
.RE
.LP
Control Flow:
.RS
.nf
This basically sets the status of node described by nodeid @ sysframe to 
 'defstat'. It also does other bookkeepings like:
save oldstatus

if status is "" ; then
       set status to $defstat
fi

save status by calling the function systemNodeStatusPut()

To do the following, call the function clusterStatsUpdate(): 
status          action
-------         ------
OFFLINE	        update the clusterOfflinePool count
DOWN            update the clusterDownPool count
FREE            update the clusterAvailPool count
INUSE           update the clusterUsePool count
RESERVED        update the clusterReservedPool count

oldstatus       action
---------       ------
OFFLINE         decrement the clusterOfflinePool count by 1
DOWN            decrement the clusterDownPool count by 1
FREE            decrement the clusterAvailPool count by 1
INUSE           decrement the clusterUsePool count by 1
RESERVED        decrement the clusterReservedPool count by 1
.fi
.RE
.NH 3
.Fn nodeDisplayInfo()
.Cs
nodeDisplayInfo (nodeframe, queryInfo, create)
.Ce
.IP Args: 4
.RS
.IP nodeframe 12
a nodeframe abstraction
.IP queryInfo 12
information to be displayed
.IP create 12
flag to signal whether to create the frame or modify contents of
existing frame (default = 0)
.RE
.LP
Control Flow:
.RS
.nf
set i 0
foreach elem in queryInfo
do
        if elem's type is TEXT, then
                if create is TRUE
                        add ith-line of text featuring elem's header and result
                else
                        mod ith-line of text featuring elem's header and result
        else if elem's type is SCALE, then
                if create is TRUE
                        add ith-line of scale featuring elem's header and result
                else
                        mod ith-line of scale featuring elem's header and result
        else if elem's type is NODEJOB, then 
                if the i-th line is empty, then
                        add ith-line of text featuring elem's header
                else
                        mod ith-line of text featuring elem's header
                fi
cluster.tk
                set k = $i + 1
cluster.tk
                foreach of the user:jobs info,
                do
                        if the k-th line of text is empty, then
                                add kth-line of text indented
                        else
                                modify the kth-line of text indented
                        fi
                        incr k
               done
        fi

        increment i
done
if no lines of text containing NODEJOB information,
        reset k to current value of i

remove remaining k lines of nodeframe

adjust the display of nodeframe to see if xscroll and yscroll bars are needed
cover the contents if nodeframe's view type is ICON; otherwise, uncover the
contents.
.fi
.RE
.NH 2
.Fi cluster.tk
.LP
This file contains routines for displaying the server box.
.NH 3
.Fn clusterAddWidth()
.Cs
clusterAddWidth( clusterf, incr )
.Ce
.IP Args: 4
.RS
.IP clusterf 10
a cluster frame abstraction
.IP incr 10
amount to add to the clusterf' width
.RE
.LP
Control Flow:
.RS
.nf
Adds 'incr' amount to the  clusterf's display width, and if the resulting
value is still within the limits, then extend the width of the clusterf's
canvas, and the enclosing system frame. Update the clusterf's scroll region
width appropriately.
.fi
.RE
.NH 3
.Fn clusterPropagateOffset() 
.Cs
clusterPropagateOffset( clusterf diff ) 
.Ce
.IP Args: 4
.RS
.IP clusterf
a cluster frame abstraction
.IP diff
offset value to be propagated
.RE
.LP
Control Flow:
.RS
.nf
Updates the offset values of all the cluster frames following 'clusterf'.
.fi
.RE
.NH 3
.Fn clusterDelete()
.Cs
clusterDelete ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 12
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
removes from view clusterf and deallocates all memory storage associated with
it.
.fi
.RE
.NH 3
.Fn clusterNamePut()
.Cs
clusterNamePut ( clusterframe, name )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP name 14
name for the cluster
.RE
.LP
Control Flow:
.RS
.nf
set the name attribute of cluster to 'name'.
.fi
.RE
.NH 3
.Fn clusterNameGet()
.Cs
clusterNameGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of clusterframe's name attribute.
.fi
.RE
.NH 3
.Fn clusterCanvasFramePut()
.Cs
clusterCanvasFramePut ( clusterframe, frame )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP frame 14
canvas frame widget
.RE
.LP
Control Flow:
.RS
.nf
set the canvasFrame attribute of cluster to 'frame'.
.fi
.RE
.NH 3
.Fn clusterCanvasFrameGet()
.Cs
clusterCanvasFrameGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.RE
.IP Returns: 4

.LP
Control Flow:
.RS
.nf
returns the value of clusterframe's canvasFrame attribute.
.fi
.RE
.NH 3
.Fn clusterCanvasPut()
.Cs
clusterCanvasPut ( clusterframe, canvas )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.IP canvas 14
canvas frame widget
.RE
.LP
Control Flow:
.RS
.nf
set the canvas frame attribute of cluster to 'canvas'.
.fi
.RE
.NH 3
.Fn clusterCanvasGet()
.Cs
clusterCanvasGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of clusterframe's canvas attribute.
.fi
.RE
.NH 3
.Fn clusterRefreshPut()
.Cs
clusterRefreshPut ( clusterframe, flag )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.IP flag 14
do a refresh? flag
.RE
.LP
Control Flow:
.RS
.nf
set the refresh flag attribute of cluster to 'flag'.
.fi
.RE
.NH 3
.Fn clusterRefreshGet()
.Cs
clusterRefreshGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.IP Returns: 4

.LP
Control Flow:
.RS
.nf
returns the value of clusterframe's refresh attribute.
.fi
.RE
.NH 3
.Fn clusterLabelFramePut()
.Cs
clusterLabelFramePut ( clusterframe, frame )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP frame 14
name of a frame
.RE
.LP
Control Flow:
.RS
.nf
set the labelFrame widget pathname of clusterframe to 'frame'.
.fi
.RE
.NH 3
.Fn clusterLabelFrameGet()
.Cs
clusterLabelFrameGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the labelFrame widget pathname of clusterframe.
.fi
.RE
.NH 3
.Fn clusterLabelPut()
.Cs
clusterLabelPut ( clusterframe, label )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP label 14
label widget pathname
.RE
.LP
Control Flow:
.RS
.nf
set the label widget pathname of clusterframe to 'label'.
.fi
.RE
.NH 3
.Fn clusterLabelGet()
.Cs
clusterLabelGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the label widget pathname of clusterframe.
.fi
.RE
.NH 3
.Fn clusterLabelTextPut()
.Cs
clusterLabelTextPut ( clusterframe, text )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.IP text 14
text of clusterframe's label widget
.RE
.LP
Control Flow:
.RS
.nf
set the text for the label widget of clusterframe to 'text'.
.fi
.RE
.NH 3
.Fn clusterLabelGet()
.Cs
clusterLabelGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the text of clusterframe's label widget.
.fi
.RE
.NH 3
.Fn clusterFooterHeaderPut()
.Cs
clusterFooterHeaderPut ( clusterframe, label )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP label 14
text of clusterframe's footer label
.RE
.LP
Control Flow:
.RS
.nf
set the text for the footer label widget of clusterframe to 'label'.
.fi
.RE

.NH 3
.Fn clusterFooterHeaderGet()
.Cs
clusterFooterHeaderGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the text of clusterframe's footer label widget.
.fi
.RE
.NH 3
.Fn clusterStatusBarFramePut()
.Cs
clusterStatusBarFramePut ( clusterframe, frame )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.IP frame 14
frame widget
.RE
.LP
Control Flow:
.RS
.nf
set the statusBarFrame attribute of cluster to 'frame'.
.fi
.RE
.NH 3
.Fn clusterStatusBarFrameGet()
.Cs
clusterStatusBarFrameGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of clusterframe's statusBarFrame attribute.
.fi
.RE
.NH 3
.Fn clusterStatusBarPut()
.Cs
clusterStatusBarPut ( clusterframe, statusBar )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP statusBar 14
footer label widget pathname
.RE
.LP
Control Flow:
.RS
.nf
set the footer label widget pathname of clusterframe to 'statusBar'.
.fi
.RE
.NH 3
.Fn clusterStatusBarGet()
.Cs
clusterStatusBarGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the footer label widget pathname.
.fi
.RE
.NH 3
.Fn clusterXscrollPut()
.Cs
clusterXscrollPut ( clusterframe, xscroll )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP xscroll 14
x scrollbar widget pathname
.RE
.LP
Control Flow:
.RS
.nf
set the xscrollbar widget pathname of clusterframe to 'xscroll'.
.fi
.RE
.NH 3
.Fn clusterXscrollGet()
.Cs
clusterXscrollGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the xscrollbar widget pathname of clusterframe.
.fi
.RE
.NH 3
.Fn clusterYscrollPut()
.Cs
clusterYscrollPut ( clusterframe, yscroll )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP yscroll 14
y scrollbar widget pathname
.RE
.LP
Control Flow:
.RS
.nf
set the yscrollbar widget pathname of clusterframe to 'yscroll'.
.fi
.RE
.NH 3
.Fn clusterYscrollGet()
.Cs
clusterYscrollGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the yscrollbar widget pathname of clusterframe.
.fi
.RE
.NH 3
.Fn clusterXscrollFramePut()
.Cs
clusterXscrollFramePut ( clusterframe, frame )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP frame 14
frame widget
.RE
.LP
Control Flow:
.RS
.nf
set the xscrollFrame attribute of cluster to 'frame'.
.fi
.RE
.NH 3
.Fn clusterXscrollFrameGet()
.Cs
clusterXscrollFrameGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of clusterframe's xscrollFrame attribute.
.fi
.RE
.NH 3
.Fn clusterYscrollFramePut()
.Cs
clusterYscrollFramePut ( clusterframe, frame )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP frame 14
canvas frame widget
.RE
.LP
Control Flow:
.RS
.nf
set the yscrollFrame attribute of cluster to 'frame'.
.fi
.RE
.NH 3
.Fn clusterYscrollFrameGet()
.Cs
clusterYscrollFrameGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of clusterframe's yscrollFrame attribute.
.fi
.RE
.NH 3
.Fn clusterDisplayWidthPut()
.Cs
clusterDisplayWidthPut ( clusterframe, width )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP width 14
width of display
.RE
.LP
Control Flow:
.RS
.nf
set the displayWidth attribute of clusterframe to 'width'.
.fi
.RE
.NH 3
.Fn clusterDisplayWidthGet()
.Cs
clusterDisplayWidthGet ( clusterframe )
.Ce

.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of the displayWidth attribute of clusterframe.
.fi
.RE
.NH 3
.Fn clusterDisplayHeightPut()
.Cs
clusterDisplayHeightPut ( clusterframe, height )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP height 14
height of display
.RE
.LP
Control Flow:
.RS
.nf
set the displayHeight attribute of clusterframe to 'height'.
.fi
.RE
.NH 3
.Fn clusterDisplayHeightGet()
.Cs
clusterDisplayHeightGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of the displayHeight attribute of clusterframe.
.fi
.RE
.NH 3
.Fn clusterCanvasWidthPut()
.Cs
clusterCanvasWidthPut ( clusterframe, width )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP width 14
width of canvas 
.RE
.LP
Control Flow:
.RS
.nf
set the canvasWidth attribute of clusterframe to 'width'.
.fi
.RE
.NH 3
.Fn clusterCanvasWidthGet()
.Cs
clusterCanvasWidthGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of the canvasWidth attribute of clusterframe.
.fi
.RE
.NH 3
.Fn clusterCanvasHeightPut()
.Cs
clusterCanvasHeightPut ( clusterframe, height )
.Ce

.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.IP height 14
height of canvas
.RE
.LP
Control Flow:
.RS
.nf
set the canvasHeight attribute of clusterframe to 'height'.
.fi
.RE
.NH 3
.Fn clusterCanvasHeightGet()
.Cs
clusterCanvasHeightGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of the canvasHeight attribute of clusterframe.
.fi
.RE
.NH 3
.Fn clusterScrollRegionWidthPut()
.Cs
clusterScrollRegionWidthPut ( clusterframe, width )
.Ce

.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP width 14
width of scrollRegion
.RE
.LP
Control Flow:
.RS
.nf
set the scrollRegionWidth attribute of clusterframe to 'width'.
.fi
.RE
.NH 3
.Fn clusterScrollRegionWidthGet()
.Cs
clusterScrollRegionWidthGet ( clusterframe )
.Ce

.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of the scrollRegionWidth attribute of clusterframe.
.fi
.RE
.NH 3
.Fn clusterScrollRegionHeightPut()
.Cs
clusterScrollRegionHeightPut ( clusterframe, height )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP height 14
height of scrollRegion
.RE
.LP
Control Flow:
.RS
.nf
set the scrollRegionHeight attribute of clusterframe to 'height'.
.fi
.RE
.NH 3
.Fn clusterScrollRegionHeightGet()
.Cs
clusterScrollRegionHeightGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of the scrollRegionsHeight attribute of clusterframe.
.fi
.RE
.NH 3
.Fn clusterXposPut()
.Cs
clusterXposPut ( clusterframe, pos )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP pos 14
width of scrollRegion
.RE
.LP
Control Flow:
.RS
.nf
set the Xpos attribute of clusterframe to 'pos'.
.fi
.RE
.NH 3
.Fn clusterXposGet()
.Cs
clusterXposGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of the Xpos attribute of clusterframe.
.fi
.RE
.NH 3
.Fn clusterYposPut()
.Cs
clusterYposPut ( clusterframe, pos )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP height 14
height of scrollRegion
.RE
.LP
Control Flow:
.RS
.nf
set the Ypos attribute of clusterframe to 'pos'.
.fi
.RE
.NH 3
.Fn clusterYposGet()
.Cs
clusterYposGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of the Ypos attribute of clusterframe.
.fi
.RE
.NH 3
.Fn clusterNextGet()
.Cs
clusterNextGet ( nodeframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
In an array of displayed clusterframes, this returns its neighbor frame to
the right.
.fi
.RE
.NH 3
.Fn clusterNextPut()
.Cs
clusterNextPut ( clusterframe, frame )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP frame 14
a neighboring frame
.RE
.LP
Control Flow:
.RS
.nf
sets clusterframe's neighbor frame to 'frame'.
.fi
.RE
.NH 3
.Fn clusterOffsetWidthPut()
.Cs
clusterOffsetWidthPut ( clusterframe, width )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP width 14
the offset width
.RE
.LP
Control Flow:
.RS
.nf
set the offset width to 'width' of clusterframe.
.fi
.RE
.NH 3
.Fn clusterOffsetWidthGet()
.Cs
clusterOffsetWidthGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the offset width of the clusterframe which  is the value to move
the clusterframe to the right when a refreshDisplay is done. 
.fi
.RE
.NH 3
.Fn clusterMainFramePut()
.Cs
clusterMainFramePut ( clusterframe, frame )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP frame 14
main frame widget
.RE
.LP
Control Flow:
.RS
.nf
set the mainFrame attribute of cluster to 'frame'.
.fi
.RE
.NH 3
.Fn clusterMainFrameGet()
.Cs
clusterMainFrameGet ( clusterframe )
.Ce

.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of clusterframe's mainFrame attribute.
.fi
.RE
.NH 3
.Fn clusterSystemFramePut()
.Cs
clusterSystemFramePut ( clusterframe, frame )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP frame 14
system frame widget
.RE
.LP
Control Flow:
.RS
.nf
set the systemFrame attribute of cluster to 'frame'.
.fi
.RE
.NH 3
.Fn clusterSystemFrameGet()
.Cs
clusterSystemFrameGet ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value of clusterframe's systemFrame attribute.
.fi
.RE
.NH 3
.Fn clusterNodesListPut()
.Cs
clusterNodesListPut( clusterframe, nlist )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.IP nlist 14
list of nodenames in clusterframe
.RE
.LP
Control Flow:
.RS
.nf
set the nodeslist of clusterframe to 'nlist'.
.fi
.RE
.NH 3
.Fn clusterNodesListGet()
.Cs
clusterNodesListGet( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the nodeslist attribute of clusterframe.
.fi
.RE
.NH 3
.Fn clusterTotPoolPut()
.Cs
clusterTotPoolPut( clusterframe, totpool )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.IP totpool 14
# of nodes in the pool of clusterframe 
.RE
.LP
Control Flow:
.RS
.nf
set totpool of clusterframe to 'totpool'.
.fi
.RE
.NH 3
.Fn clusterTotPoolGet()
.Cs
clusterTotPoolGet( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the # of nodes in the pool of clusterframe.
.fi
.RE
.NH 3
.Fn clusterUsePoolPut()
.Cs
clusterUsePoolPut( clusterframe, usepool )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP usepool 14
# of used nodes in the pool of clusterframe 
.RE
.LP
Control Flow:
.RS
.nf
set usepool attribute of clusterframe to 'usepool'.
.fi
.RE
.NH 3
.Fn clusterUsePoolGet()
.Cs
clusterUsePoolGet( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the # of used nodes in the pool of clusterframe.
.fi
.RE
.NH 3
.Fn clusterAvailPoolPut()
.Cs
clusterAvailPoolPut( clusterframe, availpool )
.Ce

.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP availpool 14
# of available nodes in the pool of clusterframe 
.RE
.LP
Control Flow:
.RS
.nf
set availpool attribute of clusterframe to 'availpool'.
.fi
.RE
.NH 3
.Fn clusterAvailPoolGet()
.Cs
clusterAvailPoolGet( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the # of available nodes in the pool of clusterframe.
.fi
.RE
.NH 3
.Fn clusterOfflinePoolPut()
.Cs
clusterOfflinePoolPut( clusterframe, offlpool )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP offlpool 14
# of offline nodes in the pool of clusterframe 
.RE
.LP
Control Flow:
.RS
.nf
set offlpool attribute of clusterframe to 'offlpool'.
.fi
.RE
.NH 3
.Fn clusterOfflinePoolGet()
.Cs
clusterOfflinePoolGet( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the # of offline nodes in the pool of clusterframe.
.fi
.RE
.NH 3
.Fn clusterDownPoolPut()
.Cs
clusterDownPoolPut( clusterframe, downpool )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP downpool 14
# of down nodes in the pool of clusterframe 
.RE
.LP
Control Flow:
.RS
.nf
set downpool attribute of clusterframe to 'downpool'.
.fi
.RE
.NH 3
.Fn clusterDownPoolGet()
.Cs
clusterDownPoolGet( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the # of down nodes in the pool of clusterframe.
.fi
.RE
.NH 3
.Fn clusterReservedPoolPut()
.Cs
clusterReservedPoolPut( clusterframe, rsrvpool )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP rsrvpool 14
# of reserved nodes in the pool of clusterframe 
.RE
.LP
Control Flow:
.RS
.nf
set rsrvpool attribute of clusterframe to 'rsrvpool'.
.fi
.RE
.NH 3
.Fn clusterReservedPoolGet()
.Cs
clusterReservedPoolGet( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the # of reserved nodes in the pool of clusterframe.
.fi
.RE
.NH 3
.Fn clusterUnkPoolPut()
.Cs
clusterUnkPoolPut( clusterframe, unkpool )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP unkpool 14
# of unknown status nodes in the pool of clusterframe 
.RE
.LP
Control Flow:
.RS
.nf
set unkpool attribute of clusterframe to 'unkpool'.
.fi
.RE
.NH 3
.Fn clusterUnkPoolGet()
.Cs
clusterUnkPoolGet( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the # of unknown status nodes in the pool of clusterframe.
.fi
.RE
.NH 3
.Fn clusterCpusAssnPut()
.Cs
clusterCpusAssnPut( clusterframe, cpus_assn )
.Ce
.IP Args: 4
.RS
.IP clusterframe  14
a cluster frame abstraction
.IP cpus_assn 14
# of cpus assigned in clusterframe 
.RE
.LP
Control Flow:
.RS
.nf
set cpus_assn attribute of clusterframe to 'cpus_assn'.
.fi
.RE
.NH 3
.Fn clusterCpusAssnGet()
.Cs
clusterCpusAssnGet( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the # of cpus assigned in clusterframe.
.fi
.RE

.NH 3
.Fn clusterCpusMaxPut()
.Cs
clusterCpusMaxPut( clusterframe, cpus_max )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.IP cpus_max 14
max # of cpus in clusterframe 
.RE
.LP
Control Flow:
.RS
.nf
set cpus_max attribute of clusterframe to 'cpus_max'.
.fi
.RE
.NH 3
.Fn clusterCpusMaxGet()
.Cs
clusterCpusMaxGet( clusterframe )
.Ce

.IP Args: 4
.RS
.IP clusterframe 14
a cluster frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the max # of cpus in clusterframe.
.fi
.RE
.NH 3
.Fn clusterPrint()
.Cs
clusterPrint ( clusterframe )
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
a cluster abstraction
.RE
.LP
Control Flow:
.RS
.nf
prints the values of all the attributes of 'clusterframe'.
.fi
.RE
.NH 3
.Fn clusterCreate()
.Cs
clusterCreate (frame, clusterName, clusterLabel, nlist, footerHeader, viewType)
.Ce
.IP Args: 4
.RS
.IP frame 14
a frame to create the cluster on
.IP clusterName 14
name for the cluster
.IP clusterLabel 14
display label
.IP nlist 14
list of nodes under the cluster
.IP footerHeader 14
the footer string for the cluster
.IP viewType 14
the viewType {ICON, FULL, MIRROR} 
.RE
.LP
Control Flow:
.RS
.nf
foreach node in nlist 
do
        get nodename, nodetype, nodelabel	
	update the cluster status counts
        create the node
        if there's a previous node, set that node's next neighbor to the
                newly-created node.
        keep positioning the nodes in one row of the cluster until you hit
        either one of the following conditions:
                i.  $canvas(clusterNumBoxesPerRow) has been reached
                ii. if adding the new node will result in the
                    $canvas(clusterMaxWidth) to be reached
        Hitting conditions i or ii means to start a new column in the cluster
                frame.
        Record the Xpos and Ypos position of  all the nodes
done

        Create the Xscrollbar
        Create the Yscrollbar
        Create the footer label, frame

        This would shrink the display view if total width is > clusterMaxWidth

        Initialize various attribute values of cluster
        pack xscroll if needed
        pack yscroll if needed
        pack the rest of clusterframe's parts to create a view	
.fi
.RE

.NH 3
.Fn clusterReCreate()
.Cs
clusterReCreate ( frame )
.Ce
.IP Args: 4
.RS
.IP frame 7
the cluster frame to recreate 
.RE
.LP
Control Flow:
.RS
.nf
relabel the display label of the cluster
relabel the footer Label

recreate the nodes of the cluster, by packing in the same as in clusterCreate.
.fi
.RE
.NH 3
.Fn clusterStatsUpdate()
.Cs
clusterStatsUpdate ( clusterf, status, oper )
.Ce
.IP Args: 9
.RS
.IP clusterf 7
the cluster frame to update status counts 
.IP status 7
the status in question
.IP oper 7
the operator (i.e. +, -)
.RE
.LP
Control Flow:
.RS
.nf

Based on the current status, whether be OFFLINE, DOWN, FREE, INUSE_SHARED,
INUSE-EXCLUSIVE, RESERVED, NOINFO, keep track of the various status counts
internally by applying 'oper'.
.fi
.RE
.NH 3
.Fn clusterRepack()
.Cs
clusterRepack (clusterframe)
.Ce
.IP Args: 4
.RS
.IP clusterframe 14
frame to repack
.RE
.LP
Control Flow:
.RS
.nf
Repacking a frame means removing the current frame in view, and redisplaying
it making appropriate adjustments to widths and heights. xscrollbar and
yscrollbar will show up as needed.
.fi
.RE
.NH 2
.Fi system.tk
.LP
This file contains the routines for displaying the site box.
.NH 3
.Fn systemAddWidth()
.Cs
systemAddWidth( systemf, incr )
.Ce
.IP Args: 4
.RS
.IP systemf 9
a system frame abstraction
.IP incr 9
amount to add to the systemf' width
.RE
Control Flow:
.RS
.nf
Adds 'incr' amount to the  systemf's display width, and if the resulting
value is still within the limits, then extend the width of the systemf's
canvas. Update the systemf's scroll region width appropriately.
.fi
.RE
.NH 3
.Fn systemRefreshPut()
.Cs
systemRefreshPut( systemframe, flag )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP flag 13
the refresh flag
.RE
.LP
Control Flow:
.RS
.nf
sets the systemframe's refresh flag to 'flag'. 
.fi
.RE
.NH 3
.Fn systemRefreshGet()
.Cs
systemRefreshGet( systemframe )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
return the systemframe's refresh flag.
.fi
.RE
.NH 3
.Fn systemNamePut()
.Cs
systemNamePut( systemframe, name )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP name 13
name associated with systemframe
.RE
.LP
Control Flow:
.RS
.nf
sets the systemframe's name to 'name'. 
.fi
.RE
.NH 3
.Fn systemNameGet()
.Cs
systemNameGet( systemframe )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
return the systemframe's name attribute.
.fi
.RE
.NH 3
.Fn systemNodeFramePut()
.Cs
systemNodeFramePut ( systemframe, nodename, frame, frametype )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a node enclosed inside a systemframe
.IP frame 13
frame widget pathname
.IP frametype 13
type of frame (ICON, FULL, MIRROR)
.RE
.LP
Control Flow:
.RS
.nf
sets the frame enclosed in systemframe for nodename to 'frame' with 'frametype'.
.fi
.RE
.NH 3
.Fn systemNodeFrameGet()
.Cs
systemNodeFrameGet ( systemframe, nodename, frametype  )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a node enclosed inside a systemframe
.IP frametype 13
type of frame (ICON, FULL, MIRROR)
.RE
.LP
Control Flow:
.RS
.nf
returns the frame enclosed in systemframe for nodename of 'frametype'.
.fi
.RE
.NH 3
.Fn systemNodeFrameUnset()
.Cs
systemNodeFrameUnset ( systemframe, nodename, frametype )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a node enclosed inside a systemframe
.IP frametype 13
type of frame (ICON, FULL, MIRROR)
.RE
.LP
Control Flow:
.RS
.nf
deallocates storage used for saving the 'frame' of 'nodename' on 'systemframe'.
.fi
.RE
.NH 3
.Fn systemNodeStatusPut()
.Cs
systemNodeStatusPut ( systemframe, nodename, stat )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a node enclosed inside a systemframe
.IP stat 13
status (i.e. UP, DOWN, OFFLINE, RESERVED, NOINFO, INUSE)
.RE
.LP
Control Flow:
.RS
.nf
sets the status of nodename under systemframe to 'stat'.
.fi
.RE
.NH 3
.Fn systemNodeStatusGet()
.Cs
systemNodeStatusGet ( systemframe, nodename )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a node enclosed inside a systemframe
.RE
.LP
Control Flow:
.RS
.nf
returns the status of nodename under systemframe.
.fi
.RE
.NH 3
.Fn systemNodeStatusUnset()
.Cs
systemNodeStatusUnset ( systemframe, nodename )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a node enclosed inside a systemframe
.RE
.LP
Control Flow:
.RS
.nf
deallocates the storage used for saving the status information for nodename
at systemframe.
.fi
.RE
.NH 3
.Fn systemNodeNamesGet()
.Cs
systemNodeNamesGet ( systemframe )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the list of nodes known under 'systemframe'.
.fi
.RE
.NH 3
.Fn systemNodeInfoPut()
.Cs
systemNodeInfoPut ( systemframe, nodename, info )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a name of the node enclosed by systemframe
.IP info 13
information about the node 
.RE
.LP
Control Flow:
.RS
.nf
sets the information about the node known by 'nodename' in 'systemframe' to
 'info'.
.fi
.RE

.NH 3
.Fn systemNodeInfoAppend()
.Cs
systemNodeInfoAppend ( systemframe, nodename, info )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a name of the node enclosed by systemframe
.IP info 13
information about the node 
.RE
.LP
Control Flow:
.RS
.nf
appends the information 'info' for the node known by 'nodename' in
 'systemframe'.
.fi
.RE
.NH 3
.Fn systemNodeInfoGet()
.Cs
systemNodeInfoGet ( systemframe, nodename )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a name of the node enclosed by systemframe
.RE
.LP
Control Flow:
.RS
.nf
returns information about the node 'nodename' under 'systemframe'.
.fi
.RE
.NH 3
.Fn systemNodeInfoUnset()
.Cs
systemNodeInfoUnset ( systemframe, nodename )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a name of the node enclosed by systemframe
.RE
.LP
Control Flow:
.RS
.nf
deallocates the storage used for saving the information for nodename
at systemframe.
.fi
.RE
.NH 3
.Fn systemNodeInfo2Append()
.Cs
systemNodeInfo2Append ( systemframe, nodename, info )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a name of the node enclosed by systemframe
.IP info 13
information about the node 
.RE
.LP
Control Flow:
.RS
.nf
appends the information 'info' for the node known by 'nodename' in
 'systemframe'.
.fi
.RE
.NH 3
.Fn systemNodeInfo2Get()
.Cs
systemNodeInfo2Get ( systemframe, nodename )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a name of the node enclosed by systemframe
.RE
.LP
Control Flow:
.RS
.nf
returns information about the node 'nodename' under 'systemframe'.
.fi
.RE
.NH 3
.Fn systemNodeInfo2Unset()
.Cs
systemNodeInfo2Unset ( systemframe, nodename )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP nodename 13
a name of the node enclosed by systemframe
.RE
.LP
Control Flow:
.RS
.nf
deallocates the storage used for saving the information for nodename
at systemframe.
.fi
.RE
.NH 3
.Fn systemNodeTypePut()
.Cs
systemNodeTypePut ( systemframe, hostname, type )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP hostname 13
a name of a host
.IP type 13
type of host/node
.RE
.LP
Control Flow:
.RS
.nf
sets the hostname at systemframe's type to 'type'.
.fi
.RE
.NH 3
.Fn systemNodeTypeGet()
.Cs
systemNodeTypeGet ( systemframe, hostname )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP hostname 13
a name of a host
.RE
.LP
Control Flow:
.RS
.nf
returns the 'type' of hostname at systemframe.
.fi
.RE
.NH 3
.Fn systemClusterFramePut()
.Cs
systemClusterFramePut( systemframe, name, frame )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP name 13
a name of a node
.IP frame 13
frame widget
.RE
.LP
Control Flow:
.RS
.nf
sets the node name under systemframe to 'frame'.
.fi
.RE
.NH 3
.Fn systemClusterFramGet()
.Cs
systemClusterFramGet( systemframe, name )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP name 13
a name of a node
.RE
.LP
Control Flow:
.RS
.nf
returns the cluster frame of node named by 'name' under systemframe.
.fi
.RE
.NH 3
.Fn systemClusterFrameUnset()
.Cs
systemClusterFrameUnset ( systemframe, name )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP name 13
a name of a node
.RE
.LP
Control Flow:
.RS
.nf
deallocates the storage used to save the cluster frame of node named 'name'
under 'systemframe'. 
.fi
.RE
.NH 3
.Fn systemClusterNamesGet()
.Cs
systemClusterNamesGet ( systemframe )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the list of names for the clusterframe known to 'systemframe'.
.fi
.RE
.NH 3
.Fn systemCanvasPut() 
.Cs
systemCanvasPut( systemframe, frame ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP frame 13
frame widget pathname
.RE
.LP
Control Flow:
.RS
.nf
sets the canvas attribute of 'systemframe' to 'frame'.
.fi
.RE
.NH 3
.Fn systemCanvasGet() 
.Cs
systemCanvasGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the canvas attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemDisplayWidthPut() 
.Cs
systemDisplayWidthPut( systemframe, width ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP width 13
width in pixels
.RE
.LP
Control Flow:
.RS
.nf
sets the displayWidth attribute of 'systemframe' to 'width'.
.fi
.RE
.NH 3
.Fn systemDisplayWidthGet() 
.Cs
systemDisplayWidthGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the displayWidth attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemDisplayHeightPut() 
.Cs
systemDisplayHeightPut( systemframe, height) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP height 13
height in pixels 
.RE
.LP
Control Flow:
.RS
.nf
sets the displayHeight attribute of 'systemframe' to 'height'.
.fi
.RE
.NH 3
.Fn systemDisplayHeightGet() 
.Cs
systemDisplayHeightGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the displayHeight attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemScrollRegionWidthPut() 
.Cs
systemScrollRegionWidthPut( systemframe, width ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP width 13
width in pixels
.RE
.LP
Control Flow:
.RS
.nf
sets the scrollRegionWidth attribute of 'systemframe' to 'width'.
.fi
.RE
.NH 3
.Fn systemScrollRegionWidthGet() 
.Cs
systemScrollRegionWidthGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe
a system frame abstraction
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
returns the value to the scrollRegionWidth attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemScrollRegionHeightPut() 
.Cs
systemScrollRegionHeightPut( systemframe, height) 
.Ce
.IP Args: 4
.RS
.IP systemframe
a system frame abstraction
.IP height
height in pixels 
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
sets the scrollRegionHeight attribute of 'systemframe' to 'height'.
.fi
.RE
.NH 3
.Fn systemScrollRegionHeightGet() 
.Cs
systemScrollRegionHeightGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the scrollRegionHeight attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemCanvasFrameWidthPut() 
.Cs
systemCanvasFrameWidthPut( systemframe, width ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP width 13
width in pixels
.RE
.LP
Control Flow:
.RS
.nf
sets the canvasFrameWidth attribute of 'systemframe' to 'width'.
.fi
.RE
.NH 3
.Fn systemCanvasFrameWidthGet() 
.Cs
systemCanvasFrameWidthGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the canvasFrameWidth attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemCanvasFrameHeightPut() 
.Cs
systemCanvasFrameHeightPut( systemframe, height) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP height 13
height in pixels 
.RE
.LP
Control Flow:
.RS
.nf
sets the canvasFrameHeight attribute of 'systemframe' to 'height'.
.fi
.RE
.NH 3
.Fn systemCanvasFrameHeightGet() 
.Cs
systemCanvasFrameHeightGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the canvasFrameHeight attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemCanvasWidthPut() 
.Cs
systemCanvasWidthPut( systemframe, width ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP width 13
width in pixels
.RE
.LP
Control Flow:
.RS
.nf
sets the canvasWidth attribute of 'systemframe' to 'width'.
.fi
.RE
.NH 3
.Fn systemCanvasWidthGet() 
.Cs
systemCanvasWidthGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the canvasWidth attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemCanvasHeightPut() 
.Cs
systemCanvasHeightPut( systemframe, height) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP height 13
height in pixels 
.RE
.LP
Control Flow:
.RS
.nf
sets the canvasHeight attribute of 'systemframe' to 'height'.
.fi
.RE
.NH 3
.Fn systemCanvasHeightGet() 
.Cs
systemCanvasHeightGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
returns the value to the canvasHeight attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemScrollWidthPut() 
.Cs
systemScrollWidthPut( systemframe, width ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP width 13
width in pixels
.RE
.LP
Control Flow:
.RS
.nf
sets the scrollWidth attribute of 'systemframe' to 'width'.
.fi
.RE
.NH 3
.Fn systemScrollWidthGet() 
.Cs
systemScrollWidthGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the scrollWidth attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemScrollHeightPut() 
.Cs
systemScrollHeightPut( systemframe, height) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP height 13
height in pixels 
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
sets the scrollHeight attribute of 'systemframe' to 'height'.
.fi
.RE
.NH 3
.Fn systemScrollHeightGet() 
.Cs
systemScrollHeightGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the scrollHeight attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemLabelWidthPut() 
.Cs
systemLabelWidthPut( systemframe, width ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP width 13
width in pixels
.RE
.LP
Control Flow:
.RS
.nf
sets the labelWidth attribute of 'systemframe' to 'width'.
.fi
.RE
.NH 3
.Fn systemLabelWidthGet() 
.Cs
systemLabelWidthGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the labelWidth attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemLabelHeightPut() 
.Cs
systemLabelHeightPut( systemframe, height) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP height 13
height in pixels 
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
sets the labelHeight attribute of 'systemframe' to 'height'.
.fi
.RE
.NH 3
.Fn systemLabelHeightGet() 
.Cs
systemLabelHeightGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the labelHeight attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemFooterWidthPut() 
.Cs
systemFooterWidthPut( systemframe, width ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP width 13
width in pixels
.RE
.LP
Control Flow:
.RS
.nf
sets the footerWidth attribute of 'systemframe' to 'width'.
.fi
.RE
.NH 3
.Fn systemFooterWidthGet() 
.Cs
systemFooterWidthGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the footerWidth attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemFooterHeightPut() 
.Cs
systemFooterHeightPut( systemframe, height) 
.Ce
.IP Args: 4
.RS
.IP systemframe 
a system frame abstraction
.IP height
height in pixels 
.RE
.LP
Control Flow:
.RS
.nf
sets the footerHeight attribute of 'systemframe' to 'height'.
.fi
.RE
.NH 3
.Fn systemFooterHeightGet()
.Cs
systemFooterHeightGet( systemframe ) 
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the value to the footerHeight attribute of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemXscrollPut()
.Cs
systemXscrollPut( systemframe, xscroll )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP xscroll 13
xscrollbar widget pathname 
.RE
.LP
Control Flow:
.RS
.nf
sets systemframe's Xscroll attribute to 'xscroll'.
.fi
.RE
.NH 3
.Fn systemXscrollGet()
.Cs
systemXscrollGet( systemframe )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the systemframe's Xscroll attribute.
.fi
.RE
.NH 3
.Fn systemYscrollPut()
.Cs
systemYscrollPut( systemframe, yscroll )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP xscroll 13
xscrollbar widget pathname 
.RE
.LP
Control Flow:
.RS
.nf
sets systemframe's Yscroll attribute to 'yscroll'.
.fi
.RE
.NH 3
.Fn systemYscrollGet()
.Cs
systemYscrollGet( systemframe )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the systemframe's Yscroll attribute.
.fi
.RE
.NH 3
.Fn systemServerNamesPut()
.Cs
systemServerNamesPut( systemframe, serverl )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP serverl 13
list of servers
.RE
.LP
Control Flow:
.RS
.nf
sets systemframe's servers attribute to 'serverl'.
.fi
.RE
.NH 3
.Fn systemServerNamesGet()
.Cs
systemServerNamesGet( systemframe )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
returns the systemframe's servers attribute.
.fi
.RE
.NH 3
.Fn systemPrint()
.Cs
systemPrint ( systemframe )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
prints the values of all the attributes of 'systemframe'.
.fi
.RE
.NH 3
.Fn systemNodesCreate()
.Cs
systemNodesCreate( systemframe, systemName )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system frame abstraction
.IP systemName 13
name assigned to the system
.RE
.LP
Control Flow:
.RS
.nf
foreach server under systemName 
do
        get server cluster label, nodeslist

        create the server cluster frame
        if there's a previous cluster, set that cluster's next neighbor to the
                 newly-created cluster.
        keep positioning the nodes in one row of the cluster until you hit
        either one of the following conditions:
                i.  $canvas(systemNumBoxesPerRow) has been reached
                ii. if adding the new cluster will result in the
                    $canvas(systemMaxWidth) to be reached
        Hitting conditions i or ii means to start a new column in the cluster
                frame.
        Record the Xpos and Ypos position of  each cluster
done
        call systemServerNamesPut() for the list of servers that at least
        has one node.

        Create the Xscrollbar
        Create the Yscrollbar
        Create the footer label, frame

        This would shrink the display view if total width is > clusterMaxWidth
        Also, it will try to adjust the display to fit all labelWidth and/or
        footerWidth up to clusterMaxWidth 

        Initialize various attribute values of system
        pack xscroll if needed
        pack yscroll if needed
        pack the rest of systemframe's parts to create a view	
.fi
.RE
.NH 3
.Fn systemNodesReCreate()
.Cs
systemNodesReCreate( systemframe )
.Ce
.IP Args: 4
.RS
.IP systemframe 13
a system abstraction
.RE
.LP
Control Flow:
.RS
.nf
redisplay the nodelabel text.  
reconfigure the nodeframe's canvas' width and height and scroll regions.
update the node's status when needed.
reconfigure the xscrollbar and the yscrollbar and redisplaying them or
removing them from view when needed.

Finally, resize the display width and height depending on the new sizes of
maxWidth and maxHeight.

If viewType is ICON, then cover the contents of the canvas.
.fi
.RE
.NH 3
.Fn systemRepack()
.Cs
systemRepack ( frame )
.Ce
.IP Args: 4
.RS
.IP frame 13
the system frame to redisplay
.RE
.LP
Control Flow:
.RS
.nf
relabel the display label of the system

display x scroll and yscroll and recalculate appropriate widths and heights. 
.fi
.RE
.NH 3
.Fn systemDelete()
.Cs
systemDelete( sysframe )
.Ce
.IP Args: 4
.RS
.IP sysframe 13
a system frame abstraction.
.RE
.LP
Control Flow:
.RS
.nf
destroys the 'sysframe' and deallocates all storage associated with 'sysframe'.
.fi
.RE
.NH 3
.Fn systemAdjustNodesDistances()
.Cs
systemAdjustNodesDistances ( sysframe )
.Ce
.IP Args: 4
.RS
.IP sysframe 13
a system frame abstraction.
.RE
.LP
Control Flow:
.RS
.nf
foreach nframe enclosed under sysframe,
do
        move the nframe by offset width (as carried in the nodeframe's
                                                         list of properties)
        update the Xpos property of nodeframe
        reset nodeframe's offsetWidth to 0
done

foreach clusterframe enclosed under sysframe,
do
        move the clusterframe by offset width (as carried in the nodeframe's
                                                            list of prorties)
        update the Xpos property of clusterframe
        reset clusterframe's offsetWidth to 0
done
.fi
.RE
.NH 3
.Fn systemRefreshDisplay()
.Cs
systemRefreshDisplay( sysframe )
.Ce
.IP Args: 4
.RS
.IP sysframe 13
a system frame abstraction.
.RE
.LP
Control Flow:
.RS
.nf
foreach nodeframe that belongs to sysframe,
do
         if nodeframe's refresh flag is set to TRUE, then
                do a nodeRepack
                set clusterRefresh flag of the clusterframe where nodeframe
                belongs to to TRUE 
                set systemRefresh flag of the systemframe where nodeframe
                belongs to to TRUE 
                reset nodeframe's refresh flag to 0
         fi

done
foreach clusterframe that belongs to sysframe,
do
        if clusterframe's refresh flag is set to TRUE, then
                do a clusterRepack
                set systemRefresh flag of the systemframe where clusterframe
                belongs to to TRUE 
                reset clusterframe's refresh flag to 0
        fi
done

if systemframe's refresh flag is set to TRUE, then
         do a systemRepack
fi
.fi
.RE
.NH 3
.Fn systemDisplayClusterStatus()
.Cs
systemDisplayClusterStatus (sysframe, cname)
.Ce
.IP Args: 4
.RS
.IP sysframe 13
a system frame abstraction.
.IP cname 13
cluster name that belongs to sysframe
.RE
.LP
Control Flow:
.RS
.nf
displays in the cluster identified by cname the values for usepool, availpool,
totpool, offlpool, downpool, rsvpool, unkpool.
.fi
.RE
.NH 3
.Fn systemAddWidth()
.Cs
systemAddWidth( systemf, incr )
.Ce
.IP Args: 4
.RS
.IP systemf 13
a system frame abstraction
.IP incr 13
amount to add to the clusterf' width
.RE
.LP
Control Flow:
.RS
.nf
Adds 'incr' amount to the  systemf's display width and canvas width, and if the
resulting values are still within the systemMaxWidth, then update the
systemf's scroll region width appropriately.
.fi
.RE
.NH 3
.Fn systemUpdateInUse()
.Cs
systemUpdateInUse( systemf, n, jobslist )
.Ce
.IP Args: 4
.RS
.IP systemf 10
a system frame abstraction
.IP n 10
the name of the node
.IP jobslist
format: { {{....} {Jobs: X USER:  Y JID:} NODEJOB} } 
.RE
.LP
Control Flow:
.RS
.nf
    Get the Y part in 'jobslist',
          if its value  is empty,
                  set it to 0
          fi

          if Y valus is 1, then update node status to INUSE-EXCLUSIVE,
          else if Y value > 1, then update node status to INUSE-SHARED.  
.fi
.RE
.NH 3
.Fn systemGetJobsInfo()
.Cs
systemGetJobsInfo (sysframe, server_name)
.Ce
.IP Args: 4
.RS
.IP sysframe 13
a system frame abstraction
.IP server_name 13
name of the server to get jobs information from
.RE
.LP
Control Flow:
.RS
.nf
create a lookup table of all the nodes/execution hostnames known to
 'sysframe'.

get the clusterframe of 'server_name'
issue a pbsconnect to the server
if connect was successful, then
        post a pbsstatserv
        if got back "resources_max.ncpus", then
                        save value to cpusMax
                        property of clusterframe
        fi

        post a pbsstatjob
        foreach job 
        do
                initialize user, state, hostlist, ncpus buffers

                if job_state is not RUNNING then go to the next job 
                if got back "Job_Owner", then save value to user buffer
                if got back "job_state", then save value to state buffer
                if got back "exec_host", then save value to hostlist buffer
                if got back "resources_used.nodes", then save list of nodes
                                                          to nodeslist buffer
                if got back "Resource_List.ncpus", then save value to ncpus
                                                                      buffer,
                increment cpus_assn by ncpus value
                set list of execution hosts assigned to the job to
                        nodeslist value (yes, this takes precedence) if it
                        exists; otherwise use the hostlist value

                go through each of the execution hosts assigned to the job,
                        and build the jobs table:
                                    jobs(hostname@user) <list of jobids>
        done

        disconnect from server_name
fi

foreach elem in jobs table,
do
       build the nodejobs table:
                   nodejobs(hostname) 
                         "user1 <list of jobids>","user2 <list of jobids>",...
       build the arrays:
                njobs(hostname) <number of jobs on hostname>
                nusers(hostname) <number of users assigned with hostname>
done

foreach hostname in nodejobs table,
do

        append the node information of hostname with the info:
                nodeinfo(hostname): 
                     $nodejobs(hostname): "list of (user, jobids) on hostname"	
                     header: "nusers(hostname) USER(s) njobs(hostname) JIDs: "
                     type: NODEJOB

        update the node INUSE status of hostname if its type is != MOM_SNODE
             because in this case, its associated server will update the
             status.
done

if clusterframe of server_name exists, then
         save cpus_assn value to cpusAssn property of clusterframe
fi
.fi
.RE

.NH 3
.Fn systemPopulateNodesWithInfo()
.Cs
systemPopulateNodesWithInfo( sysframe, create )
.Ce
.IP Args: 4
.RS
.IP sysframe 13
a system frame abstraction
.IP create 13
the create flag
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
unset node INUSE colors mapping
unset nodeinfo, nodeinfo2 saved values for each node known to the system

get a new list of nodes from each of the server

foreach server_names known to sysframe,
do
	if server has known nodes in it; then 
            get the jobs information from it,
        fi
done

foreach node known to sysframe 
do
        get nodejob info, nodestat, nodetype

        if nodetype is NOMOM, then
                mark node FREE if current stat is INUSE-EXCLUSIVE or
                                  INUSE-SHARED but no jobs running on it.  
                put 'nodeinfo2' (i.e. static attributes) as the node's info
                    to be displayed 
        else if nodetype is NOMOM_SNODE, then
                put 'nodeinfo2' (i.e. static attributes) as the node's info
                    to be displayed 
                *** no need to update its status; server's statnodes will
                *** update this
        else if nodetype is MOM, then
                mark node NOINFO if current stat is INUSE-EXCLUSIVE or
                                  INUSE-SHARED but no jobs running on it.  

                open a connection to the node's MOM
                if unsuccessful opening the connection, mark node as DOWN
                if successful, then
                       get status of this time-sharing node which should
                       return one of {DOWN, FREE, NOINFO}
                            if status is FREE,
                            then
                                send queries and
                                save the results in the nodeInfo property of
                                node at sysframe
                            else if status is NOINFO,
                            then
                                simply update the node's INUSE status depending
                                on whether is job is running on it or not.
                            fi
                       close fd to MOM
                fi
        else if nodetype is MOM_SNODE, then
                open a connection to the node's MOM
                if successful connection, then
                       get status of this node which should
                       return one of {DOWN, FREE, NOINFO}
                            if status is FREE,
                            then
                                send queries and
                                save the results
                            else if status is NOINFO,
                            fi
                       close fd to MOM
                fi
                put in as 'nodeinfo' property to be displayed the static
                    attribute values, results of the queries sent (if any),
                    and the list of jobs running on it.
        fi

        get the node information (via the nodeInfo property),
        if something exists, then
                display it on the fullnodeFrame, and mirrornodeFrame
        else
                simply remove all the items currently displayed on the node
                canvas
done

display the cluster status information for each of the clusterframe's known
to sysframe

.fi
.RE
.NH 2
.Fi pbs.tk
.LP
This file contains routines that access some of the functionalities of PBS.
.NH 3
.Fn getNodesList()
.Cs
getNodesList( sitename, host, nodesq )
.Ce
.IP Args: 4
.RS
.IP sitename 10
name of a particular site (actually a system name).
.IP host 10
host that holds some nodes/inuse file
.IP nodesq 10
the query to send that returns a list of nodes.
.RE
.LP
Control Flow:
.RS
.nf
get the list of nodes from host using the query 'nodesq', and using the openrm,
addreq, getreq, closeerm calls to obtain the result.
.fi
.RE
.NH 3
.Fn TSgetStatus()
.Cs
TSgetStatus( fd, sysframe, nodename, update )
.Ce
.IP Args: 4
.RS
.IP fd 13
descriptor to MOM
.IP sysframe 13
system frame that holds the frame of nodename
.IP nodename 13
a node's name
.IP update 13
a flag signalling whether or not to update the 'nodename's internal status flag 
.RE
.LP
Control Flow:
.RS
.nf
get the status of nodename that is of type time-sharing. 
Basically, an "arch" query is sent to the node's MOM. 
If sending the query was unsuccessful, then we assume
      node is DOWN.

If the query was sent successfully, get its result.
  i. If the result is bad (empty string returned), then
       node is DOWN
  ii. if the result is caused by the MOM not recognizing the query, then
       node has NOINFO
  iii. If neither i and ii, then mark node as FREE.
end
.fi
.RE
.NH 3
.Fn sendTSQueries()
.Cs
sendTSQueries (fd, sitename, nodename)
.Ce
.IP Args: 4
.RS
.IP fd 10
the port to MOM
.IP sitename 10
name of a site where node sending query belongs to
.IP nodename 10
name of the node
.RE
.LP
Control Flow:
.RS
.nf
foreach elem in queryTable($sitename, $nodename),

        foreach operand in an elem's query expression,
               if it is a query string, then
                        save the "operand, row, col" information to queryIdxList
                        sends the operand as query request to port $fd
               end
               increment col count
        done
        increment row count

done	
return queryIdxList
.fi
.RE
.NH 3
.Fn recvResponses()
.Cs
recvResponses (fd, sitename, nodename, querylist)
.Ce
.IP Args: 4
.RS
.IP fd 11
port to MOM
.IP sitename 11
name of the site where node running MOM belongs to
.IP nodename 11
name of the node
.IP querylist 11
list of queries (and additional info) to get response from
.RE
.LP
Control Flow:
.RS
.nf
create a mirror queryTable.

foreach elem querylist
do
	get the corresponding result from the fd
	if the result is invalid, set result to ""

	foreach (row, col) indices in the current element,
	do
		get the row-th element of the mirror queryTable. From this,
		  obtain the qexpr, header, type
		replace the row-th element's col value to the result of the
			query  
		recreate the mirror table with the modified element value
	done
done

return the mirror queryTable
.fi
.RE
.NH 2
.Fi expr.tk
.LP
This file contains routines that support query expression evaluation when
data has been gathered from appropriate PBS moms.
.NH 3
.Fn isNumber()
.Cs
isNumber ( str, number )
.Ce
.IP Args: 4
.RS
.IP str 8
a string representation of a size number that can contain the characters
kmgtpKMGTP]?[bwBW]?
.IP number 8
the extracted number from the string.
.RE
.IP Returns: 4
1 if str is a number and also returns in 'number' the value
not containing the units [kmgtpKMGTP]?[bwBW]?; 0 otherwise
.LP
.NH 3
.Fn isFloat()
.Cs
isFloat( str )
.Ce
.IP Args: 4
.RS
.IP str 5
a string representation of a size number that can contain the
characters,  kmgtpKMGTP]?[bwBW]?.
.RE
.IP Returns: 4
 1 if str is a float number (contains a .); 0 otherwise.
.LP
.NH 3
.Fn isSingleOp()
.Cs
isSingleOp ( str )
.Ce
.IP Args: 4
.RS
.IP str 5
a string representation of a TCL operator
.RE
.IP Returns: 4
.RS
.nf
     1 if is a single-character operator name;
     2 if the single-char operator name could potentially be an
          incomplete name (i.e. < for <=),
     0 if not a single-operator at all!
            Single operators: -,~,*,/,%,+,^,(,)
            incomplete opers: <,>|,&,=,,|
.fi
.RE
.NH 3
.Fn isDoubleOp()
.Cs
isDoubleOp ( str )
.Ce
.IP Args: 4
.RS
.IP str 5
a string representation of a TCL operator
.RE
.IP Returns: 4
.RS
.nf
	1 if 'str' represents a double character operator;
	0 otherwise

	Double character operators: <<, <=, >>, >=, ==, !=, &&, ||   
.fi
.RE
.LP
.NH 3
.Fn isQueryString()
.Cs
isQueryString( str )
.Ce
.IP Args: 4
.RS
.IP str 5
a string representation of a TCL operator
.RE
.LP
Control Flow:
.RS
.nf
      A query string is anything that is not an operator and it is not a
      constant number (real or int).
.fi
.RE
.LP
.NH 3
.Fn queryExprCreate()
.Cs
queryExprCreate( str )
.Ce
.IP Args: 4
.RS
.IP str 5
a query expression 
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
Parses a str (e.g. "(loadave/ncpus * 100)") and returns a list containing
each of the tokens of the expression.

expr - holds the return value for this procedure
val - holds the current character value
sval - holds set-of-chars that represents operators that are yet-to-be
	completed
hval - a buffer that holds items that are yet to be completed
foreach char in 'str';

        if char is a space (" "), then
               if there's something in the hval buffer, then  append them
                       to the expr list, clear hval 
               go to the next iteration
        end

        append char to val which holds the current set-of-chars)
 
        if current set-of-chars is a single character operator, then
                if there's something in the hval buffer, then  append them
                        to the expr list, clear hval 
                append this current set-of-chars char (which should only
                        contain 1 char) into expr list, clear the val buffer
                        which holds the current-set-of-chars
        else if current set-of-chars is a single char that represents an
                operator that is yet to be completed, then
                        if there's something in the hval buffer, then  append
                                 them to the expr list, clear hval 
                        save the 1 character into the sval buffer
        else if current set-of-chars represents a double-character operator,then
                append these set-of-chars to expr list
                clear all buffers: hval, val, sval  
        else (we have a set-of-chars that is not an operator), then,
                if there's something in the yet-to-be-completed operator sval,
                                                                           then
                        append them to expr list
                        clear sval
                        set hval to 2nd char of val since the first character
                                had already been saved to expr list via sval
                else
                        append current set-of-chars to hval
                        clear val buffer
                end
        end
		
        process remaining items: append hval to expr list if not empty

        return expr list
.fi
.RE
.LP
.NH 3
.Fn fltround()
.Cs
fltround (val,precision)
.Ce
.IP Args: 4
.RS
.IP val 11
a floating point value
.IP precision 11
number of places after the "."
.RE
.LP
Control Flow:
.RS
.nf
This rounds 'val' so that at most 'precision' number of digits would appear
after ".".
.fi
.RE
.LP
.NH 3
.Fn evaluateExpr()
.Cs
evaluateExpr( expr )
.Ce
.IP Args: 4
.RS
.IP expr
a query expression
.RE
.IP Returns: 4
Given a query expression, evaluate it, substitute query values for
query strings, and return the new expression.
.LP
Control Flow:
.RS
.nf
if the # of items in expr is <= 1; then
	simply return the expr

Get the operands of the expression and saved it in 'operand'

while operand (a char in the expression) != ""; 
do
        if operand is "/" ; then  ensure that no fraction parts are lost by:
                insert "double "(" after "/"
                go through the rest of the expr, and try to match "(", and ")"
                        and stop matching when all pending matches have been
                        satisfied.
                insert matching ")" 
                else if operand is a number ; then
                replace the operand's value in expr to a proper value
                      (i.e. remove size suffixes, etc...)
                if it is a floating point number, then
                      set hasFloat flag	
	
        get next operand (from where this loop started so yes, some of the
                elements may be parsed over again)
done

Now evaluate (execute) the parsed expr and save result in val

if execution was successful,
        return val ("rounded float") directly if hasFloat
        otherwise, return round(ceil($val))
if execution was unssuccessful,
        return an empty string
.fi
.RE
.NH 2
.Fi common.tk
.LP
This file ocntains general-purpose routines used by the \f3xpbsmon\fP utility.
.NH 3
.Fn listcomp()
.Cs
listcomp( list1, list2 )
.Ce
.IP Args: 4
.RS
.IP list1 7
TCL list 1
.IP list2 7
TCL list 2
.RE
.LP
Control Flow:
.RS
.nf
if lengths of list1 and list2 don't match, then return 1

matches each element of list1 to corresponding element at list2 and if they're
the same, return 0.
Otherwise, return 1.
.fi
.RE
.NH 3
.Fn InfoBox_flush()
.Cs
InfoBox_flush( start_line )
.Ce
.IP Args: 4
.RS
.IP start_line 12
starting line of the info listbox
.RE
.LP
Control Flow:
.RS
.nf
deletes lines starting at 'start_line' for info listbox.
.fi
.RE
.NH 3
.Fn stackPush()
.Cs
stackPush( element )
.Ce
.IP Args: 4
.RS
.IP element 8
an item to add to stack
.RE
.LP
Control Flow:
.RS
.nf
This is a local implementation of the push operator of a stack ADT.
.fi
.RE
.NH 3
.Fn stackPop()
.Cs
stackPop()
.Ce
.LP
Control Flow:
.RS
.nf
This is a local implementation of the pop operator of a stack ADT.
.fi
.RE
.NH 3
.Fn isStackEmpty()
.Cs
isStackEmpty()
.Ce
.IP Returns: 4
1 if stack is empty; 0 otherwise
.NH 3
.Fn stackClear()
.Cs
stackClear()
.Ce
.LP
Control Flow:
.RS
.nf
Deletes all the items in a stack ADT.
.fi
.RE
.NH 3
.Fn stackPrint()
.Cs
stackPrint()
.Ce
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
Prints the elements of a stack.
.fi
.RE
.NH 3
.Fn addLlist()
.Cs
addLlist (llist, key, row, col)
.Ce
.IP Args: 4
.RS
.IP llist 7
a list of lists
.IP key 7
a list's key element
.IP row 7
a row value of a list element in llist
.IP col 7
a key value of a list element in llist
.RE
.IP Returns: 4
1 if a new {key row col} was added; 0 if an existing element was modified.
.LP
Control Flow:
.RS
.nf
NOTE: This modifies the original 'llist'.
Basically, an llist element looks like:

      {key row1 col1 row2 col2 ... ...}
This adds the new elements {row col} if an element of the list matches the
 'key'; otherwise, append {key row col} to llist.
.fi
.RE
.NH 3
.Fn cleanstr()
.Cs
cleanstr(str)
.Ce
.IP Args: 4
.RS
.IP str 5
a string of characters.
.RE
.LP
Control Flow:
.RS
.nf
removes any characters in string that could be a problem under TCL like
"[]" which signifies an execute action, as well as the global
sysinfo(rcSiteInfoDelimeterChar) input separator. 
.fi
.RE
.NH 2
.Fi color.tk
.LP
This file contains functions supporting the color bar.
.NH 3
.Fn getNextNodeColorInUse()
.Cs
getNextNodeColorInUse()
.Ce
.LP
Control Flow:
.RS
.nf
Returns:
        the next color to use to mark a single-user INUSE node canvas. 


        get current value of canvas(nodeColorINUSE_index), increment it by 1,
                and get the modulus over the # of colors in
                canvas(nodeColorINUSEexclusive). The effect is that after the
                last color on the list has been returned, then it will go back
                and reselect colors from the beginning of the list.
.fi
.RE
.NH 3
.Fn assignNodeColorInUse()
.Cs
assignNodeColorInUse (job, defcolor)
.Ce
.IP Args: 4
.RS
.IP joblist 10
job info in the form "user.jobid"
.IP defcolor 10
default color 
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
if a color has already been assigned to job, then set retcolor to it	
otherwise,
        set retcolor to defcolor if one exists; otherwise, getNextColorInUse
        assign this new retcolor to job
fi

update the colorCnt of the job
.fi
.RE
.NH 3
.Fn unsetNodeColorInUseMapping()
.Cs
unsetNodeColorInUseMapping()
.Ce
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
unset all the color assignments to jobs, and their color counts
reset the colorINUSE_index back to -1.
.fi
.RE
.NH 3
.Fn colorBarPopulate()
.Cs
colorBarPopulate(startx, starty, maplist, tag)
.Ce
.IP Args: 4
.RS
.IP startx 9
starting x position of the display
.IP starty 9
starting y position of the display
.IP maplist 9
what things to be mapped on the colorbar with elements of the form:
          {color1 label} {color2 label} ...
.IP tag 9
tag to be assigned to canvas widgets created as a result of this call
.RE
.LP
Control Flow:
.RS
.nf
given a widget in canvas identified by coordinates (x1,y1,x2,y2)
foreach {color, label} in maplist
do
        if 1st element then
                x1 = startx
        else
                x1 = previous widget's x2 + add some space paddings

        y1  = starty
        x2 = x1 + smallTextFontWidth
        y2 = y1 + smallTextFontHeight
        create rectangle (x1,y1,x2,y2), colored with 'color' with tag 'tag'

        x1 = rectangle's x2 + space padding
        y1 = rectangle's y1 

        create text(x1, y1) with tag 'tag' and text 'label'
done
.fi
.RE
.NH 3
.Fn colorBarCreate()
.Cs
colorBarCreate( frame_name )
.Ce
.IP Args: 4
.RS
.IP frame_name 12
a frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
create the color bar containing rectangles of colors and their color names.

create the color bar canvas
create the scrollbar

call colorBarPopulate to create colors info for FREE, DOWN, OFFL, RSVD, NOINFO,
INUSE-TIMESHARED with tag 'fixed'.
.fi
.RE
.NH 3
.Fn colorBarUpdate()
.Cs
colorBarUpdate()
.Ce
.LP
Control Flow:
.RS
.nf
create a color table containing the list of jobs for each assigned colors.

use this color table to create the inuse table for  associating the
color name and the display label with the latter being the <jid.user.#ofnodes>.

get the coordinates of the "fixed" items on the canvas,
and  call colorBarPopulate with the new items being placed just below the
"fixed" items.

pack or unpack the colorbar's scrollbar as appropriate.
.fi
.RE
.NH 3
.Fn pref()
.Cs
pref( callerDialogBox, focusBox )
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 17
the dialog box abstraction that called this function.
.IP focusBox 17
the dialog box to return focus to upon return from this function.
.RE
.LP
Control Flow:
.RS
.nf
set a PREFLCK
set busy cursor

create a pref dialog window

create 2 boxes within this window: box1 and box2

box1 is for specifying the site names and their view types, while
box2 is for adding the server names and labels. Add values to box1 by calling
siteAdd() while add values to box2 by calling serversPut(). Delete
items from box1 by calling siteDelete() while for box2, call serversDelete().
For the "set nodes" button of box2, bring up the "Server Preferences"
window supplied with the info about the currently selected server name.
Load values to box1 by calling sitesGet()

display the row of buttons: "done redisplay view", "done don't redisplay view",
"help".

display all the widgets created.

remove busy cursor
unset PREFLCK

When the dialog window is unmapped, call boxUnset().
.fi
.RE
.NH 3
.Fn prefComplete1()
.Cs
prefComplete1( callerDialogBox )
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 17
the dialog box that called this procedure.
.RE
.LP
Control Flow:
.RS
.nf
     destroy callerDialogBox
     invoke "System.." menu button
fi
.fi
.RE
.NH 3
.Fn prefComplete2()
.Cs
prefComplete2( callerDialogBox )
.Ce
.IP Args: 4
.RS
.IP callerDialogBox 17
the dialog box that called this procedure.
.RE
.LP
Control Flow:
.RS
.nf
Same algorithm as prefComplete1() except "System.." menu button is not
invoked.
.fi
.RE
.NH 3
.Fn siteNamesGet()
.Cs
siteNamesGet()
.Ce
.IP Returns: 4
the list of site names known to the system by consulting the global sysview
array.
.NH 3
.Fn siteNamesPrint()
.Cs
siteNamesPrint()
.Ce
.LP
Control Flow:
.RS
.nf
Print to stdout the names of the sites known to the system. 
.fi
.RE
.NH 3
.Fn siteAdd()
.Cs
siteAdd( siteName, boxframe )
.Ce
.IP Args: 4
.RS
.IP siteName 10
name of a site
.IP boxframe 10
a box abstraction
.RE
.LP
Control Flow:
.RS
.nf
create a sysview entry with 'siteName' as index and boxframe's entryval 1
as the value.  
.fi
.RE
.NH 3
.Fn siteDelete()
.Cs
siteDelete( siteName )
.Ce
.IP Args: 4
.RS
.IP siteName 10
name of a site
.RE
.LP
Control Flow:
.RS
.nf
unset sysview($siteName)
Delete siteName's entry on the "System.." menu. 
.fi
.RE
.NH 3
.Fn serverDelete()
.Cs
serverDelete( serverid )
.Ce
.IP Args: 4
.RS
.IP serverid 10
"siteName,serverName"
.RE
.LP
Control Flow:
.RS
.nf
call unset sysnodes($serverid)
.fi
.RE
.NH 3
.Fn queryTableGet()
.Cs
queryTableGet( sitename, nodename, type )
.Ce
.IP Args: 4
.RS
.IP sitename 10
name of the site that holds the query table
.IP nodename 10
node name associated with a particular queryTable
.IP type 10
type of node represented by 'nodename'
.RE
.LP
Control Flow:
.RS
.nf
An internal table called "queryTable" is maintained to keep track of the
list of queries (their display labels, and display type). This returns a
query information line from the queryTable based on the "display type".
.fi
.RE
.NH 3
.Fn queryTableDelete()
.Cs
queryTableDelete( nodeid )
.Ce
.IP Args: 4
.RS
.IP nodeid 8
some node identifier (it could be a nodename, or a supernodename,node)
.RE
.LP
Control Flow:
.RS
.nf
unset queryTableDelete( nodeid ) 
.fi
.RE
.NH 3
.Fn queryTableSave()
.Cs
queryTableSave( sitename, boxframe )
.Ce
.IP Args: 4
.RS
.IP sitename
name of a site
.IP boxframe 10
a box abstraction
.RE
.LP
Control Flow:
.RS
.nf
set host to the box's title 

unset queryTable(sitename,host)

go through each row of input of 'boxframe', and use them as input to
queryTable(sitename,host)
.fi
.RE
.NH 3
.Fn queryTableLoad()
.Cs
queryTableLoad( sitename, boxframe )
.Ce
.IP Args: 4
.RS
.IP sitename 10
name of a site
.IP boxframe 10
a box abstraction
.RE
.LP
Control Flow:
.RS
.nf
set host to the title of 'boxframe'.

if queryTable(sitename,host) does not exist, then return

go through each entry of queryTable(sitename,host), and use each one as
input to the 1st, 2nd, and 3rd columns of the box in 'boxframe'.
.fi
.RE
.NH 3
.Fn queryTablePrint()
.Cs
queryTablePrint(sitename)
.Ce
.IP Args: 4
.RS
.IP sitename 10
name of a site
.RE
.LP
Control Flow:
.RS
.nf
prints the queryTable information for 'sitename'.
.fi
.RE
.NH 3
.Fn sitesGet()
.Cs
sitesGet( boxframe )
.Ce
.IP Args: 4
.RS
.IP boxframe 10
a box abstraction
.RE
.LP
Control Flow:
.RS
.nf
get the entry in boxframe. Delete its content.

get all the site names and corresponding view types known to the system, and
load them as entries to box.
.fi
.RE
.NH 3
.Fn sitesPut()
.Cs
sitesPut( boxframe )
.Ce
.IP Args: 4
.RS
.IP boxframe 10
a box abstraction
.RE
.LP
Control Flow:
.RS
.nf
Go through each element of box in 'boxframe' and add a corresponding
radiobutton to the "System.." menu.
.fi
.RE
.NH 3
.Fn serverNamesGet()
.Cs
serverNamesGet( siteName )
.Ce
.IP Args: 4
.RS
.IP siteName 10
name of a site
.RE
.IP Returns: 4
list of server names that are under 'siteName'.
.LP
Control Flow:
.RS
.nf
This function makes use of the global sysnodes array. 
.fi
.RE
.NH 3
.Fn statNodes()
.Cs
statNodes( server_name, sysframe )
.Ce
.IP Args: 4
.RS
.IP server_name 12
name of a server
.IP sysframe 12
associated system frame
.RE
.IP Returns: 4
list of nodes managed by 'server_name'.
.LP
Control Flow:
.RS
.nf
     do a pbsconnect to 'server_name'
     post a 'pbsstatnode' query.  Get the results.
     From the results,
     (1) add node's name and NOMOM_SNODE type to the nodes list. Update the
         node's type internally. 
     (2) do the following actions:
              state =>  nodeUpdateStat()
              properties => systemNodeInfo2Append()

     issue a pbsdisconnect
     return the nodes list
.fi
.RE
.NH 3
.Fn statNodesStateMap()
.Cs
statNodesStateMap( state )
.Ce
.IP Args: 4
.RS
.IP state 7
state info to map
.RE
.IP Returns: 4
the state info recognizeable to xpbsmon
.LP
Control Flow:
.RS
.nf

     IF      state     => RETURN
             FREE, free    => FREE  
             OFFLINE, offline  => OFFLINE
             DOWN, down => DOWN
             RESERVED, reserve  => RESERVED
             INUSE-EXCLUSIVE, job-exclusive => INUSE-EXCLUSIVE
             INUSE-SHARED, job-sharing => INUSE-SHARED
             NOINFO => NOINFO
             <default> => ""
.fi
.RE
.NH 3
.Fn nodesListMerge()
.Cs
nodesListMerge( nlist1, nlist2, frame )
.Ce
.IP Args: 4
.RS
.IP nlist1 8
nodes list 1
.IP nlist2 8
nodes list 2
.IP frame 8
system node frame to update information on
.RE
.LP
Control Flow:
.RS
.nf

       Load nlist1.
       Check nlist2:
            if it encounters a nodename that is in 'nlist1',
                update the corresponding 'nlist1' entry with values from
                'nlist2' and set the node type to 'MOM_SNODE'.
            else
                add to nlist1.
            update the node's type

      return the new list of nodes (with information) in the order that they
             were specified in the argument list.
 
.fi
.RE
.NH 3
.Fn serverNamesSorted()
.Cs
serverNamesSorted( systemName, servers, nodesp, frame )
.Ce
.IP Args: 4
.RS
.IP systemName 12
name of a site
.IP servers 12
list of server names
.IP nodesp 12
an array to hold the nodes for each of the server listed in 'servers' 
.IP frame 12
frame of 'systemName'
.RE
.IP Returns: 4
list of server names that are under 'systemName' sorted according to the
increasing number of nodes each one holds.
.LP
Control Flow:
.RS
.nf
for each of the server name in 'servers',
  get the nodes list by statnodes-ing  the server. Save the results in nlist1.
  get the nodes list specified by user in the Pref dialog box. Save these 
	results in nlist2.
  Merge 'nlist2' with 'nlist1' and place result in 'nodesp' array.
  create a new servers list called 'newservers', and add items to it depending
   on increasing # of nodes.
done
return 'newservers'
.fi
.RE
.NH 3
.Fn serversPut()
.Cs
serversPut( boxframe, siteName )
.Ce
.IP Args: 4
.RS
.IP boxframe 11
a box abstraction
.IP sitename 11
name of a site
.RE
.LP
Control Flow:
.RS
.nf

if 'siteName' is an empty string, then return

get the box from 'boxframe'
go through each element of box (server_name, server_label)), and
        if global array entry sysnodes($siteName,$server_name) is set,
             then update its server label value to 'server_label'
        else
             initialize: sysnodes($siteName,$server_name) -> $server_label.
.fi
.RE
.NH 3
.Fn serversGet()
.Cs
serversGet( boxframe, siteName )
.Ce
.IP Args: 4
.RS
.IP boxframe 10
a box abstraction
.IP siteName 10
name of a site
.RE
.LP
Control Flow:
.RS
.nf
get the server, label boxes from 'boxframe'. Delete all their entries. Update
the nrows count of Servers box to 0.

get the entry widgets associated with the Servers box and delete all the
characters that it is holding.

Set the site box's titlelabel to "Servers@siteName"

go through each of the server names to 'siteName', inserting the server_name
into server box, and the server_label into the label box, and updating its
nrows count.

select the first entry of the Servers box.
.fi
.RE
.NH 3
.Fn sysnodesGet()
.Cs
sysnodesGet( sitename, boxframe )
.Ce
.IP Args: 4
.RS
.IP sitename 10
name of a site.
.IP boxframe 10
a box abstraction
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
set host to the title of the boxframe 

if sysnodes(siteName,host) does not exist, then
        return
fi

get the node box (box that holds nodenames) and the nodetype box.

delete all the entries of node box.

for the other entries of sysnodes(siteName,host), input them to node box and
type box, updating the box's nrows counter.

select the first entry of box if one exists.
.fi
.RE
.NH 3
.Fn sysnodesPut()
.Cs
sysnodesPut( sitename, serverName, entry, box )
.Ce
.IP Args: 4
.RS
.IP sitename 12
name of a site
.IP serverName 12
name of a server
.IP entry 12
name of an entry widget
.IP box 12
a box abstraction
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
Reset the sysnodes(sitename,serverName) value to contain only the server_label.

And for the rest of the entries of sysnodes(sitename,serverName), fill them
with inputs from the 1st and 2nd column of 'box'. 
.fi
.RE
.NH 3
.Fn sysnodesPrint()
.Cs
sysnodesPrint(sitename)
.Ce
.IP Args: 4
.RS
.IP sitename 10
name of a site
.RE
.LP
Control Flow:
.RS
.nf
prints all the nodes information contained under 'sitename'.
.fi
.RE
.NH 3
.Fn prefServerComplete()
.Cs
prefServerComplete( boxframe, callerDialogBox )
.Ce
.IP Args: 4
.RS
.IP boxframe 17
a box abstraction
.IP callerDialogBox 17
the dialog box that called this procedure
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
if 'boxframe' has 0 rows, then issue an error message.

Otherwise, simply destroy callerDialogBox 
.fi
.RE
.NH 3
.Fn prefServer()
.Cs
prefServer(siteName, serverName, callerDialogBox, focusBox)
.Ce
.IP Args: 4
.RS
.IP siteName 17
name of a site
.IP serverName 17
name of a server
.IP callerDialogBox 17
the dialog box that called this procedure
.IP focusBox 17
the dialog box to return focus to upon return from this function
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
enable busy_cursor
create top part and bottom part of the dialog box.
create the server display label dialog box.

create the server box to be filled with Nodes information.
for the update button of server box, have it so that it calls "prefQuery()".

build the row of command buttons {ok help}. For the ok button, create an
action that will update the sysnodes global variable when the button is
pressed (via call to sysnodesPut) 

display the widgets.
load default values for the server box.

remove busy cursor

Upon return, put a grab on callerDialogBox, and set focus to focusBox.
.fi
.RE
.NH 3
.Fn prefQuery()
.Cs
prefQuery (siteName, nodeName, nodeType, callerDialogBox, focusBox)
.Ce
.IP Args: 4
.RS
.IP siteName 17
name of a site
.IP nodeName 17
name of a node
.IP nodeType 17
type of node
.IP callerDialogBox 17
the dialog box that called this procedure
.IP focusBox 17
the dialog box to return focus to upon return from this function
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
Return if nodeType is not MOM.

enable busy_cursor
create top part and bottom part of the dialog box.

create the Query box to be filled with query expressions, display label,
and output type information. Load it with default values by calling
queryTableLoad(). 

build the row of command buttons {ok help}. For the ok button, create an
action that will update the queryTable global variable when the button is
pressed (via call to queryTableSave) 

display the widgets.

remove busy cursor

Upon return, put a grab on callerDialogBox, and set focus to focusBox.
.fi
.RE
.NH 2
.Fi preferences.tcl
.LP
This file contains procedures for loading, saving parameters into the
xpbsmonrc file.
.NH 3
.Fn prefLoadSitesInfo()
.Cs
prefLoadSitesInfo()
.Ce
.LP
Control Flow:
.RS
.nf
foreach info in sitesinfo global list
do
       from the info, get the:
                col1: sitename
                col2: site's VIEW type
                col3: servername
                col4: serverlabel
                col5: nodename
                col6: nodetype
               col7: querylist

        if no 'nodename' has been specified, then simply update the
              site's view type, and server information and continue to
              the next iteration of this loop.
        return immediately if one of the ff:

                1. # of cols in info is != 7
                2. site's VIEW type is not ICON or FULL
                3. nodetype is not MOM or NOMOM
                4. querytype is not SCALE, TEXT

        based on site's VIEW type, update sysview for site
        update sysnodes for sitename,servername making sure no duplicates in
                the "nodename nodetype" value.

        update queryTable for sitename,nodename using querylist and ensuring
                no duplicates.
done
.fi
.RE
.NH 3
.Fn prefSaveSitesInfo()
.Cs
prefSaveSitesInfo()
.Ce
.LP
Control Flow:
.RS
.nf
using the global variables sysview, sysnodes, queryTable, recreate the
global siteinfo list with the following format:

<sitename>sep<sitevtype>sep<svrname>sep<srvlabel>sep<nodename>sep<nodetype>sep<querylist>

where sep is sysinfo(rcSiteInfoDelimeterChar)
.fi
.RE
.NH 2
.Fi main.tk
.LP
This file contains  procedures for building the main application window.
.NH 3
.Fn iconView()
.Cs
iconView( force )
.Ce
.IP Args: 4
.RS
.IP 
.RE
.LP
Control Flow:
.RS
.nf
force - set to TRUE if to force an icon View of the system

if !force and the view of the current system is already in ICON, then
        return

if system already exists, then
       recreate system nodes in ICON view
else
       create system nodes from scratch in ICON view
       schedule a new cycle of populateNodesWithInfo
fi
.fi
.RE
.NH 3
.Fn fullView()
.Cs
fullView( force )
.Ce
.IP Args: 4
.RS
.IP 
.RE
.LP
Control Flow:
.RS
.nf
force - set to TRUE if to force an icon View of the system

if !force and the view of the current system is already in FULL, then
        return

if system already exists, then
        recreate system nodes in FULL view
else
        create system nodes from scratch in FULL view
        schedule a new cycle of populateNodesWithInfo
fi
.fi
.RE
.NH 3
.Fn build_main_window()
.Cs
build_main_window(mainWindow)
.Ce
.IP Args: 4
.RS
.IP mainWindow 12
a frame abstraction
.RE
.LP
Control Flow:
.RS
.nf
create 3 frames for holding the menubar, main frame, and status bar.
display them on screen.

fill menubar with info
fill main frame with info
fill statusbar with info.
.fi
.RE
.NH 3
.Fn fillMainFrame()
.Cs
fillMainFrame(widget_name)
.Ce
.IP Args: 4
.RS
.IP widget_name 13
a widget abstraction
.RE
.LP
Control Flow:
.RS
.nf
displayView for current systemName (siteName)
.fi
.RE
.NH 3
.Fn fillStatusbarFrame()
.Cs
fillStatusbarFrame(widget_name)
.Ce
.IP Args: 4
.RS
.IP widget_name 13
a widget abstraction
.RE
.LP
Control Flow:
.RS
.nf
create the "INFO" labe
create the info bar listbox

display the widgets.
.fi
.RE
.NH 3
.Fn displayView()
.Cs
displayView(frame, sitename, init)
.Ce
.IP Args: 4
.RS
.IP frame 7
a frame abstraction
.IP sitename 10
name of a site
.IP init 10
flag whether it is the first time
.RE
.LP
Control Flow:
.RS
.nf
delete the previous frame in view

display icon view if current system's view is ICON
display full view if current system's view is FULL
.fi
.RE
.NH 3
.Fn fillMenubarFrame()
.Cs
fillMenubarFrame(widget_name)
.Ce
.IP Args: 4
.RS
.IP widget_name 13
a widget abstraction
.RE
.LP
Control Flow:
.RS
.nf
create a menubutton called "System.."

foreach sitename known to the system,
do
        add a corresponding radio button to the menubutton above
done

build the row of command buttons:
        Pref.. AutoUpdate.. Help About.. Close <minimize> <maximize> 

adjust various sizes of various button and set bindings:

        Pref ............ call pref()
        AutoUpdate ...... call auto_upd()
        Help ............ call xpbs_help()
        About ........... call about()
        <minimize> ...... call iconView()
        <maximize> ...... call fullView()
        Close ........... call prefSaveSitesInfo(), prefsave()
.fi
.RE
.NH 2
.Fi listbox.tk
.LP
This file contains routines supporting a complete listbox widget.
.NH 3
.Fn lboxvalue_isUnique()
.Cs
lboxvalue_isUnique(listbox, value)
.Ce
.IP Args: 4
.RS
.IP listbox 9
the list box
.IP value 9
a value string
.RE
.IP Returns: 4
1 if 'value' is unique (that is, not found in listbox);
0 if 'value' is not unique (is found in listbox)
.LP
Control Flow:
.RS
.nf
go through each element of listbox,
	if element is the same as 'value' then return 0 (meaning not unique)

return 1 (meaning value is unique)
.fi
.RE
.NH 3
.Fn lcomp()
.Cs
lcomp(lbox1, lbox2)
.Ce
.IP Args: 4
.RS
.IP lbox1 7
listbox 1 
.IP lbox2 7
listbox 2
.RE
.IP Returns: 4
0 if lbox1 and lbox2 contain the same elements; 1 if not
.LP
Control Flow:
.RS
.nf
return 1 if the 2 listboxes don't match in sizes

go through each element of the 2 listboxes, and if at least 2 elements on
the same position don't match, then return 1.
Otherwise, return 0.
.fi
.RE
NH 2
.Fi box.tk
.LP
This file contains functions that support the building of a box widget which
is a multi-column listbox and items are added to it via accompanying entry
widgets. 
.NH 3
.Fn box()
.Cs
box( frame_name, args )
.Ce
.IP Args: 4
.RS
.IP frame_name 12
frame to place box widget on.
.IP args 12
list of parameters for the box:
.IP "-title <title_of_the_box>"
.IP "title"
returns title of the box
.IP "-class <class_name>"
.IP "class"
returns the class of the box
.IP "titlelabel"
returns the label widget of the box.
.IP "-key <keyval)"
key value of the box (index to field containing unique values).
.IP "key"
returns the key of the box
.IP "-entrylabels <listOfEntryLabels>"
.IP "entrylabels"
returns list of entry labels
.IP "-lboxlabels <listOfListBoxLabels>"
.IP "lboxlabels"
returns list of listbox labels.
.IP "-lboxwidths <listOfWidths>"
.IP "lboxwidths"
returns list of listbox widths
.IP "-lboxheights <listOfHeights> lboxheights"
returns the list of listbox heights
.IP "-orient <orientation of box: x, y>"
.IP "orient"
returns the orientation of the box
.IP "-grabBox <widget_name>"
.IP "grabBox"
returns the widget name that is grabbed after the box widget has come up.
.IP "-selindex <index_whose_value_to_be_highlighted>"
.IP "selindex"
returns the index whose value is currently highlighted.
.IP "-vscroll <scrollbar_pathname>"
.IP "vscroll"
returns the vertical scrollbar pathname
.IP "ncols"
returns the # of cols of the box
.IP "-nrows <# of rows of the box>"
.IP "nrows"
returns the number of rows of the box.	
.IP "lbox <index>"
returns the listbox widget pathname at col <index> of box. 
.IP "entry <index>"
returns the entry widget pathname at col <index> of box.
.IP "-entryval <index> <value>"
.IP "entryval <index>"
returns the value of the entry widget at <index>
.IP "-entryvalDeleted <value>"
.IP "entryvalDeleted"
returns the last entry value that was deleted from the box.
.IP "-noUpdateButton <true|false>"
.IP "noUpdateButton"
returns the flag value of whether or not the box should have an update button. 
.IP "-addCmd <cmd_func>"
.IP "addCmd"
returns name of command to execute after the add button of the box has been
clicked.
.IP "-remCmd <cmd_func>"
.IP "remCmd
returns the name of command to execute after the delete button of the
box has been clicked.
.IP "updateButton"
returns the updateButton of the box. 
.IP "create"
if the box is to be newly created.
.IP "unset"
unset all storage associated with box.
.IP "getBoxArray"
return the storage array of the box.	 
.RE
.LP
Control Flow:
.RS
.nf
A box is made of a list of listboxes, where a row on each listbox is
collectively defined together, and input to each row is provided by
a list of entryboxes with one entry for each listbox.


create one frame to hold everything. add the frame_name to list of
sysinfo boxes.

create the top frame
create the bottom frame
create the bottom frame's entry frame
create the bottom frame's listbox labels frame
create the bottom frame's box frame

puts title label on the top frame
create the add button on the bottom frame's entry frame

get the parameters for list of entry info, listbox widths, and
listbox heights. 

set k 0
foreach entryinfo in list of entry infos,
do
               if entryinfo's type is MENU_ENTRY, then create a menu-ed
                        entry
               otherwise,
                        create an full entrybox complete label specified in
               entryinfo
               increment k
done

set the number of columns counter to k
pack all the entry widgets or menu-ed entry widgets created.

set the tabbing sequence for the box as it traverses the entry widgets. 

On the bottom frame's box frame,
    create the list of listboxes based on what's specified for the
               the lboxlabels.
    pack all the listbox widgets.

set the scrolling mechanism for the box. 

create the accompanying listboxes' command buttons:
   <delete> if noUpdateButton; otherwise,
   <delete> <update>

for the <delete> button, bind the remCmd to it.


depending on orientation, display the box horizontally if orient is 'x',
otherwise, vertically, if orient is 'y'.
.fi
.RE
.NH 3
.Fn boxesUnset()
.Cs
boxesUnset()
.Ce
.LP
Control Flow:
.RS
.nf
go through each of the boxes known to system and unset them. 
.fi
.RE
.NH 3
.Fn boxAdd()
.Cs
boxAdd( frame_name, addfunc )
.Ce
.IP Args: 4
.RS
.IP frame_name 11
a box abstraction
.IP addfunc 11
the TCL expression to execute after adding entries to box.
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
get the keylist (list of indices that collectively defines a unique entry
of the box), it's of the format: 
        { keyindex1 (<keyindex1>:<keyval1>) ... (<keyindexN>:<keyvalN>) }

go through each column of box,
do
        keep track of column index
        cleanup the entry values of the box, removing any ";", "]", and "["
        which can be problematic under TCL 

        if keylist contains a "(^| )<keyindex>", then this must be a 
                special key that must have a non-empty value, and that
                its value must be unique if it matches <keyval>. Record this
                info.
        fi
        create a keyval_string

done

go through each row of box,
do
        go through each col of box,
        do
                set rowvalue_string to the values
                        of the row whose col index match the keylist
	        issue an error message if a col is one of the keys and its
                        value is one of the values that must be unique,
                         and the value is not unique.
        done

         issue another error message if rowval_string matches keyval_string
	         (a duplicate)

done

Finally, insert keyval_string to the appropriate columns of the box.
increment box's row count
select the added item

execute addfunc
.fi
.RE
.NH 3
.Fn boxDelete()
.Cs
boxDelete(frame_name, remfunc)
.Ce
.IP Args: 4
.RS
.IP frame_name 12
a box abstraction
.IP remfunc 12
name of a TCL function to execute when a box is deleted.
.RE
.LP
Control Flow:
.RS
.nf
go through each col of box,
do
        get the listbox at that column
        get the selected index at that column
        save the value of the selected index
        delete the selected element
        select the next item on the listbox
done

decrement the row count
execute the remfunc
.fi
.RE
.NH 3
.Fn boxGetCurSelect()
.Cs
boxGetCurSelect( frame_name, index )
.Ce
.IP Args: 4
.RS
.IP frame_name 12
a box abstraction
.IP index 12
column index of box
.RE
.IP Returns: 4
the selected item at column 'index' of box.
.NH 3
.Fn boxSelect()
.Cs
boxSelect( frame_name, index )
.Ce
.IP Args: 4
.RS
.IP frame_name 12
a box abstraction
.IP index 12
column index of box
.RE
.LP
Control Flow:
.RS
.nf
if index is -1 (nothing to select), simply execute the 1st listbox's "cmd"

go through each column of of box,
do
        get the listbox at column.
        select the 'index' of listbox.

        whatever value is selected, load it as input to the accompanying
                input entry widgets.
        if this is the 1st column, set the focus to the corresponding entry
                widget, and select this entry's value.

        if the listbox has an accompanying "cmd", execute it.
done
.fi
.RE
.NH 3
.Fn boxSetScroll()
.Cs
boxSetScroll( frame_name )
.Ce
.IP Args: 4
.RS
.IP frame_name 12
a box abstraction
.RE
.LP
Control Flow:
.RS
.nf
if no vscroll of box, then return

go through each column of box,
do
       get the listbox at column, and set its yscrollcommand to set vscroll of
			box
done

configure vscroll to adjust all views of the listboxes of box at the same
        row.
.fi
.RE
.NH 3
.Fn boxSetTabbing()
.Cs
boxSetTabbing( f )
.Ce
.IP Args: 4
.RS
.IP f 3
a box abstraction
.RE
.LP
Control Flow:
.RS
.nf
go through each entry of box, and set tabbing mechanism so that when the
<tab> key is hit, it will go to the next (forward) adjacent entry box, and when
<cntrl-p> is hit, then it go to the previous adjacent entry box.
.fi
.RE
.NH 3
.Fn boxAdjScrollView()
.Cs
boxAdjScrollView( args )
.Ce
.IP Args: 4
.RS
.IP args 6
input parameter: <list of listboxes> <scroll parameters>  
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
go through each of the <list of listboxes>,
and issue "yview <scroll parameters" to each one.
.fi
.RE
.NH 2
.Fi bindings.tk
.LP
This contains procedures that attaches bindings to widgets as a result of
a mouse click.
.NH 3
.Fn bind_button1()
.Cs
bind_button1( win )
.Ce
.IP Args: 4
.RS
.IP win 5
pathname of a widget
.RE
.LP
Control Flow:
.RS
.nf
when the mouse button 1 is clicked on 'win', record the x and y coordinates. 
.fi
.RE
.NH 3
.Fn bind_canvas()
.Cs
bind_canvas( canvasw )
.Ce
.IP Args: 4
.RS
.IP canvasw 9
pathname to a canvas widget
.RE
.LP
Control Flow:
.RS
.nf
when button 1 is clicked on 'canvasw', then save X and Y coordinates of pointer,
and popup a node info box.
.fi
.RE
.NH 2
.Fi entry.tk
.LP
This file contains routines that are realated to an entry widget.
.NH 3
.Fn menuEntry()
.Cs
menuEntry( frame_name, args )
.Ce
.IP Args: 4
.RS
.IP frame_name 12
a frame where the menu entry widget is to be placed.
.IP args 12
parameters to this new widget which can be:
.RS
.IP "menubutton"
returns the button widget inside the entry box.
.IP "-menuvalues <listOfpossibleValues>"
.IP "menuvalues"
returns list of possible values to menu entry.
.IP "-title <titlelabel>"
.IP "title"
returns the title assigned to the menu entry.
.IP "-textvariable <NameOftextVariableToHoldResult>"
.IP "create"
create a new menu entry widget
.IP "getMenuArray"
returns the storage used for the menu entry.
.RE
.RE
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
a menuEntry is an entry widget which when clicked, will give you the
list of possible values, and by using the mouse, you can select the value
for the entry.

create the label containing the <titlelabel>

create the menubutton with <textvariable> used to hold results. Fill this
button with popup sub-menus using as <menuvalues> as labels. Invoke the 1st
entry on the list.

display the widgets.
.fi
.RE
.NH 2
.Fi auto_upd.tk
.LP
This file contains routines related to the Auto Update dialog.
.NH 3
.Fn data_auto_update()
.Cs
data_auto_update()
.Ce
.IP Returns: 4
.LP
Control Flow:
.RS
.nf
same function as in xpbs except the function systemPopulateNodesWithInfo()
is called instead.
.fi
.RE
.NH 2
.Fi dialog.tk
.LP
This file contains routines that are related to the building of dialog boxes.
.NH 3
.Fn popupNodeInfoBox()
.Cs
popupNodeInfoBox(callerDialogBox, nodeframe, nodename, nodeType, clusterSrc,
                 focusBox)
.Ce
.IP Args: 4
.RS
.IP
callerDialogBox - the dialog box when this procedure was called
.IP nodeframe 12
a node abstraction
.IP nodename 12
name associated with 'nodeframe'
.IP nodeType 12
type associated with 'nodeframe'
.IP clusterSrc 12
frame where 'nodeframe' resides
.IP focusBox 12
where to set focus upon return from this call
.RE
.LP
Control Flow:
.RS
.nf
if nodeInfoBox already exists, then retun immediately

popup a dialog box.

if nodename is of compound form (supernode,nodename), then use only the
   nodename portion as label.


create a new nodeframe with 'nodename', 'nodeType', 'clusterSrc', and MIRROR
type.

get the node information for 'nodename' under systemframe that is under
nodeframe. If one exists, then display it on the
MIRROR nodeframe. Otherwise, just color the nodeframe.

create the command button: <ok> to be placed at the bottom of the dialog
box. Register default action to this button.

Upon returning from this dialog window,
	be sure to set focus back to focusBox,  
		to grab callerDialogBox,
		do nodeDelete 
.fi
.RE
.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.bp
\}
