.nr % 1
.OH ''PBS IDS'Libraries'
.EH 'Libraries'PBS IDS''
.P1
.so ids_setup.ms
.Rv $Revision: 2.2 $
.nr H1 9
.nr Fi 0 1
.NH 1
.Tc \f3\s+2Libraries\s-2\fP
.LP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.NH 2
Library:
.Tc "\f3libattr.a - Attribute Library\fP"
.Ix libattr.a
.LP
The attribute library,
.I libattr.a ,
consists of routines to manipulate or otherwise handle PBS attributes.
This library is used by the server.
.LP
As discussed in section 2.1.1, an attribute consists of a name and a value.
An attribute can be represented in one of two ways, three if you count
the form used by the network encode/decode routines.
.LP
The internal form of an attribute is contained in two separate structure:
the attribute definition which contains the name, various flags, and pointers
to the manipulation routines for that attribute, the
.I attribute_def
structure; and the 
.I attribute ,
structure which contains the machine dependent representation of the value
and other flags.
.LP
The network independent external form has the value as well as the name
in string form.  This form is contained in a
.I svrattrl
structure.  When in the external form, the attribute is referred to as being
.I encoded ,
and when in the internal form as being
.I decoded .
.LP
.NH 3
.Ix attr_func.c
.LP
The file 
.I src/lib/Libattr/attr_func.c
contains general purpose functions relating to processing attributes.
.Fn clear_attr()
.Cs
void clear_attr(attribute *pattr)
.Ce
.IP Args: 4
.RS
.IP pattr
Pointer to attribute to clear
.RE
.LP
The attribute (value) structure is cleared by zeroing each byte.
Then the attribute flag 
.Sc ATR_VFLAG_SET
is cleared.
.LP
Note, this function is useful in clearing an attribute structure which has
just be allocated.  If used to clear a attribute to which a valued has been
assigned, the appropriate free routine, see at_free(), must be called before
clear_attr is called.
.Fn find_attr()
.Cs
int find_attr(\^attribute_def *attr_def, char *name, int limit)
.Ce
.IP Args: 4
.RS
.IP attr_def
Pointer to the attribute definition structure.  This structure contains the
name of the attribute.
.IP name
The name of the attribute to find in the definition structure.
.IP limit
The number of attributes defined by the definition structure, the limit 
on the search.
.RE
.IP Returns: 4
.RS
.IP ">= 0"
The index into the attribute definition (and attribute value) structure.
.IP -1
If error occurred.
.RE
.LP
The function compares the requested name with the name of each attribute
defined in the definition structure.  If a match is found, the index into
the array of definitions is returned.  
.LP
Given an attribute in string form, a name string and a value string,
this function is used to obtain the index which relates the attribute
to both the definition and value structures.
.Fn free_null()
.Cs
void free_null(attribute *attr)
.Ce
.IP Args: 4
.RS
.IP attr
Pointer to the attribute (value).
.RE
.LP
This function is a semi-place holder in the attribute definition
for attributes which do not have extra space allocated to hold their values.
Attributes of type long, boolean, character, and size use this function.
.LP
The value field, using at_size as an expedient, is zeroed and in at_flags
.Sc ATR_VFLAG_SET
is cleared.
.Fn attrlist_alloc()
.Cs
svrattrl *attrlist_alloc(int szname, int szresc, int szvalue)
.Ce
.IP Args: 4
.RS
.IP szname
size of attribute name including terminating null.
.IP szresc
size of resource name including terminating null, zero if no resource name.
.IP szvalue
size of value string including terminating null.
.RE
.IP Returns: 4
.RS
.IP pointer
to the created svrattrl entry.
.IP null
if error.
.RE
.LP
The svrattrl structure is used to hold the encoded form of an attribute.
It serves two functions.  First, it is a single block holding all of the
attribute information which can be saved on disk.  Second, it provides for
a structure that is independent of but similar to the network form of an
attribute.  The svrattrl structure also contains the
.I attropl 
structure used by many of the routines in the API library, libpbs.a.
.LP
The svrattrl structure has two parts, the base portion and the extended
portion.  The base portion is that defined by the structure definition itself.
The extended portion is the extra space allocated immediately following the
base and used to hold the strings.
Note that the 
.At al_flags
entry is only used when saving the attribute to disk
and the 
.At al_op
entry is only used for network encoding.
.LP
The length of the three strings added to the size of the svrattrl structure
itself is the amount of space allocated.  The string length members and the
pointers to the strings are set.  The other fields are cleared.
A pointer to the structure is returned.
.Fn attrlist_create()
.Cs
svrattrl *attrlist_create(char *atname, char *rsname, int vsize)
.Ce
.IP Args; 4
.RS
.IP atname
the attribute name.
.IP rsname
the resource name or a null pointer.
.IP vsize
the amount of space, in bytes, required to hold the encoded value.
.RE
.IP Returns:
.RS
.IP pointer
to the created svrattrl entry.
.IP null
if error.
.RE
.LP
The length of the attribute name and the resource name (if present) are
determined.
Those lengths and the passed size of the value are passed to the function
.I attrlist_alloc()
to allocate the space.
.LP
The attribute name string and if present, the resource name string are
copied into the structure.
A pointer to the structure is returned.
.Fn attrl_fixlink()
.Cs
void attrl_fixlink(list_head *svrattrl_list)
.Ce
.IP Args: 4
.RS
.IP svrattrl_list
pointer to the head of the list of svrattrl structures.
.RE
.LP
This routine is a kludgey solution to problem created by the implementation.
The design of the API, see pbs_ifl.h and libpbs.a, specified two
structures to pass attribute information into the API routines, attrl and
attropl.  The server also needed a similar structure, but one which was
a single unit actually holding the strings as well as pointing to them.
.LP
After several iterations, the current svrattrl structure was developed for
the server.  This structure contain a attropl structure.  Thus it can
be feed to the API routines without yet another round in the seemingless
cycle of format conversion.  
.LP
However, there is still one problem.  The included attropl structure has
a \*Qnext\*U pointer which must point to the next attropl structure when
the list is passed to the API routines.  The server does not use this pointer
for two reasons.  First, the server already has routines for dealing with
a linked list using double linking.  Even though the double linking does
not add any required functionality, the routines exist, so use them.
Second, the next pointer in the attropl structure must point to the next
attropl structure.  Even if the attropl is the first element in the
svrattrl structure, there is a (remote) chance that the next attropl
pointer would not be valid as pointer to the next svrattrl.
.LP
So we end up with two linkages.  The server makes use of
.I al_link ,
the double linkage.  Only when the list is being passed to one of the API
routines is 
.I al_atopl.next
used.  Thus the purpose of attrl_fixlink, to \*Qfix\*U the attropl
linkage to match the svrattrl linkage.
.LP
The svrattrl list is walked and each al_atopl.next is set to point to
the next al_atopl entry.
.Fn free_attrlist()
.Cs
void free_attrlist(list_head *attrlist)
.Ce
.IP Args: 4
.RS
.IP attrlist
pointer to head of list of svrattrl entries.
.RE
.LP
Each entry in turn is deleted from the list and freed.
.Fn parse_equal_string()
.Cs
int parse_equal_string(char *start, char **name, char **value)
.Ce
.IP Args: 4
.RS
.IP start
the start of the string to parse, or null to continue where left off.
.IP name
RETURN: pointer to first element of string, the name is returned.
.IP value
RETURN: pointer to second element of string, the value is returned.
.RE
.IP Returns: 4
.RS
.IP "function value"
1 if parse successful, 
.br
0 if at end of string, or
.br
-1 if syntax error detected.
.IP *name
as described above.
.IP *value
as described above.
.RE
.LP
This routine parses a string of the form:
.br
.Ty "name_1 = value_1[, name_2 = value_2...]
.br
On the first call to parse_equal_string(), 
.At start
points to the beginning of the string.  A pointer to 
.Ty name_1
is returned in 
.At name ,
and to
.Ty value_1
in 
.At value .
The value string is null terminated at the comma.
.LP
On each following call with
.At start
set to the null pointer, the routine will resume the parse where it terminated
before, returning
.Ty name_2
and
.Ty value_2 .
.LP
White space around the name and the equal sign is ignored.
Commas may be embedded in the value string by enclosing the value string
in either single or double quote marks.  No parsing takes place until
the matching quote is found.
.Fn parse_comma_string()
.Cs
char *parse_comma_string(char *start)
.Ce
.IP Args: 4
.RS
.IP start
a pointer to a string of comma-separated items, or the null pointer to
resume where the prior call left off.
.RE
.IP Returns: 
.RS
.IP pointer
to the first (next) item.  A Null pointer is returned when the string is
exhausted.
.RE
.LP
On the first call,
.At start
points to a string of the form:
.br
.Ty "value_1 [, value_2 ...]" .
.br
Leading white space is skipped and the first item is null terminated at either
the first following white space or the comma, which ever occurs first.
The function return is a pointer to the start of the first item:
.Ty value_1 .
.LP
On any following calls, with
.At start
set to the null pointer, the scan will resume where it terminated before.
When the end of the original string is reached, a null pointer is returned.

.NH 3
.Tc Attribute Manipulation Functions
.LP
The remaining files which make up libattr.a are attribute manipulation
functions.
Each attribute defined in an attribute definition structure has
a set of manipulation functions which are specific to that type of attribute.
The prototypes are declared in attribute.h and the calling sequence for
each function is described here (rather than repeat N times and waste paper).
The  functions are:
.IP \f3at_decode\fP 5
.if \nI=1 .tm at_decode | \n(H1-\n(PN
Convert the value string to the internal representation.  For example,
for an attribute of type "long", the string \*Q123\*U is decoded to the
integer 123.
The typical function for decoding is named \f3decode_\f2type\f1, where
\f2type\f1 is the type of data.
Note, if the attribute already has a value, it should be cleared.  This is
especially true if the value takes up addition storage (type _str, _arst, _resc,
_list).
.QP 
Important
.LP
If the decode is successful, the attribute is marked with
.Sc ATR_VFLAG_SET
and
.Sc ATR_VFLAG_MODIFY .
If the value is the null string, it is assumed the attribute is to be
\*Qunset\*U.  The attribute is marked with
.Sc ATR_VFLAG_MODIFY
and
.Sc ATR_VFLAG_SET
is cleared.
.RS
.IP Args: 5
.RS
.IP pattr
Pointer to the internal attribute into which the value is decoded.
.IP name
The attribute name.  This is most often unused, the exception is decode_unkn().
.IP resource
The resource name.  This is unused except in decode_resc().
.IP value
The value as a comma-separated string.
.RE
.IP Returns: 5
.RS
.IP 0
Ok, *pattr is set to the new decoded value.
.IP >0
If an error occurred, the PBS error number is returned.
.RE
.RE
.IP \f3at_encode\fP 5
.if \nI=1 .tm at_encode | \n(H1-\n(PN
Convert the internal representation of the value to the svrattrl form.
This consists of a string for the attribute name, one for the resource name
if the attribute is a resource item, and one for the value.
These strings are contiguous and are headed by a control structure,
which specifies the
total length of strings and control structure, the length of each
individual string, and pointers to each string.
The typical function for encoding is named \f3encode_\f2type\f1, where
\f2type\f1 is the type of data.
.LP
Attributes which are not set, i.e. 
.Sc ATR_VFLAG_SET
is cleared or which in the case of attributes with external data, have no
value, are not encoded.  The return value is zero.
.RS
.IP Args: 5
.RS
.IP attr
Pointer to the attribute to decode.
.IP phead
Head of the list of svrattrl structures to which the encoded value is
appended.
.IP atname
The name of the attribute.  This string is included in the svrattrl entry
as the attribute name.  It is typically taken from the attribute definition
structure.
.IP rsname
The name of the resource item if the attribute is a resource list.  Otherwise,
this is a null pointer.
.IP mode
The mode of the encode operation.  Certain attributes change form depending
on the recipient  The mode is either 
.Sc ATR_ENCODE_CLIENT
if the data is to be sent to a client or another server, or 
.Sc ATR_ENCODE_MOM
if the data is to be sent to MOM when starting a job.
.Sc ATR_ENCODE_SVR
if the data is to be sent to another server, the job is being routed.
.Sc ATR_ENCODE_SAVE
if the data is being encoded to save on disk.  This is unused by most attribute
types.  See encode_arst() for an example of where it is used.
.RE
.IP Returns: 5
.RS
.IP >0
if the encode was successful.
.IP 0
if no data encoded because the attribute was not set.
.IP <0
if the encode failed, typically due to a malloc failure.
.RE
.RE
.IP \f3at_set\fP 5
.if \nI=1 .tm at_set | \n(H1-\n(PN
Sets the value of an attribute (internal form) to another.  There are
three operations defined, set A = B, increment A = A + B, and
decrement A = A - B.  The operators + and - are overloaded depending on
the type of attribute.  Not all operations are supported for all attributes.
The typical function for setting an attribute type is named \f3set_\f2type\f1,
where \f2type\f1 is the type of data.
.QP
Important
.LP
If the set operation is successful, the attribute is marked with
.Sc ATR_VFLAG_MODIFY .
.Sc ATR_VFLAG_SET
is set or cleared depending on whether or not the attributes ends up with a
value.
.RS
.IP Args: 5
.RS
.IP old
Pointer to the attribute to set.
.IP new
Pointer to the attribute holding the value to use in setting attr.
.IP op
The operation to perform: Set, Incr, or Decr.
.RE
.IP Returns: 5
.RS
.IP 0
If ok.
.IP >0
If an error, the PBS error number is returned.
.RE
.RE
.IP \f3at_comp\fP 5
.if \nI=1 .tm at_comp | \n(H1-\n(PN
Returns the results of a comparison of two attributes.
The typical function for comparing is named \f3comp_\f2type\f1, where
\f2type\f1 is the type of data.
.IP
Note, 
.I comp_resc()
behaves somewhat (is that an understatement) differently.
.RS
.IP Args: 5
.RS
.IP one
A pointer to an attribute.
.IP two
A pointer to another attribute.
.RE
.IP Returns: 5
.RS
.IP \ 0
The two attributes are set to the same value, V1 equals V2.
.IP +1
The values of the two attributes are different in some fashion.
For numeric data or other attributes for which the full set of comparisons
exist, +1 is returned for V1 > V2.  For attributes where only equality or
inequality comparisons, +1 is returned for V1 not equal to V2.
.IP -1
The values of the two attributes are A1 < A2, if this relation is defined.
.RE
.RE
.IP \f3at_free\fP 5
.if \nI=1 .tm at_free | \n(H1-\n(PN
Frees the space allocated to hold the attribute value.  Certain types of
attributes, long, boolean, character, do not have \*Qextra\*U space
allocated.  A null function is used for these types, see 
.I free_null .
The typical function for freeing an attribute value is named
\f3free_\f2type\f1, where \f2type\f1 is the type of data.
.RS
.IP Args: 5
.RS
.IP pattr
Pointer to attribute for which value space is to be freed.
.RE
.RE
.IP \f3at_action\fP 5
.if \nI=1 .tm at_action | \n(H1-\n(PN
Performs an action when the attribute value is modified.
There are many times that the server must perform some action when the value
of an attribute is changed by a client.
An example, when a client changes the value of a hold-type job attribute,
the server must update the job state.
.IP
The 
.I "action function"
provides a uniform interface to provide such a function.
If the action function pointer is
non null, the action function should be called when a client request
modifies the attribute value.  If the server is doing the modification
\*Qon its own,\*U then it should know enough about what else to do.
The typical function for performing an action upon a change in value is named
\f3action_\f2type\f1, where \f2type\f1 is the type of data.
.RS
.IP Args: 4
.RS
.IP pattr 8
Pointer to attribute which was modified.
.IP pobject 8
Pointer to object which is the parent of the attribute:  the job, queue,
or server structure.
.IP mode 8
Indicates the circumstances under which the attribute is being:
.RS
.IP ATR_ACTION_NEW
Set for the first time, the parent object is new.
.IP ATR_ACTION_ALTEROLD
Altered from the current value to a new value.
.IP ATR_ACTION_ALTERNEW
Altered to this new value.
.IP ATR_ACTION_RECOV
Recovered from disk.
.IP ATR_ACTION_FREE
Freed or unset.
.IP ATR_ACTION_NOOP
A special flag to indicate that nothing should be done.  This is currently
unique to the routine
.I depend_on_que()
which does double duty.
.IP 
Not all of the above values for mode are being used.  They include about
every possibility that the author could imagine.
.RE
.RE
.IP Returns: 4
.RS
.IP 0
If ok
.IP -1
If error
.RE
.RE
.sp
.LP
Theses functions are found in files with the names
.B attr_fn_*.c .
The specifics of each function for each attribute type is discussed below.
If new attribute types are defined, not just new attributes of an existing
type, then a new set of functions must be implemented.
.LP
It is important to understand the role of two flags in all these operations:
.IP ATR_VFLAG_SET
indicates the attribute has a value.   This flag is required because with
long integer attributes, any value is possible.  
.IP ATR_VFLAG_MODIFY
indicates the attribute value has changed.  This could be from unset to set,
from one value to another, or from set to unset.  
.LP
.NH 4
.Ix attr_fn_acl.c
.LP
The functions in file
.I src/lib/Libattr/attr_fn_acl.c
implementing the various
.I "Access Control Lists" .
There three types of access control lists supported:
.IP Host\ \ 
The host access list is a list of host and/or domain names in the standard
Internet
.I host.domain.name
form.  This list list is generally used by the server to restrict services
to a set of machines.  It may also be used to limit access to any queue
to jobs from a set of hosts.
The name should be prefixed by a '+' or '-' (minus/hyphen) character to
indicate that access by the named entity is to be allowed or denied.  Absence
of either character is taken to mean access is allowed.
.IP
A host name should be fully qualified, that is be specified with the
full domain name appended: host.domain.name.
A domain name must be prefixed by \*Q*.\*U.  For example, \*Q-*.foo.bar\*U
means access from any system in 
.B domain
foo.bar is to be denied.  While \*Q+foo.bar\*U means access from the 
.B host
foo.bar is allowed.
.IP
Entries are sorted in a special order, from the tail end backwards to the head.
This forces the more fully specified entries to the front of the list where
they will be found first during a search for a match.  Any candidate host that
compares equal to an entry from the tail end to the head or up to an asterisk
is considered a match.
.IP User\ \ 
User access control lists may be used to restrict certain queues to jobs
from a specified list of users.  The user list format is very similar to
that of the
.At user-list
job attribute.  Each entry is in the form
.Av user-name@host.domain ,
where host may be wild carded with the use of an '*'.  Note, if just a
user name is supplied, the server will append \*Q@*\*U.  Each entry should
be prefixed by a '+' or '-' as with the host ACL.
.IP
The ordering of the entries in the list is by sorting on the user name first,
then on the host/domain name in the same fashion as with the host ACL.
.IP Group
The group list is the simplest list.  It is just a list of group names.
Typically, a group ACL is only applied to an execution queue to restrict
it to members of certain groups.  For a job, the group compared against the
list is the group under which the job would execute (which is why we don't
have group ACLs on routing queues).  There is no special format or sorting
performed for group ACLs.
.LP
The entries in any list are created from the comma-separated values in a
Manager batch request that sets the attribute, see qmgr(1) and pbs_manager(3).
The individual entries may be provided in any order.  The host ACL function 
.I set_hostacl()
and the user ACL function 
.I set_uacl()
will sort the entries as they are added.
This sort order is important to acl_check().
.LP
The access list may be lengthy.  For this reason, the list is not saved with
the other attributes of the parent object.  Rather each list is maintained in
its own file.  The location of the file depends on the parent object.
The server host ACL is under the server database directory.  All of the
queue host ACL files are under a directory with the name of the attribute.
The file's base name is the queue name.
.LP
The internal and external forms of the host access list are identical to the
array of strings form used by attributes of type 
.Sc ATR_TYPE_ARST .
In fact, the  at_decode, at_encode, at_comp, and at_free routines for access
list attributes are decode_arst(), encode_arst(), comp_arst() and free_arst().
The at_set routine for hosts (set_hacl) and users (set_uacl) are different
to provide the special sorting needed for a host access list.  A new routine, 
.I acl_check() ,
provides the capability to check a candidate name against the access list.
.LP
.Fn set_uacl()
.Cs
int set_uacl(attribute *attr, attribute *new, enum set_op op)
.Ce
.LP
This routine is just a wrapper.  It calls 
.I set_allacl()
with the additional parameter which indicates the ordering function for
the user type of ACL.
.Fn set_hostacl()
.Cs
int set_hostacl(attribute *old, attribute *new, enum set_op op)
.Ce
.LP
Again, this is just a wrapper that calls
.I set_allacl()
with the ordering function specific for the host ACL type.
.Fn set_allacl()
.Cs
static int set_allacl(attribute *pattr, attribute *new, enum set_op op,
	      int (*order_func)() )
.Ce
.LP
The set_allacl function updates the array of strings for the attribute
pointed to by old according to the operation.
.RS .25i
.IP Set
The complete set of access list entries in the old attribute are 
replaced by those in the new attribute.  This is done by freeing the old
array and rebuilding it one entry at a time to place them in sorted order.
[Its slow to execute, but quick to write, look to optimize later.]
.IP Incr
Each entry in the new list is added to the old list.  The new entries
are sorted into place.  The ordering function
.At order_func()
passed as a parameter
is used to determine the relative order of two entries.  
When a new entry is to be inserted between existing entries, both the index to
and the actual strings of following entries must be moved up to make room
for the new entry.  This is a bit messy as the memcpy() does not guarantee
to work if the two areas overlap as they will here.  So we code the move
character by character.
.IP Decr
As in set_arst(), any matching substrings are removed.  
Each entry in turn is checked for a match.
Note, the prefix characters, '+', '-', or '*' must also match.
.RE
.LP
.Fn acl_check()
.Cs
int acl_check(attribute *pattr, char *entry, int type)
.Ce
.IP Args: 4
.RS
.IP pattr
Pointer to the host access control list attribute.
.IP entry
Name of the user, group, or host requesting access.
.IP type
the type of the ACL:
.SC ACL_User ,
.SC ACL_Group ,
or
.SC ACL_Host .
.RE
.IP Returns: 4
.RS
.IP 1
if the host name matched an entry permitting access.
.IP 0
if access is not permitted.
.RE
.LP
This function will look for a matching entry in a access control list.
It starts with the first entry and works till a match is found or the end
of the list is reached.  Any single leading '+' or '-' in the list entry
is ignored in determining a match.
A match is found when the supplied entry matches an entry in the list.
All comparisons are performed with a routine specific to the ACL type.
With the list sorted as discussed earlier, the first match found will always
be the most specific match possible in the list.
.LP
If a match is found, access is denied if the list entry begins with
a \*Q-\*U character.  Otherwise access is allowed.  
If a match is not found but an entry with only a \*Q+\*U or \*Q-\*U character
was noted, then that + or - established the default access (allowed for +,
denied for -).  If a default entry was not found, then access is allowed if
the routine was complied with 
.Sc HOST_ACL_DEFAULT_ALL
defined, otherwise denied. 
.LP
For a host access list, 
if the list is not set or is empty, access is still allowed from
the local host.  For all list types, if this routine is complied with
.Sc HOST_ACL_DEFAULT_ALL
defined, then anybody is allowed access if the list is empty or unset.  This
is very insecure and not recommended.
.Fn user_match()
.Cs
static int user_match(char *candidate, char *master)
.Ce
.IP Args: 4
.RS
.IP candidate
a candidate user_name@host requesting access.
.IP master
an entry from the user ACL.
.RE
.IP Returns: 4
.RS
.IP 0
if the entries match.
.IP 1
if they do not match.
.RE
.LP
This function is used by
.I acl_check()
for user ACLs.  The candidate is compared against the ACL entry starting with
the user name up to the end of the master or the occurrence of an '@' in the
master.  If the master ended, the candidate must also end or start the "@host"
section.  If the master contains an '@', so must the candidate.
If master and candidate match so far through the user name, then
.I hacl_match()
is called with the host sub-strings (following the asterisk) to complete
the comparison.
.Fn user_order()
.Cs
static int user_order(char *s1, char *s2)
.Ce
.IP Returns: 4
.RS
.IP -1
s1 sorts before s2.
.IP 0
s1 and s2 are equal.
.IP +1
s1 sorts after s2.
.RE
.LP
S1 and s1 are stings of the form
.Av username@host.domain .
The two strings are compared first from the start of the user name up to the
asterisk and then from the tail end back to the asterisk by calling
.I host_order() .
.Fn hacl_match()
.Cs
static int hacl_match(char *candidate, char *master)
.Ce
.IP Args: 4
.RS
.IP candidate
a candidate host name (with domain name) requesting access.
.IP master
a entry from the host ACL of the form
.Av host.domain.name
or
.Av *.domain.name .
.RE
.IP Returns: 4
.RS
.IP 0
if candidate matches master.
.IP 1
if not a match.
.RE
.LP
The character by character comparison begins at the tail end of the two
strings and continues until (1) a character does not match,
(2) the head of either string is reached.
.LP
If the two strings are identical, or if the head of the master entry is
reached first and its first character is the wild card asterisk, then
the two stings are considered equal.
.Fn host_order()
.Cs
static int host_order(char *s1, char *s2)
.Ce
.IP Args: 4
.RS
.IP s1
a string which is a host acl entry.
.IP s2
a string which is a host acl entry.
.RE
.IP Returns: 4
.RS
.IP -1
if s1 sorts before s2
.IP 0
if s1 sorts equal with s2
.IP 1
if s1 sorts after s2
.RE
.LP
This routine is called by set_allacl() when it is determining the order
of the new host acl entry in the list.
It compares two strings from the trailing end first.
A leading '+' or '-' characters are ignored on each string.
The first inequality
before the head of the string terminated the comparison.  If the strings
are equal in length and sort equal up to the first character of the strings,
and one string has a first character that is an '*', then that string
is sorted after the other.  This places domains after specific host names.
.NH 4
.Ix attr_fn_arst.c
.LP
The functions in file
.I src/lib/Libattr/attr_fn_arst.c
deal with attributes of type
.B arst
\-
.B ar ray
of
.B st rings.
The external form of the value is a comma-separated set of strings:
\f5string1,string2,string3,...\fP.
The internal form of attribute (value) is a pointer to a control
structure:
.Cs
struct array_strings {
int	    as_npointers;   /* number of pointer slots in this block */
int	    as_usedptr;     /* number of used pointer slots          */
int	    as_bufsize;     /* size of buffer holding strings        */
char   *as_buf;         /* address of buffer                     */
char   *as_next;        /* first available byte in buffer        */
char   *as_strings[2]   /* first (two) strings pointers          */
};
.Ce
The above structure is allocated.
A separately allocated buffer is used to hold the comma-separated string
which has the commas replaced with nulls, turning it into multiple strings.
Each \*Qsub\-string\*U is pointed to by a member of the array of pointers,
as_strings.  
.LP
When more than two sub-strings exist, the array_strings structure is
expanded to allow more than two members in as_strings.
.Fn decode_arst()
.Cs
int decode_arst(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
If the value string is null, then clear the ATTR_FLAG_SET flag to indicate
no value present and return.
.LP
Allocate a buffer to hold sub\-strings.
Replace commas with null and count the number of sub\-strings.
Allocate array_strings control structure large enough for pointers to 
all sub\-strings and initialize the pointers.
.LP
Set the ATTR_FLAG_SET flag.
.Fn encode_arst()
.Cs
int encode_arst(attribute *pattr, list_head *phead, char *atname,
	char *rsname, int mode)
.Ce
.LP
The function
.I attrlist_create()
is called to create a svrattrl entry of size sufficient to contain 
all the data in the array of strings.  The strings in the array are
concatenated together.
The nulls separating the encoded sub\-strings are replaced with either
commas for all modes except
.Sc ATR_ENCODE_SAVE .
For save, the sub\-strings are jointed with new-lines.
The 
.Sc ATR_ENCODE_SAVE
mode is used for access control lists or other items
taken from a editable file.  This produces one big string.
This string is copied into the svrattrl entry.
.Fn set_arst()
.Cs
int set_arst(attribute *old, attribute *new, enum set_op op)
.Ce
.LP
If the operation is 
.I Set ,
a copy of the attr_strings and buffer replace that of the old attribute.
The old attribute attr_strings and buffer are freed.
.LP
If the operation is
.I Incr ,
each sub\-string in new is added to the set of sub\-strings in the old.
.LP
If the operation is
.I Decr ,
the first sub\-string in old which matches a sub\-string in new is removed.
.Fn comp_arst()
.Cs
int comp_arst(attribute *one, attribute *two)
.Ce
.LP
For each index, that sub\-string in the two attributes are compared.
If all match, then 0 is returned, the attribute are identical in content.
Otherwise, +1 is returned for inequality.
.Fn free_arst()
.Cs
void free_arst(attribute *pattr)
.Ce
.LP
Frees both the array_strings structure and the associated buffer.
.Fn arst_string()
.Cs
char *arst_string(char *string, attribute *pattr)
.Ce
.IP Args: 4
.RS
.IP string
a \*Qprefix\*U string for which to search.
.IP pattr
pointer to an attribute of type ATR_TYPE_ARST.
.RE
.IP Returns: 4
.RS
.IP pointer
to the attribute value entry, or null.
.RE
.LP
This function searches the sub-strings which make up the attribute value
for one with begins with the string passed in
.At string.
.LP
If the attribute is unset, or there is no entry with a match, a NULL pointer
is returned.  Otherwise, a pointer to the sub-string entry is returned.
.NH 4
.Ix attr_fn_b.c
.LP
The file
.I src/lib/Libattr/attr_fn_b.c
contains the manipulation functions for attributes of type 
.I boolean .
The boolean value is encoded as an long integer with a value of
1 for true and 0 for false.  No extra value space is required.
.Fn decode_b()
.Cs
int decode_b(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
If the character string
.I val
is the string
.I ATTR_TRUE
("1"), the value is to true (integer 1).
If the character string
.I val
is the string
.I ATTR_FALSE
("0"), the value is to true (integer 0).
Any other value in
.I val
causes an error return.
.Fn encode_b()
.Cs
int encode_b(attribute *pattr, list_head *phead, char *atname,
     char *rsname, int mode)
.Ce
The function
.I attrlist_create()
is called to create the svrattrl entry.
The value is encoded into a string and placed into the entry.
.Fn set_b()
.Cs
int set_b(attribute *old, attribute *new, enum set_op op)
.Ce
.LP
The value of old is set according to the op:
.IP Set
old set to new.
.IP Incr
old set to old inclusive or-ed with new, set bits in old that are set in
new.
.IP Decr
old set to old and-ed ed with not new, clears bits in old set in new.
.LP
.Fn comp_b()
.Cs
int comp_b(attribute *pattr, attribute *with)
.Ce
.LP
If the two values are equal, 0 is returned.
Otherwise +1 is returned,
.NH 4
.Ix attr_fn_c.c
.LP
The file
.I src/lib/Libattr/attr_fn_c.c
contains the manipulation functions for attributes of type (single) character.
The character is stored directly in the attribute structure, no additional
space is required.
.Fn decode_c()
.Cs
int decode_c(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
If
.I val
points to a string, the decoded value is the first character of the string.
Otherwise an error is returned.
.Fn encode_c()
.Cs
int encode_c(attribute *pattr, list_head *phead, char *atname,
     char *rsname, int size)
.Ce
The function
.I attrlist_create()
is called to create a svrattrl entry.
The attribute character value is encoded as a null terminated string of length
one and placed in the entry.
.Fn set_b()
.Cs
int set_b(attribute *old, attribute *new, enum set_op op)
.Ce
.LP
The value of old is set according to op:
.IP Set
Old is set to new.
.IP Incr
For lack of anything better, old is set to the character represented by the
integer sum of old and new.
.IP Decr
For lack of anything better, old is set to the character represented by the
integer difference of old minus new.
.LP
.Fn comp_c()
.Cs
int comp_c(attribute *pattr, attribute *with)
.Ce
.LP
If either attribute pointer is null, -1 is returned, otherwise the normal
(ascii) relation between two characters is returned.
.NH 4
.Ix attr_fn_hold.c
.LP
The file 
.I src/lib/Libattr/attr_fn_hold.c
contains special decode and set routines for the
.At hold-types 
attribute.  All other attribute functions are those for standard
string attributes.
.Fn decode_hold()
.Cs
int decode_hold(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
This function is identical to 
.I decode_str()
except that it requires the value string to contain only the characters
'u', 'o', and 's', the recognized hold types.
.Fn set_hold()
.Cs
int set_hold(attribute *old, attribute *new, enum set_op op)
.Ce
.LP
This function is similar to
.I set_str()
except that each hold type character is only allowed to appear in the value
string once.  For the operation type:
.IP Set
If the attribute to be set has a value string, it is freed and we fall into
the Incr code.
.IP Incr
If the attribute to be set (the old attribute) has a value, the space
is reallocated to extend the space by the size of the new string.  Otherwise,
space for the new string is allocated.  Each character in the new string
not already in the old string is appended.
.IP Decr
Each character in the new string that occurs in the old string is removed
from the old string.  Any following characters are pushed up over top of
the removed character.
.LP
.Fn comp_hold()
.Cs
int comp_hold(attribute *pattr, attribute *with)
.Ce
.LP
If either attribute pointer is null, -1 is returned, if the two hold values
are identical 0 is returned, otherwise +1 is returned.
.NH 4
.Ix attr_fn_inter.c
.LP
The file
.I src/lib/Libattr/attr_fn_inter.c
contains the manipulation functions for an attribute of type long
that is treated in a special manner.  Internally, if set and non-zero, the
job is an interactive job.  The numerical value is number of the port to which
qsub is listening for a connection from the job to transfer input and output.
This is the value sent by qsub and between servers if the job is moved.
It is also sent to MOM when the job is run.  However, to keep the port number
confidential, when the job attributes are being encoded to send to a client
(command), the value is encoded as a boolean,  true for non-zero and false
if zero or unset.  The long integer routines are used for all functions except
except for the encode, see attr_fn_l.c.
.Fn encode_fn_inter()
.Cs
int encode_inter(attribute *pattr, list_head *phead, char *atname,
	 char *rsname, int mode)
.Ce

.NH 4
.Ix attr_fn_l.c
.LP
The file
.I src/lib/Libattr/attr_fn_l.c
contains the manipulation functions for an attribute of type long integer.
.Fn decode_l()
.Cs
int decode_l(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
If
.I val
points to a numeric decimal string, it is decoded into its value.
Otherwise an error is returned.
.Fn encode_l()
.Cs
int encode_l(attribute *pattr, list_head *phead, char *atname,
     char *rsname, int mode)
.Ce
The function
.I attrlist_create()
is called to create an svrattrl entry containing the attribute name.
The integer value is encode by
.I sprintf()
in a null terminated numeric string which is copied into the entry.
.Fn set_l()
.Cs
int set_l(attribute *old, attribute *new, enum set_op op)
.Ce
set_l updates the attribute value with the new value based on the operation
type.  For long integer the operations are as defined as expected:
.IP Set
The replacement of the old value with the new.
.IP Incr
The sum of the old and new values. 
.IP Decr
The difference between the old and new.
.LP
.Fn comp_l()
.Cs
int comp_l(attribute *attr, attribute *with)
.Ce
.LP
comp_l compares the long integer values of the attributes attr and with.
The normal relation is returned.
.NH 4
.Ix attr_fn_ll.c
.LP
The file
.I src/lib/Libattr/attr_fn_ll.c
contains the manipulation functions for an attribute of type 
.Ar Long
integer. The type Long is defined as the largest supported integer type.
See the section 
.B "Long Long Integer Attribute Support"
near the end of this chapter on libattr.a for
information about the Long data support routines.
.Fn decode_ll()
.Cs
int decode_ll(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
If
.I val
points to a numeric decimal string, it is decoded into its value.
Otherwise an error is returned.
.Fn encode_ll()
.Cs
int encode_ll(attribute *pattr, list_head *phead, char *atname,
     char *rsname, int mode)
.Ce
The function
.I attrlist_create()
is called to create an svrattrl entry containing the attribute name.
The Long integer value is encode by
.I uLTostr()
in a null terminated numeric string which is copied into the entry.
.Fn set_ll()
.Cs
int set_ll(attribute *old, attribute *new, enum set_op op)
.Ce
set_ll updates the attribute value with the new value based on the operation
type.  For Long integer the operations are as defined as expected:
.IP Set
The replacement of the old value with the new.
.IP Incr
The sum of the old and new values. 
.IP Decr
The difference between the old and new.
.LP
.Fn comp_ll()
.Cs
int comp_ll(attribute *attr, attribute *with)
.Ce
.LP
comp_ll compares the Long integer values of the attributes attr and with.
The normal relation is returned.
.NH 4
.Ix attr_fn_resc.c
.LP
The file
.I src/lib/Libattr/attr_fn_resc.c
contains the manipulation functions for attributes of type 
.I resource .
Resource attributes are slightly different from other types in that they
are a linked list of resources.  Each named resource has its own definition
structure.  The resource value is maintained in a 
.I attribute
sub-structure to allow sharing of decode, set, and compare functions with
attributes of the same data type.
.LP
Members of a set of resources are not restricted to be of the same data type.
Thus the \*Qparent\*U attribute functions work through a process
of (1) identifying the resource by name and (2) invoking the corresponding
resource function.  See the header file resource.h.
.LP
Another difference between regular attributes and resources is the extra
level of naming.
The resource name, in the external form, is passed as part of the value
string, the resource value string is in the form:
.Ty resource_name=resource_value ,
for example,
.Ty cput=10 .
The parent resource attribute function will separate the value string into two
sub-strings by replacing the '=' sign with a null.  It uses the first 
sub-string to identify the resource and then passes the following sub-string as
the \*Qtrue\*U value string to the proper decode function.
.LP
.Fn decode_resc()
.Cs
int decode_resc(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
Find resource definition entry matching the resource name which is the
first string in the \*Qvalue\*U string
.I val .
This done by calling
.I find_resc_desc()
and
.I find_resc_entry() .
If there is not a entry in the list for the named resource, the function
.I add_resource_entry()
is called to create one.
.LP
The pointer to the value string is then reset past the resource name,
and the decode function (rs_decode) for the specific resource type is called.
.LP
In order to decode a resource, the caller must have either some form of
write access to the resource set in 
.Av resc_access_perm ,
or it must be set to the special value
.Sc ATR_DFLAG_ACCESS
which is done when recovering attributes and resources at server startup,
see attr_recov().
.Fn encode_resc()
.Cs
int encode_resc(attribute *pattr, list_head *phead, char  *atname,
	char *rsname, int size)
.Ce
This encode routine is a bit different from most.  It has to iterate through
the linked list of resources, encode each into a 
.I svrattrl 
form including the resource name.
.LP
Each resource value entry, which is very similar to an attribute value,
contains a pointer to the resource definition structure.  The resource name
is obtained from the definition structure and passed to the resource specific
encode routine to create the svrattrl entry.
.LP
If the encode mode is set to
.Sc ATR_ENCODE_CLIENT
or
.Sc ATR_ENCODE_MOM ,
then all resources for which the setting of
.Av resc_access_perm
includes any read access, including any resource entries with the
.Sc ATR_VFLAG_DEFLT
flag set are encoded.
.LP
Otherwise if the encode mode is set to
.Sc ATR_ENCODE_SVR 
or
.Sc ATR_ENCODE_SAVE
all entries except those with
.Sc ATR_VFLAG_DEFLT
set are encoded.  This allows default to be status-ed or passed
to MOM, but not saved, nor passed to a different server.
.Fn set_resc()
.Cs
int set_resc(attribute *old, attribute *new, enum set_op op)
.Ce
This function sets the resource value in the list headed by the attribute
.I old
to the corresponding resource value in the list headed by the attribute
.I new .
This is repeated for each resource in new.  A resource may not be specified
in new which does not exist in old except when the set function is 
.I Set .
.LP
For each resource in new, find the resource in old pointing to the save
resource_def structure, \*Qit has the same name.\*U
If one is not found in old, and the set operation is not Set, return an
error.  If the operation is set, then create the corresponding resource
in old via add_resource_entry().
.LP
Invoke the rs_set() function for this resource.
.Fn comp_resc()
.Cs
int comp_resc(attribute *pattr, attribute *with)
.Ce
This routine behaves differently than is specified for at_comp().
.LP
Since a resource attribute is a list of separate resources, no single
return can indicate the relationships of all the resources in the two
attributes.  Instead, the function return value for comp_resc() is zero
if the compare was successful and
the real returns are set in four global variables:
.At comp_resc_gt ,
.At comp_resc_eq ,
.At comp_resc_lt ,
and
.At comp_resc_nc .
Or, the function return value is -1, meaning there was a bad attribute pointer.
Each of the three global variables variables contains the number of resources
in the list headed by
.Ar pattr
which compared greater than, equal to, or less than the corresponding resource
in the list headed by
.Ar with .
Please note the comparison relationship is
.DS C
(resources in \f2pattr\f1) \f3OP\f1 (resources in \f2with\f1)
.DE
and only those resources in
.Ar with
that are 
.I set
and are not set to a
.I default
value are checked; if there are resources in 
.Ar pattr
not in 
.Ar with ,
they are ignored.
If there are resources in 
.Ar with
not in
.Ar pattr ,
the global 
.At comp_resc_nc
(not compared) is incremented.  The caller may decided if this is an error
situation.
.LP
The global counts are useful in checking the resource requirements of a job
against the resource limits of a queue, see
.I svr_chkque() .
.LP
For each resource in the list headed by
.Ar with ,
comp_resc finds the corresponding resource
(one that has a pointer to the same resource_def structure) in 
.Ar attr .
.LP
If the corresponding resource is not set to a value, or set to a queue or
system default value,
.At comp_resc_nc
is incremented.   This is teated as
an unlimited amount.  This allows an administrator to set up queues without
initializing the resources she doesn't care about.
.LP
When the corresponding resource is set,
the rs_comp() function is called with the two resource entries.  If the
comparison of the resource from the list
.Ar pattr
with the resource from the list
.Ar with
is +1 (greater than) then, 
.At comp_resc_gt
is incremented; if -1 (less than), then
.At comp_resc_lt
is incremented; otherwise (equal) 
.At comp_resc_eq
is incremented.
The comparison continues with the next resource in
.Ar with .
When completed, return zero as a success flag.
.Fn free_resc()
.Cs
void free_resc(attribute *pattr)
.Ce
.LP
Each entry in the resource list headed by the attribute is unlinked
and the space is freed.
.Fn find_resc_def()
.Cs
resource_def *find_resc_def(resource_def *rscdf, char *name, int limit)
.Ce
.IP Args: 4
.RS
.IP rscdf
Pointer to the start of the resource definition array.
.IP name
The name of the resource.
.IP limit
The number of resources defined in the array pointed to by rscdf.
.RE
.IP Returns: 4
.RS
.IP Pointer
to the resource definition structure matching the specified name.
.RE
.LP
This function walks the resource definition array till it finds a name
match.  A pointer to that entry is returned.  If a match is not found,
a NULL pointer is returned.
.Fn find_resc_entry()
.Cs
static resource *find_resc_entry(attribute *pattr, resource_def *rscdf)
.Ce
.IP Args: 4
.RS
.IP pattr
A pointer to the attribute which heads a linked list of resource values.
.IP rscdf
A pointer to a resource definition.
.RE
.IP Returns: 4
.RS
.IP Pointer 
to resource entry or NULL if one not found.
.RE
.LP
This function walks the resource entry list until a entry is found that
points to the specified resource definition.  A  pointer to that entry
is returned.  If one is not found, a NULL pointer if returned.
.Fn add_resource_entry()
.Cs
resource *add_resource_entry (attribute *pattr, resource_def *prdef)
.Ce
.IP Args: 4
.RS
.IP pattr
Pointer to the attribute which heads the resource entry list.
.IP prdef
Pointer to a resource definition structure.
.RE
.IP Returns: 4
.RS
.IP Pointer
to the newly added entry, or NULL on error.
.RE
.LP
This function inserts a new entry into a resource entry list headed by
the attribute pointed to by pattr.
The new entry type is given by the resource definition structure pointed to by
prdef.
The new entry is placed in the list alphabetically by resource name.  This is
just a convenience for listing the resources.
.LP
The existing list is walked until an entry is found that comes after the new
entry or till there are no more entries.  Should an entry with the name
already exist, it is returned.  Memory for the new entry is allocated, and
the entry is inserted into the list via a call to insert_link().
The type field in the entry is set to that of the definition, and the
\*Qvalue is unset\*U flag is marked on.  A pointer to the new entry is returned.
.Fn action_resc()
.Cs
int action_resc(attribute *pattr, void *object, int actmode)
.Ce
.IP Args: 4
.RS
.IP pattr
pointer to resource_list attribute for a job.
.IP object
pointer to parent object (job), not used.
.IP actmode
the type of action.
.RE
.IP Returns: 4
.RS
.IP zero
on all cases.
.RE
.LP
This is the 
.I at_action()
routine for the job attribute resource_list.  It is called whenever
the attribute is modified.  It will check each resource in the attribute
and if that resource has been modified,
.Sc ATR_VFLAG_MODIFY
is set, and has an action routine declared, the action routine is called.
Note, when calling the resource action routine, the object pointer, second
argument, points to the original attribute, not the job.
.Sc ATR_VFLAG_MODIFY
is cleared.  This prevents additional calls to the individual action routines
on the next cycle through the resources when another resource is modified.
.LP
Recommended reading, please take a look at 
.I set_node_ct()
in rc/server/svr_resc_def_sp2.c.
.NH 4
.Ix attr_fn_size.c
.LP
The file
.I src/lib/Libattr/attr_fn_size.c
contains the manipulation functions for attributes of type \*Qsize\*U.
A size value is an integer with a one or two character optional suffix.
The first character is k, m, g, t, or p for kilo (1024), mega, giga, tera, and
penta.  Upper case letters may also be used.
The second character character is either b or B for bytes; or w or W for
words, the size of an integer.
.LP
The value is contained with in the attribute in two fields defined in
attribute.h by
.I "struct size_value .
The first field is an unsigned long holding the specified integer.
The second field is the scaling factor, actually a shift count, to the
size suffix.  A k is represented by 10 (2^10), m by 20, etc.
.LP
The use of bytes is assumed unless w or W was specified.  The
.Sc ATR_VFLAG_WORDSZ
is set in at_flags.
.Fn decode_size()
.Cs
int decode_size(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
The value string is passed to the function
.I to_size()
which decodes the numeric part into
at_val.at_size.atsv_num, and process the suffix for the setting of 
at_val.at_size.atsv_shift and at_val.at_size.at_sv_units.
.Fn encode_size()
.Cs
int encode_size(attribute *pattr, list_head *phead, char *atname,
       char *rsname, int mode)
.Ce 
.LP
The function
.I from_size() 
is called to translate from the at_val.at_size structure to a string.
The function
.I attrlist_create()
is called to create a svrattrl entry containing the attribute name.
The encoded string is copied into the entry.
.Fn set_size()
.Cs
int set_size(attribute *old, attribute *new, enum set_op op)
.Ce
.LP
The value of the old attribute is set with the new value based
on the operation type.
Both values is save in a temporary attribute and the operations are
performed on them.  If there are any errors, the original value is undisturbed.
.IP Set
Temporary is set to the numeric and shift value of the new.  
.IP Incr
The values are normalized to the smaller of the shift counts by calling
.I normalize_size() .
Temporary is set to the sum of the temporary and new values.. 
If the resulting value overflowed, error
.Er PBSE_BADATVAL
is returned.
.IP Decr
The values are normalized to the smaller of the shift counts by calling
.I normalize_size() .
Temporary is set to the difference of the temporary and new values.. 
If the resulting value underflowed, error
.Er PBSE_BADATVAL
is returned.
.LP
If there were no errors, the old attribute is set equal to the temporary
attribute.
.LP
.Fn comp_size()
.Cs
int comp_size(attribute *attr, attribute *with)
.Ce
.LP
This function compares numerically, the values of the attribute 
.Ar attr
and 
.Ar with .
The two attribute values are normalized by calling
.I normalize_size() .
If they cannot be normalized, then they are not equal and the return
is based on the shift size alone.
Otherwise, the comparison is based on the normalized number part.
.Fn normalize_size()
.Cs
int normalize_size(struct size_value *a, struct size_value *b, 
	   struct size_value *c, struct size_value *d)
.Ce
.IP Args: 4
.RS
.IP a
pointer to an existing size_value structure.
.IP b
pointer to an existing size_value structure.
.IP c
pointer to a size_value structure, the structure is updated.
.IP d
pointer to a size_value structure, the structure is updated.
.RE
.IP Returns: 4
.RS
.IP 0
if successful.
.IP != 0 
if error.
.IP c
the size_value structure pointed to by c is set to the normalized value
of a.
.IP d
the size_value structure pointed to by c is set to the normalized value
of b.
.RE
.LP
The data from the two existing size_value structures are \*Qnormalized\*U
to each other.
This allows the values to be added, subtracted or compared.
.LP
The size_value structures are copied from a to c and from
b to d.
If one but not both of c and d are in byte, not word units,  the size of the
one not in bytes is multiplied by the word size.
If the shift counts in a and b are different, the value
in the one with the larger shift is shifted by the difference and the
sift counts are set equal to the smaller count.
.Fn to_size()
.Cs 
int to_size(char *value_string, struct size_value *size)
.Ce
.IP Args: 4
.RS
.IP value_string
the text string specifying a size value.
.IP size
pointer to a size_value structure, the structure is updated.
.RE
.IP Returns: 4
.RS
.IP 0
if success.
.IP != 0
if error.
.RE
.LP
The numeric part of the string is converted to a long by
.I strtol() .
The suffix letters are used to set the shift count and the word unit flag.
Any error results in a return value of
.Er PBSE_BADATVAL .
.Fn from_size()
.Cs
void from_size(struct size_value *size, char *cvnbuf)
.Ce
.IP Args: 4
.RS
.IP size
pointer to size_value structure to convert to a string.
.IP cvnbuf
point to a buffer in which the string is created.
.RE
.LP
The numeric part of the size, atsv_num, is converted to
an numeric string by
.I sprintf() .  
The shift factor is converted back to the corresponding letter and concatenated
to the numeric string.  If the units are
.Sc ATR_SV_WORDSZ ,
then 'w' is appended, otherwise 'b' is appended to the string.
.NH 4
.Ix attr_fn_str.c
.LP
The file
.I src/lib/Libattr/attr_fn_str.c
contains the manipulation functions for attributes of type \*Qstring\*U.
The value string is contained in space dynamically allocated and pointed to
by the attribute.
.Fn decode_str()
.Cs
int decode_str(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
decode_str takes a string and returns it as a string!
Space is allocated for the value and the string is copied into it.
.Fn encode_str()
.Cs
int encode_str(attribute *pattr, list_head *phead, char *atname,
       char *rsname, int mode)
.Ce 
.LP
The function
.I attrlist_create()
is called to create a svrattrl entry containing the attribute name.
The value string is copied into the entry.
.Fn set_str()
.Cs
int set_str(attribute *old, attribute *new, enum set_op op)
.Ce
.LP
The value of the old attribute is set with the new value based
on the operation type.
For the Set and Incr operations, the space occupied by the old string is freed
and new space is allocated.
.IP Set
Old is replaced by the new.  
.IP Incr
Old is set to the concatenation of the old and new strings. 
.IP Decr
If old has a substring that matches new, then it is truncated.
The search is from the tail end, so if multiple matching substrings exist,
the last is the one removed.
.LP
.Fn comp_str()
.Cs
int comp_str(attribute *attr, attribute *with)
.Ce
.LP
comp_str compares the strings values of the attribute and "with",
the standard function 
.I strcmp()
is used and its return value is passed back.
.Fn free_str()
.Cs
void free_str(attribute *pattr)
.Ce
.LP
Frees the space allocated to hold the attribute value string.
.NH 4
.Ix attr_fn_time.c
.LP
The file
.I src/lib/Libattr/attr_fn_time.c
contains the encode and decode functions for attributes of time.
Note, this is an interval time, not the date.  The time is maintained internally
as a long integer number of seconds. 
For the time set and compare functions, set_l() and comp_l() are used.
.LP
.Fn decode_time()
.Cs
int decode_time(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
The input string is assumed to be in the format
.Ty [[hh:]mm:]ss[.sss] .
The string is converted to the corresponding number of seconds.
.Fn encode_time()
.Cs
int encode_unkn(attribute *pattr, list_head *phead, char *atname,
	char *rsname, int mode)
.Ce
.LP
The interval time value contained in the attribute is converted to a string
of the format
.Ty hh:mm:ss[.sss] .
The hours, minutes, and seconds are printed as two digits.  Zero values are
printed as \*Q00\*U.
.LP
The file
.I src/lib/Libattr/attr_fn_unkn.c
contains the manipulation functions for attributes of miscellaneous or unknown
name and type.
These are the attribute whose name was not directly recognized by the server.
It is assumed that they have meaning to the Scheduler or some other server.
.LP
These attributes are treated slightly different
from most other types in that they are maintained as a linked list of structure 
.I svrattrl .
In other words, the decoded form IS the encoded form.
.LP
.Fn decode_unkn()
.Cs
int decode_unkn(attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
It is unfortunate, but \f3decode_unkn() must be called slightly differently\fP
than the other decode routines.  Because decode_unkn must know the attribute
name as well as the value, the parameter
.I name
is required.  Since it must be present for one, it is present for
all the decode routines.
.LP
An entry essentially duplicating the svrattrlst entry containing the triplet
.Av name ,
.Av rescn ,
and
.Av val
is made and linked to the attribute pointed to by
.I pattr .
.Fn encode_unkn()
.Cs
int encode_unkn(attribute *pattr, list_head *phead, char *atname,
	char *rsname, int mode)
.Ce
This encode routine is a bit different from most.  It iterates through
the linked list of svrattrl entries, and duplicate each one and links
the copy into the list headed by
.I phead .
.Fn set_unkn()
.Cs
int set_unkn(attribute *old, attribute *new, enum set_op op)
.Ce
Because the local server does not recognize the attribute and does not
know if duplicates are legal,  the \*Qset\*u operation for unknown
attributes maps to an append operation.   Each of the entries in the
.I new
attribute are appended to the list of entries
in the
.I old
attribute.
.Fn comp_unkn()
.Cs
int comp_unkn(attribute *pattr, attribute *with)
.Ce
The comparison routine is a fake.  Again because the local server does
not recognize the attributes, it will always return +1.  At the time of
this writing, the author cannot think of a case where comp_unkn would be
used.
.Fn free_unkn()
.Cs
void free_unkn(attribute *pattr)
.Ce
.LP
Each entry in the attrlist headed by the attribute is unlinked
and the space is freed.
.NH 4
.Ix attr_node_func.c
.LP
The routines in file
.I src/lib/Libattr/attr_node_func.c
are used when carrying out batch requests that involve the modification
or checking of status of a pbsnode.  Even though pbsnodes were not
defined to have attributes, certain modifications of the data in a pbsnode makes
use of the data structure type 
.I attribute
to accomplish the modifications.  The approach taken directly mimics that
which was established for modification of object attributes.  Each time
a pbsnode is to be modified a temporary array of node-attributes is generated
for the pbsnode.  This array of attributes is then modified atomically just as
real attributes of an object would be modified.  After the modification is
finished, the temporary array of node-attributes is then used to update the
various fields in the subject pbsnode.
.LP
Following along the same vein as the section titled
.At "Attribute Manipulation Functions"
the prototypes and returns for the set of node-attribute manipulation functions
is presented now rather than with each specific function, since one prototype/return
applys to every function callable through any particular function pointer
( at_encode,\  at_decode,\  at_free, etc) of an
.I attribute_def
data structure.  This saves a lot of repetition of prototypes and returns.
.LP
.IP \f3at_encode\fP
.IP Args: 4
.RS
.IP pattr +1
points to struct attribute data structure being encoded
.IP ph
points to head of a list of
.I svrattrl
structs which are to be returned
.IP aname
points to the node-attribute's name
.IP rname
points to the resource's name (unused)
.IP mode
mode code, unused
.RE
.IP Returns: 4
.RS
.IP <\ 0 +1
value is the negative of an error code
.IP \ \ \ 0
encoding occurred successfully
.RE 
.LP
.IP \f3at_decode\fP
.IP Args: 4
.RS
.IP pattr +1
points to an attribute data structure into which the external
form of attribute data is decoded
.IP name
attribute name
.IP rescn
resource name, unused in this application
.IP val
attribute value
.RE
.IP Returns: 4
.RS
.IP >\ 0 +1
error occurred, return an error code
.IP \ \ \ 0
decode occurred successfully
.RE 
.LP
.IP \f3at_set\fP
.IP Args: 4
.RS
.IP pattr +1
points to struct attribute data structure to get modified
.IP new
temporary attribute, holds the decoded, modifying information
.IP op
integer code, specifies a modification operation (INC, DEC, etc)
.RE
.IP Returns: 4
.RS
.IP >\ 0 +1
error occurred, return an error code
.IP \ \ \ 0
set opeation occurred successfully
.RE 
.LP
.IP \f3at_action\fP
.IP Args: 4
.RS
.IP new +1
either transform pbsnode information into this node-attribute or
use this node-attribute to modify the pbsnode's internal data
.IP pnode
pointer to the subject pbsnode structure
.IP "actmode\ action mode,"
.SC  "ATR_ACTION_NEW, ATR_ACTION_ALTER"
.RE
.IP Returns: 4
.RS
.IP >\ 0 +1
error occurred, return an error code
.IP \ \ \ 0
node-attribute initialization or pbsnode modification occurred successfully
.RE 
.LP
.IP \f3at_free\fP
.IP Args: 4
.RS
.IP pattr +1
pointer to the node-attribute
.RE
.LP
.Fn encode_state()
.Cs
int encode_state (attribute *pattr, list_head *ph, char *aname, char *rname, int mode)
.Ce
.LP
Once the pbsnode's 
.Av inuse
field datum is placed into an attribute,
the attribute is passed via an indirect function call (at_encode) to this function
where it is encoded into an svrattrl structure, which is then linked on to the list
in the batch reply structure
(a substructure within the batch\ request\ structure).
.LP
.Fn encode_ntype()
.Cs
int encode_ntype (attribute *pattr, list_head *ph, char *aname, char *rname, int mode)
.Ce
.LP
Once the pbsnode's
.Av ntype
field datum is placed into an attribute,
the attribute is passed via an indirect function call (at_encode) to this function
where it is encoded into an svrattrl structure, which is then linked on to the list
in the batch reply structure
(a substructure within the batch\ request\ structure).
.LP
.Fn encode_properties()
.Cs
int encode_properties (attribute *pattr, list_head *ph, char *aname, char *rname, int mode)
.Ce
.LP
Once the pbsnode's 
.I \ properties\ list
is placed into a
.Av prop
attribute (one whose at_val member is a pointer to a struct\ prop),
the attribute is passed via an indirect function call (at_encode) to this function
where it is encoded into an svrattrl structure.  The structure gets linked on to
the list in the batch reply structure
(a substructure within the batch\ request\ structure).
.LP
.Fn encode_jobs()
.Cs
int encode_jobs (attribute *pattr, list_head *ph, char *aname, char *rname, int mode)
.Ce
.LP
Once the pbsnode's struct\ jobinfo\ pointer is placed into a
temporary attribute, this function gets indirectly called (at_encode) to walk the
list of jobs at the node and produce a comma separated job list for sending back to
the requester via an svrattrl structure.
.LP
.Fn decode_state()
.Cs
int  decode_state (attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
For this particular function (indirect via at_decode) the two
arguments that get used are
.Ar pattr,
which points to an attribute whose value is a short, and the argument
.Ar val,
the value for the attribute.
The value argument, val, is decoded from its form
as a string of comma separated substrings and the component
values are used to set the appropriate bits in the attribute's
value field.
.LP
.Fn decode_ntype()
.Cs
int  decode_ntype (attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
For this particular function (indirect via at_decode) the two arguments
that get used are
.Ar pattr,
which points to an attribute whose value is a short, and the argument
.Ar val,
the
.Av value
of the attribute.
At this point in PBS's evolution the two values
.Av time-shared
and
.Av cluster
are the only possible values.  The one thing that is assumed is
that the types are all going to be mutually exclusive.
.LP
.Fn decode_props()
.Cs
int  decode_props (attribute *pattr, char *name, char *rescn, char *val)
.Ce
.LP
For this particular function (indirect via at_decode) the two arguments
that get used are
.Ar pattr,
which points to an attribute whose value is a short, and the argument
.Ar val,
the
.Av value
for the attribute.  Val is a string of comma separated substrings.
Once val's components are decoded into a linked list of "prop"
structures, this list is hung from the
.Ar pattr
argument's
.I at_val
field.
.LP
.Fn set_node_state()
.Cs
int  set_node_state (attribute *pattr, attribute *new, enum batch_op op)
.Ce
.LP
The information in the
.I short
attribute,
.Ar *new,
is used to
update the information in the short attribute,
.Ar *pattr.
The mode of the update is governed by the argument
.Ar op
.Av (SET,INCR,DECR).
The call is indirect via at_set.
.LP
.Fn set_node_ntype()
.Cs
int  set_node_ntype (attribute *pattr, attribute *new, enum batch_op op)
.Ce
.LP
The value field in attribute
.Ar *new
is a short.  It's generated by the decode
routine and used to update the value portion of the attribute
.Ar *pattr,
the mode of the update is goverened by the argument
.Ar op
.Av (SET,INCR,DECR).
The call is indirect via at_set.
.LP
.Fn set_node_props()
.Cs
int  set_node_props (attribute *pattr, attribute *new, enum batch_op op)
.Ce
.LP
The information in the props attribute pointed to by
.Ar new
is used to update the information in the props attribute pointed to by
.Ar pattr.
the mode of the update is goverened by the operations argument
.Ar op,
.Av (SET,INCR,DECR).
The call is indirect via at_set.
.LP
.Fn node_state()
.Cs
int  node_state (attribute *new, void *pnode, int actmode)
.Ce
.LP
Either derive a
.Av state
attribute
.Ar new
from the pbsnode pointed to by argument
.Ar pnode
or update the pbsnode's
.I inuse
bit field using the state
attribute,
.Ar *new.
The choice of which action to perform is determined by the
action mode argument,
.Ar actmode
.Av (ATR_ACTION_NEW,\ ATR_ACTION_ALTER).
The call is indirect via at_action.
.LP
.Fn node_ntype()
.Cs
int  node_ntype (attribute *new, void *pnode, int actmode)
.Ce
.LP
Either derive an "ntype" attribute
.Ar newnode
from the pbsnode pointed to by argument
.Ar pnode
or update a pbsnode's 
.Ar ntype
field using the
.Av ntype
attribute, new.
The choice of which action to perform is determined by the
action mode argument,
.Ar actmode
.Av (ATR_ACTION_NEW,\ ATR_ACTION_ALTER).
The call is indirect via at_action.
.LP
.Fn node_prop_list()
.Cs
int  node_prop_list (attribute *new, void *pnode, int actmode)
.Ce
.LP
Either derive a 
.Av prop\ list
attribute from the pbsnode
or update the pbsnode's prop list from the attribute's prop list.
The choice of which action to perform is determined by the
action mode argument,
.Ar actmode
.Av (ATR_ACTION_NEW,\ ATR_ACTION_ALTER).
The call is indirect via at_action.
.LP
.Fn free_prop_attr()
.Cs
void  free_prop_attr (attribute *pattr)
.Ce
.LP
This function calls
.I free_prop_list()
to remove the null terminated prop
list pointed to by 
.I "pattr->at_val.at_prop."
As part of the
"freeing" operation the attribute's "VALUE\ is\ SET" flag gets
zeroed and the attribute's value (a\ struct\ prop*) is set to 0.
The call is indirect via at_free.
.LP
.Fn free_prop_list()
.Cs
void  free_prop_list (struct prop *pattr)
.Ce
.IP Args: 4
.RS
.IP pattr
points to the head of a list of struct prop's that need to be freed
.RE
.LP
This function walks a null terminated prop list and for each struct\ prop
on the list it frees any string buffer space hanging from it
before freeing the space belonging to the struct\ prop itself.
.Fn load_prop()
.Cs
static int  load_prop (char *val, struct prop *pp)
.Ce
.IP Args: 4
.RS
.IP val
pointer to the string value for the prop structure
.IP prop
pointer to the prop structure in to which to copy the string
.RE
.LP
This function mallocs buffer space to hold the string pointed to by
argument, 
.Ar val.
It copies the string into this new space
and hangs it on the prop\ struct pointed to by the argument,
.Ar pp.
.Fn set_nodeflag()
.Cs
static int  set_nodeflag (char *str, short *pflag)
.Ce
.IP Args: 4
.RS
.IP str
points to a state
value in string form
.IP pflag
pointer to a "bit flags" variable for
.I state
.RE
.LP
Use the value of the input string to set a bit in
the
.Av bit\ flags
variable pointed to by argument
.Ar pflags.
Each call will set one more bit in the flags
variable or it will clear the flags variable
in the special case where
.Ar "*str"
is the value
.Av free.
.NH 4
.Ix attr_atomic.c
.LP
The file
.I src/lib/Libattr/attr_atomic.c
contains routines for performing part of an atomic update of a list
of attributes.  An atomic update is one where all the updates or changes
to an objects attributes are successful, or none are made.
.LP
In general, the steps required to perform an atomic update are:
.IP 1. 4
Decode the new values, stop if any errors.
.IP 2. 4
Duplicate the current values by calling the at_set() function.  Only those
values which are to be changed, must be duplicated.
.IP 3. 4
Update the old value with the new value.  This may be done either in the
actual old attribute or the copy.  If the actual attribute is modified and
later error occur, then the actual attribute must be restored from the saved
copy.  Or the copy can be updated, and when all are successful, then the
actual attribute must be replaced by the modified copy.
.IP
The choice of methods depends partly on how expected are errors to occur.
If errors are expected, update the copy, otherwise update the original.
.IP 4. 4
If the original attributes were updated, free the copies.  If the copies
were updated, clear the copies but make sure not to free any additional space
allocated to a copy, do not call at_free();  the original now points to the
same space.
.LP
.Fn attr_atomic_set()
.Cs
int attr_atomic_set(svrattrl *plist, attribute *old,
	    attribute *new, attribute_def *pdef, int limit,
	    int unkn, int privil, int *badattr)
.Ce
.IP "Args: And a bunch of them there are..." 4
.RS
.IP plist
pointer to list of new attribute values in the svrattrl form.
.IP old
pointer to original attribute array which is to be update.
.IP new
pointer to attribute array to be used for copies.
.IP limit
number of attributes in the new and old arrays.
.IP unkn
attribute index of unknown type attributes if allowed, >= 0.
If unknown attributes are not allowed, then this should be less than zero.
.IP privil
the privilege level of the client, based on read/write flags in the attribute.
.IP badattr
(RETURN) pointer to an integer in which the number of a bad attribute in
the svrattrl is detected.
.RE
.IP Returns: 4
.RS
.IP 0
is successful.
.IP "non zero"
error number if an error is detected.  The ordinal, starting with 1, of the
svrattrl entry is placed in *badattr.
.RE
.LP
This function performs step 1, 2, and 3 described above.  The approach taken
in step 3 is the \*Qupdate the copy\*U approach.
The following is additional useful information:  the
.Sc ATR_VFLAG_MODIFY
flag is set on all attributes which changed.
If the new value is null, effectively an \*Qunset operation\*U, then the
produced copy will have the 
.Sc ATR_VFLAG_MODIFY
flag set but not the
.Sc ATR_VFLAG_SET .  
Thus it is possible to tell what happened.
.LP
Step 4 from above is not included to allow the caller to perform additional
checks before doing the actual modification of the attributes.  For example,
when updating the attributes of a job, there are additional checks to be
make depending of the state of the job.  These checks do not apply to other
objects.
.LP
If the calling routine chooses to complete the update, it should:
.IP \(bu
Free the current 
.B old
attribute value by calling at_free().
.IP \(bu
Replace each element of 
.B old
with the corresponding element of
.B new
if new has been changed,
.Sc ATR_VFLAG_MODIFY
is on.  The calling routine should then free the storage assigned to the
.B new 
attributes without calling
.I at_free()
on the members of new as the same data space is now used by the 
.B current
attributes.
.LP
If the calling routine decides not to complete the update,  it should
completely release
.B new
by calling
.I at_free()
on each element and then freeing the array space itself, see
.I attr_atomic_kill() .
.LP
There is a special test at the beginning where the attribute is identified
by calling 
.I find_attribute() .
For the attributes of the server, queues, and jobs in execution queues,
unknown attributes are not accepted.  The error
.Er PBSE_NOATTR
is returned.  However, for jobs in routing queues, it is legal to have
unknown attributes and to alter them.  Therefore, if the parameter
.At unkn
is positive, it is the index of the \*Qunknown\*U attribute list to which
to append the new value.
.LP
.Fn attr_atomic_node_set()
.Cs
.IP "int attr_atomic_node_set " 20
(svrattrl *plist, attribute *old, attribute *new,
attribute_def *pdef,
.br
  int limit, int unkn, int privil, int *badattr)
.Ce
.IP Args: 4
.RS
.IP plist +4
pointer to list of new attribute values in the svrattrl form.
.IP old
this argument is not currently used
.IP new
pointer to the node-attribute array
.IP limit
number of elements in the node-attribute definitions array
.IP unkn
if <0 then unknown node-attributes are not permitted
.IP privil
requester's access privilege
.IP badattr
if encounter a bad node-attribute in the batch request, place its list position here
.RE
.IP Returns: 4
.RS
.IP 0 +4
if successful.
.IP non-zero
error code if an error is detected  (if bad node-attribute, put list position in *badattr)
.RE
.LP
This function atomically updates a node-attribute array with values from a batch request's
list of svrattrl structs.  If the updating is successful for all the node-attributes in
the batch request, the function returns success (0).  Otherwise, a non-zero return code
is passed back up the call chain and, if the error was due to a bad node-attribute the
position of this node-attribute in the request list is passed back via the pointer, badattr.
.LP
The sequence of steps involved in the processing is:
.br
For each node-attribute in the request list,
call
.I find_attr()
to determine if the requested node-attribute is in the definitions array.  If it isn't
in the definitions array, use the pointer
.At badattr
to record at what position in the list the error occurred and return back up the call
chain with the error code
.Er PBSE_NOATTR.
.LP
At this point the requested node-attribute is defined, now check the definition's indicated
privilege against the privilege level of the requester.  Return back up the call chain
with the error code
.Er PBSE_ATTRRO
if the requester doesn't have sufficient privilege.
.LP
Next, since the node-attribute exists in the definitions array and enough privilege exists,
decode the data in the request into a temporary node-attribute by invoking, for this
particular node attribute, the
.I at_decode
function from the definitions array.  Should an error occur in the decoding, use baddattr
to pass back where in the request list it occurred and return back up the call chain with
the error code from the decode function.
.LP
Now setup to use the data decoded into the temporary node-attribute.  If the request has not
specified the modification operation for this node-attribute, the operation is taken to be
.At SET,
the node-attribute's modification flag is turned off and the node-attribute's
.I at_set
function from the definition is invoked to perform the
modification to the node-attribute.  Again, if an error occurs badattr is used to pass back
the position where the errror was encountered and the error code
from the at_set function is returned back up the call chain to determine the reply to the
requestor.  Otherwise, if there is another node-attribute in the batch request's svrattrl list
repeat the process else return success (0).
.Fn attr_atomic_kill()
.Cs
void attr_atomic_kill(attribute temp, attribute_def *pdef, int limit)
.Ce
.IP Args: 4
.RS
.IP temp
pointer to a temporary array of attributes.
.IP pdef
pointer to attribute definitions.
.IP limit
number of attributes in the array.
.RE
.LP 
This routine assumes that 
.Ar temp
is a temporary array of attributes, space for which
must have been malloc-ed and which should have been initialized by
.I attr_atomic_set() .
The appropriate at_free routine is called on each element of the array
and then the whole array is freed by a call to free().
.NH 3
Long Long Integer Attribute Support
.LP
This part of the library is intended to make integers larger than \*Qint\*U
available in a portable fashion.  Unfortunately, far too many C vendors have
wimped out and declared long and int to be the same size (32 bits), rendering
long useless.  This package is intended to overcome that bit of vendor
treachery by inventing two new data types that always designate the
largest integer size supported by the compiler.  They are:
.Cs
typedef ?               Long;           /* largest signed integer type */
typedef unsigned ?      u_Long;         /* largest unsigned integer type */
.Ce
.LP
Fortunately, these can be defined to be integer data types larger than
int on all platforms to which we have ported PBS and to which we plan
to port PBS.  In the case of SunOS, that statement is only true using
the GCC compiler instead of the native compiler as the native cc does not
support long long integers.  In all cases except
HP-UX, Long and u_Long represent 64-bit integers.
.LP
For the most part, this is an include file exercise.  The appropriate
include file
.Cs
#include "Long.h"
.Ce
contains a good deal more documentation in its comments.  There are
also five functions associated with the package (four real and one macro).
.NH 4
.Ix LTostr.c
.LP
.Fn LTostr()
.Cs
const char *LTostr(Long value, int base);
.Ce
.IP Args: 4
.RS
.IP value
to convert to a string
.IP base
to use in conversion
.RE
.IP Return:
pointer to string
.LP
Convert a signed
.Ar Long
to a string.
This provides the complementary capability to strToL().  It
converts value into a NULL terminated digit string in the base,
.Ar base .
The pointer to the string that it returns designates a
location in static storage, so it must be copied if it is to
survive another call to LTostr() or a call to uLTostr().
.LP
Static storage was used to make the function easier to use as
an argument to printf().  No free() is required.
.NH 4
.Ix strToL.c
.LP
.Fn strToL()
.Cs 
Long strToL(const char *nptr, char **endptr, int base);
.Ce
Convert string to
.Ar Long
integer type.
This is directly analogous to POSIX strtol(), in every way.
.NH 4
.Ix strTouL.c
.LP
.Fn strTouL()
.Cs 
Long strTouL(const char *nptr, char **endptr, int base);
.Ce
Convert string to unsigned
.Ar Long
integer type.
This is directly analogous to POSIX strtoul(), in every way.
.NH 4
.Ix uLTostr.c
.LP
.Fn uLTostr()
.Cs
const char *uLTostr(u_Long value, int base);
.Ce
Convert unsigned
.Ar Long
to a string.  It is analogous to LTostr().
.NH 4
.Ix Long_.c
.LP
Provides constant data storage.
.NH 4
Long.h
.LP
.Fn atoL()
.Cs
Long atoL(char *nptr);
.Ce
This is a macro defined as
.Ty "strToL((nptr), (char **)NULL, 10)" .
It is directly analogous to POSIX atol(), in every way.

.NH 2
Library:
.Tc "\f3libcred.a - Credential Library\fP"
.Ix libcred.a
.LP
The credential library,
.I libcred.a ,
consists of routines to create an encrypted client authentication credential
and to decrypt the credential, or ticket, into a credential structure.
Together with the
.B pbs_iff
program, this library provides the basic user/client authentication required
by PBS.  This system is explained in the PBS ERS and in the IDS section on
iff.  The routines in this library are used by pbs_iff, and various server
programs.
.LP
The basic PBS credential or ticket contains the following items:
.IP 1.
The user's name and the fully qualified host name encrypted together with a key
generated by pbs_iff.
.IP 2.
The above together with a time stamp encrypted with a key generated by the
server,  and the pbs_iff key itself.
.LP
The user name must match that in the batch request, the hostname must match
that provided by the network routines, and the time stamp must be within
its life time.  The structure of the credential and its life time are defined
in credential.h.
.LP
Should a site or vendor wish to replace the authentication system with a more
general system, such as Kerberos, this library is the place to start.
.QP
NOTE:
.br
The routines in this library are set up to call DES encryption routines.
Because of restrictions on exporting DES out of the USA, these routines
cannot be included in the PBS distribution.  The DES routines used by
PBS are identical to the MIT Athena routines and other common packages.
The source for these routines may be found at many foreign ftp sites.
.LP
.Fn break_credent()
.Cs
struct credential *break_credent(char *key_string, char *ticket, int size)
.Ce
.IP Args: 4
.RS
.IP svr_key
is an (8 character) key used by the server as the ticket encryption key.
.IP ticket
is the full ticket as produced by pbs_iff.
.IP size
is the size of the full ticket string.
.RE
.IP Returns: 4
.RS
.IP pointer
to a struct credential containing the decrypted information.
.RE
.LP
This routine, found in file
.Ix break_credent.c
is used by the server to decrypt the full ticket into
its parts and build the credential structure.
.LP
The key created by pbs_iff and included in the ticket is saved.
The provided server key is used to decrypt
the sealed portion of the ticket.  This yields the time stamp and the
sub-credential encrypted by pbs_iff.
The four bytes of time are converted into at time_t type and placed in the
credential.  
.LP
The sub-credential is decrypted using the saved pbs_iff key.
The user name and host name are copied into the credential.
A pointer
to the credential is returned.
.Fn get_credent()
.Cs
int get_credent(char *server, char **credential)
.Ce
.IP Args: 4
.RS
.IP server
the full name of the server to contact.
.IP
credential
RETURN: the address of the credential is returned, ticket spaced is malloc-ed.
.RE
.IP Returns:
.RS
.IP >=0
positive size of credential.
.IP <0
if error.
.RE
.LP
This routine, see file
.Ix get_credent.c
is used by the pbs_ifl library to obtain a PBS_IFF user
credential to include in a batch request.  When the user client program calls 
.I pbs_connect() ,
it calls this function to fork and exec the 
.I pbs_iff
program to build the credential.  This is done via a
.I popen(3) 
call invoking pbs_iff with the name of the server and port, as used by
pbs_connect().
The credential, or full ticket, is read from the pipe which is closed.
If the size of the received credential is incorrect, or the exit status of
pbs_iff is not zero, a -1 is returned as an error indicator.
.LP
Note, the space for the credential is malloc-ed.  It should be freed by the
client when no longer required.
.Fn make_sealed()
.Cs
int make_sealed(char svrkey[PBS_KEY_SIZE], char *subcred, int size,
	char **sealed)
.Ce
.IP Args: 4
.RS
.IP svrkey
an (8 character) key that is the server encryption key.
.IP subcred
the sub-credential passed from pbs_iff.
.IP size
of the sub-credential.
.IP sealed
RETURN: a pointer to the sealed (encrypted) ticket, in static space.
.RE
.IP Returns: 4
.RS
.IP
the size of the encrypted ticket is returned as the function value.  If an
error occurs, -1 is returned.
.RE
.LP
This routine, see file
.Ix make_sealed.c
is used by the server to produce the sealed ticket portion
of the credential.  This portion consists of the already encrypted user and
host names and a time stamp.  These items are again encrypted using the
server's key.
.LP
The sub-credential, the user and host name encrypted by pbs_iff and sent
to the server, is checked to insure its size is correct.
.LP
The time is obtained and converted from a time_t (which according to POSIX
just might be a real number) to a long integer.  Only the least significant
4 bytes of the the integer time is included in the ticket to allow for
different word sizes.
.LP
The information is encrypted into a string, which is a multiple of 8 bytes.
A pointer is returned in ticket and the length of the string is returned as
the function value.
.Fn make_svr_key()
.Cs 
void make_svr_key(char key[PBS_KEY_SIZE])
.Ce
.IP Args:
.RS
.IP key
RETURN: the generated key
.RE
.LP
This function, also in file make_sealed.c, is
called by the server to generate an encryption key.
The function does nothing but call the des library routine
.I des_random_key() .
This function just services to isolate the server from the des library
and header files.
.Fn make_subcred()
.Cs
int make_subcred(des_cblock key, char *user, char **subcred)
.Ce
.IP Args: 4
.RS
.IP key
an encryption key provided by the caller.
.IP user
the name of the user to include in the credential.
.IP subcred
RETURN: a pointer to the encrypted string is placed into subcred.
.RE
.IP Returns: 4
.RS
.IP
the size of the encrypted string is returned as the function value.  If an
error occurs, -1 is returned.
.RE
.LP
This routine is used by 
.B pbs_iff 
to produce the sub-credential to be sent to a server.  At the server, the
sub-credential is included in the sealed-ticket which is returned to pbs_iff.
.LP
The full host name is obtained by calling
.I get_fullhostname() .
This process is performed to make sure we get the fully qualified
name when the system administrator may have only set the local name
(without the domain name).  
.LP
The information is encrypted using the supplied key into a string,
which is a multiple of 8 bytes.
A pointer is returned as in subcred and the length of the string is returned
as the function value.

.NH 2
Library:
.Tc "\f3liblog.a - Log Record Library\fP"
.Ix liblog.a
.LP
The log record library,
.I liblog.a ,
consists of routines to record a series of events and errors in a log file.
the use of this library will provide a consistent format for the records in
the log file.
Each log file entry is one line of text, terminated with a new line.
Each line is made up of several fields, with a semicolon, ';', between fields.
The fields are:
.IP "date time"
The date and time the entry was added to the log.  The date is in
month/day/year format.
The time is in 24 format with hours, minutes, and seconds
in the format hh:mm:ss.
.IP "Event Type"
This field is a hexadecimal number, where each \*Q1\*U bit identifies the
type of event recorded, see log.h.
.IP "Server Name"
This names the server which recorded the entry.  While only a single server
records in each file, this field is provided to allow a site to merge the
files together for processing.
.IP "Object Class"
This field identifies the object class affected by the event.  Current classes
are:
.br
Fil - A job related file
.br
Req - a batch request
.br
Job - a batch job
.br
Que - a queue
.br
Svr - the server
.br
.IP "Object Name"
The name of the object affected by the event.
.IP Text
This field contains the text of the message.
.LP
The server lib is divided into two parts, with each part in its own 
source file.  Part one, in file
.I pbs_log.c ,
is code which is independent of the main PBS Server.
Part two, in file
.I log_event.c ,
either requires knowledge of the server attributes or is only useful to
the server.
.NH 3
.Fi pbs_log.c
.LP
The file
.I src/lib/Liblog/pbs_log.c
contains the functions to record information to a log file.
Either \*Qevent\*U records or error records are recorded.
The necessary support functions to open and close log files
are also included.  The file descriptor and open status for the log file are
maintained within the scope of this file.
.Fn log_open()
.Cs
int log_open(char *filename, char *directory)
.Ce
.IP Args: 4
.RS
.IP filename
Name of log file to open.  Null to used default name based on the date.
.IP directory
Name where default log files are maintained.
.RE
.IP Returns: 4
.RS
.IP 0
On success.
.IP -1
If Error.
.RE
.LP
The function attempts to open the file specified by
.I filename
in append mode.
If it cannot be opened or it is the null pointer or null string,
an error is returned.
When opened, the stream is set for no buffering to minimize message
lost on a crash of the server.
A message is written in the new log file to record the time at which 
it was opened.
.LP
The file descriptor for the opened log file is maintained in a variable
whose scope is limited to the file containing the log routines.
The julian date when the log file was opened is also maintained as a static
variable, see log_record().
.Fn log_err()
.Cs
void log_err(int err, char *routine,  char *text)
.Ce
.IP Args: 4
.RS
.IP err
The system error number as found in 
.I errno
if it applies.  A value of -1 indicates PBS found an error other than
on a system call.
.IP routine
The name of the routine calling log_err.
.IP text
The message text to record.
.RE
.LP
This function is used to record internal errors.  The error is recorded
in the log file and, if configured, sent to
.I syslog .
.LP
If the log file is not open when log_err() is called, it will either use the 
.I syslog
facility, if configured, or write to 
.Ty /dev/console .
.Fn log_record()
.Cs
void log_record(int type, int class, char *name, char *text)
.Ce
.IP Args: 4
.RS
.IP type
The type of event.  Used to determine if this event is recorded.
.IP class
The class of the object: 
.Sc PBS_EVENTCLASS_SERVER ,
.Sc PBS_EVENTCLASS_QUEUE ,
.Sc PBS_EVENTCLASS_JOB ...
affected by the event.
.IP name
The name of the effected object.
.IP text
The text to record as part of the log entry.
.RE
.LP
This function is used to record normal events regardless of the event type, see
.I log_event()
below.
When log_record() is called and the current julian date is not the same as the
one recorded by log_open(), and if the default log name is being used (the 
date), then the log is closed and reopened under the new current date.
.LP
If an error occurs on the write, the current FILE pointer is saved and
the log's pointer is replaced with one pointing to /dev/console.
.I log_error()
is called to display an error message to the effect that logging is not
working.
.Fn log_close()
.Cs
void log_close(int msg_flag)
.Ce
.IP Args: 4
.RS
.IP msg_flag
if non-zero, log the \*Qlog closed\*U message.
.RE
.LP
Closes the currently opened log.
.NH 3
.Fi log_event.c
.LP
The file
.I src/lib/Liblog/log_event.c
contains log related code that is specific to logging only certain types of
events.
.Fn log_event()
.Cs
void log_event(int type, int class, char *name, char *text)
.Ce
.IP "Args (identical to log_record):"
.RS
.IP type
The type of event.  Used to determine if this event is recorded.
.IP class
The class of the object: 
.Sc PBS_EVENTCLASS_SERVER ,
.Sc PBS_EVENTCLASS_QUEUE ,
.Sc PBS_EVENTCLASS_JOB ...
affected by the event.
.IP name
The name of the effected object.
.IP text
The text to record as part of the log entry.
.RE
.IP "Global variables:"
.RS
.IP log_event_mask
is a pointer to long type.  The value to which it points is a mask which
is checked to determine if the event type is being recorded.
.RE
.LP
If
.Sc PBSEVENT_FORCE
is set in the argument
.At type ,
the event type will be recorded regardless of the 
.Ty *log_event_mask
mask value.  Otherwise, the 
.At type
arguement is and-ed with value pointed to by
.Av log_event_mask .
If the result is non-zero, the event is included in the types to be logged.
If the event is to be recorded, the arguments are passed on to
.I log_record() .
The initial setting of the logging mask includes logging error, system, 
admin, job, and security events.
.Fn log_change()
.Cs
int log_change(attribute *pattr, void *parent, int actmode)
.Ce
.IP Args: 4
.RS
.IP pattr
pointer to the server attribute
.At log-file .
.IP parent
Unused.
.IP actmode
Unused.
.RE
.IP Returns: 4
.RS
.IP 
Returns the return value of log_open().
.RE
.LP
This is the \*Qat_action\*U function for the server attribute
.At log-file .
It is invoked whenever the attribute value is changed.
All the function does is call 
.I log_open()
with the log file name.
.NH 3
.Fi chk_file_sec.c
.LP
The file
.I src/lib/Liblog/chk_file_sec.c
contains the security validation routine chk_file_sec().
This function is in liblog.a because it is a handy library that all the
daemon include.
.Fn chk_file_sec()
.Cs
int chk_file_sec(char *path, int isdir, int sticky, int disallow, int full)
.Ce
.IP Args: 4
.RS
.IP path
The full path name of the file to be checked.
.IP isdir
set non-zero if the path should be the name of a directory, zero for a file.
.IP sticky
set non-zero if group/other write is allowable on a directory if and only if
the sticky bit is set on the directory.
.IP disallow
File mode bits (see sys/stat.h) that should not be allowed on this file.
.IP full
if non-zero, check the full path, i.e. all parent directories.  Generally set
zero only when the parents have already been checked.
.RE
.IP Returns: 4
Zero if path is secure, otherwise a non-zero error code indicating the problem.
.LP
This function is used by each of the daemons and by the supplied utility
.I chk_tree
to perform a security check on critical daemon files.  Generally, these files
should not be writable to any one other than root.  The routine calls itself
recursively to check the parent directives.  The check occurs from the root
directory downward in case of symbolic links.
.NH 3
.Fi setup_env.c
.LP
The file
.I src/lib/Liblog/setup_env.c
contains the security routine setup_env().
This function is in liblog.a because it is a handy library that all the
daemon include.
.Fn setup_env()
.Cs
int setup_env(char *filename)
.Ce
.IP Args: 4
.RS
.IP filename
the name of the environment definition file.
.RE
.IP Returns: 4
Non-zero on any error.
.LP
The purpose of this routine is to insure a \*Qsecure\*U environment for the
daemons.  This prevents an attacker from using the environment to impact 
the actions of the daemons or any programs run by the daemons.
.LP
If the filename is null or the null string, the routine returns without error.
Otherwise, the environment will be updated.  If the file cannot be read
or is empty, the resulting environment is empty.
.LP
For each string in the file not starting with '#' or ' ', the string is assumed
to be of the form:
.Ty name=value
or
.Ty name .
If the first form is found that string is placed into the environment.
If the second, name only, form is found, and there is an existing environment
variable with that name, then the name and that current value are placed into
the new environment.
.NH 3
.Fi svr_messages.c
.LP
The file
.I src/lib/Liblog/pbs_messages.c
contain the text for all messages issued or recorded by various PBS processes.
The purpose of placing the messages in one place is to facilitate
translation \- internationalization.
.Fn pbse_to_txt()
.Cs
char *pbse_to_txt(int error)
.Ce
.IP Args: 4
.RS
.IP error
a PBS error number.
.RE
.IP Returns: 4
pointer to error message associated with the error, or NULL if none.
.LP
This function takes a PBS error number and returns a pointer to the 
message string associated with the error if one exists.
.NH 2
Library:
.Tc "\f3libnet.a - Network Library\fP"
.Ix libnet.a
.LP
The network library contains functions to support the client / server
networking.  Most of the TCP/IP dependent activities are packaged here.
.NH 3
.Fi net_server.c
.LP
The file
.I src/lib/Libnet/net_server.c
contains server side functions to deal with the network.
The supplied functions support a 
.I socket
based
.B TCP/IP
network.  The basic services provided are
.RS
.IP 1. 3
\*QBind\*U to the standard port for PBS
service.
Prepare to receive (listen) connection requests at those addresses.
.IP 2.
Wait (select) for requests for connections on the service addresses, or
for data on prior accepted connections. 
.IP 3.
Accept (accept) connections.
.IP 4.
Close connections when all is done.
.RE
.LP
In addition to the above functions, net_server.c maintains an entry
for each active connection identifying the type of connection, the
time of last activity on that connection, and the function to call when
data is available (to read) on the connection.
.Fn init_network()
.Cs
int init_network(\^unsigned int  port\^, void (*read_func)())
.Ce
.IP Args: 4
.RS
.IP port
The port number to which to bind.
.IP read_func
the function to read data from sockets created by accepting connections
on the service port.
.RE
.IP Returns:
.RS
.IP 0
If initialization successfully.
.IP -1
If initialization failed.
.RE
.LP
Control flow:
.LP
If this first time called, initialize connection state table and the set the
socket to connection type 
.Sc Primary .
If this is the second time called, set the socket connection type
.Sc Secondary .
If we have already been called twice, return an error.
Allocate the socket and bind it to the service port.
Note, after the socket is allocated, a call is made to the system function
.I setsockopt()
with SO_REUSEADDR.    Without this call, the server when shut down and brought
back up quickly will get an \*Qaddress already in use\*U error on the bind.
Even worse, a client that leaves a connection open to the server when the
server goes down can block the server from starting up.  The server would
get the above error forever.
.LP
Save the read function in a two element array based on first or second call.
Note, when data is ready on either the primary or secondary socket, control
is passed to the
.I accept_conn()
routine to accept the connection and allocate a new socket.  These sockets are
connection type 
.Sc General .
When data is ready on a general socket, the read routine that was passed on the
.I init_network()
call is invoked, see accept_conn().
.LP
Create the socket and bind it to port number supplied.
Add socket to select set and update connection state table.
Start listening for connection requests.
.Fn wait_request()
.Cs
int wait_request(\^waittime\^)
.Ce
.IP Args: 4
.RS
.IP waittime
The maximum time to delay waiting for a request to arrive; the timeout
on the select call.
.RE
.IP Returns:
.RS
.IP 0
No errors occurred.
.IP -1
Error on select() call.
.RE
.LP
Control flow:
.LP
.nf
Wait for data (select) on set of I/O descriptors.

For each (ready descriptor)
Update time of last activity for connection.
Call function associated with the descriptor (socket) to process data.

For each (active connection)
If (the connection has exceeded it maximum idle time)
Close the connection.
.fi
.Fn accept_conn()
.Cs
int accept_conn(\^int sd\^)
.Ce
.IP Args: 4
.RS
.IP sd
Socket with pending connection request
.RE
.IP Returns:
.RS
.IP 0 
If no error
.IP -1
If error occurred
.RE
.LP
This function is called when the 
.I select()
function returns the primary or secondary socket, the one bound to a service
port.  Data ready on these socket is a request for a connection.
.LP
If the maximum number of connections is not exceeded, an
.I accept()
is performed which returns a new socket, of type General.  This socket is added
to the connection table.  The data function entry for this socket is
set to the  processing function  passed in the init_network call for the
parent socket 
.Fn add_conn()
.Cs
void add_conn(int socket, enum conn_type type, pbs_net_t addr, 
      unsigned int port, void (*func)(int))
.Ce
.IP Args: 4
.RS
.IP socket
is the socket to be added to the svr_conn array.
.IP type
is the connection type, primary, secondary, or general.
several new types are possible:  ToServerDIS, and FromClientDIS.
.IP addr
is the address of the remote host.
.IP port
is the port on the remote host.
.IP func
is the function to be called to read data from the socket when data is
available.
.RE
.LP
The svr_conn array member, indexed by the socket number, is updated
to show its use.  The type is always set to 
.Sc General .
.Fn close_conn()
.Cs
void close_conn(\^sd\^)
.Ce
.IP Args: 4
.RS
.IP sd
The I/O descriptor (socket) to close.
.RE
.LP
The descriptor is closed and the connection table is set to \*QIdle\*U.
If there is an auxiliary close function registered in the connection table
entry
.Av cn_oncl ,
it is invoked and passed the socket descriptor value.  This allows special
processing to be performed under certain conditions.
.Fn net_close()
.Cs
void net_close(int all_but)
.Ce
.IP Args: 4
.RS
.IP but
A socket to leave open.
.RE
.LP
The network connections are closed.
For each possible connection with a socket number that does not match
.Av all_buf ...
.LP
If there is a non-null on-close-function pointer, 
.Av cn_oncl ,
it is cleared.  This prevents 
.I close_conn()
from invoking the registered function.  This function is typically called when
a child process is created and we do not want a child to invoke the parents
special routine on a descriptor it is closing.
The function close_conn() is called on each open socket in the connection
table that does not match the parameter
.I all_but .
.Fn get_connectaddr()
.Cs
pbs_net_t get_connectaddr(int socket)
.Ce
A trivial routine that returns the IP address saved in the servers connection
table.
.Fn get_connecthost()
.Cs
int get_connecthost(int sock, char *buffer, int size)
.Ce
.IP Args: 4
.RS
.IP sock
the socket identifying the connection.
.IP buffer
the buffer into which the host name is returned.
.IP size
the length of the buffer.
.RE
.IP Returns: 4
.RS
.IP 0
if successful.
.IP -1
if the buffer passed in was not large enough to hold the full name
of the host.  The buffer will still contain whatever part did fit.
.RE
.LP
The name of the host system to which a connection identified by sock exists
is returned into buffer.
.LP
The system routine
.I gethostbyname
is called with the network address saved in the cn_addr member of the
\*Qconnection\*U array.  If the host is not found, the value in cn_addr
is formatted into a numeric network address as is found in the file
.I /etc/hosts .
A maximum of size characters will be copied into buffer.  If the name
is smaller than size, the length of name characters is copied info buffer.
The name in buffer will be null terminated.
.NH 3
.Fi net_client.c
.LP
The file
.I src/lib/Libnet/net_client.c
contains client side functions to deal with the network.
.Fn client_to_svr()
.Cs
int client_to_svr(pbs_net_t hostaddr, unsigned int port, int local_port)
.Ce
.IP Args: 4
.RS
.IP hostaddr
the hexadecimal Internet host address, in network order) to which to connect
(pbs_net_t is an unsigned long).
.IP port
The port number to which to connect.
.IP
local_port
a flag, non-zero indicates an attempt should be made to bind the client
to a reserved port on the local host.
.RE
.IP Returns: 4
.RS
.IP >=0
the socket number for the connection.
.IP PBS_NET_RC_FATAL
(-1) a fatal error occurred.
.IP PBS_NET_RC_RETRY
(-2) a temporary error occurred, may retry.
.RE
.LP
The server's host address and port are passed as parameters rather than
their names to possibly save extra look-ups.
It seems likely that the caller \*Qmight\*U make several calls to the same host
or different hosts with the same port.  Let the caller keep the addresses
around rather than look it up each time.
.LP
A socket is allocated.  If the
.At local_port
flag is non-zero, an attempt is made to bind the socket to a reserved port
on the local host.  This is typically done to authenticate the client to
the server as this binding requires root privilege.
.LP
The address of the server host and its port placed in the internet address
structure and an attempt to connect to it is made.  If the connect attempt
fails for a reason that might be temporary, e.g. all server ports were busy,
then a
.Sc PBS_NET_RC_RETRY
is returned.  Otherwise
.Sc PBS_NET_RC_FATAL
is returned to the caller.
If the connect is successful, the socket number is returned.
.NH 3
.Fi get_hostaddr.c
.LP
The file
.I src/lib/Libnet/get_hostaddr.c
contains functions to look up the internet address of a host and to look
up the port number for a given service.
.Fn get_hostaddr()
.Cs
pbs_net_t get_hostaddr(char *host_name)
.Ce
.IP Args: 4
.RS
.IP host_name
the name of the host.
.RE
.IP Returns: 4
.RS
.IP address
of the requested host, the address is host order (pbs_net_t is an unsigned
long).  Return of zero indicates an error (unknown hostname).
.RE
.LP
Calls the library routine
.I gethostbyname()
to find the address.  The primary address is returned as a pbs_net_t type.
.NH 3
.Fi get_hostname.c
.LP
The file
.I src/lib/Libnet/get_hostname.c
contains the single function:
.Fn get_fullhostname()
.Cs
int get_fullhostname(char *short_name, char *namebuf, int bufsize)
.Ce
.IP Args: 4
.RS
.IP short_name
maybe the full name or a short alias for the host.
.IP namebuf
pointer to a character buffer in which the full name is to be returned.
.IP bufsize
the length in bytes of namebuf.
.RE
.IP Returns: 4
.RS
.IP 0
on success, the full hostname has been placed in namebuf.
.IP -1
on an error.
.RE
.LP
A call is made to the library routine
.I gethostbyname(3)
to obtain the internet address.  This address is passed to
.I gethostbyaddr(3)
to obtain the full and complete name.
This two step process insures that PBS will use the same name regardless
of alias ordering, we always use the name returned from the IP address.
This name is copied into the caller provided buffer.
This routine exists simply, as do most of the
routines in this library, to isolate the server from the type of network.
.LP
As a kludge to handle the over loading of the colon as a separator between
job ids in a dependency specification and within the job to specify test
server alternative ports, both \*Q:port\*U and \*Q\:port\*U are recognized
and stripped off.

.so ids_ifl.ms

.NH 2
Library:
.Tc "\f3Resource Monitor Library\fP"
.Ix libnet.a
.LP
The resource monitor library contains functions to facilitate
communication with the resource monitor.  It is set up to make
it easy to connect to several resource monitors and handle the
network communication efficiently.
In all these routines, the variable
.B pbs_errno
will be set when an error is indicated.
The lower levels of network
protocol are handled by the "Data Is Strings"
.B dis
library and the "Reliable Packet Protocol"
.B rpp
library.
.Fn delrm()
.Cs
static int delrm(int stream)
.Ce
.IP Args: 4
.RS
.IP stream
the stream number.
.RE
.IP Returns: 4
.RS
.IP 0
if all is well
.I -1
indicates an error.
.RE
.LP
Search to find the connection.  If it exists, close the stream
and free the structure.
.Fn startcom()
.Cs
static int startcom(int stream, int com)
.Ce
.IP Args: 4
.RS
.IP stream
the stream number.
.IP com
command number.
.RE
.IP Returns: 4
.RS
.I DIS_SUCCESS
if all is well
.I anything else
indicates an error
.RE
.LP
Internal routine to compose and send the beginning of a command
down a stream.  A call is made to
.B diswsi()
with the number
.I RM_PROTOCOL
followed by
.I RM_PROTOCOL_VER
and finally
.I com .
.Fn simplecom()
.Cs
static int simplecom(int stream, int com)
.Ce
.IP Args: 4
.RS
.IP stream
the stream number.
.IP com
command number.
.RE
.IP Returns: 4
.RS
.I 0
if all is well
.I -1
indicates an error
.RE
.LP
Internal routine to compose and send a "simple" command.
This means anything with a zero length body.
Search to find the stream number and compose the command.  Use
.I startcom()
and
.B rpp_flush()
to send it across the stream.  Call
.B rpp_eom()
to prepare the stream for reading.
.Fn simpleget()
.Cs
static int simpleget(int stream)
.Ce
.IP Args: 4
.RS
.IP stream
the stream number.
.RE
.IP Returns: 4
.RS
.I 0
if all is well
.I -1
indicates an error
.RE
.LP
Internal routine to read the return value from a command.
This means anything with a zero length body.
Use the function
.B disrsi()
to read the socket.  Check the response code to see if the
command succeeded.
.Fn closerm()
.Cs
int closerm(int stream)
.Ce
.IP Args: 4
.RS
.IP stream
the stream number.
.RE
.IP Returns: 4
.RS
.I 0
if all is well
.I -1
indicates an error
.RE
.LP
Close connection to resource monitor.  Use
.I simplecom()
to send a
.I RM_CMD_CLOSE
command.  Then use
.I delrm()
to close and cleanup the connection.
.Fn downrm()
.Cs
int downrm(int stream)
.Ce
.IP Args: 4
.RS
.IP stream
the stream number.
.RE
.IP Returns: 4
.RS
.I 0
if all is well
.I -1
indicates an error
.RE
.LP
Shutdown resmom.  Use
.I simplecom()
to send a
.I RM_CMD_SHUTDOWN
command followed by
.I simpleget()
to get the response.  Then use
.I delrm()
to close and cleanup the connection.
.Fn configrm()
.Cs
int configrm(int stream, char *file)
.Ce
.IP Args: 4
.RS
.IP stream
the stream number.
.IP file
the configuration file name.
.RE
.IP Returns: 4
.RS
.I 0
if all is well
.I -1
indicates an error
.RE
.LP
Cause the resource monitor to read the file named.  Use
.I startcom()
and
.B rpp_flush()
to send a
.I RM_CMD_CONFIG
command followed by
.I simpleget()
to get the response.
.Fn addreq()
.Cs
int addreq(int stream, char *line)
.Ce
.IP Args: 4
.RS
.IP stream
the stream number.
.IP line
string for request.
.RE
.IP Returns: 4
.RS
.I 0
if all is well
.I -1
indicates an error
.RE
.LP
Begin a new message to the resource monitor if necessary.
Then, add a line to the body of an outstanding command to the resource
monitor.
.Fn allreq()
.Cs
int allreq(char *line)
.Ce
.IP Args: 4
.RS
.IP line
string for request.
.RE
.IP Returns: 4
.RS
the number of streams acted upon.
.RE
.LP
For each stream, begin a new message to the resource monitor if necessary.
Then, add a line to the body of an outstanding command to the resource
monitor.
.Fn getreq()
.Cs
char *getreq(int stream)
.Ce
.IP Args: 4
.RS
.IP stream
the stream number.
.RE
.IP Returns: 4
.RS
a pointer to the next response line or a NULL if there are no more or
an error occurred.
.RE
.LP
Finish and send any outstanding message to the resource monitor.
If nothing has previously been read, call
.I simpleget()
to read the command response.
Call
.B disrst()
to read the request response.  If
.I fullresp()
has been called to turn off "full response" mode, search down the line
to find the equal sign just before the response value.
The returned string (if it is not NULL) has been allocated by
.B malloc
and
.B free
must be called when it is no longer needed to prevent memory leaks.
.Fn flushreq()
.Cs
void flushreq()
.Ce
.LP
Finish and send any outstanding messages to all resource monitors.
For each active resource monitor structure, check if outstanding
data is waiting to be sent.  If there is, send it and mark the
structure to show "waiting for response".
.Fn fullresp()
.Cs
void fullresp(int flag)
.Ce
.IP Args: 4
.RS
.IP flag
to indicate mode.
.RE
.LP
If flag is true, turn on "full response" mode where
.I getreq()
returns a pointer to the beginning of a line of response.
This is the default.  If flag is false,
the line returned by
.I getreq()
is just the answer following the equal sign.
.Fn activereq()
.Cs
int activereq()
.Ce
.LP
Return the stream number of the next stream with something
to read or a negative number (the return from
.B rpp_poll )
if there is no stream to read.
.NH 2
Library:
.Tc "\f3libpbs.a - Reliable Packet Protocol\fP"
.Ix libpbs.a
.LP
The reliable packet protocol library contains
routines to provide reliable, flow-controlled, two-way transmission
of data.  Each data path will be called a "stream" in this document.
The advantage of RPP over TCP is that many streams can be multiplexed
over one socket.  This allows simultaneous connections over many
streams without regard to the system imposed file descriptor limit.
.LP
Each stream has a state associated with it.  The state values are:
.Cs
#define RPP_DEAD        -1
#define RPP_FREE        0
#define RPP_OPEN_PEND   1
#define RPP_OPEN_WAIT   2
#define RPP_CONNECT     3
#define RPP_CLOSE_PEND  4
#define RPP_LAST_ACK    5
#define RPP_CLOSE_WAIT1 6
#define RPP_CLOSE_WAIT2 7
#define RPP_STALE       99
.Ce
A state diagram which gives the transitions follows.  The label for
each arc specifies an input such as a packet or user call, followed
by an output.  Some transitions take place with no output.  In the
state
.I RPP_OPEN_WAIT
it is legal to write but not read.  In the state
.I RPP_CONNECT
both reads and writes are legal.  No other state allows reads
or writes.
.DS
.so state.pic
.sp
.ce
Figure \n(H1 - \n+(Fi
.DE
.NH 3
.Tc Structures and Defines
.LP
This library sends UDP packets over the network.  Each packet can
optionally have a CRC checksum calculated to insure data integrity.
To compile without the CRC checksum calculation, define NO_CRC.
All processes using RPP must have the same definition of NO_CRC
to be able to communicate.
The structures used to organize the individual data streams and
packets are as follows:
.Cs
struct  send_packet     {
        u_char  *data;
        u_short type;
        u_short sent_out;
        int     len;
        int     index;
        int     sequence;
        time_t  time_sent;
        struct  send_packet     *next;
        struct  send_packet     *up;
        struct  send_packet     *down;
};

struct  recv_packet     {
        u_char  *data;
        u_short type;
        int     len;
        int     sequence;
        struct  recv_packet     *next;
};

struct  pending {               /* data pending commit */
        u_char  *data;
        struct  pending *next;
};

struct  stream {
	int			state;
        struct  sockaddr_in     addr;
        struct  in_addr         *addr_array;
        int                     stream_id;
	time_t			open_key;
        int                     msg_cnt;
        int                     send_sequence;
        struct  pending         *pend_head;
        struct  pending         *pend_tail;
        int                     pend_commit;
        int                     pend_attempt;
        struct  send_packet     *send_head;
        struct  send_packet     *send_tail;
        int                     recv_sequence;
        struct  recv_packet     *recv_head;
        struct  recv_packet     *recv_tail;
        int                     recv_commit;
        int                     recv_attempt;
};
.Ce
.LP
The different packet types are as follows:
.Cs
#define RPP_ACK         1
#define RPP_DATA        2
#define RPP_EOD         3
#define RPP_HELLO1      4
#define RPP_HELLO2      5
#define RPP_GOODBYE     6
.Ce
.NH 3
.Tc Functions
.Fi rpp.c
.LP
The file
.I src/lib/Libifl/rpp.c
contains functions entry points to the RPP package as well as internal
functions not visible to a user.
.Fn crc()
.Cs
u_long crc(u_char *buf; u_long clen)
.Ce
.IP Args: 4
.RS
.IP buf
the data area to checksum.
.IP clen
the length of the data area.
.RE
.IP Returns: 4
.RS
the checksum of the data area.
.RE
.LP
Compute a POSIX 1003.2 checksum.  This routine is copyrighted by
The Regents of the University of California.  It is derived from
software contributed to Berkeley by James W. Williams of NASA Goddard
Space Flight Center.  The disclaimer required for redistribution and use
is included with the source code.
.Fn rpp_form_pkt()
.Cs
static void rpp_form_pkt(int index, int type, int seq, u_char *buf; int len)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.IP type
the type of packet.
.IP seq
the sequence number.
.IP buf
a memory area to use.
.IP len
the length of the memory area.
.RE
.IP Returns: 4
.RS
.IP none
.RE
.LP
Create a packet of the given type, fill in the sequence and
index number.  If buf is NULL, malloc an area for just
a header.  If buf is not NULL, it should contain space
for len+RPP_PKT_HEADER bytes.
.Fn rpp_check_pkt()
.Cs
static struct stream *rpp_check_pkt(int index, struct sockaddr_in *addrp)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.IP addrp
the network address of a packet.
.RE
.IP Returns: 4
.RS
the stream structure pointer of the stream addrp matches or NULL.
.RE
.LP
Check the port and family of
.I addrp
with those of the stream structure indicated by
.I index . 
If they match, compare the IP addresses.  If they match too, return
a pointer to the stream.  If they don't match, loop through the
.I addr_array
for the stream.  This contains the alternate IP address for the
host.  If any of these match, return a pointer to the stream.  If
not, return NULL.
.Fn rpp_send_out()
.Cs
static void *rpp_send_out()
.Ce
.IP Args: 4
.RS
.IP none
.RE
.IP Returns: 4
.RS
.IP none
.RE
.LP
Loop through the
.I send_packet
structures linked together in a queue staring from the global variable
.I top
and working down to
.I bottom .
If a packet has been sent before and it has not been sent for
.I RPP_TIMEOUT
seconds it will be sent again.  If a packet has not been sent yet and
the number of packets "out on the wire"
.I pkts_sent
is less than
.I RPP_HIGHWATER
it will be sent.  The system call
.B sendto()
is used to send an UDP packet to the packet's recipient.
When the loop through the outstanding packets is done, the
.I busy_count
variable is set.  If it is less then
.I pkts_sent
it is set to
.I pkts_sent .
Otherwise, a calculation is done to slowly filter down the busyness factor.
This is used in
.I rpp_stale()
to see if too many retrys have been done on a packet.
.Fn rpp_send_ack()
.Cs
static int *rpp_send_ack(struct stream *sp, int seq)
.Ce
.IP Args: 4
.RS
.IP sp
the stream to send down.
.IP seq
the sequence number to acknowledge.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP 0
if not
.RE
.LP
Send an
.I RPP_ACK
packet for the sequence number given.  If the
.I stream_id
for the stream is less than zero, don't send anything because the
.I RPP_HELLO2
packet has not been received yet to tell us the other side's
stream number.
.Fn clear_stream()
.Cs
static void *clear_stream(struct stream *sp)
.Ce
.IP Args: 4
.RS
.IP sp
the stream to clear.
.RE
.IP Returns: 4
.RS
.IP none
.RE
.LP
Remove packets from receive, pending and send queues for
a stream, free all the memory and set the stream state to
.I RPP_DEAD .
.Fn rpp_recv_pkt()
.Cs
int rpp_recv_pkt(int fd)
.Ce
.IP Args: 4
.RS
.IP fd
.RE
.IP Returns: 4
.RS
.IP ">=0"
stream index number
.IP "<0"
code
.RE
.LP
Do a recvfrom on the socket given by
.I fd
to get a packet.  This may change the state of a stream.
Read the packet information and check the crc.  If there is no
error, check the packet type.  For an
.I RPP_ACK ,
find the packet that is being acknowledged and compute any required
state change.
Take the acknowledged packet off the send queue for the stream
and return the stream index number.  If the packet is an
.I RPP_GOODBYE ,
send an acknowledge for it and change state as needed.  If it is an
.I RPP_DATA
or
.I RPP_EOD ,
check to make sure it is not an old sequence number that we already have
before putting in in the receive queue for the stream, then acknowledge it.
If the packet is an
.I RPP_HELLO1 ,
this is the start of an open sequence.
.I RPP_HELLO1
packets have the remote side's stream index
in the "streamid" field and a stream key value in place
of the sequence number.  Create a stream
entry in the stream_array and send a
.I RPP_HELLO2 .
If the packet is a
.I RPP_HELLO2, we have started an open sequence.  The
.I RPP_HELLO2
packet has this side's stream index in the streamid field as usual
and the remote side's stream index overloaded in the "sequence" field.
Send an acknowledge with the stream key value as the sequence number
and change state.
Return the index of the stream the packet belonged to
or -2 if it was not data, or -1 if there was an error.
Return -3 if there was no data to read.
.Fn rpp_recv_all()
.Cs
static int rpp_recv_all()
.Ce
.IP Args: 4
.RS
.IP none
.RE
.LP
Calls
.I rpp_recv_pkt
for each socket being used by the library.
.Fn rpp_stale()
.Cs
static void rpp_stale(struct stream *sp)
.Ce
.IP Args: 4
.RS
.IP sp
pointer to stream being checked.
.RE
.LP
Check to see if any packet being sent out on a stream has
been sent more than a reasonable number of times.
.Fn rpp_dopending()
.Cs
static int rpp_dopending(int index, int flag)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.IP flag
flag to determine if we send an
.I RPP_EOD
packet.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP 0
otherwise
.RE
.LP
Form data packets for any pending data.  If flag is true,
create an
.I RPP_EOD
packet too.
.Fn rpp_flush()
.Cs
int *rpp_flush(int index)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP 0
otherwise
.RE
.LP
Flush all data out of a stream by calling
.I rpp_dopending()
if there is data pending or an end-of-message mark needs to be sent.
Then call
.I rpp_send_out()
and
.I rpp_recv_pkt() .
.Fn rpp_bind()
.Cs
int *rpp_bind(int port)
.Ce
.IP Args: 4
.RS
.IP port
the port number to use.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP 0
otherwise
.RE
.LP
The library can manage more than one socket.  If the global
.I rpp_fd
is -1, call
.B socket()
to open a new UPD socket, then
.B fcntl()
to set the FD_CLOEXEC and FNDELAY flags.  Optionally, call
.B atexit()
with
.B rpp_shutdown()
as the function pointer to call before exit.  Then call
.B bind
to fix the socket to the given port number.
.Fn rpp_open()
.Cs
int *rpp_open(char *name, int port)
.Ce
.IP Args: 4
.RS
.IP name
the name of the host.
.IP port
the port number to use.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP 0
otherwise
.RE
.LP
If the UPD socket has not been opened yet, call
.B rpp_bind
to set it up.  Create an entry in stream_array for the
new stream and copy the information for the host into it.  Call
.I rpp_form_pkt()
to put a RPP_HELLO1 packet into the send queue for the stream and call
.I rpp_send_out()
and
rpp_recv_pkt()
to send it and get a response.
.Fn rpp_close()
.Cs
int *rpp_open(int index)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP 0
otherwise
.RE
.LP
If the stream is in state
.I RPP_STALE ,
call
.I clear_stream()
to finish it off.  If it is in state
.I RPP_CLOSE_PEND
change state to
.I RPP_LAST_ACK
and send a
.I RPP_GOODBYE .
If it is in state
.I RPP_OPEN_WAIT
or
.I RPP_CONNECT
change state to
.I RPP_CLOSE_WAIT1
and call
.I rpp_dopending()
if there is anything on the pend queue.  Then send a
.I RPP_GOODBYE
packet.
.Fn rpp_write()
.Cs
int *rpp_write(int index, void *buf, int len)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.IP buf
the data to write.
.IP len
the number of characters to write.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP ">=0"
the number of characters written.
.RE
.LP
Check if any data has been written to the stream which has not
remained unacknowledged for so long that it is "stale".  If so,
abort the write and return -1.  Otherwise, create RPP_DATA packets
for the data in buf and link them to the pending queue for the
stream.
.Fn rpp_attention()
.Cs
static int *rpp_attention(int index)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.RE
.IP Returns: 4
.RS
TRUE or FALSE
.RE
.LP
Check a stream to see if it needs "attention".
If the stream state is
.I RPP_STALE ,
the user needs to call close so
return TRUE.  If there is a message to read, return TRUE, otherwise
return FALSE.
.Fn rpp_read()
.Cs
int *rpp_read(int index, void *buf, int len)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.IP buf
the data area to read into.
.IP len
the size of buf.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP -2
if other side has closed
.IP ">=0"
number of bytes read
.RE
.LP
Call
.I rpp_attention()
in a loop until it returns TRUE or an error occurs.  Then find the
packet in the receive queue for the stream that the field recv_attempt 
point into.  Copy data starting from there until the end of a message
or the end of the provided buffer.
.Fn rpp_rcommit()
.Cs
int *rpp_rcommit(int index, int flag)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.IP flag
TRUE to commit or FALSE to decommit.
.RE
.IP Returns: 4
.RS
-1 on error, TRUE or FALSE.
.RE
.LP
Commit data which has been read up to recv_attempt if flag
is TRUE.  Otherwise, set recv_attempt back to the previous
commit point recv_commit.
Return -1 on error, FALSE on decommit or if end-of-message has
not been reached, TRUE if end-of-message has been reached.
.Fn rpp_eom()
.Cs
int *rpp_eom(int index)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.RE
.IP Returns: 4
.RS
-1 on error, TRUE or FALSE.
.RE
.LP
Reset end-of-message condition on a stream.  Any packets
on the receive queue are freed.
Return -1 on error, -2 if stream is closed, 0 otherwise.
.Fn rpp_wcommit()
.Cs
int *rpp_wcommit(int index, int flag)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.IP flag
TRUE to commit or FALSE to decommit.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP 0
otherwise.
.RE
.LP
If flag is TRUE, call
.I rpp_dopending()
to transfer any packets from the pend queue to the send queue, then call
.I rpp_send_out()
and
.I rpp_recv_pkt()
to send the packets and get any response.
If flag is FALSE, free any packets from the pend queue which follow the
first which is kept.
.Fn rpp_poll()
.Cs
int *rpp_poll()
.Ce
.IP Args: 4
.RS
.IP none
.RE
.IP Returns: 4
.RS
.IP ">=0"
the stream number of any stream with a message waiting,
.IP -1
on error
.IP -2
otherwise
.RE
.LP
Call
.I rpp_recv_pkt
until an error occurs or a -3 is returned meaning no data was read.
Then loop over all streams calling
.I rpp_attention
to see if there is any condition which needs to be reported.  If so,
return the stream number, otherwise return -2.
.Fn rpp_getc()
.Cs
int *rpp_getc(int index)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.IP ">=0"
the character read
.RE
.LP
Call
.B rpp_read
to read one character from a stream.
.Fn rpp_putc()
.Cs
int *rpp_putc(int index, int c)
.Ce
.IP Args: 4
.RS
.IP index
the stream number.
.IP c
the character to write.
.RE
.IP Returns: 4
.RS
.IP -1
on error
.I 0
otherwise.
.RE
.LP
Call
.B rpp_write()
to write one character to a stream.
.NH 2
Library:
.Tc "\f3libsite.a - Site Modifiable Library\fP"
.Ix libsite.a
.LP
The site modifiable library contains stubs or the default version of
routines specifically set up to be modifiable by an individual site.
By placing the PBS project released version of these routines in a library,
the site can implement and compile its own version without fear of that
version being overwritten by the next release of PBS.
This library is currently linked with the Server and with MOM.
.NH 3
.Tc "How to Modify these Routines"
.LP
The site should make a source file for each function to be replaced and
compile the objection into the appropriate directory in the target tree.
The object file name should start with 
.I site_
and end of course with
.I .o .
The function names must agree with the name in the library as documented in 
this section of the IDS.  The calling parameters must also match the library
version as documented.
.LP
When the daemon is being linked, it will pickup any (site provided) object
files with the name 
.I site_*.o .
Any functions provided in these object files will be linked into the daemon
satisfying the external and therefore the object module from this library
will not be included.
.LP
For example, if a site wishes to replace the function site_check_user_map()
with something local, you should write the code in a file site_foo.c.
Then
.Cs
cp site_foo.c $(PBS_TARGET)/obj/server/site_foo.c
cd $(PBS_TARGET)/obj/server/site_foo.c
cc -c -I$(PBS_SRC)src/include site_foo.c
.Ce
When the server is linked, the local site_check_user_map() will be picked up
from site_foo.o.
.LP
The description of the routines included in libsite.a can be found under
the daemon affected in the subsection entitled 
.I "Site Modifiable Files". 
These subsections are typically located at the end of the daemon chapter.

.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.bp
\}
