.nr % 1
.OH ''PBS IDS'Operator Commands'
.EH 'Operator Commands'PBS IDS''
.P1
.so ids_setup.ms
.Rv $Revision: 2.1 $
.nr H1 2
.NH 1
.Tc \f3\s+2Operator Commands\s-2\fP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.LP
A batch operator is a user of the system who is granted privilege to perform 
actions beyond those available to the normal user.  Typical of those actions 
are starting and stopping queues and the server, and modification or deleting 
of jobs of other users.

In addition to the general user commands, the operator has access to the
.B "qdisable, qenable, qinit, qrun, qstart, qstop,"
and
.B qterm 
commands.
.NH 2
.Fi qdisable.c
.LP
The
.B qdisable
command directs that a destination should no longer accept batch jobs.
.NH 3
.Fn main()
.Cs
main(int argc, char **argv)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
.IP "destination ..." 4
A 
.I destination
is in one of the following forms:
.RS
.B queue
.br
.B @server
.br
.B queue@server
.RE
.RE
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
for each argument
	parse(in:argument, out:queue, server)
	execute(in:queue, server)
.fi
.RE
.NH 4
.Fn parse()
.Cs
int parse(char *destination, char *queue, char *server)
.Ce
.IP Args: 4
.RS
.IP destination 16
The destination queue in the form queue, @server, or queue@server.
.IP queue 16
The queue part of the destination.
.IP server 16
The server part of the destination.
.RE
.IP Returns: 4
.RS
.IP int 8
Zero, if no errors occurred.  One, if a syntax error occurred.
.RE
.LP
Control Flow:
.RS
.nf
Anything before the @ is the queue name
Anything after the @ is the server name
If ( null argument ) Then set error return
.fi
.RE
.NH 4
.Fn execute()
.Cs
int execute(char *queue, char *server)
.Ce
.IP Args: 4
.RS
.IP queue 16
The queue name.
.IP server 16
The server name.
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
Connect to the server
Disable the queue
Disconnect from the server
.fi
.RE
.NH 2
.Fi qenable.c
.LP
The
.B qenable
command directs that a destination should accept batch jobs.
.NH 3
.Fn main()
.Cs
main(int argc, char **argv)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
.IP "destination ..." 4
A 
.I destination
is in one of the following forms:
.RS
.B queue
.br
.B @server
.br
.B queue@server
.RE
.RE
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
for each argument
	parse(in:argument, out:queue, server)
	execute(in:queue, server)
.fi
.RE
.NH 4
.Fn parse()
.Cs
int parse(char *destination, char *queue, char *server)
.Ce
.IP Args: 4
.RS
.IP destination 16
The destination queue in the form queue, @server, or queue@server.
.IP queue 16
The queue part of the destination.
.IP server 16
The server part of the destination.
.RE
.IP Returns: 4
.RS
.IP int 8
Zero, if no errors occurred.  One, if a syntax error occurred.
.RE
.LP
Control Flow:
.RS
.nf
Anything before the @ is the queue name
Anything after the @ is the server name
If ( null argument ) Then set error return
.fi
.RE
.NH 4
.Fn execute()
.Cs
int execute(char *queue, char *server)
.Ce
.IP Args: 4
.RS
.IP queue 16
The queue name.
.IP server 16
The server name.
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
Connect to the server
Enable the queue
Disconnect from the server
.fi
.RE
.NH 2
.Fi qinit.c
.LP
The
.B qinit
command starts the operation of the server.
.NH 3
.Fn main()
.Cs
main(int argc, char **argv)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
.IP "-t type" 4
The type of initialization of the server: hot, warm, cold, clean, create.
.IP "-d config_path" 4
The directory path which is the home of the configuration files.
.IP server_path 4
The path name of the server to execute.
.RE
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
get the arguments with getopt
get the server path
fork
exec the server
.fi
.RE
.NH 2
.Fi qrun.c
.LP
The
.B qrun
command forces the server to execute a batch job.
.NH 3
.Fn main()
.Cs
main(int argc, char **argv)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
.IP "job_identifier ..." 4
The list of jobs to have the server run of the form:
.RS
.B sequence_number[.server_name][@server]
.RE
.RE
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
for each argument
	parse(in:argument, out:job, server, location)
	execute(in:job, server, location)
.fi
.RE
.NH 4
.Fn parse()
.Cs
int parse(char *identifier, char *job, char *server, char *location)
.Ce
.IP Args: 4
.RS
.IP identifier 16
The identifier in the form sequence_number[.server_name][@server].
.IP job 16
The sequence_number part of the identifier.
.IP server 16
The server part of the identifier that owns the job now.
.IP location 16
The location part of the identifier to the server which will run the job.
.RE
.IP Returns: 4
.RS
.IP int 8
Zero, if no errors occurred.  One, if a syntax error occurred.
.RE
.LP
Control Flow:
.RS
.nf
Anything before the . is the job
Anything after the . and before the @ is the server name
Anything after the @ is the location
If ( no job number ) Then set error return
.fi
.RE
.NH 4
.Fn execute()
.Cs
int execute(char *job, char *server, char *location)
.Ce
.IP Args: 4
.RS
.IP job 16
The job number.
.IP server 16
The server name.
.IP location 16
The location to run the job at.
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
Connect to the server
Run the job
Disconnect from the server
.fi
.RE
.NH 2
.Fi qstart.c
.LP
The
.B qstart
command directs that a destination should process batch jobs.
.NH 3
.Fn main()
.Cs
main(int argc, char **argv)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
.IP "destination ..." 4
A 
.I destination
is in one of the following forms:
.RS
.B queue
.br
.B @server
.br
.B queue@server
.RE
.RE
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
for each argument
	parse(in:argument, out:queue, server)
	execute(in:queue, server)
.fi
.RE
.NH 4
.Fn parse()
.Cs
int parse(char *destination, char *queue, char *server)
.Ce
.IP Args: 4
.RS
.IP destination 16
The destination queue in the form queue, @server, or queue@server.
.IP queue 16
The queue part of the destination.
.IP server 16
The server part of the destination.
.RE
.IP Returns: 4
.RS
.IP int 8
Zero, if no errors occurred.  One, if a syntax error occurred.
.RE
.LP
Control Flow:
.RS
.nf
Anything before the @ is the queue name
Anything after the @ is the server name
If ( null argument ) Then set error return
.fi
.RE
.NH 4
.Fn execute()
.Cs
int execute(char *queue, char *server)
.Ce
.IP Args: 4
.RS
.IP queue 16
The queue name.
.IP server 16
The server name.
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
Connect to the server
Start the queue
Disconnect from the server
.fi
.RE
.NH 2
.Fi qstop.c
.LP
The
.B qstop
command directs that a destination should stop processing batch jobs.
.NH 3
.Fn main()
.Cs
main(int argc, char **argv)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
.IP "destination ..." 4
A 
.I destination
is in one of the following forms:
.RS
.B queue
.br
.B @server
.br
.B queue@server
.RE
.RE
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
for each argument
	parse(in:argument, out:queue, server)
	execute(in:queue, server)
.fi
.RE
.NH 4
.Fn parse()
.Cs
int parse(char *destination, char *queue, char *server)
.Ce
.IP Args: 4
.RS
.IP destination 16
The destination queue in the form queue, @server, or queue@server.
.IP queue 16
The queue part of the destination.
.IP server 16
The server part of the destination.
.RE
.IP Returns: 4
.RS
.IP int 8
Zero, if no errors occurred.  One, if a syntax error occurred.
.RE
.LP
Control Flow:
.RS
.nf
Anything before the @ is the queue name
Anything after the @ is the server name
If ( null argument ) Then set error return
.fi
.RE
.NH 4
.Fn execute()
.Cs
int execute(char *queue, char *server)
.Ce
.IP Args: 4
.RS
.IP queue 16
The queue name.
.IP server 16
The server name.
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
Connect to the server
Stop the queue
Disconnect from the server
.fi
.RE
.NH 2
.Fi qterm.c
.LP
The
.B qterm
command terminates the server.
.NH 3
.Fn main()
.Cs
main(int argc, char **argv)
.Ce
.IP Args: 4
.RS
.IP argc 8
The number of arguments on the command line.
.IP argv 8
The
.B argv
array contain the following arguments:
.RS
.IP "-t type" 4
The type of termination of the server: immediater, delay, or quick.
.IP "server ..." 4
The list of servers to terminate.
.RE
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
get the arguments with getopt
get the server names
for each server
	execute(in:type, server)
.fi
.RE
.NH 4
.Fn execute()
.Cs
int execute(int type, char *server)
.Ce
.IP Args: 4
.RS
.IP type 16
The type of termination.
.IP server 16
The server name.
.RE
.IP Returns: 4
None
.LP
Control Flow:
.RS
.nf
Connect to the server
Stop the server
Disconnect from the server
.fi
.RE
.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.bp
\}
