.nr % 1
.OH ''PBS IDS'SCHEDULER'
.EH 'SCHEDULER'PBS IDS''
.P1
.so ids_setup.ms
.Rv $Revision: 2.3 $
.nr H1 5
.NH 1
.Tc \f3\s+2Job Scheduler\s-2\fP
.LP
.OF 'Chapt \*(rV''\n(H1-%'
.EF '\n(H1-%''Chapt \*(rV'
.\"         Portable Batch System (PBS) Software License
.\" 
.\" Copyright (c) 1999, MRJ Technology Solutions.
.\" All rights reserved.
.\" 
.\" Acknowledgment: The Portable Batch System Software was originally developed
.\" as a joint project between the Numerical Aerospace Simulation (NAS) Systems
.\" Division of NASA Ames Research Center and the National Energy Research
.\" Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
.\" 
.\" Redistribution of the Portable Batch System Software and use in source
.\" and binary forms, with or without modification, are permitted provided
.\" that the following conditions are met:
.\" 
.\" - Redistributions of source code must retain the above copyright and
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer.
.\" 
.\" - Redistributions in binary form must reproduce the above copyright and 
.\"   acknowledgment notices, this list of conditions and the following
.\"   disclaimer in the documentation and/or other materials provided with the
.\"   distribution.
.\" 
.\" - All advertising materials mentioning features or use of this software must
.\"   display the following acknowledgment:
.\" 
.\"   This product includes software developed by NASA Ames Research Center,
.\"   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
.\" 
.\"         DISCLAIMER OF WARRANTY
.\" 
.\" THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" 
.\" WITHOUT WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, 
.\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, 
.\" FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY
.\" DISCLAIMED.
.\"
.\" IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
.\" THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
.\" NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\" 
.\" This license will be governed by the laws of the Commonwealth of Virginia,
.\" without reference to its choice of law rules.
.LP
The Job Scheduler is a daemon that is run in conjunction with the PBS
server. The Job Scheduler determines which job(s) to run, suspend, hold, or
terminate based on a set site-specific policy. 
.LP
PBS provides several implementations of a scheduler.
A site may choose to use the
Yacc/Lex based procedural language scheduler known as the BASL scheduler,
the Tcl based scheduler, or to develop their own scheduler using the C
framework which is provided.
.NH 2
.Tc \f3The BASL Scheduler\fP
.LP
The BASL language is a C-like procedural language. It provides a number of
constructs and predefined functions that facilitate dealing with scheduling
tasks. The idea behind BASL is that a scheduler writer writes a very simple
program in BASL, compiles it, and then runs it. BASL is a high level language
optimized for scheduler development. This language allows to user to write a
simple or intermediate complexity in about 30-100 lines of code.
.LP
.NH 3
.Tc BASL Scheduler Overview
.LP
BASL consists of three major parts: (1) BASL language grammar, (2)
Pseudo-compiler, and a (3) set of assist functions or helper functions.
The idea behind BASL(2) is that a scheduler writer writes the main part of the
scheduling code (sched_main()) in a pseudo-C language called BASL, then
translates the code into C via
.Ar "basl2c",
and finally, integrates the code with
the PBS libraries by using a C compiler to produce the actual scheduler
executable:
.Ar "pbs_sched".
sched_main() will be called after each scheduling
iteration and when the command received from the server is not one of:
SCH_QUIT, SCH_ERROR, SCHED_NULL, SCHED_RULESET, SCHED_CONFIGURE, SCHED_RULESET.
.sp
The resulting
.Ar "pbs_sched"
will be able to accept the following arguments in the commandline:
.sp
.Rs
[-L logfile] [-S port] [-d home] [-p print_file] [-a alarm] [-c configfile]
.Re
.sp
where -S is for specifying the scheduler port to use when talking to the local
server, and alarm is for setting the time in seconds to wait for a schedule run
to finish (default: 180s). Just like the other PBS schedulers, this
BASL-written scheduler takes care of setting up local socket to communicate
with the server running on the same machine, cd-ing to the priv directory,
opening log files, opening configuration file (if any), setting up locks,
forking the child to become a daemon, initializing a scheduling cycle (i.e.
get node attributes that are static in nature), setting up the signal handlers,
and finally sitting on a loop waiting for a scheduling command from the
server. When an appropriate scheduling command is received, sched_main()
(whose body was initially written in BASL), is called. Another view of BASL
scheduling system is shown in figure \n(H1\-\n+(Fi.
.DS
.so baslsw_arch.pic
.sp
.ce
Figure \n(H1 - \n+(Fi : BASL Software Architecture
.DE
.LP
.NH 3
.Tc Grammar
.LP
The Basl grammar subsystem consists of 5 parts: (1) Lexer, (2) Parser,
(3) Symbol Table, (4) Semantic analyzer, and (5) Code Generator. Lexer is in
charge of scanning an input file for valid tokens (input strings). Parser takes
care of putting/combining the tokens together in a usable way. Semantic
analyzer deals with checking to make sure that variables and operators are used
in a consistent way. Symbol table holds information about matched tokens. Code
generator is in charge of translating BASL statements into C statements.
.sp
Lex/yacc is used to specify and generate the code for the Lexer and Parser.
The source codes involved in the grammar are found in the subdirectory
.Ar ParLex.
.LP
.NH 4
.Tc Lexer
.LP
The files involved with the Lexer subsystem are Lexer.fl, ParLexGlob.h,
Lexer.h, Lexer.c.
Lexer.fl is the
.I "lex specification"
file that contains a set of patterns which lex match against the input.
ParLexGlob.h, Lexer.h and Lexer.c contain various data structures and
functions that assist lex in the scanning for input. 
.NH 5
.Fi Lexer.fl 
.LP
The tokens that will be matched by the BASL lexer are:
.Ar
sched_main, Void, Int, Float, Dayofweek, DateTime, String, Server, Que, Job,
CNode, Size, Set, Range, while, if, else, return, print, for, foreach, in,
switch, case, break, continue, exit, Fun, EQ, NEQ, LT, LE, GT, GE, MIN, MAX,
AND, OR, default, MON, TUE, WED, THU, FRI, SAT, SUN, ++, --,
[+-]?[0-9]+, [+-]?[0-9]+[kmgtpKMGTP]?[bwBW], OP_EQ, OP_NEQ, OP_LE, OP_LT, OP_GE,
OP_GT, OP_MAX, OP_MIN, SYNCRUN, ASYNCRUN, DELETE, RERUN, HOLD, RELEASE, SIGNAL,
MODIFYATTR, MODIFYRES, SUCCESS, FAIL, SERVER_ACTIVE, SERVER_IDLE, SERVER_SCHED, SERVER_TERM,
SERVER_TERMDELAY, QTYPE_E, QTYPE_R, SCHED_DISABLED, SCHED_ENABLED, FALSE, TRUE,
TRANSIT, QUEUED, HELD, WAITING, RUNNING, EXITING, CNODE_OFFLINE, CNODE_DOWN,
CNODE_FREE, CNODE_RESERVE, CNODE_INUSE_EXCLUSIVE, CNODE_INUSE_SHARED,
CNODE_TIMESHARED, CNODE_CLUSTER, CNODE_UNKNOWN, NULLSTR,
NOSERVER, NOQUE, NOJOB, NOCNODE, EMPTYSETSERVER, EMPTYSETQUE, EMPTYSETJOB,
EMPTYSETCNODE, ASC, DESC [+-]?[0-9]+[.][0-9]*, ["][^"\n()]*["], [a-zA-Z]+[a-zA-Z0-9_]*,
//.*, \n.*, [ \t]+,..
.ft 1
.NH 5
.Fi ParLexGlob.h
.LP
This contains the following structure to hold information about each of the
tokens that the lexer has recognized during scanning for input:
.At
.sp
.RS
.Ty
.nf
struct MYTOK
{
  char lexeme[LEXEMSZ];
  int line;
  int len;
  int type;
  int varFlag;
};
.fi
.RE
.ft 1
.sp
.At lexeme
contains the matched string,
.At line
is where in the input file the matched string was found,
.At len
is the string length of the matched token,
.At type
is some classification assigned to the token. This can be:
.Sc "UNKNOWN, INTTYPE, FLOATTYPE, STRINGTYPE, STATUSTYPE, DAYOFWEEKTYPE, SERVERTYPE, QUETYPE, JOBTYPE, SIZETYPE, INTRANGETYPE, FLOATRANGETYPE, DAYOFWEEKRANGETYPE, SERVERSETTYPE, QUESETTYPE, JOBSETTYPE, SIZESETTYPE, PARAMTYPE, FUNTYPE, SERVERSTATETYPE, QUESTATETYPE, JOBSTATETYPE, SIZESTATETYPE, DATETIMETYPE, CNODETYPE, VOIDTYPE, DATETIMERANGETYPE, CNODESETTYPE, SIZERANGETYPE, GENERICTYPE, KEYWORDTYPE.
and 
.At varFlag
gives some indication on whether or not the matched token is indeed a constant,
variable, or some other thing.  
.LP
.NH 5
.Fi Lexer.c
.Fn LexerInit
.Cs
void LexerInit(void)
.Ce
.LP
Initializes the lexer by simply writing a simple startup message into the
lexer stdout stream.
.Fn LexerTokenPut
.Cs
void LexerTokenPut(char *lexem, int lin, int len, int typ, int varFlag)
.Ce
.LP
This just fills up the MYTOK structure with values given in the parameter list.
.Fn LexerPrintToken
.Cs
void LexerPrintToken(int linenum, char *yytext, int yylen)
.Ce
.LP
if there's a lexer stdout stream, and the lexer debug flag is turned on, then
the values to the given parameters are printed.
.Fn LexerPutDF
.Cs
void LexerPutDF(int df)
.Ce
.LP
Sets the lexer debug flag to
.Ty df.
.Fn LexerCondPrint
.Cs
void LexerCondPrint(char *str)
.Ce
.LP
Prints
.Ty str
if there's a lexer stdout stream and the lexer debug flag is turned on.
.Fn LexerErr
.Cs
void LexerErr(int e)
.Ce
.LP
If there's a lexer stdout stream, print the message string associated with the
error number given by
.Ty e.
This will issue an exit to the program.
.LP
.NH 4
.Tc Parser
.LP
The files involved with the Parser subsystem are Parser.b, Parser.h, and
Parser.c.
Parser.b is the
.I "yacc specification"
file describing valid "sentences" in the BASL grammar.
Parser.h and Parser.c contain various data structures and functions that assist
yacc in the parsing for correct grammar.
.LP
.NH 5
.Fi Parser.b
.LP
The following is the syntax definition for the Batch Scheduler Language
(BASL) used by the PL (procedural language) job scheduler program. Some notes
concerning the semantics analyzer and code generator are also added.
.sp 2
.nf
.Ty
prog::= defs1 globAssign "sched_main" blockWithDefs

blockWithDefs::= '{' defs stats '}'
.fi
.ft 1
.RS
.IP NOTE:
A variable's  scope, which determines in what functions the variable has been
defined/declared, is kept track via the ParserVarScope global variable.
Whenever a function block is entered, ParserVarScope is incremented by 1.
.RE
.sp
.LP
.nf
.Ty
block::= '{' stats '}'	/* no definition */

defs1::=  ''             /* empty */
        | defs1 defFun
        | defs1 def
.fi
.ft 1
.RS
.IP NOTE:
Any global variable declared (ParserLevel == 0 ) will get a "static"
keyword attached to it during BASL-to-C translation so that the variable
will only be accessible from the local sched_main file, minimizing the
chance of name collision when the translated code is compiled and linked
with the PBS libraries.
.RE
.sp
.LP
.nf
.Ty
globAssign::= ''         /* empty */
             | globAssign statAssign
	 
defFun::= "Int" identifier        '(' params ')' blockWithDefs
        | "Float" identifier      '(' params ')' blockWithDefs
        | "Void" identifier       '(' params ')' blockWithDefs
        | "Dayofweek" identifier  '(' params ')' blockWithDefs
        | "DateTime" identifier   '(' params ')' blockWithDefs
        | "String" identifier     '(' params ')' blockWithDefs
        | "Size" identifier       '(' params ')' blockWithDefs
        | "Server" identifier     '(' params ')' blockWithDefs
        | "Que" identifier        '(' params ')' blockWithDefs
        | "Job" identifier        '(' params ')' blockWithDefs
        | "CNode" identifier      '(' params ')' blockWithDefs
        | "Set Server" identifier '(' params ')' blockWithDefs
        | "Set Que" identifier    '(' params ')' blockWithDefs
        | "Set Job" identifier    '(' params ')' blockWithDefs
        | "Set CNode" identifier  '(' params ')' blockWithDefs
.fi
.ft 1
.RS
NOTE:
In the definition of functions, the identifier (function name) must be unique.
.br
On the generated code, identifier will be prefixed with "basl_" to avoid
possible name conflict when the code is compiled and linked with other
libraries like PBS.
.RE
.sp
.LP
.nf
.Ty
params::=   ''   /* empty */
          | paramDeclare moreParams

paramDeclare::=	  "Int" identifier
                | "Float" identifier
                | "Void" identifier
                | "Dayofweek" identifier
                | "DateTime" identifier
                | "String" identifier
                | "Size" identifier
                | "Server" identifier
                | "Que" identifier
                | "Job" identifier
                | "CNode" identifier
                | "Set Server" identifier
                | "Set Que" identifier
                | "Set Job" identifier
                | "Set CNode" identifier
                | "Range Int" identifier
                | "Range Float" identifier
                | "Range Dayofweek" identifier
                | "Range DateTime" identifier
                | "Range Size" identifier
                | "Fun Int" identifier
                | "Fun Float" identifier
                | "Fun Void" identifier
                | "Fun Dayofweek" identifier
                | "Fun DateTime" identifier
                | "Fun String" identifier
                | "Fun Size" identifier
                | "Fun Server" identifier
                | "Fun Que" identifier
                | "Fun Job" identifier
                | "Fun CNode" identifier
                | "Fun Set Server" identifier
                | "Fun Set Que" identifier
                | "Fun Set Job" identifier
                | "Fun Set CNode" identifier

moreParams::= ''
              | ',' paramDeclare moreParams		
.fi
.RS
.IP NOTE:
The identifiers that appear in the list of parameters must be unique.
.RE
.sp
.LP
.nf
.Ty
defs::= ''    /* empty */
        | defs def

def::=    "Int" identifier ';'
        | "Float" identifier ';'
        | "Dayofweek" identifier ';'
        | "DateTime" identifier ';'
        | "String" identifier ';'
        | "Size" identifier ';'
        | "Server" identifier ';'
        | "Que" identifier ';'
        | "Job" identifier ';'
        | "CNode" identifier ';'
        | "Set Server" identifier ';'
        | "Set Que" identifier ';'
        | "Set Job" identifier ';'
        | "Set CNode" identifier ';'
        | "Range Int" identifier ';'
        | "Range Float" identifier ';'
        | "Range Dayofweek" identifier ';'
        | "Range DateTime" identifier ';'
        | "Range Size" identifier ';'
.fi
.RS
.IP NOTE:
The identifier used must be unique; no other identifier in the same level of the
same name must have been declared.
.sp
During code generation, the following translations occur:
.sp
.nf
.Ty
Int   identifier;             -> int identifier;
Float identifier;             -> double identifier;
Dayofweek identifier;         -> Dayofweek identifier;
DateTime identifier;          -> DateTime identifier;
String identifier;            -> char *identifier = NULLSTR;
Size identifier;              -> Size identifier;
Server identifier;            -> Server identifier = NOSERVER;
Que identifier;               -> Que identifier = NOQUE;
Job identifier;               -> Job identifier = NOJOB;
CNode identifier;             -> CNode identifier = NOCNODE;
Set Server identifier;        -> SetServer *identifier = EMPTYSETSERVER;
Set Que identifier;           -> SetQue *identifier = EMPTYSETQUE;
Set Job identifier;           -> struct SetJobElement *identifier = EMPTYSETJOB;
Set CNode identifier;         -> SetCNode *identifier = EMPTYSETCNODE;
Range Int identifier;         -> IntRange identifier;
Range Float identifier;       -> FloatRange identifier;
Range Dayofweek identifier;   -> DayofweekRange identifier;
Range DateTime identifier;    -> DateTimeRange identifier;
Range Size identifier;        -> SizeRange identifier;
.fi
.RE
.sp
.LP
.nf
.Ty
stats::=   ''    /* empty */
        | stats stat

stat::= ';'     /* empty statement */
        | expr
        | statIf
        | statAssign
        | statPrint ';'
        | statFor
        | statSwitch
        | statForeach
        | statWhile
        | statContinue ';'
        | statBreak ';'
        | statREturn
        | statExit
        | block	

statAssign::= identifier eqs expr ';'
.fi
.RS
NOTE:
.RS
.IP 1.
Compatible assignment types:
.TS
expand tab(+) ;
c s s
l l .

identifier+expression
_+_
Int+Int, Float
Float+Int, Float
Dayofweek+Dayofweek
DateTime+DateTime
String+String
Size+Size	
Que+Que
Job+Job
CNode+CNode
Server+Server
Range Dayofweek+Range Dayofweek
Range DateTime+Range DateTime
Range Size+Range Size
Server+Server
Que+Que
Job+Job
CNode+CNode
Range Int+Range Int 
Range Float+Range Float
.TE
.sp
.IP 2.
If identifier is of string type, generate code to modify the identifier's
scope to reflect actual scope, and also generate code that will free up
any temporarily allocated strings during the assignment operation.

.IP 3.
If identifier is of Que type, generate code that will modify the scope of the
identifier only if it is not already of global scope (mallocTableSafeModScope).
Then free up any temporarily allocated Que structures (those with scope of
-1).	
.RE
.RE
.LP
.nf
.Ty
statWhile:: = "while" '(' expr ')' block
.fi
.RS
NOTE:
.RS
.IP 1.
expr's type must be INTTYPE or FLOATTYPE.
.IP 2.
A global variable called inLoop exists to keep track on whether or not the
parser is currently inside a loop construct. As the parser is inside the while
loop, the inLoop counter is incremented. Leaving the loop will cause the
inLoop counter to be decremented.
.RE
.RE
.sp
.LP
.nf
.Ty
statForeach::= "foreach" '(' identifier "in" identifier ')' block
.fi
.RS
NOTE:
.IP 1.
The valid types of identifiers are:
.TS
expand tab(+) ;
c s s
l l .

1st identifier+2nd identifier
_+_
Server+Set Server
Que+Set Que
Job+Set Job
CNode+Set CNode
.TE
.RE
.sp
.nf
.Ty
expr::=	  expr '+' expr
        | expr '-' expr
        | expr '*' expr
        | expr '/' expr
        | expr '%' expr
        | '-' expr
        | '+' expr
        | exprTerms EQ exprTerms
        | exprTerms NEQ exprTerms
        | exprTerms LT exprTerms
        | exprTerms LE exprTerms
        | exprTerms GT exprTerms
        | exprTerms GE exprTerms
        | expr AND expr
        | expr OR expr
        | '!' expr
        | identifier postop
        | '(' expr ')'
        | exprTerms
.fi
.RS
.IP 1.
Consistent types for +:
.TS
expand tab(+) ;
c s s
l l .

left expression type+right expression type
_+_
STRINGTYPE+STRINGTYPE
SIZETYPE+SIZETYPE
INTTYPE or FLOATTYPE+INTTYPE or FLOATTYPE	
.TE
.IP 2.
Consistent types for -, *, /:
.TS
expand tab(+) ;
c s s
l l .

left expression type+right expression type
_+_
SIZETYPE+SIZETYPE
INTTYPE or FLOATTYPE+INTTYPE or FLOATTYPE	
.TE
.IP 3.
Consistent types for modulus (%):
.TS
expand tab(+) ;
c s s
l l .

left expression type+right expression type
_+_
INTTYPE+INTTYPE
.TE
.IP 4.
Consistent types for unary minus (-) and unary plus (+):
.TS
expand tab(+) ;
c s
l .

expression type
_
INTTYPE
FLOATTYPE
SIZETYPE
.TE
.IP 5.
Consistent types for EQ, NEQ, LT, LE, GT, GE:
.TS
expand tab(+) ;
c s s
l l .

left expression type+right expression type
_+_
Dayofweek+Dayofweek
DateTime+DateTime
String+String
Size+Size
Server+Server
Que+Que
Job+Job
CNode+CNode
Server+Server
Que+Que
Set Job+Set Job
Set CNode+Set CNode
Int, Float+Int, Float
.TE
.IP 6.
Consistent types for AND, OR:
.TS
expand tab(+) ;
c s s
l l .

left expression type+right expression type
_+_
INTTYPE or FLOATTYPE+INTTYPE or FLOATTYPE	
.TE
.IP 7.
Consistent types for !expr:
.TS
expand tab(+) ;
c s
l .

expression type 
_
INTTYPE
FLOATTYPE
.TE
.IP 8.
Consistent types for post operators ++ and --:
.TS
expand tab(+) ;
c s
l .

expression type
_
INTTYPE
FLOATTYPE
.TE   
.IP 9.
After every expression, if the expr's type is String, then code to free up
temporarily allocated strings (scope -1) is generated.
Same with Que type.
.RE
.sp
.LP
.nf
.Ty
exprTerms::=   consts
	     | identifier '(' args ')'
	     | identifier
.fi
.RS
NOTE:
.RS
.IP 1.
For function calls, "identifier(args)", identifier must have been previously
declared. Also, the arguments' types must match the proto types except in
special functions like the following:
.RS  
.IP a.
Job QueJobFind( Que que, Fun <ReturnType> function(Job job),
{EQ, NEQ, GE, GT, LE, LT}, <ReturnType> value )
.IP b.
Job QueJobFind( Que que, Fun <ReturnType> function(Job job), {MAX, MIN} )
.IP c.
Que QueFilter(Que que, Fun <ReturnType> function(Job job),
{EQ,NEQ,GE,GT,LE,LT}, <ReturnType> value )
.IP d.
Que QueFilter( Que que, Fun Job function(Job job), {MAX, MIN} )
.sp
For the above functions, CodeGenBuffSaveQueJobFind() and
CodeGenBuffSaveQueFilter() are called to generate code. In forms (a) and
(c), the <ReturnType> of arguments 2 and 4 must match, and the code
generated depends on the <ReturnType>.
.RE
.IP 2.
Functions are classified into 2 category: internally-defined (or built-ins),
and externally-defined (as defined by the scheduler writer). If identifier
refers to a function that has been externally defined, then
a "basl_" prefix is added to the function name during code generation so as to
avoid name collision when the code is linked with system, PBS libraries.
.IP 3.
Any identifier used must have been previously declared. 
.RE
.RE
.sp
.LP
.nf
.Ty
statPrint::=   "print" '(' identifier ')'
             | "print" '(' consts ')'
.fi
.RS
.IP 1.
Allowed types for identifier, consts:
.TS
expand tab(+) ;
c s s
l l .

TYPE
_
Int
Float
Dayofweek
String
Size
Que
Job
CNode
Server
Range Int
Range Float
Range Dayofweek
Range DateTime
Range Size
.TE
.RE
.sp
.LP
.nf
.Ty
statFor::= "for" '(' statForAssign ';' identifier cprOp expr ';'
           statForAssign ')' block
.fi
.RS
NOTE:
.RS
.IP 1.
Upon entering the for loop, inLoop counter is incremented; it is decremented
upon exit.
.RE
.RE
.sp
.LP
.nf
.Ty
statForAssign:   identifier eqs expr
               | identifier postop
.fi
.RS
NOTE:
.RS
.IP 1.
In the first form, identifier and expr must be of type INTTYPE or FLOATTYPE.
.IP 2.
In the second form, identifier must be of type INTTYPE or FLOATTYPE.
.RE
.RE
.sp
.LP
.nf
.Ty
statIf::=   "if" '(' expr ')' block
	  | "if" '(' expr ')' block "else" block
.fi
.RS
NOTE:
expr's return type is either INT or FLOAT.
.RE
.sp
.LP
.nf
.Ty
statReturn::=   "return" '(' identifier ')'
	      | "return" '(' consts ')'	
	      | "return" '(' ')'	
.fi
.RS
NOTE:
.RS
.IP 1.
The type returned by identifier and consts must match the calling function's
return type.
.IP 2.
if the identifier is of string type, then generate code that will modify its
scope to be -1 (become a temporary string) so that the malloc-ed storage for it
does not get cleared up yet upon return. It will get freed on the next call to
varstrFree() to free up temporary strings, which takes place after
an expression involving the function call is executed.
.IP 3.
if the identifier is of Que type, then generate code that will modify its
scope to be -1 (a temporary queue) only if its current scope is not global
(mallocTableSafeModScope). This is so that malloc-ed storage for the Que
identifier does not get cleared up yet. It will get freed on the next call to 
mallocTableFreeByScope() of temporary queue variables, which takes place after
an expression involving the function call is executed.
.IP 4.
The third form "return()" is allowed if the return type of the enclosing
function is of type Void.
.RE
.RE
.LP
.nf 
.Ty
statSwitch::= "switch" '(' identifier ')' '{' caseList defCase '}'
.fi
.RS
NOTE:
.RS
.IP 1.
The identifier's type cannot be of type Void.
.IP 2.
inSwitch variable keeps track of whether or not the parser is currently 
inside a switch construct. CurrSwitchVar holds the switch variable token. So
when the parser enters the switch statement, ParserLevel and inSwitch variables
are incremented, and CurrSwitchVar is set appropriately.  Decrement
ParserLevel, inSwitch upon leaving.
.RE
.RE
.sp
.LP
.nf
.Ty
caseList::= ''
            | caseList caseElement	

caseElement::=    "case" intConst        ':' block
                | "case" floatConst      ':' block
                | "case" dayofweekConst  ':' block
                | "case" datetimeConst   ':' block
                | "case" sizeConst       ':' block
                | "case" stringConst     ':' block
                | "case" serverConst     ':' block
                | "case" queConst        ':' block
                | "case" jobConst        ':' block
                | "case" cnodeConst      ':' block
                | "case in" constRange   ':' block
                | "case in" identifier   ':' block

defCase::=   ''
             | 'default' ':' block
.fi
.RS
NOTE:
.RS
.IP 1.
The identifier's type in statSwitch must match the type given in caseElement.
.IP 2.
The case labels are not allowed to be duplicated.
.IP 3.
The allowed constRange and identifier types in "case in" depends on the
identifier's type on the "switch" statement as follows:
.TS
expand tab(+) ;
c s s
l l .

switch identifier type+constRange, identifier type
_+_
SERVERTYPE+SERVERSETTYPE
QUETYPE+QUESETTYPE
JOBTYPE+JOBSETTYPE
CNODETYPE+CNODESETTYPE
INTTYPE+INTRANGETYPE
FLOATTYPE+FLOATRANGETYPE
DAYOFWEEKTYPE+DAYOFWEEKRANGETYPE
DATETIMETYPE+DATETIMERANGETYPE
SIZETYPE+SIZERANGETYPE
.TE
.RE
.RE
.LP
.nf
.Ty
statContinue::= "continue" ';'
.fi
.RS
NOTE:
The continue statement must have been invoked within a loop. This is done by
checking to see if inLoop counter is > 0.
.RE
.sp
.LP
.nf
.Ty
statBreak::= "break" ';'
.fi
.RS
NOTE:
The break statement must have been invoked within a loop. This is done by 
checking to see if inLoop counter is > 0.
.RE
.sp
.LP
.nf
.Ty
statExit::= "exit" '(' intConst ')' ';'
.fi
.RS
NOTE:
Before the "exit" statement is generated, generate code also that will
free up storage allocated at the current variable scope.
.RE
.sp
.LP
.nf
.Ty
consts::=   intConst
          | floatConst
          | dayofweekConst
          | datetimeConst
          | stringConst
          | sizeConst
          | cprOp
          | constRange
          | 'MAX'	
          | 'MIN'
          | serverConst
          | queConst
          | jobConst
          | cnodeConst
          | setServerConst
          | setQueConst
          | setJobConst
          | setCnodeConst
          | stringConst

constRange:   intConstRange
            | floatConstRange
            | dayofweekConstRange
            | datetimeConstRange
            | sizeConstRange

intConst::= [+-]?[0-9]+
            | "SUCCESS"
            | "FAIL"
            | "SERVER_ACTIVE"
            | "SERVER_IDLE"
            | "SERVER_SCHED"
            | "SERVER_TERM"
            | "SERVER_TERMDELAY"
            | "QTYPE_E"
            | "QTYPE_R"
            | "SCHED_DISABLED"
            | "SCHED_ENABLED"
            | "FALSE"
            | "TRUE"
            | "TRANSIT"
            | "QUEUED"
            | "HELD"
            | "WAITING"
            | "RUNNING"
            | "EXITING"
            | "CNODE_OFFLINE"
            | "CNODE_DOWN"
            | "CNODE_FREE"
            | "CNODE_RESERVE"
            | "CNODE_INUSE_EXCLUSIVE"
            | "CNODE_INUSE_TIMESHARED"
            | "CNODE_TIMESHARED"
            | "CNODE_CLUSTER"
            | "CNODE_UNKNOWN"
            | "SYNCRUN"
            | "ASYNCRUN"
            | "DELETE"
            | "RERUN"
            | "HOLD"
            | "RELEASE"
            | "SIGNAL"
            | "MODIFYATTR"
            | "MODIFYRES"
            | "OP_EQ"
            | "OP_NEQ"
            | "OP_LT"
            | "OP_LE"
            | "OP_GE"
            | "OP_GT"
            | "OP_MAX"
            | "OP_MIN"
	     	 		
floatConst::= [+-]?[0-9]+[.][0-9]*

dayofweekConst::=   "SUN"
                  | "MON"
                  | "TUE"
                  | "WED"
                  | "THU"
                  | "FRI"
                  | "SAT"

datetimeConst::=   '(' intConst '|' intConst '|' intConst ')'
                 | '(' intConst ':' intConst ':' intConst ')'
                 | '(' intConst '|' intConst '|' intConst '@' intConst ':' intConst ':' intConst ')'


serverConst::=	NOSERVER

queConst::=	NOQUE

jobConst::=	NOJOB

cnodeConst::=	NOCNODE

setServerConst::= EMPTYSETSERVER 

setQueConst::= EMPTYSETQUE

setJobConst::= EMPTYSETJOB

setCnodeConst::= EMPTYSETCNODE

stringConst::= NULLSTR
.fi
.RS
NOTE:
.RS
.IP 1.
A time constant (hh:mm:ss) must satisfy the condition:
.br
0 <= hh <= 23, 0 <= mm <= 59, 0 <= ss  <= 61.
.IP 2.
A date constant (mon|day|year) must satisfy the condition:
.br
1 <= mon <= 12, 1 <= day <= 31, 0 <= year.
.IP 3.
A time/date constant (mon|day|year@hh:mm:ss) must satisfy 1) and 2). 
.RE
.RE
.LP
.nf
.Ty
stringConst::= ["][a-zA-Z0-9 \n]*["]

sizeConst::= [+-]?[0-9]+[kmgtpKMGTP]?[bwBW]

intConstRange::= '(' intConst ',' intConst ')'
.fi
.RS
NOTE:
For an int constant range, the 1st part must be <= 2nd part.
.RE
.LP
.nf
.Ty 
floatConstRange::= '(' floatConst ',' floatConst ')'
.fi
.RS
NOTE:
For a float constant range, the 1st part must be <= 2nd part.
.RE
.LP
.nf
.Ty
dayofweekConstRange::= '(' dayofweekConst ',' dayofweekConst ')'
.fi
.RS
NOTE:
For a dayofweek constant range, the 1st part must be <= 2nd part.
.RE
.LP
.nf
.Ty
datetimeConstRange::= '(' datetimeConst ',' datetimeConst ')'
.fi
.RS
NOTE:
For a datetime constant range, if both the 1st part and 2nd part are the full
date/time construct, then 1st part <= 2nd part. 
.RE
.LP
.nf
.Ty
sizeConstRange::= '(' sizeConst ',' sizeConst ')'
.fi
.RS
NOTE:
The 1st part must be <= 2nd part.
.RE
.sp
.LP
.nf
.Ty
cprOp::=  "LE"
        | "LT"
        | "GE"
        | "GT"
        | "EQ"
        | "NEQ"

args::=    ''
        | arg argList

argList::=   ''
        | ',' arg argList

arg::=    identifier
        | consts  

eqs::=    '='
.fi
.RS
.IP "NOTE:"
When '{' has been encountered, ParserLevel variable is incremented.
When '}' is encountered, if the block contains any kind of String type
variable, then code is generated to call varstrFreeByScope to free up 
strings that have been malloc-ed at that block (scope is determined via
the variable ParserVarScope). Also, if the block that the
parser is in is sched_main()'s, then  code for varstrFreeByScope(-1) is
generated to free up all temporary malloc-ed strings. Also if the block contains
declarations for Que type variables, then code to free up malloc-ed
storage for the temporary Que structures is generated.
.sp
Code to free up malloc-ed storage (varstrFree(), mallocTableFree(),
varstrModScope(), mallocTableSafeModScope()) are generated appropriately
before a return statement, exit statement, or level 1 right curly bracket.
 "generated appropriately" means that if any string has been declared at level 1
in the enclosing function, then varstrFree() code will be generated along with
the appropriate variable scope to free; similarly, mallocTableFree() code will
be generated if any Que type entity has been declared at level 1 in the
enclosing function. 
.RE
.fi
.ft 1
.NH 5
.Fi Parser.c
.Fn yyerror
.Cs
void yyerror(char *ep)
.Ce
.LP
A slightly modified version of the yacc's yyerror() call where addition message
about linenum is printed out to the parser's stdout stream.
.Fn ParserInit
.Cs
void ParserInit(void)
.Ce
.LP
Initializes variables ParserLevel (keeps track of program nestings) and
ParserVarScope (keeps track of variable's readability within a BASL program).
.Fn ParserPrintToken
.Cs
void ParserPrintToken(char *lexeme, int lin, int len, int typ)
.Ce
.LP
If there's a parser stdout stream and the parser debug flag is turned on, then
print out the values of the given parameters.
.Fn ParserPutDF
.Cs
void ParserPutDF(int df)
.Ce
.LP
Set the parser debug flag to the given
.Ty df
value.
.Fn ParserLevelIncr
.Cs
void ParserLevelIncr(void)
.Ce
.LP
Increments the ParserLevel variable, and sends a message to parser stdout 
stream saying that it has done so.
.Fn ParserLevelDecr
.Cs
void ParserLevelDecr(void)
.Ce
.LP
Decrement the ParserLevel variable, and sends a message to parser stdout 
stream saying that it has done so.
.Fn ParserLevelGet
.Cs
int ParserLevelGet(void)
.Ce
.LP
Returns the value to the ParserLevel variable.
.Fn ParserVarScopeIncr
.Cs
void ParserVarScopeIncr(void)
.Ce
.LP
Increments the ParserVarScope variable, and sends a message to parser stdout 
stream saying that it has done so.
.Fn ParserVarScopeGet
.Cs
int ParserVarScopeGet(void)
.Ce
.LP
Returns the value to the ParserVarScope variable.
.Fn ParserCondPrint
.Cs
void ParserCondPrint(char *str)
.Ce
.LP
Prints
.Ty str
to parser stdout stream (if any) and if the parser debug flag is turned on.   
.Fn ParserErr
.Cs
void ParserErr(int e)
.Ce
.LP
Prints the message string associated with error
.Ty e
to parser stdout stream (if any).
.Fn ParserCurrFunPtrPut
.Cs
void ParserCurrFunPtrPut(Np np)
.Ce
.LP
Makes
.Ty np
be the current pointer to a node containing a function token.
.Fn ParserCurrFunPtrGet
.Cs
Np ParserCurrFunPtrGet(void)
.Ce
.LP
Returns the current pointer to the node containing a function token.
.Fn ParserCurrFunParamPtrPut
.Cs
void ParserCurrFunParamPtrPut(Np np)
.Ce
.LP
Makes
.Ty np
be the current pointer to a node that is holding a function parameter token.
.Fn ParserCurrFunParamPtrGet
.Cs
Np ParserCurrFunParamPtrGet(void)
.Ce
.LP
Returns the current pointer to a node that is holding a function parameter
token.
.Fn ParserCurrSwitchVarPut
.Cs
void ParserCurrSwitchVarPut(struct MYTOK token)
.Ce
.LP
Makes
.Ty token
be the switch variable.
.Fn ParserCurrSwitchVarGet
.Cs
struct MYTOK ParserCurrSwitchVarGet(void)
.Ce
.LP
Returns the current switch variable token.
.LP
.NH 4
.Tc Symbol Table
.LP
The symbol table contains data structures that are accessed by the Lexer,
Parser, Semantic analyzer, and code generator in order to perform various
tasks leading to the translation of BASL code into C. The symbol table stores
the variable and structure names, labels, and all other names used in the
program. The files involved with
the symbol table are Node.h, Node.c, List.h, List.c, SymTabGlob.h,
SymTab.h, and SymTab.c.
.NH 5
.Fi Node.h
.LP
The main data structure manipulated by the routines in this file is the Node
class shown in the following:
.sp
.nf
.Ty
    struct FUNDESCR
    {
           int paramCnt;
           struct Node *paramPtr;
    };

    struct Node
    {
           char lexeme[LEXEMSZ];
           int  type;            /* Semantic type */
           int  lineDef;
           int  level;
           int  funFlag;
           struct FUNDESCR funDescr;
           struct Node *rptr;
    }
    typedef struct Node *np;
.fi 
.NH 5
.Fi Node.c
.LP
.Fn NodeNew
.Cs
Np NodeNew(char *lexem, int typ, int lin, int leve, int funFla)
.Ce
.IP Args: 4
.RS
.IP lexem 8
A match token string.
.IP type 8
Internal data type of lexem.
.IP lin 8
The line number in the program input file where the lexem was found.
.IP leve 8
The nesting level of the matched token.
.IP funFla 8
The flag that says whether or not the lexem is part of a function definition.
.RE
.LP
Create a new Node structure by malloc-ing its storage, and then fill it with
values given by the function arguments. A pointer to this Node structure is
returned.
.Fn NodeInit
.Cs
void NodeInit(Np nx, char *lexem, int typ, int lin, int leve, int funFla)
.Ce
.IP Args: 4
.RS
.IP nx 8
A pointer to an existing node structure.
.IP lexem 8
A match token string.
.IP type 8
Internal data type of lexem.
.IP lin 8
The line number in the program input file when the lexem was found.
.IP leve 8
The nesting level of the matched token.
.IP funFla 8
The flag that says whether or not the lexem is part of a function definition.
.RE
.LP
Fill an existing Node structure with values given by the function arguments.
.Fn NodePrint
.Cs
void NodePrint(Np nx)
.Ce
.IP Args: 4
.RS
.IP nx 8
A pointer to an existing node structure.
.RE
.LP
Print out to the Node stdout stream (if any) the values of the given Node
structure.
.Fn NodeFunDescrPrint
.Cs
void NodeFunDescrPrint(Np nx)
.Ce
.IP Args: 4
.RS
.IP nx 8
A pointer to an existing node structure.
.RE
.LP
Just print the function description values for the given Node structure.
.Fn NodeFunDescrFindByLexeme
.Cs
Np NodeFunDescrFindByLexeme(Np nx, char *lexem)
.Ce
.IP Args: 4
.RS
.IP nx 8
A pointer to an existing node structure.
.IP lexem 8
The token to match. 
.RE
.LP
Return the pointer to the node that is a parameter pointer structure, whose
lexeme value is the one given in this function's argument.
.Fn NodeCmp
.Cs
int NodeCmp(Np nx, char *lexem)
.Ce
.IP Args: 4
.RS
.IP nx 8
A pointer to an existing node structure.
.IP lexem 8
The token to match.
.RE
.LP
Compares the Node nx's lexem with that of the argument lexem (given). Returns
1 if the former is > latter, -1 if the former is < latter, 0 if they are the
same.
.Fn NodeErr
.Cs
void NodeErr(int e)
.Ce
.IP Args: 4
.RS
.IP e 8
error number.
.RE
.LP
Prints the error message associated with error number e.
.Fn NodeCondPrint
.Cs
void NodeCondPrint(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string message to print out.
.RE
.LP
If Node debug flag is on and if there's a  Node stdout stream, then print
the given message.
.Fn NodePutDF
.Cs
void NodePutDF(int df)
.Ce
.IP Args: 4
.RS
.IP df 8
The new debug flag value.
.RE
.LP
Updates the Node debug flag value to df.
.Fn NodeGetLexeme
.Cs
char *NodeGetLexeme(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the lexeme attribute value of nxp.
.Fn NodeGetType
.Cs
int NodeGetType(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the type attribute value of nxp.
.Fn NodeGetLineDef
.Cs
int NodeGetLineDef(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the lineDef attribute value of nxp.
.Fn NodeGetLevel
.Cs
int NodeGetLevel(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the level attribute value of nxp.
.Fn NodeGetFunFlag
.Cs
int NodeGetFunFlag(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the funFlag attribute value of nxp.
.Fn NodeGetParamPtr
.Cs
Np NodeGetParamPtr(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns pointer to the Node nxp's 1st parameter.
.Fn NodeGetLexeme
.Cs
char *NodeGetLexeme(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the lexeme attribute value of nxp.
.Fn NodeGetType
.Cs
int NodeGetType(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the type attribute value of nxp.
.Fn NodeGetLineDef
.Cs
int NodeGetLineDef(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the lineDef attribute value of nxp.
.Fn NodeGetLevel
.Cs
int NodeGetLevel(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the level attribute value of nxp.
.Fn NodeGetFunFlag
.Cs
int NodeGetFunFlag(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns the funFlag attribute value of nxp.
.Fn NodeGetParamPtr
.Cs
Np NodeGetParamPtr(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Returns pointer to the Node nxp's 1st parameter.
.Fn NodePutLexeme
.Cs
void NodePutLexeme(Np nxp, char *lexem)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.IP lexem 8
new lexem value.
.RE
.LP
Makes lexem be the new nxp lexeme value.
.Fn NodePutType
.Cs
void NodePutType(Np nxp, int type)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.IP type 8
The new type for the Node's lexeme.
.RE
.LP
Replaces the type attribute value of nxp to the given argument.
.Fn NodePutLineDef
.Cs
void NodePutLineDef(Np nxp, int lin)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.IP lin 8 
The new line for the Node's lexeme.
.RE
.LP
Replaces the lineDef attribute value to the given argument.
.Fn NodePutLevel
.Cs
void NodePutLevel(Np nxp, int level)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.IP level 8
The new level for the Node's lexeme.
.RE
.LP
Replaces the level attribute value of nxp to the given argument.
.Fn NodePutFunFlag
.Cs
void NodePutFunFlag(Np nxp, int funFla)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure.
.IP funFla
The new function flag for the Node's lexeme.
.RE
.LP
Replaces the funFlag attribute value of nxp to the given argument.
.Fn NodePutParamPtr
.Cs
void NodePutParamPtr(Np nxp, Np paramPtr)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.IP paramPtr 8
A pointer to a Node's paramPtr structure. 
.RE
.LP
Replaces the pointer value to the Node nxp's 1st parameter to the given
argument.
.Fn NodePutParamCnt
.Cs
void NodePutParamCnt(Np nxp, int paramCnt)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.IP paramCnt 8
# of parameters to the function node.
.RE
.LP
Replaces the paramCnt attribute of Node nxp to the given argument.
.Fn NodeParamCntIncr
.Cs
void NodeParamCntIncr(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Increments the paramCnt attribute of Node nxp.
.Fn NodeParamCntDecr
.Cs
void NodeParamCntDecr(Np nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a Node structure. 
.RE
.LP
Decrements the paramCnt attribute of Node nxp.
.NH 5
.Fi List.c
.LP
.Fn ListPutDF
.Cs
void ListPutDF(int df)
.Ce
.IP Args: 4
.RS
.IP df 8
the new debug flag value.
.RE
.LP
Set the List debug flag value to df.
.Fn ListCondPrint
.Cs
void ListCondPrint(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The message to print out.
.RE
.LP
If List debug flag is on, and there's a List stdout stream, then print out the
message str.
.Fn ListIsEmpty
.Cs
int ListIsEmpty(List L)
.Ce
.IP Args: 4
.RS
.IP L 8
A pointer to the head of the list of Nodes.
.RE
.LP
Returns 1 if the L is NULL; 0 otherwise.
.Fn ListPrint
.Cs
void ListPrint(List L)
.Ce
.IP Args: 4
.RS
.IP L 8
A pointer to the head of the list of Nodes.
.RE
.LP
Prints every member of a list of Nodes. 
.Fn ListInsertFront
.Cs
List ListInsertFront(List L, Np nxp)
.Ce
.IP Args: 4
.RS
.IP L 8
A pointer to the head of the list of Nodes.
.IP nxp 8
A new node to insert into the list.
.RE
.LP
Insert the Node nxp in front of L, and returns nxp.
.Fn ListParamLink
.Cs
void ListParamLink(Np funNp, Np parNp)
.Ce
.IP Args: 4
.RS
.IP funNp 8
A pointer to the head of the list of Nodes.
.IP parNp 8
A new node to insert into the list.
.RE
.LP
Inserts parNp at the end of function Node funNp's parameter list.
.Fn ListInsertSortedN
.Cs
List ListInsertSortedN(List L, Np nxp)
.Ce
.IP Args: 4
.RS
.IP L 8
A pointer to the head of the list of Nodes.
.IP nxp 8
A new node to insert into the list.
.RE
.LP
Insert the Node nxp into the List L in a way that the increasing
lexicographical  ordering of lexemes is maintained.
.Fn ListInsertSortedD
.Cs
List ListInsertSortedD(List L, char *lexem, int typ, int lineDe, int leve, int funFla)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP lexem 8
A lexeme for the new Node.
.IP type 8
A type for the new Node. 
.IP lineDe 8
The line # where the lexeme was found.
.IP level 8
The nesting level of the Node.
.IP funFla 8
The function flag of the Node.
.RE
.LP
Creates a new Node with the given values, and insert the Node into the list
in a sorted manner. Returns the pointer to the new List.
.Fn ListIsMember
.Cs
int ListIsMember(List L, Np nxp)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP nxp 8
A Node pointer. 
.RE
.LP
Returns 1 if nxp is a member of the List of Nodes L; 0, otherwise.
.Fn ListGetLast
.Cs
Np ListGetLast(List L)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.RE
.LP
Returns the last node in the List of Nodes L.
.Fn ListGetSucc
.Cs
Np ListGetSucc(List L, Np nxp)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP nxp 8
A Node pointer.
.RE
.LP
Returns the next Node element after nxp.
.Fn ListDeleteNode
.Cs
List ListDeleteNode(List L, Np nxp)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP nxp 8
A Node pointer.
.RE
.LP
Deletes the node pointed by nxp, and free up any malloc-ed storage for it. 
.Fn ListDelete
.Cs
List ListDelete(List L)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.RE
.LP
Deletes the entire List of Nodes L. Malloc-ed areas are freed. 
.Fn ListDeleteLevel
.Cs
List ListDeleteLevel(List L, int leve)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP leve 8
A Node level.
.RE
.LP
Deletes all Nodes in List L that have a level leve. Return a new List L.
.Fn ListFindNodeByLexeme
.Cs
Np ListFindNodeByLexeme(List L, char *lexeme)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP lexeme 8
A lexeme to look for.
.RE
.LP
Returns the Node in the List of Nodes that contains the given lexeme.
.Fn ListFindNodeByLexemeInLevel
.Cs
Np ListFindNodeByLexemeInLevel(List L, char *lexeme, int leve)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP lexeme 8
A lexeme to look for
.IP leve 8
A level to look for.
.RE
.LP
Returns the Node in the List of Nodes that contains the given lexeme and level.
.Fn ListFindNodeByLexemeInLine
.Cs
Np ListFindNodeByLexemeInLine(List L, char *lexeme, int line)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP lexeme 8
A lexeme to look for
.IP line 8
A line to look for.
.RE
.LP
Returns the Node in the List of Nodes that contains the given lexeme and line.  
.Fn ListMatchNodeByLexemeInLine
.Cs
Np ListMatchNodeByLexemeInLine(List L, char *lexeme, int line)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP lexeme 8
A lexeme to look for
.IP line 8
A line to look for.
.RE
.LP
Returns the Node in the List of Nodes that match the given lexeme and line.  
.Fn ListFindNodeBeforeLexemeInLine
.Cs
Np ListFindNodeBeforeLexemeInLine(List L, char *lexeme, int line)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP lexeme 8
A lexeme to look for
.IP line 8
A line to look for.
.RE
.LP
Returns the Node in the List of Nodes that is before the node containing the
given lexeme and line. If the node found that contain the lexeme and line does
not have a previous node (head of List), then that node itself is returned.
.Fn ListMatchNodeBeforeLexemeInLine
.Cs
Np ListMatchNodeBeforeLexemeInLine(List L, char *lexeme, int line)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP lexeme 8
A lexeme to look for
.IP line 8
A line to look for.
.RE
.LP
Returns the Node in the List of Nodes that is before the node matching the
given lexeme and line. If the node found that match the lexeme and line does
not have a previous node (head of List), then that node itself is returned.
.Fn ListFindNodeByLexemeAndTypeInLevel
.Cs
Np ListFindNodeByLexemeAndTypeInLevel(List L, char *lexeme, int leve,
                                     int line, int (*compare_func)())
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP lexeme 8
A lexeme to look for
.IP level 8
A level to look for.
.IP line 8
A line to look for.
.IP compare_func
The compare function to use when comparing lexemes.
.RE
.LP
Returns the Node in the List of Nodes that contains lexeme, leve, and line. 
compare_func is used to determine whether or not the Node contains lexeme.
.Fn ListFindAnyNodeInLevelOfType
.Cs
Np ListFindAnyNodeInLevelOfType(List L, int leve, int type)
.Ce
.IP Args: 4
.RS
.IP L 8
A list of Nodes.
.IP leve 8
A level to look for.
.IP type 8
A type to look for.
.RE
.LP
Returns any Node in the List of Nodes that contains leve with 'type'. 
.Fn ListErr
.Cs
void ListErr(int e)
.Ce
.IP Args: 4
.RS
.IP e 8
error number.
.RE
.LP
Prints out the message associated with error number e.
.NH 5
.Fi SymTab.c
.LP
The symbol table is nothing more but a linked List.
.Fn SymTabInit
.Cs
void SymTabInit(void)
.Ce
.LP
Calls SymTabKeywordsInit() to initialize the symbol table.
.Fn SymTabPutDF
.Cs
void SymTabPutDF(int df)
.Ce
.IP Args: 4
.RS
.IP df 8
new debug flag value.
.RE
.LP
Sets the Symbol table debug flag to the value of the given argument.
.Fn SymTabCondPrint
.Cs
void SymTabCondPrint(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The message string to print out.
.RE
.LP
Prints out to Symbol table output stream (if any) the message 'str' only if
the debug flag is set.
.Fn SymTabIsEmpty
.Cs
int SymTabIsEmpty(void)
.Ce
.LP
Returns 1 if the symbol table is empty (head of the list is NULL).
.Fn SymTabPrint
.Cs
int SymTabPrint(void)
.Ce
.LP
Prints to stdout stream the entire symbol table.
.Fn SymTabInsertFront
.Cs
void SymTabInsertFront(STEP nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
The node to insert in front of the symbol table. 
.RE
.LP
Puts the node pointed to by 'nxp' at the head of the symbol table. 
.Fn SymTabParamLink
.Cs
void SymTabParamLink(STEP funNp, Np parNp)
.Ce
.IP Args: 4
.RS
.IP funNp 8
Pointer to the function node. 
.IP parNp 8
Pointer to a parameter node.
.RE
.LP
Inserts the node parNp at the end of function node funNp's parameter list.
.Fn SymTabInsertSortedN
.Cs
void SymTabInsertSortedN(STEP nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to the node to be inserted into the symbol table.
.RE
.LP
Inserts the node nxp into the symbol table, maintaining the lexicographical
ordering of the nodes' lexemes.
.Fn SymTabInsertSortedD
.Cs
void SymTabInsertSortedD(char *lexem, int typ, int lineDe, int leve, int funFla)
.Ce
.IP Args: 4
.RS
.IP lexem 8
A node lexeme value.
.IP typ 8
A lexeme's type.
.IP lineDe 8
A lexeme's lineDef value.
.IP level 8
A lexeme's level value. 
.IP funFla 8
A lexeme's function flag value.
.RE
.LP
Creates a new node with values (lexem, typ, lineDe, leve, funFla), and this
new node is inserted into the symbol table in a manner in which the
lexicographical ordering of the nodes' lexemes is maintained.
.Fn SymTabIsMember
.Cs
int SymTabIsMember(STEP nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a node.
.RE
.LP
Returns 1 if node 'nxp' is one of the nodes in the symbol table; 0 otherwise.
.Fn SymTabGetLast
.Cs
STEP SymTabGetLast(void)
.Ce
.LP
Returns the last element of the symbol table.
.Fn SymTabGetSucc
.Cs
STEP SymTabGetSucc(STEP nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a node.
.RE
.LP
Returns the node that comes after 'nxp' in the symbol table.
.Fn SymTabDeleteNode
.Cs
void SymTabDeleteNode(STEP nxp)
.Ce
.IP Args: 4
.RS
.IP nxp 8
A pointer to a node.
.RE
.LP
Removes the node 'nxp' from the symbol table.
.Fn SymTabDelete
.Cs
void SymTabDelete(void)
.Ce
.LP
Removes all the node elements from the symbol table.
.Fn SymTabFindFunProtoByLexemeInProg
.Cs
STEP SymTabFindFunProtoByLexemeInProg(char *lexeme)
.Ce
.IP Args: 4
.RS
.IP lexeme 8
Lexeme to search for.
.RE
.LP
Returns the function node that contains 'lexeme'.
.Fn SymTabFindNodeByLexemeInProg
.Cs
STEP SymTabFindNodeByLexemeInProg(char *lexeme)
.Ce
.IP Args: 4
.RS
.IP lexeme 8
Lexeme to search for.
.RE
.LP
Returns the node that contains 'lexeme'.
.Fn SymTabFindNodeByLexemeInLevel
.Cs
STEP SymTabFindNodeByLexemeInLevel(char *lexeme, int level)
.Ce
.IP Args: 4
.RS
.IP lexeme 8
Lexeme to search for.
.IP level 8
Level value to look for.
.RE
.LP
Returns the node that contains 'lexeme' and 'level'.
.Fn SymTabFindNodeByLexemeAndTypeInLevel
.Cs
STEP SymTabFindNodeByLexemeAndTypeInLevel(char *lexeme, int level,
                                  int type, int (*compare_func)())
.Ce
.IP Args: 4
.RS
.IP lexeme 8
Lexeme to search for.
.IP level 8
Level value to look for.
.IP type 8
Type value to search for.
.IP compare_func 8
Compare function to use when comparing the given 'lexeme' with the lexemes 
on the symbol table.
.RE
.LP
Returns the node that contains 'lexeme' (compared via 'compare_func'), 'level',
and 'type'.
.Fn SymTabFindAnyNodeInLevelOfType
.Cs
STEP SymTabFindAnyNodeInLevelOfType(int level, int type)
.Ce
.IP Args: 4
.RS
.IP level 8
Level value to look for.
.IP type 8
Type value to search for.
.RE
.LP
Returns any node that in 'level' that is of 'type'.
.Fn SymTabDeleteLevel
.Cs
STEP SymTabDeleteLevel(int leve)
.Ce
.IP Args: 4
.RS
.IP leve 8
Level value whose nodes will be deleted.
.RE
.LP
Remove nodes whose level is 'leve'.
.Fn SymTabKeyWordsInit
.Cs
void SymTabKeyWordsInit(void)
.Ce
.LP
Initializes the symbol table by creating an "endmarker" node.
.Fn SymTabGetOrigin
.Cs
STEP SymTabGetOrigin(void)
.Ce
.LP
Returns the first node in the symbol table.
.Fn SymTabErr
.Cs
void SymTabErr(int e)
.Ce
.IP Args: 4
.RS
.IP e 8
An error number.
.RE
.LP
Prints out to symbol table stdout stream the message string associated with
error 'e'.
.LP
.NH 4
.Tc Semantic Analyzer
.LP
The files involved with the Semantic analyzer subsystem are Semantic.h, and
Semantic.c. The semantics analyzer is responsible for checking to make sure
that tokens are used together in a consistent and valid way.
.LP
.NH 5
.Fi Semantic.c
.Fn SemanticInit
.Cs
void SemanticInit(void)
.Ce
.LP
Initializes any internal variables used by the semantics analyzer.
.Fn SemanticPutDF
.Cs
void SemanticPutDF(int df)
.Ce
.IP Args: 4
.RS
.IP df 8
The new debug flag value
.RE
.LP
Sets the semantics debug flag to the 'df' value.
.Fn SemanticCondPrint
.Cs
void SemanticCondPrint(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The message to print out.
.RE
.LP
Prints to semantics stdout (if any) the 'str' message only if the semantics
debug flag is on.
.Fn SemanticErr
.Cs
void SemanticErr(int e)
.Ce
.IP Args: 4
.RS
.IP e 8
Error number.
.RE
.LP
Prints the message associated with error number 'e'.
.Fn SemanticStatAssignCk
.Cs
void SemanticStatAssignCk(struct MYTOK var, struct MYTOK expr)
.Ce
.IP Args: 4
.RS
.IP var 8
An identifier token to be assigned a new value.
.IP expr 8
An expression token whose value will be assigned to 'var'.
.RE
.LP
So this semantically checks the BASL grammar: var = expr.
See grammar specification for consistent types for 'var' and 'expr'.
.Fn SemanticPlusExprCk
.Cs
void SemanticStatPlusExprCk(struct MYTOK left_expr, struct MYTOK right_expr)
.Ce
.IP Args: 4
.RS
.IP left_expr 11
The left expression in a '+' arithmetic expression. 
.IP right_expr 11
The right expression in a '+' arithmetic expression. 
.RE
.LP
This semantically checks the BASL grammar: left_expr + right_expr.
Allowed types to be added are String, Size, Int, and Float. See grammar
specification for mutually consistent types for 'left_expr' and 'right_expr'.
.Fn SemanticMinusExprCk
.Cs
void SemanticStatMinusExprCk(struct MYTOK left_expr, struct MYTOK right_expr)
.Ce
.IP Args: 4
.RS
.IP left_expr 11
The left expression in a '-' arithmetic expression. 
.IP right_expr 11
The right expression in a '-' arithmetic expression. 
.RE
.LP
This semantically checks the BASL grammar: left_expr - right_expr.
Allowed types to be subtracted are Size, Int, and Float. See grammar
specification for mutually consistent types for 'left_expr' and 'right_expr'.
.Fn SemanticStatMultDivExprCk
.Cs
void SemanticStatMultDivExprCk(struct MYTOK left_expr, struct MYTOK right_expr)
.Ce
.IP Args: 4
.RS
.IP left_expr 11
The left expression in a '*', '/' arithmetic expression. 
.IP right_expr 11
The right expression in a '*', '/' arithmetic expression. 
.RE
.LP
This semantically checks the BASL grammar: left_expr * right_expr or
left_expr / right_expr.
Allowed types to be multiplied or divided are Size, Int, and Float. See grammar
specification for mutually consistent types for 'left_expr' and 'right_expr'.
.Fn SemanticStatModulusExprCk
.Cs
void SemanticStatModulusExprCk(struct MYTOK left_expr, struct MYTOK right_expr)
.Ce
.IP Args: 4
.RS
.IP left_expr 11
The left expression in a '%' arithmetic expression. 
.IP right_expr 11
The right expression in a '%' arithmetic expression. 
.RE
.LP
This semantically checks the BASL grammar: left_expr % right_expr.
Allowed type to be remaindered is Int. See grammar
specification for mutually consistent types for 'left_expr' and 'right_expr'.
.Fn SemanticStatCompExprCk
.Cs
void SemanticStatCompExprCk(struct MYTOK left_expr, struct MYTOK right_expr)
.Ce
.IP Args: 4
.RS
.IP left_expr 11
The left expression in a logical expression involving EQ, NEQ, LE, LT, GE, GT. 
.IP right_expr 11
The right expression in a logical expression involving EQ, NEQ, LE, LT, GE, GT. 
.RE
.LP
This semantically checks the BASL grammar: left_expr <logical_op> right_expr.
Allowed types to be logically operated are: Int, Float, Dayofweek, DateTime,
String, Size, Server, Que, Job, CNode, Set Server, Set Que, Set Job, Set CNode.
See grammar specification for mutually consistent types for 'left_expr'
and 'right_expr'.
.Fn SemanticStatAndOrExprCk
.Cs
void SemanticStatAndOrExprCk(struct MYTOK left_expr, struct MYTOK right_expr)
.Ce
.IP Args: 4
.RS
.IP left_expr 11
The left expression in a logical expression involving AND, OR. 
.IP right_expr 11
The right expression in a logical expression involving AND, OR. 
.RE
.LP
This semantically checks the BASL grammar: left_expr <AND|OR> right_expr.
Allowed types to be AND/OR-ed are: Int, Float.
See grammar specification for mutually consistent types for 'left_expr'
and 'right_expr'.
.Fn SemanticStatNotExprCk
.Cs
void SemanticStatNotExprCk(struct MYTOK expr)
.Ce
.IP Args: 4
.RS
.IP expr 8
The expression in a unary expression: !expr. 
.RE
.LP
This semantically checks the BASL grammar: !expr.
Allowed types to the ! operator are: Int, Float.
.Fn SemanticStatPostOpExprCk
.Cs
void SemanticStatPostOpExprCk(struct MYTOK expr)
.Ce
.IP Args: 4
.RS
.IP expr 8
The expression in a unary expression: expr++, expr--. 
.RE
.LP
This semantically checks the BASL grammar: expr++, expr--.
Allowed types to the ++, -- operators are: Int, Float.
.Fn SemanticStatUnaryExprCk
.Cs
void SemanticStatUnaryExprCk(struct MYTOK expr)
.Ce
.IP Args: 4
.RS
.IP expr 8
The expression in a unary expression: +expr, -expr. 
.RE
.LP
This semantically checks the BASL grammar: +expr, -expr.
Allowed types to the unary operators are: Int, Float, Size.
.Fn SemanticStatPrintTailCk
.Cs
void SemanticStatPrintTailCk(struct MYTOK expr)
.Ce
.IP Args: 4
.RS
.IP expr 8
The expression in a return statement: return(expr). 
.RE
.LP
This semantically checks the BASL grammar: return(expr).
Allowed types to the return expr are: Int, Float, Dayofweek, DateTime, String,
Size, Que, Job, CNode, Server, Range Int, Range Float, Range Dayofweek,
Range DateTime, Range Size.
.Fn SemanticStatWhileHeadCk
.Cs
void SemanticStatWhileHeadCk(struct MYTOK expr)
.Ce
.IP Args: 4
.RS
.IP expr 8
The expression in a while statement. 
.RE
.LP
This semantically checks the BASL grammar: while(expr) { ... }.
Allowed types to the expr are: Int, Float.
.Fn SemanticStatIfHeadCk
.Cs
void SemanticStatIfHeadCk(struct MYTOK expr)
.Ce
.IP Args: 4
.RS
.IP expr 8
The expression in an if statement. 
.RE
.LP
This semantically checks the BASL grammar: if(expr) { ... }.
Allowed types to the expr are: Int, Float.
.Fn SemanticStatReturnTailCk
.Cs
void SemanticStatReturnTailCk(struct MYTOK expr)
.Ce
.IP Args: 4
.RS
.IP expr 8
The return expression to check.
.LP
This semantically checks the BASL grammar: return(expr). 'expr' must match
the enclosing function's return type. Allowed expr types are: Dayofweek,
DateTime, String, Size, Server, Que, Job, CNode, Int, Float.
.RE
.LP
This semantically checks the BASL grammar: if(expr) { ... }.
Allowed types to the expr are: Int, Float.
.Fn SemanticVarDefCk
.Cs
void SemanticVarDefCk(struct MYTOK var)
.Ce
.IP Args: 4
.RS
.IP var 8
The variable to check.
.RE
.LP
This semantically checks the variable definition construct in a BASL grammar.
 'var' must have not been previously declared.  
.Fn SemanticForHeadCk
.Cs
void SemanticForHeadCk(struct MYTOK exp6, struct MYTOK exp8)
.Ce
.IP Args: 4
.RS
.IP exp6 8
An expression to semantically check.
.IP exp8 8
An expression to semantically check.
.RE
.LP
This semantically checks the for head construct in a BASL grammar:
for(statForAssign; exp6 cprOp exp8; statForAssign) ...
exp6 and exp8 must have types that are either Int or Float.
.Fn SemanticForAssignCk
.Cs
void SemanticForAssignCk(struct MYTOK exp1, struct MYTOK exp2)
.Ce
.IP Args: 4
.RS
.IP exp1 8
An expression to semantically check.
.IP exp2 8
An expression to semantically check.
.RE
.LP
This semantically checks the statForAssign statement found in a for head
construct: expr1 = expr2.
exp1 and exp2 must have types that are either Int or Float.
.Fn SemanticForPostAssignCk
.Cs
void SemanticForAssignCk(struct MYTOK exp)
.Ce
.IP Args: 4
.RS
.IP exp 8
An expression to semantically check.
.RE
.LP
This semantically checks the post-operated assignment statement that can be
found in a for head construct in a BASL grammar.
exp must have type that is either Int or Float.
.Fn SemanticForeachHeadCk
.Cs
void SemanticForeachHeadCk(struct MYTOK val1, struct MYTOK val2)
.Ce
.IP Args: 4
.RS
.IP val1 8
The first identifier in a foreach statement.
.IP val2 8
The second identifier in a foreach statement.
.RE
.LP
This semantically checks to make sure that val1 is one of {Server, Que, Job,
CNode} and that they match up 1:1 with val2 values {Set Server, Set Que,
Set Job, Set CNode}.
.Fn SemanticParamVarCk
.Cs
int SemanticParamVarCk(struct MYTOK val)
.Ce
.IP Args: 4
.RS
.IP val 8
The parameter variable to check.
.RE
.LP
This semantically checks a particular parameter that appears in a function call.
If the parameter value matches with its prototype type, then that type is
returned. Predefined functions (type: YES_INT) and user-defined functions
appearing (type: YES) as a parameter are considered the same.
.Fn SemanticParamConstsCk
.Cs
int SemanticParamConstsCk(struct MYTOK val)
.Ce
.IP Args: 4
.RS
.IP val 8
The parameter variable to check.
.RE
.LP
This semantically checks a particular parameter that appears in a function call.
If the parameter constant type matches with its prototype type, then that type
is returned.
.Fn SemanticCaseInVarCk
.Cs
void SemanticCaseInVarCk(struct MYTOK var)
.Ce
.IP Args: 4
.RS
.IP var 8
The parameter variable to check.
.RE
.LP
This semantically checks the type of the var appearing in a "case in var"
switch body. Var must have one of the following types: Range Int,
Range Float, Range Dayofweek, Range DateTime, Range Size, Set Server, Set Que,
Set Job, Set CNode.
.Fn SemanticCaseTypeCk
.Cs
void SemanticCaseTypeCk(struct MYTOK val)
.Ce
.IP Args: 4
.RS
.IP val 8
The case value to check.
.RE
.LP
This semantically checks the type of the case value (label) against the
switch variable. Given "switch(var) { case val: ... }", the var type must be the
same as the val type.
.Fn SemanticCaseInTypeCk
.Cs
void SemanticCaseInTypeCk(struct MYTOK val)
.Ce
.IP Args: 4
.RS
.IP val 8
The case value to check.
.RE
.LP
This semantically checks the type of the "case in" value (label) against the
switch variable. Given "switch(var) { case in val: ... }", val can be
one of {Set Server, Set Que, Set Job, Set CNode, Range Int, Range Float,
Range Dayofweek, Range DateTime, Range Size} and must match 1:1 with one of
the following switch variable's types: {Server, Que, Job, CNode, Int, Float,
Dayofweek, DateTime, Size}.
.Fn SemanticTimeConstCk
.Cs
void SemanticTimeConstCk(struct MYTOK h, struct MYTOK m, struct MYTOK s)
.Ce
.IP Args: 4
.RS
.IP h 8
The hour entity in a time constant string.
.IP m 8
The minute entity in a time constant string.
.IP s 8
The seconds entity in a time constant string.
.RE
.LP
Given a time constant string, (h:m:s), this function checks to make sure that
0 <= h <= 23, 0 <= m <= 59, 0 <= s <= 61.
.Fn SemanticDateConstCk
.Cs
void SemanticDateConstCk(struct MYTOK m, struct MYTOK d, struct MYTOK y)
.Ce
.IP Args: 4
.RS
.IP m 8
The month entity in a date constant string.
.IP d 8
The day entity in a date constant string.
.IP y 8
The year entity in a date constant string.
.RE
.LP
Given a date constant string, (m|d|y), this function checks to make sure that
1 <= m <= 12, 1 <= d <= 31, 0 <= y.
.Fn SemanticIntConstRangeCk
.Cs
void SemanticIntConstRangeCk(struct MYTOK lo, struct MYTOK hi)
.Ce
.IP Args: 4
.RS
.IP lo 8
The low value (left) in a Range Int constant.
.IP hi 8
The high value (right) in a Range Int const.
.RE
.LP
Given a Range Int constant, (low, high), this function checks to make sure that
low <= high.
.Fn SemanticFloatConstRangeCk
.Cs
void SemanticFloatConstRangeCk(struct MYTOK lo, struct MYTOK hi)
.Ce
.IP Args: 4
.RS
.IP lo 8
The low value (left) in a Range Float constant.
.IP hi 8
The high value (right) in a Range Float const.
.RE
.LP
Given a Range Float constant, (low, high), this function checks to make sure
that low <= high.
.Fn SemanticDayofweekConstRangeCk
.Cs
void SemanticDayofweekConstRangeCk(struct MYTOK lo, struct MYTOK hi)
.Ce
.IP Args: 4
.RS
.IP lo 8
The low value (left) in a Range Dayofweek constant.
.IP hi 8
The high value (right) in a Range Dayofweek constant.
.RE
.LP
Given a Range Dayofweek constant, (low, high), this function checks to make sure
that low <= high.
.Fn SemanticDateTimeConstRangeCk
.Cs
void SemanticDateTimeConstRangeCk(struct MYTOK lo, struct MYTOK hi)
.Ce
.IP Args: 4
.RS
.IP lo 8
The low value (left) in a Range DateTime constant.
.IP hi 8
The high value (right) in a Range DateTime constant.
.RE
.LP
Given a Range DateTime constant, (low, high), this function checks to make sure
that low <= high if at least one of the values contain a date portion. If both
low and high contain time portions only, then they will go through a different
algorithm in some other function such as automatically filling in the missing
time or date portions.
.Fn SemanticSizeConstRangeCk
.Cs
void SemanticSizeConstRangeCk(struct MYTOK lo, struct MYTOK hi)
.Ce
.IP Args: 4
.RS
.IP lo 8
The low value (left) in a Range Size constant.
.IP hi 8
The high value (right) in a Range Size constant.
.RE
.LP
Given a Range Size constant, (low, high), this function checks to make sure
that low <= high.
.LP
.NH 4
.Tc Code Generator
.LP
The files involved with the code generator subsystem are CodeGen.h, and
CodeGen.c. The code generator is responsible for translating BASL statements 
into C statements. The code generator maintains 2 data structures, a stack (St)
and a list (CodeGenBuff) containing the various translated C tokens. The
stack is used to properly evaluate postfix arithmetic and logical expressions,
and the CodeGenBuff holds the resulting C statements.
.LP
.NH 5
.Fi CodeGen.c
.Fn CodeGenStackNew
.Cs
St CodeGenStackNew(Np np)
.Ce
.IP Args: 4
.RS
.IP np 8
The node to be placed as the first element of the stack. 
.RE
.LP
Initializes a Stack data type (St) used by the code generator, giving it a
node 'np' value. The top of the new stack is returned.
.Fn CodeGenStackPush
.Cs
void CodeGenStackPush(Np np)
.Ce
.IP Args: 4
.RS
.IP np 8
A Node pointer to put into the stack.
.RE
.LP
Adds a new element to the stack St and this element contains 'np'.
.Fn CodeGenStackPop
.Cs
void CodeGenStackPop(void)
.Ce
.LP
This returns the element that is at the top of the stack, and removes that
element of the stack. The stack element's malloc-ed storage is freed; the node
that it contains is not freed since it maybe part of another list that contains
the free routine.
.Fn CodeGenStackClear
.Cs
void CodeGenStackClear(void)
.Ce
.LP
This removes all the elements from the stack.
.Fn CodeGenStackPrint
.Cs
void CodeGenStackPrint(void)
.Ce
.LP
This prints all the elements on the stack.
.Fn CodeGenInit
.Cs
void CodeGenInit(void)
.Ce
.LP
This initializes all internal variables accessed by the code generator.
.Fn CodeGenPutDF
.Cs
void CodeGenPutDF(int df)
.Ce
.IP Args: 4
.RS
.IP df 8
The new debug flag.
.RE
.LP
Set the code generator debug flag to 'df'.
.Fn CodeGenCondPrint
.Cs
void CodeGenCondPrint(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The new string to print out.
.RE
.LP
Prints out the message 'str' to the code generator stdout stream (if any) 
if the code generator debug flag is on.
.Fn CodeGenPrint
.Cs
void CodeGenPrint(void)
.Ce
.LP
Prints some information about the code generator like the descriptors to
the generator buffer.
.Fn CodeGenErr
.Cs
void CodeGenErr(int e)
.Ce
.IP Args: 4
.RS
.IP e 8
An error number.
.RE
.LP
Prints the message associated with error 'e'.
.Fn CodeGenBuffClear
.Cs
void CodeGenBuffClear(void)
.Ce
.LP
Removes all the elements in CodeGenBuff.
.Fn CodeGenBuffPrint
.Cs
void CodeGenBuffPrint(void)
.Ce
.LP
Prints out the contents of the CodeGenBuff list.
.Fn CodeGenBuffEmit
.Cs
void CodeGenBuffEmit(void)
.Ce
.LP
Prints out the lexemes in CodeGenBuff into the C output file stream.
Necessary amount of indentation is added for blocks of statements.
After printing the lexemes, the CodeGenBuff is flushed (cleared).
.Fn CodeGenBuffSwitchEmit
.Cs
void CodeGenBuffSwitchEmit(void)
.Ce
.LP
Same as CodeGenBuffEmit() except the amount of indentations in the output is
1 less.
.Fn CodeGenLastDef
.Cs
void CodeGenLastDef(char *lexeme)
.Ce
.IP Args: 4
.RS
.IP lexeme 8
The lexeme to match.
.RE
.LP
Returns the last instance (maximum lineDef value) of 'lexeme' on the CodeGenBuff
table. Lexemes that contain "(" or ")" are matched with any lexemes containing
"(" or ")" no matter what the leading or trailing characters are. For example,
if the lexeme is "str(", then all entries in the CodeGenBuff that contain
the left and right parenthesis will match. 
.Fn CodeGenBuffGetNp
.Cs
void CodeGenBuffGetNp(char *lexeme, int lineDef)
.Ce
.IP Args: 4
.RS
.IP lexeme 8
The lexeme to match.
.IP lineDef 8
The lineDef value to match.
.RE
.LP
Returns the pointer to the node containing 'lexeme' with 'lineDef'.
.Fn matchPairs
.Cs
static void matchPairs(char *leftsym, int rightsym)
.Ce
.IP Args: 4
.RS
.IP leftsym 8
The left pair symbol.
.IP lineDef 8
The right pair symbol.
.RE
.LP
Go through the elements of CodeGenBuff, and match 'leftsym' with 'rightsym'.
For 'leftsym' that matches, push the corresponding node onto the code generator
stack (St); for 'rightsym' that matches, remove node that is at the top of
the stack (presumably this is the match), and update the rightsym's lineDef
value in the CodeGenBuff buffer to that of the matching 'leftsym'. So matching
leftsym and rightsym will have the same unique lineDef value.
.Fn CodeGenBuffSaveFirst
.Cs
void CodeGenBuffSaveFirst(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to insert into CodeGenBuff. 
.RE
.LP
Inserts 'str' into CodeGenBuff making it the first entry. If 'str' contains
a '(' or a ')', then the CodeGenBuff entries are modified so that all matching
leftsym and rightsym have the same lineDef value.
.Fn CodeGenBuffSave
.Cs
void CodeGenBuffSave(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to insert into CodeGenBuff. 
.RE
.LP
Appends 'str' to CodeGenBuff making it the last entry. If 'str' contains
a '(' or a ')', then the CodeGenBuff entries are modified so that all matching
leftsym and rightsym have the same lineDef value.
.Fn CodeGenBuffSaveBefore
.Cs
void CodeGenBuffSaveBefore(char *str, char *lexeme, int inst)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to insert into CodeGenBuff.
.IP lexeme 8
The succeeding lexeme.
.IP inst 8
The lexeme's lineDef value.
.RE
.LP
Insert 'str' before the node containing 'lexeme' with 'inst' lineDef value in
CodeGenBuff. If 'str' contains a '(' or a ')', then the CodeGenBuff entries are
modified so that all matching leftsym and rightsym have the same lineDef value.
.Fn CodeGenBuffSaveAfter
.Cs
void CodeGenBuffSaveAfter(char *str, char *lexeme, int inst)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to insert into CodeGenBuff.
.IP lexeme 8
The preceding lexeme.
.IP inst 8
The lexeme's lineDef value.
.RE
.LP
Insert 'str' after the node containing 'lexeme' with 'inst' lineDef value in
CodeGenBuff. If 'str' contains a '(' or a ')', then the CodeGenBuff entries are
modified so that all matching leftsym and rightsym have the same lineDef value.
.Fn CodeGenBuffDelete
.Cs
void CodeGenBuffDelete(char *lexeme, int inst)
.Ce
.IP Args: 4
.RS
.IP lexeme 8
A lexeme value.
.IP inst 8
The lexeme's lineDef value.
.RE
.LP
Deletes the node in CodeGenBuff containing 'lexeme' with 'inst' lineDef value.
.Fn CodeGenBuffSaveFunFirst
.Cs
void CodeGenBuffSaveFunFirst(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to insert into CodeGenBuff. 
.RE
.LP
Same as CodeGenBuffSaveFirst() except the node containing 'str' will have a
function flag indicator on it.
.Fn CodeGenBuffSaveFun
.Cs
void CodeGenBuffSaveFun(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to insert into CodeGenBuff. 
.RE
.LP
Same as CodeGenBuffSave() except the node containing 'str' will have a
function flag indicator on it.
.Fn CodeGenBuffSaveFunBefore
.Cs
void CodeGenBuffSaveFunBefore(char *str, char *lexeme, int inst)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to insert into CodeGenBuff.
.IP lexeme 8
The succeeding lexeme.
.IP inst 8
The lexeme's lineDef value.
.RE
.LP
Same as CodeGenBuffSaveBefore() except the node containing 'str' will have a
function flag indicator on it.
.Fn CodeGenBuffSaveFunAfter
.Cs
void CodeGenBuffSaveFunAfter(char *str, char *lexeme, int inst)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to insert into CodeGenBuff.
.IP lexeme 8
The preceeding lexeme.
.IP inst 8
The lexeme's lineDef value.
.RE
.LP
Same as CodeGenBuffSaveAfter() except the node containing 'str' will have a
function flag indicator on it.
.Fn CodeGenStatPrint
.Cs
void CodeGenStatPrint(void)
.Ce
.LP
Adds a "printf" to CodeGenBuff.
.Fn CodeGenStatPrintTail
.Cs
void CodeGenStatPrintTail(struct MYTOK expr)
.Ce
.IP Args: 4
.RS
.IP expr 8
Some expression entity.
.RE
.LP
Generates the code for 'print(expr)' BASL statement in CodeGenBuff. The
corresponding "printf()" statement will be generated based on the data type
of 'expr'.
.Fn CodeGenBuffGetLast
.Cs
Np CodeGenBuffGetLast(void)
.Ce
.LP
Return the last node in CodeGenBuff.
.Fn CodeGenBuffSaveSpecOper
.Cs
void CodeGenBuffSaveSpecOper(operstr)
.Ce
.IP Args: 4
.RS
.IP operstr 8
An special operator string: could be sizeAdd(, sizeMult(, sizeMinus(, sizeDiv(. 
.RE
.LP
This checks to make sure ++, and -- operators are preceded by an identifier
expression. Also, this routine makes sure that the special operator string is
placed in the right place in a heavily nested arithmetic expression.
.Fn CodeGenBuffSaveStrAssign
.Cs
void CodeGenBuffSaveStrAssign(void)
.Ce
.LP
Given a BASL assignment statement, var = expr, with var being of String type,
then generate the C statement "dynamic_strcpy(&var, expr);".   
.Fn CodeGenBuffSaveForeach
.Cs
void CodeGenBuffSaveForeach(struct MYTOK var, struct MYTOK svar)
.Ce
.IP Args: 4
.RS
.IP var 8
The 1st identifier in the foreach statement.
.IP svar 8
The 2nd identifier in the foreach statement.
.RE
.LP
Given a BASL assignment statement, foreach(var in svar) {}, the following
C translations occur:
.nf
 foreach(server in set_server) {}  -->
  for(server=set_server->head; server; server=server->nextptr) {}

 foreach(cnode in set_cnode) {}  -->
  for(cnode=set_cnode->head; cnode; cnode=cnode->nextptr) {}

 foreach(que in set_que) {}  -->
  for(que=set_que->head; que; que=que->nextptr) {}

 foreach(job in set_job) {}  -->
  for(firstJobPtr(&set_job, set_job->first); (job=set_job->job); nextJobPtr(&set_job)) {}

.fi
.Fn CodeGenBuffSaveSwitch
.Cs
void CodeGenBuffSaveSwitch(struct MYTOK switchVar)
.Ce
.IP Args: 4
.RS
.IP switchVar 8
The variable at the head of the switch statement.
.RE
.LP
Given a BASL assignment statement, switch(switchVar) { case caseVal: ...  },
BASL-to-C translations occur resulting in "if(switchVar == caseVal) {}" or
 "else if(switchVar == caseVal) {}" statements.
.Fn CodeGenBuffSaveSwitchIn
.Cs
void CodeGenBuffSaveSwitchIn(struct MYTOK switchVar, struct MYTOK caseVal)
.Ce
.IP Args: 4
.RS
.IP switchVar 8
The variable at the head of the switch statement.
.IP caseVal 8
A value appearing in a case label of a switch statement.
.RE
.LP
Given a BASL assignment statement, switch(switchVar) { case in caseVal: ...  },
BASL-to-C translations occur resulting in "if(inXRange(switchVar, caseVal)) {}"
or "else if(inXRange(switchVar, caseVal)) {}" statements.
.Fn CodeGenBuffSaveQueJobFind
.Cs
void CodeGenBuffSaveQueJobFind(void)
.Ce
.LP
.nf
The following translations occur:

  QueJobFind(que, arg2(), cpr, arg4) --> QueJobFindInt(que, arg2(), cpr, arg4)
                                     if arg2's type = arg4's type == Int
  QueJobFind(que, arg2(), cpr)       --> QueJobFindInt(que, arg2(), cpr)
                                     if arg2's type == Int

  QueJobFind(que, arg2(), cpr, arg4) --> QueJobFindStr(que, arg2(), cpr, arg4)
                                     if arg2's type = arg4's type == String 
  QueJobFind(que, arg2(), cpr)       --> QueJobFindStr(que, arg2(), cpr)
                                     if arg2's type == String

  QueJobFind(que, arg2(), cpr, arg4) --> QueJobFindSize(que, arg2(), cpr, arg4)
                                     if arg2's type = arg4's type == Size
  QueJobFind(que, arg2(), cpr)       --> QueJobFindSize(que, arg2(), cpr)
                                     if arg2's type == Size

  QueJobFind(que, arg2(), cpr, arg4)
                                 --> QueJobFindDateTime(que, arg2(), cpr, arg4)
                                 if arg2's type = arg4's type == DateTime
  QueJobFind(que, arg2(), cpr)   --> QueJobFindSize(que, arg2(), cpr)
                                 if arg2's type == DateTime

.fi
.Fn CodeGenBuffSaveQueFilter
.Cs
void CodeGenBuffSaveQueFilter(void)
.Ce
.LP
.nf
The following translations occur:

  QueFilter(que, arg2(), cpr, arg4) --> QueFilterInt(que, arg2(), cpr, arg4)
                                     if arg2's type = arg4's type == Int
  QueFilter(que, arg2(), cpr)       --> QueFilterInt(que, arg2(), cpr)
                                     if arg2's type == Int

  QueFilter(que, arg2(), cpr, arg4) --> QueFilterStr(que, arg2(), cpr, arg4)
                                     if arg2's type = arg4's type == String 
  QueFilter(que, arg2(), cpr)       --> QueFilterStr(que, arg2(), cpr)
                                     if arg2's type == String

  QueFilter(que, arg2(), cpr, arg4) --> QueFilterSize(que, arg2(), cpr, arg4)
                                     if arg2's type = arg4's type == Size
  QueFilter(que, arg2(), cpr)       --> QueFilterSize(que, arg2(), cpr)
                                     if arg2's type == Size

  QueFilter(que, arg2(), cpr, arg4)
                                 --> QueFilterDateTime(que, arg2(), cpr, arg4)
                                 if arg2's type = arg4's type == DateTime
  QueFilter(que, arg2(), cpr)   --> QueFilterSize(que, arg2(), cpr)
                                 if arg2's type == DateTime

.fi
.Fn CodeGenBuffSaveSort
.Cs
void CodeGenBuffSaveSort(void)
.Ce
.LP
.nf
The following translations occur:

  Sort(Set Job s, Int arg2(), Int arg3) --> SetJobSortInt(s, arg2(), arg3)
  Sort(Set Job s, String arg2(), Int arg3) --> SetJobSortStr(s, arg2(), arg3)
  Sort(Set Job s, Size arg2(), Int arg3) --> SetJobSortSize(s, arg2(), arg3)
  Sort(Set Job s, DateTime arg2(), Int arg3) --> SetJobSortDateTime(s, arg2(), arg3)
  Sort(Set Job s, Float arg2(), Int arg3) --> SetJobSortFloat(s, arg2(), arg3)

  Sort(Set CNode s, Int arg2(), Int arg3) --> SetCNodeSortInt(s, arg2(), arg3)
  Sort(Set CNode s, String arg2(), Int arg3) --> SetCNodeSortStr(s, arg2(), arg3)
  Sort(Set CNode s, Size arg2(), Int arg3) --> SetCNodeSortSize(s, arg2(), arg3)
  Sort(Set CNode s, DateTime arg2(), Int arg3) --> SetCNodeSortDateTime(s, arg2(), arg3)
  Sort(Set CNode s, Float arg2(), Int arg3) --> SetCNodeSortFloat(s, arg2(), arg3)

  Sort(Set Que s, Int arg2(), Int arg3) --> SetQueSortInt(s, arg2(), arg3)
  Sort(Set Que s, String arg2(), Int arg3) --> SetQueSortStr(s, arg2(), arg3)
  Sort(Set Que s, Size arg2(), Int arg3) --> SetQueSortSize(s, arg2(), arg3)
  Sort(Set Que s, DateTime arg2(), Int arg3) --> SetQueSortDateTime(s, arg2(), arg3)
  Sort(Set Que s, Float arg2(), Int arg3) --> SetQueSortFloat(s, arg2(), arg3)

  Sort(Set Server s, Int arg2(), Int arg3) --> SetServerSortInt(s, arg2(), arg3)
  Sort(Set Server s, String arg2(), Int arg3) --> SetServerSortStr(s, arg2(), arg3)
  Sort(Set Server s, Size arg2(), Int arg3) --> SetServerSortSize(s, arg2(), arg3)
  Sort(Set Server s, DateTime arg2(), Int arg3) --> SetServerSortDateTime(s, arg2(), arg3)
  Sort(Set Server s, Float arg2(), Int arg3) --> SetServerSortFloat(s, arg2(), arg3)
.fi
.NH 3
.Tc Pseudo-Compiler
.LP
The source code for the pseudo-compiler front end
.Ar basl2c
is Basl2c.c. The
compiler will take a program in BASL and translate it into intermediate
language (C code). The compiler will check the structure and semantic
correctness of the BASL program before generating the intermediate code.
.LP
.NH 4
.Fi Basl2c.c
.LP
.Fn loadUserAccessibleAssistFuncs
.Cs
static void loadUserAccessibleAssistFuncs(void)
.Ce
.LP
This is where predefined functions in BASL are loaded in order for the
scheduler writer to call them. This is the function to modify in case new
functions are added or when deleting functions from the list. 
.Fn addIncludes
.Cs
static void addIncludes(void)
.Ce
.LP
This function defines the "#include" lines to be placed at the header of the
resulting intermediate (C) code.
.Fn addMainSched
.Cs
static void addMainSched(void)
.Ce
.LP
Attaches some calls like SystemInit(), SystemStateRead() to the resulting
intermediate code in order for it to function as a daemon scheduler.
.Fn main
.Cs
main(int argc, char **argv)
.Ce
.LP
The sequence of execution are: (1) get command line arguments (see BASL
ERS for format of options), (2) initialize
internal variables used by the Lexer, Parser, Symbol table, Semantic analyzer,
and Code Generator, (3) generate the #include lines, (4) load the predefined
functions' prototypes, (5) start parsing the input file.
At the end of the parsing stage, then (6) delete the Symbol table, (7) close
any opened output stream.
.NH 3
.Tc Assist Functions
.LP
The assist (helper) functions are made available to create scheduling 
constructs Job, Que, CNode, Server, and ResMom. The functions can be found
under the
.Ar Assist
subdirectory.
.LP
.NH 4
.Tc General Purpose Functions
.LP
The source code found under the
.Ar Gen
subdirectory
contains general-purpose data structures and functions that are used by
the Lexer, Parser, Semantic analyzer, Code generator, and the predefined
functions. The files involved are af.h and af.c. The main data structures used are:
.nf
.Ty
struct time_struct {
   int h;
   int m;
   int s;
}
typedef struct time_struct Time;

struct date_struct {
   int m;
   int d;
   int y;
}
typedef struct date_struct Date;

struct datetime_struct {
   Time t;
   Date d;
}
typedef struct datetime_struct DateTime;

struct size_struct {
   long int num;       /* numeric part */
   unsigned int shift; /* K=10, M=20, G=30, T=40, P=50 */
   unsigned int units; /* BYTES=0, WORD=1 */
}
typedef struct size_struct Size;

struct intRange_struct {
    int lo;
    int hi;
}
typedef struct intRange_struct IntRange;

struct floatRange_struct {
     float lo;
     float hi;
}
typedef struct floatRange_struct FloatRange;

struct dayofweekRange_struct {
     float lo;
     float hi;
}
typedef struct dayofweekRange_struct DayofweekRange;

struct datetimeRange_struct {
     DateTime lo;
     DateTime hi;
}
typedef datetimeRange_struct DateTimeRange;

struct sizeRange_struct {
     Size  lo;
     Size  hi;
}
typedef sizeRange_struct SizeRange;

struct IntRes {
     struct IntRes *nextptr;
     char   *name;
     int    value;
}

struct SizeRes {
     struct SizeRes *nextptr;
     char   *name;
     Size   value;
}

struct StringRes {
     struct StringRes *nextptr;
     char   *name;
     char   *value;
}

struct dynamic_array {
     void   *ptr;    /* pointer to the dynamic array */
     int    numElems; /* # of elements in the array */
}

struct varstr_type {
     int   scope;    /* variable's scope */
     void  *pptr;    /* variable's parent ptr -
                        used to collectively free
                        up malloc-ed storage
                        linked to some main structure */
     void  *ptr;     /* ptr to malloc-ed storage of a */
                     /* variable string */
}
#define VARSTRLEN 500
static struct varstr_type *varstr[VARSTRLEN];

struct varstrIndex_type {
        struct varstr_type      *mptr;
        struct varstrIndex_type *link;
};

#define VARSTR_INDEX_LEN 480
static struct varstrIndex_type *varstrIndex[VARSTR_INDEX_LEN];

struct varstrSubIndex_type {
        struct varstrIndex_type         *ptr;
        struct varstrSubIndex_type      *link;
};

#define VARSTR_SUBINDEX_LEN 19
static struct varstrSubIndex_type *varstrSubIndex[VARSTR_SUBINDEX_LEN];

struct malloc_type {
     int   scope;    /* variable's scope */
     void  *pptr;    /* variable's parent ptr -
                        used to collectively free
                        up malloc-ed storage
                        linked to some main structure */
     void  *ptr;     /* ptr to malloc-ed storage */
}
#define MALLOCLEN 500
static struct malloc_type *mallocTable[MALLOCLEN];

struct mallocIndex_type {
        struct malloc_type      *mptr;
        struct mallocIndex_type *link;
};

#define MALLOC_INDEX_LEN 480
static struct mallocIndex_type *mallocIndexTable[MALLOC_INDEX_LEN];

struct mallocSubIndex_type {
        struct mallocIndex_type         *ptr;
        struct mallocSubIndex_type      *link;
};

#define MALLOC_SUBINDEX_LEN 19
static struct mallocSubIndex_type *mallocSubIndexTable[MALLOC_SUBINDEX_LEN];
.fi
.LP
.Ty dynamic_array
is a table of dynamically allocated arrays.
.Ty varstr
hash table that holds information about malloc-ed strings, hashed according to
ptr value.
.Ty varstrIndex
is a hash index table for the varstr table, hashed on the pptr attribute.
.Ty varstrSubIndex
is another hash index table for the varstr table, hashed on the scope attribute.
.Ty mallocTable
hash table that holds information about malloc-ed non-string objects, hashed
against the ptr value.
.Ty mallocIndexTable
another hash table for the mallocTable, this time, hashed against the pptr
attribute.
.Ty mallocSubIndexTable
another hash table for the mallocTable, this time, hashed against the scope
attribute.
.Ty "IntRes, SizeRes, StringRes"
hold various resource names and values that were obtained from a query of the
Server.
.NH 5
.Fi af.c
.LP
.Fn varstrHash
.Cs
static int varstrHash(unsigned long k)
.Ce
.IP Args: 4
.RS
.IP k 4
A hash key
.RE
.LP
Uses the multiplication method found in p. 228 of Cormen, Leiserson, Rivest
book, "Introduction to Algorithms", to come up with a hashing function.
.Fn varstrIndexHash
.Cs
static int varstrIndexHash(unsigned long k)
.Ce
.IP Args: 4
.RS
.IP k 4
A hash key
.RE
.LP
Uses the multiplication method found in p. 228 of Cormen, Leiserson, Rivest
book, "Introduction to Algorithms", to come up with a hashing function.
.Fn varstrSubIndexHash
.Cs
static int varstrSubIndexHash(unsigned long k)
.Ce
.IP Args: 4
.RS
.IP k 4
A hash key
.RE
.LP
Uses the multiplication method found in p. 228 of Cormen, Leiserson, Rivest
book, "Introduction to Algorithms", to come up with a hashing function.
.Fn mallocTableHash
.Cs
static int mallocTableHash(unsigned long k)
.Ce
.IP Args: 4
.RS
.IP k 4
A hash key
.RE
.LP
Uses the multiplication method found in p. 228 of Cormen, Leiserson, Rivest
book, "Introduction to Algorithms", to come up with a hashing function.
.Fn mallocIndexTableHash
.Cs
static int mallocIndexTableHash(unsigned long k)
.Ce
.IP Args: 4
.RS
.IP k 4
A hash key
.RE
.LP
Uses the multiplication method found in p. 228 of Cormen, Leiserson, Rivest
book, "Introduction to Algorithms", to come up with a hashing function.
.Fn mallocSubIndexTableHash
.Cs
static int mallocSubIndexTableHash(unsigned long k)
.Ce
.IP Args: 4
.RS
.IP k 4
A hash key
.RE
.LP
Uses the multiplication method found in p. 228 of Cormen, Leiserson, Rivest
book, "Introduction to Algorithms", to come up with a hashing function.
.Fn varstrSubIndexAdd
.Cs
void varstrSubIndexAdd(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to varstrIndex_type
.RE
.LP
Adds a new entry into the varstrSubIndex table, hashed according to the
ptr->mptr->scope value.
.Fn varstrSubIndexFree
.Cs
void varstrSubIndexFree(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to varstrIndex_type
.RE
.LP
Frees the varstrSubIndex table entry that carries a 'ptr' value.
.Fn varstrIndexAdd
.Cs
void varstrIndexAdd(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to varstr_type
.RE
.LP
Adds a new entry into the varstrIndex table, hashed according to the
ptr->pptr value.
.Fn varstrIndexFree
.Cs
void varstrIndexFree(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to varstr_type
.RE
.LP
Frees the varstrIndex table entry that carries a 'ptr' value. Also, frees up
any varstrSubIndex table entry that hangs off of this entry.
.Fn varstrIndexFreeNoIndex
.Cs
void varstrIndexFreeNoIndex(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to varstr_type
.RE
.LP
Like varstrIndexFree except only the varstrSubIndex table entry that hangs off
of this entry is freed.
.Fn varstrIndexFreeNoSubIndex
.Cs
void varstrIndexFreeNoSubIndex(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to varstr_type
.RE
.LP
Like varstrIndexFree except only the varstrIndex table entry that carries a
 'ptr' value is freed, not any varstrSubIndex entry that hangs off it.
.Fn varstrAdd
.Cs
void varstrAdd(void *ptr, int scope, void *pptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to malloc-ed string.
.IP scope 8
Scope value of ptr.
.IP pptr 8
Some parent pointer in which 'ptr' is somewhat related to.
.RE
.LP
Adds a new entry into the varstr table, hashed according to its 'ptr' value.
.Fn varstrRemove
.Cs
void varstrRemove(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to malloc-ed string.
.RE
.LP
Frees up the slot occupied by 'ptr' in the varstr table, as well as any
varstrIndex table entry that hangs off it.
.Fn varstrModScope
.Cs
void varstrModScope(void *ptr, int scope)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to malloc-ed string.
.IP scope 8
The ptr's new scope.
.RE
.LP
Modifies a ptr's scope in the varstr table to the given value. The
corresponding varstrSubIndex table entry is updated as well since that is
hashed according to scope value.
.Fn varstrModPptr
.Cs
void varstrModPptr(void *ptr, void *newpptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to malloc-ed string.
.IP newpptr 8
ptr's parent pointer.
.RE
.LP
Modifies a ptr's pptr value in the varstr table to the given value.  The
corresponding varstrIndex table entry is updated as well since that is
hashed according to parent ptr value.
.Fn inVarstr
.Cs
int inVarstr(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to malloc-ed string.
.RE
.LP
Returns 1 if 'ptr' is in the varstr table; 0 otherwise.
.Fn varstrPrint
.Cs
void varstrPrint(void)
.Ce
.LP
Prints out the elements of the varstr table.
.Fn varstrFree
.Cs
void varstrFree(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to malloc-ed string.
.RE
.LP
Issues a free() to the malloc-ed storage allocate to 'ptr', and clearing
any varstrIndex, varstrSubIndex table entries associated with it.
.Fn varstrFreeNoIndex
.Cs
void varstrFreeNoIndex(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to malloc-ed string.
.RE
.LP
Issues a free() to the varstr entry that carries 'ptr', but do not free
any varstrIndex table entry associated with it.
.Fn varstrFreeNoSubIndex
.Cs
void varstrFreeNoSubIndex(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to malloc-ed string.
.RE
.LP
Issues a free() to the varstr entry that carries 'ptr', but do not free
any varstrSubIndex table entry associated with it.
.Fn varstrPrint
.Cs
void varstrPrint(void)
.Ce
.LP
Prints out the elements of the varstr, varstrIndex, and varstrSubIndex tables.
.Fn varstr2Free
.Cs
void varstr2Free(void *ptr, void *ptr2)
.Ce
.IP Args: 4
.RS
.IP ptr 8
Pointer to malloc-ed string.
.IP ptr2 8
Pointer to another malloc-ed string.
.RE
.LP
An optimization attempt that allows 2 pointers to be freed all at once.
.Fn varstrFreeByScope
.Cs
void varstrFreeByScope(int scope)
.Ce
.IP Args: 4
.RS
.IP scope 8
The scope of string(s) to free up.
.RE
.LP
Frees up all malloc-ed strings whose scope value is as given. 
.Fn varstrFreeByPptr
.Cs
void varstrFreeByPptr(void *pptr)
.Ce
.IP Args: 4
.RS
.IP pptr 8
The parent pointer of the string(s) to free up.
.RE
.LP
Frees up all malloc-ed strings whose pptr value is as given.
.Fn varstrInit
.Cs
void varstrInit(void)
.Ce
.LP
initializes the hash tables: varstr, varstrIndex, varstrSubIndex.
.Fn dynamic_strcpy
.Cs
void dynamic_strcpy(char **str1_ptr, const char *str2)
.Ce
.IP Args: 4
.RS
.IP str1_ptr 8
Pointer to the string to copy a new value into.
.IP str2 8
New value of the string.
.RE
.LP
Copies value of 'str2' to the string pointed to by str1_ptr. If the latter is
NULL, then a new string is malloc-ed; otherwise, it will be realloc-ed. The
newly alloc-ed or realloc-ed storage is recorded in the varstr table. On
realloc, any previous alloc-ed storage recorded in the varstr table is removed.
The varstr scope of the string is automatically global (0).
.Fn dynamic_strcat
.Cs
void dynamic_strcat(char **str1_ptr, const char *str2)
.Ce
.IP Args: 4
.RS
.IP str1_ptr 8
Pointer to the string to copy a new value into.
.IP str2 8
value of a string to append.
.RE
.LP
Appends value of 'str2' to the string pointed to by str1_ptr. If the latter is
NULL, then a new string is malloc-ed; otherwise, it will be realloc-ed. The
newly alloc-ed or realloc-ed storage is recorded in the varstr table. On
realloc, any previous alloc-ed storage recorded in the varstr table is removed.
The varstr scope of the string is automatically global (0).
.Fn strToInt
.Cs
int strToInt(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
String to convert.
.RE
.LP
Converts a 'str' into an int value using the strtol() call. The int value is
returned.
.Fn strToFloat
.Cs
Float strToFloat(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
String to convert.
.RE
.LP
Converts a 'str' into a float value using the strtod() call. The float value is
returned.
.Fn strToDayofweek
.Cs
Dayofweek strToDayofweek(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
String to convert.
.RE
.LP
Converts a 'str' into a Dayofweek value, mapping "SUN"->SUN, "MON"->MON, etc... 
The resulting value is returned.
.Fn strToDate
.Cs
Date strToDate(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
String to convert.
.RE
.LP
Converts a 'str' of the form: (m|d|y@h:m:s), or (m|d|y) into a Date value.
{0, 0, 0} will be returned if error was encountered during conversion.
.Fn strToTime
.Cs
Time strToTime(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
String to convert.
.RE
.LP
Converts a 'str' of the form: (m|d|y@h:m:s), or (h:m:s) into a Time value.
{-1, -1, -1} will be returned if error was encountered during conversion.
.Fn strToDateTime
.Cs
DateTime strToDateTime(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
String to convert.
.RE
.LP
Converts a 'str' of the form: (m|d|y@h:m:s), (h:m:s), or (m|d|y) into a
DateTime value.
{-1, -1, -1, 0, 0, 0} will be returned if error was encountered during
conversion.
.Fn strToSize
.Cs
Size strToSize(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
String to convert.
.RE
.LP
Converts a 'str' of the form: "<numeric><suffix>" where <suffix> is:
[k|K|m|M|g|G|t|T|p|P] [b|w] into the corresponding Size struct. If an error
occurred during conversion such as BADVAL or BADSUFFIX, then {-1, 0, BYTES}
Size struct is returned.
NOTE: The algorithm used in the conversion is the same as the routines found in
the server.
.Fn strsecsToDateTime
.Cs
DateTime strsecsToDateTime(char *str)
.Ce
.IP Args: 4
.RS
.IP val 8
String to convert.
.RE
.LP
Converts a 'str', containing some # of seconds since epoch, into a
DateTime value.
{-1, -1, -1, 0, 0, 0} will be returned if error was encountered during
conversion.
.Fn strToBool
.Cs
Size strToBool(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
String to convert.
.RE
.LP
Converts a 'str', of the form: "True" or "False", to the int TRUE or FALSE.
.Fn strToSize
.Cs
Size strToSize(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
String to convert.
.RE
.LP
Converts a 'str' of the form: "<numeric><suffix>" where <suffix> is:
[k|K|m|M|g|G|t|T|p|P] [b|w] into the corresponding Size struct. If an error
occurred during conversion such as BADVAL or BADSUFFIX, then {-1, 0, BYTES}
Size struct is returned.
NOTE: The algorithm used in the conversion is the same as the routines found in
.Fn sizeToStr
.Cs
void sizeToStr(Size sizeval, char *cvnbuf)
.Ce
.IP Args: 4
.RS
.IP sizeval 8
The Size value to convert.
.IP cvnbuf 8
The converted String.
.RE
.LP
Converts a 'sizeval' into a string, placing the result in 'cvnbuf'.
.Fn strtimeToSecs
.Cs
int strtimeToSecs(times)
.Ce
.IP Args: 4
.RS
.IP times 8
A time string of the form (hh:mm:ss[.ms]).
.RE
.LP
This returns the equivalent # of seconds for a given 'times' string. 'ms' can
potentially be lost. If conversion fails, this will return a -1.
.Fn datecmp
.Cs
int datecmp(Date d1, Date d2)
.Ce
.IP Args: 4
.RS
.IP d1 8
1st Date value to compare.
.IP d2 8
2nd Date value to compare.
.RE
.LP
Returns: < 0 if d1 is < d2; = 0 if d1 = d2; > 0 if d1 >= d2.
.Fn timecmp
.Cs
int timecmp(Time t1, Time t2)
.Ce
.IP Args: 4
.RS
.IP t1 8
1st Time value to compare.
.IP t2 8
2nd Time value to compare.
.RE
.LP
Returns: < 0 if t1 is < t2; = 0 if t1 = t2; > 0 if t1 >= t2.
.Fn datetimecmp
.Cs
int datetimecmp(DateTime dt1, DateTime dt2)
.Ce
.IP Args: 4
.RS
.IP dt1 8
1st DateTime value to compare.
.IP dt2 8
2nd DateTime value to compare.
.RE
.LP
Returns: < 0 if dt1 is < dt2; = 0 if dt1 = dt2; > 0 if dt1 >= dt2.
.Fn datetimeToSecs
.Cs
int datetimeToSecs(DateTime dt)
.Ce
.IP Args: 4
.RS
.IP dt 8
DateTime value to convert.
.RE
.LP
Converts a DateTime structure into the # of seconds since epoch
(1|1|1970@0:0:0). The NOW time or date is substituted for missing time or
date portions.
.Fn normalizeSize
.Cs
int normalizeSize(Size *a, Size *b, Size *ta, Size *tb)
.Ce
.IP Args: 4
.RS
.IP a 8
1st size value to normalize.
.IP b 8
2nd size value to normalize.
.IP ta 8
Where the normalize value to 'a' is placed.
.IP tb 8
Where the normalize value to 'b' is placed.
.RE
.LP
Normalize 2 size value, a and b, adjusting them so that the shift counts are
the same. The new values are placed in ta and tb, respectively. The shift that
is "lower" of the 2 becomes the common denominator. 
Returns 0 if successful; -1 otherwise.
.Fn sizecmp
.Cs
int sizecmp(Size a, Size w)
.Ce
.IP Args: 4
.RS
.IP a 8
1st size value to compare.
.IP w 8
2nd size value to compare.
.RE
.LP
Compares 2 Size structures, a and w, and returns +1 if a > w, 0 if a == w,
-1 if a < w.
.Fn hashptr
.Cs
static long int hashptr(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
A pointer whose hash index to d_array will be obtained.
.RE
.LP
Returns a possible hash index for 'ptr'. Formula: ptr % MAXDARRAY.
.Fn getHashValue
.Cs
static int getHashValue(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
A pointer whose hash actual value to d_array will be obtained.
.RE
.LP
Returns the hash value for 'ptr', with hash collisions automatically resolved.
.Fn getHashValueToStore
.Cs
static int getHashValueToStore(void *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
A pointer that will be stored in system array d_array.
.RE
.LP
Returns the hash value where 'ptr' could be stored in d_array. 
.Fn dynamicArraySize
.Cs
static int dynamicArraySize(void *array)
.Ce
.IP Args: 4
.RS
.IP array 8
A dynamic array.
.RE
.LP
Returns # of elements in 'array'.
.Fn initDynamicArray
.Cs
void *initDynamicArray(size_t numElems, size_t elementSize)
.Ce
.IP Args: 4
.RS
.IP numElems 8
# of elements in the array to be created.
.IP elementSize 8
The size of each element in the array to be created.
.RE
.LP
Used calloc to create an array containing 'numElems' with each element of
size 'elementSize'. A pointer to the newly-created array is returned, and
also recorded in the 'd_array' table.
.Fn extendDynamicArray
.Cs
void *extendDynamicArray(void *array, size_t minNumElems, size_t elementSize)
.Ce
.IP Args: 4
.RS
.IP array 8
A dynamic array to expand.
.IP minNumElems 8
# of elements in the array to be created.
.IP elementSize 8
The size of each element in the array to be created.
.RE
.LP
Expands the 'array' so that the minNumElems can at least fit. If 'array' is
NULL, then initDynamicArray(minNumElems, elementSize) will be called. 
Information about the newly realloc-ed 'array' is recorded in the 'd_array'
table (removing the previous old pointer), and the pointer to this newly-
realloc-ed storage is also returned.
.Fn freeDynamicArray
.Cs
void freeDynamicArray(void *array)
.Ce
.IP Args: 4
.RS
.IP array 8
A dynamic array to free up.
.RE
.LP
Free up the malloc-ed storage allocated to 'array', and remove its entry from
the 'd_array' table.
.Fn printDynamicArrayTable
.Cs
void printDynamicArrayTable(void)
.Ce
.LP
Prints out the contents of the 'd_array' table. 
.Fn datePrint
.Cs
void datePrint(Date d)
.Ce
.IP Args: 4
.RS
.IP d 8
The Date structure to print out.
.RE
.LP
Print out 'd' in a human readable format.
.Fn timePrint
.Cs
void timePrint(Time t)
.Ce
.IP Args: 4
.RS
.IP t 8
The Time structure to print out.
.RE
.LP
Print out 't' in human readable format.
.Fn datetimePrint
.Cs
void timePrint(DateTime dt)
.Ce
.IP Args: 4
.RS
.IP dt 8
The DateTime structure to print out.
.RE
.LP
Print out 'dt' in human readable format.
.Fn sizePrint
.Cs
void sizePrint(Size s, int readable)
.Ce
.IP Args: 4
.RS
.IP s 11
The Size structure to print out.
.IP readable 11
The format of output flag. 
.RE
.LP
Print out 's' in human readable format if 'readable' flag is set to 1;
otherwise, just print out the elements of the structure.
.Fn intRangePrint
.Cs
void intRangePrint(IntRange r)
.Ce
.IP Args: 4
.RS
.IP r 8
The IntRange structure to print out.
.RE
.LP
Print out 'r' in human readable format.
.Fn floatRangePrint
.Cs
void floatRangePrint(FloatRange r)
.Ce
.IP Args: 4
.RS
.IP r 8
The FloatRange structure to print out.
.RE
.LP
Print out 'r' in human readable format.
.Fn dayofweekPrint
.Cs
void dayofweekPrint(Dayofweek dow)
.Ce
.IP Args: 4
.RS
.IP dow 8
The Dayofweek structure to print out.
.RE
.LP
Print out 'dow' in human readable format.
.Fn dayofweekRangePrint
.Cs
void dayofweekRangePrint(DayofweekRange r)
.Ce
.IP Args: 4
.RS
.IP r 8
The DayofweekRange structure to print out.
.RE
.LP
Print out 'r' in human readable format.
.Fn dateRangePrint
.Cs
void dateRangePrint(DateRange d)
.Ce
.IP Args: 4
.RS
.IP d 8
The DateRange structure to print out.
.RE
.LP
Print out 'd' in human readable format.
.Fn timeRangePrint
.Cs
void timeRangePrint(TimeRange t)
.Ce
.IP Args: 4
.RS
.IP t 8
The TimeRange structure to print out.
.RE
.LP
Print out 't' in human readable format.
.Fn datetimeRangePrint
.Cs
void timeRangePrint(DateTimeRange dt)
.Ce
.IP Args: 4
.RS
.IP dt 8
The DateTimeRange structure to print out.
.RE
.LP
Print out 'dt' in human readable format.
.Fn sizeRangePrint
.Cs
void sizeRangePrint(SizeRange s, int readable)
.Ce
.IP Args: 4
.RS
.IP s 11
The SizeRange structure to print out.
.IP readable 11
The format of output flag.
.RE
.LP
Print out 's' in human readable format if 'readable' flag is set to 1;
otherwise, just print out the elements of the Size structure.
.Fn strToIntRange
.Cs
IntRange strToIntRange(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to convert: "(low Int, high Int)" 
.RE
.LP
Converts 'str' into an IntRange structure, returning the latter.
.Fn strToFloatRange
.Cs
FloatRange strToFloatRange(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to convert: "(low Float, high Float)" 
.RE
.LP
Converts 'str' into a FloatRange structure, returning the latter.
.Fn strToDayofweekRange
.Cs
DayofweekRange strToDayofweekRange(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to convert: "(low dow, high dow)" 
.RE
.LP
Converts 'str' into a DayofweekRange structure, returning the latter.
.Fn strToDateRange
.Cs
DateRange strToDateRange(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to convert: "(low date, high date)" 
.RE
.LP
Converts 'str' into a DateRange structure, returning the latter.
.Fn strToTimeRange
.Cs
DateRange strToTimeRange(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to convert: "(low time, high time)" 
.RE
.LP
Converts 'str' into a TimeRange structure, returning the latter.
.Fn strToDateTimeRange
.Cs
DateRange strToDateTimeRange(char *str)
.Ce
.IP Args: 4
.RS
.IP str 8
The string to convert: "(low datetime, high datetime)" 
.RE
.LP
Converts 'str' into a DateTimeRange structure, returning the latter.
.Fn sizeRangecmp
.Cs
int sizeRangecmp(SizeRange r1, SizeRange r2)
.Ce
.IP Args: 4
.RS
.IP r1 8
1st SizeRange structure to compare.
.IP r2 8
2nd SizeRange structure to compare.
.RE
.LP
Compares 2 size ranges, r1 and r2, and returns 0 if they're the same; 1,
otherwise.
.Fn sizeStrcmp
.Cs
int sizeStrcmp(char *a, char *w)
.Ce
.IP Args: 4
.RS
.IP a 8
1st string to compare with format "<number><suffix>".
.IP w 8
2nd string to compare with format "<number><suffix>".
.RE
.LP
Compares 2 size-formatted strings, a and w, and returns +1 if a > w, 0 if
a == w, and -1 if a < w.
.Fn sizeRangeStrcmp
.Cs
int sizeRangeStrcmp(char *a, char *w)
.Ce
.IP Args: 4
.RS
.IP a 8
1st string to compare with format "(<number><suffix>, <number><suffix>)".
.IP w 8
2nd string to compare with format "(<number><suffix>, <number><suffix>)".
.RE
.LP
Compares 2 sizeRange-formatted strings, a and w, and returns +1 if a > w, 0 if
a == w, and -1 if a < w.
.Fn toIntRange
.Cs
IntRange toIntRange(int i1, int i2)
.Ce
.IP Args: 4
.RS
.IP i1 8
1st number in the range.
.IP i2 8
2nd number in the range.
.RE
.LP
Converts the 2 given numbers into an IntRange structure.
.Fn toFloatRange
.Cs
FloatRange toFloatRange(double f1, double f2)
.Ce
.IP Args: 4
.RS
.IP f1 8
1st number in the range.
.IP f2 8
2nd number in the range.
.RE
.LP
Converts the 2 given numbers into a FloatRange structure.
.Fn toDayofweekRange
.Cs
DayofweekRange toDayofweekRange(Dayofweek dow1, Dayofweek dow2)
.Ce
.IP Args: 4
.RS
.IP dow1 8
1st entity in the range.
.IP dow2 8
2nd entity in the range.
.RE
.LP
Converts the 2 given entities into a DayofweekRange structure.
.Fn toDateRange
.Cs
DateRange toDateRange(Date d1, Date d2)
.Ce
.IP Args: 4
.RS
.IP d1 8
1st entity in the range.
.IP d2 8
2nd entity in the range.
.RE
.LP
Converts the 2 given entities into a DateRange structure.
.Fn toTimeRange
.Cs
TimeRange toTimeRange(Time t1, Time t2)
.Ce
.IP Args: 4
.RS
.IP t1 8
1st entity in the range.
.IP t2 8
2nd entity in the range.
.RE
.LP
Converts the 2 given entities into a TimeRange structure.
.Fn toDateTimeRange
.Cs
DateTimeRange toDateTimeRange(DateTime dt1, DateTime dt2)
.Ce
.IP Args: 4
.RS
.IP dt1 8
1st entity in the range.
.IP dt2 8
2nd entity in the range.
.RE
.LP
Converts the 2 given entities into a DateTimeRange structure.
.Fn toSizeRange
.Cs
SizeRange toSizeRange(Size sz1, Size sz2)
.Ce
.IP Args: 4
.RS
.IP sz1 8
1st entity in the range.
.IP sz2 8
2nd entity in the range.
.RE
.LP
Converts the 2 given entities into a SizeRange structure.
.Fn sizeAdd
.Cs
Size sizeAdd(Size a, Size w)
.Ce
.IP Args: 4
.RS
.IP a 8
left operand.
.IP w 8
right operand.
.RE
.LP
Adds 2 Sizes together, returning the result. For values of different suffixes,
normalization will take place; the suffix in the final result is the suffix
that is the smaller of the two. If adding the two values would result in an
overflow during the normalization step, then -1b is returned.
.Fn sizeSub
.Cs
Size sizeSub(Size a, Size w)
.Ce
.IP Args: 4
.RS
.IP a 8
left operand.
.IP w 8
right operand.
.RE
.LP
Subtracts 2 Sizes together, returning the result. For values of different
suffixes,
normalization will take place; the suffix in the final result is the suffix
that is the smaller of the two. If adding the two values would result in an
overflow during the normalization step, then -1b is returned.
.Fn sizeMul
.Cs
Size sizeMul(Size a, Size w)
.Ce
.IP Args: 4
.RS
.IP a 8
left operand.
.IP w 8
right operand.
.RE
.LP
Multiplies 2 Sizes together, returning the result. For values of different
suffixes,
normalization will take place; the suffix in the final result is the suffix
that is the smaller of the two. If adding the two values would result in an
overflow during the normalization step, then -1b is returned.
.Fn sizeDiv
.Cs
Size sizeDiv(Size a, Size w)
.Ce
.IP Args: 4
.RS
.IP a 8
left operand.
.IP w 8
right operand.
.RE
.LP
Divides 2 Sizes together, returning the result. For values of different
suffixes,
normalization will take place; the suffix in the final result is the suffix
that is the smaller of the two. If adding the two values would result in an
overflow during the normalization step, then -1b is returned.
.Fn sizeUminus
.Cs
Size sizeUminus(Size sz)
.Ce
.IP Args: 4
.RS
.IP sz 8
A Size operand.
.RE
.LP
Multiplies the numeric part of 'sz' by -1, returning the result. 
.Fn strCat
.Cs
char *strCat(char *str1, char *str2)
.Ce
.IP Args: 4
.RS
.IP str1 8
left operand.
.IP str2 8
right operand.
.RE
.LP
Concatenates 2 malloc-ed strings into one string, returning the result. The
returned string is a pointer to a malloc-ed area whose scope in the varstr
table will be -1. So, calling a varstrFreeByScope(-1) will clean up the
temporary storage. 
.Fn mallocSubIndexTableAdd
.Cs
void mallocSubIndexTableAdd(struct mallocIndex_type *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
The pointer value to add.
.RE
.LP
Adds a new entry (content is as given) to the mallocSubIndexTable, hashed
against ptr->mptr->scope.
.Fn mallocSubIndexTableFree
.Cs
void mallocSubIndexTableFree(struct mallocIndex_type *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
associated ptr value
.RE
.LP
Free up the entry of mallocSubIndexTable whose ptr value is 'ptr'.
.Fn mallocIndexTableAdd
.Cs
void mallocIndexTableAdd(struct malloc_type *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
The pointer value to add.
.RE
.LP
Adds a new entry (content is as given) to the mallocIndexTable, hashed
against ptr->pptr.
.Fn mallocIndexTableFree
.Cs
void mallocIndexTableFree(struct malloc_type *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
associated ptr value
.RE
.LP
Free up the entry of mallocIndexTable whose associated ptr value is 'ptr', and
also frees up any mallocSubIndexTable entry that hangs off it.
.Fn mallocIndexTableFreeNoIndex
.Cs
void mallocIndexTableFreeNoIndex(struct malloc_type *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
associated ptr value
.RE
.LP
Like mallocIndexTableFree() except only the associated mallocSubIndexTable
entry value is freed.
.Fn mallocIndexTableFreeNoIndex
.Cs
void mallocIndexTableFreeNoSubIndex(struct malloc_type *ptr)
.Ce
.IP Args: 4
.RS
.IP ptr 8
associated ptr value
.RE
.LP
Like mallocIndexTableFree() except only the associated mallocIndexTable
entry value is freed, and not any mallocSubIndexTable entry associated with it.
.Fn mallocTableAdd
.Cs
void mallocTableAdd(void *ptr, void *pptr, int scope)
.Ce
.IP Args: 4
.RS
.IP ptr 8
The pointer value to add.
.IP pptr 8
The parent pointer to assign 'ptr'.
.IP scope 8
The scope value to assign 'ptr'.
.RE
.LP
Adds a new entry (content is as given) to the mallocTable, hashed against 'ptr'.
.Fn mallocTablePrint
.Cs
void mallocTablePrint(void)
.Ce
.LP
Prints out the contents of mallocTable, mallocIndexTable, mallocSubIndexTable
.Fn inMallocTable
.Cs
int inMallocTable(void *ptr)
.Ce
.LP
.IP Args: 4
.RS
.IP ptr 8
A pointer value to look for in the mallocTable.
.RE
.LP
Returns 1 if 'ptr' is one of the entries on the mallocTable; 0, otherwise.
.Fn mallocTableInit
.Cs
int mallocTableInit(void)
.Ce
.LP
Initializes the mallocTable, mallocIndexTable, mallocSubIndexTable entries.
.Fn mallocTableFree
.Cs
void mallocTableFree(void *ptr)
.Ce
.LP
.IP Args: 4
.RS
.IP ptr 8
A pointer value in the mallocTable to free up.
.RE
.LP
Free up the malloc-ed storage occupied by 'ptr', and also remove its entry
from the mallocTable. Also, frees up any associated mallocIndexTable and
mallocSubIndexTable entries.
.Fn mallocTableFreeNoIndex
.Cs
void mallocTableFreeNoIndex(void *ptr)
.Ce
.LP
.IP Args: 4
.RS
.IP ptr 8
A pointer value in the mallocTable to free up.
.RE
.LP
Like mallocTableFree except associated mallocIndexTable entry is not freed.
.Fn mallocTableFreeNoSubIndex
.Cs
void mallocTableFreeNoSubIndex(void *ptr)
.Ce
.LP
.IP Args: 4
.RS
.IP ptr 8
A pointer value in the mallocTable to free up.
.RE
.LP
Like mallocTableFree except associated mallocSubIndexTable entry is not freed.
.Fn mallocTableFreeNoSubIndex2
.Cs
void mallocTableFreeNoSubIndex2(void *ptr)
.Ce
.LP
.IP Args: 4
.RS
.IP ptr 8
A pointer value in the mallocTable to free up.
.RE
.LP
Like mallocTableFree except associated mallocSubIndexTable entry is not freed,
as well as the 'ptr' itself is not freed.
.Fn mallocTableFreeByPptr
.Cs
void mallocTableFreeByPptr(void *pptr)
.Ce
.LP
.IP Args: 4
.RS
.IP pptr 8
A parent pointer value in the mallocTable.
.RE
.LP
Free up pointers to storage associated with 'pptr' (parent pointer value of
 'pptr') and remove the corresponding slots from mallocTable. Also, any
mallocTableSubIndex entry is freed.
.Fn mallocTableFreeByScope
.Cs
void mallocTableFreeByScope(int scope, void (*freefunc)())
.Ce
.LP
.IP Args: 4
.RS
.IP scope 8
A scope value to look for in mallocTable.
.IP freefunc 8
The free function to use when freeing storage associated with 'scope'.
.RE
.LP
Free up pointers to storage associated with 'scope' value
and remove the corresonding slots from mallocTable.  Also, update the
associated mallocSubIndexTable entry.
.Fn mallocTableModScope
.Cs
void mallocTableModScope(void *ptr, int newscope)
.Ce
.LP
.IP Args: 4
.RS
.IP ptr 8
A pointer value to look for in mallocTable.
.IP newscope 8
The new scope for 'ptr'.
.RE
.LP
Modify 'ptr's scope value to 'newscope'. 
Appropriately update the mallocIndexTable() that hangs off of this.
.Fn mallocTableSafeModScope
.Cs
void mallocTableSafeModScope(void *ptr, int newscope)
.Ce
.LP
.IP Args: 4
.RS
.IP ptr 8
A pointer value to look for in mallocTable.
.IP newscope 8
The new scope for 'ptr'.
.RE
.LP
Modify ptr's scope value to 'newscope' IF the current scope value is != 0. 
Appropriately update the mallocSubIndexTable() that hangs off of this.
.Fn inIntRange
.Cs
int inIntRange(int i, IntRange range)
.Ce
.LP
.IP Args: 4
.RS
.IP i 8
An integer value.
.IP range 8
A range of numbers.
.RE
.LP
Returns 1 if i is in 'range'; 0 otherwise.
.Fn inFloatRange
.Cs
int inFloatRange(double f, FloatRange range)
.Ce
.LP
.IP Args: 4
.RS
.IP f 8
A float value.
.IP range 8
A range of numbers.
.RE
.LP
Returns 1 if f is in 'range'; 0 otherwise.
.Fn inDayofweekRange
.Cs
int inDayofweekRange(Dayofweek dow, DayofweekRange range)
.Ce
.LP
.IP Args: 4
.RS
.IP dow 8
A float value.
.IP range 8
A range of days of week.
.RE
.LP
Returns 1 if dow is in 'range'; 0 otherwise.
.Fn inDateRange
.Cs
int inDateRange(Date d, DateRange range)
.Ce
.LP
.IP Args: 4
.RS
.IP d 8
A Date value.
.IP range 8
A range of Dates.
.RE
.LP
Returns 1 if d is in 'range'; 0 otherwise.
.Fn inTimeRange
.Cs
int inTimeRange(Time t, TimeRange range)
.Ce
.LP
.IP Args: 4
.RS
.IP t 8
A Time value.
.IP range 8
A range of Times.
.RE
.LP
Returns 1 if t is in 'range'; 0 otherwise.
.Fn inDateTimeRange
.Cs
int inDateTimeRange(DateTime dt, DateTimeRange range)
.Ce
.LP
.IP Args: 4
.RS
.IP t 8
A DateTime value.
.IP range 8
A range of DateTimes.
.RE
Returns 1 if dt is in 'range'; 0 otherwise.
.br
NOTE: If date/times contain only time portions (i.e. hh:mm:ss) and low > hi,
then adjust hi by 1 day.
.Fn inSizeRange
.Cs
int inSizeRange(Size sz, SizeRange range)
.Ce
.LP
.IP Args: 4
.RS
.IP sz 8
A DateTime value.
.IP range 8
A range of DateTimes.
.RE
.LP
Returns 1 if 'sz' is in 'range'; 0 otherwise.
.Fn IntResCreate
.Cs
static struct IntRes *IntResCreate(void)
.Ce
.LP
Creates/mallocs a new IntRes structure, returning the pointer to it. 
.Fn IntResValueGet
.Cs
int IntResValueGet(struct IntRes *head, char *name)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of IntRes structures.  
.IP name 8
The resource name to look for in the list.
.RE
.LP
Return 'value', given the 'name' in the IntRes list. 
.Fn IntResListPrint
.Cs
void IntResListPrint(struct IntRes *head, char *descr)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of IntRes structures.  
.IP descr 8
Additional string description to print out.
.RE
.LP
Prints out the elements of IntRes list whose 1st element is 'head'. Print the
message 'descr' along with the list output.
.Fn IntResValuePut
.Cs
struct IntRes *IntResValuePut(struct IntRes *head, char *name, int value,
                                               void *pptr)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of IntRes structures.  
.IP name 8
The resource name.
.IP value 8
The new resource value.
.IP pptr 8
The parent pointer to associate malloc-ed storage on the IntRes list.
.RE
.LP
If a resource 'name' is matched in IntRes list, then the matching element
is updated so that its resource value is set to 'value'. If no such element
exists, then a new entry is malloc-ed/created. Information about malloc-ed
areas that were created as a result of this call will be recorded in the
mallocTable and varstr table, with parent pointer values set to 'pptr'.
.Fn IntResListFree
.Cs
void IntResListFree(struct IntRes *head)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of IntRes structures.  
.RE
.LP
Frees up the element of an IntRes list starting with 'head'.
.Fn SizeResCreate
.Cs
static struct SizeRes *SizeResCreate(void)
.Ce
.LP
Creates/mallocs a new SizeRes structure, returning the pointer to it. 
.Fn SizeResValueGet
.Cs
int SizeResValueGet(struct SizeRes *head, char *name)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of SizeRes structures.  
.IP name 8
The resource name to look for in the list.
.RE
.LP
Return 'value', given the 'name' in the SizeRes list. 
.Fn SizeResListPrint
.Cs
void SizeResListPrint(struct SizeRes *head, char *descr)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of SizeRes structures.  
.IP descr 8
Additional string description to print out.
.RE
.LP
Prints out the elements of SizeRes list whose 1st element is 'head'. Print the
message 'descr' along with the list output.
.Fn SizeResValuePut
.Cs
struct SizeRes *SizeResValuePut(struct SizeRes *head, char *name, int value,
                                               void *pptr)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of SizeRes structures.  
.IP name 8
The resource name.
.IP value 8
The new resource value.
.IP pptr 8
The parent pointer to associate malloc-ed storage on the SizeRes list.
.RE
.LP
In SizeRes list, this function modifies an existing element which matches
 'name', updating its resource value to 'value'. If no such element exists,
then a new entry is malloc-ed/created. Information about malloc-ed areas that
were created as a result of this call will be recorded in the mallocTable
and varstr table, with parent pointer values set to 'pptr'.
.Fn SizeResListFree
.Cs
void SizeResListFree(struct SizeRes *head)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of SizeRes structures.  
.RE
.LP
Frees up the element of a SizeRes list starting with 'head'.
.Fn StringResCreate
.Cs
static struct StringRes *StringResCreate(void)
.Ce
.LP
Creates/mallocs a new StringRes structure, returning the pointer to it. 
.Fn StringResValueGet
.Cs
int StringResValueGet(struct StringRes *head, char *name)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of StringRes structures.  
.IP name 8
The resource name to look for in the list.
.RE
.LP
Return 'value', given the 'name' in the StringRes list. 
.Fn StringResListPrint
.Cs
void StringResListPrint(struct StringRes *head, char *descr)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of StringRes structures.  
.IP descr 8
Additional string description to print out.
.RE
.LP
Prints out the elements of StringRes list whose 1st element is 'head'. Print the
message 'descr' along with the list output.
.Fn StringResValuePut
.Cs
struct StringRes *StringResValuePut(struct StringRes *head, char *name, int value,
                                               void *pptr)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of StringRes structures.  
.IP name 8
The resource name.
.IP value 8
The new resource value.
.IP pptr 8
The parent pointer to associate malloc-ed storage on the StringRes list.
.RE
.LP
In StringRes list, this function modifies an existing element which matches
 'name', updating its resource value to 'value'. If no such element exists,
then a new entry is malloc-ed/created. Information about malloc-ed areas that
were created as a result of this call will be recorded in the mallocTable
and varstr table, with parent pointer value set to 'pptr'.
.Fn StringResListFree
.Cs
void StringResListFree(struct StringRes *head)
.Ce
.IP Args: 4
.RS
.IP head 8
The 1st element in a list of StringRes structures.  
.RE
.LP
Frees up the element of a StringRes list starting with 'head'.
.LP
.NH 4
.Tc ResMom
.LP
The source code found under the
.Ar ResMom
subdirectory
contains data structures and functions that are used by the PBS ResMom (resource
monitor) abstraction.  ResMom responds to resource queries such as "loadave",
 "numCpus", and so on. The files involved are af_resmom.h and af_resmom.c. The
main data structure used is:
.nf
.Ty
   struct resmom_struct {
     char *inetAddr;
     int  portNumber;
     int  connectFd;
   }
   typedef struct resmom_struct ResMom;
.fi
.NH 5
.Fi af_resmom.c
.LP
.Fn ResMomInetAddrGet
.Cs
char *ResMomInetAddrGet(ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.RE
.LP
Returns the official host name assigned to 'mom'.
.Fn ResMomPortNumberGet
.Cs
int ResMomPortNumberGet(ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.RE
.LP
Returns the network port number assgned to 'mom'.
.Fn ResMomConnectFdGet
.Cs
int ResMomConnectFdGet(ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.RE
.LP
Returns the connect file descriptor assgned to 'mom'.
.Fn ResMomInetAddrPut
.Cs
void ResMomInetAddrPut(ResMom *mom, char *mom_name)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.IP mom_name 8
A name for 'mom'. 
.RE
.LP
Assigns (mallocs) mom_name to 'mom'. The string name has a global scope of 0.
.Fn ResMomPortNumberPut
.Cs
void ResMomPortNumberPut(ResMom *mom, int port)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.IP port 8
Port number to 'mom'.
.RE
.LP
Assigns port as port number to 'mom'.
.Fn ResMomConnectFdPut
.Cs
void ResMomConnectFdPut(ResMom *mom, int fd)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.IP fd 8
New connect file descriptor to 'mom'.
.RE
.LP
Assigns fd as connect file descriptor to 'mom'.
.Fn ResMomOpen
.Cs
int ResMomOpen(ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.RE
.LP
Opens a connection to the resource monitor using the "openrm()" call, and
returns the resulting file descriptor. The 'connectFd' attribute of 'mom' is
updated accordingly. 
.Fn ResMomClose
.Cs
int ResMomClose(ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.RE
.LP
Closes a connection to the resource monitor using the "closerm()" call. Returns
0 if closerm() was successful; non-zero otherwise.
.Fn ResMomWrite
.Cs
int ResMomWrite(ResMom *mom, char *buffer)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.IP buffer 8
A query string to send out to 'mom'.
.RE
.LP
Sends 'buffer' query to 'mom' using the addreq() call. Returns 1 if successful,
non-zero otherwise.
.Fn ResMomRead
.Cs
char *ResMomRead(ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.RE
.LP
Returns the result of a previous resource query to sent to 'mom', using the
getreq() call.
.Fn ResMomPrint
.Cs
void ResMomPrint(ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.RE
.LP
Prints out the elements of 'mom'.
.Fn ResMomInit
.Cs
void ResMomInit(ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.RE
.LP
Initializes 'mom'.
.Fn ResMomFree
.Cs
void ResMomFree(ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP mom 8
Pointer to a ResMom structure.
.RE
.LP
Frees up all malloc-ed storage associated with 'mom' structure.
.LP
.NH 4
.Tc CNode
.LP
The source code found under the
.Ar CNode
subdirectory
contains data structures and functions that are used by the CNode abstraction.
CNode stands for computational node, consisting of a shared memory, single OS
image, and a set of CPUs.  The files involved are af_cnode.h and af_cnode.c,
af_cnodemap.h, af_cnodemap.c. The main data structures used are:
.nf
.Ty
  struct IODevice {
    struct IODevice *nextptr;
    char *name;               /* unique identitiy of the device */
    Size spaceTotal;          /* total space on the device */
    Size spaceAvail;          /* space available on the device */
    Size spaceReserved;       /* space reserved for the jobs */
    int  inBw;                /* read bandwidth (bytes/s) or swap in rate */ 
    int  outBw;               /* write bandwidth (bytes/s) or swap out rate */
  };

  struct Network {
    struct Network *nextptr;
    char *type;               /* type of network - hippi, fddi, ... */  
    int  bw;                  /* network bandwidth - in bytes/sec */ 
  };

  struct Memory {
    struct Memory *nextptr;
    char *type;               /* could be physical or virtual Mem */
    Size total;               /* total memory size */
    Size avail;               /* available memory */ 
  };

  struct cnode_struct {
    struct cnode_struct *nextptr;
    ResMom name;             /* the MOM representing the node */
    char   *properties;      /* comma-separated list of alias hostnames */
    char   *vendor;          /* system name */
    char   *os;              /* string describing the OS version */
    int    numCpus;          /* number of processors */
    int    state;            /* node state */
    int    type;             /* node type */
    int    queryMom;         /* flag */
    int    idletime;         /* time since last keystroke/mouse movement */
    int    cpuPercentIdle;   /* % of idletime experienced by all processors */
    int    cpuPercentSys;    /* % of time that all processors have spent */
                             /* running kernel code */
    int    cpuPercentUser;   /* % of time that all processors have spent */
                             /* running user code */
    int   cpuPercentGuest;   /* % of time that all processors have spent */
                             /* running a guest operating system */
    double loadave;          /* load average of all cpus in the node */
    struct Memory *mem;      /* memory */
    struct Network *network; /* list of network devices and their properties */	
    struct IODevice *swap;   /* list of swap devices and their properties */
    struct IODevice disk;    /* list of disk devices and their properties */
    struct IODevice tape;    /* list of tape devices and their properties */
    struct IODevice srfs;    /* list of srfs devices and their properties */
    int    multiplicity;     /* during node requests, this is the # */
                             /* of nodes of this type requested */ 
  };
  typedef struct cnode_struct CNode;

  struct SetCNode_type {    /* a Set of CNodes abstraction */
    CNode *head;
    CNode *tail;
    int   numAvail;
    int   numAlloc;
    int   numRsvd;
    int   numDown;
  };
  typedef struct SetCNode_type SetCNode;

  struct CNodeAttrInfo {
    char *name;             /* name of a CNode struct member */
    int  type;              /* attribute type */
    void (*attrPutFunc)();  /* CNodePut function for attribute */
  };

  struct Resource {
    char *archType;
    char *nodeAttr;
    char *hostQuery_keyword;

  };

.fi
.NH 5
.Fi af_cnode.c
.LP
.Fn IODeviceCreate
.Cs
static struct IODevice *IODeviceCreate(void)
.Ce
.LP
Mallocs a new struct IODevice structure, initializes the values of its 
elements, and then returns the pointer to the structure.
.Fn IODeviceSpaceTotalGet
.Cs
static Size IODeviceSpaceTotalGet(struct IODevice *iod_head, char *name)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name assigned to the device.
.RE
.LP
Returns the spaceTotal attribute value of a device named 'name' as found in
the list of devices. 
.Fn IODeviceSpaceAvailGet
.Cs
static Size IODeviceSpaceAvailGet(struct IODevice *iod_head, char *name)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name assigned to the device.
.RE
.LP
Returns the spaceAvail attribute value of a device named 'name' as found in
the list of devices. 
.Fn IODeviceSpaceReservedGet
.Cs
static Size IODeviceSpaceReservedGet(struct IODevice *iod_head, char *name)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name assigned to the device.
.RE
.LP
Returns the spaceReserved attribute value of a device named 'name' as found in
the list of devices. 
.Fn IODeviceInBwGet
.Cs
static int IODeviceInBwGet(struct IODevice *iod_head, char *name)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name assigned to the device.
.RE
.LP
Returns the inBw attribute value of a device named 'name' as found in
the list of devices. 
.Fn IODeviceOutBwGet
.Cs
static int IODeviceOutBwGet(struct IODevice *iod_head, char *name)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name assigned to the device.
.RE
.LP
Returns the outBw attribute value of a device named 'name' as found in
the list of devices. 
.Fn IODeviceListPrint
.Cs
static void IODeviceListPrint(struct IODevice *iod_head, char *descr)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP descr 8
A message string to print out.
.RE
.LP
Prints out the values of the list of IO devices headed by 'iod_head'.
.Fn IODeviceSpaceTotalPut
.Cs
static struct IODevice *IODeviceSpaceTotalPut(struct IODevice *iod_head,
                                     char *name, Size total, void *pptr)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name of the device.
.IP total 8
New spaceTotal attribute value.
.IP pptr 8
Some parent pointer to associate a device's malloc-ed storage. 
.RE
.LP
Modifies the spaceTotal attribute value of the device named by 'name'. A new
IODevice structure is created if no device named 'name' exists. For any
newly malloc-ed area, an association with 'pptr' is established. This function
returns non-NULL if there's a new head of the list (takes place when a
new device is added to the list); NULL otherwise.
.Fn IODeviceSpaceAvailPut
.Cs
static struct IODevice *IODeviceSpaceAvailPut(struct IODevice *iod_head,
                                     char *name, Size avail, void *pptr)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name of the device.
.IP avail 8
New spaceAvail attribute value.
.IP pptr 8
Some parent pointer to associate a device's malloc-ed storage. 
.RE
.LP
Modifies the spaceAvail attribute value of the device named by 'name'. A new
IODevice structure is created if no device named 'name' exists. For any
newly malloc-ed area, an association with 'pptr' is established. This function
returns non-NULL if there's a new head of the list (takes place when a
new device is added to the list); NULL otherwise.
.Fn IODeviceSpaceReservedPut
.Cs
static struct IODevice *IODeviceSpaceReservedPut(struct IODevice *iod_head,
                                      char *name, Size reserve, void *pptr)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name of the device.
.IP reserve 8
New spaceAvail attribute value.
.IP pptr 8
Some parent pointer to associate a device's malloc-ed storage. 
.RE
.LP
Modifies the spaceReserved attribute value of the device named by 'name'. A new
IODevice structure is created if no device named 'name' exists. For any
newly malloc-ed area, an association with 'pptr' is established. This function
returns non-NULL if there's a new head of the list (takes place when a
new device is added to the list); NULL otherwise.
.Fn IODeviceSpaceInBwPut
.Cs
static struct IODevice *IODeviceInBwPut(struct IODevice *iod_head,
                                 char *name, int inBw, void *pptr)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name of the device.
.IP inBw 8
New inBw attribute value.
.IP pptr 8
Some parent pointer to associate a device's malloc-ed storage. 
.RE
.LP
Modifies the inBw attribute value of the device named by 'name'. A new
IODevice structure is created if no device named 'name' exists. For any
newly malloc-ed area, an association with 'pptr' is established. This function
returns non-NULL if there's a new head of the list (takes place when a
new device is added to the list); NULL otherwise.
.Fn IODeviceSpaceOutBwPut
.Cs
static struct IODevice *IODeviceOutBwPut(struct IODevice *iod_head,
                                 char *name, int outBw, void *pptr)
.Ce
.IP Args: 4
.RS
.IP iod_head 8
1st device in the device list.
.IP name 8
Name of the device.
.IP outBw 8
New outBw attribute value.
.IP pptr 8
Some parent pointer to associate a device's malloc-ed storage. 
.RE
.LP
Modifies the outBw attribute value of the device named by 'name'. A new
IODevice structure is created if no device named 'name' exists. For any
newly malloc-ed area, an association with 'pptr' is established. This function
returns non-NULL if there's a new head of the list (takes place when a
new device is added to the list); NULL otherwise.
.Fn NetworkCreate
.Cs
static struct Memory *NetworkCreate(void)
.Ce
.LP
Mallocs a new struct Network structure, initializes the values of its 
elements, and then returns the pointer to the structure.
.Fn NetworkBwGet
.Cs
static int NetworkBwGet(struct Network *net_head, char *name)
.Ce
.IP Args: 4
.RS
.IP net_head 8
1st network device in the device list.
.IP name 8
Name assigned to the network device.
.RE
.LP
Returns the bw attribute value of a network device named 'name' as found in
the list of devices.
.Fn NetworkListPrint
.Cs
static void NetworkListPrint(struct IODevice net_head)
.Ce
.IP Args: 4
.RS
.IP net_head 8
1st network device in the device list.
.RE
.LP
Prints out the various network names and respective bandwidths in the list of
network devices.
.Fn NetworkBwPut
.Cs
static struct IODevice *NetworkBwPut(struct IODevice *net_head,
                                char *type, int bw, void *pptr)
.Ce
.IP Args: 4
.RS
.IP net_head 8
1st network device in the device list.
.IP type 8
Type of the network device.
.IP bw 8
New bw attribute value.
.IP pptr 8
Some parent pointer to associate a device's malloc-ed storage. 
.RE
.LP
Modifies the bw attribute value of the network device named by 'type'. A new
Network structure is created if no network device named 'type' exists. For any
newly malloc-ed area, an association with 'pptr' is established. This function
returns non-NULL if there's a new head of the list (takes place when a
new device is added to the list); NULL otherwise.
.Fn MemoryCreate
.Cs
static struct Memory *MemoryCreate(void)
.Ce
.LP
Mallocs a new struct Memory structure, initializes the values of its 
elements, and then returns the pointer to the structure.
.Fn MemoryTotalGet
.Cs
static Size MemoryTotalGet(struct Memory *mem_head, char *type)
.Ce
.IP Args: 4
.RS
.IP mem_head 8
1st memory device in the device list.
.IP type 8
Name assigned to the memory device (i.e. physical or virtual).
.RE
.LP
Returns the total attribute value of a memory device named 'type' as found in
the list of devices. -1B is returned if no such device is found.
.Fn MemoryAvailGet
.Cs
static Size MemoryAvailGet(struct Memory *mem_head, char *type)
.Ce
.IP Args: 4
.RS
.IP mem_head 8
1st memory device in the device list.
.IP type 8
Name assigned to the memory device (i.e. physical or virtual).
.RE
.LP
Returns the avail attribute value of a memory device named 'type' as found in
the list of devices. -1B is returned if no such device is found.
.Fn MemoryListPrint
.Cs
static void MemoryListPrint(struct Memory *mem_head)
.Ce
.IP Args: 4
.RS
.IP mem_head 8
1st memory device in the device list.
.RE
.LP
Prints out the various memory types and respective attributes in the list of
memory devices.
.Fn MemoryTotalPut
.Cs
static struct Memory *MemoryTotalPut(struct Memory *mem_head,
                         char *type, Size newTot, void *pptr)
.Ce
.IP Args: 4
.RS
.IP mem_head 8
1st memory device in the device list.
.IP type 8
Type of the memory device.
.IP newTot 8
New total attribute value.
.IP pptr 8
Some parent pointer to associate a device's malloc-ed storage. 
.RE
.LP
Modifies the total attribute value of the memory device named by 'type'. A new
Memory is created if no memory device named 'type' exists. For any
newly malloc-ed area, an association with 'pptr' is established. This function
returns non-NULL if there's a new head of the list (takes place when a
new device is added to the list); NULL otherwise.
.Fn MemoryAvailPut
.Cs
static struct Memory *MemoryAvailPut(struct Memory *mem_head,
                       char *type, Size newAvail, void *pptr)
.Ce
.IP Args: 4
.RS
.IP mem_head 8
1st memory device in the device list.
.IP type 8
Type of the memory device.
.IP newAvail 8
New avail attribute value.
.IP pptr 8
Some parent pointer to associate a device's malloc-ed storage. 
.RE
.LP
Modifies the avail attribute value of the memory device named by 'type'. A new
Memory is created if no memory device named 'type' exists. For any
newly malloc-ed area, an association with 'pptr' is established. This function
returns non-NULL if there's a new head of the list (takes place when a
new device is added to the list); NULL otherwise.
.Fn CNodeResMomInetAddrGet
.Cs
ResMom *CNodeResMomGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the ResMom structure representing 'node'.
.Fn CNodeNameGet
.Cs
char *CNodeNameGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the official name of the 'node'.
.Fn CNodePropertiesGet
.Cs
char *CNodePropertiesGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the properties attribute of the 'node'.
.Fn CNodeOsGet
.Cs
char *CNodeOsGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the os attribute of the 'node'.
.Fn CNodeNumCpusGet
.Cs
int CNodeNumCpusGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the numCpus attribute of the 'node'.
.Fn CNodeMemTotalGet
.Cs
Size CNodeMemTotalGet(CNode *node, char *type)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP type 8
Type of memory.
.RE
.LP
Returns the mem[type]->total attribute of the 'node'. -1B if undefined.
.Fn CNodeMemAvailGet
.Cs
Size CNodeMemAvailGet(CNode *node, char *type)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP type 8
Type of memory.
.RE
.LP
Returns the mem[type]->avail attribute of the 'node'. -1B if undefined.
.Fn CNodeStateGet
.Cs
int CNodeStateGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the state attribute of the 'node'.
.Fn CNodeTypeGet
.Cs
int CNodeTypeGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the type attribute of the 'node'.
.Fn CNodeQueryMomGet
.Cs
int CNodeQueryMomGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the queryMom attribute of the 'node'.
.Fn CNodeIdletimeGet
.Cs
int CNodeIdletimeGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the idletime attribute of the 'node'.
.Fn CNodeLoadAveGet
.Cs
double CNodeLoadAveGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the loadAve attribute of the 'node'.
.Fn CNodeNetworkBwGet
.Cs
int CNodeNetworkBwGet(CNode *node, char *type)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP type 8
type of network.
.RE
.LP
Returns the network[type]->bw attribute of the 'node'.
.Fn CNodeDiskSpaceTotalGet
.Cs
Size CNodeDiskSpaceTotalGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a disk device.
.RE
.LP
Returns the disk[name]->spaceTotal attribute of the 'node'.
.Fn CNodeDiskSpaceAvailGet
.Cs
Size CNodeDiskSpaceAvailGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a disk device.
.RE
.LP
Returns the disk[name]->spaceAvail attribute of the 'node'.
.Fn CNodeDiskSpaceReservedGet
.Cs
Size CNodeDiskSpaceReservedGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a disk device.
.RE
.LP
Returns the disk[name]->spaceReserved attribute of the 'node'.
.Fn CNodeDiskInBwGet
.Cs
int CNodeDiskInBwGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a disk device.
.RE
.LP
Returns the disk[name]->inBw attribute of the 'node'.
.Fn CNodeDiskOutBwGet
.Cs
int CNodeDiskOutBwGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a disk device.
.RE
.LP
Returns the disk[name]->outBw attribute of the 'node'.
.Fn CNodeSwapSpaceTotalGet
.Cs
Size CNodeSwapSpaceTotalGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a swap device.
.RE
.LP
Returns the swap[name]->spaceTotal attribute of the 'node'.
.Fn CNodeSwapSpaceAvailGet
.Cs
Size CNodeSwapSpaceAvailGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a swap device.
.RE
.LP
Returns the swap[name]->spaceAvail attribute of the 'node'.
.Fn CNodeSwapSpaceReservedGet
.Cs
Size CNodeSwapSpaceReservedGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a swap device.
.RE
.LP
Returns the swap[name]->spaceReserved attribute of the 'node'.
.Fn CNodeSwapInBwGet
.Cs
int CNodeSwapInBwGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a swap device.
.RE
.LP
Returns the swap[name]->inBw attribute of the 'node'.
.Fn CNodeSwapOutBwGet
.Cs
int CNodeSwapOutBwGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a swap device.
.RE
.LP
Returns the swap[name]->outBw attribute of the 'node'.
.Fn CNodeTapeSpaceTotalGet
.Cs
Size CNodeTapeSpaceTotalGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a tape device.
.RE
.LP
Returns the tape[name]->spaceTotal attribute of the 'node'.
.Fn CNodeTapeSpaceAvailGet
.Cs
Size CNodeTapeSpaceAvailGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a tape device.
.RE
.LP
Returns the tape[name]->spaceAvail attribute of the 'node'.
.Fn CNodeTapeSpaceReservedGet
.Cs
Size CNodeTapeSpaceReservedGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a tape device.
.RE
.LP
Returns the tape[name]->spaceReserved attribute of the 'node'.
.Fn CNodeTapeInBwGet
.Cs
int CNodeTapeInBwGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a tape device.
.RE
.LP
Returns the tape[name]->inBw attribute of the 'node'.
.Fn CNodeTapeOutBwGet
.Cs
int CNodeTapeOutBwGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of a tape device.
.RE
.LP
Returns the tape[name]->outBw attribute of the 'node'.
.Fn CNodeSrfsSpaceTotalGet
.Cs
Size CNodeSrfsSpaceTotalGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of an srfs device.
.RE
.LP
Returns the srfs[name]->spaceTotal attribute of the 'node'.
.Fn CNodeSrfsSpaceAvailGet
.Cs
Size CNodeSrfsSpaceAvailGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of an srfs device.
.RE
.LP
Returns the srfs[name]->spaceAvail attribute of the 'node'.
.Fn CNodeSrfsSpaceReservedGet
.Cs
Size CNodeSrfsSpaceReservedGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of an srfs device.
.RE
.LP
Returns the srfs[name]->spaceReserved attribute of the 'node'.
.Fn CNodeSrfsInBwGet
.Cs
int CNodeSrfsInBwGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of an srfs device.
.RE
.LP
Returns the srfs[name]->inBw attribute of the 'node'.
.Fn CNodeSrfsOutBwGet
.Cs
int CNodeSrfsOutBwGet(CNode *node, char *name)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
name of an srfs device.
.RE
.LP
Returns the srfs[name]->outBw attribute of the 'node'.
.Fn CNodeCpuPercentIdleGet
.Cs
int CNodeCpuPercentIdleGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the cpuPercentIdle attribute of the 'node'.
.Fn CNodeCpuPercentSysGet
.Cs
int CNodeCpuPercentSysGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the cpuPercentSys attribute of the 'node'.
.Fn CNodeCpuPercentUserGet
.Cs
int CNodeCpuPercentUserGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the cpuPercentUser attribute of the 'node'.
.Fn CNodeCpuPercentGuestGet
.Cs
int CNodeCpuPercentGuestGet(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Returns the cpuPercentGuest attribute of the 'node'.
.Fn CNodeResMomPut
.Cs
void CNodeResMomPut(CNode *node, ResMom *mom)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP mom 8
New mom structure. 
.RE
.LP
Sets node->mom attribute value to *mom.
.Fn CNodePropertiesPut
.Cs
void CNodePropertiesPut(CNode *node, char *properties)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP properties 8
New properties
.RE
.LP
Sets node->properties attribute value to 'properties'.
.Fn CNodeVendorPut
.Cs
void CNodeVendorPut(CNode *node, char *vendor)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP vendor 8
New vendor name.
.RE
.LP
Sets node->vendor attribute value to 'vendor'.
.Fn CNodeOsPut
.Cs
void CNodeOsPut(CNode *node, char *os)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP os 8
New os type.
.RE
.LP
Sets node->os attribute value to 'os'.
.Fn CNodeNumCpusPut
.Cs
void CNodeNumCpusPut(CNode *node, int ncpus)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP ncpus 8
Number of cpus.
.RE
.LP
Sets node->NumCpus attribute value to 'ncpus'.
.Fn CNodeMemTotalPut
.Cs
void CNodeMemTotalPut(CNode *node, char *type, Size pmem)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP type 8
A type of memory.
.IP pmem 8
New memory total value.
.RE
.LP
Sets the node's mem[type]->total attribute value to 'pmem'.
.Fn CNodeMemAvailPut
.Cs
void CNodeMemAvailPut(CNode *node, char *type, Size pmem)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP type 8
A type of memory.
.IP pmem 8
New memory total value.
.RE
.LP
Sets the node's mem[type]->avail attribute value to 'pmem'.
.Fn CNodeStatePut
.Cs
void CNodeStatePut(CNode *node, int state)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP state 8
New state attribute value.
.RE
.LP
Sets the node's state attribute value to 'state'.
.Fn CNodeTypePut
.Cs
void CNodeTypePut(CNode *node, int type)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP type 8
New type attribute value.
.RE
.LP
Sets the node's type attribute value to 'type'.
.Fn CNodeQueryMomPut
.Cs
void CNodeQueryMomPut(CNode *node, int queryMom)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP queryMom 8
New queryMom attribute value.
.RE
.LP
Sets the node's queryMom attribute value to 'queryMom'.
.Fn CNodeIdletimePut
.Cs
void CNodeIdletimePut(CNode *node, int idletime)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP idletime 8
New idletime attribute value.
.RE
.LP
Sets the node's idletime attribute value to 'idletime'.
.Fn CNodeLoadAvePut
.Cs
void CNodeLoadAvePut(CNode *node, double loadave)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP loadave 8
New loadave attribute value.
.RE
.LP
Sets the node's loadAve attribute value to 'loadave'.
.Fn CNodeDiskSpaceTotalPut
.Cs
void CNodeDiskSpaceTotalPut(CNode *node, char *name, Size size)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a disk device to update info on. 
.IP size 8
New size value to spaceTotal attribute.
.RE
.LP
Sets the node's disk[name]->spaceTotal attribute value to 'size'.
.Fn CNodeDiskSpaceAvailPut
.Cs
void CNodeDiskSpaceAvailPut(CNode *node, char *name, Size size)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a disk device to update info on. 
.IP size 8
New size value to spaceAvail attribute.
.RE
.LP
Sets the node's disk[name]->spaceAvail attribute value to 'size'.
.Fn CNodeDiskSpaceReservedPut
.Cs
void CNodeDiskSpaceReservedPut(CNode *node, char *name, Size size)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a disk device to update info on. 
.IP size 8
New size value to spaceReserved attribute.
.RE
.LP
Sets the node's disk[name]->spaceReserved attribute value to 'size'.
.Fn CNodeDiskInBwPut
.Cs
void CNodeDiskInBwPut(CNode *node, char *name, int bw)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a disk device to update info on. 
.IP bw 8
New bandwidth value to inBw attribute.
.RE
.LP
Sets the node's disk[name]->inBw attribute value to 'bw'.
.Fn CNodeDiskOutBwPut
.Cs
void CNodeDiskOutBwPut(CNode *node, char *name, int bw)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a disk device to update info on. 
.IP bw 8
New bandwidth value to outBw attribute.
.RE
.LP
Sets the node's disk[name]->outBw attribute value to 'bw'.
.Fn CNodeSwapSpaceTotalPut
.Cs
void CNodeSwapSpaceTotalPut(CNode *node, char *name, Size swaptot)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a swap device to update info on. 
.IP swaptot 8
New value to spaceTotal attribute.
.RE
.LP
Sets the node's swap[name]->spaceTotal attribute value to 'swaptot'.
.Fn CNodeSwapSpaceAvailPut
.Cs
void CNodeSwapSpaceAvailPut(CNode *node, char *name, Size swapavail)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a swap device to update info on. 
.IP swapavail 8
New value to spaceAvail attribute.
.RE
.LP
Sets the node's swap[name]->spaceAvail attribute value to 'swapavail'.
.Fn CNodeSwapSpaceReservedPut
.Cs
void CNodeSwapSpaceReservedPut(CNode *node, char *name, Size swapres)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a swap device to update info on. 
.IP swapres 8
New value to spaceReserved attribute.
.RE
.LP
Sets the node's swap[name]->spaceReserved attribute value to 'size'.
.Fn CNodeSwapInBwPut
.Cs
void CNodeSwapInBwPut(CNode *node, char *name, int bw)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a swap device to update info on. 
.IP bw 8
New bandwidth value to inBw attribute.
.RE
.LP
Sets the node's swap[name]->inBw attribute value to 'bw'.
.Fn CNodeSwapOutBwPut
.Cs
void CNodeSwapOutBwPut(CNode *node, char *name, int bw)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a swap device to update info on. 
.IP bw 8
New bandwidth value to outBw attribute.
.RE
.LP
Sets the node's swap[name]->outBw attribute value to 'bw'.
.Fn CNodeTapeSpaceTotalPut
.Cs
void CNodeTapeSpaceTotalPut(CNode *node, char *name, Size size)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a tape device to update info on. 
.IP size 8
New value to spaceTotal attribute.
.RE
.LP
Sets the node's tape[name]->spaceTotal attribute value to 'size'.
.Fn CNodeTapeSpaceAvailPut
.Cs
void CNodeTapeSpaceAvailPut(CNode *node, char *name, Size size)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a tape device to update info on. 
.IP size 8
New value to spaceAvail attribute.
.RE
.LP
Sets the node's tape[name]->spaceAvail attribute value to 'size'.
.Fn CNodeTapeSpaceReservedPut
.Cs
void CNodeTapeSpaceReservedPut(CNode *node, char *name, Size size)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a swap device to update info on. 
.IP size 8
New value to spaceReserved attribute.
.RE
.LP
Sets the node's tape[name]->spaceReserved attribute value to 'size'.
.Fn CNodeTapeInBwPut
.Cs
void CNodeTapeInBwPut(CNode *node, char *name, int bw)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a tape device to update info on. 
.IP bw 8
New bandwidth value to inBw attribute.
.RE
.LP
Sets the node's tape[name]->inBw attribute value to 'bw'.
.Fn CNodeTapeOutBwPut
.Cs
void CNodeTapeOutBwPut(CNode *node, char *name, int bw)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of a tape device to update info on.
.IP bw 8
New bandwidth value to outBw attribute.
.RE
.LP
Sets the node's tape[name]->outBw attribute value to 'bw'.
.Fn CNodeSrfsSpaceTotalPut
.Cs
void CNodeSrfsSpaceTotalPut(CNode *node, char *name, Size size)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of an srfs device to update info on. 
.IP size 8
New value to spaceTotal attribute.
.RE
.LP
Sets the node's srfs[name]->spaceTotal attribute value to 'size'.
.Fn CNodeSrfsSpaceAvailPut
.Cs
void CNodeSrfsSpaceAvailPut(CNode *node, char *name, Size size)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of an srfs device to update info on. 
.IP size 8
New value to spaceAvail attribute.
.RE
.LP
Sets the node's srfs[name]->spaceAvail attribute value to 'size'.
.Fn CNodeSrfsSpaceReservedPut
.Cs
void CNodeSrfsSpaceReservedPut(CNode *node, char *name, Size size)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of an srfs device to update info on. 
.IP size 8
New value to spaceReserved attribute.
.RE
.LP
Sets the node's srfs[name]->spaceReserved attribute value to 'size'.
.Fn CNodeSrfsInBwPut
.Cs
void CNodeSrfsInBwPut(CNode *node, char *name, int bw)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of an srfs device to update info on. 
.IP bw 8
New bandwidth value to inBw attribute.
.RE
.LP
Sets the node's srfs[name]->inBw attribute value to 'bw'.
.Fn CNodeSrfsOutBwPut
.Cs
void CNodeSrfsOutBwPut(CNode *node, char *name, int bw)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP name 8
Name of an srfs device to update info on.
.IP bw 8
New bandwidth value to outBw attribute.
.RE
.LP
Sets the node's srfs[name]->outBw attribute value to 'bw'.
.Fn CNodeCpuPercentIdlePut
.Cs
void CNodeCpuPercentIdlePut(CNode *node, int percent)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP percent 8
New value to cpuPercentIdle attribute.
.RE
.LP
Sets the node's cpuPercentIdle attribute value to 'percent'.
.Fn CNodeCpuPercentSysPut
.Cs
void CNodeCpuPercentSysPut(CNode *node, int percent)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP percent 8
New value to cpuPercentSys attribute.
.RE
.LP
Sets the node's cpuPercentSys attribute value to 'percent'.
.Fn CNodeCpuPercentUserPut
.Cs
void CNodeCpuPercentUserPut(CNode *node, int percent)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP percent 8
New value to cpuPercentUser attribute.
.RE
.LP
Sets the node's cpuPercentUser attribute value to 'percent'.
.Fn CNodeCpuPercentGuestPut
.Cs
void CNodeCpuPercentGuestPut(CNode *node, int percent)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP percent 8
New value to cpuPercentGuest attribute.
.RE
.LP
Sets the node's cpuPercentGuest attribute value to 'percent'.
.Fn CNodeFree
.Cs
void CNodeFree(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Free up all malloc-ed storage associated with 'node'.
.Fn CNodeInit
.Cs
void CNodeInit(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Initialized the values of the 'node' members to something that are consistent.
.Fn CNodePrint
.Cs
void CNodePrint(CNode *node)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.RE
.LP
Print out the values of the 'node' members.
.Fn send_queries
.Cs
static int send_queries(CNode *node, char *arch, int typeOfData,
                                     struct CNodeAttrInfo **buf)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP arch 8
Some unique classification of a node (could be its name or os type)
.IP typeOfData 8
type of query to send out (i.e. STATIC_RESOURCE or DYNAMIC_RESOURCE) 
.IP buf 8
an array of information describing each of the resource queries to be sent
out. Description includes name of the corresponding CNode attribute, its type,
and a pointer to the function that handles assigning the query result to the
CNode attribute.
.RE
.LP
The algorithm is as follows:
.nf
  if typeOfData is STATIC_RESOURCE
  then

    foreach of the the known static attributes
    do
 	get the corresponding resource query for the attribute based on a
            matching 'arch' value,
        fill the 'buf' array with relevant information,
        send out the query.
        reset the value of the corresponding attribute to some default value
           so that we can tell if if the query fails
        update the numSends count. 
    done
  else if typeOfData is DYNAMIC_RESOURCE
    foreach of the the known dynamic attributes 
    do
 	get the corresponding resource query for the attribute based on a
            matching 'arch' value.
        fill the 'buf' array with relevant information,
        send out the query.
        update the numSends count. 
    done

    NOTE: Information about the queries are listed in the array in the order
          that they were sent.
           
    Return the number of queries sent.
.fi
.Fn put_default_val
.Cs
static int put_default_val(CNode *node, char *attrib, int type, void (*putfunc)())
.Ce
.IP Args: 4
.RS
.IP node 10
Pointer to a CNode structure.
.IP attrib 10
a CNode attribute name.
.IP type 10
data type for the attribue
.IP putfunc 10
The put function that will store the default value.
.RE
.LP
.nf
  if 'type' is INT_TYPE, then put a value of -1
  if 'type' is SIZE_TYPE, then put a value of -1.0b
  if 'type' is FLT_TYPE, then put a value of -1.0
  if 'type' is STR_TYPE, then put a value of NULLSTR
.fi
.Fn recv_responses
.Cs
static int recv_responses(CNode *node, struct CNodeAttrInfo **buf)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP buf 8
an array of information describing each of the resource queries received.
Description includes name of the corresponding CNode attribute, its type,
and a pointer to the function that handles assigning the query result to the
CNode attribute.
.RE
.LP
.nf
  foreach of the query results received,
  do
    update the corresponding 'node' structure by using information provided
    in the 'buf' array.
  done
  Return the number of query results received.
.fi
.Fn CNodeStateRead
.Cs
void CNodeStateRead(CNode *node, int typeOfData)
.Ce
.IP Args: 4
.RS
.IP node 8
Pointer to a CNode structure.
.IP typeOfData 8
The type of data to get for 'node' (i.e. STATIC_RESOURCE, DYNAMIC_RESOURCE) 
.RE
.LP
.nf
  Don't proceed if CNodeQueryMomGet(node) is set to 0.
  open a connection to the node's ResMom.
  get the node's ResMom name. Use this name to send resource queries that
    apply only to this name.
  get the ResMom's responses to the queries.

  If nodetype is CNODE_UNKNOWN, then update the node's state value: CNODE_FREE,
    CNODE_DOWN,
  close connection to the ResMom.
  
  foreach of the query results received,
  do
    update the corresponding 'node' structure by using information provided
    in the 'buf' array.
  done
.fi
.Fn SetCNodeInit
.Cs
void SetCNodeInit(SetCNode *scn)
.Ce
.IP Args: 4
.RS
.IP scn 8
Pointer to a Set of CNode structure.
.RE
.LP
Initializes the 'scn' structure so that point the head of the set and the tail
of set are pointing to NOCNODE.
Also, initialize the attributes numAvail, numAlloc, numRsvd, numDown to -1.
.Fn SetCNodeAdd
.Cs
void SetCNodeAdd(SetCNode *scn, CNode *cn)
.Ce
.IP Args: 4
.RS
.IP scn 8
Pointer to a Set of CNode structure.
.IP cn 8
A new node to add.
.RE
.LP
Adds 'cn' to the set of CNodes.
.Fn SetCNodeFree
.Cs
void SetCNodeFree(SetCNode *scn)
.Ce
.IP Args: 4
.RS
.IP scn 8
Pointer to a Set of CNode structure.
.RE
.LP
Free up all malloc-storage associated with scn.
.Fn SetCNodeFindCNodeByName
.Cs
CNode *SetCNodeFindCNodeByName(SetCNode *scn, char *node_name)
.Ce
.IP Args: 4
.RS
.IP scn 8
Pointer to a Set of CNode structure.
.IP node_name 8
A node_name to search for.
.RE
.LP
Return the node in the set of CNode, 'scn', whose name matches 'node_name'. 
.Fn SetCNodePrint
.Cs
void SetCNodePrint(SetCNode *scn)
.Ce
.IP Args: 4
.RS
.IP scn 8
Pointer to a Set of CNode structure.
.RE
.LP
Print out the structures associated with 'scn'.
.Fn inSetCNode
.Cs
int inSetCNode(CNode *cn, SetCNode *scn)
.Ce
.IP Args: 4
.RS
.IP cn 8
A node to look for.
.IP scn 8
Pointer to a Set of CNode structure.
.RE
.LP
Returns 1 if 'cn' is a member of the set of nodes, 'scn'; 0 otherwise.
.Fn CNodePartition
.Cs
int CNodePartition(struct CNodeSortArgs *A, int p, int r)
.Ce
.IP Args: 4
.RS
.IP A 8
stuff of information needed to reorder the elements of a set of CNodes. 
.IP p 8
the "leftmost" element of a set of CNodes.  
.IP r 8
the "rightmost" element of a set of CNodes. 
.RE
.LP
This is the Partition() function in the well-known Quicksort() sorting
algorithm. (see "Introduction to Algorithms" by Cormen, et al) pp. 153-156).
.Fn CNodeQuickSort
.Cs
void CNodeQuickSort (struct CNodeSortArgs *A, int p, int r)
.Ce
.IP Args: 4
.RS
.IP A 8
stuff of information needed to reorder the elements of a set of CNodes. 
.IP p 8
the "leftmost" element of a set of CNodes.
.IP r 8
the "rightmost" element of a set of CNodes. 
.RE
.LP
This is the Quicksort() function in the well-known quicksort sorting
algorithm. (see "Introduction to Algorithms" by Cormen, et al) pp. 153-156).
.Fn SetCNodeSortInt
.Cs
int SetCNodeSortInt (SetCNode *s, int (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of CNodes to reorder.
.IP key 8
the function to apply to each member of the set of CNodes whose int value
will be used to reorder the set of CNodes.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of CNodes in a dynamic array, and then run
CNodeQuicksort() function on the array, which also rearranges the pointers
representing the set of CNodes.
.Fn SetCNodeSortStr
.Cs
int SetCNodeSortStr (SetCNode *s, char *(*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of CNodes to reorder.
.IP key 8
the function to apply to each member of the set of CNodes whose char* value
will be used to reorder the set of CNodes.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of CNodes in a dynamic array, and then run
CNodeQuicksort() function on the array, which also rearranges the pointers
representing the set of CNodes.
.Fn SetCNodeSortDateTime
.Cs
int SetCNodeSortDateTime (SetCNode *s, DateTime (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of CNodes to reorder.
.IP key 8
the function to apply to each member of the set of CNodes whose DateTime value
will be used to reorder the set of CNodes.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of CNodes in a dynamic array, and then run
CNodeQuicksort() function on the array, which also rearranges the pointers
representing the set of CNodes.
.Fn SetCNodeSortSize
.Cs
int SetCNodeSortSize (SetCNode *s, Size (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of CNodes to reorder.
.IP key 8
the function to apply to each member of the set of CNodes whose Size value
will be used to reorder the set of CNodes.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of CNodes in a dynamic array, and then run
CNodeQuicksort() function on the array, which also rearranges the pointers
representing the set of CNodes.
.Fn SetCNodeSortFloat
.Cs
int SetCNodeSortFloat (SetCNode *s, double (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of CNodes to reorder.
.IP key 8
the function to apply to each member of the set of CNodes whose double value
will be used to reorder the set of CNodes.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of CNodes in a dynamic array, and then run
CNodeQuicksort() function on the array, which also rearranges the pointers
representing the set of CNodes.
.NH 5
.Fi af_cnodemap.h
.LP
This file defines 2 special variables called
.Ty static_attrinfo_map
and
.Ty dynamic_attrinfo_map
which are arrays of
.Ty "struct CNodeAttrInfo" 
recording the various pointers to functions that update attribute values,
attributes' types, and names of the respective CNodeGet functions. Update these
data structure accordingly if a new CNodeGet() function has been added. Place
those functions under static_attrinfo_map if the type of resource being mapped
by the CNodeGet() function in question is STATIC in nature; otherwise, place
them in dynamic_attrinfo_map.
.NH 5
.Fi af_cnodemap.c
.LP
.Fn nodeAttrCmpNoTag
.Cs
int nodeAttrCmpNoTag(char *attr1, char *attr2)
.Ce
.IP Args: 4
.RS
.IP attr1 8
1st attribute name to compare.
.IP attr2 8
2nd attribute name to compare.
.RE
.LP
Compares 2 attribute names (ignoring tags in vector attributes), and returns
0 if they are of the same name. Note that a no-tag CNodeDiskSpaceReservedGet[]
will match a tagged CNodeDiskSpaceReservedGet[$FASTDIR] (example).
.Fn parseAttrForTag
.Cs
char *parseAttrForTag(char *attName)
.Ce
.IP Args: 4
.RS
.IP attName 8
An attribute name to parse.
.RE
.LP
Given an attribute name of the form, "name[tag]", return the "tag" part.
If no tag, then return NULL.
.Fn getAttrType
.Cs
int *getAttrType(char *attName)
.Ce
.IP Args: 4
.RS
.IP attName 8
An attribute name.
.RE
.LP
Given an attribute name, return its type.
If 'attName' does not exist, then return -1.
.Fn getAttrPutFunc
.Cs
void (*getAttrPutFunc(char *attName))()
.Ce
.IP Args: 4
.RS
.IP attName 8
An attribute name.
.RE
.LP
Given an attribute name, return its CNodePut() function.
If 'attName' does not exist, then return NULL.
.Fn getStaticAttrAtIndex
.Cs
char *getStaticAttrAtIndex(int index, int *type, void (**putfunc)())
.Ce
.IP Args: 4
.RS
.IP index 8
An index value to the static_attrinfo_map array.
.IP type 8
Type of the attribute.
.IP putfunc 8
CNodePut() function of the attribute described by 'attName'.
.RE
.LP
Looks into the static_attrinfo_map[] array and return the name, type and putfunc
information of the entry at 'index'.
.Fn getDynamicAttrAtIndex
.Cs
char *getDynamicAttrAtIndex(int index, int *type, void (**putfunc)())
.Ce
.IP Args: 4
.RS
.IP index 8
An index value to the dynamic_attrinfo_map array.
.IP type 8
Type of the attribute.
.IP putfunc 8
CNodePut() function of the attribute described by 'attName'.
.RE
.LP
Looks into the dynamic_attrinfo_map[] array and return the name, type and
putfunc information of the entry at 'index'.
.Fn attrInfoMapPrint
.Cs
void attrInfoMapPrint(void)
.Ce
.LP
Prints out the entries of the static_attrinfo_map and dynamic_attrinfo_map.
.Fn addRes
.Cs
int addRes(char *archType, char *nodeAttr, char *hostQuery)
.Ce
.IP Args: 4
.RS
.IP archType 11
A class type of the resource (could be a node name or os type) 
.IP nodeAttr 11
A node attribute (or even CNodeGet function)
.IP hostQuery 11
A query string to send to a MOM.
.RE
.LP
Adds a 3-type (archType, nodeAttr, hostQuery) into the internal Res table.
If (archType, nodeAttr, ...) is duplicated, then only the hostQuery portion
is updated.
.Fn findResPtrGivenNodeAttr
.Cs
static int findResPtrGivenNodeAttr(struct Resource **resptrs, char *nodeAttr)
.Ce
.IP Args: 4
.RS
.IP resptrs 8
Ptr to a table of Resource pointers.
.IP nodeAttr 8
A node attribute (or even CNodeGet function)
.RE
.LP
Returns the index to resptrs that contain 'nodeAttr'. Otherwise, -1 is returned.
.Fn getResPtr
.Cs
static struct Resource **getResPtr(char *archType, char *nodeAttr)
.Ce
.IP Args: 4
.RS
.IP archType 11
A class type of a resource (could be a node name or os type)
.IP nodeAttr 11
A node attribute (or even CNodeGet function)
.RE
.LP
Returns an array of pointers to the internal Resource table, Res containing
entries that match (archType, nodeAttr,,) with a non-NULLSTR or non-""
entry for hostQuery_keyword. This will also match any "*" entry for 'archType.
.Fn getNodeAttrGivenResPtr
.Cs
char *getNodeAttrGivenResPtr(struct Resource *resptr)
.Ce
.IP Args: 4
.RS
.IP resptr 8
A pointer to a struct Resource entry.
.RE
.LP
Returns 'nodeAttr' value of the entry pointed to by 'resptr'.
.Fn getHostQueryKeywordGivenResPtr
.Cs
char *getHostQueryKeywordGivenResPtr(struct Resource *resptr)
.Ce
.IP Args: 4
.RS
.IP resptr 8
A pointer to a struct Resource entry.
.RE
.LP
Returns 'hostQuery_keyword' value of the entry pointed to by 'resptr'.
.Fn ResPrint
.Cs
void ResPrint(void)
.Ce
.LP
Prints out the entries of the internal Resource table, Res.
.Fn ResFree
.Cs
void ResFree(void)
.Ce
.LP
Free up all malloc-ed storage associated with the internal Resource table
Res.
.LP
.NH 4
.Tc Job
.LP
The source code found under the
.Ar Job
subdirectory
contains data structures and functions that are used by the Job abstraction.
The files involved are af_job.h and af_job.c. The
main data structures used are:
.nf
.Ty
  struct job_struct {
    char *jobId; 
    char *jobName;
    char *ownerName; 
    char *effectiveUserName;  /* username to execute job under */
    char *effectiveGroupName; /* group to execute job under */ 
    int  state;
    int  priority;
    int  rerunFlag;          /* rerunnable attribute */
    int  interactiveFlag;    /* is job interactive ? */
    DateTime dateTimeCreated;
    char *emailAddr;         /* for notification of job status */
    char *stageinFiles;
    char *stageoutFiles;
    struct IntRes *intResReq;
    struct SizeRes *sizeResReq;
    struct StringRes *stringResReq;
    struct IntRes *intResUse;
    struct SizeRes *sizeResUse;
    struct StringRes *stringResUse;
    void   *server;         /* needed in order to run a job; need to */
                            /* instruct the appropriate server to run */
                            /* the job it owns */
    void    *queue;         /* needed in order to accumulate */
                            /* certain Que resources based on */
                            /* resource value for job. */
	
    int    refCnt;          /* # of link references to this struct - only */
                            /* used to determine if this job struct should be */
                            /* freed */
  };
  typedef struct job_struct Job;

  struct SetJobElement {
    struct SetJobElement *nextptr;
    struct SetJobElement *first; /* pointer to the first element in Set */
  };

  struct setJob_struct {
    struct SetJobElement  *head;
    struct SetJobElement  *tail; /* non-NULL tail */
  };
  typedef struct setJob_struct SetJob;
.fi
.NH 5
.Fi af_job.c 
.Fn JobIdGet
.Cs
char *JobIdGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'jobId' attribute value of 'job'.
.Fn JobNameGet
.Cs
char *JobNameGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'jobName' attribute value of 'job'.
.Fn JobOwnerNameGet
.Cs
char *JobOwnerNameGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'ownerName' attribute value of 'job'.
.Fn JobEffectiveUserNameGet
.Cs
char *JobEffectiveUserNameGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'effectiveUserName' attribute value of 'job'.
.Fn JobEffectiveGroupNameGet
.Cs
char *JobEffectiveGroupNameGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'effectiveGroupName' attribute value of 'job'.
.Fn JobStateGet
.Cs
int JobStateGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'state' attribute value of 'job'.
.Fn JobPriorityGet
.Cs
int JobPriorityGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'priority' attribute value of 'job'.
.Fn JobRerunFlagGet
.Cs
int JobRerunFlagGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'rerunFlag' attribute value of 'job'.
.Fn JobInteractiveFlagGet
.Cs
int JobInteractiveFlagGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'interactiveFlag' attribute value of 'job'.
.Fn JobDateTimeCreatedGet
.Cs
DateTime JobDateTimeCreatedGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'dateTimeCreated' attribute value of 'job'.
.Fn JobEmailAddrGet
.Cs
char *JobEmailAddrGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'emailAddr' attribute value of 'job'.
.Fn JobServerGet
.Cs
void *JobServerGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'server' attribute value of 'job'.
.Fn JobRefCntGet
.Cs
int JobRefCntGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'refCnt' attribute value of 'job'.
.Fn JobStageinFilesGet
.Cs
char *JobStageinFilesGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'stageinFiles' attribute value of 'job'.
.Fn JobStageoutFilesGet
.Cs
char *JobStageoutFilesGet(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Returns 'stageoutFiles' attribute value of 'job'.
.Fn JobIntResReqGet
.Cs
int JobIntResReqGet(Job *job, char *name)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.RE
.LP
Returns 'intResReq->name' attribute value of 'job'.
.Fn JobSizeResReqGet
.Cs
Size JobSizeResReqGet(Job *job, char *name)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.RE
.LP
Returns 'sizeResReq->name' attribute value of 'job'.
.Fn JobStringResReqGet
.Cs
char *JobStringResReqGet(Job *job, char *name)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.RE
.LP
Returns 'stringResReq->name' attribute value of 'job'.
.Fn JobIntResUseGet
.Cs
int JobIntResUseGet(Job *job, char *name)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.RE
.LP
Returns 'intResUse->name' attribute value of 'job'.
.Fn JobSizeResUseGet
.Cs
Size JobSizeResUseGet(Job *job, char *name)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.RE
.LP
Returns 'sizeResUse->name' attribute value of 'job'.
.Fn JobStringResUseGet
.Cs
char *JobStringResUseGet(Job *job, char *name)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.RE
.LP
Returns 'stringResUse->name' attribute value of 'job'.
.Fn JobIdPut
.Cs
void JobIdPut(Job *job, char *jobId)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP jobId 8
A job id.
.RE
.LP
Set job->jobId attribute value to 'jobId'.
.Fn JobNamePut
.Cs
void JobNamePut(Job *job, char *jobName)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP jobName 8
A job name.
.RE
.LP
Set job->jobName attribute value to 'jobName'.
.Fn JobOwnerNamePut
.Cs
void JobOwnerNamePut(Job *job, char *ownerName)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP ownerName 8
A job's ownername.
.RE
.LP
Set job->jobOwner attribute value to 'ownerName'.
.Fn JobEffectiveUserNamePut
.Cs
void JobEffectiveUserNamePut(Job *job, char *euser)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP ownerName 8
A job's effective username.
.RE
.LP
Set job->effectiveUserName attribute value to 'euser'.
.Fn JobEffectiveGroupNamePut
.Cs
void JobEffectiveGroupNamePut(Job *job, char *groupName)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP groupName 8
A job's effective groupname.
.RE
.LP
Set job->effectiveGroupName attribute value to 'groupName'.
.Fn JobStatePut
.Cs
void JobStatePut(Job *job, int state)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP state 8
A job's state.
.RE
.LP
Set job->state attribute value to 'state'.
.Fn JobPriorityPut
.Cs
void JobPriorityPut(Job *job, int priority)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP priority 8
A job's priority.
.RE
.LP
Set job->priority attribute value to 'priority'.
.Fn JobRerunFlagPut
.Cs
void JobRerunFlagPut(Job *job, int rerunFlag)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP rerunFlag 8
A job's priority.
.RE
.LP
Set job->rerunFlag attribute value to 'rerunFlag'.
.Fn JobInteractiveFlagPut
.Cs
void JobRerunFlagPut(Job *job, int interactiveFlag)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP interactiveFlag 8
Is job interactive?
.RE
.LP
Set job->interactiveFlag attribute value to 'interactiveFlag'.
.Fn JobDateTimeCreatedPut
.Cs
void JobDateTimeCreatedPut(Job *job, DateTime cdate)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP interactiveFlag 8
Is job interactive?
.RE
.LP
Set job->dateTimeCreated attribute value to 'cdate'.
.Fn JobEmailAddrPut
.Cs
void JobEmailAddrPut(Job *job, char *emailAddr)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP emailAddr 8
Email address to notify of job status.
.RE
.LP
Set job->emailAddr attribute value to 'emailAddr'.
.Fn JobServerPut
.Cs
void JobServerPut(Job *job, void *server)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP server 8
Server owner of the job.
.RE
.LP
Set job->server attribute value to 'server'.
.Fn JobRefCntPut
.Cs
void JobRefCntPut(Job *job, int refCnt)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP refCnt 8
# of link references to the Job struct.
.RE
.LP
Set job->refCnt attribute value to 'refCnt'.
.Fn JobStageinFilesPut
.Cs
void JobStageinFilesPut(Job *job, char *stagein)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP stagein 8
The list of files to stagein. 
.RE
.LP
Set job->stageinFiles attribute value to 'stagein'.
.Fn JobStageoutFilesPut
.Cs
void JobStageoutFilesPut(Job *job, char *stageout)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP stageout 8
The list of files to stageout. 
.RE
.LP
Set job->stageoutFiles attribute value to 'stageout'.
.Fn JobIntResReqPut
.Cs
void JobIntResReqPut(Job *job, char *name, int value)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.IP value 8
A resource value.
.RE
.LP
Set intResReq->name attribute value of 'job' to 'value'.
.Fn JobSizeResReqPut
.Cs
void JobSizeResReqPut(Job *job, char *name, Size value)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.IP value 8
A resource value.
.RE
.LP
Set sizeResReq->name attribute value of 'job' to 'value'.
.Fn JobStringResReqPut
.Cs
void JobStringResReqPut(Job *job, char *name, char *value)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.IP value 8
A resource value.
.RE
.LP
Set stringResReq->name attribute value of 'job' to 'value'.
.Fn JobIntResUsePut
.Cs
void JobIntResUsePut(Job *job, char *name, int value)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.IP value 8
A resource value.
.RE
.LP
Set intResUse->name attribute value of 'job' to 'value'.
.Fn JobSizeResUsePut
.Cs
void JobSizeResUsePut(Job *job, char *name, Size value)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.IP value 8
A resource value.
.RE
.LP
Set sizeResUse->name attribute value of 'job' to 'value'.
.Fn JobStringResUsePut
.Cs
void JobStringResUsePut(Job *job, char *name, char *value)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP name 8
A resource name.
.IP value 8
A resource value.
.RE
.LP
Set stringResUse->name attribute value of 'job' to 'value'.
.Fn JobInit
.Cs
void JobInit(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Initialize the members of the Job object to consistent values.
.Fn JobPrint
.Cs
void JobPrint(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Prints out the values to the members of the 'job'.
.Fn JobFree
.Cs
void JobFree(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.RE
.LP
Frees up malloc-ed areas associated with 'job'.
.Fn SetJobInit
.Cs
void SetJobInit(SetJob *sjob)
.Ce
.IP Args: 4
.RS
.IP sjob 8
A pointer to a set of jobs.
.RE
.LP
Initializes the set of jobs, 'sjob', adding a NOJOB end of list record, and
forcing the head and tail pointers to point to this end record.
.Fn SetJobAdd
.Cs
void SetJobAdd(SetJob *sjob, Job *job)
.Ce
.IP Args: 4
.RS
.IP sjob 8
A pointer to a set of jobs.
.IP job 8
A pointer to a Job object.
.RE
.LP
Adds 'job' to the set of jobs pointed to by 'sjob'.
.Fn SetJobUpdateFirst
.Cs
void SetJobUpdateFirst(SetJob *sjob, struct SetJobElement *first)
.Ce
.IP Args: 4
.RS
.IP sjob 8
A pointer to a set of jobs.
.IP first 8
A pointer to  a set of jobs element.
.RE
.LP
Go through each element of 'sjob' and update each one's first attribute value
to 'first'.
.Fn SetJobRemove
.Cs
void SetJobRemove(SetJob *sjob, Job *job)
.Ce
.IP Args: 4
.RS
.IP sjob 8
A pointer to a set of jobs.
.IP job 8
A pointer to  a Job object.
.RE
.LP
Delete 'job' from the set of jobs, 'sjob'. The 'job' itself is malloc
freed if its refCnt is 0.
.Fn SetJobFree
.Cs
void SetJobFree(SetJob *sjob)
.Ce
.IP Args: 4
.RS
.IP sjob 8
A pointer to a set of jobs.
.RE
.LP
Free up all malloc-ed areas associated with 'sjob'.
.Fn SetJobPrint
.Cs
void SetJobPrint(struct SetJobElement *sje)
.Ce
.IP Args: 4
.RS
.IP sje 8
A pointer to a set of jobs element.
.RE
.LP
Prints out the members of 'sje'.
.Fn inSetJob
.Cs
int inSetJob(Job *job, struct SetJobElement *sje)
.Ce
.IP Args: 4
.RS
.IP job 8
A pointer to a Job object.
.IP sje 8
A pointer to a set of jobs element.
.RE
.LP
Returns TRUE or FALSE depending on whether or not 'job' is in 'sje'.
.Fn strToJobState
.Cs
int strToJobState(char *val)
.Ce
.IP Args: 4
.RS
.IP val 8
A string containing: "Q", "R", "T", "H", "E", "W", "D"
.RE
.LP
Returns the following:
         string          value
         ------          -----------
         "Q"             QUEUED
         "R"             RUNNING
         "T"             TRANSIT
         "H"             HELD
         "E"             EXITING
         "W"             WAITING
         "D"             DELETED
.Fn firstJobPtr
.Cs
void firstJobPtr(struct SetJobElement **sjeptr, struct SetJobElement *first)
.Ce
.IP Args: 4
.RS
.IP sjeptr 8
pointer to a pointer to a set of Jobs.
.IP sje 8
A pointer to a Job element.
.RE
.LP
Updates the *sjeptr to "first", and then continues to reassign the value of
*sjeptr to *sjeptr->nextptr until encountering a non-DELETED Job record.
.Fn nextJobPtr
.Cs
void nextJobPtr(struct SetJobElement **sjeptr)
.Ce
.IP Args: 4
.RS
.IP sjeptr 8
pointer to a pointer to a set of Jobs.
.RE
.LP
Updates the *sjeptr to *sjeptr->nextptr, and then continues to reassign the
value until encountering a non-DELETED Job record. 
.Fn JobPartition
.Cs
int JobPartition(struct JobSortArgs *A, int p, int r)
.Ce
.IP Args: 4
.RS
.IP A 8
stuff of information needed to reorder the elements of a set of Jobs. 
.IP p 8
the "leftmost" element of a set of Jobs.
.IP r 8
the "rightmost" element of a set of Jobs. 
.RE
.LP
This is the Partition() function in the well-known Quicksort() sorting
algorithm. (see "Introduction to Algorithms" by Cormen, et al) pp. 153-156).
.Fn JobQuickSort
.Cs
void JobQuickSort (struct JobSortArgs *A, int p, int r)
.Ce
.IP Args: 4
.RS
.IP A 8
stuff of information needed to reorder the elements of a set of Jobs. 
.IP p 8
the "leftmost" element of a set of Jobs.
.IP r 8
the "rightmost" element of a set of Jobs. 
.RE
.LP
This is the Quicksort() function in the well-known quicksort sorting
algorithm. (see "Introduction to Algorithms" by Cormen, et al) pp. 153-156).
.Fn SetJobSortInt
.Cs
int SetJobSortInt (struct SetJobElement *sje, int (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Jobs to reorder.
.IP key 8
the function to apply to each member of the set of Jobs whose int value
will be used to reorder the set of Jobs.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Jobs in a dynamic array, and then run
JobQuicksort() function on the array, which also rearranges the pointers
representing the set of Jobs.
.Fn SetJobSortStr
.Cs
int SetJobSortStr (struct SetJobElement *sje, char *(*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Jobs to reorder.
.IP key 8
the function to apply to each member of the set of Jobs whose char*
 value will be used to reorder the set of Jobs.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Jobs in a dynamic array, and then run
JobQuicksort() function on the array, which also rearranges the pointers
representing the set of Jobs.
.Fn SetJobSortDateTime
.Cs
int SetJobSortDateTime (struct SetJobElement *sje, DateTime (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Jobs to reorder.
.IP key 8
the function to apply to each member of the set of Jobs whose DateTime value
will be used to reorder the set of Jobs.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Jobs in a dynamic array, and then run
JobQuicksort() function on the array, which also rearranges the pointers
representing the set of Jobs.
.Fn SetJobSortSize
.Cs
int SetJobSortSize (struct SetJobElement *sje, Size (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Jobs to reorder.
.IP key 8
the function to apply to each member of the set of Jobs whose Size value
will be used to reorder the set of Jobs.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Jobs in a dynamic array, and then run
JobQuicksort() function on the array, which also rearranges the pointers
representing the set of Jobs.
.Fn SetJobSortFloat
.Cs
int SetJobSortFloat (struct SetJobElment *sje, double (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of CNodes to reorder.
.IP key 8
the function to apply to each member of the set of Jobs whose double value
will be used to reorder the set of Jobs.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Jobs in a dynamic array, and then run
JobQuicksort() function on the array, which also rearranges the pointers
representing the set of Jobs.
.LP
.NH 4
.Tc Que
.LP
The source code found under the
.Ar Que 
subdirectory
contains data structures and functions that are used by the Que abstraction.
The files involved are af_que.h and af_que.c. The main data structures used
are:
.nf
.Ty
  struct que_struct {
    struct que_struct *nexptr; /* to maintain a list of ques */
    char *name;                /* name of a queue */ 
    int  type;                 /* type of queue: execution or routing */
    int  numJobs;
    int  priority;            /* priority of this queue against all other */
                              /* queues */
    int  maxRunJobs;          /* maximum # of jobs allowed to be selected */
                              /* from this queue */
    int  maxRunJobsPerUser;
    int  maxRunJobsPerGroup;
    int  state;               /* can jobs from this queue be scheduled for */
                              /* execution? */
    struct IntRes *intResAvail;
    struct IntRes *intResAssign;
    struct SizeRes *sizeResAvail;
    struct SizeRes *sizeResAssign;
    struct StringRes *stringResAvail;
    struct StringRes *stringResAssign;
    SetJob jobs;             /* pointer to head of the job */
  };
  typedef struct que_struct Que;

  struct SetQue_type {
    Que *head;
    Que *tail;
  };
  typedef struct SetQue_type SetQue;
.fi
.NH 5
.Fi af_que.c 
.Fn QueNameGet
.Cs
char *QueNameGet(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Returns 'name' attribute value of 'que'.
.Fn QueTypeGet
.Cs
int QueTypeGet(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Returns 'type' attribute value of 'que'.
.Fn QueNumJobsGet
.Cs
int QueNumJobsGet(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Returns 'numJobs' attribute value of 'que'.
.Fn QuePriorityGet
.Cs
int QuePriorityGet(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Returns 'priority' attribute value of 'que'.
.Fn QueMaxRunJobsGet
.Cs
int QueMaxRunJobsGet(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Returns 'maxRunJobs' attribute value of 'que'.
.Fn QueMaxRunJobsPerUserGet
.Cs
int QueMaxRunJobsPerUserGet(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Returns 'maxRunJobsPerUser' attribute value of 'que'.
.Fn QueMaxRunJobsPerGroupGet
.Cs
int QueMaxRunJobsPerGroupGet(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Returns 'maxRunJobsPerGroup' attribute value of 'que'.
.Fn QueStateGet
.Cs
int QueStateGet(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Returns 'state' attribute value of 'que'.
.Fn QueIntResAvailGet
.Cs
int QueIntResAvailGet(Que *que, char *name)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.RE
.LP
Returns 'intResAvail->name' attribute value of 'que'.
.Fn QueIntResAssignGet
.Cs
int QueIntResAssignGet(Que *que, char *name)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.RE
.LP
Returns 'intResAssign->name' attribute value of 'que'.
.Fn QueSizeResAvailGet
.Cs
Size QueSizeResAvailGet(Que *que, char *name)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.RE
.LP
Returns 'sizeResAvail->name' attribute value of 'que'.
.Fn QueSizeResAssignGet
.Cs
Size QueSizeResAssignGet(Que *que, char *name)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.RE
.LP
Returns 'sizeResAssign->name' attribute value of 'que'.
.Fn QueStringResAvailGet
.Cs
char *QueStringResAvailGet(Que *que, char *name)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.RE
.LP
Returns 'stringResAvail->name' attribute value of 'que'.
.Fn QueStringResAssignGet
.Cs
char *QueStringResAssignGet(Que *que, char *name)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.RE
.LP
Returns 'stringResAssign->name' attribute value of 'que'.
.Fn QueJobsGet
.Cs
SetJobElement *QueJobsGet(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Returns 'jobs.head' attribute value of 'que'.
.Fn QueNamePut
.Cs
void QueNamePut(Que *que, char *queue_name)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP queue_name 8
A new queue name.
.RE
.LP
Sets the 'name' attribute value to 'queue_name'.
.Fn QueNumJobsPut
.Cs
void QueNumJobsPut(Que *que, int numJobs)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP numJobs 8
The # of PBS jobs.
.RE
.LP
Sets the 'numJobs' attribute value to 'numJobs'.
.Fn QueMaxRunJobsPut
.Cs
void QueMaxRunJobsPut(Que *que, int maxRunJobs)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP maxRunJobs 8
Some # of PBS jobs.
.RE
.LP
Sets the 'maxRunJobs' attribute value to 'maxRunJobs'.
.Fn QueMaxRunJobsPerUserPut
.Cs
void QueMaxRunJobsPerUserPut(Que *que, int maxRunJobsPerUser)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP maxRunJobsPerUser 8
Some # of PBS jobs.
.RE
.LP
Sets the 'maxRunJobsPerUser' attribute value to 'maxRunJobsPerUser'.
.Fn QueMaxRunJobsPerGroupPut
.Cs
void QueMaxRunJobsPerGroupPut(Que *que, int maxRunJobsPerGroup)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP maxRunJobsPerGroup 8
Some # of PBS jobs.
.RE
.LP
Sets the 'maxRunJobsPerGroup' attribute value to 'maxRunJobsPerGroup'.
.Fn QuePriorityPut
.Cs
void QuePriorityPut(Que *que, int priority)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP priority 8
Priority value of queue against all other queues. 
.RE
.LP
Sets the 'priority' attribute value of 'que' to 'priority'.
.Fn QueStatePut
.Cs
void QueStatePut(Que *que, int state)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP state 8
State of queue. 
.RE
.LP
Sets the 'state' attribute value of 'que' to 'state'.
.Fn QueIntResAvailPut
.Cs
void QueIntResAvailPut(Que *que, char *name, int value)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.IP value 8
New resource value.
.RE
.LP
Sets the 'intResAvail->name' attribute value of 'que' to 'value'.
.Fn QueIntResAssignPut
.Cs
void QueIntResAssignPut(Que *que, char *name, int value)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.IP value 8
New resource value.
.RE
.LP
Sets the 'intResAssign->name' attribute value of 'que' to 'value'.
.Fn QueSizeResAvailPut
.Cs
void QueSizeResAvailPut(Que *que, char *name, Size value)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.IP value 8
New resource value.
.RE
.LP
Sets the 'sizeResAvail->name' attribute value of 'que' to 'value'.
.Fn QueSizeResAssignPut
.Cs
void QueSizeResAssignPut(Que *que, char *name, Size value)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.IP value 8
New resource value.
.RE
.LP
Sets the 'sizeResAssign->name' attribute value of 'que' to 'value'.
.Fn QueStringResAvailPut
.Cs
void QueStringResAvailPut(Que *que, char *name, char *value)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.IP value 8
New resource value.
.RE
.LP
Sets the 'stringResAvail->name' attribute value of 'que' to 'value'.
.Fn QueStringResAssignPut
.Cs
void QueStringResAssignPut(Que *que, char *name, char *value)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP name 8
A resource name.
.IP value 8
New resource value.
.RE
.LP
Sets the 'stringResAssign->name' attribute value of 'que' to 'value'.
.Fn QueInit
.Cs
void QueInit(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Initialize the members of 'que' to have consistent values.
.Fn QuePrint
.Cs
void QuePrint(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Prints out the members of the Que structure.
.Fn QueFree
.Cs
void QueFree(Que *que)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.RE
.LP
Frees up malloc-ed areas associated with 'que'.
.Fn QueJobInsert
.Cs
void QueJobInsert(Que *que, Job *job)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP job 8
A pointer to a Job object.
.RE
.LP
Insert 'job' into the set of jobs pool of 'que'.
.Fn QueJobDelete
.Cs
void QueJobDelete(Que *que, Job *job)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP job 8
A pointer to a Job object.
.RE
.LP
Deletes 'job' from the set of jobs pool of 'que'.
.Fn intExpr
.Cs
static Job *intExpr(Job *j, Que *q, int (*func)(), Comp operator,
                               int value, Job **maxj, Job **minj)
.Ce
.IP Args: 4
.RS
.IP j 8
A pointer to a Job object.
.IP que 8
A pointer to a Que object.
.IP func 8
A pointer to a function returning an integer value.
.IP operator 8
A compare operator: OP_EQ, OP_NEQ, OP_GT, OP_GE, OP_LE, OP_LT, OP_MAX, OP_MIN. 
.IP value 8
Some integer value.
.IP maxj 8
Holder of a return max Job value.
.IP minj 8
Holder of a return min Job value.
.RE
.LP
Runs a "func(j)  operator value" and if it returns TRUE, then return j.
Otherwise, the return value is NOJOB.
If operator is OP_MAX, or OP_MIN, then run func() on each job in q,
saving in maxj the job with the largest return value, or saving in minj the
job with the minimum return value. 
.Fn strExpr
.Cs
static Job *strExpr(Job *j, Que *q, char *(*strfunc)(), Comp operator,
                               char *valuestr, Job **maxj, Job **minj)
.Ce
.IP Args: 4
.RS
.IP j 8
A pointer to a Job object.
.IP que 8
A pointer to a Que object.
.IP strfunc 8
A pointer to a function returning a string value.
.IP operator 8
A compare operator: OP_EQ, OP_NEQ, OP_GT, OP_GE, OP_LE, OP_LT, OP_MAX, OP_MIN
.IP valuestr 8
Some string value.
.IP maxj 8
Holder of a return max Job value.
.IP minj 8
Holder of a return min Job value.
.RE
.LP
Runs a "strfunc(j)  operator strvalue" and if it returns TRUE, then return j.
Otherwise, the return value is NOJOB.
If operator is OP_MAX, or OP_MIN, then run strfunc() on each job in q,
saving in maxj the job with the lexicographically largest return value, or
saving in minj the job with the lexicographically minimum return value. 
.Fn dateTimeExpr
.Cs
static Job *dateTimeExpr(Job *j, Que *q, DateTime *(*datetfunc)(),
                         Comp operator, DateTime datet, Job **maxj, Job **minj)
.Ce
.IP Args: 4
.RS
.IP j 8
A pointer to a Job object.
.IP que 8
A pointer to a Que object.
.IP datetfunc 8
A pointer to a function returning a DateTime value.
.IP operator 8
A compare operator: OP_EQ, OP_NEQ, OP_GT, OP_GE, OP_LE, OP_LT, OP_MAX, OP_MIN
.IP datet 8
Some DateTime value.
.IP maxj 8
Holder of a return max Job value.
.IP minj 8
Holder of a return min Job value.
.RE
.LP
Runs a "datetfunc(j)  operator datet" and if it returns TRUE, then return j.
Otherwise, the return value is NOJOB.
If operator is OP_MAX, or OP_MIN, then run datetfunc() on each job in q,
saving in maxj the job with the largest return value, or saving in minj the job
with the minimum return value. 
.Fn sizeExpr
.Cs
static Job *sizeExpr(Job *j, Que *q, Size (*sizefunc)(),
                         Comp operator, Size size, Job **maxj, Job **minj)
.Ce
.IP Args: 4
.RS
.IP j 8
A pointer to a Job object.
.IP que 8
A pointer to a Que object.
.IP sizefunc 8
A pointer to a function returning a Size value.
.IP operator 8
A compare operator: OP_EQ, OP_NEQ, OP_GT, OP_GE, OP_LE, OP_LT, OP_MAX, OP_MIN
.IP size 8
Some Size value.
.IP maxj 8
Holder of a return max Job value.
.IP minj 8
Holder of a return min Job value.
.RE
.LP
Runs a "sizefunc(j)  operator size" and if it returns TRUE, then return j.
Otherwise, the return value is NOJOB.
If operator is OP_MAX, or OP_MIN, then run sizefunc() on each job in q,
saving in maxj the job with the largest return value, or saving in minj the job
with the minimum return value. 
.Fn QueJobFindInt
.Cs
Job *QueJobFindInt(Que *que, ...)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP ... 8
Variable list of arguments,  could be: int (*func)(), Comp operator, int value.
.RE
.LP
This is basically the front end (user interface) to intExpr().
.Fn QueJobFindStr
.Cs
Job *QueJobFindStr(Que *que, ...)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP ... 8
Variable list of arguments,  could be: char *(*strfunc)(), Comp operator,
char *valuestr.
.RE
.LP
This is basically the front end (user interface) to strExpr().
.Fn QueJobFindDateTime
.Cs
Job *QueJobFindDateTime(Que *que, ...)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP ... 8
Variable list of arguments,  could be  DateTime (*datefunc)(), Comp operator,
DateTime datet.
.RE
.LP
This is basically the front end (user interface) to dateTimeExpr().
.Fn QueJobFindSize
.Cs
Job *QueJobFindSize(Que *que, ...)
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP ... 8
Variable list of arguments,  could be  Size (*sizefunc)(), Comp operator,
Size size.
.RE
.LP
This is basically the front end (user interface) to sizeExpr().
.Fn QueFilterInt
.Cs
Que *QueFilterInt(Que *que, int (*func)(), Comp operator, int value) 
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP func 8
A pointer to a function returning an integer value.
.IP operator 8
A compare operator: OP_EQ, OP_NEQ, OP_GT, OP_GE, OP_LE, OP_LT, OP_MAX, OP_MIN. 
.IP value 8
Some integer value.
.RE
.LP
This is another front end (user interface) to intExpr(), but this creates
a new queue of jobs that satisfy "func(job) operator value" expression for
each job in 'que'.
.Fn QueFilterStr
.Cs
Que *QueFilterStr(Que *que, char *(*strfunc)(), Comp operator, char *valuestr) 
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP strfunc 8
A pointer to a function returning a string value.
.IP operator 8
A compare operator: OP_EQ, OP_NEQ, OP_GT, OP_GE, OP_LE, OP_LT, OP_MAX, OP_MIN. 
.IP valuestr 8
Some string value.
.RE
.LP
This is another front end (user interface) to strExpr(), but this creates
a new queue of jobs that satisfy "strfunc(job) operator valuestr" expression for
each job in 'que'.
.Fn QueFilterDateTime
.Cs
Que *QueFilterDateTime(Que *que, DateTime (*datefunc)(),
                          Comp operator, DateTime datet) 
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP datefunc 8
A pointer to a function returning a DateTime value.
.IP operator 8
A compare operator: OP_EQ, OP_NEQ, OP_GT, OP_GE, OP_LE, OP_LT, OP_MAX, OP_MIN. 
.IP datet 8
Some DateTime value.
.RE
.LP
This is another front end (user interface) to dateTimeExpr(), but this creates
a new queue of jobs that satisfy "datefunc(job) operator datet" expression for
each job in 'que'.
.Fn QueFilterSize
.Cs
Que *QueFilterSize(Que *que, Size (*sizefunc)(),
                          Comp operator, Size size) 
.Ce
.IP Args: 4
.RS
.IP que 8
A pointer to a Que object.
.IP sizefunc 8
A pointer to a function returning a Size value.
.IP operator 8
A compare operator: OP_EQ, OP_NEQ, OP_GT, OP_GE, OP_LE, OP_LT, OP_MAX, OP_MIN. 
.IP size 8
Some Size value.
.RE
.LP
This is another front end (user interface) to sizeExpr(), but this creates
a new queue of jobs that satisfies "sizefunc(job) operator size" expression for
each job in 'que'.
.Fn SetQueInit
.Cs
void SetQueInit(SetQue *sq)
.Ce
.IP Args: 4
.RS
.IP sq 8
A pointer to a set of queues object.
.RE
.LP
Initializes 'sq' so that both head and tail of the list are pointing to NOQUE. 
.Fn SetQueAdd
.Cs
void SetQueAdd(SetQue *sq, Que *q)
.Ce
.IP Args: 4
.RS
.IP sq 8
A pointer to a set of queues object.
.IP q 8
New queue to add to the set.
.RE
.LP
Adds 'q' to the set of queues, 'sq'. Malloc table is updated since 'q' is a
malloc-ed area.
.Fn SetQueFree
.Cs
void SetQueFree(SetQue *sq)
.Ce
.IP Args: 4
.RS
.IP sq 8
A pointer to a set of queues object.
.RE
.LP
Frees up all storage associated with 'sq' and then re-initializes it.
.Fn SetQueFindQueByName
.Cs
Que *SetQueFindQueByName(SetQue *sq, char *queue_name)
.Ce
.IP Args: 4
.RS
.IP sq 8
A pointer to a set of queues object.
.IP queue_name 8
A name of a queue to search for.
.RE
.LP
Returns the que in 'sq' whose  name is 'queue_name'.
.Fn SetQuePrint
.Cs
void SetQuePrint(SetQue *sq)
.Ce
.IP Args: 4
.RS
.IP sq 8
A pointer to a set of queues object.
.RE
.LP
Prints out the elements in the set of queues, 'sq'.
.Fn inSetQue
.Cs
int inSetQue(Que *que, SetQue *sq)
.Ce
.IP Args: 4
.RS
.IP que 8
A queue to search for.
.IP sq 8
A pointer to a set of queues object.
.RE
.LP
Returns 1 if 'que' is a member of 'sq'; 0 otherwise.
.Fn QuePartition
.Cs
int QuePartition(struct QueSortArgs *A, int p, int r)
.Ce
.IP Args: 4
.RS
.IP A 8
stuff of information needed to reorder the elements of a set of Ques. 
.IP p 8
the "leftmost" element of a set of Ques.
.IP r 8
the "rightmost" element of a set of Ques. 
.RE
.LP
This is the Partition() function in the well-known Quicksort() sorting
algorithm. (see "Introduction to Algorithms" by Cormen, et al) pp. 153-156).
.Fn QueQuickSort
.Cs
void QueQuickSort (struct QueSortArgs *A, int p, int r)
.Ce
.IP Args: 4
.RS
.IP A 8
stuff of information needed to reorder the elements of a set of Ques.
.IP p 8
the "leftmost" element of a set of Ques.
.IP r 8
the "rightmost" element of a set of Ques. 
.RE
.LP
This is the Quicksort() function in the well-known quicksort sorting
algorithm. (see "Introduction to Algorithms" by Cormen, et al) pp. 153-156).
.Fn SetQueSortInt
.Cs
int SetQueSortInt (SetQue *s, int (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Ques to reorder.
.IP key 8
the function to apply to each member of the set of Ques whose int value
will be used to reorder the set of Ques.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Ques in a dynamic array, and then run
QueQuicksort() function on the array, which also rearranges the pointers
representing the set of Ques.
.Fn SetQueSortStr
.Cs
int SetQueSortStr (SetQue *s, char *(*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Ques to reorder.
.IP key 8
the function to apply to each member of the set of Ques whose char*
 value will be used to reorder the set of Ques.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Ques in a dynamic array, and then run
QueQuicksort() function on the array, which also rearranges the pointers
representing the set of Ques.
.Fn SetQueSortDateTime
.Cs
int SetQueSortDateTime (SetQue *s, DateTime (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Jobs to reorder.
.IP key 8
the function to apply to each member of the set of Ques whose DateTime value
will be used to reorder the set of Ques.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Ques in a dynamic array, and then run
QueQuicksort() function on the array, which also rearranges the pointers
representing the set of Ques.
.Fn SetQueSortSize
.Cs
int SetQueSortSize (SetQue *s, Size (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Ques to reorder.
.IP key 8
the function to apply to each member of the set of Ques whose Size value
will be used to reorder the set of Ques.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Ques in a dynamic array, and then run
QueQuicksort() function on the array, which also rearranges the pointers
representing the set of Ques.
.Fn SetQueSortFloat
.Cs
int SetQueSortFloat (SetQue *s, double (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Ques to reorder.
.IP key 8
the function to apply to each member of the set of Ques whose double value
will be used to reorder the set of Ques.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Ques in a dynamic array, and then run
QueQuicksort() function on the array, which also rearranges the pointers
representing the set of Ques.
.LP
.NH 4
.Tc Server
.LP
The source code found under the
.Ar Server
subdirectory
contains data structures and functions that are used by the Server abstraction.
The files involved are af_server.h and af_server.c. The main data structures
used are:
.nf
.Ty
  struct server_struct {
    struct server_struct *nexptr; /* to maintain a list of servers */
    char *inetAddr;               /* hostname of the server */
    int  portNumberOneWay;   /* scheduler <-- server */
                             /* if set to 0, use PBS_SCHEDULER_SERVICE_PORT */
    int  portNumberTwoWay;   /* scheduler <-> server */
                             /* if set to 0, use PBS_BATCH_SERVICE_PORT_DIS */
    int  socket;             /* socket file descriptor */
    int  fdOneWay;           /* fd to use when only receiving messages from */
                             /* the Server */
    int  fdTwoWay;           /* fd to use when sending messages to and */
                             /* receiving messages from the Server. -1 if */
                             /* not connected. */
    int  state;
    int  maxRunJobs;         /* on this server */
    int  maxRunJobsPerUser;
    int  maxRunJobsPerGroup;
    char *defQue;           /* server's default queue */
    struct IntRes *intResAvail;
    struct IntRes *intResAssign;
    struct SizeRes *sizeResAvail;
    struct SizeRes *sizeResAssign;
    struct StringRes *stringResAvail;
    struct StringRes *stringResAssign;
    SetQue queues;         /* queues managed by the server */
    SetCNode nodes;
  };
  typedef struct server_struct Server;

  struct SetServer_type {
    Server *head;
    Server *localhost;
    Server *tail;
  };
  typedef struct SetServer_type SetServer;

  SetServer AllServers;   /* list of Servers known to the system */
.fi
.NH 5
.Fi af_server.h
.LP
In this file, the special structures
.Ty "node_alist, serv_alist, que_alist, job_alist"
hold the attribute values that will be queried from the Server.
.Ty "ServerAttrInfo"
hold the mappings for the job attribute names and Job*Put() functions.
.Ty "accumTable"
hold the list of resources that must be accumulated and Job*Put() functions.
.NH 5
.Fi af_server.c 
.Fn pbserror
.Cs
static char *pbserror(void)
.Ce
.LP
This returns the message string associated with the current value of the
global variable pbs_errno.
.Fn socket_to_conn
.Cs
static int socket_to_conn(int sock)
.Ce
.IP Args: 4
.RS
.IP sock 8
A socket number.
.RE
.LP
Updates some internal table to convert opened 'sock' into a connection.
.Fn get_4byte
.Cs
static int get_4byte(int sock, unsigned long *val)
.Ce
.IP Args: 4
.RS
.IP sock 8
A socket to read from.
.IP val 8
The return integer from socket.
.RE
.LP
Read and return a 4 byte integer from the network. Returns the (unsigned long)
integer in *val. The function return is 0 for EOF, +1 for success, or -1 if
error.
.Fn updateServerJobInfo
.Cs
static void updateServerJobInfo(Job *job, char *name, char *res, char *value)
.Ce
.IP Args: 4
.RS
.IP job 8
the job
.IP name 8
name of an attribute to update for job.
.IP res 8
name of a resource to update for job.
.IP value 8
new value of attribute, resource for job.
.RE
.LP
This function consults the ServerAttrInfo[] table for updating the appropriate
attribute,resource=value for Job.
.Fn inAccumTable
.Cs
int inAccumTable(char *resName)
.Ce
.IP Args: 4
.RS
.IP resName 8
name of a resource.
.RE
.LP
This function consults the accumTable[] and return TRUE if resName is in the
table; otherwise, returns FALSE.
.Fn accumRes
.Cs
int accumRes(Job *job)
.Ce
.IP Args: 4
.RS
.IP job 8
Pointer to a job structure.
.RE
.LP
This functions looks into the resources_required.* resources, and for any
resource name that is found in accumTable[], the corresponding values
for Server and Queue (those owning the job) are updated.
.Fn ServerInetAddrGet
.Cs
char *ServerInetAddrGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns inetAddr attribute value of 'server'.
.Fn ServerDefQueGet
.Cs
char *ServerDefQueGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns defQue attribute value of 'server'.
.Fn ServerSocketGet
.Cs
int ServerSocketGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns socket attribute value of 'server'.
.Fn ServerPortNumberOneWayGet
.Cs
int ServerPortNumberOneWayGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns portNumberOneWay attribute value of 'server'.
.Fn ServerPortNumberTwoWayGet
.Cs
int ServerPortNumberTwoWayGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns portNumberTwoWay attribute value of 'server'.
.Fn ServerFdTwoWayGet
.Cs
int ServerFdTwoWayGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns fdTwoWay attribute value of 'server'.
.Fn ServerFdOneWayGet
.Cs
int ServerFdOneWayGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns fdOneWay attribute value of 'server'.
.Fn ServerStateGet
.Cs
int ServerStateGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns state attribute value of 'server'.
.Fn ServerMaxRunJobsGet
.Cs
int ServerMaxRunJobsGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns maxRunJobs attribute value of 'server'.
.Fn ServerMaxRunJobsPerUserGet
.Cs
int ServerMaxRunJobsPerUserGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns maxRunJobsPerUser attribute value of 'server'.
.Fn ServerMaxRunJobsPerGroupGet
.Cs
int ServerMaxRunJobsPerGroupGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns maxRunJobsPerGroup attribute value of 'server'.
.Fn ServerQueuesGet
.Cs
int ServerQueuesGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns the pointer to server->queues attribute of 'server'.
.Fn ServerJobsGet
.Cs
int ServerJobsGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns the jobs.head value of 'server'.
.Fn ServerIntResAvailGet
.Cs
int ServerIntResAvailGet(Server *server, char *name)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
A resource name.
.RE
.LP
Returns intResAvail->name attribute value of 'server'.
.Fn ServerIntResAssignGet
.Cs
int ServerIntResAssignGet(Server *server, char *name)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
A resource name.
.RE
.LP
Returns intResAssign->name attribute value of 'server'.
.Fn ServerSizeResAvailGet
.Cs
Size ServerSizeResAvailGet(Server *server, char *name)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
A resource name.
.RE
.LP
Returns sizeResAvail->name attribute value of 'server'.
.Fn ServerSizeResAssignGet
.Cs
Size ServerSizeResAssignGet(Server *server, char *name)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
A resource name.
.RE
.LP
Returns sizeResAssign->name attribute value of 'server'.
.Fn ServerStringResAvailGet
.Cs
char *ServerStringResAvailGet(Server *server, char *name)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
A resource name.
.RE
.LP
Returns stringResAvail->name attribute value of 'server'.
.Fn ServerStringResAssignGet
.Cs
char *ServerStringResAssignGet(Server *server, char *name)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
A resource name.
.RE
.LP
Returns stringResAssign->name attribute value of 'server'.
.Fn ServerInetAddrPut
.Cs
void ServerInetAddrPut(Server *server, char *server_name)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP server_name 8
Name of the server.
.RE
.LP
Sets the inetAddr attribute value to 'server_name'.
.Fn ServerDefQuePut
.Cs
void ServerDefQuePut(Server *server, char *queue_name)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP server_name 8
Name of the default queue.
.RE
.LP
Sets the defQue attribute value to 'queue_name'.
.Fn ServerPortNumberOneWayPut
.Cs
void ServerPortNumberOneWayPut(Server *server, int port)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP port 8
Port number.
.RE
.LP
Sets the portNumberOneWay attribute value to 'port'.
.Fn ServerPortNumberTwoWayPut
.Cs
void ServerPortNumberTwoWayPut(Server *server, int port)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP port 8
Port number.
.RE
.LP
Sets the portNumberTwoWay attribute value to 'port'.
.Fn ServerSocketPut
.Cs
void ServerSocketPut(Server *server, int fd)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP fd 8
A file descriptor.
.RE
.LP
Sets the socket attribute value to 'fd'.
.Fn ServerFdTwoWayPut
.Cs
void ServerFdTwoWayPut(Server *server, int fd)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP fd 8
A file descriptor.
.RE
.LP
Sets the fdTwoWay attribute value to 'fd'.
.Fn ServerFdOneWayPut
.Cs
void ServerFdOneWayPut(Server *server, int fd)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP fd 8
A file descriptor.
.RE
.LP
Sets the fdOneWay attribute value to 'fd'.
.Fn ServerStatePut
.Cs
void ServerStatePut(Server *server, int state)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP state 8
A server state.
.RE
.LP
Sets the state attribute value of 'server' to 'state'.
.Fn ServerMaxRunJobsPut
.Cs
void ServerMaxRunJobsPut(Server *server, int maxRunJobs)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP maxRunJobs 8
# of jobs.
.RE
.LP
Sets the maxRunJobs attribute value of 'server' to 'maxRunJobs'.
.Fn ServerMaxRunJobsPerUserPut
.Cs
void ServerMaxRunJobsPerUserPut(Server *server, int maxRunJobsPerUser)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP maxRunJobsPerUser 8
# of jobs.
.RE
.LP
Sets the maxRunJobsPerUser attribute value of 'server' to 'maxRunJobsPerUser'.
.Fn ServerMaxRunJobsPerGroupPut
.Cs
void ServerMaxRunJobsPerGroupPut(Server *server, int maxRunJobsPerGroup)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP maxRunJobsPerGroup 8
# of jobs.
.RE
.LP
Sets the maxRunJobsPerGroup attribute value of 'server' to 'maxRunJobsPerGroup'.
.Fn ServerIntResAvailPut
.Cs
void ServerIntResAvailPut(Server *server, char *name, int value)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
Resource name.
.IP value 8
Resource value.
.RE
.LP
Sets the intResAvail->name attribute value of 'server' to 'value'.
.Fn ServerIntResAssignPut
.Cs
void ServerIntResAssignPut(Server *server, char *name, int value)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
Resource name.
.IP value 8
Resource value.
.RE
.LP
Sets the intResAssign->name attribute value of 'server' to 'value'.
.Fn ServerSizeResAvailPut
.Cs
void ServerSizeResAvailPut(Server *server, char *name, Size value)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
Resource name.
.IP value 8
Resource value.
.RE
.LP
Sets the sizeResAvail->name attribute value of 'server' to 'value'.
.Fn ServerSizeResAssignPut
.Cs
void ServerSizeResAssignPut(Server *server, char *name, Size value)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
Resource name.
.IP value 8
Resource value.
.RE
.LP
Sets the sizeResAssign->name attribute value of 'server' to 'value'.
.Fn ServerStringResAvailPut
.Cs
void ServerStringResAvailPut(Server *server, char *name, char *value)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
Resource name.
.IP value 8
Resource value.
.RE
.LP
Sets the stringResAvail->name attribute value of 'server' to 'value'.
.Fn ServerStringResAssignPut
.Cs
void ServerStringResAssignPut(Server *server, char *name, char *value)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP name 8
Resource name.
.IP value 8
Resource value.
.RE
.LP
Sets the stringResAssign->name attribute value of 'server' to 'value'.
.Fn ServerPrint
.Cs
void ServerPrint(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Prints out values to the Server structure.
.Fn ServerInit2
.Cs
static void ServerInit2(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Initializes all members of the server structure except inetAddr, the port
numbers, socket, and file descriptors.
.Fn ServerInit
.Cs
void ServerInit(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Initializes all members of the server structure.
.Fn ServerOpenInit
.Cs
int ServerOpenInit(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
The algorithm is as follows:
.sp
.nf
.Ty
  get network address of 'server'.
  create a new socket.
  bind the socket to a local port.
  listen to the local port for incoming messages/request.
  Update the socket attribute of the 'server'.
  Return 0 if everything's okay; 1 otherwise.
.fi
.Fn ServerOpen
.Cs
int ServerOpen(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
The algorithm is as follows:
.sp
.nf
.Ty
   get the socket of the 'server' (set in the 'socket' attribute).
   If socket is not a valid value (no socket exists),
   then
      send a pbs_connect() call using the server name alone.
      Use the file descriptor value obtained from pbs_connect() as the new value
        to fdTwoWay attribute.
   else
      accept() a request from the server using the socket.
      Check to make sure that the request came from a trusted host.
      Use the descriptor value returned by accept() call as the new value to
        fdOneWay(). 
      Call socket_to_conn() to obtain another descriptor to be used as the
        value of the fdTwoWay attribute.

   Return 0 if everything's ok; 1 otherwise.
.fi
.Fn ServerRead
.Cs
int ServerRead(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Get a scheduling command from the 'server'.
.Fn ServerWriteRead
.Cs
int ServerWriteRead(Server *server, int msg, void *param)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP msg 8
Type of message to send to the server.
.IP param 8
Additional parameters to accompany the message to send to the server.
.RE
.LP
.nf
.Ty
If msg is STATNODE, then issue a pbs_statnode() call using the fdTwoWay
    attribute value as file descriptor.
If msg is STATSERV, then issue a pbs_statserver() call using the fdTwoWay
    attribute value as file descriptor.
If msg is STATQUE, then issue a pbs_statque() call using the fdTwoWay
    attribute value as file descriptor.
If msg is STATJOB, then issue a pbs_statjob() call using the fdTwoWay
    attribute value as file descriptor.
.fi
.Fn ServerClose
.Cs
int ServerClose(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Issues a pbs_disconnect() on the descriptor given by the fdTwoWay attribute.
Returns the value obtained from pbs_disconnect().
.Fn ServerCloseFinal
.Cs
void ServerCloseFinal(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Get any opened socket for the 'server'. Clean up any remaining request on it.
Then close the socket.
.Fn getNodesInfo
.Cs
static int getNodesInfo(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Issue a ServerWriteRead() using node_alist as param value.
Get the results, and fill out the appropriate member of the CNode structure,
and add it to the set of nodes known to 'server'. 
Returns 0 if successful; non-zero otherwise.
.Fn getServerInfo
.Cs
static int getServerInfo(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Issue a ServerWriteRead() using serv_alist as param value.
Get the results and fill out the appropriate member of the Server structure. 
Returns 0 if successful; non-zero otherwise.
.Fn getQueuesInfo
.Cs
static int getQueuesInfo(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Issue a ServerWriteRead() using que_alist as param value.
Get the results and fill out the appropriate member of the Server structure. 
Returns 0 if successful; non-zero otherwise.
.Fn getJobsInfo
.Cs
static int getJobsInfo(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Issue a ServerWriteRead() using job_alist as param value.
Get the results and fill out the appropriate member of the Server structure. 
Returns 0 if successful; non-zero otherwise.
.Fn ServerFree2
.Cs
static void ServerFree2(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Free up all temporary strings associated with 'server'.
Free up malloc-ed areas associated with 'server'.
Free up all dynamic strings, and job structures associated with the 'server's
queues.
.Fn ServerFree
.Cs
static void ServerFree(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Free up the entire Server structure, and any malloc-ed areas associated with
it. 
.Fn ServerStateRead
.Cs
void ServerStateRead(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Deallocates all queuest and jobs associated with 'server'.
If fdTwoWay attribute valid is invalid, then issue a ServerOpen().
Get server, nodes, queues, and jobs info from the 'server'.  
.Fn AllNodesGet
.Cs
SetCNode *AllNodesGet()
.Ce
.IP Args: 4
.LP
Returns ServerNodesGet(AllServersLocalHostGet))
.Fn AllNodesLocalHostGet
.Cs
SetCNode *AllNodesLocalHostGet()
.Ce
.IP Args: 4
.LP
Returns the CNode associated with the local host.
.Fn ServerNodesGet
.Cs
SetCNode *ServerNodesGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
Returns the set of nodes managed by 'server'.
.Fn ServerNodesAdd
.Cs
CNode *ServerNodesAdd(Server *server, char *name, int port, int queryMom)
.Ce
.IP Args: 4
.RS
.IP server 10
A pointer to a Server object.
.IP name 10
name of a node to add.
.IP port 10
port number of the associated MOM
.IP queryMom 10
flag as to whether or not to query the corresponding MOM.
.RE
.LP
.nf
.Ty
If node with 'name' is already in the set of nodes managed by 'server', then
    no need to add.
Otherwise,
    create a new CNode object, initialize it, propagate any resmom information,
      and add the new oobject to the list of nodes known to the 'server'.
.fi
.Fn ServerNodesHeadGet
.Cs
CNode *ServerNodesHeadGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 10
A pointer to a Server object.
.RE
.LP
Returns the first CNode object in the list of nodes known to 'server'.
.Fn ServerNodesTailGet
.Cs
CNode *ServerNodesTailGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 10
A pointer to a Server object.
.RE
.LP
Returns the last CNode object in the list of nodes known to 'server'.
.Fn ServerNodesQuery
.Cs
int ServerNodesQuery(Server *server, char *spec)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP spec 8
A nodes specification
.RE
.LP
.nf
.Ty
  Calls pbs_rescquery() to issue a request to 'server' to query for
  availability of resources as specified in 'spec'. After getting the
  results, this calls ServerNodesNumAvailPut(), ServerNodesNumAllocPut(),
  ServerNodesNumRsvdPut(), and ServerNodesNumDownPut().

  Then, it will return SUCCESS or FAIL depending on the results.
.fi
.Fn ServerNodesReserve
.Cs
int ServerNodesReserve(Server *server, char *spec, int resId)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP spec 8
A nodes specification
.IP resId 8
A handle to the reservation
.RE
.LP
.nf
.Ty
  Calls pbs_rescreserve() to issue a request to 'server' to reserve resources
  specified in 'spec'. If 'resId' is zero, then this is for a new reservation.
  Otherwise, it is for an existing or partial reservation.

  Then, it will return SUCCESS or FAIL depending on the results.
.fi
.Fn ServerNodesRelease
.Cs
int ServerNodesRelease(Server *server, int resId)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.IP resId 8
A handle to the reservation
.RE
.LP
.nf
.Ty
  Calls pbs_rescrelease() to ssue a request to 'server' to release resources
  from a previous reservation session whose handle is 'resId'.

  Then, it will return SUCCESS or FAIL depending on the results.
.fi
.Fn ServerNodesNumAvailGet
.Cs
int ServerNodesNumAvailGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
.nf
.Ty
   Return the numAvail attribute value of the nodes attribute of 'server'.
.fi
.Fn ServerNodesNumAllocGet
.Cs
int ServerNodesNumAllocGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
.nf
.Ty
   Return the numAlloc attribute value of the nodes attribute of 'server'.
.fi
.Fn ServerNodesNumRsvdGet
.Cs
int ServerNodesNumRsvdGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
.nf
.Ty
   Return the numRsvd attribute value of the nodes attribute of 'server'.
.fi
.Fn ServerNodesNumDownGet
.Cs
int ServerNodesNumDownGet(Server *server)
.Ce
.IP Args: 4
.RS
.IP server 8
A pointer to a Server object.
.RE
.LP
.nf
.Ty
   Return the numDown attribute value of the nodes attribute of 'server'.
.fi
.Fn ServerNodesNumAvailPut
.Cs
void ServerNodesNumAvailPut(Server *server, int numAvail)
.Ce
.IP Args: 4
.RS
.IP server 10
A pointer to a Server object.
.IP numAvail 10
# of nodes available
.RE
.LP
.nf
.Ty
   Update the numAvail value of the nodes attribute of 'server' to 'numAvail'.
.fi
.Fn ServerNodesNumAllocPut
.Cs
void ServerNodesNumAllocPut(Server *server, int numAlloc)
.Ce
.IP Args: 4
.RS
.IP server 10
A pointer to a Server object.
.IP numAlloc 10
# of nodes allocated 
.RE
.LP
.nf
.Ty
   Update the numAlloc value of the nodes attribute of 'server' to 'numAlloc'.
.fi
.Fn ServerNodesNumRsvdPut
.Cs
void ServerNodesNumRsvdPut(Server *server, int numRsvd)
.Ce
.IP Args: 4
.RS
.IP server 10
A pointer to a Server object.
.IP numRsvd 10
# of nodes reserved
.RE
.LP
.nf
.Ty
   Update the numRsvd value of the nodes attribute of 'server' to 'numRsvd'.
.fi
.Fn ServerNodesNumDownPut
.Cs
void ServerNodesNumDownPut(Server *server, int numDown)
.Ce
.IP Args: 4
.RS
.IP server 10
A pointer to a Server object.
.IP numDown 10
# of nodes down
.RE
.LP
.nf
.Ty
   Update the numDown value of the nodes attribute of 'server' to 'numDown'.
.fi
.Fn JobAction
.Cs
int JobAction(Job *job, Action action, void *params)
.Ce
.IP Args: 4
.RS
.IP job 8
Pointer to a job object.
.IP action 8
Action to perform on the job: SYNCRUN, ASYNCRUN, DELETE, RERUN, HOLD, RELEASE,
SIGNAL, MODIFYATTR, and MODIFYRES.  
.IP params
Additional parameters to the action.
.RE
.LP
Depending on the action specified, issue the appropriate PBS API call:
.nf
.Ty
  If SYNCRUN, then pbs_runjob(), update the job's state to RUNNING,
                   accumulate the resources.
  If ASYNCRUN, then pbs_asyrunjob(), update the job's state to RUNNING,
                   accumulate the resources.
  If DELETE, then pbs_deljob(), update the job's state to DELETED.
  If RERUN, then pbs_rerunjob(), update the job's state to QUEUED.
  If HOLD, then pbs_holdjob(), update the job's state to HELD.
  If RELEASE, then pbs_rlsjob(), update the job's state to RELEASE. 
  If SIGNAL, then pbs_sigjob(),
  If MODIFYRES or MODIFYATTR, then pbs_alterjob(), and update the value 
                                   for the appropriate resource or attribute.
.fi
Returns SUCCESS (1) if operation was completed successfully; otherwise, it 
return FAIL (0).
.Fn SetServerInit
.Cs
void SetServerInit(SetServer *ss)
.Ce
.IP Args: 4
.RS
.IP ss 8
A set of server structures.
.RE
.LP
Initialize the set of servers 'ss' so that both head and tail are pointing to
NOSERVER.
.Fn SetServerAdd
.Cs
void SetServerAdd(SetServer *ss, Server *s)
.Ce
.IP Args: 4
.RS
.IP ss 8
A set of server structures.
.IP s 8
A pointer to a Server object. 
.RE
.LP
Add Server 's' to the set of servers, 'ss'.
.Fn SetServerFree
.Cs
void SetServerFree(SetServer *ss)
.Ce
.IP Args: 4
.RS
.IP ss 8
A set of server structures.
.RE
.LP
Free up malloc-ed areas associated with 'ss'.
.Fn SetServerPrint
.Cs
void SetServerPrint(SetServer *ss)
.Ce
.IP Args: 4
.RS
.IP ss 8
A set of server structures.
.RE
.LP
Prints out the elements in the set of servers 'ss'.
.Fn inSetServer
.Cs
int inSetServer(Server *s, SetServer *ss)
.Ce
.IP Args: 4
.RS
.IP s 8
Pointer to a Server object.
.IP ss 8
A set of server structures.
.RE
.LP
Returns 1 if 's' is a member of 'ss'; 0 otherwise. 
.Fn AllServersAdd
.Cs
int AllServersAdd(char *name, int port)
.Ce
.IP Args: 4
.RS
.IP name 8
A node name.
.IP port 8
Network port number for the new Server.
.RE
.LP
Creates a new Server(name, port) object, and adds it (if not a duplicate) to
the internal SetServer variable, AllServers.
.Fn AllServersInit
.Cs
void AllServersInit(void)
.Ce
.LP
Initializes the internal SetServer variable, AllServers to a consistent value. 
.Fn AllServersGet
.Cs
void AllServersGet(void)
.Ce
.LP
Returns a pointer to the internal SetServer variable, AllServers.
.Fn AllServersFree
.Cs
void AllServersFree(void)
.Ce
.LP
Frees up malloc-ed storage associated with internal variable, AllServers.
.Fn ServerPartition
.Cs
int ServerPartition(struct ServerSortArgs *A, int p, int r)
.Ce
.IP Args: 4
.RS
.IP A 8
stuff of information needed to reorder the elements of a set of Servers.
.IP p 8
the "leftmost" element of a set of Servers.
.IP r 8
the "rightmost" element of a set of Servers.
.RE
.LP
This is the ServerPartition() function in the well-known Quicksort() sorting
algorithm. (see "Introduction to Algorithms" by Cormen, et al) pp. 153-156).
.Fn ServerQuickSort
.Cs
void ServerQuickSort (struct ServerSortArgs *A, int p, int r)
.Ce
.IP Args: 4
.RS
.IP A 8
stuff of information needed to reorder the elements of a set of Servers.
.IP p 8
the "leftmost" element of a set of Servers.
.IP r 8
the "rightmost" element of a set of Servers.
.RE
.LP
This is the Quicksort() function in the well-known quicksort sorting
algorithm. (see "Introduction to Algorithms" by Cormen, et al) pp. 153-156).
.Fn SetServerSortInt
.Cs
int SetServerSortInt (SetServer *s, int (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Servers to reorder.
.IP key 8
the function to apply to each member of the set of Servers whose int value
will be used to reorder the set of Servers.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Servers in a dynamic array, and then run
ServerQuicksort() function on the array, which also rearranges the pointers
representing the set of Servers.
.Fn SetServerSortStr
.Cs
int SetServerSortStr (SetServer *s, char *(*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Servers to reorder.
.IP key 8
the function to apply to each member of the set of Servers whose char*
 value will be used to reorder the set of Servers.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Ques in a dynamic array, and then run
ServerQuickSort() function on the array, which also rearranges the pointers
representing the set of Servers.
.Fn SetServerSortDateTime
.Cs
int SetServerSortDateTime (SetServer *s, DateTime (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Servers to reorder.
.IP key 8
the function to apply to each member of the set of Servers whose DateTime value
will be used to reorder the set of Servers.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Servers in a dynamic array, and then run
ServerQuicksort() function on the array, which also rearranges the pointers
representing the set of Servers.
.Fn SetServerSortSize
.Cs
int SetServerSortSize (SetQue *s, Size (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Ques to reorder.
.IP key 8
the function to apply to each member of the set of Servers whose Size value
will be used to reorder the set of Servers.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Servers in a dynamic array, and then run
ServerQuickSort() function on the array, which also rearranges the pointers
representing the set of Servers.
.Fn SetServerSortFloat
.Cs
int SetServerSortFloat (SetServer *s, double (*key)(), int order)
.Ce
.IP Args: 4
.RS
.IP s 8
the set of Servers to reorder.
.IP key 8
the function to apply to each member of the set of Servers whose double value
will be used to reorder the set of Servers.
.IP order 8
the order of sort: ASCending or DESCending. 
.RE
.LP
Holds the pointers to the set of Servers in a dynamic array, and then run
ServerQuicksort() function on the array, which also rearranges the pointers
representing the set of Servers.
.LP
.NH 4
.Tc System
.LP
The source code found under the
.Ar System
subdirectory
contains data structures and functions that are used in order to build
the resulting scheduler daemon. It is under this abstraction where the
main() part of the program exists. The files involved are af_config.h,
af_config.c, af_system.h, and af_system.c.
.NH 5
.Fi af_config.c
.LP
This contains functions related to the scheduler configuration file.
.Fn badconn
.Cs
void badconn(char *msg, struct sockaddr_in saddr)
.Ce
.IP Args: 4
.RS
.IP msg 8
A message to attach to the PBS log file regarding a bad connection.
.IP saddr 8
The bad address that attempted to connect to the scheduler.
.RE
.LP
Sends a message to the PBS log file regarding a bad connection involving
 'saddr'.
.Fn addClient
.Cs
int addClient(char *name)
.Ce
.IP Args: 4
.RS
.IP name 8
A name to add to the list of okClients.
.RE
.LP
If not a duplicate, add the host address of 'name' to the list of addresses
allowed to connect to the scheduler. The list is maintained via the internal
variable, okClients.
Returns 0 if successful; non-zero otherwise.
.Fn validateClient
.Cs
int validateClient(void *saddr)
.Ce
.IP Args: 4
.RS
.IP saddr 8
A host address to validate.
.RE
.LP
Returns 0 if saddr's host address appears on the okClients list; otherwise,
return non-zero.  
.Fn freeClients
.Cs
void freeClients(void)
.Ce
.LP
Free up the malloc-ed storage associated with okClients.
.Fn freeConfig
.Cs
void freeConfig(void)
.Ce
.LP
Free up the malloc-ed storage associated with various arrays filled as a 
result of reading the configuration file.
.Fn getNextToken
.Cs
static char *getNextToken(char *line)
.Ce
.IP Args: 4
.RS
.IP line 8
If non-NULLSTR, a new line to read. Otherwise, continue from previous call.
.RE
.LP
Returns the next token flagged by a previous call to strtok(). Returns NULL
if no more tokens or if an error has occurred.
.Fn readConfig
.Cs
int readConfig(char *file)
.Ce
.IP Args: 4
.RS
.IP file 8
File to read.
.RE
.LP
Read and process the lines in the configuration file. Valid lines format are:
.nf
  $clienthost <hostname>
  $momhost <hostname> <port>
  $node <node_name> <CNodeGet() function name> <hostQuery_keyword>
.fi
.LP
.NH 5
.Fi af_config.c
.Fn lock_out
.Cs
static void lock_out(int fds, short op)
.Ce
.IP Args: 4
.RS
.IP fds 8
The padlock.
.IP op 8
Lock type.
.RE
.LP
Prevents other daemons from accessing the file represented by 'fds'.
.Fn die
.Cs
static void die(int sig)
.Ce
.IP Args: 4
.RS
.IP sig 8
The signal number.
.RE
.LP
Causes the scheduler to exit after shutting down the system and closing PBS
log file.
.Fn initSchedCycle
.Cs
static void initSchedCycle(void)
.Ce
.LP
Get all the static resource values for all the known CNodes.
.Fn addDefaults
.Cs
static void addDefaults(void)
.Ce
.LP
Loads the okClients, and Res internal variables with some default values.
.Fn toolong
.Cs
static void toolong(int sig)
.Ce
.IP Args: 4
.RS
.IP sig 8
A signal number.
.RE
.LP
Parent re-execs itself, while child process attempts to dump core if no
core file exists.
.Fn restart
.Cs
static void restart(int sig)
.Ce
.IP Args: 4
.RS
.IP sig 8
A signal number.
.RE
.LP
The algorithm is as follows:
.nf
.Ty
  Save some information about the local Server such as PortNumberOneWay,
    PortNumberTwoWay, socket, and fdOneWay.
  Free up all malloc-ed storage filled in when the configuration file was read.
  Add the local server again to the list of known Servers. The saved values of
    PortNumberOneWay, PortNumberTwoWay, socket, and fdOneWay are reloaded into
    the local Server structure.
  Add default values to the internal variables okClients and Res.
  Re-read the configuration file.
  Initialize a scheduling cycle.
.fi
.Fn getArgs
.Cs
static void getArgs(int argc, char *argv[])
.Ce
.IP Args: 4
.RS
.IP argc 8
# of arguments.
.IP argv 8
list of the actual arguments.
.RE
.LP
This function takes care of reading the command line arguments. See BASL ERS
for the format of the commandline.
.Fn cdToPrivDir
.Cs
static void cdToPrivDir(void)
.Ce
.LP
Checks to make sure that the priv directory is not group and 
other-writeable before cd-ing to it. Pbs_environment file is
also checked for security.
.Fn secureEnv
.Cs
static void secureEnv(void)
.Ce
.LP
Set up a secure executing environment for the scheduler daemon.
.Fn signalHandleSet
.Cs
static void signalHandleSet(void)
.Ce
.LP
Sets signal handlers for SIGHUP, SIGALRM, SIGINT, and SIGTERM.
.Fn SystemInit
.Cs
static void SystemInit(int argc, char *argv[])
.Ce
.IP Args: 4
.RS
.IP argc 8
# of arguments.
.IP argv 8
A list of arguments.
.RE
.LP
The algorithm for this function is as follows:
.nf
.Ty
  Check to make sure that effective user id and user id are set to root (when
    not under DEBUG mode) 
  Get the local hostname. 
  Initialize the set of servers known to the system. Add the local hostname to
    this set.
  Get command line arguments (via the supplied argc, argv parmeters).
  go to the privilege directory (sched_priv).
  create a secure executing environment.
  Open the PBS sched log file.
  Get a socket from the local server.
  Add defaults to internal Resource variable Res.
  Initialize the set of nodes known to the system.
  Read the configuration file (if set).
  Attempt to open the lock file. If successful, prevent other daemons from
    accessing the file.
  Kill the parent process, causing the child process to be become stand-alone
    daemon.
  Direct stdout/stderr to some debug file (sched_out or as specified in -p)
  Get current process id of the child.
  Close any stdin of the process.
  Write a message to the sched lock file the process id of the daemon.
  Lock the daemon into memory if PLOCK_DAEMONS variable is set appropriately.
  Set up things for DIS data encoding/decoding.
  Set up the signal handlers.
  Initialize a scheduling cycle.
  Write a message to the PBS sched log file indicating that the daemon has
    started.
.fi
.Fn SystemStateRead
.Cs
void SystemStateRead(void (*sched_main)())
.Ce
.IP Args: 4
.RS
.IP sched_main 8
A function to invoke during a scheduling cycle.
.RE
.LP
The algorithm for this function is as follows:
.nf
.Ty
  Get the local server's socket.
  Listen on it for messages. If a message has arrived, then go get it.
  if the message received is one of
     {SCH_SCHEDULE_NEW, SCH_SCHEDULE_TERM, SCH_SCHEDULE_TIME,
      SCH_SCHEDULE_RECYC, SCH_SCHEDULE_CMD, SCH_SCHEDULE_FIRST}, then
    begin
      set up an alarm for 'alarm_time'
      Get data for all servers known to the system.
      Get DYNAMIC_RESOURCE data for all nodes known to the system.
      Call sched_main()
      Then disconnect opened connections (2-way channels) to the servers.
      Reset alarm time.
      listen for the next scheduling  message
    end
  else if message received is one of
     {SCH_CONFIGURE, SCH_RULESET}, then
    begin
      Issue a restart() call which will re-read the configuration file.
      listen for the next scheduling  message
    end
  else if message received is one of
     {SCH_CONFIGURE, SCH_RULESET}, then
    begin
      Issue a restart() call which will re-read the configuration file.
    end
  else if message received is SCH_QUIT, then
      return from this function.
  else if message received is one of
     {SCH_ERROR, SCH_SCHEDULE_NULL},
      listen for the next scheduling  message
  end     
.fi
.LP
.Fn SystemCloseServers
.Cs
void SystemCloseServers(void)
.Ce
.LP
For all the Servers known the the system, close their fdTwoWay file descriptor. 
.Fn SystemClose
.Cs
void SystemClose(void)
.Ce
.LP
Close all file descriptors associated with the Servers known to the system.
Free up all malloc-ed areas filled in when the configuration file was read.
.NH 2
.Tc \f3The Tcl Scheduler\fP
.LP
The second provided scheduler is based on the Tcl language developed by
John K. Ousterhout. Tcl stands for Tool Control Language.
.NH 3
.Tc Tcl Scheduler Overview
.LP
The Tcl Scheduler contains a number of functions which act as wrappers
for existing PBS library calls.  The main() routine opens a logfile,
processes the command line arguments, and sets up signal handling.  
After that, a Tcl interpreter is created and Tcl_CreateCommand()
is called for each of the function wrappers.  The initialization
script is run if it exists and the body script is read into memory.
A socket is set up to get connections from the server and a loop
is entered to process wakeup calls from the server.  Each wakeup
contains a command from the server.  If the command is
.I SCH_SCHEDULE_NEW ,
.I SCH_SCHEDULE_TERM ,
.I SCH_SCHEDULE_TIME ,
.I SCH_SCHEDULE_RECYC ,
or
.I SCH_SCHEDULE_CMD
the function Tcl_Eval() is called with the saved body script.
If the result from this is not
.I TCL_OK
an error message is logged and the process aborts.
.LP
.NH 3
.Fi pbs_tclWrap.c
.LP
The purpose of the wrapper routines is to check the legality of the
parameters passed from a Tcl command and call a library function.  The
.B sched_tcl
man page describes each Tcl function in detail.  The following
is a list of their names with arguments and any special processing
that they need to do.
.Fn OpenRM()
.Cs
int OpenRM(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST [])
.Ce
.LP
This function is bound to the Tcl function "openrm" and calls the
PBS resource monitor library function openrm().
.Fn CloseRM()
.Cs
int CloseRM(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST [])
.Ce
.LP
This function is bound to the Tcl function "closerm" and calls the
PBS resource monitor library function closerm().
.Fn DownRM()
.Cs
int DownRM(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST [])
.Ce
.LP
This function is bound to the Tcl function "downrm" and calls the
PBS resource monitor library function downrm().
.Fn ConfigRM()
.Cs
int ConfigRM(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST [])
.Ce
.LP
This function is bound to the Tcl function "configrm" and calls the
PBS resource monitor library function configrm().
.Fn AddREQ()
.Cs
int AddREQ(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST [])
.Ce
.LP
This function is bound to the Tcl function "addreq" and calls the
PBS resource monitor library function addreq().
.Fn AllREQ()
.Cs
int AllREQ(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "allreq" and calls the
PBS resource monitor library function allreq().
.Fn GetREQ()
.Cs
int GetREQ(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST [])
.Ce
.LP
This function is bound to the Tcl function "getreq" and calls the
PBS resource monitor library function getreq().
.Fn FlushREQ()
.Cs
int FlushREQ(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "flushreq" and calls the
PBS resource monitor library function flushreq().
.Fn ActiveREQ()
.Cs
int ActiveREQ(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "activereq" and calls the
PBS resource monitor library function activereq().
.Fn FullResp()
.Cs
int FullResp(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "fullresp" and calls the
PBS resource monitor library function fullresp().
.Fn attrlist()
.Cs
char* attrlist(struct attrl *ap)
.Ce
.LP
This function takes a list of attrl's and creates a Tcl list from them.
For each attrl, Tcl_Merge() is called to create a list with two elements.
The first is the name and resource if it exists, separated by a colon.
The second is the value.  Tcl_Merge() is
called again to combine all the name/value pairs into one list.
The functions PBS_StatServ(), PBS_StatJob(), PBS_SelStat(), and PBS_StatQue()
all use this to create their return lists.
.Fn PBS_StatServ()
.Cs
int PBS_StatServ(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsstatserv" and calls the
PBS interface library function pbs_statserv().
The single batch_status struct which is returned is combined using
.I Tcl_Merge()
to form a list element with the batch_status struct's name, attribs and
text forming the three sublists.  The routine
.I attrlist()
is called to form the second sublist out of the attribs.
The temporary storage used to create the list is free'ed.
.Fn PBS_StatJob()
.Cs
int PBS_StatJob(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsstatjob" and calls the
PBS interface library function pbs_statjob().
The list of batch_status struct's which are returned are looped through
with an array of three char *'s being setup to pass to
.I Tcl_Merge()
to form a list element with the batch_status struct's name, attribs and
text forming the three sublists.  The routine
.I attrlist()
is called to form the second sublist out of the attribs.
All the above list elements are combined in a final call to
.I Tcl_Merge()
and the temporary storage used to create the lists is free'ed.
.Fn PBS_SelStat()
.Cs
int PBS_SelStat(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsselstat" and calls the
PBS interface library function pbs_selstat() with a list of attropl
struct's giving the attributes to select.  To get only the "runnable"
jobs from the server, the attropl's are setup to only return jobs
with "queue_type=E" and "job_state=Q".
The list of batch_status struct's which are returned are looped through
with an array of three char *'s being setup to pass to
.I Tcl_Merge()
to form a list element with the batch_status struct's name, attribs and
text forming the three sublists.  The routine
.I attrlist()
is called to form the second sublist out of the attribs.
All the above list elements are combined in a final call to
.I Tcl_Merge()
and the temporary storage used to create the lists is free'ed.
.Fn PBS_StatQue()
.Cs
int PBS_StatQue(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsstatque" and calls the
PBS interface library function pbs_statque().
The list of batch_status struct's which are returned are looped through
with an array of three char *'s being setup to pass to
.I Tcl_Merge()
to form a list element with the batch_status struct's name, attribs and
text forming the three sublists.  The routine
.I attrlist()
is called to form the second sublist out of the attribs.
All the above list elements are combined in a final call to
.I Tcl_Merge()
and the temporary storage used to create the lists is free'ed.
.Fn PBS_RunJob()
.Cs
int PBS_RunJob(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsrunjob" and calls the
PBS interface library function pbs_runjob().
.Fn PBS_AsyRunJob()
.Cs
int PBS_AsyRunJob(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsasyrunjob" and calls the
PBS interface library function pbs_asyrunjob().
.Fn PBS_MoveJob()
.Cs
int PBS_MoveJob(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsmovejob".  A call
to the fuction get_server() is made, followed by a call to the
PBS interface library function pbs_movejob().
.Fn PBS_DelJob()
.Cs
int PBS_DelJob(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsdeljob" and calls the
PBS interface library function pbs_deljob().
.Fn PBS_HoldJob()
.Cs
int PBS_HoldJob(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsholdjob" and calls the
PBS interface library function pbs_holdjob().
.Fn PBS_QueueOp()
.Cs
int PBS_QueueOp(ClientData, Tcl_Interp *, int, char *[], struct attropl *)
.Ce
.LP
This function is called by PBS_EnableQueue(), PBS_DisableQueue(),
PBS_StartQueue() and PBS_StopQueue().  It is not bound to any
Tcl function directly.  It calls the PBS interface library function
pbs_manager() with the second and third parameters of
.I MGR_CMD_SET
and
.I MGR_OBJ_QUEUE
respectively, and a
.I "struct attropl *"
supplied by the calling routine depending on what action is to be done.
.Fn PBS_EnableQueue()
.Cs
int PBS_EnableQueue(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsqenable" and calls
PBS_QueueOp().
.Fn PBS_DisableQueue()
.Cs
int PBS_DisableQueue(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsqdisable" and calls
PBS_QueueOp().
.Fn PBS_StartQueue()
.Cs
int PBS_StartQueue(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsqstart" and calls
PBS_QueueOp().
.Fn PBS_StopQueue()
.Cs
int PBS_StopQueue(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "pbsqstop" and calls
PBS_QueueOp().
.Fn PBS_AlterJob()
.Cs
int PBS_AlterJob(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST [])
.Ce
.LP
This function is bound to the Tcl function "pbsalterjob" and calls the
PBS interface library function pbs_alterjob().
The Tcl function
.I Tcl_SplitList()
is called to separate each of the attributes to be altered.
Then a loop is entered to create a attrl structure for each attribute.
.Fn DateTime()
.Cs
int DateTime(ClientData, Tcl_Interp *, int, char *[])
.Ce
.LP
This function is bound to the Tcl function "datetime".  A switch statement
is entered for the number of arguments.  The time format requested is
determined and the result calculated by using the POSIX
.I time() ,
.I mktime()
and
.I localtime()
functions.
.Fn StrFtime()
.Cs
int StrFtime(ClientData, Tcl_Interp *, int, Tcl_Obj *CONST [])
.Ce
.LP
This function is bound to the Tcl function "strftime" and calls the
POSIX function
.I strftime() .
It requires two arguments.  The first
is a format string.  The format conventions are the same as those
for the POSIX function strftime().  The second argument is POSIX
calendar time in seconds.
.Fn add_cmds()
.Cs
void add_cmds(Tcl_Interp *interp)
.Ce
.LP
Call Tcl_CreateCommand() for each of the new commands.  Also call
site_cmds() so any site-specific processing will be done.
.LP
.NH 3
.Fi pbs_sched.c
.LP
This file contains main() and the loop which reads and processes
commands from the server.
.Fn start_tcl()
.Cs
void start_tcl(void)
.Ce
.LP
The function Tcl_CreateInterp() is called to create a Tcl interpreter.
Then, add_cmds() is called to create the additional commands.
The initialization script is run if it exists and the body script is
read into memory.
.Fn restart()
.Cs
void restart(int sig)
.Ce
.LP
This is the signal handler for SIGHUP.  The Tcl interpreter is
deleted by calling Tcl_DeleteInterp().  Then a new one is started
by calling start_tcl().
.Fn server_command()
.Cs
int server_command(int socket_number)
.Ce
.LP
This function waits for a server wakeup and reads the command.
A call to
.B accept()
is made followed by a
.B read()
to get the four byte command.  The command is returned.
.LP
.NH 3
.Fi site_tclWrap.c
.LP
This file is provided as a holder for any site-specific code
which needs to be included.  It contains one routine which is
called from add_cmds().
.Fn site_cmds()
.Cs
void site_cmds(Tcl_Interp *interp)
.Ce
.LP
As delivered, this function just returns.  Use it to add commands
to Tcl that solve your problems in scheduling better, faster and
cheaper!
.NH 2
.Tc \f3The C Scheduler\fP
.LP
The third provided scheduler is not a complete program.  To use
this will require the largest initial effort but will yield
the most flexablity and quickest runtime of all the other
schedulers.  It is recommended that a site use either the Basl or
Tcl scheduler to to try out policies and move to use
the C scheduler only after having firmly settled on something
that will not be changed quickly.
.LP
There are two functions that must be provided by the scheduler writter.
The first is
.sp
.Cs
int schedinit(int argc, char *argv[])
.Ce
The parameters passed are the same as those passes to main from
the command line.  If this function returns a non-zero value,
this is considered a failure and the scheduler exits.
The second function is
.sp
.Cs
int schedule(int cmd)
.Ce
The parameter is the command from the server.
If this function returns a non-zero value,
this is considered a failure and the scheduler exits.
The global variable
.sp
.Cs
int connector
.Ce
must be defined and is setup with the PBS connection handle when
.I schedule
is called.

If a resource mom connection is to be used in the scheduler, the global 
variable
.Av pbs_rm_port
should be used as the default port.
.NH 3
.Fi pbs_sched.c
.LP
The C Scheduler has a provided main routine which
processes the command line arguments, and sets up signal handling
before going into a loop reading scheduler commands.
.Fn toolong()
.Cs
void toolong(int sig)
.Ce
.LP
This is the routine setup as the alarm signal handler.  This
carries over from the Tcl scheduler as a error recovery method
if the schedule run takes too long.  An error message is logged and
the network is shutdown.  The process forks and the parent simply
re-exec's itself to do a clean startup.  The child calls abort()
if no core file exists already and exits.
.Fi restart()
.Cs
void restart(int sig)
.Ce
.LP
This is the routine setup as the HUP signal handler.  It logs a
message and calls schedule() with the argument
.I SCH_CONFIGURE .
.Fn server_command()
.Cs
int server_command(int socket_number)
.Ce
Call
.B accept()
to get a new socket from the socket specified by
.I socket_number .
Then convert the new socket to a connection via
.I socket_to_conn() .
.LP
.NH 3
.Tc "FIFO Sample C scheduler"
.LP
     Scheduling policies differ greatly from site to site.  They differ to
such a degree that it is impossible to guess all the different parts that
everyone will want in their scheduler.  This sample scheduler was meant as 
a jumping off point into a useful scheduling policy. It would be useful to 
know where to change the code.  In making this scheduler several assumptions 
were made which will probably be wrong.

.LP
To make the scheduler gather more data from the pbs_server:
.RS
.IP 1. 
add the variable to the correct data structure in data_types.h
i.e. job_info / queue_info / server_info / node_info

.IP 2. 
edit the appropriate file and change the 
.I query_*_info()
function.  These functions will loop though a batch_status structure which is 
returned from the server.  There is a
large if/else statement block comparing the current element in the list to
information that is wanted.  Add a new statement to the end block.  
All the symbolic constants for the attributes are in src/include/pbs_ifl.h.  

.IP 3.
Add the initialization of the new variable in the 
.I new_*_info() 
function, and free it in the 
.I free_*_info() 
function.  Also add a print statement to 
.I print_*_info() 
if you plan to use that for debugging.
.RE

.LP
To have the scheduler check more/different resources:

.IP
There is a variable in globals.c which tells the scheduler which variables to
check aginst jobs in the scheduling cycles.  Change the array 
.Av res_to_check .

Format: 
.ft 3 
{ resource_name, comment_msg, debug_msg }
.ft 1

.RS
.IP -
.Av resource_name 
is the name of a resource how PBS views it.  Ex: ncpus, cput, mem

.IP -
.Av comment_msg 
is what the comment of the job will bet set to if there is a 
insufficient amount of this resource

.IP -
.Av debug_msg 
is what will be logged if there is an insufficient amount of this resource
.RE

.LP
To add a new sorting method:

.RS
.IP 1. 
add a new element to the sort_type enum in constants.h

.IP 2. 
write the compare function used by qsort
the prototype: 
.I "int func( const void *v1, const void *v2 )"

The compare function should return 
.RS
.IP -1:
if v1 < v2
.IP 0: 
if v1 == v2
.IP 1: 
if v1 > v2
.RE

The current compare functions are in the file 
.I sort.c.
.br
NOTE: multi_sort uses the global array, so it will automatically work 
with the new sort.

.IP 3. 
add to the 
.Av sorting_info 
array in globals.c

Format: 
.ft 3 
{ sort_type, config_name, cmp_func_ptr }
.ft 1

.RS
.IP -
.Av sort_type : 
the element in the enum sort_type

.IP -
.Av config_name : 
string: The name of the sort which is used in the scheduling policy config file

.IP -
.Av cmp_func_ptr : 
pointer to compare function  
.KS
.Cs
int (*cmp_func_ptr) (const void*, const void*)
.Ce
.KE
.RE
.RE

.LP
To add a global sort i.e. one that happens with every sort:
.IP
There is one entry point into the sorting compare function.  Currently it is 
sorting on sch_priority and if equal to call the requested sorting function.
Modify this function to change the sorting globally.

.LP
To change how the scheduler picks the next job candidate to run:

.IP
This is decided in the 
.I next_job() 
function.  Currently there are 3 choices Round Robin, By Queue, or neither.  
If another choice is added,
a bit should be added to the config strucuture and scheduling policy 
config file should be updated.

.LP
To change how the scheduler decides if a job can fit into the system.

.IP
All the checks for a job are in check.c
.I is_ok_to_run_in_queue()
is run once per scheduling cycle for each queue.  Any any queue check which 
needs to be 
checked but wont change within a scheduling cycle should be added to this 
fuction.  Any check which needs to be checked once for each job should be added
to 
.I is_ok_to_run_job().

.LP
To add to the scheduling config file:
.RS
.IP 1. 
add a variable to the config structure and possibily status structure 
in data_types.h.  If what is being added is going to change between prime and
non-prime, the status structure needs to be changed.  If it will change with
prime and non-prime time, make sure to change the init functions (see below).
.IP 2.
add a symbolic constant in config.h which will hold the name which will appear
in the config file.  The prefix for the symbolic constant is PARSE.
.IP 3. 
change the parse_config function in parse.c
There is an if/else block which checks each config word from the file.  This 
block needs to be expanded.  The variable
.Av config_name 
contains the name on the left side of the colen(:) in the config file. 
If the value is boolean or numeric, the 
.Av num 
variable will hold its value.
In any case the variable 
.Av config_value 
will hold the string value.

Find a good place in the if/else structure to add your new item.  It should be
if( !strcmp(config_name, PARSE_symbolic_constant) )

If an error is detected set the variable
.Av error
to 1, and it will be printed if there is an error.

.LP
To have something happen at the start of primetime or nonprimetime

There are two functions in the file prime.c.  
.I Init_non_prime_time()
and
.I init_prime_time().

These functions are called in the beginning of primetime and nonprimetime.  
Add all the necessary code in those functions.  The status structure is updated
in theses functions.
.RE

.LP
To change information gathered by MOM
Information is picked up from mom for nodes.  

.RS
.IP 1. 
edit globals.c and add an element to the array
.Av res_to_get .
This will cause the scheduler to query mom for the resource.
.IP 2. 
edit data_types.h and add new members to the node_info structure.
.IP 3.
edit the function 
.I talk_with_mom()
in node_info.c.  Near the end of the function there will be an if/else block.  
This is where the answers from mom are converted into the data for the node.
.RE

NOTE: If you are running a single 
timeshared system, set up a nodes file with your one system and mark it 
timeshared(:ts). 

.LP
To change how load balencing is done:

The load balencing policy is done in 2 functions.  The first checks to see 
if there is a timesharing node available to run on, 
.I is_node_available().
The second finds the best timesharing node to run on, 
.I find_best_node().

.LP 
To change how starving jobs are helped:

Job starvation is done by setting a internal scheduler priority variable
.Av sch_priority .
This is done in the function
.I update_starvation().
It is called in 
.I init_scheduling_cycle()
to make sure it will be updated every cycle.  Currently, all which is done
is to set the priority to the ammount of times it has waited the
.Av max_starve
time.

The seconds half of the job starvation code is how to allow jobs to run 
while there is a starving job.  There is a function in 
.I check.c
which only allows the most starving job to run.  The function knows which
job is most starving, since it is stored in the scheduling cycle status 
variable, 
.Av stat .

.NH 4
.Fi globals.c
.LP
This file defines the necessary global variables for the scheduler.  Most of 
the variables are constant.

.RS
.IP res_to_check
This is the list of resources the scheduler will check inorder to see if a job
can run.  
.br
The Format:
.B
name, comment_msg, debug_msg
.R
.IP name
the name of the resource as PBS knows it
.IP comment_msg 
If the job can not run, the comment attribute of the job will be changed to 
this message.
.IP debug_msg
If the job can not run, this debug message will be logged
.RE

.IP sorting_info
This variable holds all the information about the different sorts which can 
be done on the jobs.
.br
The Format:
.br
.B
sort_type, sort_name, cmp_func
.R
.RS
.IP sort_type
element from the enum sort_type
.IP sort_name
The name of the sort that will appear in the scheduling policy config file
i.e. shortest_job_first
.IP cmp_func
the function pointer to qsort compare function
.RE

.IP num_res
This is the number of elements in the res_to_check array

.IP num_sorts
This is the number of elements in the sorting_info array

.IP conf
This is the global config structure.  This holds all the run time config info
read in from the scheduling policy config file.  This information does not 
change during the runtime of the scheduler.

.IP stat
This is the global scheduling cycle status structure.  This holds all the 
configuration information which changes during the runtime of the scheduler.

.NH 4
.Fi check.c
.LP
The functions in this file deal with checking if a job can run on the system
at the current time.

.LP
.ft 3
The main check functions
.ft 1

.Fn is_ok_to_run_in_queue
.Cs
int is_ok_to_run_queue(queue_info *qinfo)
.Ce
.IP Args: 4
.RS
.IP qinfo 
the structure holding the queue information
.RE
.IP Returns: 4
.RS
.IP SUCCESS
if is possible to run jobs in the queue
.IP QUEUE_NOT_STARTED  
if the queue is not started
.IP QUEUE_NOT_EXEC
if the queue is not an execution queue
.IP IN_DED_TIME
if it is dedicated time and the queue is not a dedicated time queue
.RE
.LP
This function is called on each queue to see if jobs in the queue can be run.
It checks first to see if the queue's started attribute is set to 'true'
and then it checks to see if the queue is a execution queue.  It also will 
check to see if it is currently dedicated time and if the queue is a 
dedicated time queue or if we are not in dedcated time.
If all the conditions are true then jobs can run in the queue.
.sp 1
NOTE: this function gets called once per queue each scheduling cycle, other 
queue related variables that can change doing the scheduling cycle are checked
in 
.I is_ok_to_run_job().

.Fn is_ok_to_run_job
.Cs
int is_ok_to_run_job(server_info *sinfo, queue_info *qinfo, job_info *jinfo)
.Ce
.IP Args: 4
.RS
.IP sinfo 
the server the job resides in
.IP qinfo 
the queue the job resides in
.IP jinfo 
the job to check
.RE
.IP Returns:
.RS
.IP SUCCESS
if the job is OK to run
.IP QUEUE_GROUP_LIMIT_REACHED  
if the queue's max_group_run limit has been reached
.IP QUEUE_USER_LIMIT_REACHED   
if the queue's max_user_run limit has been reached
.IP QUEUE_JOB_LIMIT_REACHED    
if queue's max_running limit has been reached
.IP SERVER_GROUP_LIMIT_REACHED 
if the server's max_group_run limit has been reached
.IP SERVER_USER_LIMIT_REACHED  
if the server's max_user_run limit has been reached
.IP SERVER_JOB_LIMIT_REACHED   
if the server's max_running limit has been reached
.IP NOT_QUEUED
if the job is not in the queued state
.IP CROSS_INTO_DED_TIME
if the job would cross a dedicated time boundry
.IP NOT_ENOUGH_NODES_AVAIL
if the there are not enough of the right type of nodes available
.IP return_code 
from what 
.I check_avail_resources() 
.RE
.LP
This function will check the queues 
.Av max_running , 
.Av max_user_run ,
and 
.Av max_group_run 
attributes, and the servers 
.Av max_running , 
.Av max_group_run , 
and 
.Av max_user_run 
attributes. It will also check if the job is queued.  It will check of the job
would cross a dedicated time boundry.  There is a check to see if 
there are enough nodes of the right type of nodes available to run the job.
Finally, it will it will call 
.I check_avail_resources()
to see if the job is able to run within the server's resources.

.LP
.ft 3
Helper Functions
.ft 1

.Fn check_avail_resources
.Cs
int check_avail_resources(server_info *sinfo, queue_info *qinfo, 
							job_info *jinfo)
.Ce
.IP Args: 4
.RS
.IP sinfo 
the server the job resides in
.IP qinfo 
the queue the job resides in
.IP jinfo 
the job
.RE
.IP Returns:
.IP SUCCESS 
if job is within the resources left on the system
.IP index 
of the 
.Av res_to_check 
array for the resource which was lacking.
.LP
This function will check to see if the there are enough resources available to
run the job.  The resources are specified in the global array 
.Av res_to_check .
If the resource is not found or set to infinity, the check is skipped.

.Fn check_server_max_user_run
.Cs
int check_server_max_user_run(server_info *sinfo, char *account)
.Ce
.IP Args: 4
.RS
.IP sinfo 
the server 
.IP account
account name of the owner of the job
.RE
.IP Returns: 4
.RS
.IP 0
if user is within server's max_user_run limit
.IP SERVER_USER_LIMIT_REACHED
if user is above server's max_user_run limit
.RE
.LP
This function counts the number of running jobs on the server which are owned 
by 
.Av account .  
If that less then the max_user_run attribute on the server then 
.Sc TRUE 
is returned.  If 
.Av max_user_run 
is not set, then this function does not count.

.Fn check_queue_max_user_run
.Cs
int check_queue_max_user_run(queue_info *qinfo, char *account)
.Ce
.IP Args: 4
.RS
.IP qinfo 
the queue
.IP account 
account name of the owner of the job
.RE
.IP Returns: 4
.RS
.IP 0
.br
if the user is within queue user run limits
.IP QUEUE_USER_LIMIT_REACHED
.br
if the user is above queue user run limits
.RE
.LP
This function counts the number of running jobs the user has running in the
queue and checks it against the 
.Av max_user_run 
of the queue.  Nothing is done if 
.Av max_user_run 
is not set

.Fn check_queue_max_group_run
.Cs
int check_queue_max_group_run(queue_info *qinfo, char *group)
.Ce
.IP Args: 4
.RS
.IP qinfo
information about the queue
.IP group
the group name
.RE
.IP Returns:
.RS
.IP 0
.br
if the group is within their queue group run limits
.IP QUEUE_GROUP_LIMIT_REACHED
.br
if the group is above their queue group run limits
.RE
.LP
This function counts the number of running jobs the group has in the queue and
checks that against the 
.Av max_group_run 
of the queue.  Nothing is done if 
.Av max_group_run 
is not set.

.Fn check_server_max_group_run
.Cs
int check_server_max_group_run(server_info *sinfo, char *group)
.Ce
.IP Args: 
.RS
.IP sinfo 
the server
.IP group 
group name
.RE
.IP Returns:
.RS
.IP 0
.br
if the group is within their server group run limits
.IP SERVER_GROUP_LIMIT_REACHED
.br
if the group is above their server group run limits
.RE
.LP
This function counts the number of running jobs the group has on the server
and checks that against the 
.Av max_group_run 
of the server.  Nothing will be done if
.Av max_group_run 
is not set

.Fn dynamic_avail
.Cs
long int dynamic_avail(resource *res)
.Ce
.IP Args: 4
.RS
.IP res 
the resource
.RE
.IP Returns:
the remaining availability of the resource
.LP
This function will return the remaining unallocated amount of a resource.  
The server will return the maximum amount of a resource(resources_max).  
It will also return the amount which is available for the scheduler to use
(resources_available).  If the 
.Av resources_available
attribute of the server is set, the amount available at the current time is
.Av resources_available 
- 
.Av resources_assigned .  
If it is not set, the maximum is used: 
.Av resources_max
-
.Av resources_assigned.

.Fn count_by_user
.Cs
int count_by_user(job_info **jobs, char *user)
.Ce
.IP Args: 4
.RS
.IP jobs
an array of jobs
.IP user 
the user name
.RE
.IP Returns:
The number of jobs the user owns in the array
.LP
This function counts the number of jobs the user owns in the array of jobs,
.Av jobs .

.Fn count_by_group
.Cs
int count_by_group(job_info **jobs, char *group)
.Ce
.IP Args: 4
.RS
.IP jobs
an array of jobs
.IP group\ 
the group name
.RE
.IP Returns:
    The number of jobs the group owns in the array
.LP
This function counts the number of jobs the group owns in the array of jobs.

.Fn check_ded_time_boundry()
.Cs
int check_ded_time_boundry( job_info *jinfo )
.Ce

.IP Args:
.RS
.IP jinfo 
The job to check
.RE

.IP Returns
.RS
.IP 0:
if the job will not cross into dedicated time
.IP CROSS_DED_TIME_BOUNDRY:
if the job will cross either dedicated time boundry (start or finish)
.RE

.LP
This function will check if the job will cross either dedtime boundry
(start or finish).  If it is currently
dedtime the function will check if the job will complete before dedtime 
is over.  If it is not currently dedtime, the function will check if the job
will finish before dedtime starts.

.Fn check_ded_time_queue()
.Cs
int check_ded_time_queue( queue_info *qinfo )
.Ce

.IP Args
.RS
.IP qinfo
The queue to check
.RE

.IP Returns 
.RS
.IP 0
if it is dedtime and the queue is a didtime queue or if it is not dedtime 
and the queue is not a dedtime queue
.IP DED_TIME
otherwis
.RE
.LP
This function will check if it is an approprate time to run jobs in the queue
If it is dedtime only dedtime queues can run jobs.  If it is not dedtime make
sure no jobs are run out of dedtime queues.

.Fn check_nodes()
.Cs 
int check_nodes( int pbs_sd, job_info *jinfo )
.Ce

.IP Args
.RS
.IP pbs_sd
the connection descriptor to the pbs server
.IP jinfo
the job to check
.IP ninfo_arr
Array of nodes
.RE
.IP Returns
.RS
.IP 0
if the job can run
.IP NOT_ENOUGH_NODES_AVAIL
if there are not suficient nodes of the correct type to run the job
.IP SCHD_ERROR
on error
.RE

.LP
First, this function will check what type of nodes the job needs.  If the job
needs cluster nodes, the function will make a 
.I pbs_rescquery()
call to see if there are sufficent nodes to be able to run the job.
If the job needs timesharing nodes a call to 
.I is_node_available
will be made and its value returned.

.Fn check_node_availability()
.Cs
int check_node_availability( job_info *jinfo, node_info **ninfo_arr )
.Ce

.IP Args
.RS
.IP jinfo
.br
The job to check if there is a node available for
.IP ninfo_arr
.br
The array if nodes to check if the job will fit
.RE
.IP Returns
.RS
.IP 0
if the node is available
.IP NO_AVAILABLE_NODE
if the node is not available
.RE

.LP
This function is used to find out if a node exists which the job can be run on.
Currently the function will check if the arch of the job and the machine match,
the memory is not more then the max physmem of the machine, and that the
load avereage wont raise above the max load ave for a node.

.Fn check_starvation
.Cs
int check_starvation( job_info *jinfo )
.Ce

.IP Args:
.RS
.IP jinfo
the current job to check
.RE

.IP Returns
.RS
.IP 0
.br
If 
.Av jinfo 
is the starving job or there are no starving jobs or starving
jobs are not being helped
.IP JOB_STARVING
.br
if jinfo is not the starving job and there are starving jobs
.RE
.LP 
This function will allow only the starving job to run if there are starving
jobs and the scheduler is helping starving jobs.  

.NH 4
.Fi fairshare.c
.LP
This file contains all the functions dealing with the fairshare algorithm.  
The functions to create the group_info structures, and to create the resource
group tree.  Also the functions to collect usage, and to select the next best
job to be considered to be run.

.Fn add_child

.Cs 
void add_child( group_info *ginfo, group_info *parent )
.Ce
.IP Args: 4
.RS
.IP node
The group_info to add to the tree
.IP parent
The parent of the group_info to be added to the tree
.RE
.LP
The function adds ginfo onto the resource group tree.  The parent of where the 
node should be is passed in.  It connects the group_info, and sets the resgroup.

.Fn add_unknown

.Cs
void add_unknown( group_info *node )
.Ce
.IP Args: 4
.RS
.IP node
the node to add
.RE

.LP
The function will add the node onto the "unknown" group.  It also recalculates
the fair share percentages for the unknown group since they will have changed.

.Fn find_group_info

.Cs
group_info *find_group_info( char *name, group_info *root )
.Ce
.IP Args: 4
.RS
.IP name
The name of the group_info to find
.IP root
the root of the tree
.RE

.IP Returns
the found group_info or
.Sc NULL

.LP
This is a recursive function which runs through the fair share tree trying 
to find the group_info whose name is passed in.

.Fn find_alloc_ginfo
.Cs
group_info *find_alloc_ginfo( char *name )
.Ce
.IP Args: 4
.RS
.IP name 
the name of the group_info to find or allocate
.RE

.IP Returns
The group if it is found, or the new group if it is created

.LP
This function will either find the specified group_info, or allocate an new 
group_info with the specified name and add it to the "unknown" group.

.Fn new_group_info

.Cs 
group_info *new_group_info()
.Ce

.IP Returns
a point to the new group_info struct

.LP
Allocate and initialize a group_info structure

.Fn parse_group
.IP Args: 4
.Cs
int parse_group( char *fname )
.Ce

.RS
.IP fname
the name of the file to parse
.RE

.IP Returns 
success/failure

.LP
This function opens and parses the the resource_group file.  It will take each
line of the file and either add a new group_info to the tree or print 
an error.  The function does rudimentary error checking.

.Fn free_group_tree
.Cs
void free_group_tree( group_info *root )
.Ce
.IP Args: 4
.RS
.IP root
The root of the resource group tree
.RE

.LP
This is a recursive function which will free all the group_info structures 
in the resource group tree.

.Fn preload_tree
.Cs
int preload_tree()
.Ce

.IP Returns:
success/failure

.LP
This function loads the "root" group and the "unknown" group into the 
resource group tree.  This function should be called after parse_config(
because it uses the unknown_shares value from the config file.

.Fn count_shares
.Cs
int count_shares( group_info *grp )
.Ce
.IP Args: 4
.RS
.IP grp
.RE
.IP Returns
the number of shares in the group
.LP
This function will count the number of shares in a resource group.  It will 
go down a sibling chain and count the shares.

.Fn calc_fair_share_perc
.Cs
int calc_fair_share_perc( group_info *root, int shares )
.Ce
.IP Args: 4
.RS
.IP root 
The root of the current subtree
.IP shares 
The total number of shares in the group or UNSPECIFIED if the value is unknown
.RE
.IP Returns
success/failure

.LP
This function recurses down the resource group tree calculating the percentange
of the machine a user gets.  A user is defined as a leaf of the tree.  The 
function that is used: parent_percentage * (shares/total_group_shares).  The
percentage of the "root" group is 1.0.  When a child link is taken to a new 
group is taken, the shares of that group is counted.  

.Fn test_perc
.Cs
float test_perc( group_info *root )
.Ce
.IP Args:
.RS
.IP root
The root of the current subtree
.RE
.IP Returns:
total percentage (hopefully 1.0)

.LP
This is a debugging function to test the percentages calculated from the 
resource group tree.  It recursivly traverses the tree and adds the percentages
for the leaves (users).  The target number is 1.0.

.Fn update_usage_on_run
.Cs
void update_usage_on_run( job_info *jinfo )
.Ce
.IP Args:
.RS
.IP jinfo
The job which was just run
.RE

.LP
This function will add the entire jobs usage to the job temporarly.  It will 
last for this cycle only.

.Fn calculate_usage_value
.Cs
long calculate_usage_value( resource_req *resreq )
.Ce
.IP Args:
.RS
.IP resreq
The resources to calculate the usage value from
.RE
.IP Returns
The calculated value

.LP
This function takes all the usage into account which is stored in the 
resource_req struct passed in.  This function is to be modified how the 
scheduling policy wants to collect the usage.  Currently it only accumulates
cput.  An example of another method would be to accumute cput * 100000 + mem.
This would make cput much more important them memory usage, but memory usage
would come into effect also.

.Fn decay_fairshare_tree
.Cs
void decay_fairshare_tree( group_info *root )
.Ce
.IP Args: 4
.RS
.IP root
the root of the current subtree
.RE

.LP
This function decays the resource group tree.  Since the algorighm calls for
a half life, the function decays the information by 50%.  If the usage decays
to zero, it is reset to the default value of one.
The function is recursive.  The tree gets decayed in a post order traversal.

.Fn extract_fairshare
.Cs
job_info *extract_fairshare( job_info **jobs )
.Ce
.IP Args: 4
.RS
.IP jobs
The array of jobs to extract from
.RE
.IP Returns:
the job with the max fairshare value

.LP
This is a extract max function for the fair share algorithm.  The function 
extracts the job with the max value of the function percentage / usage.  The
value which is returned will be first job of the user with the max value.
Usage defaults to one and will not decay below that, so no division by zero 
error can happen.  The function runs in O(n) time.

.Fn print_fairshare
.Cs
void print_fairshare( group_info *root )
.Ce
.IP Args:
.RS
.IP root
The root of the current subtree
.RE

.LP
This function will print out the fair share tree in a preorder traversal.

.Fn write_usage
.Cs
int write_usage()
.Ce
.IP Returns:
success/failure

.LP
This function opens the usage file and calls 
.I rec_write_usage()
to write out the resource group tree.

.Fn rec_write_usage
.Cs
void rec_write_usage( group_info *root, FILE *fp )
.Ce
.IP Args:
.RS
.IP root 
The root of the current subtree
.IP fp
file pointer of the usage file
.RE

.LP
This function copies the usage and name of a group_info struct into a 
group_node_usage struct.  The smaller struct is written out to the file.
Nodes with usage equal to one are not written out, since the default value 
for usage is one.  The function writes out in a preorder traversal.

.Fn read_usage
.Cs
int read_usage( )
.Ce
.IP Returns
success/failure

.LP
This function reads in the usage information into the usage file.  It will find
the correct group_info and assign the usage information into the group_info.  
.I find_alloc_ginfo() 
is called to find the group_info, so if the user is not in the tree 
already, a group_info will be added to the "unknown" group.

.NH 4
.Fi job_info.c
.LP
This file contains all the functions which have to deal with jobs.  The 
functions which create the job_info structures, and the resource_req structures

.Fn query_jobs
.Cs
job_info **query_jobs(int pbs_sd, queue_info *qinfo)
.Ce
.IP Args:
.RS
.IP pbs_sd\ 
the connection descriptor to the pbs server
.IP qinfo 
information about the queue 
.RE
.IP Returns:
a 
.Sc NULL 
terminated array of jobs that reside in the queue
.LP
This function will query all the jobs from the server that reside in the
queue.  It will then count the jobs so the correct ammount of space can be 
allocated.  After allocation is done, it will call 
.Av query_job_info 
on each of the
batch_status structs that the server returned.  It puts the 
sentinel value
.Sc NULL 
at the end of the array.  The group_info in the resource group tree is found 
and assigned into the job structure.  Finally, frees up the batch_status list.  

.Fn query_job_info
.Cs
job_info *query_job_info(struct batch_status *job, queue_info *queue)
.Ce
.IP Args: 4
.RS
.IP job
the job information returned from the server
.IP queue\ 
information about the queue the job resides in
.RE
.IP Returns:
    A pointer to a job_info struct of the processed data about the jobs
.LP
This function collects the data out of the linked list of values in the
batch_status structure and puts that data into a job_info structure.  It
checks for 
.Sc ATTR_p 
(priority), 
.Sc ATTR_qtime
(time job was queued),
.Sc ATTR_state 
(state of job), 
.Sc ATTR_comment
(job comment),
.Sc ATTR_euser 
(username of owner), 
.Sc ATTR_egroup 
(group name of owner), 
.Sc ATTR_exechost
(host the job is executing on),
.Sc ATTR_l 
(resource requested), and
.Sc ATTR_used
(resource used)

.Fn new_job_info
.Cs
job_info *new_job_info()
.Ce
.IP Returns:
Pointer to newly allocated and initialized job_info struct
.LP
This function allocates and initializes a job_info struct

.Fn new_resource_req
.Cs
resource_req *new_resource_req()
.Ce
.IP Returns:
Pointer to newly allocated and initialized resource_req struct
.LP
This function allocates and initializes a resource_req struct

.Fn find_alloc_resource_req
.Cs
resource_req *find_alloc_resource_req(char *name, resource_req *reqlist)
.Ce
.IP Args: 4
.IP name\ 
name of resource to look for
.IP reqlist\ 
.I resource_req 
list to look in
.IP Returns:
Pointer to found or newly allocated 
.I resource_req
.LP
This function will attempt to find the 
.I resource_req 
struct with the name
passed in.  If it is found, it is returned.  If it can not be found, a new
.I resource_req 
is allocated and the 
.Av name 
field is assigned.

.Fn free_job_info
.Cs
void free_job_info(job_info *jinfo)
.Ce
.IP Args: 4
.RS
.IP jinfo 
the job_info structure to free
.RE
.LP
This function will free all the memory used by a job_info struct.

.Fn free_jobs
.Cs
void free_jobs(job_info **jarr)
.Ce
.IP Args: 4
.RS
.IP jarr
array of jobs to free
.RE
.LP
This function calls 
.Av free_job_info 
all each element in the array.  Finally, it will free the array itself

.Fn find_resource_req
.Cs
resource_req *find_resource_req(resource_req *reqlist, const char *name)
.Ce
.IP Args: 4
.RS
.IP reqlist
.br
the 
.I resource_req 
linked list to search through
.IP name
the name to look for
.RE
.IP Returns:
Found resource_req or 
.Sc NULL 
if the resource can not be found
.LP
This function will search through the resource_req list looking for a
.I resource_req 
with the specified name.

.Fn free_resource_req_list
.Cs
void free_resource_req_list( resource_req *list )
.Ce
.IP Args:
.RS
.IP list
the resource_req list to free
.RE

.LP
Frees up memory used by a resource_req linked list.

.Fn print_job_info
.Cs
void print_job_info( ob_info *jinfo, char brief)
.Ce
.IP Args: 4
.RS
.IP jinfo 
job_info to print
.IP brief 
boolean
.RE
.LP
This function will print out the job info to stdout.  It is meant for
debugging purposes.  If the 
.Av brief 
flag is true, only the name of the job is printed.

.Fn set_state
.Cs
void set_state(char *state, job_info *jinfo)
.Ce
.IP Args: 4
.RS
.IP state 
the state of the job
.IP jinfo 
job information which needs one of the state bits set
.RE
.IP Returns:
.Av jinfo
is passed in by reference
.LP
This function will set one of the following state bits: 
.Av is_queued ,
.Av is_running ,
.Av is_held ,
.Av is_transit ,
.Av is_exiting ,
.Av is_waiting.

.Fn update_job_on_run
.Cs
void update_job_on_run(int pbs_sd, job_info *jinfo)
.Ce
.IP Args: 4
.RS
.IP pbs_sd\ 
connection descriptor to the pbs server
.IP jinfo  
the job which was just run
.RE
.LP
This function updates the state bit from 
.Av is_queued 
to 
.Av is_running .  

.Fn update_job_comment
.Cs
int update_job_comment(int pbs_sd, job_info *jinfo, char *comment)
.Ce
.IP Args: 4
.RS
.IP pbs_sd\ 
connection descriptor to the pbs server
.IP jinfo   
job to update
.IP comment 
the comment string 
.RE
.IP Returns:
    Success or Failure.  Use pbs_errno for more information
.LP
The function first checks if the comment of the job is the same of what it is
being set to.  If it is, the comment will not be updated.  If the comment is
not the same, the old space for the comment in 
.Av jinfo i
is freed in order to
update it.  Lastly pbs_alterjob is called to update the comment on the server

.Fn translate_job_fail_code()
.Cs
void translate_job_fail_code( int fail_code, char *comment_msg, char *log_msg )
.Ce
.IP Args: 4
.RS
.IP  fail_code 
the return code from the check functions
.IP  comment  
string passed by reference
.RE
.LP
This function will translate the failure code from 
.I is_ok_to_run_job()
to both a comment message and a log error message.  They are copied into 
buffers supplied by the caster.  Any code which is less then 
.Sc RET_BASE
is considered to be an index into the 
.Av res_to_check 
array.  The default action is the clear the comment message.  The symbolic 
constants are defined in config.h

.Fn update_jobs_cant_run
.Cs
void update_jobs_cant_run(int pbs_sd, job_info **jinfo_arr, job_info *start, 
					char *comment, int start_where)
.Ce
.IP Args: 4
.RS
.IP pbs_sd
connection descriptor to the pbs server
.IP jinfo_arr   
array of jobs to update comments for
.IP start       
the job to start updating comments or NULL: start at the front of the array
.IP comment     
the comment to update the jobs
.IP start_where 
where to start relative to the job start
.RE    
.IP Returns:
nothing  - updates comments of jobs in 
.Av jinfo_arr

.LP
This function will update all the comments in a job_info array.  It will
start before, at, or after the job in 
.Av start
depending on the 
.Av start_where 
parameter.  The function will also set the 
.Av job_can_not_run
bit.

.Fn job_filter
.Cs
job_info **job_filter(job_info** jobs, int size, int (*filter_func) (job_info*, void*), void *arg)
.Ce
.IP Args: 4
.RS
.IP jobs
an array of jobs
.IP size        
size of the array
.IP filter_func 
pointer to a function that will do filtering
.IP arg         
extra arg to pass to filter_func
.RE
.IP Returns:
    Pointer to the head of the newly allocated filtered array
.LP
This function will filter through the jobs in an array.  It will call
.Av filter_func 
on each job in the array.  If the function returns non-zero, the
job is kept, if it returns 0, the job is not kept.  A new array is allocated
and is up to the user to free.  

NOTE: Only an array of pointers has been allocated.  The jobs are not copied.

.NH 4
.Fi misc.c
.LP
This file contains miscellaneous functions which are used everywhere in the
scheduler

.Fn string_dup
.Cs
char *string_dup(char *str)
.Ce
.IP Args: 4
.RS
.IP str 
the string to duplicate
.RE
.IP Returns:
Pointer to a newly allocated copy of str
.LP
This function will allocate a new string and copy the parameter into the newly
allocated space.  

NOTE: This function was used instead of 
.Av strdup ()
because it is not in the POSIX.1 standard

.Fn log
.Cs
void log( int event, int class, char *name, char *text)
.Ce
.IP Args: 4
.RS
IP event
.br
the event type 
.IP class
.br
The event class of the log
.IP name
.br
the name of the object
.IP text
.br
the text of the log message
.RE
.LP
This function will first check if the event type is being filtered.  If it 
isn't log the record using
.I log_record().

.Fn res_to_num
.Cs
long int res_to_num(char *res_str)
.Ce
.IP Args: 4
.IP res_str 
the string returned by the server as a resource
.IP Returns:
    The numeric resource in kilobytes or kilowords for memory, or in seconds 
    for time
.LP
This function will convert a string in the form of HH:MM:SS into a number
corresponding to the total number of seconds.  It will also convert a memory
string into the corresponding number of kilobytes.  Symbolic 
constants
.Sc MEGATOKILO , 
.Sc GIGATOKILO , 
and 
.Sc TERATOKILO 
are used in the conversions.  The constant
.Sc SIZE_OF_WORD
is used in converting words to bytes.

.Fn skip_line
.Cs
int skip_line(char *line)
.Ce
.IP Args: 4
.RS
.IP line 
the line from a config file
.RE
.IP Returns:
.RS
.IP 1
skip the line 
.IP 0
parse the line
.RE
.LP
This function will return 1 if the line is a comment( starting with # or * ) or
a blank line of only white space.  

.NH 4
.Fi parse.c
.LP
This file contains functions which read in and parse the scheduling policy 
configuration file.

.Fn parse_config
.Cs
int parse_config(char *fname)
.Ce
.IP Args: 4
.RS
.IP fname 
a string containing the filename
.RE
.IP Returns:
success/failure and the global conf will be assigned
.LP
This function will open the scheduling policy config file and parse it.  The
global config variable 
.Av conf 
will be assigned with the correct values parsed
from the file.  The format of the file is:
.br
.ft 3
name : value
.ft 1
.br
The scanner is a little lax on scanning.  It will skip over white space and
the ':'.  The parser has rudimentary error detection and recovery.  If an
error is detected, a message is printed to stderr and the line is skipped.

.Fn init_config
.Cs
int init_config()
.Ce
.IP Returns:
success/failure
.LP
This function will initialize the global config structure, 
.Av conf .

.Fn reinit_config
.Cs
int reinit_config()
.Ce
.IP Returns:
success/failure

.LP
Frees up memory used by the conf config structure and frees the resource
group tree.
.I init_config()
is called to do the initialization.

.NH 4
.Fi queue_info.c
.LP
This file contains the functions to create and handle the queue_info 
structures.

.Fn query_queues
.Cs
queue_info **query_queues(int pbs_sd, server_info *sinfo)
.Ce
.IP Args: 4
.RS
.IP pbs_sd
.br
connection descriptor to the pbs server
.IP sinfo  
information about the server
.RE
.IP Returns:
Pointer to an array of queue_info structures
.LP
This function does a pbs_statque() to get the information about all the queues
on the server.  It will then count the queues and allocate an array of
pointers to point at queues.  Next, it will call 
.I query_queue_info() 
on each queue and assign them into that array.  The jobs are queried from the
server by 
.I query_jobs().
The function 
.I is_ok_to_run_queue()
is called on each job and is_ok_to_run is set.  If it is not OK to run, all
the job comments for the jobs in the queue are changed.  The job states are 
counted in the queues.  Finally, the list of running jobs is created and 
general cleanup is done.

.Fn query_queue_info
.Cs
queue_info *query_queue_info(struct batch_status *queue, server_info *sinfo)
.Ce
.IP Args: 4
.RS
.IP queue 
the batch_status struct returned from the server 
.IP sinfo 
information about the server the queue resides in
.RE
.IP Returns: 
Pointer to newly allocated and assigned queue_info struct or 
.Sc NULL 
on error
.LP
This function takes information out the the linked list in the batch_status
struct and puts it into a queue_info struct.  The following attributes are
converted: 
.Sc ATTR_start 
(started), 
.Sc ATTR_maxrun 
(max_running), 
.Sc ATTR_maxuserrun
(max_user_run), 
.Sc ATTR_maxgrprun 
(max_group_run),
.Sc ATTR_p 
(priority), and 
.Sc ATTR_qtype 
(queue_type)

.Fn new_queue_info
.Cs
queue_info *new_queue_info()
.Ce
.IP Returns:
Pointer to a newly allocated and initialized queue_info
.LP 
This function allocates a new queue_info struct and initializes it.

.Fn print_queue_info
.Cs
void print_queue_info(queue_info *qinfo, char brief, char deep)
.Ce
.IP Args: 4
.RS
.IP qinfo 
the queue to print info about
.IP brief 
only print queue name
.IP deep
print info about jobs in queue also
.RE
.LP
This function will print out a queue_info structure.  It is mainly used for
debugging.  If 
.Av brief 
is true, then only the name of the queue is printed.  If
.Av deep 
is true, all the jobs in the queue will be printed.  
.Av brief 
is passed to 
.I print_job_info()

.Fn update_queue_on_run
.Cs
void update_queue_on_run(queue_info *qinfo, job_info *jinfo)
.Ce
.IP Args: 4
.RS
.IP jinfo 
the job which was run
.IP qinfo 
the queue 
.Av jinfo
is in
.RE
.LP
This function updates the state counts in the queue

.Fn free_queues
.Cs
void free_queues(queue_info **qarr, char free_jobs_too)
.Ce
.IP Args: 4
.RS
.IP qarr
an array of queues
.IP free_jobs_too 
free the jobs in the queues also
.RE
.LP
This function will call free_queue_info on each queue in the array and then
finally free the array.  If 
.Av free_jobs_too 
is true, free_jobs is called on the job arrays within the queues.

.Fn free_queue_info
.Cs
void free_queue_info(queue_info *qinfo)
.Ce
.IP Args: 4
.RS
.IP qinfo 
pointer to a queue_info structure to free
.RE
.LP
This function will free all the memory used by a queue_info struct

.NH 4
.Fi server_info.c
.LP
This file contains all the functions to create, handle, and free the 
server_info and the resource structures.

.Fn query_server
.Cs
server_info *query_server(int pbs_sd)
.Ce
.IP Args: 4
.RS
.IP pbs_sd 
connection descriptor to the pbs server
.RE
.IP Returns:
A newly allocated server_info struct 
.LP
This function calls pbs_statserver() to get batch_status struct about the
server.  It calls 
.I query_server_info() 
to collect all the server information.  The nodes are querried by a call to 
.I query_nodes(). 
It calls 
.I query_queues() 
to get all the info about the queues (which 
gets the info about the jobs).  It then counts the number of queues and 
collects all the state counts.  It will then allocate a 
.I job_info 
array and copy into it pointers to all the jobs.  Finally it will set 
.Av running_jobs 
by filtering out all but running jobs.  Timesharing nodes are also set in a 
simular way.

.Fn query_server_info
.Cs
server_info *query_server_info(struct batch_status *server)
.Ce
.IP Args: 4
.IP server 
batch_status struct returned from the server
.IP Returns:
pointer to newly allocated and assigned server_info struct
.LP
This function will allocate a new server_info struct.  It will then fill it
with the information from the linked list within server.  It checks the
following: 
.Sc ATTR_dfltque 
(default_queue), 
.Sc ATTR_maxrun 
(max_running), 
.Sc ATTR_maxuserrun 
(max_user_run), 
.Sc ATTR_maxgrprun 
(max_group_run), 
.Sc ATTR_rescavail 
(resources_available), 
.Sc ATTR_rescmax 
(resources_max), 
.Sc ATTR_rescassn 
(resources_assigned)
It will combine the 
.Av resources_available , 
.Av resources_max , 
and 
.Av resources_assigned
into one resource structure

.Fn find_alloc_resource
.Cs
resource *find_alloc_resource(resource *resplist, char *name)
.Ce
.IP Args: 4
.RS
.IP resplist\ 
resource list to search
.IP name     
resource name to search for in the list
.RE
.IP Returns:
pointer to found resource a newly allocated resource
.LP
This function will search through the the 
.Av resplist .  
If it find the resource,
it returns it.  If it is not found, then a new resource is allocated and added
to the 
.Av resplist .
The 
.Av name 
field is also set.

.Fn find_resource
.Cs
resource *find_resource(resource *reslist, const char *name)
.Ce
.IP Args: 4
.RS
.IP reslist 
.br
resource list to search through
.IP name    
the name to search for
.RE
.IP Returns:
pointer to found resource or 
.Sc NULL
.LP
This function searches through the reslist for the resource specified.

.Fn free_server_info
.Cs 
void free_server_info(server_info *sinfo)
.Ce
.IP Args: 4
.RS
.IP sinfo 
the server to free
.RE
.LP
This function frees all the memory associated with a server_info structure

.Fn new_server_info
.Cs
server_info *new_server_info( )
.Ce
.IP Returns: 
newly allocated and initialized server_info struct
.LP
This function allocates and initializes a new server_info struct

.Fn new_resource
.Cs
resource *new_resource()
.Ce
.IP Returns:
newly allocated and initialized resource struct
.LP
This function allocates and initializes a new resource struct

.Fn print_server_info
.Cs
void print_server_info(server_info *sinfo, char brief)
.Ce
.IP Args:
.RS
.IP sinfo 
information about the server
.IP brief 
if true only print the server name
.RE
.LP
This function will print all the fields in a server_info struct.  If 
.Av brief 
is true, it will only print the name.

.Fn free_server
.Cs
void free_server(server_info *sinfo, int free_queues_too)
.Ce
.IP Args: 4
.RS
.IP sinfo\ 
the server to free
.IP free_queues_too 
if true, will call 
.I free_queues() 
on the queues
.RE
.LP
This function will call 
.I free_server_info() 
to free the server, and if 
.Av free_queues_too 
is true, will call 
.I free_queues() 
to free the queues and jobs.

.Fn update_server_on_run
.Cs
void update_server_on_run(server_info *sinfo, queue_info *qinfo, job_info *jinfo)
.Ce
.IP Args: 4
.RS
.IP sinfo
server to update
.IP qinfo
queue the job was in
.IP jinfo
the job which was run
.RE
.LP
This function updates the information in a 
.I server_info 
structure when one of its jobs has been run.  
First the function will update the running and queued counts, and then update
the resources that were assigned to the job.

.Fn set_jobs
.Cs
void set_jobs(server_info *sinfo)
.Ce
.IP Args: 4
.IP sinfo
.br
the server
.LP
This function will create an array of all the jobs on the server from the 
arrays contined in the queues.  The array will be a list of pointers to the
jobs.  The jobs themselves are not copied.

.Fn check_run_job
.Cs
int check_run_job(job_info *job, void *arg)
.Ce
.IP Args: 4
.RS
.IP job 
the job to check
.IP arg 
optional argument
.RE
.IP Returns:
.RS
.IP 1
if the job is running
.IP 0
if the job is not running
.RE
.LP
This function is used by job_filter to keep only running jobs.
i.e. return 1 if the job is running.

.NH 4
.Fi state_count.c
.LP 
This file contains all the functions to handle state_count structures

.Fn print_state_count
.Cs
void print_state_count(state_count *sc)
.Ce
.IP Args: 4
.RS
.IP sc 
state_count to print
.RE
.LP
This function prints all the fields of a state_count struct.  It is mainly
used in debugging.

.Fn init_state_count 
.Cs
void init_state_count(state_count *sc)
.Ce
.LP
This function initializes the state count passed in as a parameter

.Fn count_states
.Cs
void count_states(job_info **jobs, state_count *sc)
.Ce
.IP Args: 4
.RS
.IP jobs 
array of jobs
.IP sc 
state_count passed in as reference
.RE
.IP Returns:
sc is passed in by reference
.LP
This function will loop through the jobs in the array and count the amount in
each state.  Then total is set by adding the counts together.
.Fn total_states
.Cs
void total_states(state_count *sc1, state_count *sc2)
.Ce
.IP Args:
.RS
.IP sc1 
state_count struct which gets accumulated into
.IP sc2 
state_count which gets added into sc1
.RE
.IP Returns:
    sc1 is passed by reference
.LP 
Basically this function does 
.Av sc1 
+= 
.Av sc2 ;
all the fields of 
.Av sc1 
are added with the like field in 
.Av sc2 
and stored in 
.Av sc1

.NH 4
.Fi fifo.c
.LP
This file contains the most important functions in the scheduler.  The two 
main functions which are called for by pbs_sched.c, 
.I schedule()
and
.I schedinit().
.I Schedule()
will handle the scheduling command, and call
.I scheduling_cycle()
to handle a normal cycle.  It calls the rest of the functions in order to 
run the jobs.

.Fn schedinit
.Cs
int schedinit(int argc, char *argv[])
.Ce
.IP Args: 4
.RS
.IP argc 
number of arguments passed into the program on the command line.
.IP argv 
the arguments passed into the program on the command line.
.RE
.IP Returns:
success/failure
.LP
This function calls several functions to parse the config files to set up the
scheduler for operation.

.Fn init_scheduling_cycle
.Cs
int init_scheduling_cycle(server_info *sinfo)
.Ce
.IP Args: 4
.IP sinfo 
the server/queue/job info structure
.IP Returns:
success/failure
.LP
This function takes care of things that need to before happen every scheduling 
cycle.  If fairshare is turned on, it will collect the usage information by
finding the difference between the current resources_used minus the last cycles 
resources_used.  A check to see if it is time to decay is done.  It is 
possible it should have happened in the past, so the
.Av last_decay
variable will be set to when it should have happened.  A check to see if 
it is time to sync the usage happens also.  If the queues need to be sorted, 
they are sorted by priority, and the jobs are sorted if a sort was selected. 
It also calls 
.I next_job(1) 
to initialize the scheduling policy.

.Fn schedule
.Cs
int schedule(int cmd, int sd)
.Ce
.IP Args:
.RS
.IP cmd 
The reason why schedule was called
.IP sd  
connection descriptor to the pbs server
.RE
.IP Returns:
success/failure
.LP
This is the function which gets called to start a scheduling cycle.  A switch
will be done on 
.Av cmd
to see what needs to be done.
.Sc SCH_ERROR ,
.Sc SCH_SCHEDULE_NULL ,
.Sc SCH_RULESET ,
.Sc SCH_SCHEDULE_RECYC
are ignored.  
.Sc SCH_SCHEDULE_RECYC 
is ignored because it is meant for a type of scheduler which will only run one
job at a time.  The server will send a recycle command to the scheduler if only
one job is run.  There is no reason to run another scheduling cycle if this 
occurs.

.Sc SCH_SCHEDULE_NEW ,
.Sc SCH_SCHEDULE_TERM ,
.Sc SCH_SCHEDULE_FIRST ,
.Sc SCH_SCHEDULE_CMD ,
.Sc SCH_SCHEDULE_TIME
will cause a scheduling cycle to be run.  The function 
.I scheduling_cycle()
is called.

.Sc SCH_CONFIGURE
will cause the scheduler to reinitialize its self.  The usage information will
be written to disk.  The config structure will be reinitialized, and the config
files will be reread.  Lastly the usage info is read back from disk.

.Sc SCH_QUIT
returns 1 from schedule() which will cause the scheduler to exit nicely.

by default return zero which will cause the scheduler to wait for its next 
cycle to be started.

.Fn update_cycle_status
.Cs 
void update_cycle_status()
.Ce

.LP
This function will update all the status bits in the beginning of every 
scheduling cycle.  It checks for dedicated time, chage in primetime, and sets
the status them.

.Fn scheduling_cycle
.Cs
int scheduling_cycle( int sd )
.Ce
.IP Args: 4
.RS
.IP sd
the connection descriptor to the PBS server
.RE

.LP
This is the main function which controls the scheduling cycle.  It will first
call 
.I query_server() 
to set up the server/queue/job info structure.  Then it will call 
.I schedule_init()
to initialize the scheduling cycle.  Finally it gets
into the main loop.  This loop is controlled by successive calls to 
.I next_job() .
Once 
.I next_job() 
returns the next job to run, the function will call
.I is_ok_to_run_job() 
to see if it is within server and queue limits to run.  If
it can be run, the job will be passed to 
.I run_update_job()
to run the job and to update the internal information (server/queues/jobs).
Finally the running jobs are saved and the 
server / queue / job structure is freed up.

.Fn update_last_running
.Cs 
int update_last_running( server_info *sinfo )
.Ce
.IP Args: 4
.RS
.IP sinfo
the server info
.RE
.IP Returns
success/failure

.LP
This function frees up the jobs pointed to by the global variable
.Av last_running ,
and it will create a new array from the current running jobs.

.Fn run_update_job
.Cs
int run_update_job(int pbs_sd, server_info *sinfo, queue_info *qinfo, job_info *jinfo)
.Ce
.IP Args: 4
.RS
.IP pbs_sd\ 
connection descriptor to the pbs server
.IP sinfo  
information about the server the job resides in
.IP qinfo  
information about the queue the job resides in
.IP jinfo  
the job which needs to run
.RE
.IP Returns:
success/failure  - see pbs_errno for more details
.LP
This function will first run the job and then call the necessary update
functions to update the information kept about the jobs in this scheduling 
cycle.  This is done so the server does not need to be consulted every time a 
job is run.  If load balencing is on, the function will call 
.I find_best_node()
to find the best node to run the job on.  If
.I pbs_runjob() 
fails, the job comment will be updated to the PBS error message.

.Fn next_job
.Cs
job_info *next_job(server_info *sinfo, int init)
.Ce
.IP Args: 4
.RS
.IP sinfo    
the server to find the next job to run
.IP init
Whether or not to initialize 
.RE
.IP Returns:
The next job to run
.LP
This is the main function which controls the scheduling policy.  It finds the
next job to be considered for running.  There are currently three deciding
places in this function, whether the jobs should be run round robin, by queue,
or just in server order.  Several static variables help out.  The variables
are 
.Av last_job , 
.Av last_queue , 
and 
.Av cjobs .

If the jobs are to be run in round robin order, the init section will allocate 
an array of an array of jobs, 
.Av cjobs .
This will be used to cycle through the queues.  If
strict fifo is set and a job could not run, that queue in the array, 
.Av cjobs ,
will be set to 
.Sc NULL 
to insure no more jobs will run from that queue. If fairshare is turned on, 
instead of picking the next job in the queue to run,
.I extract_fairshare()
is called to find the next job to run.

If the jobs will be running by queue, the variable 
.Av last_job 
and 
.Av last_queue 
are used to index into the 
.Av "sinfo -> queues[] -> jobs[]" 
arrays.  If fairshare is turned on, 
.Av "sinfo -> queues[] -> jobs[]" 
is passed into 
.I exract_fairshare()
for the next job to be picked.
Lastly if the jobs are to be run in queue order, the 
.Av "sinfo -> jobs[]"  
array is used along with the 
.Av last_job 
variable.  If fairshare is turned on, "sinfo -> jobs[]" is passed into the 
e  If fairshare is turned on, "sinfo -> jobs[]" is passed into the 
.I extract_fairshare()
function for the next job to be found.

.Fn update_starvation()
.Cs
job_info *update_starvation( job_info **jobs );
.Ce

.IP Args:
.RS
.IP jobs
The jobs to update their sch_priority 
.RE

.IP Returns
The most starving job

.LP
This function will go through all the jobs and set their 
.Av sch_priority .
It will be set to 
.I "qtime / max_starve."
Which means every time the job waits a
.Av max_starve
period of time, thier 
.Av sch_priority
goes up by one.

.NH 4
.Fi prime.c
.LP
This file contains all the functions dealing with primetime.

.Fn is_prime_time
.Cs
enum prime_time is_prime_time( )
.Ce
.IP Returns
.RS
.IP PRIME
if it is primetime
.IP NONPRIME
if it is non-primetime
.RE

.LP
This function checks to see if it is primetime or not.  It uses the information
in the global config struct.  It will first check if it is a holiday.  Holidays 
are nonprimetime.  It will then call 
.I check_prime()
to see whether or not it is primetime.

.Fn check_prime
.Cs
enum prime_time check_prime( enum days d, struct tm *t )
.Ce
.IP Args:
.RS
.IP d
the day to check: SATURDAY SUNDAY or WEEKDAY
.IP t
the current time in a struct tm
.RE
.IP Returns
PRIME or NONPRIME

.P
The function will return PRIME or NONPRIME depending on the status of primetime
The function first checks for all or none status.  It will nextly check if 
primeime does not cross a day boundry (i.e. primetime is 0700-1800).  It will 
then check if primetime is less then one hour.  Finally a check if primetime
crosses a day boundry(i.e. 2200-0400).

.Fn is_holiday
.Cs
int is_holiday( int jdate )
.Ce
.IP Args: 4
.RS
.IP jdate
the julien date
.RE
.IP Returns:
True if it is a holiday

.LP
This function looks though the holiday list to see if today is a holiday

.Fn parse_holidays
.Cs
int parse_holidays( char *fname )
.Ce
.IP Args
.RS
.IP fname
the name of the file to parse
.RE
.IP Returns 
success/failure

.LP
This function will read in and parse the holidays file.  It will first check
for the first word to be 4 numbers.  This will be the year for prime/nonprime.
Next it will check for YEAR, to set teh current year.  It will then check for 
weekday/saturday/sunday to set primetime/nonprime (different format the above).
Finally it will read in the holidays.  The parser will ignore the string 
"HOLDAYFILE_VERSION1"  It is part of the spec for the UNICOS 8 holidays format.

.Fn load_day
.Cs
int load_day( enum days d, enum prime_time pr, char *tok )
.Ce
.IP Args:
.RS
.IP d
the day to load
.IP pr
PRIME/NONPRIME
.IP tok
the time or "all" or "none"
.RE
.IP Returns:
success(0) / failure(-1)

.LP
This function will set a primetime or nonprimetime values for a day.

.Fn init_prime_time
.Cs
void init_prime_time( )
.Ce

.LP
This function is called at the beginning of prime time.  currently it only 
changes the scheduling policy bits and the sort to the primetime values.

.Fn init_non_prime_time
.Cs
void init_non_prime_time( )
.Ce

.LP
This function is called at the beginning of non prime time.  Currently it 
only changes the policy bits and the sort to the nonprimetime value.

.NH 4
.Fi prev_job_info
.LP
This file contains all the functions for creating and destorying 
prev_job_info structs.

.Fn create_prev_job_info
.Cs
prev_job_info *create_prev_job_info( job_info **jinfo_arr, int size )
.Ce
.IP Args:
.RS
.IP jinfo_arr 
array of jobs
.IP size
size of the array or 
.Sc UNSPECIFIED 
if unknown
.RE
.IP Returns: 
newly created and filled prev_job_info array

.LP
This function will allocate a new prev_job_info array and fill it with the
jobs in jinfo_arr.  If 
.Av size
is set to
.Sc UNSPECIFIED
the jobs will be counted.  The 
.Av name ,
.Av resused ,
and
.Av account 
fields in 
.Av jinfo_arr
will be cleared so they will not be freed at the end of the scheduling cycle.

.Fn free_prev_job_info
.Cs
void free_prev_job_info( prev_job_info *pjinfo )
.Ce
.IP Args: 4
.RS
.IP pjinfo 
job to free
.RE

.LP
This function frees all the memory used by a prev_job_info struct.
Note that it does not free the structure its self.  That is part of an arary
and will be freed later.

.Fn free_pjobs
.Cs
void free_pjobs( prev_job_info *pjinfo_arr, int size )
.Ce
.IP Args: 4
.RS
.IP pjinfo_arr
the array to free
.IP size
the size of the array
.RE
.LP
This function calls 
.I free_prev_job_info()
on every job in
.Av pjinfo_arr
and then frees the array.

.NH 4
.Fi dedtime.c
.LP
This file has all the functions which are specific to dedicated time support

.Fn parse_ded_file
.Cs
void parse_ded_file( char *filename )
.Ce

.IP Args:
.RS
.IP filename
The name of the file to parse
.RE

.LP
This function will parse a dedicated time file in the format of
.br
MM/DD/YYYY HH:MM MM/DD/YYYY HH:MM
.br
If the two digit format is used(which is the wrong format) and 
the year 2000 is shortened to 00, it is 
smart enough to turn that into the correct date.  It does this by checking 
if it is smaller then some year in the past (90... why 90?  why not?), and 
adding 100 to it.  Note this will break if the year 2100 is shortened to 00.  

The function will use mktime to turn the date into a UNIX time_t and store it 
in the global config data structure.  Finally it will sort the dedicated times.
Zero is a non valid dedtime, it is sorted to the end of the array.

.Fn is_ded_time
.IP Returns
.RS
.IP 1 
if it is dedicated time
.IP 0 
if it is not dedicated time
.RE

This function checks if it is dedicated time.

.NH 4
.Fi node_info.c
.LP
This file contains all the functions which create, handle, and free node_info
structures.  It also contains some functions to handle load balencing.

.Fn query_nodes()
.Cs
node_info **query_nodes( int pbs_sd, server_info *sinfo )
.Ce

.IP Args:
.RS
.IP pbs_sd
.br
communication descriptor to the pbs server
.IP sinfo
.br
The server the nodes are associated with
.RE

.IP Returns
An array of nodes which are associated with the server

.LP
This function will call 
.I pbs_statnode()
and then convert the batch_status which is returned into an array of nodes.
It does this by looping through the linked list returned by 
.I pbs_statnode()
and counting the elements.  It will use that count to allocate the array
for the nodes.  It will then loop through the linked list a second time calling
.I query_node_info()
on each element.  Also, it will call 
.I talk_with_mom()
to get all the information from the resource monitor on the node.

.Fn query_node_info()
.Cs
node_info *query_node_info( struct batch_status *node, server_info *sinfo )
.Ce

.IP Args:
.RS
.IP node 
.br
The batch_status node returned from the pbs server
.IP sinfo
.br 
The server the node is associated with
.RE

.IP Returns
a node_info with all the information from the batch_status

.LP
This function will loop through the attributes in the batch_status struct and
set the apporprite values in the node_info.

.Fn new_node_info()
.Cs
node_info *new_node_info()
.Ce

.IP Returns
New node_info struct

.LP
This function will create a new node_info struct and initialize the values

.Fn free_nodes()
.Cs
void free_nodes( node_info **ninfo_arr )
.Ce

.IP Args
.RS
.IP ninfo_arr
.br
The array of nodes to free
.RE

.LP
Call 
.I free_node_info()
on every member of the array and then free the array itself.

.Fn free_node_info()
.Cs
void free_node_info( node_info *ninfo )
.Ce

.IP Args
.RS
.IP ninfo
.br
The node to free
.RE

.LP
Free all the memory used bu a node_info structure

.Fn set_node_type()
.Cs
int set_node_type( node_info *ninfo, char *ntype )
.Ce

.IP Args:
.RS
.IP ninfo
.br
The node to set type
.IP ntype
.br
The node type
.RE
.IP Returns
non-zero on error

.LP
This function will set one of the nodes type fields 
(is_timeshare or is_cluster).

.Fn set_node_state
.Cs
int set_node_state( node_info *ninfo, char *state )
.Ce

.IP Args:
.RS
.IP ninfo
.br
The node to set state
.IP state
.br
The State
.RE

.IP Returns
non-zero on error

.LP
This function will set the state bits on the node by breaking the state string
by commas and then setting the correct state bit for each state listen in the 
string.

.Fn talk_with_mom()
.Cs
int talk_with_mom( node_info *ninfo )
.Ce

.IP Args:
.RS
.IP ninfo 
.br
The node to get information from its mom
.RE
.IP Returns
non-zero on error

.LP
This function will connect to the nodes mom and get the resources that are
defined in the global 
.Av res_to_get .
The information is then processed and converted into the correct types and 
assigned to the node.

.Fn node_filter
.Cs
node_info **node_filter( node_info **nodes, int size,
			 int (*filter_func) (node_info*, void*), void *arg )
.Ce

.IP Args:
.RS
.IP nodes
.br
the array of nodes to filter
.IP size
.br 
the number of nodes in the array
.IP filter_func
.br
a pointer to a function which will be used to filter the nodes
.IP arg
.br
an optional arg to be passed to the filter_func
.RE

.IP Returns
filtered array

.LP
This function will call the filter function each element in the array.  If the
filter function returns a non-zero value, the element is included in the new 
array.  The array is initially allocated to the entire size of the original
array, and then realloced to the final size after the new array is complete.

.Fn is_node_timeshared
.Cs
int is_node_timeshared( node_info *node, void *arg )
.Ce

.IP Args
.RS
.IP node 
.br
the node to check if it is timeshared or not
.IP arg
.br
Unused
.RE

.IP Returns
.RS
.IP 1
if the node is timeshared
.IP 2
If the node is not timeshared
.RE

.LP
This function checks if a node is timeshared or not.  It is used in conjuction
with node_filter

.Fn find_best_node
.Cs
node_info *find_best_node( job_info *jinfo, node_info **ninfo_arr )
.Ce

.IP Args
.RS
.IP jinfo
.br
The job to find the best node for
.IP ninfo_arr
.br
The array of nodes to find the best node for the job
.RE

.IP Returns
the best node to run the job on

.LP
This function will search through all the nodes to find a node which the job
has requested the same arch and the node has enough memory.  It will find the
first node which the added load will not raise the node above the ideal load
level.  If no such node exists, then find the first node which the added load 
will not raise it above its max load.  The best node is returned.

.Fn find_node_info()
.Cs
node_info *find_node_info( char *nodename, node_info **ninfo_arr )
.Ce

.IP Args
.RS
.IP nodename
.br
the node to find
.IP ninfo_arr
.br
the array of nodes to look in
.RE
.IP Returns
the found node or NULL if not found

.LP
Look in the node array and see if the node exists.  If it does, return it, 
if it doesnt, return NULL

.\" force next chapter to odd page
.bp
.if e \{
\&
.sp 10
.DS C
[This page is blank.]
.DE
.bp
\}
