/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * soelim - eliminate .so lines from troff documents
 *
 * This simple utility is provided to eliminate the .so lines
 * from troff documents by merging in the text from the referenced
 * source file.  Some systems already come with soelim, others do not.
 *
 * Usage: soelim [-d include [-d include]...] inputfile
 *	The named input file is opened processed.  Any .so line in the
 *	input is replace by the lines from the file.
 *
 *	Output is written to standard out
 */

#include <stdio.h>
#include <string.h>
#include <ctype.h>

char *sodir[] = { 0, 0, 0, 0, 0 };

main(argc, argv)
	int argc;
	char *argv[];
{
	int   dofile();
	int   dirct = 0;
	FILE *filein;
	int   i;
	extern int   optind;
	extern char *optarg;

	while ((i = getopt(argc, argv, "d:")) != -1) 
		switch (i) {
		    case (int)'d':	sodir[dirct++] = optarg;
					break;

		    default:	fprintf(stderr, "Usage: %s [-d include_dir] [filename ...]\n", argv[0]);
				return 1;
		}

	if (optind < argc) {
		for (i=optind; i<argc; ++i) {
			
			filein = fopen(argv[i], "r");
			if (filein == NULL) {
				fprintf(stderr, "soelim: unable to open %s\n", argv[i]);
				return (1);
			}
			if (dofile(filein) != 0)
				return (1);
		}
	} else {
		return ( dofile(stdin) );
	}
	return (0);
}

int dofile(filein)
	FILE *filein;
{
	char buf[256];
	int  dirindex;
	int  found;
	char newfile[1024];
	FILE *newin;
	char *pc;
	char *pdir;
	char *pso;

	while (fgets(buf, 255, filein) != NULL) {
		if (strncmp(buf, ".so ", 4) == 0) {
			dirindex = 0;
			found = 0;
			pso = buf + 4;
			while (*pso == ' ')
				pso++;
			pc = pso;
			while (isspace((int)*pc) == 0)
				pc++;
			*pc = '\0';
			while (pdir = sodir[dirindex] ) {
				(void)strcpy(newfile, pdir);
				(void)strcat(newfile, "/");
				(void)strcat(newfile, pso);

				if ((newin = fopen(newfile, "r")) != NULL) {
					found = 1;
					dofile(newin);
					break;
				}
				dirindex++;
			}
			if (found == 0) {
				/* try local directory */

				(void)strcpy(newfile, pso);
				if ((newin = fopen(newfile, "r")) != NULL) {
					dofile(newin);
				} else {
					fprintf(stderr, "Unable to find include file %s\n", pso);
					exit(1);
				}
			}

		} else {
			fputs(buf, stdout);
		}
	}
	fclose(filein);
	return (0);
}
