/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* 
 * Used by PBS on IBM SP systems to set environment for tasks spawned by poe as:
 *
 * pbspd job_key window_id_file cmd args
 *
 * This results in the execution of "cmd" with the arguments "args"
 * The environ variable MP_PARTITION is set to "job_key"
 * The environ variable MP_CHILD is used to index into the text file
 * window_id_file to obtain the window id which becomes the value of the
 * environ variable MP_MPI_NETWORK.
 */

#define SWLINELEN 5
char get_winid(winidfile, mpchild)
	char *winidfile;
	char *mpchild;
{
	FILE *wf;
	int   tid;
	char  buf[SWLINELEN+1];
	char  swid = '\0';
	

	if ((wf = fopen(winidfile, "r")) == NULL) 
		return '\0';
	tid = atoi(mpchild) + 1;

	while (tid--) {
		if (fgets(buf, SWLINELEN, wf) == NULL) {
			fclose(wf);
			return '\0';
		}
	}
	fclose(wf);
	swid = buf[0];
	return (swid);
}


main(int argc, char **argv)
{
	int	     len;
	char 	    *jk;
	char	    *mpchild;
	char	    winid;

	static char *job_key="MP_PARTITION=";
	static char job_win[15+SWLINELEN]="MP_MPI_NETWORK=";

	/* Check that calling args are correct */

	if (argc < 4) {
		fprintf(stderr, "%s: insufficent arguments\n", argv[0]);
		return 1;
	}

	if ((mpchild = getenv("MP_CHILD")) == NULL) {
		fprintf(stderr, "%s: MP_CHILD not in environment\n", argv[0]);
		return 1;
	}

	/*
	 * Build up job key and window variables and put into environment.
	 * The job key is the first argument.
	 * The switch window_id_file is the second argument.
	 */

	len = strlen(argv[1]) + strlen(job_key) + 1;
	if ((jk  = (char *)malloc(len)) == 0) {
		fprintf(stderr, "%s: cannot allocate memory\n", argv[0]);
		return 1;
	}
	(void)strcpy(jk, job_key);
	(void)strcat(jk, argv[1]);
	putenv(jk);


	winid = get_winid(argv[2], mpchild);
	if (winid == '\0') {
		fprintf(stderr, "%s: unable to obtain switch window id\n",
				argv[0]);
		return 1;
	}
	len = strlen(job_win);
	job_win[len] = winid;
	job_win[len+1] = '\0';
	putenv(job_win);

	/* now exec the real program with its args */
	
	if (execvp(argv[3], &argv[3]) < 0) {
		fprintf(stderr, "%s: unable to exec %s\n", argv[0], argv[3]);
		perror("error:");
		return 1;
	}
	return 0;
}
