/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: list_link.h,v 2.2 1999/07/21 22:56:22 lonhyn Exp $
 */

/*
 * list_link.h - header file for general linked list routines
 *		see list_link.c
 *
 *	A user defined linked list can be managed by these routines if
 *	the first element of the user structure is the list_link struct
 *	defined below.
 */

#ifndef LIST_LINK_H
#define LIST_LINK_H 1
/* list entry list sub-structure */

typedef struct list_link {
	struct list_link *ll_prior;
	struct list_link *ll_next;
	void		 *ll_struct;
} list_link;
typedef list_link list_head;


/* macros to clear list head or link */

#define CLEAR_HEAD(e) e.ll_next = &e, e.ll_prior = &e, e.ll_struct = (void *)0
#define CLEAR_LINK(e) e.ll_next = &e, e.ll_prior = &e

#define LINK_INSET_BEFORE 0
#define LINK_INSET_AFTER  1

#ifdef NDEBUG
#define GET_NEXT(pe)  (pe).ll_next->ll_struct
#define GET_PRIOR(pe) (pe).ll_prior->ll_struct
#else
#define GET_NEXT(pe) get_next(pe, __FILE__, __LINE__)
#define GET_PRIOR(pe) get_prior(pe, __FILE__, __LINE__)
#endif

/* function prototypes */

extern void insert_link A_((list_link *old,list_link *new,void *pobj, int pos));
extern void append_link A_((list_head *head, list_link *new, void *pnewobj));
extern void delete_link A_((list_link *old));
extern void swap_link   A_((list_link *, list_link *));
extern int  is_linked A_((list_link *head, list_link *old));
extern void list_move A_((list_head *old, list_head *new));

#ifndef NDEBUG
extern void *get_next A_((list_link, char *file, int line));
extern void *get_prior A_((list_link, char *file, int line));
#endif	/* NDEBUG */

#endif /* LIST_LINK_H */
