/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: queue.h,v 2.2 1999/07/21 22:56:31 lonhyn Exp $
 */

/*
 * queue.h - struture definations for queue objects
 *
 * Include Files Requried:
 *
 *	<sys/types.h>
 *	"attribute.h"
 *	"list_link.h"
 *      "server_limits.h"
 *      "resource.h"
 *
 * Queue Types
 */

#ifndef QUEUE_H
#define QUEUE_H

#define QTYPE_Unset	0
#define QTYPE_Execution 1
#define QTYPE_RoutePush 2
#define QTYPE_RoutePull 3

/*
 * Attributes, including the various resource-lists are maintained in an
 * array in a "decoded or parsed" form for quick access to the value.
 *
 * The following enum defines the index into the array.
 */

enum queueattr {
	QA_ATR_QType,
	QA_ATR_Priority,
	QA_ATR_MaxJobs,
	QA_ATR_TotalJobs,
	QA_ATR_JobsByState,
	QA_ATR_MaxRun,
	QA_ATR_AclHostEnabled,
	QA_ATR_AclHost,
	QA_ATR_AclUserEnabled,
	QA_ATR_AclUsers,
	QA_ATR_FromRouteOnly,
	QA_ATR_ResourceMax,
	QA_ATR_ResourceMin,
	QA_ATR_ResourceDefault,

	/* The following attributes apply only to exection queues */

	QE_ATR_AclGroupEnabled,
	QE_ATR_AclGroup,
	QE_ATR_ChkptMim,
	QE_ATR_RendezvousRetry,
	QE_ATR_ReservedExpedite,
	QE_ATR_ReservedSync,
	QE_ATR_ResourceAvail,
	QE_ATR_ResourceAssn,
	QE_ATR_KillDelay,
	QE_ATR_MaxUserRun,
	QE_ATR_MaxGrpRun,

	/* The following attribute apply only to routing queues... */

	QR_ATR_RouteDestin,
	QR_ATR_AltRouter,
	QR_ATR_RouteHeld,
	QR_ATR_RouteWaiting,
	QR_ATR_RouteRetryTime,
	QR_ATR_RouteLifeTime,

#include "site_que_attr_enum.h"
	QA_ATR_Enabled,	/* these are last for qmgr print function   */
	QA_ATR_Started,
	QA_ATR_LAST	/* WARNING: Must be the highest valued enum */
};

extern attribute_def que_attr_def[];

	
/* at last we come to the queue definition itself	*/
 
struct pbs_queue {
	list_link	qu_link;		/* forward/backward links */
	list_head	qu_jobs;		/* jobs in this queue */

	struct queuefix {
		int	qu_modified;		/* != 0 => update disk file */
		int	qu_type;		/* queue type: exec, route */
		time_t	qu_ctime;		/* time queue created */
		time_t	qu_mtime;		/* time queue last modified */
		char	qu_name[PBS_MAXQUEUENAME]; /* queue name */
	} qu_qs;

	int	qu_numjobs;			/* current numb jobs in queue */
	int	qu_njstate[PBS_NUMJOBSTATE];	/* # of jobs per state */
	char	qu_jobstbuf[100];

	/* the queue attributes */

	attribute	qu_attr[QA_ATR_LAST];
};
typedef struct pbs_queue pbs_queue;

extern pbs_queue *find_queuebyname A_((char *));
extern pbs_queue *get_dfltque();
extern pbs_queue *que_alloc A_((char *name));
extern void   que_free A_((pbs_queue *));
extern pbs_queue *que_recov A_((char *));
extern int    que_save A_((pbs_queue *));

#endif	/* QUEUE_H */
