/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: resource.h,v 2.2 1999/07/21 22:56:32 lonhyn Exp $
 */

/*
 * This header file contains the definitions for resources.
 *
 * Other required header files:
 *	"portability.h"
 *	"attribute.h"
 *	"list_link.h"
 *
 * Resources are "a special case" of attributes.  Resources use similiar
 * structures as attributes.  Certain types, type related functions,
 * and flags may differ between the two.
 *
 * Within the resource structure, the value is contained in an attribute
 * substructure, this is done so the various attribute decode and encode
 * routines can be "reused".
 *
 * For any server, queue or job attribute which is a set of resources,
 * the attribute points to an list  of "resource" structures.
 * The value of the resource is contained in these structures.
 *
 * Unlike "attributes" which are typically identical between servers
 * within an administrative domain,  resources vary between systems.
 * Hence, the resource instance has a pointer to the resource definition
 * rather than depending on a predefined index.
 */

typedef struct resource {
	list_link 	     rs_link;	/* link to other resources in list */
	struct resource_def *rs_defin;	/* pointer to definition entry */
	attribute	     rs_value;	/* attribute struct holding value */
} resource;
	
typedef struct resource_def {
	char   *rs_name;
	int   (*rs_decode) A_((attribute *prsc,char *name,char *rn,char *val));
	int   (*rs_encode) A_((attribute *prsv, list_head *phead, char *atname,
			       char *rsname, int mode));
	int   (*rs_set) A_((attribute *old, attribute *new, enum batch_op op));
	int   (*rs_comp) A_((attribute *prsc, attribute *with));
	void  (*rs_free) A_((attribute *prsc));
	int   (*rs_action) A_((resource *presc, attribute *pat, int actmode));
	int	rs_flags:ATRFLAG;	/* flags: R/O, ..., see attribute.h */
	int	rs_type:ATRTYPE;	/* type of resource,see attribute.h */
} resource_def;

extern resource_def svr_resc_def[];	/* the resource definition array */
extern int	    svr_resc_size;	/* size (num elements) in above  */

extern resource     *add_resource_entry A_((attribute *, resource_def *));
extern resource_def *find_resc_def A_((resource_def *, char *, int));
extern resource     *find_resc_entry A_((attribute *, resource_def *));
