/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

/*
 * @(#) $Id: server.h,v 2.3 1999/10/05 22:43:07 hender Exp $
 */

/*
 * server.h - definitions for the server object (structure)
 *
 * Other include files required:
 *	<sys/types.h>
 *	"attribute.h"
 *	"list_link.h"
 *	"server_limits.h"
 *
 * The server object (structure) contains the parameters which
 * control the operation of the server itself.  This includes
 * the server attributes and resource (limits).
 */

enum srv_atr {
	SRV_ATR_State,
	SRV_ATR_scheduling,
	SRV_ATR_max_running,
	SRV_ATR_MaxUserRun,
	SRV_ATR_MaxGrpRun,
	SRV_ATR_TotalJobs,
	SRV_ATR_JobsByState,
	SRV_ATR_acl_host_enable,
	SRV_ATR_acl_hosts,
	SRV_ATR_AclUserEnabled,
	SRV_ATR_AclUsers,
	SRV_ATR_AclRoot,
	SRV_ATR_managers,
	SRV_ATR_operators,
	SRV_ATR_dflt_que,
	SRV_ATR_log_events,
	SRV_ATR_mailfrom,
	SRV_ATR_query_others,
	SRV_ATR_resource_avail,
	SRV_ATR_resource_deflt,
	SRV_ATR_ResourceMax,
	SRV_ATR_resource_assn,
	SRV_ATR_resource_cost,
	SVR_ATR_sys_cost,
	SRV_ATR_schedule_iteration,
	SRV_ATR_Comment,
	SVR_ATR_DefNode,
	SVR_ATR_NodePack,
#include "site_svr_attr_enum.h"
	SRV_ATR_version,
	/* This must be last */
	SRV_ATR_LAST
};
extern attribute_def svr_attr_def[];

struct server {
	struct server_qs {
		int  sv_numjobs;	 /* number of job owned by server   */
		int  sv_numque;		/* nuber of queues managed          */
		int  sv_jobidnumber;	/* next number to use in new jobid  */
					/* the server struct must be saved  */
					/* whenever this value is updated   */
		time_t sv_savetm;	/* time of server db update         */
	} sv_qs;

	time_t	  sv_started;		/* time server started */
	time_t	  sv_hotcycle;		/* if RECOV_HOT,time of last restart */
	time_t	  sv_next_schedule;	/* when to next run scheduler cycle */
	int	  sv_jobstates[PBS_NUMJOBSTATE];  /* # of jobs per state */
	char	  sv_jobstbuf[100];

	attribute sv_attr[SRV_ATR_LAST]; /* the server attributes 	    */

	int	  sv_trackmodifed;	/* 1 if tracking list modified	    */
	int	  sv_tracksize;		/* total number of sv_track entries */
	struct tracking *sv_track;	/* array of track job records	    */
	
};

extern struct server server;

/*
 * server state values 
 */
#define SV_STATE_DOWN    0
#define SV_STATE_INIT	 1
#define SV_STATE_HOT	 2
#define SV_STATE_RUN     3
#define SV_STATE_SHUTDEL 4
#define SV_STATE_SHUTIMM 5
#define SV_STATE_SHUTSIG 6

/*
 * Other misc defines
 */
#define SVR_HOSTACL "svr_hostacl"
#define PBS_DEFAULT_NODE "1#shared"

#define SVR_SAVE_QUICK 0
#define SVR_SAVE_FULL  1

#define SVR_HOT_CYCLE	15	/* retry mom every n sec on hot start     */
#define SVR_HOT_LIMIT	300	/* after n seconds, drop out of hot start */

/* function prototypes */

extern int  svr_recov A_((char *));
extern int  svr_save A_((struct server *, int mode));
