/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <ctype.h>
#include <memory.h>
#ifndef NDEBUG
#include <stdio.h>
#endif
#include <stdlib.h>
#include <string.h>
#include "pbs_ifl.h"
#include "list_link.h"
#include "attribute.h"
#include "server_limits.h"
#include "job.h"
#include "pbs_error.h"

static char ident[] = "@(#) $RCSfile: attr_fn_hold.c,v $ $Revision: 2.1 $";

#define HOLD_ENCODE_SIZE 3

/*
 * This file contains special decode and encode functions for the hold-types
 * attribute.  All other functions for this attribute are the standard
 * _b (boolean) routines.
 *
 * decode_hold - decode string into hold attribute
 *
 *	Returns: 0 if 0k
 *		>0 error number if error
 *		*patr members set
 */

int decode_hold(patr, name, rescn, val)
	struct attribute *patr;
	char *name;		/* attribute name */
	char *rescn;		/* resource name - unused here */
	char *val;		/* attribute value */
{
	char  *pc;

	patr->at_val.at_long = 0;
	if ((val != (char *)0) && (strlen(val) > (size_t)0)) {
		for (pc = val; *pc != '\0'; pc++) {
			switch (*pc) {
			    case 'n':
				patr->at_val.at_long = HOLD_n;
				break;
			    case 'u':
				patr->at_val.at_long |= HOLD_u;
				break;
			    case 'o':
				patr->at_val.at_long |= HOLD_o;
				break;
			    case 's':
				patr->at_val.at_long |= HOLD_s;
				break;
			    default:
				return (PBSE_BADATVAL);
			}
		}
		patr->at_flags |= ATR_VFLAG_SET | ATR_VFLAG_MODIFY;
	} else {
		patr->at_flags = (patr->at_flags & ~ATR_VFLAG_SET) |
				 ATR_VFLAG_MODIFY;
	}
	return (0);
}

/*
 * encode_str - encode attribute of type ATR_TYPE_STR into attr_extern
 *
 *	Returns: >0 if ok
 *		 =0 if no value, so no link added to list
 *		 <0 if error
 */
/*ARGSUSED*/

int encode_hold(attr, phead, atname, rsname, mode)
	attribute	*attr;	  /* ptr to attribute */
	list_head	*phead;	  /* head of attrlist */
	char		*atname;  /* name of attribute */
	char		*rsname;  /* resource name or null */
	int		 mode;	  /* encode mode, unused here */
	
{
	int       i;
	svrattrl *pal;

	if ( !attr )
		return (-1);
	if ( !(attr->at_flags & ATR_VFLAG_SET))
		return (0);

	pal = attrlist_create(atname, rsname, HOLD_ENCODE_SIZE + 1);
	if (pal == (svrattrl *)0)
		return (-1);

	i = 0;
	if (attr->at_val.at_long == 0)
		*(pal->al_value + i++) = 'n';
	else {
		if (attr->at_val.at_long & HOLD_s) 
			*(pal->al_value + i++) = 's';
		if (attr->at_val.at_long & HOLD_o) 
			*(pal->al_value + i++) = 'o';
		if (attr->at_val.at_long & HOLD_u) 
			*(pal->al_value + i++) = 'u';
	}
	while (i < HOLD_ENCODE_SIZE+1)
		*(pal->al_value + i++) = '\0';
		
	pal->al_flags = attr->at_flags;
	append_link(phead, &pal->al_link, pal);

	return (1);
}

/*
 * comp_hold - compare two attributes of type hold
 *
 *	Returns: +1 if 1st != 2nd
 *		  0 if 1st == 2nd
 */

int comp_hold(attr, with)
	struct attribute *attr;
	struct attribute *with;
{
	if ( !attr || !with )
		return -1;
	if (attr->at_val.at_long == with->at_val.at_long)
		return 0;
	else
		return 1;
}
