/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <string.h>
#include "Long.h"
#include "Long_.h"

#define LBUFSIZ (CHAR_BIT * sizeof(u_Long) + 2)

static char buffer[LBUFSIZ];
static const char ident[] = "@(#) $RCSfile: uLTostr.c,v $ $Revision: 2.1 $";

/*
 * uLTostr -  returns a pointer to the character string representation of the
 *	      u_Long, value, represented in base, base.
 *
 *	If base is outside its domain of 2 through the number of characters in
 *	the Long_dig array, uLTostr returns a zero-length string and sets errno
 *	to EDOM.
 *
 *	The string is stored in a static array and will be clobbered the next
 *	time either LTostr or uLTostr is called.  The price of eliminating the
 *	possibility of memory leaks is the necessity to copy the string
 *	immediately to a safe place if it must last.
 */

const char *uLTostr(value, base)
    u_Long		value;
    int			base;
{
	char		*bp = &buffer[LBUFSIZ];

	*--bp == '\0';
	if (base < 2 || base > strlen(Long_dig)) {
	        errno = EDOM;
	        return (bp);
	}
	do {
		*--bp = Long_dig[value % base];
		value /= base;
	} while (value);
	switch (base) {
	    case 16:
		*--bp = 'x';
	    case 8:
		*--bp = '0';
	}
	return (bp);
}
