/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * cvtdate - convert POSIX touch date/time to seconds since epoch time
 *	
 *	datestr is a date/time string in the form: [[[[CC]YY]MM]DD]hhmm[.SS]
 *	as defined by POSIX.  
 *		CC = centry, ie 19 or 20
 *		YY = year, if CC is not provided and YY is < 69, then 
 *		     CC is assumed to be 20, else 19.
 *		MM = Month, [1,12], if YY is not provided and MM is less than
 *		     the current month, YY is next year, else it is the
 *		     current year.
 *		DD = Day of month, [1,31], if MM is not provided and DD is less
 *		     than the current day, MM is next month, else it is the
 *		     next month.
 *		hh = hour, [00, 23], if DD is not provided and hh is less than
 *		     the current hour, DD is tomorrow, else it is today.
 *		mm = minute, [00, 59]
 *		SS = seconds, [00, 59]
 *
 *	Returns: time_t number of seconds since epoch (Coordinated Univ. Time)
 *		 -1 if error.
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

static char ident[] = "@(#) $RCSfile: cvtdate.c,v $ $Revision: 2.1 $";

time_t
cvtdate(datestr)
char   *datestr;
{
	char	   buf[3];
	time_t	   clock;
	int	   i;
	struct tm *ptm;
	char      *pc;
	struct tm  tm;
	int	   year = 0;
	int	   month = -1;
	int	   day = 0;


	if (pc = strchr(datestr, (int)'.')) {
		*pc++ = '\0';
		if ((strlen(pc) != 2) ||
		    (isdigit((int)*pc) == 0) ||
		    (isdigit((int)*(pc+1)) == 0))
			return (-1);
		tm.tm_sec = atoi(pc);
		if ( tm.tm_sec > 59 )
			return (-1);
	} else
		tm.tm_sec = 0;

	for (pc = datestr; *pc; ++pc)
		if (isdigit((int)*pc) == 0)
			return (-1);

	buf[2] = '\0';
	clock = time((time_t *)0);
	ptm   = localtime(&clock);
	tm.tm_year = ptm->tm_year;	/* default year to current */
	tm.tm_mon  = ptm->tm_mon;	/* default month to current */
	tm.tm_mday = ptm->tm_mday;	/* default day to current */

	switch (strlen(datestr)) {

	    case 12:		/* CCYYMMDDhhmm */
		buf[0] = datestr[0];
		buf[1] = datestr[1];
		year   = atoi(buf) * 100;
		datestr += 2;

		/* no break, fall into next case */

	    case 10:		/* YYMMDDhhmm */
		buf[0] = datestr[0];
		buf[1] = datestr[1];
		i      = atoi(buf);
		if (year == 0)
			if (i > 68)
				year = 1900 + i;
			else
				year = 2000 + i;
	
		else
			year += i;
		tm.tm_year = year - 1900;
		datestr += 2;
		
		/* no break, fall into next case */

	    case 8:		/* MMDDhhmm */
		buf[0] = datestr[0];
		buf[1] = datestr[1];
		i = atoi(buf);
		if (i < 1 || i > 12)
			return (-1);
		if (year == 0)
			if (i <= ptm->tm_mon)
				tm.tm_year++;
		month = i - 1;
		tm.tm_mon = month;
		datestr += 2;
		
		/* no break, fall into next case */

	    case 6:		/* DDhhmm */
		buf[0] = datestr[0];
		buf[1] = datestr[1];
		day = atoi(buf);
		if (day < 1 || day > 31)
			return (-1);
		if (month == -1)
			if (day < ptm->tm_mday)
				tm.tm_mon++;
		tm.tm_mday = day;
		datestr += 2;
		
		/* no break, fall into next case */

	    case 4:		/* hhmm */
		buf[0] = datestr[0];
		buf[1] = datestr[1];
		tm.tm_hour = atoi(buf);
		if (tm.tm_hour > 23)
			return (-1);

		tm.tm_min = atoi(&datestr[2]);	/* mm -  minute portion */
		if (tm.tm_min > 59)
			return (-1);
		if (day == 0)			/* day not specified */
			if ( (tm.tm_hour < ptm->tm_hour) ||
			     ((tm.tm_hour == ptm->tm_hour) &&
			      (tm.tm_min <= ptm->tm_min)) )
				tm.tm_mday++;	/* time for tomorrow */

		break;

	    default:
		return (-1);
	}
		
	tm.tm_isdst = -1;

	return (mktime(&tm));
}
