/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "pbs_ifl.h"
#include "cmds.h"

static char ident[] = "@(#) $RCSfile: parse_depend.c,v $ $Revision: 2.1 $";

static char *deptypes[] = {
	"on",		/* "on" and "synccount" must be first two */
	"synccount",
	"after",
	"afterok",
	"afternotok",
	"afterany",
	"before",
	"beforeok",
	"beforenotok",
	"beforeany",
	"syncwith",
	(char *)0
};

/*
 *
 * parse_depend_item
 *
 * syntax:
 *
 *	jobid[:jobid...]
 *
 */

int parse_depend_item(depend_list, rtn_list, rtn_size)
	char *depend_list;
	char *rtn_list;		/* expanded jobids appended here */
	int   rtn_size;		/* size of above 		 */
{
    char *at;
    int i;
    int first = 1;
    char *s, *c;
    char full_job_id[PBS_MAXCLTJOBID+1];
    char server_out[PBS_MAXSERVERNAME + PBS_MAXPORTNUM + 2];

    /* Begin the parse */
    c = depend_list;

    /* Loop on strings between colons */
    while ( *c != '\0' ) {
	s = c;
        while (((*c != ':') || (*(c-1) == '\\'))  && *c ) c++;
	if ( s == c ) return 1;

	if ( *c == ':' ) {
		*c++ = '\0';
	}

	if (first) {
		first = 0;
		for (i=0; deptypes[i]; ++i) {
			if (strcmp(s, deptypes[i]) == 0)
				break;
		}
		if (deptypes[i] == (char *)0)
			return 1;
		(void)strcat(rtn_list, deptypes[i]);

	} else {

		if (i < 2) {		/* for "on" and "synccount", number */
			(void)strcat(rtn_list, s);
		} else {		/* for others, job id */
			at = strchr(s, (int)'@');
			if (get_server(s, full_job_id, server_out) != 0)
				return 1;
			(void)strcat(rtn_list, full_job_id);
			if (at) {
				(void)strcat(rtn_list, "@");
				(void)strcat(rtn_list, server_out);
			}
		}
	}
	if (*c)
		(void)strcat(rtn_list, ":");
    }
    if ( s == c ) return 1;

    return 0;
}



/*
 *
 * parse_depend_list
 *
 * syntax:
 *
 *	depend_list[,depend_list...]
 *
 * Arguments:
 *
 *	list		List of colon delimited lists.
 *
 */

int parse_depend_list(list, rtn_list, rtn_size)
	char *list;
	char *rtn_list;		/* expanded list returned here */
	int   rtn_size;		/* size of above array */

{
    char *b, *c, *s, *lc;
    int comma;

    if ( strlen(list) == 0 ) return (1);

    if ( (lc = (char *)malloc(strlen(list)+1)) == (char *)0 ) {
        fprintf(stderr, "Out of memory.\n");
        exit(1);
    }
    strcpy(lc, list);
    c = lc;
    *rtn_list = '\0';

    while ( *c != '\0' ) {
	/* Drop leading white space */
        while ( isspace(*c) ) c++;

	/* Find the next comma */
        s = c;
        while ( *c != ',' && *c ) c++;

	/* Drop any trailing blanks */
        comma = (*c == ',');
        *c = '\0';
	b = c - 1;
	while ( isspace((int)*b) ) *b-- = '\0';

	
	/* Parse the individual list item */

        if ( parse_depend_item(s, rtn_list, rtn_size) ) {
            return 1;
        }

        if ( comma ) {
            c++;
	    (void)strcat(rtn_list, ",");
        }
    }
    free(lc);

    if ( comma ) return 1;

    return 0;
}
