/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 *
 * parse_destination_id
 *
 * full syntax permitted;
 *
 * queue_name[@server_name[:port_number]]
 * @server_name[:port_number]
 *
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <string.h>
#include <ctype.h>
#include "pbs_ifl.h"

#define ISNAMECHAR(x) ( (isgraph(x)) && ((x) != '#') && ( (x) != '@') )
#define MAXSERVERNAME PBS_MAXSERVERNAME+PBS_MAXPORTNUM+2

static char queue_name[PBS_MAXQUEUENAME+1]; 
static int q_pos;
static char server_name[MAXSERVERNAME]; 
static int c_pos;

static char ident[] = "@(#) $RCSfile: parse_destid.c,v $ $Revision: 2.1 $";

int 
parse_destination_id(destination_in, queue_name_out, server_name_out) 
char *destination_in;
char **queue_name_out;
char **server_name_out;
{
    int i;
    char *c;

    /* initialize static data for this parsing call */
    for ( i=0; i<PBS_MAXQUEUENAME+1; i++ ) queue_name[i]='\0'; 
    q_pos= 0;
    for ( i=0; i<MAXSERVERNAME; i++ ) server_name[i]='\0';
    c_pos = 0;

    /* Begin the parse */
    c = destination_in;
    while ( isspace(*c) ) c++;

    /* Looking for a queue */
    while ( *c != '\0' ) {
        if ( ISNAMECHAR(*c) ) {
	    if ( q_pos >= PBS_MAXQUEUENAME ) return 1;
            queue_name[q_pos++]=*c;
        } else
            break;
        c++;
    }

    /* Looking for a server */
    if ( *c == '@' ) {
        c++;
        while ( *c != '\0' ) {
            if ( ISNAMECHAR(*c) ) {
	        if ( c_pos >= MAXSERVERNAME ) return 1;
                server_name[c_pos++]=*c;
            } else
                break;
            c++;
        }
	if ( c_pos == 0 ) return 1;
    }

    if ( *c != '\0' ) return 1;

    /* set char * pointers to static data, to arguments */
    if ( queue_name_out != NULL ) *queue_name_out = queue_name;
    if ( server_name_out != NULL ) *server_name_out = server_name;

    return 0;
}
