/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * perpare_path
 *
 *	Perpare a full path name to give to the server.
 *
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include "pbs_ifl.h"
#include "net_connect.h"

static char ident[] = "@(#) $RCSfile: prepare_path.c,v $ $Revision: 2.1 $";

int 
prepare_path(path_in, path_out)
char *path_in;
char *path_out;
{
    int i;
    char *c;
    char host_name[PBS_MAXSERVERNAME+1];
    int h_pos;
    char path_name[MAXPATHLEN+1];
    int p_pos;
    char cwd[MAXPATHLEN+1];
    char *host_given;
    struct	stat	statbuf;
    dev_t	dev;
    ino_t	ino;

/* initialize data for this parsing call */
    for ( i=0; i<= PBS_MAXSERVERNAME; i++ ) host_name[i]='\0';
    h_pos = 0;
    for ( i=0; i<= MAXPATHLEN; i++ ) path_name[i]='\0';
    p_pos = 0;
    cwd[MAXPATHLEN] = '\0';

/* Begin the parse */
    c = path_in;
    while ((int)isspace(*c)) c++;
    if ( strlen(c) == 0 ) return 1;

/* Looking for a hostname :  */
    if ( (host_given=strchr(path_in, ':')) != NULL ) {
        while ( *c != ':' && *c != '\0' ) {
            if ( isalnum(*c) || (*c == '.') || (*c == '-') || (*c == '_') )
                host_name[h_pos++]=*c;
            else
                break;
            c++;
        }
    }

/* Looking for a posix path */
    if ( (*c == ':') || (c == path_in) ) {
        if ( *c == ':' ) c++;
        while ( *c != '\0' ) {
            if ( isgraph(*c) )
                path_name[p_pos++]=*c;
            else
                break;
            c++;
        }
    }

    /* we had trailing trash, or a parse error */
    if ( *c != '\0' ) return 1;
    if ( strlen(path_name) == 0 ) return 1;

/* get full host name */
    if ( host_name[0] == '\0' ) {
        if ( gethostname(host_name, PBS_MAXSERVERNAME) != 0 ) return 2;
    }
    if ( get_fullhostname(host_name, host_name, PBS_MAXSERVERNAME) != 0 ) return 2;

/* prepare complete path name */
    strcpy(path_out, host_name);
    strcat(path_out, ":");
    if ( path_name[0] != '/' && host_given == NULL ) {
     	c = getenv("PWD");		/* PWD carries a name that will cause */
 	if ( c != NULL ) {		/* the NFS to mount */
 	
 	    if (stat(c, &statbuf) < 0) {	/* can't stat PWD */
 		c = NULL;
     	    } else {
 		dev = statbuf.st_dev;
 		ino = statbuf.st_ino;	
 		if (stat(".", &statbuf) < 0) {
 		    perror("prepare_path: cannot stat current directory:" );
 		    return (1);
     		}
 	    }
 	    if (dev == statbuf.st_dev && ino == statbuf.st_ino) {
         	strcpy(cwd, c);
 	    } else {
 		c = NULL;
 	    }
 	}
 	if (c == NULL) {
 	    c = getcwd(cwd, MAXPATHLEN);
 	    if ( c == NULL ) {
 		perror("prepare_path: getcwd failed : ");
 		return (1);
 	    }
 	}
        strcat(path_out, cwd);
        strcat(path_out, "/");
    }
    strcat(path_out, path_name);

    return (0);
}
