/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#include <pbs_config.h>   /* the master config generated by configure */

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "dis.h"
#include "dis_.h"

static char *ulmax;
static unsigned ulmaxdigs = 0;

int disrsl_(stream, negate, value, count)
    int			stream;
    int			*negate;
    unsigned long      	*value;
    unsigned long	count;
    {
	int		c;
	unsigned long	locval;
	unsigned long	ndigs;
	char		*cp;

	assert(negate != NULL);
	assert(value != NULL);
	assert(count);
	assert(stream >= 0);
	assert(dis_getc != NULL);
	assert(dis_gets != NULL);

	if (ulmaxdigs == 0) {
		cp = discul_(dis_buffer + DIS_BUFSIZ, ULONG_MAX, &ulmaxdigs);
		ulmax = (char *)malloc(ulmaxdigs);
		if (ulmax == NULL)
		        return (DIS_NOMALLOC);
		memcpy(ulmax, cp, ulmaxdigs);
		if (dis_umaxd == 0)
		    disiui_();
	}
	switch (c = (*dis_getc)(stream)) {
	    case '-':
	    case '+':
		*negate = c == '-';
		if ((*dis_gets)(stream, dis_buffer, count) != count)
		        return (DIS_EOD);
		if (count >= ulmaxdigs) {
			if (count > ulmaxdigs)
			        goto overflow;
			if (memcmp(dis_buffer, ulmax, ulmaxdigs) > 0)
			        goto overflow;
		}
		cp = dis_buffer;
		locval = 0;
		do {
			if ((c = *cp++) < '0' || c > '9')
			        return (DIS_NONDIGIT);
			locval = 10 * locval + c - '0';
		} while (--count);
		*value = locval;
		return (DIS_SUCCESS);
	    case '0':
		return (DIS_LEADZRO);
	    case '1':
	    case '2':
	    case '3':
	    case '4':
	    case '5':
	    case '6':
	    case '7':
	    case '8':
	    case '9':
		ndigs = c - '0';
		if (count > 1) {
			if ((*dis_gets)(stream, dis_buffer + 1, count - 1) !=
								count - 1)
			        return (DIS_EOD);
			cp = dis_buffer;
			if (count >= ulmaxdigs) {
				if (count > ulmaxdigs)
				        break;
				*cp = c;
				if (memcmp(dis_buffer, ulmax, ulmaxdigs) > 0)
				        break;
			}
			while (--count) {
				if ((c = *++cp) < '0' || c > '9')
				        return (DIS_NONDIGIT);
				ndigs = 10 * ndigs + c - '0';
			}
		}
		return (disrsl_(stream, negate, value, ndigs));
	    case -1:
		return (DIS_EOD);
	    case -2:
		return (DIS_EOF);
	    default:
		return (DIS_NONDIGIT);
	}
	*negate = FALSE;
    overflow:
	*value = ULONG_MAX;
	return (DIS_OVERFLOW);
}
