/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*	PBS_status.c

	The function that underlies all the status requests
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <string.h>
#include <stdio.h>
#include "libpbs.h"

static char ident[] = "@(#) $RCSfile: PBSD_status.c,v $ $Revision: 2.1 $";

static struct batch_status *alloc_bs();

struct batch_status *
PBSD_status(c, function, id, attrib, extend )
	int c;
	int function;
	char *id;
	struct attrl *attrib;
	char *extend;
{
	int rc;
	struct batch_status *PBSD_status_get A_((int c));

	/* send the status request */

	if (id == (char *)0)
		id = "";	/* set to null string for encoding */

	rc = PBSD_status_put(c, function, id, attrib, extend);
	if (rc) {
		return (struct batch_status *)NULL;
	}

	/* get the status reply */

	return ( PBSD_status_get(c) );
}

struct batch_status *PBSD_status_get(c)
	int c;
{
	struct brp_cmdstat  *stp; /* pointer to a returned status record */
	struct batch_status *bsp;
	struct batch_status *rbsp = (struct batch_status *)NULL;
	struct batch_reply  *reply;
	int i;

	/* read reply from stream into presentation element */

	reply = PBSD_rdrpy(c);
	if ( reply == NULL ) {
                pbs_errno = PBSE_PROTOCOL;
	} else if ( reply->brp_choice != BATCH_REPLY_CHOICE_NULL  &&
	            reply->brp_choice != BATCH_REPLY_CHOICE_Text &&
	            reply->brp_choice != BATCH_REPLY_CHOICE_Status ) {
		pbs_errno = PBSE_PROTOCOL;
	} else if ( connection[c].ch_errno == 0 ) {
		/* have zero or more attrl structs to decode here */
		stp = reply->brp_un.brp_statc;
		i = 0;
		pbs_errno = 0;
		while( stp != (struct brp_cmdstat *)NULL ) {
			if( i++ == 0 ) {
				rbsp = bsp = alloc_bs();
				if( bsp == (struct batch_status *)NULL ) {
					pbs_errno = PBSE_SYSTEM;
					break;
				}
			} else {
				bsp->next = alloc_bs();
				bsp = bsp->next;
				if( bsp == (struct batch_status *)NULL ) {
					pbs_errno = PBSE_SYSTEM;
					break;
				}
			}
			bsp->name = strdup(stp->brp_objname);
			bsp->attribs = stp->brp_attrl;
			if (stp->brp_attrl)
				stp->brp_attrl = 0;
			bsp->next = (struct batch_status *)NULL;
			stp = stp->brp_stlink;
		}
		if (pbs_errno) {
			pbs_statfree(rbsp);
			rbsp = (struct batch_status *)NULL;
		}
	}
	PBSD_FreeReply(reply);
	return rbsp;
}

/*	
	Allocate a batch status reply structure
*/

static struct batch_status *alloc_bs()
{
	struct batch_status *bsp;

	bsp = MH(struct batch_status);
	if (bsp) {

		bsp->next = (struct batch_status *)NULL;
		bsp->name = (char *)NULL;
		bsp->attribs = (struct attrl *)NULL;
		bsp->text = (char *)NULL;
	}
	return bsp;
}
