/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
 
static char ident[] = "@(#) $RCSfile: dec_attrl.c,v $ $Revision: 2.1 $";

/*
 * decode_DIS_attrl() - decode into a list of PBS API "attrl" structures
 *
 *	The space for the attrl structures is allocated as needed.
 *
 *	The first item is a unsigned integer, a count of the
 *	number of attrl entries in the linked list.  This is encoded
 *	even when there are no entries in the list.
 *
 *	Each individual entry is encoded as:
 *		u int	size of the three strings (name, resource, value)
 *			including the terminating nulls, see dec_svrattrl.c
 *		string	attribute name
 *		u int	1 or 0 if resource name does or does not follow
 *		string	resource name (if one)
 *		string  value of attribute/resource
 *		u int	"op" of attrlop (also flag of svrattrl) 
 *
 *	Note, the encoding of a attrl is the same as the encoding of
 *	the pbs_ifl.h structures "attropl" and the server struct svrattrl.
 *	Any one of the three forms can be decoded into any of the three with
 *	the possible loss of the "flags" field (which is the "op" of the
 *	attrlop).
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdlib.h>
#include "libpbs.h"
#include "dis.h"

int decode_DIS_attrl(sock, ppatt)
	int		 sock;
	struct attrl **ppatt;
{
	int		 hasresc;
	int		 i;
	unsigned int	 name_len;
	unsigned int	 numpat;
	struct attrl  *pat;
	struct attrl  *patprior;
	int		 rc;


	numpat = disrui(sock, &rc);
	if (rc) return rc;

	for (i=0; i < numpat; ++i) {

		name_len = disrui(sock, &rc);	/* name_len is unusued here */
		if (rc) break;

		pat = malloc(sizeof (struct attrl));
		if (pat == 0)
			return DIS_NOMALLOC;

		pat->next     = (struct attrl *)0;
		pat->name     = (char *)0;
		pat->resource = (char *)0;
		pat->value    = (char *)0;

		pat->name = disrst(sock, &rc);
		if (rc)	break;

		hasresc = disrui(sock, &rc);
		if (rc) break;
		if (hasresc) {
			pat->resource = disrst(sock, &rc);
			if (rc) break;
		}

		pat->value = disrst(sock, &rc);
		if (rc) break;

		/* discard the op field */
		(void)disrui(sock, &rc);
		if (rc) break;

		if (i == 0) {
			/* first one, link to passing in pointer */
			*ppatt = pat;
		} else {
			patprior->next = pat;
		}
		patprior = pat;
	}

	if (rc)
		PBS_free_aopl((struct attropl *)pat);
	return rc;
}
