/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
 
static char ident[] = "@(#) $RCSfile: dec_svrattrl.c,v $ $Revision: 2.1 $";

/*
 * decode_DIS_svrattrl() - decode into a list of server "svrattrl" structures
 *
 *	The space for the svrattrl structures is allocated as needed.
 *
 *	The first item is a unsigned integer, a count of the
 *	number of svrattrl entries in the linked list.  This is encoded
 *	even when there are no entries in the list.
 *
 *	Each individual entry is encoded as:
 *		u int	size of the three strings (name, resource, value)
 *			including the terminating nulls
 *		string	attribute name
 *		u int	1 or 0 if resource name does or does not follow
 *		string	resource name (if one)
 *		string  value of attribute/resource
 *		u int	"op" of attrlop
 *
 *	Note, the encoding of a svrattrl is the same as the encoding of
 *	the pbs_ifl.h structures "attrl" and "attropl".  Any one of
 *	the three forms can be decoded into any of the three with the
 *	possible loss of the "flags" field (which is the "op" of the attrlop).
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include "libpbs.h"
#include "list_link.h"
#include "attribute.h"
#include "dis.h"

int decode_DIS_svrattrl(sock, phead)
	int 	   sock;
	list_head *phead;
{
	int		i;
	unsigned int	hasresc;
	size_t		ls;
	unsigned int	data_len;
	unsigned int	numattr;
	svrattrl       *psvrat;
	int		rc;
	size_t		tsize;


	numattr = disrui(sock, &rc);	/* number of attributes in set */
	if (rc) return rc;

	for (i=0; i<numattr; ++i) {

		data_len = disrui(sock, &rc);	/* here it is used */
		if (rc) return rc;

		tsize = sizeof (svrattrl) + data_len;
		if ((psvrat = (svrattrl *)malloc(tsize)) == 0)
			return DIS_NOMALLOC;

		CLEAR_LINK(psvrat->al_link);
		psvrat->al_atopl.next = 0;
		psvrat->al_tsize = tsize;
		psvrat->al_name  = (char *)psvrat + sizeof (svrattrl);
		psvrat->al_resc  = 0;
		psvrat->al_value = 0;
		psvrat->al_nameln = 0;
		psvrat->al_rescln = 0;
		psvrat->al_valln  = 0;
		psvrat->al_flags  = 0;

		if (rc = disrfcs(sock, &ls, data_len, psvrat->al_name))
			break;
		*(psvrat->al_name + ls++) = '\0';
		psvrat->al_nameln = (int)ls;
		data_len -= ls;
	
		hasresc = disrui(sock, &rc);
		if (rc) break;
		if (hasresc) {
			psvrat->al_resc = psvrat->al_name + ls;
			if (rc = disrfcs(sock, &ls, data_len, psvrat->al_resc))
				break;
			*(psvrat->al_resc + ls++) = '\0';
			psvrat->al_rescln = (int)ls;
			data_len -= ls;
		}

		psvrat->al_value  = psvrat->al_name + psvrat->al_nameln +
				    psvrat->al_rescln;
		if (rc = disrfcs(sock, &ls, data_len, psvrat->al_value))
			break;
		*(psvrat->al_value + ls++) = '\0';
		psvrat->al_valln = (int)ls;

		psvrat->al_op = (enum batch_op)disrui(sock, &rc);
		if (rc) break;

		append_link(phead, &psvrat->al_link, psvrat);
	}

	if (rc) {
		(void)free(psvrat);
	}

	return (rc);
}
