/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*	pbs_locjob.c

	This function does the LocateJob request.
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <string.h>
#include <stdio.h>
#include "libpbs.h"
#include "dis.h"

static char ident[] = "@(#) $RCSfile: pbsD_locjob.c,v $ $Revision: 2.1 $";

char *
pbs_locjob(c, jobid, extend)
int c;
char * jobid;
char * extend;
{
	int	rc;
	struct batch_reply *reply;
	char       *ploc = (char *)0;
	int sock;
	

	if ((jobid == (char *)0) || (*jobid == '\0')) {
		pbs_errno = PBSE_IVALREQ;
		return (ploc);
	}

	sock = connection[c].ch_socket;

	/* setup DIS support routines for following DIS calls */

	DIS_tcp_setup(sock);

	if ( (rc = encode_DIS_ReqHdr(sock, PBS_BATCH_LocateJob,pbs_current_user)) ||
	     (rc = encode_DIS_JobId(sock, jobid))	   ||
	     (rc = encode_DIS_ReqExtend(sock, extend)) ) {
		connection[c].ch_errtxt = strdup(dis_emsg[rc]);
		pbs_errno = PBSE_PROTOCOL;
		return (char *)NULL;
	}
	
	/* write data over tcp stream */

	if (DIS_tcp_wflush(sock)) {
		pbs_errno = PBSE_PROTOCOL;
		return (char *)NULL;
	}

	/* read reply from stream */

	reply = PBSD_rdrpy(c);
	if ( reply == NULL) {
                pbs_errno = PBSE_PROTOCOL;
	} else if ( reply->brp_choice != BATCH_REPLY_CHOICE_NULL &&
	            reply->brp_choice != BATCH_REPLY_CHOICE_Text &&
	            reply->brp_choice != BATCH_REPLY_CHOICE_Locate) {
		advise("pbs_locjob", "Unexpected reply choice");
		pbs_errno = PBSE_PROTOCOL;
	} else if ( connection[c].ch_errno == 0 ) {
		ploc = strdup(reply->brp_un.brp_locate);
	}

	PBSD_FreeReply(reply);

	return ploc;
}
