/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*	pbs_submit.c
 *
 *	The Submit Job request.  
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include "libpbs.h"

static char ident[] = "@(#) $RCSfile: pbsD_submit.c,v $ $Revision: 2.1 $";

char *
pbs_submit(c, attrib, script, destination, extend)
	int c;
	struct attropl *attrib;
	char * script;
	char * destination;
	char * extend;
{
	struct attropl *pal;
	char * return_jobid = (char *)NULL;

	
	/* first be sure that the script is readable if specified ... */

	if ((script != (char *)0) && (*script != '\0')) {
		if( access( script, R_OK ) != 0 ) {
			pbs_errno = PBSE_BADSCRIPT;
			return (char *)NULL;
		}
	}

	/* initiate the queueing of the job */

	for (pal = attrib; pal; pal = pal->next)
		pal->op = SET;		/* force operator to SET */
	
	/* Queue job with null string for job id */
	return_jobid = PBSD_queuejob(c, "", destination, attrib, extend);
	if( return_jobid == (char *)NULL ) {
		return (char *)NULL;
	}
		
	/* send script across */

	if ((script != (char *)0) && (*script != '\0')) {
		if( PBSD_jscript(c, script) != 0 ) {
			pbs_errno = PBSE_BADSCRIPT;
			return (char *)NULL;
		}
	}
	
	/* OK, the script got across, apparently, so we are */
	/* ready to commit 				    */
	
	if (PBSD_rdytocmt(c, return_jobid) != 0) {
		return (char *)NULL;
	}
	
	if (PBSD_commit(c, return_jobid) != 0) {
		return (char *)NULL;
	}
	
	return return_jobid;
}
