/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
#include <pbs_config.h>   /* the master config generated by configure */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "portability.h"
#include "log.h"

static char ident[] = "@(#) $RCSfile: setup_env.c,v $ $Revision: 2.2 $";

/*
 * setup_env - setup the daemon's environment
 *
 *	To provide a "safe and secure" environment, the daemons replace their
 *	inherited one with one from a file.  Each line in the file is
 *	either a comment line, starting with '#' or ' ', or is a line of 
 *	the forms:	variable=value
 *			variable
 *	In the second case the value is obtained from the current environment.
 *
 *	Returns: number of variables placed or -1 on error
 */

#define PBS_ENVP_STR     64
#define PBS_ENV_CHUNCK 1024

int setup_env(filen)
	char *filen;
{
	char	     buf[256];
	int	     evbufsize = 0;
	FILE	    *efile;
	char        *envbuf;
	static char *envp[PBS_ENVP_STR+1];
	int	     len;
	int	     nstr = 0;
	char	    *pequal;
	char	    *pval;
	extern char **environ;

	envp[0] = (char *)0;
	if ((filen == (char *)0) || (*filen == '\0')) {
		environ = envp;
		return 0;
	}

	efile = fopen(filen, "r");
	if (efile != (FILE *)0) {

	    while (fgets(buf, 255, efile) ) {
		if ((buf[0] != '#') && (buf[0] != ' ') && (buf[0] != '\n')) {
			len = strlen(buf);
			buf[len-1] = '\0';
			if ((pequal = strchr(buf, (int)'=')) == 0) {
				if ((pval = getenv(buf)) == 0)
					continue;
				len += strlen(pval) + 1;
			}
	
			if (evbufsize < len) {
				if ((envbuf = malloc(PBS_ENV_CHUNCK)) == 0)
					goto err;

				evbufsize = PBS_ENV_CHUNCK;
			}
			(void)strcpy(envbuf, buf);
			if (pequal == 0) {
				(void)strcat(envbuf, "=");
				(void)strcat(envbuf, pval);
			}
			envp[nstr++] = envbuf;
			if (nstr == PBS_ENVP_STR)
				goto err;
			envp[nstr] = (char *)0;
			envbuf += len;
			evbufsize -= len;
		}
	    }
	    fclose(efile);
	    environ = envp;
	} else if (errno != ENOENT) {
		goto err;
	}
	return (nstr);

err:	log_err(-1, "setup_env", "Could not set up the environment");
	return (-1);
}
