/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <sys/types.h>
#include <netinet/in.h>
#include "portability.h"
#include <netdb.h>
#include <string.h>

static char ident[] = "@(#) $RCSfile: get_hostname.c,v $ $Revision: 2.1 $";

/*
 * get_fullhostname - get the fully qualified name of a host
 *
 * Returns: 0 - if success
 *		host name in character buffer pointed to by namebuf	
 *	   -1 - if error
 */

int get_fullhostname(shortname, namebuf, bufsize)
	char *shortname;
	char *namebuf;
	int   bufsize;
{
	char	       *pbkslh = 0;
	char           *pcolon = 0;
	struct hostent *phe;
	struct in_addr  ina;

	if (pcolon = strchr(shortname, (int)':')) {
		*pcolon = '\0';
		if (*(pcolon-1) == '\\')
			*(pbkslh = pcolon-1) = '\0';
	}
	phe = gethostbyname(shortname);
	if (pcolon) {
		*pcolon = ':';	/* replace the colon */
		if (pbkslh)
			*pbkslh = '\\';
	}
	if (phe == (struct hostent *)0)
		return (-1);

	(void)memcpy((char *)&ina, *phe->h_addr_list, phe->h_length);
	if ((phe = gethostbyaddr((char *)&ina, phe->h_length, phe->h_addrtype))
									   == 0)
		return (-1);

	if ((size_t)bufsize < strlen(phe->h_name))
		return (-1);
	(void)strncpy(namebuf, phe->h_name, bufsize);
	*(namebuf + bufsize) = '\0';	/* insure null terminated */
	return (0);
}
