/*
 * This file contains homebrewed PBS replacements for
 * library functions found on BSD 4.4-Lite.
 *
 * NOTE: the strange set of "if define..." results from Sun not having
 * stdarg.h, at least on SunOS 4.x
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include <errno.h>
#include <stdio.h>
#if defined(__STDC__) && !defined(sun)
#include <stdarg.h>
#else
#include <varargs.h>
#endif

static char ident[] = "@(#) $RCSfile: replace.c,v $ $Revision: 2.0 $";

#if defined(__STDC__) && !defined(sun)
void errx(int err, const char *fmt, ...)
#else
void errx(err, fmt, va_alist)
	int   err;
	char *fmt;
	va_dcl
#endif
{
	va_list ap;

#if defined(__STDC__) && !defined(sun)
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void)vfprintf(stderr, fmt, ap);
	exit (err);
}

#if defined(__STDC__) && !defined(sun)
void warnx(const char *fmt, ...)
#else
void warnx(fmt, va_alist)
	char *fmt;
	va_dcl
#endif
{
	va_list ap;

#if defined(__STDC__) && !defined(sun)
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	(void)vfprintf(stderr, fmt, ap);
}


void err(val, str)
	int val;
	char *str;
{
	if (str)
		(void)fprintf(stderr, "%s\n", str);
	exit(val);
}
