/*
This program is confidential and proprietary to MRJ Technology Solutions
and may not be reproduced, published or disclosed to others without
written authorization from MRJ.

Copyright (c) 1998 MRJ Technology Solutions, Inc. All Rights Reserved.

This program is derived from prior work some of which was originally
written as a joint project between the Numerical Aerospace Simulation
(NAS) Systems Division of NASA Ames Research Center and the National
Energy Research Supercomputer Center (NERSC) of Lawrence Livermore
National Laboratory.
*/
/*
 * Machine-dependent definitions for the Machine Oriented Miniserver
 *
 * Target System: sp2
 */



#ifndef MOM_MACH
#define MOM_MACH "sp2"

#define SET_LIMIT_SET   1
#define SET_LIMIT_ALTER 0
#define PBS_CHKPT_MIGRATE 0

/* struct startjob_rtn = used to pass error/session/other info 	*/
/* 			child back to parent			*/

struct startjob_rtn {
	int   sj_code;		/* error code	*/
	pid_t sj_session;	/* session	*/
};
	
extern int mom_set_limits A_((job *pjob, int));	/* Set job's limits */
extern int mom_do_poll A_((job *pjob));		/* Should limits be polled? */
extern int mom_does_chkpnt();                   /* see if mom does chkpnt */
extern int mom_open_poll A_(());		/* Initialize poll ability */
extern int mom_get_sample A_(());		/* Sample kernel poll data */
extern int mom_over_limit A_((job *pjob));	/* Is polled job over limit? */
extern int mom_set_use A_((job *pjob));		/* Set resource_used list */
extern int mom_kill A_((int sid, int sig));	/* Kill a session */
extern int mom_close_poll A_(());		/* Terminate poll ability */
extern int mach_checkpoint A_((struct task *, char *path, int abt));
						/* do the checkpoint */
extern long mach_restart A_((struct task *, char *path));	/* Restart checkpointed task */

#endif /* MOM_MACH */
