/*
This program is confidential and proprietary to MRJ Technology Solutions
and may not be reproduced, published or disclosed to others without
written authorization from MRJ.

Copyright (c) 1998 MRJ Technology Solutions, Inc. All Rights Reserved.

This program is derived from prior work some of which was originally
written as a joint project between the Numerical Aerospace Simulation
(NAS) Systems Division of NASA Ames Research Center and the National
Energy Research Supercomputer Center (NERSC) of Lawrence Livermore
National Laboratory.
*/
#include <pbs_config.h>   /* the master config generated by configure */

#include <fcntl.h>
#include <sys/param.h>

static char ident[] = "@(#) $RCSfile: pe_input.c,v $ $Revision: 2.0 $";

/*
 * pe_input() - open architecture dependent input file for prologue
 *	and epilogue scripts.  See ../prolog.c
 *	For SP-2 - The node list file
 */

int pe_input(jobid)
	char *jobid;
{
	char    file[MAXPATHLEN+1];
	extern	char *path_home;
	int	fd;

        (void)sprintf(file, "%s/aux/%s", path_home, jobid);
        fd = open(file, O_RDONLY, 0);
	if (fd == -1)
		return (open("/dev/null", O_RDONLY, 0));	
	else
		return (fd);
}
