/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <setjmp.h>
#include <string.h>
#include <math.h>
#include "Parser.h"
#include "Lexer.h"
#include "SymTab.h"
#include "Semantic.h"
#include "CodeGen.h"

static char ident[] = "@(#) $RCSfile: Basl2c.c,v $ $Revision: 2.1 $";
int	linenum = 1;	/* manipulated by both Parser and Lexer */
jmp_buf begin;		/* where to return from in case of a FPE error */

extern FILE *ParserFpOut;
extern FILE *LexerFpOut;
extern FILE *NodeFpOut;
extern FILE *ListFpOut;
extern FILE *SymTabFpOut;
extern FILE *SemanticFpOut;
extern FILE *CodeGenFpOut;
extern FILE *CodeGenFpImedCode;
extern FILE *yyin;
extern FILE *yyout;

static void loadUserAccessibleAssistFuncs(void)
{
	Np np;	

	/* Server AllServersLocalHostGet() */
	np = NodeNew("AllServersLocalHostGet", SERVERTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	
	/* Set Server AllServersGet() {} */
	np = NodeNew("AllServersGet", SERVERSETTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	/* String ServerInetAddrGet("Server s) {} */
	np = NodeNew("ServerInetAddrGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	
	/* String ServerDefQueGet("Server s) {} */
	np = NodeNew("ServerDefQueGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	
	/* Int ServerStateGet("Server s) {} */
	np = NodeNew("ServerStateGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	
	/* Int ServerMaxRunJobsGet("Server s) {} */
	np = NodeNew("ServerMaxRunJobsGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	
	/* Int ServerMaxRunJobsPerUserGet("Server s) {} */
	np = NodeNew("ServerMaxRunJobsPerUserGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int ServerMaxRunJobsPerGroupGet("Server s) {} */
	np = NodeNew("ServerMaxRunJobsPerGroupGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Set Que	ServerQueuesGet("Server s) {} */
	np = NodeNew("ServerQueuesGet", QUESETTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Set Job	ServerJobsGet("Server s) {} */
	np = NodeNew("ServerJobsGet", JOBSETTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerIntResAvailGet(Server s, String name) {} */
	np = NodeNew("ServerIntResAvailGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Size	ServerSizeResAvailGet(Server s, String name) {} */
	np = NodeNew("ServerSizeResAvailGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* String ServerStringResAvailGet(Server s, String name) {} */
	np = NodeNew("ServerStringResAvailGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerIntResAssignGet(Server s, String name) {} */
	np = NodeNew("ServerIntResAssignGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Size	ServerSizeResAssignGet(Server s, String name) {} */
	np = NodeNew("ServerSizeResAssignGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* String ServerStringResAssignGet(Server s, String name) {} */
	np = NodeNew("ServerStringResAssignGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerNodesGet(Server s) {} */
	np = NodeNew("ServerNodesGet", CNODESETTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerNodesQuery(Server s, String spec) {} */
	np = NodeNew("ServerNodesQuery", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("spec", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerNodesReserve(Server s, String spec, Int resId) {} */
	np = NodeNew("ServerNodesReserve", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("spec", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("resId", INTTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerNodesRelease(Server s, Int resId) {} */
	np = NodeNew("ServerNodesRelease", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("resId", INTTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerNodesNumAvailGet(Server s) {} */
	np = NodeNew("ServerNodesNumAvailGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerNodesNumAllocGet(Server s) {} */
	np = NodeNew("ServerNodesNumAllocGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerNodesNumRsvdGet(Server s) {} */
	np = NodeNew("ServerNodesNumRsvdGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	ServerNodesNumDownGet(Server s) {} */
	np = NodeNew("ServerNodesNumDownGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("s", SERVERTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Set Cnode AllNodesGet() {} */
	np = NodeNew("AllNodesGet", CNODESETTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	/* Cnode AllNodesLocalHostGet() {} */
	np = NodeNew("AllNodesLocalHostGet", CNODETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);

	/* String CnodeNameGet("Cnode node) {} */
	np = NodeNew("CNodeNameGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String CnodePropertiesGet("Cnode node) {} */
	np = NodeNew("CNodePropertiesGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String CnodeVendorGet("Cnode node) {} */
	np = NodeNew("CNodeVendorGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	
	/* String CnodeOsGet("Cnode node) {} */
	np = NodeNew("CNodeOsGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeNumCpusGet(Cnode node) {} */
	np = NodeNew("CNodeNumCpusGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int CnodeCpuPercentIdleGet(Cnode node) {} */
	np = NodeNew("CNodeCpuPercentIdleGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int CnodeCpuPercentSysGet(Cnode node) {} */
	np = NodeNew("CNodeCpuPercentSysGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeCpuPercentUserGet(Cnode node) {} */
	np = NodeNew("CNodeCpuPercentUserGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int CnodeCpuPercentGuestGet(Cnode node) {} */
	np = NodeNew("CNodeCpuPercentGuestGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Size  CnodeMemTotalGet( Cnode node, String type ) {} */
	np = NodeNew("CNodeMemTotalGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("type", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size  CnodeMemAvailGet( Cnode node, String type ) {} */
	np = NodeNew("CNodeMemAvailGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("type", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeStateGet( Cnode node ) {} */
	np = NodeNew("CNodeStateGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int CnodeTypeGet( Cnode node ) {} */
	np = NodeNew("CNodeTypeGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeIdletimeGet( Cnode node ) {} */
	np = NodeNew("CNodeIdletimeGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Float CnodeLoadAveGet( Cnode  node ) {} */
	np = NodeNew("CNodeLoadAveGet",  FLOATTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeNetworkBwGet( Cnode node, String type ) {} */
	np = NodeNew("CNodeNetworkBwGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("type", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeDiskSpaceTotalGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeDiskSpaceTotalGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeDiskSpaceAvailGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeDiskSpaceAvailGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeDiskSpaceReservedGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeDiskSpaceReservedGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeDiskInBwGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeDiskInBwGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeDiskOutBwGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeDiskOutBwGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeSwapSpaceTotalGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeSwapSpaceTotalGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeSwapSpaceAvailGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeSwapSpaceAvailGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeSwapInBwGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeSwapInBwGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeSwapOutBwGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeSwapOutBwGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeTapeSpaceTotalGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeTapeSpaceTotalGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeTapeSpaceAvailGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeTapeSpaceAvailGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeTapeInBwGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeTapeInBwGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeTapeOutBwGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeTapeOutBwGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeSrfsSpaceTotalGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeSrfsSpaceTotalGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeSrfsSpaceAvailGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeSrfsSpaceAvailGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Size CnodeSrfsSpaceReservedGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeSrfsSpaceReservedGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeSrfsInBwGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeSrfsInBwGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeSrfsOutBwGet( Cnode node, String name ) {} */
	np = NodeNew("CNodeSrfsOutBwGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("node", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int CnodeMatchPair( Cnode sys, CNode jreq) {} */
	np = NodeNew("CNodeMatchPair", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("sys", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	np = NodeNew("jreq", CNODETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* String QueNameGet( Que que ) {} */
	np = NodeNew("QueNameGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int QueTypeGet( Que que ) {} */
	np = NodeNew("QueTypeGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int QueNumJobsGet( Que que ) {} */
	np = NodeNew("QueNumJobsGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int QueMaxRunJobsGet( Que que ) {} */
							
	np = NodeNew("QueMaxRunJobsGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int QueMaxRunJobsPerUserGet( Que que ) {} */
	np = NodeNew("QueMaxRunJobsPerUserGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int QueMaxRunJobsPerGroupGet( Que que ) {} */
	np = NodeNew("QueMaxRunJobsPerGroupGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int QuePriorityGet( Que que ) {} */
	np = NodeNew("QuePriorityGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int QueStateGet( Que que ) {} */
	np = NodeNew("QueStateGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);

	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	

	/* Int	QueIntResAvailGet(Que q, String name) {} */
	np = NodeNew("QueIntResAvailGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("q", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Size	QueSizeResAvailGet(Que q, String name) {} */
	np = NodeNew("QueSizeResAvailGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("q", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* String QueStringResAvailGet(Que q, String name) {} */
	np = NodeNew("QueStringResAvailGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("q", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	QueIntResAssignGet(Que q, String name) {} */
	np = NodeNew("QueIntResAssignGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("q", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Size	QueSizeResAssignGet(Que q, String name) {} */
	np = NodeNew("QueSizeResAssignGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("q", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* String QueStringResAssignGet(Que q, String name) {} */
	np = NodeNew("QueStringResAssignGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("q", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Set Job QueJobsGet( Que que ) {} */
	np = NodeNew("QueJobsGet", JOBSETTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);

	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String JobIdGet( Job job ) {} */
	np = NodeNew("JobIdGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String JobNameGet( Job job ) {} */
	np = NodeNew("JobNameGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String JobOwnerNameGet( Job job ) {} */
	np = NodeNew("JobOwnerNameGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String JobEffectiveUserNameGet( Job job ) {} */
	np = NodeNew("JobEffectiveUserNameGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String JobEffectiveGroupNameGet( Job job ) {} */
	np = NodeNew("JobEffectiveGroupNameGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int JobStateGet ( Job job ) {} */
	np = NodeNew("JobStateGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int JobPriorityGet( Job job ) {} */
	np = NodeNew("JobPriorityGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int JobRerunFlagGet( Job job ) {} */
	np = NodeNew("JobRerunFlagGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int JobInteractiveFlagGet( Job job ) {} */
	np = NodeNew("JobInteractiveFlagGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* DateTime JobDateTimeCreatedGet( Job job ) {} */
	np = NodeNew("JobDateTimeCreatedGet", DATETIMETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String JobEmailAddrGet( Job job ) {} */
	np = NodeNew("JobEmailAddrGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String JobStageinFilesGet( Job job ) {} */
	np = NodeNew("JobStageinFilesGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* String JobStageoutFilesGet( Job job ) {} */
	np = NodeNew("JobStageoutFilesGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
	
	/* Int	JobIntResReqGet(Job j, String name) {} */
	np = NodeNew("JobIntResReqGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("j", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Size	JobSizeResReqGet(Job j, String name) {} */
	np = NodeNew("JobSizeResReqGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("j", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* String JobStringResReqGet(Job j, String name) {} */
	np = NodeNew("JobStringResReqGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("j", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Int	JobIntResUseGet(Job j, String name) {} */
	np = NodeNew("JobIntResUseGet", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("j", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Size	JobSizeResUseGet(Job j, String name) {} */
	np = NodeNew("JobSizeResUseGet", SIZETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("j", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* String JobStringResUseGet(Job j, String name) {} */
	np = NodeNew("JobStringResUseGet", STRINGTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("j", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("name", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());


	/* String JobAction( Job job, Act act, String param ) {} */
	np = NodeNew("JobAction", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("job", JOBTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("act", INTTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("param", STRINGTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* Job QueJobFind( Que que, Fun Int fun, Int cpr, Int value ) */
	/* Job QueJobFind( Que que, Fun String fun, Int cpr, String value ) */
	/* Job QueJobFind( Que que, Fun Date fun, Int cpr, Date value ) */
	/* Job QueJobFind( Que que, Fun Time fun, Int cpr, Time value ) */
	/* Job QueJobFind( Que que, Fun Size fun, Int cpr, Size value ) */

	/* Job QueJobFind( Que que, Fun Int fun, Cpr cpr = {OP_MAX|OP_MIN}) */
	/* Job QueJobFind( Que que, Fun String fun, Cpr cpr = {OP_MAX|OP_MIN}) */
	/* Job QueJobFind( Que que, Fun Date fun, Cpr cpr = {OP_MAX|OP_MIN}) */
	/* Job QueJobFind( Que que, Fun Time fun, Cpr cpr = {OP_MAX|OP_MIN}) */
	/* Job QueJobFind( Que que, Fun Size fun, Cpr cpr = {OP_MAX|OP_MIN}) */

	np = NodeNew("QueJobFind", JOBTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* GENERIC TYPE matches anything */
	np = NodeNew("fun", GENERICTYPE, 0, 0, YES);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("cpr", INTTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("value", GENERICTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* void QueFilter( Que que, Que newq, Fun Int fun, Int cpr, Int value ) */
	/* void QueFilter( Que que, Que newq, Fun String fun, Int cpr, String value ) */
	/* void QueFilter( Que que, Que newq, Fun Date fun, Int cpr, Date value ) */
	/* void QueFilter( Que que, Que newq, Fun Time fun, Int cpr, Time value ) */
	/* void QueFilter( Que que, Que newq, Fun Size fun, Int cpr, Size value ) */

	np = NodeNew("QueFilter", QUETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	np = NodeNew("que", QUETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* GENERIC TYPE matches anything */
	np = NodeNew("fun", GENERICTYPE, 0, 0, YES);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("cpr", INTTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("value", GENERICTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

/*	Int Sort( {SetJob,SetQue,SetServer,SetCNode} col, 
	      {Int,Float,String,DateTime,Size}   keyfunc,
	      {ASC, DESC}			 order
*/		

	np = NodeNew("Sort", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);
	
	/* GENERIC TYPE matches anything */
	np = NodeNew("col", GENERICTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("keyfunc", GENERICTYPE, 0, 0, YES);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	np = NodeNew("order", INTTYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());

	/* DateTime datetimeGet() {} */
	np = NodeNew("datetimeGet", DATETIMETYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);

	/* DateTime datetimeToSecs(DateTime dt) {} */
	np = NodeNew("datetimeToSecs", INTTYPE, 0, 0, YES_INT);
	SymTabInsertFront(np);
	ParserCurrFunPtrPut(np);

	np = NodeNew("dt", DATETIMETYPE, 0, 0, NO);
	SymTabParamLink(ParserCurrFunPtrGet(), np);
	NodeParamCntIncr(ParserCurrFunPtrGet());
}

static void addIncludes(void)
{
	fprintf(CodeGenFpImedCode, "#include <stdio.h>\n");
	fprintf(CodeGenFpImedCode, "#include <unistd.h>\n");
	fprintf(CodeGenFpImedCode, "#include \"portability.h\"\n");
	fprintf(CodeGenFpImedCode, "#include \"af.h\"\n");
	fprintf(CodeGenFpImedCode, "#include \"af_system.h\"\n");
	fprintf(CodeGenFpImedCode, "#include \"af_server.h\"\n");
	fprintf(CodeGenFpImedCode, "#include \"af_cnode.h\"\n");
}

static void addMainSched(void)
{
	fprintf(CodeGenFpImedCode, "main(argc, argv)\n");
	fprintf(CodeGenFpImedCode, "int  argc;\n");
	fprintf(CodeGenFpImedCode, "char *argv[];\n");
	fprintf(CodeGenFpImedCode, "{\n");

        fprintf(CodeGenFpImedCode, "	SystemInit(argc, argv);\n");
        fprintf(CodeGenFpImedCode, "	sched_init();\n");
        fprintf(CodeGenFpImedCode, "	SystemStateRead(sched_main);\n");
	fprintf(CodeGenFpImedCode, "	SystemClose();\n");
	fprintf(CodeGenFpImedCode, "}\n");

/*
  	fprintf(CodeGenFpImedCode, "printf(\"Printing Dynamic Array Table: \\n\");\n");
  	fprintf(CodeGenFpImedCode, "printDynamicArrayTable();\n");
  	fprintf(CodeGenFpImedCode, "printf(\"Printing Varstr Table: \\n\");\n");
  	fprintf(CodeGenFpImedCode,"varstrPrint();\n");
  	fprintf(CodeGenFpImedCode, "printf(\"Printing Malloc Table Table: \\n\");\n");
  	fprintf(CodeGenFpImedCode, "mallocTablePrint();\n");

        fprintf(CodeGenFpImedCode, "		sched_main();\n");
  	fprintf(CodeGenFpImedCode, "printf(\"Printing Dynamic Array Table: \\n\");\n");
  	fprintf(CodeGenFpImedCode, "printDynamicArrayTable();\n");
  	fprintf(CodeGenFpImedCode, "printf(\"Printing Varstr Table: \\n\");\n");
  	fprintf(CodeGenFpImedCode,"varstrPrint();\n");
  	fprintf(CodeGenFpImedCode, "printf(\"Printing Malloc Table Table: \\n\");\n");
  	fprintf(CodeGenFpImedCode, "mallocTablePrint();\n");
	fprintf(CodeGenFpImedCode, "}\n");
*/

}

#define GETOPT_ARGS "dp:l:y:s:g:c:"
main(argc, argv)
int	argc;
char	**argv;
{
	int 		c;
	int		debugflg = 0;
    	int 		errflg=0;
	char		parserDebugFile[80];
	char		lexerDebugFile[80];
	char		symtabDebugFile[80];
	char		semanticDebugFile[80];
	char		codegenDebugFile[80];
	char		cFile[80];
	extern 		char *optarg;
	extern 		int  optind;
	extern		int yyparse();


	LexerFpOut = stdout;
	ParserFpOut = stdout;
	NodeFpOut = stdout;
	ListFpOut = stdout;
	SymTabFpOut = stdout;
	SemanticFpOut = stdout;
	CodeGenFpOut = stdout;

	strcpy(cFile, "pbs_sched.c");
	if( (CodeGenFpImedCode = fopen(cFile, "w")) == NULL ) {
		fprintf(stderr, "Error opening c translation file.\n");
		exit(2);
	}

    	while ((c = getopt(argc, argv, GETOPT_ARGS)) != EOF) {
    		switch (c) {
    		  case 'd':
			debugflg = 1;
        		break;
    		  case 'p':
			strcpy(parserDebugFile, optarg);
			if( (LexerFpOut = fopen(parserDebugFile, "w")) == NULL ) {
				fprintf(stderr, "Error opening lexer debug file.\n");
				exit(2);
			}
        		break;
    		  case 'l':
			strcpy(lexerDebugFile, optarg);
			if( (ParserFpOut = fopen(lexerDebugFile, "w")) == NULL ) {
				fprintf(stderr, "Error opening lexer debug file.\n");
				exit(2);
			}
        		break;
    		  case 'y':
			strcpy(symtabDebugFile, optarg);
			if( (SymTabFpOut = fopen(symtabDebugFile, "w")) == NULL ) {
				fprintf(stderr, "Error opening symtab debug file.\n");
				exit(2);
			}
			NodeFpOut=SymTabFpOut;
			ListFpOut=SymTabFpOut;
        		break;
    		  case 's':
			strcpy(semanticDebugFile, optarg);
			if( (SemanticFpOut = fopen(semanticDebugFile, "w")) == NULL ) {
				fprintf(stderr, "Error opening semantic debug file.\n");
				exit(2);
			}
        		break;
    		  case 'g':
			strcpy(codegenDebugFile, optarg);
			if( (CodeGenFpOut = fopen(codegenDebugFile, "w")) == NULL ) {
				fprintf(stderr, "Error opening codegen debug file.\n");
				exit(2);
			}
        		break;
    		  case 'c':
			strcpy(cFile, optarg);
			fclose(CodeGenFpImedCode);
			if( (CodeGenFpImedCode = fopen(cFile, "w")) == NULL ) {
				fprintf(stderr, "Error opening c translation file.\n");
				exit(2);
			}
        		break;
    		  default :
        		errflg++;
    		}
	}
   
	if(errflg || (optind == argc) ) {
        	static char usage[]="usage: basl2c [-d] \
[-p parserDebugFile] [-l lexerDebugFile] \n\
		[-y symtabDebugFile] [-s semanticDebugFile]   \n\
		[-g codegenDebugFile] [-c cFile] baslFile \n";
        	fprintf(stderr, usage);
        	exit(2);
	}

	if( (yyin = fopen(argv[optind], "r")) == NULL ) {
		fprintf(stderr, "Error opening basl input file file.\n");
		exit(2);
	}
	optind++;

	if( optind != argc ) {
        	static char usage[]="usage: basl2cc [-d] \
		[-p parserDebugFile] [-l lexerDebugFile] \n\
		[-y symtabDebugFile] [-s semanticDebugFile]   \n\
		[-g codegenDebugFile] [-c cFile] [-o executable] baslFile \n";
        	fprintf(stderr, usage);
        	exit(2);
	}

	if( debugflg ) {
		LexerPutDF(1);
		ParserPutDF(1);
		SemanticPutDF(1);
		CodeGenPutDF(1);
		SymTabPutDF(1);
		NodePutDF(1);
		ListPutDF(1);
	} else {
		LexerPutDF(0);
		ParserPutDF(0);
		SemanticPutDF(0);
		CodeGenPutDF(0);
		SymTabPutDF(0);
		NodePutDF(0);
		ListPutDF(0);
	}

	LexerInit();
	ParserInit();
	SymTabInit();
	SemanticInit();
	CodeGenInit();

	setjmp(begin);   /* return here after input error */
	signal(SIGFPE, ParserFpeCatch);  /* redefine default FPE handler */

	addIncludes();
	loadUserAccessibleAssistFuncs();
	while(yyparse());

	SymTabDelete();

	addMainSched();
	fclose(LexerFpOut);
	fclose(ParserFpOut);
	fclose(SymTabFpOut);
	fclose(SemanticFpOut);
	fclose(CodeGenFpOut);
	fclose(CodeGenFpImedCode);

	return(0);
}
