/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*************************************************************
*      myname           List.h
*      created          7/12/1996
*      updated          8/13/1996
*      works            8/13/1996
*
*      function         Singly Linked List
*
*
*
*************************************************************/
#ifndef _LIST_H 
#define _LIST_H
/* Feature test switches */
#ifndef _POSIX_SOURCE
#define _POSIX_SOURCE 1
#endif  /* _POSIX_SOURCE */

#if __STDC__ == 1
/*
 * The following macro definations take affect when compiling under ansi C
 *
 * The A_ macro is provided for function prototype declarations.  It allows
 * ANSI C prototypes to be complied under K&R C
 */

#define A_(x) x

#else
/* The following macro definations take affect when compiling under K&R C */

#define const
#define volatile
#define A_(x) ()

#endif  /* __STDC__ */

#include "Node.h"

typedef Np List;

/*prototypes*/

extern void
ListPutDF A_((int df));

extern void
ListCondPrint A_((char *str));

extern int
ListIsEmpty A_((List L));

extern void
ListPrint A_((List L));

extern void
ListErr A_((int e));

extern List
ListInsertFront A_((List L, Np nxp));

extern List
ListInsertSortedN A_((List L, Np nxp));

extern List
ListInsertSortedD A_((List L, char * lexem, int typ, int LineDe, int leve, int funFlag));

extern int
ListIsMember A_((List L, Np nxp));

extern Np
ListGetLast A_((List L));

extern Np
ListGetSucc A_((List L, Np nxp));

extern List
ListDelete A_((List L));

extern List
ListDeleteNode A_((List L, Np nxp));

extern Np
ListFindNodeByLexeme A_((List L, char * lexem));

extern Np
ListFindNodeByLexemeInLevel A_((List L, char * lexem, int leve));

extern Np
ListFindNodeByLexemeInLine A_((List L, char * lexem, int line));

extern Np
ListMatchNodeByLexemeInLine A_((List L, char * lexem, int line));

extern Np
ListFindNodeBeforeLexemeInLine A_((List L, char * lexem, int line));

extern Np
ListMatchNodeBeforeLexemeInLine A_((List L, char * lexem, int line));

extern Np
ListFindNodeByLexemeAndTypeInLevel A_((List L, char * lexem, int leve, int type, int (*compare_func)()));

extern Np
ListFindAnyNodeInLevelOfType A_((List L, int leve, int type));

extern List
ListDeleteLevel A_((List L, int leve));

extern void
ListParamLink A_((Np tailnp, Np newnp));

extern Np
ListFindFunProtoByLexemeInProg A_((List L, char * lexem));

#endif /* _LIST_H */
