/* $Id: cleanup.c,v 1.1 1999/11/15 23:34:45 hender Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <string.h>

/* PBS header files */

#include "pbs_error.h"
#include "pbs_ifl.h"
#include "log.h"

/* Scheduler header files */

#include "toolkit.h"
#include "gblxvars.h"

static int cleanup_queue(Queue *queue);
static int cleanup_rsrcs(Resources *rlist);

int 
schd_cleanup(void)
{
    QueueList *qptr;

    for (qptr = schd_SubmitQueue; qptr != NULL; qptr = qptr->next)
	cleanup_queue(qptr->queue);

    for (qptr = schd_BatchQueues; qptr != NULL; qptr = qptr->next)
	cleanup_queue(qptr->queue);

    for (qptr = schd_DedQueues; qptr != NULL; qptr = qptr->next)
	cleanup_queue(qptr->queue);

    if (schd_AllJobs) {
	schd_free_jobs(schd_AllJobs);
	schd_AllJobs = NULL;
    }

    if (schd_RsrcsList) {
	cleanup_rsrcs(schd_RsrcsList);
	schd_RsrcsList = NULL;
    }

    return (0);
}

static int
cleanup_queue(Queue *queue)
{
    char *qname, *exechost;
    time_t idle_since;
    int   pt_obsvd;

    if (queue->jobs)
	schd_free_jobs(queue->jobs);

    if (queue->useracl)
	schd_free_useracl(queue->useracl);

    /* 
     * Rather than explicitly zeroing out all the fields in the queue, save
     * a reference to the queue name and host, which is all that is needed 
     * to identify the queue next time it is used.  Note that this sets the
     * jobs list to NULL, so it will not be accidentally traversed.
     *
     * Be sure to save and restore any other necessary information here!
     */

    qname      = queue->qname;
    exechost   = queue->exechost;
    idle_since = queue->idle_since;
    pt_obsvd   = queue->observe_pt;

    memset (queue, 0, sizeof (Queue));

    queue->qname      = qname;
    queue->exechost   = exechost;
    queue->idle_since = idle_since;
    queue->observe_pt = pt_obsvd;

    return (0);
}

static int 
cleanup_rsrcs(Resources *rlist)
{
    Resources *rptr, *next;
    int    num = 0;

    for (rptr = rlist; rptr != NULL; rptr = next) {
	next = rptr->next;

	if (rptr->exechost)
	    free(rptr->exechost);

	memset (rptr, 0, sizeof (Resources));

	num ++;
    }

    return (num);
}
