/* $Id: fragments.c,v 1.1 1999/11/15 23:34:48 hender Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <string.h>

/* PBS header files */

#include "pbs_error.h"
#include "pbs_ifl.h"
#include "log.h"

/* Scheduler header files */

#include "toolkit.h"
#include "gblxvars.h"

int
schd_fragment_okay(Job *job, Queue *queue, char *reason)
{
    /* char   *id = "fragment_okay"; */
    int     nodes_avail, frag_size, avg_nodes;

    /*
     * If this job has been waiting for a long time, don't allow anything to
     * interfere with it's execution.
     */
    if (job->flags & JFLAGS_WAITING)
	return (1);

    /* 
     * "Fragments" only make sense if there is a node limit and a maximum
     * number of running jobs.  If not, fragmentation is not really an issue.
     */
    if ((queue->nodes_max == UNSPECIFIED) ||
	(queue->maxrun == UNSPECIFIED) ||
	(queue->maxrun < 2))
    {
	return (1);
    }

    frag_size = (queue->nodes_max / queue->maxrun);
    nodes_avail = (queue->nodes_max - queue->nodes_assn);

    /*
     * See if the queue has fragments of less than 2 nodes, and return if
     * so -- fragmentation is nonsensical for <2 nodes/frag.
     */
    if (frag_size < 2)
	return (1);

    /*
     * If there is less than a fragment left, do not run a job that would
     * cause this queue to be fragmented when the other jobs exit.
     */
    if (nodes_avail < frag_size) {
	if ((job->walltime + schd_TimeNow) > queue->empty_by) {
	    if (reason)
		sprintf(reason, 
		    "Would leave fragments in %s (must be <= %s walltime)", 
		    queue->qname, schd_sec2val(queue->empty_by - schd_TimeNow));
	    return (0);
	}

	/*
	 * This job will end before the queue is drained, so go ahead and
	 * run it.  It may temporarily increase fragmentation, but it will
	 * not be a problem for long.
	 */
	return (1);
    }

    /*
     * Find the average number of nodes consumed by jobs in this queue.  This
     * number is rounded to the nearest fragment size.  If there are no 
     * running jobs, allow anything to run and deal with the consequences
     * later.  This should help prevent starvation of very small jobs.
     */
    if (queue->running)
	avg_nodes = ((queue->nodes_assn + (frag_size / 2)) / queue->running);
    else
	return (1);

    /*
     * If the average number of nodes in use by the processes running in the
     * queues is less than the fragment size, then run a job that is smaller
     * than the fragment size, as long as it won't go beyond the time limit
     * of the longest running job.  If there are no running jobs, than let 
     * the fragment run.
     */
    if (job->nodes < frag_size) {

	/* This job is a fragment, and the average job in the queue is not. */

	if (avg_nodes >= frag_size) {
	    if (reason) {
		sprintf(reason, 
		    "Would fragment queue %s (must be >= %d nodes)",
		    queue->qname, frag_size);
	    }
	    return (0);
	}

	if (queue->running && 
	    ((job->walltime + schd_TimeNow) > queue->empty_by))
	{
	    if (reason) {
		sprintf(reason, 
		    "Would perpetuate fragmentation (must be < %d sec)",
		    (queue->empty_by - schd_TimeNow));
	    }
	    return (0);
	}
    }

    return (1);
}
