/* $Id: rejectjob.c,v 1.1 1999/11/15 23:34:53 hender Exp $ */

#include <stdio.h>
#include <stdlib.h>

#include "pbs_ifl.h"
#include "log.h"

#include "toolkit.h"
#include "gblxvars.h"

/*
 * The size of the buffer to allocate to hold the message that will be
 * sent to the user.  This is dynamically allocated (once) since it may 
 * need to be a very large buffer, depending on the complexity of the 
 * message.
 */
#define MSG_BUFFER_SIZE	4000

extern int connector;

int
schd_reject_job(Job *job, char *reason)
{
    char   *id = "schd_reject_job";
    static char *message = NULL;
    int     rc = 0;

    if (message == NULL) {
	if ((message = (char *)malloc(MSG_BUFFER_SIZE)) == NULL) {
	    (void)sprintf(log_buffer, "cannot malloc %d bytes\n",
		MSG_BUFFER_SIZE);
	    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
	    return (-1);
	}
    }

    DBPRT((
"*************************************************************************\n"));

    if (schd_TEST_ONLY) {
	DBPRT(("JOB %s WOULD HAVE BEEN DELETED!!!\n", job->jobid));
	DBPRT(("Message: %s\n", reason));
    } else {
	(void)sprintf(message, 
	    "\n"
	    "PBS job '%s' was rejected by all execution queues.\n"
	    "\n"
	    "The reason given for this action was :\n"
	    "\n"
	    "       %s\n"
	    "\n"
	    "Please correct the problem and resubmit your job, or contact the PBS\n"
	    "administrator for assistance.\n"
	    "\n"
	    "Thank you.\n"
	    "\n",
		job->jobid, reason);


	/* 
	 * Ask PBS to delete the job from the queue, which should deliver the
	 * message to the user.
	 */

	rc = pbs_deljob(connector, job->jobid, message);

	if (rc) {
	    (void)sprintf(log_buffer, "pbs_deljob failed: error %d", rc);
	    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
	    DBPRT(("%s: %s\n", id, log_buffer));
	    return 1;
	}

	/*
	 * Delete this job from the queue's list (move to a NULL queue)
	 */
	schd_move_job_to(job, NULL);

	DBPRT(("JOB %s DELETED!!!\n", job->jobid));
	DBPRT(("Message: %s\n", reason));
    }

    DBPRT((
"*************************************************************************\n"));
    return 0;
}
