/* $Id: resource_limits.c,v 1.1 1999/11/15 23:34:53 hender Exp $ */

#include <sys/types.h>
#include <stdio.h>

#include "toolkit.h"
#include "gblxvars.h"
#include "msgs.h"

int schd_resource_limits(Job *job, Resources *rsrcs, char *reason)
{
    /* Could nodes be over-allocated by running this job? */
    if ((rsrcs->nodes_alloc + job->nodes) > rsrcs->nodes_total) {
	if (reason)
	    sprintf(reason, "%s (%d max)",
		schd_JobMsg[NO_NODES], rsrcs->nodes_total);
	return (1);
    }

    return 0;		/* Job will fit within available resources. */
}

/*
 * Origin machines may come up and run happily with fewer nodes available
 * than the actual queue structure might indicate.  One example is that a
 * node board goes bad due to a power failure -- the machine might only
 * have 62 CPUs available, but the largest queue would allow 64 CPUs.
 */
int schd_resources_avail(Job *job, Resources *rsrcs, char *reason)
{
    /* Are sufficient CPUs available on the system to run this job? */
    if (job->nodes > rsrcs->nodes_total) {
	if (reason)
	    sprintf(reason, "%s (only %d avail)", schd_JobMsg[NO_NODES],
		rsrcs->nodes_total);
	return (0);
    }

    return 1;		/* Job will fit within available resources. */
}
