/* $Id: runjob.c,v 1.1 1999/11/15 23:34:54 hender Exp $ */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<time.h>

/* PBS header files */
#include        "pbs_error.h"
#include        "pbs_ifl.h"
#include        "log.h"

/* Toolkit header files */
#include "toolkit.h"
#include "gblxvars.h"

extern int connector;

/*
 * run_job_on(job, queue, set_comment) :
 *
 * Run the job pointed to by 'job' in the queue on which it is enqueued.
 * If 'queue' is non-NULL, move the job to the queue before running it.  
 * If 'set_comment' is non-zero, the job comment will be changed to reflect
 * the time at which the job was started.
 */

int 
schd_run_job_on(Job *job, Queue *destq, char *exechost, int set_comment)
{
    char   *id = "schd_run_job_on";
    Queue  *srcq = NULL;
    char   *date;
    char    reason[128];

    /* Get the datestamp from 'ctime()'.  Remove the trailing '\n'. */
    date = ctime(&schd_TimeNow);
    date[strlen(date) - 1] = '\0';

    if (job->state != 'Q') {
	    (void)sprintf(log_buffer,
		"run_job_on(%s, %s) called with job not in 'Q' state.\n",
	        job->jobid, (destq ? destq->qname : "(NULL)"));
	    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
	    DBPRT(("%s: %s\n", id, log_buffer));
	return (-1);
    }

    if (set_comment) {
	sprintf(reason, "Started on %s", date);

	if (job->flags & JFLAGS_PRIORITY) {
	    strcat(reason, " (special access job)");
	} else if (job->flags & JFLAGS_WAITING) {
	    strcat(reason, " (waited too long)");
	}

	schd_comment_job(job, reason, JOB_COMMENT_REQUIRED);
    }


    /* Fix added by jjones per Dr. Hook to change behavior of jobs being
     * moved from submit queue to exec queue before run, at request of
     * ERDC.
     */
#if 0
    /* 
     * If a destination Queue is provided, and it is different from the 
     * source queue, then ask PBS to move the job to that queue before
     * running it.
     */
    srcq = job->queue;

    if ((destq != NULL) && (strcmp(destq->qname, srcq->qname) != 0)) {
	/* Move the job from its queue to the specified run queue. */ 
	if (schd_TEST_ONLY) {
	    DBPRT(("%s: would have moved %s from queue %s to queue %s\n", id, 
		job->jobid, srcq->qname, destq->qname));
	} else {
	    if (pbs_movejob(connector, job->jobid, destq->qname, NULL)) {
		(void)sprintf(log_buffer, "move job %s to queue %s failed, %d",
		    job->jobid, destq->qname, pbs_errno);
		log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, 
		    id, log_buffer);
		DBPRT(("%s: %s\n", id, log_buffer));
		return (-1);
	    }
	}

	schd_move_job_to(job, destq);
    }
#endif

    /* Give the job handle (JOBID) to PBS to run. */
    if (schd_TEST_ONLY) {
	DBPRT(("%s: would have run %s on queue %s\n", id, job->jobid, 
	    destq->qname));
    } else {
	if (pbs_runjob(connector, job->jobid, exechost, NULL)) {
	    (void)sprintf(log_buffer, "failed start job %s on queue %s@%s, %d",
			  job->jobid, destq->qname, exechost, pbs_errno);
	    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
	    DBPRT(("%s: %s\n", id, log_buffer));

#if 0
	    /*
	     * Running failed!  Move the job back to the source queue (if 
	     * applicable) before returning.  This prevents jobs being marooned
	     * in execution queues.
	     */
	    if (srcq) {
		DBPRT(("Attempting to move job %s back to queue %s\n", 
		    job->jobid, srcq->qname));

		if (pbs_movejob(connector, job->jobid, srcq->qname, NULL)) {
		    (void)sprintf(log_buffer, 
		    "failed to move job %s back to queue %s, %d", job->jobid, 
		    srcq->qname, pbs_errno);

		    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, 
			log_buffer);
		    DBPRT(("%s: %s\n", id, log_buffer));
		}

		schd_move_job_to(job, srcq);
	    }
#endif
	    return (-1);
	}

    }
    /* PBS accepted the job (and presumably will run it).  Log it. */
    (void)sprintf(log_buffer, "job %s started on %s@%s", 
		  job->jobid, destq->qname, exechost);
    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
    DBPRT(("%s: %s\n", id, log_buffer));

    /*
     * Change the state of the local representation of the job to "Running".
     */
    job->state = 'R';

    /*
     * Account for the job on this queue's statistics.  'queued' will be
     * bumped up if the queued job was moved to a new destination queue.
     */

    job->queue->queued --;
    job->queue->running ++;

    /* The queue is no longer idle.  Unset the idle timer. */
    job->queue->idle_since = 0;

    return (0);				/* Job successfully started. */
}

/*
 * schd_charge_job(job, queue, rsrcs)
 *
 * Account for the job resources requested by 'job' in the assigned and
 * available resources in 'queue' and 'rsrcs'
 *
 * Possible side effects:
 *  - If job allocates all of some resource, the queue will be marked "FULL".
 *  - queue->empty_by time may be extended to the end of this job.
 *
 * Returns 0 on success.
 */
int
schd_charge_job(Job *job, Queue *queue, Resources *rsrcs)
{
#ifdef DEBUG
    char   *id = "schd_charge_job";
#endif /* DEBUG */
    time_t  job_ends;

    /* Update the queue and resources with the job's expected usage. */

    queue->nodes_assn  += job->nodes;
    rsrcs->nodes_alloc += job->nodes;
    rsrcs->freemem     -= (job->nodes * MB_PER_NODE);
    rsrcs->njobs ++;

    /* Has the queue node limit been reached?  If so, note it and fail. */
    if ((queue->nodes_max != UNSPECIFIED) &&
	(queue->nodes_max <= queue->nodes_assn)) 
    {
	DBPRT(("%s: Queue %s node limit (%d) reached - mark full\n", id, 
	    queue->qname, queue->nodes_max));
	queue->flags |= QFLAGS_FULL;
    }

    /*
     * If job specified a walltime, see if the queue "empty at" time needs
     * to be updated.  This function should only be called once we are
     * committed to running this job, so it is appropriate to update this
     * value at this point.
     */
    if (job->walltime != UNSPECIFIED) {
	job_ends = schd_TimeNow + job->walltime;

	if (job_ends > queue->empty_by)	{
	    DBPRT(("%s: Queue %s empty_by %s to %s", id, queue->qname, 
		queue->empty_by ? "bumped" : "set to", ctime(&job_ends)));

	    queue->empty_by = job_ends;
	}
    }

    /* Lastly, update the Recent Usage Table used by the sorting algorithm */
    schd_update_resource_usage(job);

    return (0);
}
