/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/

#ifndef FIFO_H
#define FIFO_H

/*
 *      schedinit - initialize conf struct and parse conf files
 */
int schedinit( int argc, char *argv[] );

/*
 *      schedule - this function gets called to start each scheduling cycle
 *                 It will handle the difference cases that caused a
 *                 scheduling cycle
 */
int schedule(int cmd, int sd);

/*
 *      scheduling_cycle - the controling function of the scheduling cycle
 */
 
int scheduling_cycle( int sd );

/*
 *      init_scheduling_cycle - run things that need to be set up every
 *                              scheduling cycle
 */
int init_schedule_cycle( server_info *sinfo );

/*
 *      run_update_job - run and update the job information
 */
int run_update_job( int pbs_sd, server_info *sinfo, queue_info *qinfo, 
							job_info *jinfo);
/*
 *
 *      next_job - find the next job to be run by the scheduler
 *
 *        sinfo - the server the jobs are on
 *        ret_code - the previous return code from running a job
 *
 *      returns the next job to run or NULL when there are no more jobs
 *              to run, or on error
 *
 */

job_info *next_job( server_info *sinfo, int ret_code );

/*
 *      update_last_running - update the last_running job array
 */
int update_last_running( server_info *sinfo );

/*
 *
 *      update_starvation - update jobs sch_priority for starvation
 */
job_info *update_starvation( job_info **jobs );


#endif
