static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Name: 

        Author : Nicholas P. Cardo
                 Sterling Software, Inc.
                 NAS Facility
                 NASA Ames Research Center

  Description:

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include "toolkit.h"

struct	hrec *dbdat();

/*
 *  Look up a file and return the information to
 *  the caller in the form of a structure
 */
struct	hrec * dbdat(user)
char	*user;
{
char	*id = "dbdat";
static	struct	hrec hu;
int	db;
int	pos;
struct	flock lock;

	memset(&hu,0,sizeof(struct hrec));

	/*
	 *  Locate the position in the data file
	 *  from the index file
	 */
	if((pos=dbpos(user)) == -1) 
		return((struct hrec *)0L);

	/*
	 *  Open the data file
	 */
	if((db=open(DBDAT,O_RDONLY)) == -1) 
		return((struct hrec *)0L);

	/*
	 *  Lock the record
	 */
	lock.l_type = F_RDLCK;
	lock.l_whence = SEEK_SET;
	lock.l_start = pos;
	lock.l_len = sizeof(struct hrec);

	if(fcntl(db,F_SETLKW,&lock) == -1) {
		close(db);
		return((struct hrec *)0L);
	}

	/*
	 *  See and read
	 */
	lseek(db,pos,SEEK_SET);

	read(db,&hu,sizeof(struct hrec));

	/*
	 *  Unlock the record
	 */
	lock.l_type = F_UNLCK;

	fcntl(db,F_SETLK,&lock);

	close(db);

	/*
	 *  Validate and return structure
	 */
	if(strcmp(user,hu.user)) 
		return(NULL);

	return(&hu);
}

/*
 *  Get the position of the user from the
 *  index file
 */
int	dbpos(user)
char	*user;
{
char	*id = "dbpos";
int	idx;
struct	hidx hi;
int	found;

	found = 0;
	/*
	 *  Open the index file
	 */
	if((idx=open(DBIDX,O_RDONLY)) == -1)
		return(-1);

	/*
	 *  Find the user
	 */
	while(read(idx,&hi,sizeof(struct hidx))) {
		if(!strcmp(user,hi.user)) {
			found++;
			break;
		}
	}
	close(idx);

	/*
	 *  Return the position 
	 */
	if(found)
		return(hi.pos);

	return(-1);
}

/*
 *  Update a record in the data file
 */
int updatedb(hu)
struct	hrec *hu;
{
char	*id = "updatedb";
int	pos;
int	db;
struct	flock lock;

	/*
	 *  Locate the record
	 */
	pos = dbpos(hu->user);

	/*
 	 *  Open the data file
	 */
	if((db=open(DBDAT,O_RDWR)) == -1)
		return(-1);

	/*
	 *  Lock the record
	 */
	lock.l_type = F_WRLCK;
	lock.l_whence = SEEK_SET;
	lock.l_start = pos;
	lock.l_len = sizeof(struct hrec);

	if(fcntl(db,F_SETLKW,&lock) == -1) {
		close(db);
		return(-1);
	}

	/*
	 *  Seek and rewrite the record
	 */
	lseek(db,pos,SEEK_SET);
	write(db,hu,sizeof(struct hrec));

	/*
	 *  Unlock the record
	 */
	lock.l_type = F_UNLCK;
	fcntl(db,F_SETLK,&lock);

	close(db);

	return(0);
}

/*
 *  Is this user authorized to run in the
 *  high priority queue
 */
int usrok(usr,cputim)
char	*usr;
int	cputim;
{
char	*id = "usrok";
struct	hrec *hu;

	if((hu=dbdat(usr)) == (struct hrec *)0L)
		return(-1);

	if(((hu->max_use + cputim) > hu->max_lim) && (hu->max_lim > 0))
		return(0);

	if(((hu->int_use + cputim) > hu->int_lim) && (hu->int_lim > 0))
		return(0);

	return(1);
}

