static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: libsched.a
       File: getconfig.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Get all the jobs queued in the specified queue.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include	<stdio.h>

#include        "pbs_error.h"
#include        "pbs_ifl.h"
#include        "log.h"

/*
 *  ALIST_ENTRIES is the number of entries
 *  in the static structure alist which is
 *  used as the criteria for selecting jobs.
 *  This provides a convient way to easily
 *  increase the search capability in the future.
 */
#define	ALIST_ENTRIES	2

extern	int	connector;

struct	batch_status * getjobs(qname,state)
char	*qname;
char	*state;
{
char	*id = "getjobs";
static	struct batch_status *bs;
static	struct attropl alist[] = {
	{NULL,NULL,NULL,NULL,EQ},
	{NULL,NULL,NULL,NULL,EQ}
};
int	idx;

	if((qname == NULL) && (state == NULL)) {
		/*
		 *  all jobs in all queues
		 */
		bs = pbs_selstat(connector,NULL,NULL);
	} else {
		/*
		 *  Initialize the search criteria because
		 *  alist is a static structure and it will
		 *  retain the previous search when repeatedly
		 *  called.
		 */
		for(idx=0;idx<ALIST_ENTRIES;idx++) {
			alist[idx].next  = NULL;
			alist[idx].name  = NULL;
			alist[idx].value = NULL;
		}

		idx = 0;

		/*
		 *  specific queue?
		 */
		if(qname != NULL) {
			alist[idx].name = ATTR_queue;
			alist[idx].value = qname;
			idx++;
		}

		/*
		 *  specific state?
		 */
		if(state != NULL) {
			alist[idx].name = ATTR_state;
			alist[idx].value = state;
			if(idx > 0)
				alist[idx-1].next = &alist[idx];
			idx++;
		}

		/*
		 *  More tests can be added here
		 */

		/*
		 *  Get the jobs
		 */
		bs = pbs_selstat(connector,alist,NULL);
	}

	if((bs == (struct batch_status *)0L) && (pbs_errno)) {
		(void) sprintf(log_buffer,"pbs_selstat failed, %d",pbs_errno);
		log_record(PBSEVENT_SYSTEM,PBS_EVENTCLASS_SERVER,id,log_buffer);
	}

	/*
	 *  Return the pointer to all the jobs
	 */
	return(bs);
}
