static char USMID[] = "%Z%%M%	%I%	%G% %U%";

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/param.h>
#include <sys/sysmacros.h>
#include <string.h>
/*
 *  PBS header files
 */
#include "pbs_error.h"
#include "pbs_ifl.h"
#include "log.h"
/*
 *  Scheduler header files
 */
#include "toolkit.h"

extern	int connector;

/*
 *  Check queue limits to see if a job should be
 *  run out of this job.
 */
int qenabled(queue_name)
char	*queue_name;
{
char	*id = "qenabled";
struct	batch_status *bs;
int	enabled;
char	*ptr;
static	struct attrl alist[] = {
	{NULL,ATTR_enable, "",""}
};

	enabled = UNSPECIFIED;

	/*
	 *  Ask the server for queue information
	 */
	if((bs=pbs_statque(connector,queue_name,alist,NULL)) == 
	   (struct batch_status *)0L) {
		sprintf(log_buffer,"pbs_statque failed, %d",pbs_errno);
		log_record(PBSEVENT_ERROR,PBS_EVENTCLASS_SERVER,id,log_buffer);
		return(0);
	} 

	/*
	 *  Process the results
	 */
	if((ptr=getat(ATTR_enable,bs,NULL)) != NULL) {
		enabled = 0;
		if(!strcmp(ptr,"True"))
			enabled = 1;
	}

	pbs_statfree(bs);

	/*
	 *  Is the queue started
	 */
	if((enabled == UNSPECIFIED) || (enabled == 0)) {
		sprintf(log_buffer,"queue %s not enabled",queue_name);
		log_record(PBSEVENT_SYSTEM,PBS_EVENTCLASS_QUEUE,id,log_buffer);
		return(0);
	}

	return(1);
}

