static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: pbs_sched.a
       File: schedinit.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Perform any scheduler initialization.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <time.h>
#include <unistd.h>
#include "gblxvars.h"
#include "pbs_ifl.h"
#include "log.h"

char	schedhost[255];

void    catchUSR1(int signo);
void	catchHUP(int signo);
void	setalarm(void);

/*
 *  Perform scheduler initialization stuff here
 */
int schedinit(argc,argv)
int	argc;
char	**argv;
{
char	*id = "schedinit";

	/*
	 *  Read the configuration file
	 */
	if (getconfig())
		return(-1);

	/*
	 *  Read the holidays file to determine
	 *  prime and non-prime times.
	 */
	read_holidays();

	/*
	 *  set the signal for rereading the config file
	 */
	signal(SIGHUP,catchHUP);

	/*
	 *  What host is this scheduler running on
	 */
	gethostname(schedhost,255);

	/* any other required initializations: */
	need_to_get_alloc_info = 1;     /* get per-group allocation info */
	need_to_get_YTD_info   = 1;     /* get per-group YTD usage info */

	return(0);
}

/*
 *  read the linear usage file
 */
void
catchUSR1(signo)
int	signo;
{
char	*id = "catchUSR1";

	signal(SIGUSR1,catchUSR1);
}

void
setalarm()
{
time_t	tim;
struct	tm *tm;
int	now;
int	tday;
char	*id = "setalarm";

	/*
	 *  Reset the next alarm
	 */
	time(&tim);
	tm = localtime(&tim);

	/*
	 *  Calculate how many seconds until 0600 tomorrow
	 */
	now = (tm->tm_hour * 60) + tm->tm_min;  /* minutes from 0000 */
	tday = 1440 - now;                      /* minutes till 2400 */
	tday *= 60;                             /* seconds till 2400 */
	tday += 21600;                          /* seconds till 0600 */

	alarm(tday);
}

/*
 *  read the configuration file
 */
void
catchHUP(signo)
int	signo;
{
time_t	tim;
struct	tm *tm;
int	now;
int	tday;
char	*id = "catchHUP";

	(void) sprintf(log_buffer,"SIGHUP: reread configuration file");
	log_record(PBSEVENT_SYSTEM,PBS_EVENTCLASS_SERVER,id,log_buffer);

	clrcomp();
	getconfig();

	/*
	 *  reset the signal
	 */
	signal(SIGHUP,catchHUP);

}
