static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: libtoolkit.a
       File: sec2val.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Given seconds, convert it to HH:MM:SS.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>

char * sec2val(seconds)
int	seconds;
{
char	*id = "sec2val";
int	hours;
int	minutes;
static	char tval[9];

	hours = minutes = 0;

	/*
	 *  Hours
	 */
	if(seconds >= 3600)
		hours = seconds / 3600;

	seconds -= (hours *3600);

	/*
	 *  Minutes
	 */
	if(seconds >= 60)
		minutes = seconds / 60;

	/*
	 *  Seconds
	 */
	seconds -= (minutes * 60);

	(void) sprintf(tval,"%2.2d:%2.2d:%2.2d\0",hours,minutes,seconds);

	return(&tval[0]);
}

