static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: libtoolkit.a
       File: val2sec.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Convert a value string from time to its equivalent value in seconds.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include <stdio.h>
#include <sys/types.h>
#include <string.h>

#define	COLON 58

int val2sec(val)
char	*val;
{
char	*id = "val2sec";
int	tm;
char	*h,*m,*s;
char	*ptr;

	/*
	 *  If no : then it must be already in seconds
	 */
	if((ptr=strchr(val,COLON)) == NULL)
		return(atoi(val));

	/*
	 *  Hour
	 */
	h = val;

	/*
	 *  Minutes
	 */
	m = strstr(h,":");
	*m ='\0';
	m++;

	/*
	 *  seconds
	 */
	s = strstr(m,":");
	*s = '\0';
	s++;

	/*
	 *  time in seconds
	 */
	tm = (atoi(h) * 3600) + (atoi(m) * 60) + atoi(s);

	return(tm);
}

