/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
static char USMID[] = "%Z%%M%	%I%	%G% %U%";

/*

    Program: libsched.a
       File: getconfig.c

        Author : Nicholas P. Cardo
                 Sterling Software
                 NAS Facility
                 NASA Ames Research Center

  Description:
    Get all the jobs queued in the specified queue.

*/

#include <pbs_config.h>   /* the master config generated by configure */

#include	<stdio.h>

#include        "pbs_error.h"
#include        "pbs_ifl.h"
#include        "log.h"

/*
 *  ALIST_ENTRIES is the number of entries
 *  in the static structure alist which is
 *  used as the criteria for selecting jobs.
 *  This provides a convient way to easily
 *  increase the search capability in the future.
 */
#define	ALIST_ENTRIES	2

extern	int	connector;

struct	batch_status * getjobs(qname,state)
char	*qname;
char	*state;
{
char	*id = "getjobs";
static	struct batch_status *bs;
static	struct attropl alist[] = {
	{NULL,NULL,NULL,NULL,EQ},
	{NULL,NULL,NULL,NULL,EQ}
};
int	idx;

	if((qname == NULL) && (state == NULL)) {
		/*
		 *  all jobs in all queues
		 */
		bs = pbs_selstat(connector,NULL,NULL);
	} else {
		/*
		 *  Initialize the search criteria because
		 *  alist is a static structure and it will
		 *  retain the previous search when repeatedly
		 *  called.
		 */
		for(idx=0;idx<ALIST_ENTRIES;idx++) {
			alist[idx].next  = NULL;
			alist[idx].name  = NULL;
			alist[idx].value = NULL;
		}

		idx = 0;

		/*
		 *  specific queue?
		 */
		if(qname != NULL) {
			alist[idx].name = ATTR_queue;
			alist[idx].value = qname;
			idx++;
		}

		/*
		 *  specific state?
		 */
		if(state != NULL) {
			alist[idx].name = ATTR_state;
			alist[idx].value = state;
			if(idx > 0)
				alist[idx-1].next = &alist[idx];
			idx++;
		}

		/*
		 *  More tests can be added here
		 */

		/*
		 *  Get the jobs
		 */
		bs = pbs_selstat(connector,alist,NULL);
	}

	if((bs == (struct batch_status *)0L) && (pbs_errno)) {
		(void) sprintf(log_buffer,"pbs_selstat failed, %d",pbs_errno);
		log_record(PBSEVENT_SYSTEM,PBS_EVENTCLASS_SERVER,id,log_buffer);
	}

	/*
	 *  Return the pointer to all the jobs
	 */
	return(bs);
}
