/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* $Id: byte2val.c,v 1.1 1999/04/16 19:32:11 hender Exp $ */

#include <sys/types.h>
#include <stdio.h>

/*
 * byte2val(bytes)
 *
 * Return a pointer to a static string that is the shortest string by which
 * the number of bytes can be accurately represented. i.e.:
 *
 *	1023			-> 1023b
 *	16384			-> 16kb
 *	1048576			-> 1mb
 *	16777216		-> 16mb
 *	16777217		-> 16777217b
 *	34359738368		-> 32gb
 */

char *
schd_byte2val(size_t bytes)
{
    size_t  mult      = 1;	/* Initial multiplier */
    int     log_1024  = 0;	/* logarithm base 1024 of multiplier */

    size_t  next_mult = 1024;	/* multiplier of next-highest unit */

    static char string[32];

    char   *units[] = { 
	"b", 		/* bytes     */
	"kb", 		/* kilobytes */
	"mb", 		/* megabytes */
	"gb", 		/* gigabytes */
	"tb", 		/* terabytes */
	"pb", 		/* petabytes */
	"eb"		/* exabytes  */
    };

    /*
     * Find the first multiplier by which the given byte count is not 
     * evenly divisible.  If we overflow the next multiplier, we have
     * gone far enough.
     */
    while (bytes && (bytes % next_mult) == 0) {
	mult = next_mult;
	next_mult <<= 10;
	log_1024 ++;

	if (next_mult == 0)
	    break;
    }

    /*
     * Make 'bytes' be the number of units being represented.
     */
    bytes /= mult;

    /*
     * Create a string from number of units, and the symbol for that unit.
     */
    sprintf(string, "%lu%s", bytes, units[log_1024]);

    /*
     * Remember: this is a static string!
     */
    return (string);
}
