/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* $Id: rejectjob.c,v 1.1 1999/04/16 19:33:40 hender Exp $ */

#include <stdio.h>
#include <stdlib.h>

#include "pbs_ifl.h"
#include "log.h"

#include "toolkit.h"
#include "gblxvars.h"

/*
 * The size of the buffer to allocate to hold the message that will be
 * sent to the user.  This is dynamically allocated (once) since it may 
 * need to be a very large buffer, depending on the complexity of the 
 * message.
 */
#define MSG_BUFFER_SIZE	4000

extern int connector;

int
schd_reject_job(Job *job, char *reason)
{
    char   *id = "schd_reject_job";
    static char *message = NULL;
    int     rc = 0;

    if (message == NULL) {
	if ((message = (char *)malloc(MSG_BUFFER_SIZE)) == NULL) {
	    (void)sprintf(log_buffer, "cannot malloc %d bytes\n",
		MSG_BUFFER_SIZE);
	    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
	    return (-1);
	}
    }

    DBPRT((
"*************************************************************************\n"));

    if (schd_TEST_ONLY) {
	DBPRT(("JOB %s WOULD HAVE BEEN DELETED!!!\n", job->jobid));
	DBPRT(("Message: %s\n", reason));
    } else {
	(void)sprintf(message, 
	    "\n"
	    "PBS job '%s' was rejected by all execution queues.\n"
	    "\n"
	    "The reason given for this action was :\n"
	    "\n"
	    "       %s\n"
	    "\n"
	    "Please correct the problem and resubmit your job, or contact the PBS\n"
	    "administrator for assistance.\n"
	    "\n"
	    "Thank you.\n"
	    "\n",
		job->jobid, reason);


	/* 
	 * Ask PBS to delete the job from the queue, which should deliver the
	 * message to the user.
	 */

	rc = pbs_deljob(connector, job->jobid, message);

	if (rc) {
	    (void)sprintf(log_buffer, "pbs_deljob failed: error %d", rc);
	    log_record(PBSEVENT_SYSTEM, PBS_EVENTCLASS_SERVER, id, log_buffer);
	    DBPRT(("%s: %s\n", id, log_buffer));
	    return 1;
	}

	/*
	 * Delete this job from the queue's list (move to a NULL queue)
	 */
	schd_move_job_to(job, NULL);

	DBPRT(("JOB %s DELETED!!!\n", job->jobid));
	DBPRT(("Message: %s\n", reason));
    }

    DBPRT((
"*************************************************************************\n"));
    return 0;
}
