/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/* $Id: resource_limits.c,v 1.1 1999/04/16 19:33:43 hender Exp $ */

#include <sys/types.h>
#include <stdio.h>

#include "toolkit.h"
#include "gblxvars.h"
#include "msgs.h"

int schd_resource_limits(Job *job, Resources *rsrcs, char *reason)
{
    /* Could nodes be over-allocated by running this job? */
    if ((rsrcs->nodes_alloc + job->nodes) > rsrcs->nodes_total) {
	if (reason)
	    sprintf(reason, "%s (%d max)",
		schd_JobMsg[NO_NODES], rsrcs->nodes_total);
	return (1);
    }

    return 0;		/* Job will fit within available resources. */
}

/*
 * Origin machines may come up and run happily with fewer nodes available
 * than the actual queue structure might indicate.  One example is that a
 * node board goes bad due to a power failure -- the machine might only
 * have 62 CPUs available, but the largest queue would allow 64 CPUs.
 */
int schd_resources_avail(Job *job, Resources *rsrcs, char *reason)
{
    /* Are sufficient CPUs available on the system to run this job? */
    if (job->nodes > rsrcs->nodes_total) {
	if (reason)
	    sprintf(reason, "%s (only %d avail)", schd_JobMsg[NO_NODES],
		rsrcs->nodes_total);
	return (0);
    }

    return 1;		/* Job will fit within available resources. */
}
