/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * node_attr_def is the array of "attribute" definitions for a node.
 * Each legal node "attribute" is defined here
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include "pbs_ifl.h" 
#include "list_link.h" 
#include "attribute.h" 

static char ident[] = "@(#) $RCSfile: node_attr_def.c,v $ $Revision: 2.2 $";

/* External Functions Referenced */

/*
* extern int decode_state A_((struct attribute *patr, char *nam, char *rn, char *val));
* extern int decode_props A_((struct attribute *patr, char *nam, char *rn, char *val));
* extern int encode_state	     A_((struct attribute *patr, list_head *ph, char *anm, char *rmn, int mode));
* extern int encode_props	     A_((struct attribute *patr, list_head *ph, char *anm, char *rmn, int mode));
* extern int set_node_state    A_((attribute *patr, attribute *new, enum batch_op));
* extern int set_node_props    A_((attribute *patr, attribute *new, enum batch_op));
* extern int node_state        A_((attribute *patr, void *pobj, int actmode));
* extern int node_np_action    A_((attribute *patr, void *pobj, int actmode));
* extern int node_prop_list    A_((attribute *patr, void *pobj, int actmode));
* extern void free_null	     A_((attribute *patr));
* extern void free_prop_attr   A_((attribute *patr));
* extern int  comp_null	     A_((attribute *patr, attribute *with));
*/


/*
 * The entries for each attribute are (see attribute.h):
 *	name,
 *	decode function,
 *	encode function,
 *	set function,
 *	compare function,
 *	free value space function,
 *	action function,
 *	access permission flags,
 *	value type
 */

attribute_def node_attr_def[] = {

/* NODE_ATR_state */
    {	ATTR_NODE_state,	/* "state" */
	decode_state,
	encode_state,
	set_node_state,
	comp_null,
	free_null,
	node_state,
	NO_USER_SET,
	ATR_TYPE_SHORT,
	PARENT_TYPE_NODE,
    },
	
/* NODE_ATR_np */
    {	ATTR_NODE_np,		/* "np" */
	decode_l,
	encode_l,
	set_l,
	comp_null,
	free_null,
	node_np_action,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_NODE,
    },
/* NODE_ATR_properties */
    {	ATTR_NODE_properties,	/* "properties" */
	decode_arst,
	encode_arst,
	set_arst,
	comp_null,
	free_arst,
	node_prop_list,
	MGR_ONLY_SET,
	ATR_TYPE_ARST,
	PARENT_TYPE_NODE,
    },

/* NODE_ATR_ntype */
    {	ATTR_NODE_ntype,	/* "ntype" */
	decode_ntype,
	encode_ntype,
	set_node_ntype,
	comp_null,
	free_null,
	node_ntype,
	NO_USER_SET,
	ATR_TYPE_SHORT,
	PARENT_TYPE_NODE,
    },

/* NODE_ATR_jobs */
    {   ATTR_NODE_jobs,         /* "jobs" */
	decode_null,
	encode_jobs,
	set_null,
	comp_null,
	free_null,
	NULL_FUNC,
	ATR_DFLAG_RDACC,
	ATR_TYPE_JINFOP,
	PARENT_TYPE_NODE,
    },
};
