/*
*         Portable Batch System (PBS) Software License
* 
* Copyright (c) 1999, MRJ Technology Solutions.
* All rights reserved.
* 
* Acknowledgment: The Portable Batch System Software was originally developed
* as a joint project between the Numerical Aerospace Simulation (NAS) Systems
* Division of NASA Ames Research Center and the National Energy Research
* Supercomputer Center (NERSC) of Lawrence Livermore National Laboratory.
* 
* Redistribution of the Portable Batch System Software and use in source
* and binary forms, with or without modification, are permitted provided
* that the following conditions are met:
* 
* - Redistributions of source code must retain the above copyright and
*   acknowledgment notices, this list of conditions and the following
*   disclaimer.
* 
* - Redistributions in binary form must reproduce the above copyright and 
*   acknowledgment notices, this list of conditions and the following
*   disclaimer in the documentation and/or other materials provided with the
*   distribution.
* 
* - All advertising materials mentioning features or use of this software must
*   display the following acknowledgment:
* 
*   This product includes software developed by NASA Ames Research Center,
*   Lawrence Livermore National Laboratory, and MRJ Technology Solutions.
* 
*         DISCLAIMER OF WARRANTY
* 
* THIS SOFTWARE IS PROVIDED BY MRJ TECHNOLOGY SOLUTIONS ("MRJ") "AS IS" WITHOUT 
* WARRANTY OF ANY KIND, AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING,
* BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS
* FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE EXPRESSLY DISCLAIMED.
* 
* IN NO EVENT, UNLESS REQUIRED BY APPLICABLE LAW, SHALL MRJ, NASA, NOR
* THE U.S. GOVERNMENT BE LIABLE FOR ANY DIRECT DAMAGES WHATSOEVER,
* NOR ANY INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* 
* This license will be governed by the laws of the Commonwealth of Virginia,
* without reference to its choice of law rules.
*/
/*
 * svr_attr_def is the array of attribute definitions for the server.
 * Each legal server attribute is defined here
 */

#include <pbs_config.h>   /* the master config generated by configure */

#include "pbs_ifl.h" 
#include "list_link.h" 
#include "attribute.h" 

static char ident[] = "@(#) $RCSfile: svr_attr_def.c,v $ $Revision: 2.2 $";

/* External Functions Referenced */

extern int manager_oper_chk A_((attribute *pattr, void *pobject, int actmode));
extern int poke_scheduler A_((attribute *pattr, void *pobject, int actmode));

extern int encode_svrstate A_((attribute *pattr, list_head *phead, char *aname,
			       char *rsname, int mode));

extern int decode_rcost A_((attribute *patr, char *name, char *rn, char *val));
extern int encode_rcost A_((attribute *attr, list_head *phead, char *atname,
			    char *rsname, int mode));
extern int set_rcost A_((attribute *attr,attribute *new, enum batch_op));
extern void free_rcost A_((attribute *attr));
extern int decode_null A_((attribute *patr, char *name, char *rn, char *val));
extern int set_null A_((attribute *patr, attribute *new, enum batch_op op));

/*
 * The entries for each attribute are (see attribute.h):
 *	name,
 *	decode function,
 *	encode function,
 *	set function,
 *	compare function,
 *	free value space function,
 *	action function,
 *	access permission flags,
 *	value type
 */

attribute_def svr_attr_def[] = {

/* SRV_ATR_State */
    {	ATTR_status,		/* "server_state" */
	decode_null,
	encode_svrstate,
	set_null,
	comp_l,
	free_null,
	NULL_FUNC,
	READ_ONLY,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER,
    },

/* SRV_ATR_scheduling */
    {	ATTR_scheduling,
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	poke_scheduler,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER,
    },

/* SRV_ATR_MAX_running */
    {	ATTR_maxrun,		/* "max_running" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_MaxUserRun */
    {	ATTR_maxuserrun,	/* "max_user_run" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_MaxGrpRun */
    {	ATTR_maxgrprun,		/* "max_group_run" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_TotalJobs */
    {	ATTR_total,		/* "total_jobs" */
	decode_null,
	encode_l,
	set_null,
	comp_l,
	free_null,
	NULL_FUNC,
	READ_ONLY,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_JobsByState */
    {	ATTR_count,		/* "state_count" */
	decode_null,		/* note-uses fixed buffer in server struct */
	encode_str,
	set_null,
	comp_str,
	free_null,
	NULL_FUNC,
	READ_ONLY,
	ATR_TYPE_STR,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_acl_host_enable */
    {	ATTR_aclhten,		/* "acl_host_enable" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	MGR_ONLY_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_acl_hosts */
    {	ATTR_aclhost,		/* "acl_host_list" */
	decode_arst,
	encode_arst,
	set_hostacl,
	comp_arst,
	free_arst,
	NULL_FUNC,
	MGR_ONLY_SET,
	ATR_TYPE_ACL,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_AclUserEnabled */	/* User ACL to be used */
    {	ATTR_acluren,		/* "acl_user_enable" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	MGR_ONLY_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_AclUsers */		/* User Acess Control List */
    {	ATTR_acluser,		/* "acl_users" */
	decode_arst,
	encode_arst,
	set_uacl,
	comp_arst,
	free_arst,
	NULL_FUNC,
	MGR_ONLY_SET,
	ATR_TYPE_ACL,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_AclRoot */		/* List of which roots may execute jobs */
    {	ATTR_aclroot,		/* "acl_roots"				*/
	decode_arst,
	encode_arst,
	set_uacl,
	comp_arst,
	free_arst,
	NULL_FUNC,
	MGR_ONLY_SET,
	ATR_TYPE_ACL,
	PARENT_TYPE_SERVER
    },
	
/* SRV_ATR_managers */
    {	ATTR_managers,		/* "managers" */
	decode_arst,
	encode_arst,
	set_uacl,
	comp_arst,
	free_arst,
	manager_oper_chk,
	MGR_ONLY_SET,
	ATR_TYPE_ACL,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_operators */
    {	ATTR_operators,		/* "operators" */
	decode_arst,
	encode_arst,
	set_uacl,
	comp_arst,
	free_arst,
	manager_oper_chk,
	MGR_ONLY_SET,
	ATR_TYPE_ACL,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_dflt_que */
    {	ATTR_dfltque,		/* "default_queue" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_STR,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_log_events */
    {	ATTR_logevents,		/* "log_events" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_mailfrom */
    {	ATTR_mailfrom,		/* "mail_from" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_STR,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_query_others */
    {	ATTR_queryother,	/* "query_other_jobs" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	MGR_ONLY_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_resource_avail */
    {	ATTR_rescavail,		/* "resources_available" */
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_RESC,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_resource_deflt */
    {	ATTR_rescdflt,		/* "resources_default" */
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_RESC,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_ResourceMax */
    {	ATTR_rescmax,		/* "resources_max" */
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_RESC,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_resource_assn */
    {	ATTR_rescassn,		/* "resources_assigned" */
	decode_resc,
	encode_resc,
	set_resc,
	comp_resc,
	free_resc,
	NULL_FUNC,
	READ_ONLY,
	ATR_TYPE_RESC,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_resource_cost */
    {	ATTR_resccost,		/* "resources_cost" */
	decode_rcost,	/* these are not right, haven't figured this out yet */
	encode_rcost,
	set_rcost,
	NULL_FUNC,
	free_rcost,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_RESC,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_sys_cost */
    {	ATTR_syscost,		/* "system_cost" */
	decode_l,
	encode_l,
	set_l,
	NULL_FUNC,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* SRV_ATR_schedule_iteration */
    {	ATTR_schedit,		/* "schedule_iteration" */
	decode_l,
	encode_l,
	set_l,
	comp_l,
	free_null,
	NULL_FUNC,
	NO_USER_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },
/* SRV_ATR_Comment */
    {	ATTR_comment,		/* "comment"  - information */
	decode_str,	
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	MGR_ONLY_SET,
	ATR_TYPE_STR,
	PARENT_TYPE_SERVER
    },
/* SVR_ATR_DefNode */
    {	ATTR_defnode,		/* "default_node" */
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	MGR_ONLY_SET,
	ATR_TYPE_STR,
	PARENT_TYPE_SERVER
    },
/* SVR_ATR_NodeOrder */
    {	ATTR_nodepack,		/* "node_pack" */
	decode_b,
	encode_b,
	set_b,
	comp_b,
	free_null,
	NULL_FUNC,
	MGR_ONLY_SET,
	ATR_TYPE_LONG,
	PARENT_TYPE_SERVER
    },

/* site supplied server attribute definitions if any, see site_svr_attr_*.h  */
#include "site_svr_attr_def.h"

/* SRV_ATR_version */
    {	"pbs_version",
	decode_str,
	encode_str,
	set_str,
	comp_str,
	free_str,
	NULL_FUNC,
	READ_ONLY,
	PARENT_TYPE_SERVER
    }
};
